/* rc_file.h - A simple configuration file reader/writer header file
 * by Patrick Gallot <patrick.gallot@cimlinc.com>
 *
 * This file is part of GTKeyboard and as such is licensed under the terms
 * of the GNU General Public License.
 */

#define RC_FILE_H

#include <glib.h>

/* Different types that resource file varaibles can have */
#define RC_NONE                 0x0000
#define RC_INT	                0x0001      /* Integer */
#define RC_STR	                0x0002      /* String */
#define RC_DOUBLE               0x0003      /* Double (not finished) */
#define RC_FLOAT                0x0004      /* Float  (not finished) */
#define RC_BOOL                 0x0005      /* Boolean (really an int) */
#define RC_PARSE_FUNC           0x0006      /* This one means that an external
					     * parsing function should be used
					     * and the resource file code 
					     * shouldn't bother with the values
					     */
typedef struct config_var
{
     /* These go together to specify a line in a file that could say something
      * like "set foo_variable 10" or "foobar = 20" or even 
      * "toolbar menubar off"
      */

     gchar *Prefix;   /* This could be something like "set" or "toolbar" */
     gchar *Name;     /* Element name */
     gint  Type;      /* Type of the value */
     gpointer Val;    /* Pointer to the value to store */
     /* Function pointer for custom handling -- it should have parameters
      * of the "prefix" token, (usually "set"), the variable name, the
      * varaible value, and the pointer we were supposed to store it in.
      * The pointer is usually going to be the same as Val above 
      */
     int (*func)(char *prefix, char *varname, char *val, gpointer ptr);
} RCVARS;

extern int read_ConfigFile                  (char *filename, RCVARS *vars, 
                                             int complain);
extern int write_ConfigFile                 (char *file, RCVARS *vars);



