package jacob.tool;

import java.awt.Frame;
import java.util.Vector;
import java.awt.event.*;

import jacob.*;

import ccl.util.*;
import ccl.awt.AWTUtil;

import javancss.*;

/**
 * Example wrapper class for JavaNCSS.
 *
 * @author  <a href="http://mats.gmd.de/clemens/">Chr. Clemens Lahme</a> (<a href="mailto:clemens.lahme@mailexcite.com"><i>Clemens.Lahme@mailexcite.com</i></a>)
 * @version $Id: JavancssSelected.java,v 1.4 1999/02/22 11:44:12 clemens Exp clemens $
 * @see JavancssAll
 */
public class JavancssSelected implements JacobRunnable {
    protected JacobInterface _pJacobInterface = null;

    protected Vector _vAllClasses = new Vector();

    protected String _sSelectedTab;

    private JavancssFrame _pJavancssFrame = null;

    protected void _setAllClasses() {
        String sPackage = _pJacobInterface.getSelectedPackage();
        if (Util.isEmpty(sPackage)) {
            Frame frmMain = _pJacobInterface.getMainFrame();
            AWTUtil.showMessage(frmMain, "Sorry, no Package selected!");
            frmMain.requestFocus();
            
            return;
        }
        Package pckSelected = _pJacobInterface.getMainPackage().
               getPackage(sPackage);
        
        _vAllClasses = new Vector();
        
        String sClass = _pJacobInterface.getSelectedClass();
        if (!Util.isEmpty(sClass)) {
            _sSelectedTab = JavancssFrame.S_METHODS;
            sClass = sClass.substring(sClass.lastIndexOf('.') + 1);
            _vAllClasses.addElement(FileUtil.
                                    concatPath(pckSelected.getPath(),
                                               sClass));
        } else {
            _sSelectedTab = JavancssFrame.S_CLASSES;
            // get Vector with source and compile classen
            _vAllClasses = pckSelected.getClassPathNames();
        }
        
        Transformer pTransformer = new Transformer() {
            public Object transform(Object pObject_) {
                return(((String)pObject_) + ".java");
            }
        };
        _vAllClasses = Util.map(_vAllClasses, pTransformer);
    }

    public JavancssSelected() {
        super();
    }

    public void set(JacobInterface pJacobInterface_) {
        Util.panicIf(pJacobInterface_ == null);
        _pJacobInterface = pJacobInterface_;
    }

    /**
     * For testing purposes.
     */
    public JavancssFrame getJavancssFrame() {
        return _pJavancssFrame;
    }

    public void run() {
        _sSelectedTab = JavancssFrame.S_PACKAGES;
        
        _setAllClasses();
        
        _pJavancssFrame = new JavancssFrame(_pJacobInterface.getInit());
        final Thread pThread = Thread.currentThread();
        try {
            _pJavancssFrame.addWindowListener(new WindowAdapter() {
                public void windowClosing(WindowEvent e_) {
                    Util.debug("JavancssAll.run().WindowAdapter.windowClosing().1");
                    _pJavancssFrame.dispose();
                    _pJacobInterface.stopped(JavancssSelected.this);
                    pThread.stop();
                }
            });
            _pJavancssFrame.setVisible(true);
            AWTUtil.centerComponent( _pJavancssFrame );
            Javancss pJavancss = new Javancss(_vAllClasses);
            Util.debug("JavancssAll.run().1");
            _pJavancssFrame.showJavancss(pJavancss);
            _pJavancssFrame.setSelectedTab(_sSelectedTab);
            _pJavancssFrame.run();
        } finally {
            try {
                _pJavancssFrame.dispose();
            } catch( NullPointerException pNullPointerException ) {
                // just catched for JacobTest
            }
        }
        _pJacobInterface.stopped(this);
    }
    
    public String toString() {
        String sRetVal = getClass().getName();
        sRetVal = sRetVal.substring(sRetVal.lastIndexOf('.') + 1);
        
        return sRetVal;
    }
}
