package jacob.tool;

import java.awt.Frame;
import java.util.Hashtable;

import jacob.Package;
import jacob.EditorInterface;

import ccl.util.Init;

/**
 * This class is used by the tools wrapper, so they can access
 * Jacob's data and feed their tool with it.
 *
 * @author  <a href="http://mats.gmd.de/clemens/">Chr. Clemens Lahme</a> (<a href="mailto:clemens.lahme@mailexcite.com"><i>Clemens.Lahme@mailexcite.com</i></a>)
 * @version $Id: JacobInterface.java,v 1.5 1998/09/21 13:52:16 clemens Exp clemens $
 */
public interface JacobInterface {
    public Frame           getMainFrame();
    
    public Package         getMainPackage();
    
    /**
     * The class you can set in "Edit->Project Settings..."
     * and which is the class that gets invoked via its
     * main(String) method when executing the project.
     *
     * For example: jacob.Main
     */
    public String          getMainClass();

    /**
     * The flags Jacob will pass on to 'java' in the makefile.
     */
    public String          getJavaInterpreterFlags();
    
    /**
     * The parameter Jacob will attach in the 'run:' rule to your
     * application invokation in the makefile.
     */
    public String          getStartParameter();
    
    /**
     * A tag string used for rcs etc.
     */
    public String          getProjectTag();

    /**
     * The dependencies among the project java files for
     * use in makefile generation.
     */
    public Hashtable       getDependencies();

    /**
     * The flags Jacob will pass on to 'javac' in the makefile.
     */
    public String          getJavaCFlags();
    
    public Init            getInit();
    
    /**
     * @see #jacob.EditorInterface
     */
    public EditorInterface getEditor();
    
    /**
     * @deprecated
     * @see #getEditor()
     */
    public void            editFile(String sFileName_);
    
    /**
     * The name of the selected package. The empty package is denoted
     * with ".".
     */
    public String          getSelectedPackage();
    
    /**
     * For example: java.util.Vector or MyApplet.
     */
    public String          getSelectedClass();
    
    /**
     * Includes package and class name.
     */
    public String          getSelectedMethod();
    
    /**
     * With this method you can add a new class to the project.
     * If the package does not yet belong to the project it
     * gets added too (but just with this one class as content).
     */
    public void            addClass(String sClassFullName_);
    
    /**
     * Select a class in the browser.
     */
    public void            selectClass(String sClassFullName_);
    
    /**
     * This must be called at the end of a JacobRunnable.run()
     * method to notify Jacob that this thread has finished.
     */
    public void            stopped(JacobRunnable pJacobRunnable_);
}
