package jacob;

import java.util.*;
import java.io.File;

import ccl.util.*;
import ccl.awt.*;
import ccl.swing.SwingUtil;

import jacob.tool.WrapperAdapter;


public class Makefile extends WrapperAdapter
                      implements JacobConstants
{
    private static final String S_SUF_JAVA = ".java";
    private static final String S_SUF_CLASS = ".class";
    private static final String S_MAKEFILE = "Makefile";
    
    private Init _pInit;
    private Package _pckMain;
    private String _sMainClass;
    private Hashtable _htDependencies;
    private String _sProjectClassPath;
    private String _sJavacFlags;
    private String _sJavaInterpreterFlags;
    private String _sStartParameter;
    private String _sProjectTag;
    
    private String _getClassFile(Package pPackage_, String sClassName_)
        throws ApplicationException
    {
        Util.debug("Makefile: _getClassFile: pPackage_: " + pPackage_);
        Util.debug("Makefile: _getClassFile: sClassName_: " + sClassName_);
        String sClassFullFileName = FileUtil.
               concatPath(pPackage_.getPath(), sClassName_) + S_SUF_JAVA;
        String sClassFileContent = null;
        try {
            sClassFileContent = FileUtil.readFile(sClassFullFileName);
        } catch(Exception e) {
            throw new ApplicationException
                   ("Error: the class file\n" + sClassFullFileName +
                    "\ncould not be opened!");
        }
        
        return sClassFileContent;
    }

    private String _getClassFile(String sPackageName_,
                                 String sClassName_)
        throws ApplicationException
    {
        Package pPackage = _pckMain.getPackage(sPackageName_);
        return _getClassFile(pPackage, sClassName_);
    }
    
    private String _getClassFile(String sFullClassName_)
        throws ApplicationException
    {
        return _getClassFile(Package.getPackageName(sFullClassName_),
                             Package.getClassName(sFullClassName_));
    }
    
    private String _getRcsVersion()
        throws ApplicationException
    {
        if (_sMainClass == null || _sMainClass.equals("")) {
            return (String)null;
        }
        String sClassFileContent = _getClassFile(_sMainClass);
        Util.debug("Makefile: _getRcsVersion: sClassFileContent: " +
                   sClassFileContent);
        if (sClassFileContent == null) {
            return (String)null;
        }
        
        String sVersion = null;
        
        // "$Header: " suchen
        int endIndex;
        int startIndex = sClassFileContent.indexOf("$Header");
        if (startIndex != -1) {
            sVersion = "1.0";
        }
        startIndex = sClassFileContent.indexOf(": ", startIndex) + 2;
        if (startIndex != -1 + 2) {
            startIndex = sClassFileContent.indexOf(' ', startIndex) + 1;
            if (startIndex != -1) {
                endIndex = sClassFileContent.indexOf(' ', startIndex);
                if (endIndex != -1) {
                    sVersion = sClassFileContent.substring(startIndex,
                                                           endIndex);
                    // Noch mal berprfen, obs auch wirklich ne Versionsnummer ist
                    try {
                        int version = Util.atoi(sVersion.substring(0, sVersion.
                                                                   indexOf('.')));
                        int release = Util.atoi(sVersion.substring(sVersion.
                                                                   indexOf('.') + 1));
                        String sTestVersion = "" + version + "." + release;
                        if (!sVersion.equals(sTestVersion)) {
                            sVersion = null;
                        }
                    } catch(Exception e) {
                        sVersion = null;
                    }
                }
            }
        }
        
        return sVersion;
    }
    
    private String _getRcs() {
        StringBuffer sRcs = new StringBuffer();
        sRcs.append("cm : cm_ ");
        
        if (FileUtil.existsFile(FileUtil.concatPath(_pInit.getFilePath(),
                                                    "make_cm_last")))
        {
            sRcs.append("cm_last zip\n\ninclude make_cm_last");
        } else {
            sRcs.append("zip");
        }
        
        sRcs.append("\n\ncm_ :\n\t-mkdir RCS\n");
        if (!Util.isEmpty(_sMainClass)) {
            String sClassFullFileName = _pckMain.getClassFullFileName(_sMainClass);
            sRcs.append("\tci -l$(VERSION) -f ").
                   append(sClassFullFileName).append('\n');
        }
        
        sRcs.append("\tci -l -n$(TAG) ").
               append(S_MAKEFILE).append('\n');
        sRcs.append("\t-ci -l -n$(TAG) README.TXT\n");
        sRcs.append("\t-ci -l -n$(TAG) make_all_first\n");
        sRcs.append("\t-ci -l -n$(TAG) make_all_last\n");
        sRcs.append("\t-ci -l -n$(TAG) make_cm_last\n");
        sRcs.append("\t-ci -l -n$(TAG) make_zip_last\n");
        sRcs.append("\t-ci -l -n$(TAG) make_public_last\n");
        sRcs.append("\tci -l -n$(TAG) ").
               append(_pInit.getFileName().toLowerCase()).
               append(_pInit.getKeyValue(S_INIT_PROJSUFFIX)).
               append('\n');
        
        String sCurrentPath = "";
        for(Enumeration eClasses = _pckMain.getAllClassPathNames(true, true, false).elements();
            eClasses.hasMoreElements(); )
        {
            String sNextClass = (String)eClasses.nextElement();
            int index = sNextClass.lastIndexOf(File.separatorChar) + 1;
            if (index > 0) {
                String sPath = sNextClass.substring(0, index);
                if (!sPath.equals(sCurrentPath)) {
                    sCurrentPath = sPath;
                    sRcs.append("\t-mkdir ").append(sCurrentPath).
                           append("RCS\n");
                }
            }
            sRcs.append("\tci -l -n$(TAG) ").append(sNextClass).
                   append(".java\n");
        }
        sRcs.append('\n');
        
        return(sRcs.toString());
    }
    
    private String _getMakefileAll() {
        StringBuffer sAll = new StringBuffer(40000);
        sAll.append("JAVA_HOME = ").append
               (FileUtil.getAbsoluteFileName
                (System.getProperty("java.home"))).
               append('\n');
        sAll.append("CLASSPATH = ").append
               (_sProjectClassPath).append('\n');
        if ( !Package.usesClassPath() ) {
            sAll.append( "DESTINATION = " ).append
                   ( Package.getDestinationDirectory() ).append( '\n' );
        }
        sAll.append("JAVAC = $(JAVA_HOME)").
               append(File.separatorChar).
               append("bin").
               append(File.separatorChar).
               append("javac\n");
        sAll.append("JAVA = $(JAVA_HOME)").
               append(File.separatorChar).
               append("bin").
               append(File.separatorChar).
               append("java\n");
        sAll.append("CFLAGS = ").append(_sJavacFlags).
               append('\n');
        sAll.append("OS = ").
               append(System.getProperty("os.name").replace(' ', '_')).
               append('\n');
        sAll.append("APP_NAME = ").
               append(_pInit.getFileName().toLowerCase()).
               append('\n');
        
        String sTag = "";
        // fuer RCS Dirs muss der user selber sorgen
        String sVersion = _getRcsVersion();
        if (!_sProjectTag.equals("") && sVersion != null) {
            sTag = _sProjectTag;
            // z.B.: 1.13 -> 14
            String sRelease = "" + (Util.atoi(sVersion.substring(sVersion.indexOf('.') + 1,
                                                                 sVersion.length())) + 1);
            sVersion = sVersion.substring(0, sVersion.indexOf('.') + 1) +
                   sRelease;
            
            sTag += sRelease;
        } else {
            sVersion = "1.1";
        }
        sAll.append("VERSION = ").append(sVersion).append('\n');
        sAll.append("TAG = ").append(sTag).append('\n');
        
        sAll.append("\nall : ");
        boolean bMakeAllFirst = false;
        if (FileUtil.existsFile(FileUtil.concatPath(_pInit.getFilePath(),
                                                    "make_all_first")))
        {
            bMakeAllFirst = true;
            sAll.append("all_first ");
        }
        StringBuffer sClasses = new StringBuffer();
        //    jede Klasse mit vollem Pfad aneinander reihen mit " "
        Util.debug("Java_Home: " + System.getProperty("java.home"));

        Enumeration enJavaClasses = _pckMain.getClassElements();
        while ( enJavaClasses.hasMoreElements() ) {
            JavaClass jclNext = (JavaClass)enJavaClasses.nextElement();
            //Util.debug("Makefile._getMakefileAll().jclNext: " + jclNext );
            //        }
            //
            //        for(Enumeration e = _pckMain.getAllClassPathNames(true, true, false).
            //                   elements();
            //            e.hasMoreElements(); )
            //        {
            //            String sFullName = (String)e.nextElement();
            String sClassFullName = jclNext.getClassFullFileName();
            sAll.append(sClassFullName).append(' ');
            String sFullName = jclNext.getSourceFullFileName();
            sClasses.append(sClassFullName).append(" : ").append(sFullName);
            Vector vDepends = (Vector)_htDependencies.get
                   ( sFullName.substring( 0, sFullName.length() - 5 ) );
            if (vDepends != null) {
                for( Enumeration eDepends = vDepends.elements(); 
                     eDepends.hasMoreElements(); ) 
                {
                    // warning: this looks like /path/foo/A
                    String sFullClassName = (String)eDepends.nextElement();
                    String sPackageName = Package.getPackageName(sFullClassName);
                    String sClassName = Package.getClassName(sFullClassName);
                    Util.debug("_getMakefileAll: sFullClassName: " + sFullClassName);
                    Util.debug("_getMakefileAll: sClassName: " + sClassName);
                    Util.debug("_getMakefileAll: sPackageName: " + sPackageName);
                    JavaClass jclTemp = _pckMain.getJavaClass( sPackageName, 
                                                               sClassName );
                    Util.debug( "Makefile._getMakefileAll().jclTemp: " + jclTemp );
                    Package pckNext = _pckMain.getPackage(sPackageName);
                    Util.debug("_getMakefileAll: pckNext: " + pckNext);
                    /*sClasses.append(' ').
                           append(FileUtil.concatPath(pckNext.getPath(),
                                                      sClassName)).
                                                      append(S_SUF_CLASS);*/
                    sClasses.append(' ').append( jclTemp.getClassFullFileName() );
                }
            }
            sClasses.append("\n\t$(JAVAC) $(CFLAGS) -classpath $(CLASSPATH) ");
            if ( !Package.usesClassPath() ) {
                sClasses.append( "-d $(DESTINATION) " );
            }
            sClasses.append(sFullName).append("\n\n");
        }
        if (FileUtil.existsFile(FileUtil.concatPath(_pInit.getFilePath(),
                                                    "make_all_last")))
        {
            sAll.append("all_last\n\ninclude make_all_last");
        }
        sAll.append("\n\n");
        if (bMakeAllFirst) {
            sAll.append("include make_all_first\n\n");
        }
        sAll.append(sClasses);
        
        return sAll.toString();
    }
    
    private String _getClean() {
        StringBuffer sClean = new StringBuffer(40000);
        sClean.append("\nclean : \n");
        Vector vpckClassPackages = _pckMain.getClassPackages(true, true);
        for(Enumeration eClassPackages = vpckClassPackages.elements();
            eClassPackages.hasMoreElements(); )
        {
            Package pckNext = (Package)eClassPackages.nextElement();
            String sPackagePath = pckNext.getPath();
            
            for(Enumeration eClasses = pckNext.getClassNames(false).elements();
                eClasses.hasMoreElements(); )
            {
                String sNextClass = (String)eClasses.nextElement();
                sClean.append("\t-rm ").append
                       (FileUtil.concatPath(sPackagePath,
                                            sNextClass)).
                       append(S_SUF_CLASS).append('\n');
                sClean.append("\t-rm ").append
                       (FileUtil.concatPath(sPackagePath,
                                            sNextClass)).
                       append("$$*").append(S_SUF_CLASS).append('\n');
            }
        }
        sClean.append('\n');
        return(sClean.toString());
    }
    
    /**
     * Macht aus "psp/timelog/" "../.."
     */
    private String _getBackPath(String sSubPath_) {
        if (sSubPath_.equals("") ||
            sSubPath_.equals(".") || sSubPath_.equals("./"))
        {
            return "";
        }
        String sBackPath = "..";
        int dirLevel = Util.getOccurances(sSubPath_, '/');
        for(int level = 0; level < dirLevel - 1; level++) {
            sBackPath += "/..";
        }
        sBackPath += "/";
        
        return sBackPath;
    }
    
    private String _getProjectPath(String sFullProjPath_)
        throws ApplicationException
    {
        Util.debug( "Makefile._getProjectPath(..).sFullProjPath_: " + 
                    sFullProjPath_ );
        String sProjPath = null;
        for(Enumeration ePackages = _pckMain.elements(); 
            ePackages.hasMoreElements(); ) 
        {
            Package pckNext = (Package)ePackages.nextElement();
            if (FileUtil.equalsPath(sFullProjPath_, pckNext.getPath())) {
                sProjPath = pckNext.getName();
                break;
            }
        }
        if (sProjPath != null) {
            sProjPath = sProjPath.replace('.', '/') + "/";
            if (sProjPath.equals("//")) {
                sProjPath = "";
            }
        } /*else {
            throw new ApplicationException
            ("Error:\nThe project file is not inside a package.\n" +
            "The separation of the project data and\nthe source " + 
            "code is not yet supported.");
            }*/
        
        Util.debug( "Makefile._getProjectPath(..).sProjPath: " + 
                    sProjPath );

        return sProjPath;
    }
    
    /**
     * @param sZipFileName_ Enthlt den Namen der Zipdatei MIT der Endung ".zip"!
     */
    private String _getMakefileZip(String sZipFileName_, Vector vProjectFileNames_,
                                   boolean bSource_) {
        StringBuffer sZip = new StringBuffer();
        sZip.append("\t-mv ").append(sZipFileName_).append(' ').
               append(sZipFileName_).append(".bak\n");
        
        String sFullProjPath = _pInit.getFilePath();
        
        String sProjPath = _getProjectPath(sFullProjPath);
        if (sProjPath == null) {
            return "";
        }
        
        if (Util.isOSWindows()) {
            sZip.append("\tcd ./").append(_getBackPath(sProjPath)).
                   append('\n');
        }
        for(Enumeration eProjFiles = vProjectFileNames_.elements();
            eProjFiles.hasMoreElements(); )
        {
            String sNextFileName = (String)eProjFiles.nextElement();
            sZip.append("\t-");
            if (!Util.isOSWindows()) {
                sZip.append("cd ./").append(_getBackPath(sProjPath)).
                       append(";\t");
            }
            sZip.append("zip ").append(sProjPath).
                   append(sZipFileName_).append(' ').
                   append(sProjPath).append(sNextFileName).
                   append('\n');
        }
        if (Util.isOSWindows()) {
            sZip.append("\tcd ./").append(sProjPath).append('\n');
        }
        
        String sSuffix = S_SUF_CLASS;
        if (bSource_) {
            sSuffix = S_SUF_JAVA;
        }
        Vector vpckClassPackages = _pckMain.getClassPackages(bSource_, bSource_);
        for(Enumeration eClassPackages = vpckClassPackages.elements();
            eClassPackages.hasMoreElements(); )
        {
            Package pckNext = (Package)eClassPackages.nextElement();
            String sPackagePath = pckNext.getPath();
            
            String sSubPath = Util.replace(pckNext.getName(), '.', '/', 1) + "/";
            String sBackPath = _getBackPath(sSubPath);
            sPackagePath = FileUtil.concatPath(sPackagePath, sBackPath);
            String sCDCommand = "\tcd " + sPackagePath;
            sZip.append(sCDCommand).append('\n');
            
            for(Enumeration eClasses = pckNext.getClassNames(false).elements();
                eClasses.hasMoreElements(); )
            {
                String sNextClass = (String)eClasses.nextElement();
                if (!Util.isOSWindows()) {
                    sZip.append(sCDCommand).append(';');
                }
                sZip.append("\tzip ").append(sFullProjPath).
                       append(sZipFileName_).append(' ').
                       append(sSubPath).append(sNextClass).
                       append(sSuffix).append('\n');
                if (!bSource_) {
                    if (Util.isOSWindows()) {
                        sZip.append("\t-zip ").append(sFullProjPath).
                               append(sZipFileName_).append(' ').
                               append(sSubPath).
                               append(sNextClass).append("$$*").
                               append(sSuffix).append('\n');
                    } else {
                        sZip.append("\t-cd ").append(sPackagePath).
                               append(";\tzip ").
                               append(sFullProjPath).
                               append(sZipFileName_).append(' ').
                               append(sSubPath).append(sNextClass).
                               append("$$*").append(sSuffix).
                               append('\n');
                    }
                }
            }
        }
        sZip.append("\tcd ").append(sFullProjPath).append('\n');
        String sRetVal = sZip.toString();
        sRetVal = sRetVal.replace('\\', '/');
        if (!Util.isOSWindows()) {
            sRetVal = Util.replace(sRetVal, "$$*", "\\$$*");
        }
        
        return sRetVal;
    }

	private String _getMakefileZip() {
		String sFileName = _pInit.getFileName().toLowerCase();
		String sZip = "zip :";

		if (FileUtil.existsFile(FileUtil.concatPath(_pInit.getFilePath(),
																  "make_zip_last")))
		{
			sZip += " zip_ zip_last \n\ninclude make_zip_last\n\nzip_ :";
		}
		Vector vProjectFileNames = new Vector();
		vProjectFileNames.addElement(S_MAKEFILE);
		vProjectFileNames.addElement("README.TXT");
		vProjectFileNames.addElement("make_all_first");
		vProjectFileNames.addElement("make_all_last");
		vProjectFileNames.addElement("make_cm_last");
		vProjectFileNames.addElement("make_zip_last");
		vProjectFileNames.addElement("make_public_last");
		vProjectFileNames.addElement(sFileName + _pInit.getKeyValue(S_INIT_PROJSUFFIX));
		String sZipBody = _getMakefileZip(sFileName + ".zip", vProjectFileNames, true);
		if (sZipBody == null) {
			sZip += "\n\n";
		}
		sZip += "\n" + sZipBody + "\n";

		return sZip;
	}

	private String _getMakefilePublic()
			 throws ApplicationException
	{
		// Application.bat erzeugen
		String sBatFileContent = "@echo off\nREM Edit the environment variables in line 9 and 14 if they are not already properly set\n\n" +
				 "set _JAVA_HOME_ORIG=%JAVA_HOME%\nset _CLASSPATH_ORIG=%CLASSPATH%\n\n" +
				 "if NOT \"%JAVA_HOME%\"==\"\" goto endif1\n\tREM #################### EDIT THIS ENVIRONMENT VARIABLE IF NOT ALREADY SET #################\n" +
				 "\tset JAVA_HOME=" +
				 System.getProperty("java.home") + "\n" +":endif1\n\n" +
				 "if NOT \"%CLASSPATH%\"==\"\" goto endif2\n" +
				 "\tREM #################### EDIT THIS ENVIRONMENT VARIABLE IF NOT ALREADY SET #################\n" +
				 "\tset CLASSPATH=" + _sProjectClassPath + "\n" +
				 "\tREM set CLASSPATH=..;%JAVA_HOME%\\lib\\classes.zip\n:endif2\n\n" +
				 "%JAVA_HOME%\\bin\\java -classpath %CLASSPATH% " + _sMainClass + " %1 %2 %3 %4 %5 %6 %7 %8 %9\n\n" +
				 "set JAVA_HOME=%_JAVA_HOME_ORIG%\nset CLASSPATH=%_CLASSPATH_ORIG%\n" +
				 "set _JAVA_HOME_ORIG=\nset _CLASSPATH_ORIG=\n";

		String sShellFileContent = "#!/bin/sh\n# -*- indented-text -*-\n#\n" +
				 "# Edit the JAVA_HOME and CLASSPATH environment variables if they are not\n" +
				 "# already properly set\n#\n" +
				 "#\n#\n\n" +
				 "if [ -z \"$JAVA_HOME\" ]; then\n" +
				 "  #### EDIT THIS ENVIRONMENT VARIABLE IF NOT ALREADY SET ####\n  " +
				 "  JAVA_HOME=" +
				 System.getProperty("java.home") + "\n" +
				 "fi\n\n"  +
				 "if [ -z \"$CLASSPATH\" ]; then\n" +
				 "  #### EDIT THIS ENVIRONMENT VARIABLE IF NOT ALREADY SET ####\n" +
				 "  CLASSPATH=" + _sProjectClassPath + "\n" + /*`dirname $0`/..:$JAVA_HOME/lib/classes.zip\n" +*/
				 "fi\n\n" +
				 "$JAVA_HOME/bin/java -classpath $CLASSPATH " +
				 _sMainClass + " $*\n";

		String sFullProjPath = _pInit.getFilePath();
		String sFileName = _pInit.getFileName().toLowerCase();

		String sShellFullFileName = FileUtil.concatPath(sFullProjPath,
																		sFileName);
		String sBatFullFileName = sShellFullFileName + ".bat";
		try {
			FileUtil.writeDosFile(sBatFullFileName, sBatFileContent);
			FileUtil.writeFile(sShellFullFileName, sShellFileContent);
		} catch(Exception e) {
			throw new ApplicationException
					 ("Error: either file \n" + sBatFullFileName +
					  "\nor file\n" + sShellFullFileName +
					  " could not be created!");
		}

		// zip erstellen

		//    Name des zip files
		String sZipFileName = new String(sFileName);
		String sVersion = _getRcsVersion();
		if (sVersion == null) {
			sVersion = "1.0";
		}
		sVersion = sVersion.substring(0, sVersion.indexOf('.') + 1) +
				 (Util.atoi(sVersion.substring(sVersion.indexOf('.') + 1,
														 sVersion.length())) + 1);
		sZipFileName += sVersion + ".zip";
		Vector vProjectFileNames = new Vector();
		vProjectFileNames.addElement(sFileName);
		vProjectFileNames.addElement(sFileName + ".bat");
		vProjectFileNames.addElement(sFileName + ".gif");
		vProjectFileNames.addElement(sFileName + "*.ico");
		vProjectFileNames.addElement("README.TXT");
		vProjectFileNames.addElement(MainFrame.S_DOC_DIR + "/*.*");
		String sMakefileZip = _getMakefileZip(sZipFileName, vProjectFileNames, false);

		if (sMakefileZip == null) {
			return "";
		}
		String sPublic = "public :";
		if (FileUtil.existsFile(FileUtil.concatPath(_pInit.getFilePath(),
																  "make_public_last")))
		{
		  sPublic += " public_ public_last\n\ninclude make_public_last\n\npublic_ :";
		}
		sPublic += "\n" + sMakefileZip + "\n";

		return sPublic;
	}

    private void _createMakefile() {
        // Gibt es berhaupt java code?
        if (_pckMain.isEmpty()) {
            AWTUtil.showMessage("There are no Java source files.");
            
            return;
        }

        // testen ob makefile schon existiert
        Util.debug("Makefile._createMakefile(): _pInit.getFilePath()" + 
                   _pInit.getFilePath());
        boolean bOK = !FileUtil.exists(_pInit.getFilePath() + S_MAKEFILE);
        if (!bOK) {
            bOK = SwingUtil.isOKOrCancel
                   ( _pJacobInterface.getMainFrame(),
                     "There exists already a Makefile. Do you want to continue?" );
            if (!bOK) {
                return;
            }
        }

        BusyFrameWindow.start(_pJacobInterface.getMainFrame());

        try {
            // Erste Zeile: all
            String sAll = _getMakefileAll();
            Util.debug("Makefile: _createMakefile: sAll");

            // clean : --------------------------------------------------
            String sClean = _getClean();
            Util.debug("Makefile: _createMakefile: sClean");

            // rcs : --------------------------------------------------
            String sRcs = _getRcs();
            Util.debug("Makefile: _createMakefile: sRcs");

            // zip : --------------------------------------------------
            String sZip = _getMakefileZip();
            Util.debug("Makefile: _createMakefile: sZip");

            // public release
            String sPublic = _getMakefilePublic();
            Util.debug("Makefile: _createMakefile: sPublic");

            // run : --------------------------------------------------
            String sRun = "";
            if (!_sMainClass.equals("")) {
                sRun += "run : all\n\t$(JAVA) " + _sJavaInterpreterFlags +
                       " -classpath $(CLASSPATH) " +
                       _sMainClass + " " + _sStartParameter + " \n";
            }

            String sMakefile = sAll + sRun + sClean;
            if (File.separatorChar == '\\') {
                sMakefile = Util.replace(sMakefile, "/", Init.S_FILE_SEPARATOR);
            } else {
                sMakefile = Util.replace(sMakefile, "\\", Init.S_FILE_SEPARATOR);
            }

            sMakefile += sZip + sRcs + sPublic; 

            try {
                FileUtil.writeFile(_pInit.getFilePath() + S_MAKEFILE,
                                   sMakefile);
            } catch(Exception e) {
                throw new ApplicationException
                       (e.toString() + "\n\nFailure while writing the Makfile to disk.");
            }

            // save java source files for javancss
            Vector vAllAbsoluteSourceFileNames = _pckMain.
                   getAllClassPathNames(true, false);
            String sFileName = FileUtil.concatPath
                   (_pInit.getFilePath(), _pInit.getFileName().toLowerCase()) +
                   ".srcfiles.txt";
            try {
                String sSourceFiles = Util.concat
                       (vAllAbsoluteSourceFileNames, ".java\n") + ".java\n";
                FileUtil.writeFile(sFileName, sSourceFiles);
            } catch(Exception e) {
                throw new ApplicationException
                       (e.toString() + "\n\nFailure while writing\n'" + 
                        sFileName + "'\nto disk.");
            }
        } catch(ApplicationException pApplicationException) {
            BusyFrameWindow.stop();
            AWTUtil.showMessage(_pJacobInterface.getMainFrame(),
                                pApplicationException.getMessage());
            
            return;
        }

        BusyFrameWindow.stop();
    }

    public Makefile() {
        super();
    }

    public void run() {
        Util.debug("Makefile.run().Thread.currentThread().getPriority(): " + 
                   Thread.currentThread().getPriority());
        
        _pInit = _pJacobInterface.getInit();
        _pckMain = _pJacobInterface.getMainPackage();
        _sMainClass = _pJacobInterface.getMainClass();
        _htDependencies = new Hashtable();
        _sProjectClassPath = Package.getClassPath();
        _sJavacFlags = _pJacobInterface.getJavaCFlags();
        _sJavaInterpreterFlags = _pJacobInterface.getJavaInterpreterFlags();
        _sStartParameter = _pJacobInterface.getStartParameter();
        _sProjectTag = _pJacobInterface.getProjectTag();
        Hashtable htTempDependencies = _pJacobInterface.getDependencies();
        
        for(Enumeration eKeys = htTempDependencies.keys(); eKeys.hasMoreElements(); ) {
            String sFullClassName = (String)eKeys.nextElement();
            Vector vNext = (Vector)htTempDependencies.get(sFullClassName);
            
            String sClassName = Package.getClassName(sFullClassName);
            String sPackageName = Package.getPackageName(sFullClassName);
            Package pckNext = _pckMain.getPackage(sPackageName);
            
            String sClassPathName = FileUtil.concatPath(pckNext.getPath(),
                                                        sClassName);
            Util.debug("Makefile: <init>: sClassPathName: " + sClassPathName);
            Util.debug("Makefile: <init>: vNext: " + vNext);
            Util.debug("Makefile: <init>: sFullClassName: " + sFullClassName);
            _htDependencies.put(sClassPathName, vNext);
        }
        
        _createMakefile();
        _pJacobInterface.stopped( this );
    }
}
