package jacob;

import jacob.tool.JacobInterface;

import ccl.util.*;

/**
 * 
 * @author  <a href="http://mats.gmd.de/clemens/">Chr. Clemens Lahme</a> (<a href="mailto:clemens.lahme@mailexcite.com"><i>Clemens.Lahme@mailexcite.com</i></a>)
 * @version $Id: EditorAdapter.java,v 1.5 1999/02/22 11:44:03 clemens Exp clemens $
 */
public class EditorAdapter extends Singleton
    implements EditorInterface,
               JacobConstants
{
    protected JacobInterface _pJacobInterface = null;
    protected static EditorInterface _pEditor = null;
    private static JacobInterface _pStaticJacobInterface = null;
    
    protected EditorAdapter() {
        super();
    }
    
    /**
     * First use static init(Init).
     */
    public static Object getInstance() {
        if (_pEditor == null) {
            Util.panicIf(_pStaticJacobInterface == null);
            
            Init pInit = _pStaticJacobInterface.getInit();
            if ((pInit.getOptions().get(S_INIT_NOEMACS.toLowerCase()) != null) ||
                Util.atob(pInit.getKeyValue(S_INIT_NOEMACS)))
            {
                _pEditor = new EditorAdapter();
            } else {
                _pEditor = new EmacsEditor();
            }
            _pEditor.init(_pStaticJacobInterface);
        }
        
        return _pEditor;
    }
    
    public static void initInstance(JacobInterface pJacobInterface_) {
        _pStaticJacobInterface = pJacobInterface_;
    }
    
    /*
     * --- implemented methods of class 'jacob.EditorInterface' ---
     */
    
    public void init(JacobInterface pJacobInterface_) {
        _pJacobInterface = pJacobInterface_;
    }
    
    public void editFile(String sFileFullName_) {
    }
    
    public void saveCurrentFile() {
    }

    public void toFrontAndFocus() {
    }

    public String getCurrentFileName() {
        return null;
    }

    public void editMethod(String sJavaFileFullName_, 
                           String sMethod_) {
    }
    
    public boolean editMethod(String sFullMethod_) {
        return false;
    }

    public void insertString( String pString_ ) {
    }

    public void gotoLine( int line_ ) {
    }

    public void gotoColumn( int column_ ) {
    }

    public String getCurrentWord() {
        return null;
    }

    public void setColumnWidth(int columns_) {
    }
    
    public String system(String sCommand_) {
        return null;
    }
    
    public String toString() {
        String sRetVal = "No Editor";
        
        if (!(this instanceof EditorAdapter)) {
            sRetVal = getClass().getName();
            sRetVal = sRetVal.substring(sRetVal.lastIndexOf('.') + 1);
            if (Util.endsWith(sRetVal, "Editor")) {
                sRetVal = sRetVal.substring(0, sRetVal.length() - 6);
            }
        }
        
        return sRetVal;
    }
}
