// Copyright (C) 2000 Open Source Telecom Corporation.
//  
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software 
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// As a special exception to the GNU General Public License, permission is
// granted for additional uses of the text contained in its release
// of Bayonne as noted here.
//
// This exception is that permission is hereby granted to link Bayonne 
// with the Dialogic runtime libraries to produce a executable image
// without requiring Dialogic's sources to be supplied so long as each
// each source file so linked contains this exclusion.
//
// This exception does not however invalidate any other reasons why
// the resulting executable file might be covered by the GNU General
// public license or invalidate the licensing requirements of any
// other component or library.
//
// This exception applies only to the code released by OST under the
// name Bayonne.  If you copy code from other releases into a copy of
// Bayonne, as the General Public License permits, the exception does not
// apply to the code that you add in this way.  To avoid misleading
// anyone as to the status of such modified files, you must delete
// this exception notice from them.
//
// If you write modifications of your own to Bayonne, it is your choice
// whether to permit this exception to apply to your modifications.
// If you do not wish that, delete this exception notice, at which
// point the terms of your modification would be covered under the GPL
// as explicitly stated in "COPYING".

#include "driver.h"

#define	EVENT_BUFFER_SIZE	16

char DialogicTrunk::status[600];

DialogicTrunk::DialogicTrunk(int id, int ch, int ts) :
Trunk(id), TimerPort(), Thread(NULL, 0)
{
	unsigned long opts;
	CT_DEVINFO ctinfo;

	handler = NULL;
	lastring = 0;
	chdev = ch;
	tsdev = ts;

	interface = NT_ANALOG;

	if(dx_getctinfo(ch, &ctinfo) != -1)
	{
		switch(ctinfo.ct_nettype)
		{
		case CT_NTT1:
			interface = NT_T1;
			break;
		case CT_NTE1:
			interface = NT_E1;
			break;
		}
	}

	if(interface != NT_ANALOG)
	{
		if(ATDT_BDMODE(tsdev) == -1)
			interface = NT_ISDN;
	}

	routing = dialogicivr.getRouting();
	if(interface == NT_ANALOG)
	{
		if(routing)
		{
			nr_scunroute(chdev, SC_LSI, chdev, SC_VOX, SC_FULLDUP);
			nr_scroute(chdev, SC_LSI, chdev, SC_VOX, SC_FULLDUP);
		}
	}
	else
	{
		nr_scunroute(tsdev, SC_DTI, chdev, SC_VOX, SC_FULLDUP);
		nr_scroute(tsdev, SC_DTI, chdev, SC_VOX, SC_FULLDUP);
	}

	dx_setevtmsk(chdev, DM_RINGS);
	dx_setrings(chdev, group->getAnswer());

	if(interface != NT_ANALOG)
	{
		dt_setidle(tsdev, DTIS_DISABLE);
		dt_setsigmod(tsdev, DTM_SIGINS);
		if(interface == NT_E1)
			dt_settssigsim(tsdev, DTB_DON | DTB_COFF | DTB_AON);
		
		dt_setevtmsk(tsdev, DTG_SIGEVT, DTMM_AOFF | DTMM_AON,  DTA_SETMSK);
	}
	pipe(evbuf);
	opts = fcntl(evbuf[1], F_GETFL);
	fcntl(evbuf[1], F_SETFL, opts | O_NONBLOCK);
}

DialogicTrunk::~DialogicTrunk()
{
	Terminate();
	if(interface == NT_ANALOG)
	{
		if(routing)
			nr_scunroute(chdev, SC_LSI, chdev, SC_VOX, SC_FULLDUP);
	}
	else
	{
		nr_scunroute(tsdev, SC_DTI, chdev, SC_VOX, SC_FULLDUP);
	
		if(interface == NT_E1)
			dt_settssigsim(tsdev, DTB_BON);
		dt_close(tsdev);
	}
	dx_close(chdev);
	close(evbuf[0]);
	close(evbuf[1]);
}

void DialogicTrunk::Run(void)
{
	char buf[EVENT_BUFFER_SIZE];

	for(;;)
	{
		if(read(evbuf[0], &buf, sizeof(buf)) != sizeof(buf))
		{
			slog(SLOG_ERROR) << "dx(" << id << "): event failure in read" << endl;
			continue;
		}
		postEvent((TrunkEvent *)&buf);
	}
}

void DialogicTrunk::putEvent(TrunkEvent *evt)
{
	char buf[EVENT_BUFFER_SIZE];

	memcpy(buf, evt, sizeof(TrunkEvent));
	if(write(evbuf[1], &buf, sizeof(buf)) != sizeof(buf))
		slog(SLOG_ERROR) << "dx(" << id << "): event overflow" << endl;
}

