/*
 This file is part of GNU Taler
 (C) 2021-2023 Taler Systems S.A.

 GNU Taler is free software; you can redistribute it and/or modify it under the
 terms of the GNU General Public License as published by the Free Software
 Foundation; either version 3, or (at your option) any later version.

 GNU Taler is distributed in the hope that it will be useful, but WITHOUT ANY
 WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
 A PARTICULAR PURPOSE.  See the GNU General Public License for more details.

 You should have received a copy of the GNU General Public License along with
 GNU Taler; see the file COPYING.  If not, see <http://www.gnu.org/licenses/>
 */

/**
 *
 * @author Sebastian Javier Marchano (sebasjm)
 */

import { useTranslationContext } from "@gnu-taler/web-util/browser";
import { h, VNode, Fragment } from "preact";
import { route, Route } from "preact-router";
import { Paths, Redirect } from "../../InstanceRoutes.js";
import { AuditorBackend } from "../../declaration.js";

export interface ListPageProps {
  onShowAll: () => void;
  onShowNotPaid: () => void;
  onShowPaid: () => void;
  onShowRefunded: () => void;
  onShowNotWired: () => void;
  onShowWired: () => void;
  onCopyURL: (id: string) => void;
  isAllActive: string;
  isPaidActive: string;
  isNotPaidActive: string;
  isRefundedActive: string;
  isNotWiredActive: string;
  isWiredActive: string;

  jumpToDate?: Date;
  onSelectDate: (date?: Date) => void;

  onLoadMoreBefore?: () => void;
  hasMoreBefore?: boolean;
  hasMoreAfter?: boolean;
  onLoadMoreAfter?: () => void;

  onCreate: () => void;
}

export function ListPage(): VNode {
  const { i18n } = useTranslationContext();

  return (
    <Fragment>

      <div class="columns">
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.amount_arithmethic_inconsistency_list) }
                value={"Amount arithmetic inconsistencies"}
              >Amount arithmetic inconsistencies
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.bad_sig_losses_list) }
                value={"Bad signature losses"}
              >Bad signature losses
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.closure_lag_list) }
              >Closure Lags
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.coin_inconsistency_list) }
              >Coin inconsistencies
              </button>
            </div>
          </div>
        </div>
      </div>

      <div class="columns">
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.denomination_key_validity_withdraw_inconsistency_list) }
              >Denominations key validity
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.denomination_without_sig_list) }
              >Denominations without signature
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.denomination_pending_list) }
              >Denominations pending
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.deposit_confirmation_list) }
              >Deposit confirmations
              </button>
            </div>
          </div>
        </div>
      </div>

      <div class="columns">
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.emergency_list) }
              >Emergencies
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.emergency_by_count_list) }
              >Emergencies by count
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.fee_time_inconsistency_list) }
              >Fee time inconsistencies
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.misattribution_in_inconsistency_list) }
              >Misattribution in inconsistencies
              </button>
            </div>
          </div>
        </div>
      </div>

      <div class="columns">
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.purse_not_closed_inconsistency_list) }
              >Purses not closed
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.purse_list) }
              >Purses
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.refresh_hanging_list) }
              >Refreshes hanging
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.reserve_balance_insufficient_inconsistency_list) }
              >Reserve balances insufficient
              </button>
            </div>
          </div>
        </div>
      </div>

      <div class="columns">
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.reserve_balance_summary_wrong_inconsistency_list) }
              >Reserve balances summary wrong
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.reserve_in_inconsistency_list) }
              >Reserves in
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.reserve_not_closed_inconsistency_list) }
              >Reserves not closed
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.reserves_list) }
              >Reserves
              </button>
            </div>
          </div>
        </div>
      </div>

      <div class="columns">
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.row_inconsistency_list) }
              >Row inconsistencies
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.row_minor_inconsistency_list) }
              >Row minor inconsistencies
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.wire_format_inconsistency_list) }
              >Wire format inconsistencies
              </button>
            </div>
          </div>
        </div>
        <div class="column">
          <div class="card">
            <div class="card-body">
              <button
                class="button is-fullwidth"
                onClick={(e) => route(Paths.wire_out_inconsistency_list) }
              >Wire out inconsistencies
              </button>
            </div>
          </div>
        </div>
      </div>

    </Fragment>
  );
}
