/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.encoding;

import gnu.inet.encoding.CombiningClass;
import gnu.inet.encoding.Composition;
import gnu.inet.encoding.DecompositionKeys;
import gnu.inet.encoding.DecompositionMappings;

public class NFKC {
    static final int SBase = 44032;
    static final int LBase = 4352;
    static final int VBase = 4449;
    static final int TBase = 4519;
    static final int LCount = 19;
    static final int VCount = 21;
    static final int TCount = 28;
    static final int NCount = 588;
    static final int SCount = 11172;

    public static String normalizeNFKC(String string) {
        int n;
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        for (n3 = 0; n3 < string.length(); ++n3) {
            n2 = string.charAt(n3);
            if (n2 >= 44032 && n2 <= 55215) {
                stringBuffer.append(NFKC.decomposeHangul((char)n2));
                continue;
            }
            n = NFKC.decomposeIndex((char)n2);
            if (n == -1) {
                stringBuffer.append((char)n2);
                continue;
            }
            stringBuffer.append(DecompositionMappings.m[n]);
        }
        NFKC.canonicalOrdering(stringBuffer);
        n3 = 0;
        n2 = 0;
        for (n = 0; n < stringBuffer.length(); ++n) {
            char c;
            char c2;
            int n4;
            int n5 = NFKC.combiningClass(stringBuffer.charAt(n));
            if (n > 0 && (n3 == 0 || n3 != n5) && (n4 = NFKC.compose(c2 = stringBuffer.charAt(n2), c = stringBuffer.charAt(n))) != -1) {
                stringBuffer.setCharAt(n2, (char)n4);
                stringBuffer.deleteCharAt(n);
                if (--n == n2) {
                    n3 = 0;
                    continue;
                }
                n3 = NFKC.combiningClass(stringBuffer.charAt(n - 1));
                continue;
            }
            if (n5 == 0) {
                n2 = n;
            }
            n3 = n5;
        }
        return stringBuffer.toString();
    }

    static int decomposeIndex(char c) {
        int n = 0;
        int n2 = DecompositionKeys.k.length / 2;
        int n3;
        int n4;
        while (c != (n4 = DecompositionKeys.k[(n3 = (n + n2) / 2) * 2])) {
            if (n3 == n) {
                return -1;
            }
            if (c > n4) {
                n = n3;
                continue;
            }
            n2 = n3;
        }
        return DecompositionKeys.k[n3 * 2 + 1];
    }

    static int combiningClass(char c) {
        int n = c >> 8;
        int n2 = c & 0xFF;
        int n3 = CombiningClass.i[n];
        if (n3 > -1) {
            return CombiningClass.c[n3][n2];
        }
        return 0;
    }

    static void canonicalOrdering(StringBuffer stringBuffer) {
        boolean bl = false;
        while (!bl) {
            bl = true;
            int n = NFKC.combiningClass(stringBuffer.charAt(0));
            for (int i = 0; i < stringBuffer.length() - 1; ++i) {
                int n2 = NFKC.combiningClass(stringBuffer.charAt(i + 1));
                if (n2 != 0 && n > n2) {
                    for (int j = i + 1; j > 0 && NFKC.combiningClass(stringBuffer.charAt(j - 1)) > n2; --j) {
                        char c = stringBuffer.charAt(j);
                        stringBuffer.setCharAt(j, stringBuffer.charAt(j - 1));
                        stringBuffer.setCharAt(j - 1, c);
                        bl = false;
                    }
                    n2 = n;
                }
                n = n2;
            }
        }
    }

    static int composeIndex(char c) {
        if (c >> 8 >= Composition.composePage.length) {
            return -1;
        }
        int n = Composition.composePage[c >> 8];
        if (n == -1) {
            return -1;
        }
        return Composition.composeData[n][c & 0xFF];
    }

    static int compose(char c, char c2) {
        char[] cArray;
        int n = NFKC.composeHangul(c, c2);
        if (n != -1) {
            return n;
        }
        int n2 = NFKC.composeIndex(c);
        if (n2 >= 181 && n2 < 391) {
            if (c2 == Composition.singleFirst[n2 - 181][0]) {
                return Composition.singleFirst[n2 - 181][1];
            }
            return -1;
        }
        int n3 = NFKC.composeIndex(c2);
        if (n3 >= 391) {
            if (c == Composition.singleSecond[n3 - 391][0]) {
                return Composition.singleSecond[n3 - 391][1];
            }
            return -1;
        }
        if (n2 >= 0 && n2 < 144 && n3 >= 144 && n3 < 181 && n3 - 144 < (cArray = Composition.multiFirst[n2]).length) {
            char c3 = cArray[n3 - 144];
            if (c3 == '\u0000') {
                return -1;
            }
            return c3;
        }
        return -1;
    }

    static String decomposeHangul(char c) {
        int n = c - 44032;
        if (n < 0 || n >= 11172) {
            return String.valueOf(c);
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 4352 + n / 588;
        int n3 = 4449 + n % 588 / 28;
        int n4 = 4519 + n % 28;
        stringBuffer.append((char)n2);
        stringBuffer.append((char)n3);
        if (n4 != 4519) {
            stringBuffer.append((char)n4);
        }
        return stringBuffer.toString();
    }

    static int composeHangul(char c, char c2) {
        int n;
        int n2;
        int n3 = c - 4352;
        if (n3 >= 0 && n3 < 19 && (n2 = c2 - 4449) >= 0 && n2 < 21) {
            return 44032 + (n3 * 21 + n2) * 28;
        }
        n2 = c - 44032;
        if (n2 >= 0 && n2 < 11172 && n2 % 28 == 0 && (n = c2 - 4519) >= 0 && n <= 28) {
            return c + n;
        }
        return -1;
    }
}

