#
# Copyright 2004,2005 Free Software Foundation, Inc.
# 
# This file is part of GNU Radio
# 
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
# 
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with GNU Radio; see the file COPYING.  If not, write to
# the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
# Boston, MA 02111-1307, USA.
# 

"""
Wrapper for usrp sinks and sources.

When a sink or source is instantiated, probe the usb to locate the requested
board number, then use the appropriate version specific sink or source.
"""

__all__ = [ 'sink_c', 'source_c', 'sink_s', 'source_s']


import usrp_prims
from gnuradio import usrp0              # usrp Rev 0
from gnuradio import usrp1              # usrp Rev 1 and later

def look_for_usrp(which):
    """
    Try to open the specified usrp.

    @param which: int >= 0 specifying which USRP to open
    @type which: int
    
    @return: Returns version number, or raises RuntimeError
    @rtype: int
    """
    d = usrp_prims.usrp_find_device (which)
    if not d:
        raise RuntimeError, "Unable to find USRP #%d" % (which,)

    if usrp_prims.usrp_usrp0_p (d):
        return 0
    elif usrp_prims.usrp_usrp1_p (d) or usrp_prims.usrp_usrp2_p (d):
        return 1
    else:
        raise RuntimeError, "Hmmm, unknown usrp rev"


def sink_c(which, *args, **kwargs):
    return ((usrp0.sink_c, usrp1.sink_c)[look_for_usrp(which)])(which, *args, **kwargs)

def sink_s(which, *args, **kwargs):
    return ((usrp0.sink_s, usrp1.sink_s)[look_for_usrp(which)])(which, *args, **kwargs)

def source_c(which, *args, **kwargs):
    return ((usrp0.source_c, usrp1.source_c)[look_for_usrp(which)])(which, *args, **kwargs)

def source_s(which, *args, **kwargs):
    return ((usrp0.source_s, usrp1.source_s)[look_for_usrp(which)])(which, *args, **kwargs)
