#!/usr/bin/env python

import sys
import gtk
import gtk.glade

from thread import *

sys.path.append ('.')
sys.path.append ('/usr/local/gnuradio/python')
import GnuRadio

def gtk_main_quit(*args):
    m.stop()
    gtk.main_quit()

def clear_all(*args):
    txbutton.set_active(0)
    mutebutton.set_active(0)
    gainbutton.set_active(0)
    spinbutton.set_value(0)

def toggle_tx(*args):
    dds.set_tx(txbutton.get_active())

def toggle_mute(*args):
    dds.set_mute(mutebutton.get_active())

def toggle_gain(*args):
    dds.set_gain(gainbutton.get_active())

def toggle_extern(*args):
    print args

def spin_vc(*args):
    dds.set_freq(spinbutton.get_value())

dds=GnuRadio.sdr_1000()
xml = gtk.glade.XML("sdr1k_panel.glade")
xml.signal_autoconnect(locals())

#window = xml.get_widget("mainwin")
#txbutton = xml.get_widget("txtoggle")
#mutebutton = xml.get_widget("mutebutton")
#gainbutton = xml.get_widget("gainbutton")
#spinbutton = xml.get_widget("spinbutton1")

m = None
mainloop = None
source = None
sink = None
magblock = None
mixer = None

def StartUp(repeat=0):
    SAMPLE_RATE = 48000
    IF_BW = 20000
    DEMOD_GAIN = 1
    global m, source, sink, mainloop

    
    print ("Python GnuRadio StartUp called!")
    m = GnuRadio.VrMultiTask()
    print ("Made VrMultiTask", m)
    mainloop = GnuRadio.mainloop ()
    print ("Made mainloop", mainloop)
    source = GnuRadio.GrAudioSourceC(48000, 1,1, "/dev/dsp")
    sink = GnuRadio.GrAudioSinkF(1,"/dev/dsp")

    magblock = GnuRadio.GrMagnitudeCF()

    channel_coeffs = GnuRadio.gr_firdes.low_pass ( 1, SAMPLE_RATE,
                                                   IF_BW/2, 3000,
                                                   GnuRadio.gr_firdes.WIN_HAMMING)
    
    mixer = GnuRadio.GrFreqXlatingFIRfilterCCF(1,channel_coeffs,10000)

    fm_demod = GnuRadio.VrQuadratureDemodCF (DEMOD_GAIN)

    m.add(sink)

    mixer.connect_proc(source,0)
    fm_demod.connect_proc(mixer,0)
    sink.connect_proc(fm_demod, 0)

    m.start()
    print ("Started m")
    print ("Processing m...")
    mainloop.loop (m);
    print ("Stopped m")

#start_new_thread(StartUp,(0,))
#gtk.main()
start_new_thread(gtk.main,())
StartUp()
