/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef _GRDELAY_H_
#define _GRDELAY_H_

#include <VrHistoryProc.h>

template<class iType, class oType>
class GrDelay : public VrHistoryProc<iType,oType>
{
 public:
  GrDelay (unsigned int maxdelay);

  virtual const char *name () { return "GrDelay"; }
  virtual int work (VrSampleRange output, void *o[],
		    VrSampleRange inputs[], void *i[]);
  virtual void set_delay (unsigned int del) { del = (delay>history) ? history : delay; };
 protected:
  unsigned int delay;
};

template<class iType, class oType>
GrDelay<iType, oType>::GrDelay (unsigned int maxdelay)
  : VrHistoryProc<iType, oType>(1), delay(maxdelay) 
{ 
  history = delay+1;
}

template<class iType, class oType> int
GrDelay<iType, oType>::work (VrSampleRange output, void *ao[],
				     VrSampleRange inputs[], void *ai[])
{
  iType **in = (iType **) ai;
  oType **out = (oType **) ao;
  unsigned int size = output.size;
  for(unsigned int samp=0; samp < size; samp++)
    out[0][samp] = in[0][samp + history - delay];

  return output.size;
}

#endif
