/* -*- c++ -*- */
/*
 * Copyright 2002 Free Software Foundation, Inc.
 * 
 * This file is part of GNU Radio
 * 
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#include <microtune_eval_board.h>
#include <cstdio>
#include <cstdlib>
#include <iostream>


static void
usage (const char *name)
{
  std::cerr << "usage: " << name << " <agc_value_0_to_1000>\n";
  exit (1);
}

int
main (int argc, char **argv)
{
  int	which = 0;
  bool	ok = true;

  if (argc != 2)
    usage (argv[0]);

  float agc = strtod (argv[1], 0);
    
  microtune_eval_board *eb = new microtune_eval_board (which);

  if (!eb->board_present_p ()){
    ok = false;
    fprintf (stderr, "microtune: eval board is NOT present\n");
  }

  if (!ok)
    exit (1);

  eb->set_AGC (agc);
  exit (0);
}
