#!/usr/bin/env python

#
# read mpeg transport stream from stdin,
# write transport error flag to stdout, one per line
#

import sys, getopt

MPEG_PKT_LEN = 188

g_outfile = None
g_next = 0


def read_pkt (file):
    p = file.read (MPEG_PKT_LEN)
    if p and p[0] != '\x47':
        sys.stderr.write (("MPEG packet doesn't start with 0x47 at file offset %d\n"
                          % (file.tell() - MPEG_PKT_LEN)))
    return p


    
def process_packets (infile, output_filename_base):
    global g_outfile, g_next
    while 1:
        pkt = read_pkt (infile)
        if not pkt:
            break

        error_bit = (ord(pkt[1]) >> 7) & 0x1;
        if error_bit:
            if g_outfile:
                g_outfile.close ()
                g_outfile = None
        else:
            if not g_outfile:
                g_outfile = open ("%s.%03d" % (output_filename_base, g_next), "w")
                g_next = g_next + 1

            g_outfile.write (pkt)

            

def usage ():
    print "usage: %s -f input -o output_base" % sys.argv[0]
    sys.exit (2)


def main ():

    global g_outfile, g_next
    
    input_filename = None
    output_filename_base = None
    
    try:
        opts, args = getopt.getopt(sys.argv[1:], "f:o:")
    except getopt.GetoptError:
        # print help information and exit:
        usage ()

    for o, a in opts:
        if o == '-f':
            input_filename = a
        if o == '-o':
            output_filename_base = a

    if len (args) != 0:
        usage ()

    if not input_filename:
        usage ()

    if not output_filename_base:
        usage ()

    infile = open (input_filename, "r")
    g_outfile = None
    g_next = 0

    process_packets (infile, output_filename_base)

    
main ()
