
CCCC#ifdef HAVE_F77

CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
CCCCC
CCCCC     Contour finding package written by 
CCCCC         Prof. Overman, 
CCCCC         Math Dept
CCCCC         University of Arizona,
CCCCC         Tucson, AZ 85721
CCCCC
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC


      SUBROUTINE CNTADJ(X,Y,NPT,NCRVPD,XPRD,YPRD,IDXVAR,IDYVAR,
     1 DX,DY,FRADJT,ICONTR,ICLCIJ,IJATXY)

      REAL X(1),Y(1),XPRD(1),YPRD(1),DX(1),DY(1)
      INTEGER IJATXY(1)

      DMIN = AMIN1( ABS(DX(1)) , ABS(DY(1)) )
      IF ( IDXMIN .EQ. 0 ) GO TO 20
      DO 10 I = 1,NX-1
      AMIN = AMIN1( DMIN , ABS(DX(I)) )
   10 CONTINUE
   20 IF ( IDYMIN .EQ. 0 ) GO TO 50
      DO 30 J = 1,NY-1
      DMIN = AMIN1( DMIN , ABS(DY(J)) )
   30 CONTINUE

   50 DMINSQ = ( FRADJT*DMIN )**2

      NPTM = NPT - 1
      IF ( ICONTR .EQ. 2 ) NPTM = NPT - 2

      IF ( NCRVPD .GT. 1 ) GO TO 400

      I = 0
  100 I = I + 1
  120 IF ( I .GT. NPTM ) GO TO 300
      DSTSQI = (X(I+1) - X(I))**2  + (Y(I+1) - Y(I))**2
      IF ( DSTSQI .GE. DMINSQ ) GO TO 100

      IF ( ICONTR .NE. 2 ) GO TO 150
      X(I) = .5*(X(I) + X(I+1))
      Y(I) = .5*(Y(I) + Y(I+1))
      IF ( NCRVPD .EQ. 0 ) GO TO 200
      XPRD(I+1) = X(I)
      YPRD(I+1) = Y(I)
      GO TO 200
  150 IF ( I .EQ. 1 ) GO TO 200
      IF ( I .LT. NPTM ) GO TO 170
      X(I) = X(I+1)
      Y(I) = Y(I+1)
      IF ( ICLCIJ .EQ. 1 ) IJATXY(I) = IJATXY(I+1)
      IF ( NCRVPD .EQ. 0 ) GO TO 200
      XPRD(I+1) = .5*(XPRD(I+1) + XPRD(I+2))
      YPRD(I+1) = .5*(YPRD(I+1) + YPRD(I+2))
      GO TO 200
  170 X(I) = .5*(X(I) + X(I+1))
      Y(I) = .5*(Y(I) + Y(I+1))
      IF ( NCRVPD .EQ. 0 ) GO TO 200
      XPRD(I+1) = .5*(XPRD(I+1) + XPRD(I+2))
      YPRD(I+1) = .5*(YPRD(I+1) + YPRD(I+2))

  200 DO 220 K = I+1,NPT-1
      X(K) = X(K+1)
      Y(K) = Y(K+1)
      IF ( ICLCIJ .EQ. 1 ) IJATXY(K) = IJATXY(K+1)
  220 CONTINUE
      IF ( NCRVPD .EQ. 0 ) GO TO 270
      DO 240 K = I+1,NPT-1
      XPRD(K+1) = XPRD(K+2)
      YPRD(K+1) = YPRD(K+2)
  240 CONTINUE
  270 NPT = NPT - 1
      NPTM = NPTM - 1
      GO TO 120

  300 IF ( ICONTR .EQ. 1 ) GO TO 380

  320 NPTM1 = NPT - 1
      IF ( NPT .EQ. 1 ) GO TO 380
      DSTSQI = (X(NPTM1) - X(1))**2  + (Y(NPTM1) - Y(1))**2
      IF ( DSTSQI .GE. DMINSQ ) GO TO 350
      X(NPTM1) = .5*(X(NPTM1) + X(1))
      Y(NPTM1) = .5*(Y(NPTM1) + Y(1))
      IF ( NCRVPD .EQ. 0 ) GO TO 330
      XPRD(NPT) = .5*(XPRD(NPT) + XPRD(2))
      YPRD(NPT) = .5*(YPRD(NPT) + YPRD(2))
  330 NPT = NPT - 1
      GO TO 320
  350 X(NPT) = X(1)
      Y(NPT) = Y(1)
      IF ( ICLCIJ .EQ. 1 ) IJATXY(NPT) = IJATXY(1)
      IF ( NCRVPD .EQ. 0 ) GO TO 380
      XPRD(NPT+1) = XPRD(2)
      YPRD(NPT+1) = YPRD(2)

  380 IF ( NCRVPD .EQ. 0 ) GO TO 1000
      XPRD(1) = NPT
      GO TO 1000

  400 NCURVE = 0
      IPRD = 1
  420 NPTP = XPRD(IPRD)
      KEND = YPRD(IPRD)
      NCURVE = NCURVE + 1
      IPRD = IPRD + NPTP + 1
      IF ( KEND .EQ. 0 ) GO TO 420
      NPTPTT = IPRD - 1
      IEND = 0
      IENDPL = 0
      IPRDND = 0
      ICURVE = 0

  450 ICURVE = ICURVE + 1
      IST = IEND + 1
      IPRDST = IPRDND + 1
      NPTP = XPRD(IPRDST)
      KEND = YPRD(IPRDST)
      IENDPL = IEND + NPTP
      IEND = IEND + NPTP - 1
      IF ( ICURVE .EQ. NCURVE ) IEND = IEND + 1
      IPRDND = IPRDST + NPTP
      I = IST - 1

  500 I = I + 1
  520 IF ( I .GE. IENDPL ) GO TO 700
      DSTSQI = (X(I+1) - X(I))**2  + (Y(I+1) - Y(I))**2
      IF ( DSTSQI .GE. DMINSQ ) GO TO 500

      I0 = I - IST + 1
      IF ( I .EQ. IST ) GO TO 600
      IF ( I .LT. IENDPL-1 ) GO TO 570
      X(I) = X(I+1)
      Y(I) = Y(I+1)
      IF ( ICLCIJ .EQ. 1 ) IJATXY(I) = IJATXY(I+1)
      XPRD(IPRDST+I0) = XPRD(IPRDST+I0+1)
      YPRD(IPRDST+I0) = YPRD(IPRDST+I0+1)
      GO TO 600
  570 X(I) = .5*(X(I) + X(I+1))
      Y(I) = .5*(Y(I) + Y(I+1))
      XPRD(IPRDST+I0) = .5*(XPRD(IPRDST+I0) +
     1 XPRD(IPRDST+I0+1))
      YPRD(IPRDST+I0) = .5*(YPRD(IPRDST+I0) +
     1 YPRD(IPRDST+I0+1))

  600 DO 620 K = I+1,NPT-1
      X(K) = X(K+1)
      Y(K) = Y(K+1)
      IF ( ICLCIJ .EQ. 1 ) IJATXY(K) = IJATXY(K+1)
  620 CONTINUE
      DO 640 K = IPRDST+I0+1,NPTPTT-1
      XPRD(K) = XPRD(K+1)
      YPRD(K) = YPRD(K+1)
  640 CONTINUE
      NPTP = NPTP - 1
      IEND = IEND - 1
      IENDPL = IENDPL - 1
      IPRDND = IPRDND - 1
      NPT = NPT - 1
      NPTPTT = NPTPTT - 1
      GO TO 520

  700 XPRD(IPRDST) = NPTP
      IF ( KEND .EQ. 0 ) GO TO 450

 1000 RETURN
      END


      SUBROUTINE CNTCCL(ICONTR,IBRDR,X,Y,NPT,NCRVPD,
     1 XPRD,YPRD,ICLCIJ,IJATXY)

      REAL X(1),Y(1),XPRD(1),YPRD(1)
      INTEGER IJATXY(1)
      INTEGER JWRITE(5)

      COMMON /CNTDBG/ JWRITE

      IF ( ICONTR .EQ. 2 ) GO TO 100

      IF ( JWRITE(5) .EQ. 0 ) GO TO 9
      JWRIT5 = JWRITE(5)
      WRITE(JWRIT5,10090)IBRDR,X(1),Y(1),X(NPT),Y(NPT)
10090 FORMAT(' IBRDR,X,Y',I5,4F12.5)
    9 CONTINUE


C  THE CONTOUR IS OPEN

      GO TO (10,20,30,40) , IBRDR

   10 IF ( X(NPT) .LT. X(1) ) GO TO 1000
      GO TO 500

   20 IF ( Y(NPT) .LT. Y(1) ) GO TO 1000
      GO TO 500

   30 IF ( X(NPT) .GT. X(1) ) GO TO 1000
      GO TO 500

   40 IF ( Y(NPT) .GT. Y(1) ) GO TO 1000
      GO TO 500

  100 DELX2 = X(2) - X(1)
      DELY2 = Y(2) - Y(1)
      DELSQ2 = DELX2**2  + DELY2**2
      ANGLE = 0.
      NPTM2 = NPT - 2
      DO 120 I = 2,NPTM2
      DELX1 = DELX2
      DELY1 = DELY2
      DELSQ1 = DELSQ2
      DELX2 = X(I+1) - X(1)
      DELY2 = Y(I+1) - Y(1)
      DELSQ2 = DELX2**2  + DELY2**2
      IF ( DELSQ2 .EQ. 0. ) GO TO 150
      ANGLE = ANGLE + ASIN( (DELX1*DELY2 - DELX2*DELY1)/
     1 SQRT( DELSQ1*DELSQ2 ) )

      IF ( JWRITE(5) .EQ. 0 ) GO TO 119
      JWRIT5 = JWRITE(5)
      WRITE(JWRIT5,11190)ANGLE
11190 FORMAT(' ANGLE',F16.8)
  119 CONTINUE

  120 CONTINUE
  150 IF ( ANGLE .GT. 0. ) GO TO 1000

C  REVERSE THE CURVE

  500 NPTD2 = NPT/2
      KK = NPT
      DO 520 K = 1,NPTD2
      XK = X(K)
      YK = Y(K)
      X(K) = X(KK)
      Y(K) = Y(KK)
      X(KK) = XK
      Y(KK) = YK
      KK = KK - 1
  520 CONTINUE
      IF ( ICLCIJ .EQ. 0 ) GO TO 1000
      KK = NPT
      DO 540 K = 1,NPTD2
      IJK = IJATXY(K)
      IJATXY(K) = IJATXY(KK)
      IJATXY(KK) = IJK
      KK = KK - 1
  540 CONTINUE
      IF ( NCRVPD .EQ. 0 ) GO TO 1000

      KEND = 0
      IPRDND = 0
      NCURVE = 0
  600 IF ( KEND .EQ. 1 ) GO TO 650
      IPRDST = IPRDND + 1
      NPTP = XPRD(IPRDST)
      KEND = YPRD(IPRDST)
      IPRDM1 = IPRDST - 1
      DO 620 I = 1,NPTP
      XPRD(I+IPRDM1) = XPRD(I+IPRDST)
      YPRD(I+IPRDM1) = YPRD(I+IPRDST)
  620 CONTINUE
      IPRDND = IPRDST + NPTP
      XPRD(IPRDND) = NPTP
      YPRD(IPRDND) = KEND
      IF ( IPRDST .EQ. 1 ) YPRD(IPRDND) = 1.
      NCURVE = NCURVE + 1
      GO TO 600

  650 IPRDP1 = IPRDND + 1
      IPRDD2 = IPRDND/2
      DO 670 I = 1,IPRDD2
      XST = XPRD(I)
      YST = YPRD(I)
      XPRD(I) = XPRD(IPRDP1-I)
      YPRD(I) = YPRD(IPRDP1-I)
      XPRD(IPRDP1-I) = XST
      YPRD(IPRDP1-I) = YST
  670 CONTINUE
      IF ( NCURVE .GT. 1 ) YPRD(1) = 0.

 1000 RETURN
      END


      SUBROUTINE CNTCKB(IBRDR,ISTRT,JSTRT,NX,NY,IABOX)

      INTEGER IABOX(NX,1)

      COMMON /CNTBIT/ IBIT1,IBIT2,IBIT3,IBIT4,IBIT5,
     1                IBT2A5,IBT2T5

      NXYMP1 = MAX0(NX,NY) + 1
      IBRDRM = MOD(IBRDR-1,4) + 1
      IBRDRD = (IBRDR + 3)/4

      GO TO (100,200,300,400) , IBRDRM

  100 JJ = 1
      DO 120 I = ISTRT,NX-1
      IF ( (IABOX(I,JJ) .AND. IBIT2) .EQ. 0 ) GO TO 120
      II = I
      GO TO 150
  120 CONTINUE
      ISTRT = 1
      JSTRT = 1
      GO TO (200,300,300) , IBRDRD
  150 IBRDR = 1
      IABIT1 = MOD( IABOX(NX,NY) , 2 )
      IABOX(NX,NY) = -( 2*(NXYMP1*IBRDR + II) + IABIT1 )
      ISTRT = II
      JSTRT = JJ
      GO TO 1000

  200 II = NX - 1
      DO 220 J = JSTRT,NY-1
      IF ( (IABOX(II,J) .AND. IBIT3) .EQ. 0 ) GO TO 220
      JJ = J
      GO TO 250
  220 CONTINUE
      ISTRT = 1
      JSTRT = 1
      GO TO (300,400,400) , IBRDRD
  250 IBRDR = 2
      IABIT1 = MOD( IABOX(NX,NY) , 2 )
      IABOX(NX,NY) = -( 2*(NXYMP1*IBRDR + JJ) + IABIT1 )
      ISTRT = II
      JSTRT = JJ
      GO TO 1000

  300 JJ = NY - 1
      DO 320 I = ISTRT,NX-1
      IF ( (IABOX(I,JJ) .AND. IBIT4) .EQ. 0 ) GO TO 320
      II = I
      GO TO 350
  320 CONTINUE
      ISTRT = 1
      JSTRT = 1
      GO TO (400,200,500) , IBRDRD
  350 IBRDR = 3
      IABIT1 = MOD( IABOX(NX,NY) , 2 )
      IABOX(NX,NY) = -( 2*(NXYMP1*IBRDR + II) + IABIT1 )
      ISTRT = II
      JSTRT = JJ
      GO TO 1000

  400 II = 1
      DO 420 J = JSTRT,NY-1
      IF ( (IABOX(II,J) .AND. IBIT5) .EQ. 0 ) GO TO 420
      JJ = J
      GO TO 450
  420 CONTINUE
      ISTRT = 1
      JSTRT = 1
      GO TO (500,500,100) , IBRDRD
  450 IBRDR = 4
      IABIT1 = MOD( IABOX(NX,NY) , 2 )
      IABOX(NX,NY) = -( 2*(NXYMP1*IBRDR + JJ) + IABIT1 )
      ISTRT = II
      JSTRT = JJ
      GO TO 1000

  500 IBRDR = 0

 1000 RETURN
      END


      SUBROUTINE CNTCKI(ISTRT,JSTRT,NX,NY,IABOX,
     1 IZERO)

      INTEGER IABOX(NX,1)

      COMMON /CNTBIT/ IBIT1,IBIT2,IBIT3,IBIT4,IBIT5,
     1                IBT2A5,IBT2T5

      DO 40 J = JSTRT,NY-1
      DO 30 I = ISTRT,NX-1
      IF ( (IABOX(I,J) .AND. IBT2A5) .EQ. 0 ) GO TO 30
      II = I
      JJ = J
      GO TO 100
   30 CONTINUE
      ISTRT = 1
   40 CONTINUE
      IZERO = 0
      GO TO 1000

  100 IABIT1 = MOD( IABOX(NX,NY) , 2 )
      IABOX(NX,NY) = 2*((NX + 1)*JJ + II) + IABIT1
      ISTRT = II
      JSTRT = JJ
      IZERO = 1

 1000 RETURN
      END


      subroutine cntclc(iwhich,a,nx,ny,mx,avalue,
     1 iprdlr,iprdtb,maxnpt,intrpl,xat11,yat11,idxvar,idyvar,
     2 dx,dy,fradjt,icclkw,ixyprd,iclcij,iabox,
     3 x,y,npt,icontr,ijatxy,xprd,yprd)

      COMMON /CNTDBG/ JWRITE
      COMMON /CNTBIT/ IBIT1,IBIT2,IBIT3,IBIT4,IBIT5,
     1                IBT2A5,IBT2T5
      REAL A(MX,1)
      INTEGER IABOX(NX,1)
      REAL DX(1),DY(1)
      REAL X(1),Y(1),XPRD(1),YPRD(1)
      INTEGER IJATXY(1)
      INTEGER JWRITE(5)

      DATA SMALL / 1.E-05 /
      DATA IDEBUG / 0 /

      IBIT1 = 1
      IBIT2 = 2
      IBIT3 = 4
      IBIT4 = 8
      IBIT5 = 16
      IBT2A5 = IBIT2 + IBIT5
      IBT2T5 = IBIT2 + IBIT3 + IBIT4 + IBIT5

      IF ( IDEBUG .EQ. 1 ) GO TO 30
      DO 10 I = 1,5
      JWRITE(I) = 0
   10 CONTINUE

   30 IF ( INTRPL .NE. 1 .AND. MIN0(NX,NY) .LE. 3 ) GO TO 900
      IF ( MIN0(NX,NY) .LE. 1 ) GO TO 920
      NXYMP1 = MAX0(NX,NY) + 1

      XAT11P = XAT11
      YAT11P = YAT11
      IPRD = 0
      NCRVPD = 0
      IPXY = 1
      IPRDST = 1
      IPRDPV = 0
      IF ( IPRDLR .EQ. 0 ) GO TO 60
      IPRD = 1
      IF ( IDXVAR .EQ. 1 ) GO TO 40
      WIDTH = (NX - 1.)*DX(1)
      GO TO 60
   40 WIDTH = 0.
      DO 50 I = 1,NX-1
      WIDTH = WIDTH + DX(I)
   50 CONTINUE
   60 IF ( IPRDTB .EQ. 0 ) GO TO 100
      IPRD = 1
      IF ( IDYVAR .EQ. 1 ) GO TO 70
      HEIGHT = (NY - 1.)*DY(1)
      GO TO 100
   70 HEIGHT = 0.
      DO 80 J = 1,NY-1
      HEIGHT = HEIGHT + DY(J)
   80 CONTINUE

  100 IF ( IWHICH .EQ. 3 ) GO TO 600
      IF ( IWHICH .EQ. 1 ) GO TO 200
      IF ( IWHICH .NE. 2 ) GO TO 940

      IF ( JWRITE(1) .EQ. 0 ) GO TO 109
      JWRIT1 = JWRITE(1)
      NLINES = ((NX - 1) + 9)/10
      DO 108 J = 1,NY-1
      JREV = NY - J
      IEND = 0
      DO 107 NL = 1,NLINES
      ISTRT = IEND + 1
      IEND = IEND + 10
      IF ( NL .EQ. NLINES ) IEND = NX - 1
      IF ( NL .EQ. 1 )
     1 WRITE(JWRIT1,11097)JREV,(IABOX(I,JREV),I=ISTRT,IEND)
11097 FORMAT(I4,10I12)
      IF ( NL .NE. 1 )
     1 WRITE(JWRIT1,11098)(IABOX(I,JREV),I=ISTRT,IEND)
11098 FORMAT(4X,10I12)
  107 CONTINUE
  108 CONTINUE
      WRITE(JWRIT1,11099)IABOX(NX,NY)
11099 FORMAT(' IABOX(NX,NY)=',I10)
  109 CONTINUE
CCCCC
      IF ( IABOX(NX,NY) .GT. 0 ) GO TO 120
      IBRDR = ( (-IABOX(NX,NY)/2) )/NXYMP1
      ISTRT = (-IABOX(NX,NY)/2) - NXYMP1*IBRDR
      JSTRT = ISTRT
      GO TO 300
  120 JSTRT = (IABOX(NX,NY)/2) / (NX + 1)
      ISTRT = (IABOX(NX,NY)/2) - (NX + 1)*JSTRT
      GO TO 500

C  THIS IS THE INITIAL CALL SO SET UP 'A' AND  IABOX

  200 CALL CNTSTA(A,NX,NY,MX,AVALUE,SMALL,IPRDLR,IPRDTB,
     1 IABOX)
      ISTRT = 1
      IBRDR = 1
      IF ( IPRD .EQ. 0 ) GO TO 300
      JSTRT = 1
      IF ( IPRDLR .EQ. 1 .AND. IPRDTB .EQ. 0 ) IBRDR = 5
      IF ( IPRDLR .EQ. 0 .AND. IPRDTB .EQ. 1 ) IBRDR = 9

  300 CALL CNTCKB(IBRDR,ISTRT,JSTRT,NX,NY,IABOX)
      IF ( IBRDR .EQ. 0 ) GO TO 500
      IF ( IPRD .EQ. 0 ) GO TO 400

      ISTRT0 = ISTRT
      JSTRT0 = JSTRT
      IBRDR0 = IBRDR
  350 IF ( NCRVPD .GE. 1 ) IPXY = IPXY - 1
      MXNPTP = MAXNPT + 1 - IPXY
      CALL CNTRPT(IBRDR,ISTRT,JSTRT,A,NX,NY,MX,
     1 IABOX,MAXNPT,INTRPL,XAT11P,YAT11P,IDXVAR,IDYVAR,
     2 DX,DY,ICLCIJ,
     3 X(IPXY),Y(IPXY),NPT,IJATXY(IPXY))
      IF ( IPRDST+NPT .GT. MAXNPT ) GO TO 960
      XPRD(IPRDST) = NPT
      YPRD(IPRDST) = 1.
      IF ( IPRDPV .NE. 0 ) YPRD(IPRDPV) = 0.
      IPXYM1 = IPXY - 1
      XDIF = XAT11P - XAT11
      YDIF = YAT11P - YAT11
      DO 370 I = 1,NPT
      XPRD(I+IPRDST) = X(I+IPXYM1) - XDIF
      YPRD(I+IPRDST) = Y(I+IPXYM1) - YDIF
  370 CONTINUE
      NCRVPD = NCRVPD + 1
      IPRDPV = IPRDST
      IPRDST = IPRDST + NPT + 1
      IPXY = IPXY + NPT
      IPXYND = IPXY - 1
      CALL CNTPNX(NCRVPD,IABOX,MX,NX,NY,IJATXY(IPXYND),
     1 ISTRT0,JSTRT0,IBRDR0,WIDTH,HEIGHT,XAT11P,YAT11P,
     2 KEND,ICONTR,IBRDR,ISTRT,JSTRT)
      IF ( KEND .EQ. 0 ) GO TO 350
      NPT = IPXYND
      IWHICH = 2
      IF ( ICONTR .EQ. 1 ) GO TO 700
      IF ( ABS(X(NPT)-X(1)) .GE. .01*WIDTH .OR.
     1 ABS(Y(NPT)-Y(1)) .GE. .01*HEIGHT ) ICONTR = 3
      GO TO 700


  400 CALL CNTRPT(IBRDR,ISTRT,JSTRT,A,NX,NY,MX,
     1 IABOX,MAXNPT,INTRPL,XAT11P,YAT11P,IDXVAR,IDYVAR,
     2 DX,DY,ICLCIJ,
     3 X,Y,NPT,IJATXY)
      ICONTR = 1
      IF ( NPT .EQ. 1 ) ICONTR = -1
      IWHICH = 2
      GO TO 700

  500 CALL CNTCKI(ISTRT,JSTRT,NX,NY,IABOX,
     1 IZERO)
      IF ( IZERO .EQ. 1 ) GO TO 550
      ICONTR = 0
      GO TO 600
  550 CALL CNTRPT(IBRDR,ISTRT,JSTRT,A,NX,NY,MX,
     1 IABOX,MAXNPT,INTRPL,XAT11P,YAT11P,IDXVAR,IDYVAR,
     2 DX,DY,ICLCIJ,
     3 X,Y,NPT,IJATXY)
      ICONTR = 2
      IF ( NPT .EQ. 1 ) ICONTR = -1
      IWHICH = 2
      IF ( IPRD .EQ. 0 ) GO TO 700
      IF ( NPT+1 .GT. MAXNPT ) GO TO 960
      XPRD(1) = NPT
      YPRD(1) = 1.
      DO 570 I = 1,NPT
      XPRD(I+1) = X(I)
      YPRD(I+1) = Y(I)
  570 CONTINUE
      GO TO 700


  600 DO 650 J = 1,NY
      DO 640 I = 1,NX
      IF ((IABOX(I,J) .AND. IBIT1) .EQ. 1 ) A(I,J) = 0.
      A(I,J) = A(I,J) + AVALUE
  640 CONTINUE
  650 CONTINUE
      IWHICH = 1
      GO TO 1000


  700 IF ( IPRD .EQ. 1 .OR. IXYPRD .EQ. 0 ) GO TO 750
      IF ( NPT+1 .GT. MAXNPT ) GO TO 960
      XPRD(1) = NPT
      YPRD(1) = 1.
      DO 720 I = 1,NPT
      XPRD(I+1) = X(I)
      YPRD(I+1) = Y(I)
  720 CONTINUE
      NCRVPD = 1


  750 IF ( ICONTR .EQ. -1 ) GO TO 1000
      IF ( ICCLKW .EQ. 1 )
     * CALL CNTCCL(ICONTR,IBRDR,X,Y,NPT,NCRVPD,
     1 XPRD,YPRD,ICLCIJ,IJATXY)
      IF ( FRADJT .NE. 0. )
     * CALL CNTADJ(X,Y,NPT,NCRVPD,XPRD,YPRD,IDXVAR,IDYVAR,
     1 DX,DY,FRADJT,ICONTR,ICLCIJ,IJATXY)
      IF ( NPT .EQ. 1 ) ICONTR = -1
      IF ( ICONTR .NE. 2 ) GO TO 1000
      X(NPT) = X(1)
      Y(NPT) = Y(1)
      GO TO 1000

  900 WRITE(6,19000)
19000 FORMAT(' In subroutine cntclc to use cubic interpolation',
     1 ' you must have  NX,NY >= 4')
      STOP

  920 WRITE(6,19200)
19200 FORMAT(' In subroutine cntclc you must have  NX,NY >= 2')
      STOP

  940 WRITE(6,19400)IWHICH
19400 FORMAT(' in subroutine cntclc  iwhich  must be 1, 2, or',
     1 ' 3.  it is',I20)
      STOP

  960 WRITE(6,19600)
19600 FORMAT(' In subroutine cntclc the dimensioned size of',
     1 ' xprd,yprd  is not large enough')
      STOP

 1000 RETURN
      END


      SUBROUTINE CNTPNX(NCRVPD,IABOX,MX,NX,NY,IJATXY,
     1 ISTRT0,JSTRT0,IBRDR0,WIDTH,HEIGHT,XAT11P,YAT11P,
     2 KEND,ICONTR,IBRDR,ISTRT,JSTRT)

      COMMON /CNTBIT/ IBIT1,IBIT2,IBIT3,IBIT4,IBIT5,
     1                IBT2A5,IBT2T5
      INTEGER IABOX(MX,1)


      IBRDR = 0
      JEND = IABS(IJATXY)/(NX + 1)
      IEND = IABS(IJATXY) - JEND*(NX + 1)
      IF ( IJATXY .LT. 0 ) GO TO 20
      IF ( JEND .EQ. 1 ) IBRDR = 1
      IF ( JEND .EQ. NY ) IBRDR = 3
      IF ( IBRDR .EQ. 0 ) GO TO 890
      GO TO 50
   20 IF ( IEND .EQ. 1 ) IBRDR = 4
      IF ( IEND .EQ. NX ) IBRDR = 2
      IF ( IBRDR .EQ. 0 ) GO TO 890
   50 ICONTR = 2
      GO TO (100,200,300,400) , IBRDR

  100 IF ( NCRVPD .EQ. 1 .AND. IPRDTB .EQ. 0 ) ICONTR = 1
      IF ( (IABOX(IEND,JEND) .AND. IBIT2) .EQ. 0 ) GO TO 900
      ISTRT = IEND
      JSTRT = NY - 1
      IBRDR = 3
      YAT11P = YAT11P - HEIGHT
      GO TO 500

  200 IF ( NCRVPD .EQ. 1 .AND. IPRDLR .EQ. 0 ) ICONTR = 1
      IF ( (IABOX(IEND,JEND) .AND. IBIT3) .EQ. 0 ) GO TO 900
      ISTRT = 1
      JSTRT = JEND
      IBRDR = 4
      XAT11P = XAT11P + WIDTH
      GO TO 500

  300 IF ( NCRVPD .EQ. 1 .AND. IPRDTB .EQ. 0 ) ICONTR = 1
      IF ( (IABOX(IEND,JEND) .AND. IBIT4) .EQ. 0 ) GO TO 900
      ISTRT = IEND
      JSTRT = 1
      IBRDR = 1
      YAT11P = YAT11P + HEIGHT
      GO TO 500

  400 IF ( NCRVPD .EQ. 1 .AND. IPRDLR .EQ. 0 ) ICONTR = 1
      IF ( (IABOX(IEND,JEND) .AND. IBIT5) .EQ. 0 ) GO TO 900
      ISTRT = NX - 1
      JSTRT = JEND
      IBRDR = 2
      XAT11P = XAT11P - WIDTH

  500 KEND = 0
      IF ( ISTRT .EQ. ISTRT0 .AND. JSTRT .EQ. JSTRT0 .AND.
     1 IBRDR .EQ. IBRDR0 ) KEND = 1
      GO TO 1000

  890 WRITE(6,18900)
18900 FORMAT(' Error in subroutine cntpnx - ijatxy  is',
     1 ' incorrect')
      STOP

  900 WRITE(6,19000)
19000 FORMAT(' Error in subroutine cntpnx  A = 0  across a',
     1 ' boundary')
      STOP

 1000 RETURN
      END

      SUBROUTINE CNTRPT(IBRDR,I,J,A,NX,NY,MX,
     1 IABOX,MAXNPT,INTRPL,XAT11P,YAT11P,IDXVAR,IDYVAR,
     2 DX,DY,ICLCIJ,
     3 X,Y,NPT,IJATXY)

      COMMON /CNTDBG/ JWRITE
      REAL A(MX,1)
      REAL DX(1),DY(1)
      INTEGER IABOX(NX,1)
      REAL X(1),Y(1)
      INTEGER IJATXY(1)
      INTEGER IBIT(4)
      INTEGER IJATAD(4,3)
      INTEGER JWRITE(5)

      COMMON /CNTBIT/ IBIT1,IBIT,
     1                IBT2A5,IBT2T5
      DATA IJATAD / 0 , 1 , 0 , 0 ,
     1              0 , 0 , 1 , 0 ,
     2              1 , -1 , 1 , -1 /


      II = I
      JJ = J
      NPT = 0

      XII = XAT11P
      IF ( II .EQ. 1 ) GO TO 20
      IF ( IDXVAR .EQ. 0 ) GO TO 15
      IIM1 = II - 1
      DO 10 ID = 1,IIM1
      XII = XII + DX(ID)
   10 CONTINUE
      GO TO 20
   15 XII = XII + DX(1)*(II - 1.)

   20 YJJ = YAT11P
      IF ( JJ .EQ. 1 ) GO TO 40
      IF ( IDYVAR .EQ. 0 ) GO TO 35
      JJM1 = JJ - 1
      DO 30 JD = 1,JJM1
      YJJ = YJJ + DY(JD)
   30 CONTINUE
      GO TO 40
   35 YJJ = YJJ + DY(1)*(JJ - 1.)

   40 IF ( IDXVAR .EQ. 1 ) DXII = DX(II)
      IF ( IDXVAR .EQ. 0 ) DXII = DX(1)
      IF ( IDYVAR .EQ. 1 ) DYJJ = DY(JJ)
      IF ( IDYVAR .EQ. 0 ) DYJJ = DY(1)

      IF ( IBRDR .EQ. 0 ) GO TO 50
      ISIDE1 = IBRDR
      GO TO 100
   50 IF ( (IABOX(II,JJ) .AND. IBIT(1)) .EQ. 0 ) GO TO 60
      ISIDE1 = 1
      GO TO 100
   60 IF ( (IABOX(II,JJ) .AND. IBIT(4)) .EQ. 0 ) GO TO 900
      ISIDE1 = 4
  100 ISIDE0 = ISIDE1

C  USE LINEAR OR CUBIC INTERPOLATION TO FIND THE POINT ON THIS

      NPT = NPT + 1
      IF ( NPT .GT. MAXNPT ) GO TO 920
      IF ( ICLCIJ .EQ. 1 )
     1 IJATXY(NPT) = IJATAD(ISIDE1,3)*( (NX+1)*(JJ +
     2 IJATAD(ISIDE1,2)) + (II + IJATAD(ISIDE1,1)) )
      GO TO (110,120,130,140) , ISIDE1
  110 X(NPT) = XII + CNTZRO(INTRPL,1,II,JJ,A,MX,NX,IDXVAR,DX)
      Y(NPT) = YJJ
      GO TO 160
  120 X(NPT) = XII + DXII
      IIP1 = II + 1
      Y(NPT) = YJJ + CNTZRO(INTRPL,2,IIP1,JJ,A,MX,NY,IDYVAR,DY)
      GO TO 160
  130 JJP1 = JJ + 1
      X(NPT) = XII + CNTZRO(INTRPL,1,II,JJP1,A,MX,NX,IDXVAR,DX)
      Y(NPT) = YJJ + DYJJ
      GO TO 160
  140 X(NPT) = XII
      Y(NPT) = YJJ + CNTZRO(INTRPL,2,II,JJ,A,MX,NY,IDYVAR,DY)
  160 CONTINUE

      IF ( JWRITE(3) .EQ. 0 ) GO TO 169
      JWRIT3 = JWRITE(3)
      WRITE(JWRIT3,11690)NPT,X(NPT),Y(NPT),II,JJ,ISIDE1
11690 FORMAT(' X,Y,I,J,ISIDE',I5,2F12.5,3I5)
  169 CONTINUE

  200 IF ( (IABOX(II,JJ) .AND. IBT2T5) .EQ. IBT2T5 ) GO TO 240
      IABOX(II,JJ) = IABOX(II,JJ) - IBIT(ISIDE1)
      DO 220 ISDE2 = 1,4
      ISIDE2 = ISDE2
      IF ( (IABOX(II,JJ) .AND. IBIT(ISIDE2)) .NE. 0 ) GO TO 300
  220 CONTINUE
      GO TO 900
  240 DISC = A(II,JJ)*A(II+1,JJ+1) - A(II+1,JJ)*A(II,JJ+1)
      IABOX(II,JJ) = IABOX(II,JJ) - IBIT(ISIDE1)

      IF ( JWRITE(3) .EQ. 0 ) GO TO 249
      JWRIT3 = JWRITE(3)
      WRITE(JWRIT3,12490)DISC
12490 FORMAT(' ALL FOUR SIDES - DISC',E20.8)
  249 CONTINUE

      IF ( DISC .LT. 0. ) GO TO 260
      IF ( ISIDE1 .LE. 2 ) ISIDE2 = 3 - ISIDE1
      IF ( ISIDE1 .GT. 2 ) ISIDE2 = 7 - ISIDE1
      GO TO 300
  260 ISIDE2 = 5 - ISIDE1


  300 IABOX(II,JJ) = IABOX(II,JJ) - IBIT(ISIDE2)
      NPT = NPT + 1
      IF ( NPT .GT. MAXNPT ) GO TO 920
      IF ( ICLCIJ .EQ. 1 )
     1 IJATXY(NPT) = IJATAD(ISIDE2,3)*( (NX+1)*(JJ +
     2 IJATAD(ISIDE2,2)) + (II + IJATAD(ISIDE2,1)) )
      GO TO (310,320,330,340) , ISIDE2
  310 X(NPT) = XII + CNTZRO(INTRPL,1,II,JJ,A,MX,NX,IDXVAR,DX)
      Y(NPT) = YJJ
      JJ = JJ - 1
      IF ( JJ .EQ. 0 ) GO TO 500
      IF ( IDYVAR .EQ. 1 ) YJJ = YJJ - DY(JJ)
      IF ( IDYVAR .EQ. 0 ) YJJ = YJJ - DY(1)
      ISIDE1 = 3
      GO TO 400
  320 X(NPT) = XII + DXII
      IIP1 = II + 1
      Y(NPT) = YJJ + CNTZRO(INTRPL,2,IIP1,JJ,A,MX,NY,IDYVAR,DY)
      II = II + 1
      IF ( II .EQ. NX ) GO TO 500
      IF ( IDXVAR .EQ. 1 ) XII = XII + DX(II-1)
      IF ( IDXVAR .EQ. 0 ) XII = XII + DX(1)
      ISIDE1 = 4
      GO TO 400
  330 JJP1 = JJ + 1
      X(NPT) = XII + CNTZRO(INTRPL,1,II,JJP1,A,MX,NX,IDXVAR,DX)
      Y(NPT) = YJJ + DYJJ
      JJ = JJ + 1
      IF ( JJ .EQ. NY ) GO TO 500
      IF ( IDYVAR .EQ. 1 ) YJJ = YJJ + DY(JJ-1)
      IF ( IDYVAR .EQ. 0 ) YJJ = YJJ + DY(1)
      ISIDE1 = 1
      GO TO 400
  340 X(NPT) = XII
      Y(NPT) = YJJ + CNTZRO(INTRPL,2,II,JJ,A,MX,NY,IDYVAR,DY)
      II = II - 1
      IF ( II .EQ. 0 ) GO TO 500
      IF ( IDXVAR .EQ. 1 ) XII = XII - DX(II)
      IF ( IDXVAR .EQ. 0 ) XII = XII - DX(1)
      ISIDE1 = 2

  400 IF ( IDXVAR .EQ. 1 ) DXII = DX(II)
      IF ( IDYVAR .EQ. 1 ) DYJJ = DY(JJ)
CCCCC
      IF ( JWRITE(3) .EQ. 0 ) GO TO 409
      JWRIT3 = JWRITE(3)
      WRITE(JWRIT3,11690)NPT,X(NPT),Y(NPT),II,JJ,ISIDE1
  409 CONTINUE
CCCCC


      IF ( II .NE. I .OR. JJ .NE. J ) GO TO 200
      IF ( ISIDE1 .NE. ISIDE0 ) GO TO 200
      GO TO 1000

  500 CONTINUE

      IF ( JWRITE(3) .EQ. 0 ) GO TO 509
      JWRIT3 = JWRITE(3)
      WRITE(JWRIT3,11690)NPT,X(NPT),Y(NPT),II,JJ,ISIDE1
  509 CONTINUE

      GO TO 1000

  900 WRITE(6,19000)II,JJ,IABOX(II,JJ)
19000 FORMAT(' Error in subroutine cntrpt at do loop',
     1 3I8)
      STOP

  920 WRITE(6,19200)MAXNPT
19200 FORMAT(' The maximum number of points on a contour in',
     1 ' subroutine cntrpt',I7,'  has been exceeded')
      STOP

 1000 RETURN
      END

      SUBROUTINE CNTSTA(A,NX,NY,MX,AVALUE,SMALL,IPRDLR,IPRDTB,
     1 IABOX)

      REAL A(MX,1)
      INTEGER IABOX(NX,1)
      INTEGER JWRITE(5)

      COMMON /CNTBIT/ IBIT1,IBIT2,IBIT3,IBIT4,IBIT5,
     1                IBT2A5,IBT2T5
      COMMON /CNTDBG/ JWRITE

      IF ( IPRDLR .EQ. 0 ) GO TO 50
      DO 20 J = 1,NY
      A(NX,J) = A(1,J)
   20 CONTINUE
   50 IF ( IPRDTB .EQ. 0 ) GO TO 100
      DO 70 I = 1,NX
      A(I,NY) = A(I,1)
   70 CONTINUE

  100 DO 150 J = 1,NY
      DO 140 I = 1,NX
      A(I,J) = A(I,J) - AVALUE
      IABOX(I,J) = 0
  140 CONTINUE
  150 CONTINUE

      DO 280 J = 1,NY
      DO 270 I = 1,NX
      IF ( A(I,J) .NE. 0. ) GO TO 270
      IABOX(I,J) = IBIT1
      IM1 = I - 1
      IF ( I .NE. 1 ) GO TO 230
      IM1 = 2
      IF ( IPRDLR .EQ. 1 ) IM1 = NX - 1
  230 IP1 = I + 1
      IF ( I .NE. NX ) GO TO 240
      IP1 = NX - 1
      IF ( IPRDLR .EQ. 1 ) IP1 = 2
  240 JM1 = J - 1
      IF ( J .NE. 1 ) GO TO 250
      JM1 = 2
      IF ( IPRDTB .EQ. 1 ) JM1 = NY - 2
  250 JP1 = J + 1
      IF ( J .NE. NY ) GO TO 260
      JP1 = NY - 1
      IF ( IPRDTB .EQ. 1 ) JP1 = 2
  260 A(I,J) = SMALL*AMIN1( ABS(A(IM1,J)) , ABS(A(I,JM1)) ,
     1 ABS(A(IP1,J)) , ABS(A(I,JP1)) )
      IF ( A(I,J) .NE. 0. ) GO TO 270
      WRITE(6,12600)I,J,A(IM1,J),A(I,JM1),A(IP1,J),A(I,JP1)
12600 FORMAT(' In subroutine cntclc two adjacent A''s are',
     1 ' 0',10X,'I,J,A(I-1,J),A(I,J-1),A(I+1,J),A(I,J+1)'/
     2 2I5,4E20.10)
      A(I,J) = SMALL*.25*( ABS(A(IM1,J)) + ABS(A(I,JM1)) +
     1 ABS(A(IP1,J)) + ABS(A(I,JP1)) )
      IF ( A(I,J) .EQ. 0. ) GO TO 900
  270 CONTINUE
  280 CONTINUE

      IF ( JWRITE(1) .EQ. 0 ) GO TO 289
      JWRIT1 = JWRITE(1)
      NLINES = (NX + 9)/10
      DO 288 J = 1,NY
      JREV = NY + 1 - J
      IEND = 0
      DO 287 NL = 1,NLINES
      ISTRT = IEND + 1
      IEND = IEND + 10
      IF ( NL .EQ. NLINES ) IEND = NX
      IF ( NL .EQ. 1 )
     1 WRITE(JWRIT1,12898)JREV,(A(I,JREV),I=ISTRT,IEND)
12898 FORMAT(I4,10F12.5)
      IF ( NL .NE. 1 )
     1 WRITE(JWRIT1,12899)(A(I,JREV),I=ISTRT,IEND)
12899 FORMAT(4X,10F12.5)
  287 CONTINUE
  288 CONTINUE
  289 CONTINUE


      DO 320 J = 1,NY
      DO 310 I = 1,NX-1
      IF ( A(I,J) .NE. SIGN(A(I,J),A(I+1,J)) )
     1 IABOX(I,J) = IABOX(I,J) + IBIT2
  310 CONTINUE
  320 CONTINUE
      DO 340 J = 1,NY-1
      DO 330 I = 1,NX
      IF ( A(I,J) .NE. SIGN(A(I,J),A(I,J+1)) )
     1 IABOX(I,J) = IABOX(I,J) + IBIT5
  330 CONTINUE
  340 CONTINUE
      DO 360 J = 2,NY
      DO 350 I = 1,NX-1
      IF ((IABOX(I,J) .AND. IBIT2) .NE. 0 )
     1 IABOX(I,J-1) = IABOX(I,J-1) + IBIT4
  350 CONTINUE
  360 CONTINUE
      DO 380 J = 1,NY-1
      DO 370 I = 2,NX
      IF ( (IABOX(I,J) .AND. IBIT5) .NE. 0 )
     1 IABOX(I-1,J) = IABOX(I-1,J) + IBIT3
  370 CONTINUE
  380 CONTINUE

      IF ( JWRITE(1) .EQ. 0 ) GO TO 389
      JWRIT1 = JWRITE(1)
      NLINES = ((NX - 1) + 9)/10
      DO 388 J = 1,NY-1
      JREV = NY - J
      IEND = 0
      DO 387 NL = 1,NLINES
      ISTRT = IEND + 1
      IEND = IEND + 10
      IF ( NL .EQ. NLINES ) IEND = NX - 1
      IF ( NL .EQ. 1 )
     1 WRITE(JWRIT1,13898)JREV,(IABOX(I,JREV),I=ISTRT,IEND)
13898 FORMAT(I4,10I12)
      IF ( NL .NE. 1 )
     1 WRITE(JWRIT1,13899)(IABOX(I,JREV),I=ISTRT,IEND)
13899 FORMAT(4X,10I12)
  387 CONTINUE
  388 CONTINUE
  389 CONTINUE

      GO TO 1000

  900 WRITE(6,19000)IM1,JM1,IP1,JP1
19000 FORMAT(' In subroutine cntclc 5 a''s describing A',
     1 ' plus sign are all 0'/
     2 ' IM1,JM1,IP1,JP1',4I5)
      STOP

 1000 RETURN
      END


      FUNCTION CNTZRO(INTRPL,IXORY,I,J,A,MX,NXY,IDXYVA,DXY)

      COMMON /CNTDBG/ JWRITE
      REAL A(MX,1),DXY(1)
      REAL B(4),XY(4),AZ(2),XYZ(2)
      INTEGER JWRITE(5)

      DATA SMALL / .0001 / , SMALLZ / .00001 /


      IF ( IDXYVA .EQ. 1 ) GO TO 50
      DXY0 = DXY(1)
      GO TO 100
   50 IF ( IXORY .EQ. 1 ) DXY0 = DXY(I)
      IF ( IXORY .EQ. 2 ) DXY0 = DXY(J)
  100 IF ( IXORY .EQ. 1 ) AIJEND = A(I+1,J)
      IF ( IXORY .EQ. 2 ) AIJEND = A(I,J+1)
      ZERO = -DXY0*A(I,J)/(AIJEND - A(I,J))

      IF ( JWRITE(4) .EQ. 0 ) GO TO 109
      JWRIT4 = JWRITE(4)
      WRITE(JWRIT4,11090)ZERO,A(I,J),AIJEND,DXY0
11090 FORMAT(' ZERO,A1,A2,DXY',4E20.6)
  109 CONTINUE


      IF ( INTRPL .EQ. 1 ) GO TO 600

      SMALLA = SMALL*AMIN1( ABS(A(I,J)) , ABS(AIJEND) )

      IF ( IXORY .EQ. 1 ) IJ1 = I - 1
      IF ( IXORY .EQ. 2 ) IJ1 = J - 1
      IF ( IJ1 .LT. 1 ) IJ1 = 1
      IF ( IJ1+3 .GT. NXY ) IJ1 = NXY - 3
      IF ( IXORY .EQ. 2 ) GO TO 250
      DO 220 K = 1,4
      B(K) = A(IJ1+K-1,J)
  220 CONTINUE
      GO TO 300
  250 DO 270 K = 1,4
      B(K) = A(I,IJ1+K-1)
  270 CONTINUE
  300 XY(1) = 0.
      DO 320 K = 2,4
      IF ( IDXYVA .EQ. 0 ) DXYIJ = DXY(1)
      IF ( IDXYVA .EQ. 1 ) DXYIJ = DXY(IJ1+K-2)
      XY(K) = XY(K-1) + DXYIJ
  320 CONTINUE
      IF ( IXORY .EQ. 1 ) DELXY = XY(I-IJ1+1)
      IF ( IXORY .EQ. 2 ) DELXY = XY(J-IJ1+1)
      DO 350 K = 1,4
      XY(K) = XY(K) - DELXY
  350 CONTINUE


      DO 450 L = 1,3
      NRK = 4 - L
      DO 420 K = 1,NRK
      KK = 5 - K
      B(KK) = (B(KK) - B(KK-1))/(XY(KK) - XY(KK-L))
  420 CONTINUE
  450 CONTINUE

      AZ(1) = A(I,J)
      XYZ(1) = 0.
      AZ(2) = AIJEND
      XYZ(2) = DXY0
      LOOPS = 0


  500 APT = B(1) + (ZERO - XY(1))*(B(2) + (ZERO - XY(2))*
     1 (B(3) + (ZERO - XY(3))*B(4)))

      IF ( ABS(APT) .LE. SMALLA ) GO TO 600
      LOOPS = LOOPS + 1
      IF ( LOOPS .GT. 20 ) GO TO 600
      IABOX = 2
      IF ( AZ(1)*APT .GT. 0. ) IABOX = 1
      AZ(IABOX) = APT
      XYZ(IABOX) = ZERO
      ZEROST = ZERO
      ZERO = XYZ(1) - AZ(1)*(XYZ(2) - XYZ(1))/(AZ(2) - AZ(1))

      IF ( JWRITE(4) .EQ. 0 ) GO TO 599
      JWRIT4 = JWRITE(4)
      WRITE(JWRIT4,15990)ZERO,AZ(1),AZ(2)
15990 FORMAT(16X,3E20.6)
  599 CONTINUE

      IF ( ABS(ZERO-ZEROST) .GT. SMALLZ*DXY0 ) GO TO 500

  600 CNTZRO = ZERO
      GO TO 1000

  900 WRITE(6,19000)ZERO,I,J
19000 FORMAT(' Derivative is zero at',f12.6,2i5)
      STOP

  920 WRITE(6,19200)ZERO,I,J
19200 FORMAT(' Zero has shifted left out of the box at',f12.6,2i5)
      STOP

  940 WRITE(6,19400)ZERO
19400 FORMAT(' Zero has shifted right out of the box at',f12.6,2i5)
      STOP

 1000 RETURN
      END
CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC

cccc#endif
