/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.generator.flag.router;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.generator.flag.router.ToConnect;
import com.sun.electric.tool.routing.SeaOfGates;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngine;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesEngineFactory;
import com.sun.electric.tool.routing.seaOfGates.SeaOfGatesHandlers;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class SogRouterAdapter {
    private final Job job;
    private final SeaOfGatesEngine seaOfGates = SeaOfGatesEngineFactory.createSeaOfGatesEngine();
    private final Technology generic = Technology.findTechnology("Generic");
    private final ArcProto unroutedArc = this.generic.findArcProto("Unrouted");

    private Cell findParent(List<ToConnect> toConns) {
        for (ToConnect tc : toConns) {
            Iterator<PortInst> iterator = tc.getPortInsts().iterator();
            if (!iterator.hasNext()) continue;
            PortInst pi = iterator.next();
            return pi.getNodeInst().getParent();
        }
        return null;
    }

    private List<ArcInst> addUnroutedArcs(EditingPreferences ep, Cell cell, List<ToConnect> toConns) {
        Netlist nl = cell.getNetlist();
        ArrayList<ArcInst> unroutedArcs = new ArrayList<ArcInst>();
        for (ToConnect tc : toConns) {
            PortInst firstPi = null;
            Network firstNet = null;
            for (PortInst pi : tc.getPortInsts()) {
                if (firstPi == null) {
                    firstPi = pi;
                    firstNet = nl.getNetwork(firstPi);
                    continue;
                }
                Network net = nl.getNetwork(pi);
                if (firstNet == net) continue;
                ArcInst ai = ArcInst.newInstanceBase(this.unroutedArc, ep, 1.0, firstPi, pi);
                unroutedArcs.add(ai);
            }
        }
        return unroutedArcs;
    }

    public SogRouterAdapter(Job job) {
        this.job = job;
    }

    public void route(List<ToConnect> toConns, EditingPreferences ep, SeaOfGates.SeaOfGatesOptions prefs) {
        Cell cell = this.findParent(toConns);
        if (cell == null) {
            return;
        }
        this.addUnroutedArcs(ep, cell, toConns);
        this.seaOfGates.setPrefs(prefs);
        this.seaOfGates.routeIt(SeaOfGatesHandlers.getDefault(cell, null, prefs.contactPlacementAction, this.job, ep), cell, false);
    }
}

