/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.simulation;

import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.tool.simulation.RangeSample;
import com.sun.electric.tool.simulation.Sample;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.simulation.SignalCollection;
import com.sun.electric.tool.simulation.Stimuli;
import com.sun.electric.tool.user.waveform.Panel;
import com.sun.electric.tool.user.waveform.WaveSignal;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.util.List;

public abstract class DerivedSignal<SNew extends Sample, SOld extends Sample>
extends Signal<SNew> {
    private final Signal<SOld>[] sources;

    public DerivedSignal(SignalCollection sc, Stimuli sd, String signalName, String signalContext, boolean digital, Signal<SOld>[] sources) {
        super(sc, sd, signalName, signalContext, digital);
        this.sources = sources;
    }

    @Override
    public Signal.View<RangeSample<SNew>> getRasterView(double t0, double t1, int numPixels) {
        Signal.View[] views = new Signal.View[this.sources.length];
        for (int i = 0; i < views.length; ++i) {
            views[i] = this.sources[i].getRasterView(t0, t1, numPixels);
        }
        return new DerivedSignalRasterView(views);
    }

    @Override
    public double getMinTime() {
        double min = -1.7976931348623157E308;
        for (int i = 0; i < this.sources.length; ++i) {
            min = Math.max(min, this.sources[i].getMinTime());
        }
        return min;
    }

    @Override
    public double getMaxTime() {
        double max = Double.MAX_VALUE;
        for (int i = 0; i < this.sources.length; ++i) {
            max = Math.min(max, this.sources[i].getMaxTime());
        }
        return max;
    }

    @Override
    public Signal.View<SNew> getExactView() {
        if (this.sources.length == 1) {
            return new DerivedSignalExactView(this.sources[0].getExactView());
        }
        throw new RuntimeException("Exact views of DerivedSignal's with >1 source are not supported");
    }

    protected abstract RangeSample<SNew> getDerivedRange(RangeSample<SOld>[] var1);

    @Override
    public void plot(Panel panel, Graphics g, WaveSignal ws, Color light, List<PolyBase> forPs, Rectangle2D bounds, List<Panel.WaveSelection> selectedObjects, Signal<?> xAxisSignal) {
        throw new RuntimeException("not implemented");
    }

    private class DerivedSignalRasterView
    implements Signal.View<RangeSample<SNew>> {
        private Signal.View<RangeSample<SOld>>[] views;
        private RangeSample<SOld>[] scratch;

        public DerivedSignalRasterView(Signal.View<RangeSample<SOld>>[] views) {
            this.views = views;
            this.scratch = new RangeSample[views.length];
        }

        @Override
        public int getNumEvents() {
            return this.views[0].getNumEvents();
        }

        @Override
        public double getTime(int event) {
            return this.views[0].getTime(event);
        }

        @Override
        public RangeSample<SNew> getSample(int event) {
            for (int i = 0; i < this.scratch.length; ++i) {
                this.scratch[i] = this.views[i].getSample(event);
            }
            RangeSample ret = DerivedSignal.this.getDerivedRange(this.scratch);
            for (int i = 0; i < this.scratch.length; ++i) {
                this.scratch[i] = null;
            }
            return ret;
        }
    }

    private class DerivedSignalExactView
    implements Signal.View<SNew> {
        private Signal.View<SOld> view;

        public DerivedSignalExactView(Signal.View<SOld> view) {
            this.view = view;
        }

        @Override
        public int getNumEvents() {
            return this.view.getNumEvents();
        }

        @Override
        public double getTime(int event) {
            return this.view.getTime(event);
        }

        @Override
        public SNew getSample(int event) {
            Object old = this.view.getSample(event);
            RangeSample derivedRange = DerivedSignal.this.getDerivedRange(new RangeSample[]{new RangeSample(old, old)});
            return derivedRange.getMin();
        }
    }
}

