/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.network.NetworkTool;
import com.sun.electric.database.prototype.PortCharacteristic;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.Name;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.CircuitChangeJobs;
import com.sun.electric.tool.user.Highlight;
import com.sun.electric.tool.user.Highlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.menus.MenuCommands;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.util.TextUtils;
import com.sun.electric.util.math.DBMath;
import com.sun.electric.util.math.GenMath;
import java.awt.Font;
import java.awt.Point;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JOptionPane;

public final class ExportChanges {
    public static void describeExports(boolean summarize) {
        new DescribeExports(summarize);
    }

    private static String addPossibleArcConnections(String infstr, Set<ArcProto> arcsSeen) {
        ArcProto ap;
        Iterator<ArcProto> aIt;
        Technology tech;
        int i = 0;
        Iterator<Technology> it = Technology.getTechnologies();
        while (it.hasNext()) {
            tech = it.next();
            aIt = tech.getArcs();
            while (aIt.hasNext()) {
                ap = aIt.next();
                if (arcsSeen.contains(ap)) continue;
                ++i;
            }
        }
        if (i == 0) {
            infstr = infstr + " EVERYTHING";
        } else {
            i = 0;
            it = Technology.getTechnologies();
            while (it.hasNext()) {
                tech = it.next();
                if (tech == Generic.tech()) continue;
                aIt = tech.getArcs();
                while (aIt.hasNext()) {
                    ap = aIt.next();
                    if (!arcsSeen.contains(ap)) continue;
                    if (i != 0) {
                        infstr = infstr + ",";
                    }
                    ++i;
                    infstr = infstr + " " + ap.getName();
                }
            }
        }
        return infstr;
    }

    public static void reExportAll() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        ArrayList<Geometric> allNodes = new ArrayList<Geometric>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            allNodes.add(it.next());
        }
        new ReExportNodes(cell, allNodes, false, true, false, true, User.isIncrementRightmostIndex());
    }

    public static void reExportSelected(boolean wiredPorts, boolean unwiredPorts) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        List<Geometric> nodeInsts = MenuCommands.getSelectedObjects(true, false);
        if (nodeInsts.size() == 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Please select one or objects to re-export", "Re-export failed", 0);
            return;
        }
        new ReExportNodes(cell, nodeInsts, wiredPorts, unwiredPorts, false, true, User.isIncrementRightmostIndex());
    }

    public static void reExportSelectedPort() {
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Highlighter highlighter = wnd.getHighlighter();
        if (highlighter == null) {
            return;
        }
        Highlight high = highlighter.getOneHighlight();
        if (high == null || !high.isHighlightEOBJ() || !(high.getElectricObject() instanceof PortInst)) {
            System.out.println("Must first select a single node and its port");
            return;
        }
        PortInst pi = (PortInst)high.getElectricObject();
        PortProto pp = pi.getPortProto();
        NodeInst ni = pi.getNodeInst();
        ArrayList<PortInst> queuedExports = new ArrayList<PortInst>();
        Cell cell = ni.getParent();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst oNi = it.next();
            if (oNi.getProto() != ni.getProto()) continue;
            boolean unexported = true;
            Iterator<Export> eIt = oNi.getExports();
            while (eIt.hasNext()) {
                Export e = eIt.next();
                if (e.getOriginalPort().getPortProto() != pp) continue;
                unexported = false;
                break;
            }
            if (!unexported) continue;
            PortInst oPi = oNi.findPortInstFromProto(pp);
            queuedExports.add(oPi);
        }
        new ReExportPorts(cell, queuedExports, true, false, true, false, User.isIncrementRightmostIndex(), null);
    }

    public static void reExportPowerAndGround() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        ArrayList<Geometric> allNodes = new ArrayList<Geometric>();
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            allNodes.add(it.next());
        }
        new ReExportNodes(cell, allNodes, false, true, true, true, User.isIncrementRightmostIndex());
    }

    public static int reExportNodes(Cell cell, List<Geometric> nodeInsts, boolean wiredPorts, boolean unwiredPorts, boolean onlyPowerGround, boolean ignorePrimitives, boolean fromRight) {
        int total = 0;
        for (Geometric geom : nodeInsts) {
            NodeInst ni = (NodeInst)geom;
            if (ignorePrimitives && !ni.isCellInstance() || ni.isIconOfParent()) continue;
            ArrayList<PortInst> portInstsToExport = new ArrayList<PortInst>();
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                boolean found = false;
                Iterator<Export> eIt = ni.getExports();
                while (eIt.hasNext()) {
                    Export pp = eIt.next();
                    if (pp.getOriginalPort() != pi) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                portInstsToExport.add(pi);
            }
            total += ExportChanges.reExportPorts(cell, portInstsToExport, true, wiredPorts, unwiredPorts, onlyPowerGround, fromRight, null);
        }
        return total;
    }

    public static void reExportHighlighted(boolean deep, boolean wiredPorts, boolean unwiredPorts) {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        EditWindow wnd = EditWindow.getCurrent();
        Rectangle2D bounds = wnd.getHighlighter().getHighlightedArea(null);
        if (bounds == null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Must select area before re-exporting the highlighted area", "Re-export failed", 0);
            return;
        }
        ERectangle eBounds = ERectangle.fromLambda(bounds);
        new ReExportHighlighted(cell, eBounds, deep, wiredPorts, unwiredPorts, User.isIncrementRightmostIndex());
    }

    private static void reExportInBounds(Cell cell, Rectangle2D bounds, boolean deep, boolean wiredPorts, boolean unwiredPorts, boolean topLevel, boolean fromRight) {
        ArrayList<PortInst> queuedExports = new ArrayList<PortInst>();
        Iterator<Object> it = cell.getNodes();
        while (it.hasNext()) {
            Rectangle2D cellBounds;
            NodeInst ni = it.next();
            if (!ni.isCellInstance() || !bounds.intersects(cellBounds = ni.getBounds())) continue;
            if (deep) {
                AffineTransform goIn = ni.translateIn(ni.rotateIn());
                Rectangle2D.Double boundsInside = new Rectangle2D.Double(bounds.getMinX(), bounds.getMinY(), bounds.getWidth(), bounds.getHeight());
                DBMath.transformRect(boundsInside, goIn);
                ExportChanges.reExportInBounds((Cell)ni.getProto(), boundsInside, deep, wiredPorts, unwiredPorts, false, fromRight);
            }
            Iterator<PortInst> pIt = ni.getPortInsts();
            while (pIt.hasNext()) {
                PortInst pi = pIt.next();
                Poly portPoly = pi.getPoly();
                if (!bounds.contains(portPoly.getCenterX(), portPoly.getCenterY())) continue;
                queuedExports.add(pi);
            }
        }
        it = cell.getPorts();
        while (it.hasNext()) {
            Export pp = (Export)it.next();
            PortInst pi = pp.getOriginalPort();
            queuedExports.remove(pi);
        }
        if (queuedExports.size() == 0) {
            if (topLevel) {
                System.out.println("No ports in area to export");
            }
            return;
        }
        int num = ExportChanges.reExportPorts(cell, queuedExports, true, wiredPorts, unwiredPorts, false, fromRight, null);
        System.out.println(num + " ports exported.");
    }

    public static int reExportPorts(Cell cell, List<PortInst> portInsts, boolean sort2, boolean wiredPorts, boolean unwiredPorts, boolean onlyPowerGround, boolean fromRight, Map<PortInst, Export> originalExports) {
        PortInst pi;
        int errorCode;
        EDatabase.serverDatabase().checkChanging();
        ArrayList<PortInst> portInstsFiltered = new ArrayList<PortInst>();
        for (PortInst pi2 : portInsts) {
            PortProto pp;
            if (!pi2.hasConnections() ? !unwiredPorts : !wiredPorts) continue;
            if (onlyPowerGround && !(pp = pi2.getPortProto()).isPower() && !pp.isGround()) continue;
            NodeInst ni = pi2.getNodeInst();
            Iterator<Export> exit = ni.getExports();
            while (exit.hasNext()) {
                Export e = exit.next();
                if (e.getOriginalPort() != pi2) continue;
            }
            portInstsFiltered.add(pi2);
        }
        if (sort2) {
            Collections.sort(portInstsFiltered, new PortInstsSortedByBusIndex());
        }
        HashSet<String> already = new HashSet<String>();
        Iterator<PortProto> it = cell.getPorts();
        while (it.hasNext()) {
            Export e = (Export)it.next();
            already.add(e.getNameKey().toString());
        }
        HashMap<String, GenMath.MutableInteger> nextPlainIndex = new HashMap<String, GenMath.MutableInteger>();
        int total = 0;
        Iterator i$ = portInstsFiltered.iterator();
        while (i$.hasNext() && (errorCode = CircuitChangeJobs.cantEdit(cell, (pi = (PortInst)i$.next()).getNodeInst(), true, true, true)) >= 0) {
            int busWidth;
            if (errorCode > 0) continue;
            Name protoName = pi.getPortProto().getNameKey();
            PortCharacteristic pc = pi.getPortProto().getCharacteristic();
            Export refExport = null;
            if (originalExports != null && (refExport = originalExports.get(pi)) != null) {
                protoName = refExport.getNameKey();
                pc = refExport.getCharacteristic();
            }
            if ((busWidth = pi.getNodeInst().getNameKey().busWidth()) > 1) {
                protoName = NetworkTool.isBusAscending() ? Name.findName(protoName.toString() + "[0:" + (busWidth - 1) + "]") : Name.findName(protoName.toString() + "[" + (busWidth - 1) + ":0]");
            }
            String protoNameString = protoName.toString();
            Export newPp = Export.newInstance(cell, pi, protoNameString = ElectricObject.uniqueObjectName(protoNameString, cell, Export.class, already, nextPlainIndex, false, fromRight), pc);
            if (newPp == null) continue;
            if (pi.getPortProto() instanceof Export) {
                newPp.copyTextDescriptorFrom((Export)pi.getPortProto(), Export.EXPORT_NAME);
                newPp.copyVarsFrom((Export)pi.getPortProto());
            }
            if (refExport != null) {
                newPp.copyTextDescriptorFrom(refExport, Export.EXPORT_NAME);
                newPp.copyVarsFrom(refExport);
                newPp.setCharacteristic(refExport.getCharacteristic());
            }
            ++total;
            already.add(newPp.getNameKey().toString());
        }
        return total;
    }

    public static PortInst getNewPortFromReferenceExport(NodeInst newNi, Export referenceExport) {
        PortInst origPi = referenceExport.getOriginalPort();
        PortInst newPi = newNi.findPortInstFromProto(origPi.getPortProto());
        return newPi;
    }

    private static List<Export> getSelectedExports() {
        ArrayList<Export> selectedExports = new ArrayList<Export>();
        EditWindow wnd = EditWindow.getCurrent();
        List<DisplayedText> dts = wnd.getHighlighter().getHighlightedText(true);
        for (DisplayedText dt : dts) {
            if (!(dt.getElectricObject() instanceof Export)) continue;
            Export pp = (Export)dt.getElectricObject();
            selectedExports.add(pp);
        }
        return selectedExports;
    }

    public static void deleteExport() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        List<Export> exportsToDelete = ExportChanges.getSelectedExports();
        if (exportsToDelete.size() == 0) {
            System.out.println("There are no selected exports to delete");
            return;
        }
        ExportChanges.deleteExports(cell, exportsToDelete);
    }

    public static void deleteExportsOnSelected() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        ArrayList<Export> exportsToDelete = new ArrayList<Export>();
        EditWindow wnd = EditWindow.getCurrent();
        List<Geometric> highs = wnd.getHighlighter().getHighlightedEObjs(true, false);
        for (Geometric geom : highs) {
            NodeInst ni = (NodeInst)geom;
            Iterator<Export> eIt = ni.getExports();
            while (eIt.hasNext()) {
                exportsToDelete.add(eIt.next());
            }
        }
        if (exportsToDelete.size() == 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "There are no exports on the highlighted objects", "Re-export failed", 0);
            return;
        }
        ExportChanges.deleteExports(cell, exportsToDelete);
    }

    public static void deleteExportsInArea() {
        Cell cell = WindowFrame.needCurCell();
        if (cell == null) {
            return;
        }
        ArrayList<Export> exportsToDelete = new ArrayList<Export>();
        EditWindow wnd = EditWindow.getCurrent();
        Rectangle2D bounds = wnd.getHighlighter().getHighlightedArea(null);
        if (bounds == null) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "Must select something before deleting the highlighted exports", "Export delete failed", 0);
            return;
        }
        Iterator<NodeInst> it = cell.getNodes();
        while (it.hasNext()) {
            NodeInst ni = it.next();
            Iterator<Export> eIt = ni.getExports();
            while (eIt.hasNext()) {
                Export e = eIt.next();
                PortInst pi = e.getOriginalPort();
                Poly poly = pi.getPoly();
                if (!bounds.contains(poly.getCenterX(), poly.getCenterY())) continue;
                exportsToDelete.add(e);
            }
        }
        if (exportsToDelete.size() == 0) {
            JOptionPane.showMessageDialog(TopLevel.getCurrentJFrame(), "There are no exports in the highlighted area", "Re-export failed", 0);
            return;
        }
        ExportChanges.deleteExports(cell, exportsToDelete);
    }

    public static void deleteExports(Cell cell, List<Export> exportsToDelete) {
        Export e;
        int errorCode;
        if (CircuitChangeJobs.cantEdit(cell, null, true, false, false) != 0) {
            return;
        }
        HashSet<Export> exportsConfirmed = new HashSet<Export>();
        Iterator<Export> i$ = exportsToDelete.iterator();
        while (i$.hasNext() && (errorCode = CircuitChangeJobs.cantEdit(cell, (e = i$.next()).getOriginalPort().getNodeInst(), true, true, false)) >= 0) {
            if (errorCode > 0) continue;
            exportsConfirmed.add(e);
        }
        if (exportsConfirmed.isEmpty()) {
            System.out.println("No exports deleted");
            return;
        }
        new DeleteExports(cell, exportsConfirmed);
    }

    public static void moveExport() {
        Export source = null;
        PortInst dest = null;
        EditWindow wnd = EditWindow.getCurrent();
        for (Highlight h : wnd.getHighlighter().getHighlights()) {
            boolean used = false;
            if (h.isHighlightEOBJ()) {
                if (h.getElectricObject() instanceof PortInst) {
                    if (dest != null) {
                        System.out.println("Must select only one node-port as a destination of the move");
                        return;
                    }
                    dest = (PortInst)h.getElectricObject();
                    used = true;
                }
            } else if (h.isHighlightText() && h.getVarKey() == Export.EXPORT_NAME && h.getElectricObject() instanceof Export) {
                source = (Export)h.getElectricObject();
                used = true;
            }
            if (used) continue;
            System.out.println("Moving exports: select one export to move, and one node-port as its destination");
            return;
        }
        if (source == null || dest == null) {
            System.out.println("First select one export to move, and one node-port as its destination");
            return;
        }
        new MoveExport(source, dest);
    }

    public static void renameExport() {
        EditWindow wnd = EditWindow.getCurrent();
        Highlight h = wnd.getHighlighter().getOneHighlight();
        if (h == null || h.getVarKey() != Export.EXPORT_NAME || !(h.getElectricObject() instanceof Export)) {
            System.out.println("Must select an export name before renaming it");
            return;
        }
        Export pp = (Export)h.getElectricObject();
        String response = JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Rename export", pp.getName());
        if (response == null) {
            return;
        }
        new RenameExport(pp, response);
    }

    public static void showExports() {
        ExportChanges.showPortsAndExports(null);
    }

    public static void showPorts() {
        EditWindow wnd = EditWindow.getCurrent();
        List<Geometric> nodes = wnd.getHighlighter().getHighlightedEObjs(true, false);
        if (nodes == null || nodes.size() == 0) {
            System.out.println("No nodes are highlighted");
            return;
        }
        ExportChanges.showPortsAndExports(nodes);
    }

    private static void showPortsAndExports(List<Geometric> nodes) {
        double shift;
        int i;
        int botSideCount;
        EditWindow wnd = EditWindow.needCurrent();
        if (wnd == null) {
            return;
        }
        Cell cell = wnd.getCell();
        if (cell == null) {
            System.out.println("No cell in this window");
            return;
        }
        int total = cell.getNumPorts();
        if (nodes != null) {
            total = 0;
            for (Geometric geom : nodes) {
                NodeInst ni = (NodeInst)geom;
                total += ni.getNumPortInsts();
            }
        }
        Rectangle2D displayable = wnd.displayableBounds();
        ShownPorts[] portList = new ShownPorts[total];
        total = 0;
        int ignored = 0;
        if (nodes == null) {
            Iterator<PortProto> it = cell.getPorts();
            while (it.hasNext()) {
                Export pp = (Export)it.next();
                Poly poly = pp.getPoly();
                Point2D.Double ptOut = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                if (((Point2D)ptOut).getX() < displayable.getMinX() || ((Point2D)ptOut).getX() > displayable.getMaxX() || ((Point2D)ptOut).getY() < displayable.getMinY() || ((Point2D)ptOut).getY() > displayable.getMaxY()) {
                    ++ignored;
                    continue;
                }
                portList[total] = new ShownPorts();
                portList[total].loc = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                portList[total].pp = pp;
                ++total;
            }
        } else {
            for (Geometric geom : nodes) {
                NodeInst ni = (NodeInst)geom;
                Iterator<PortInst> pIt = ni.getPortInsts();
                while (pIt.hasNext()) {
                    PortInst pi = pIt.next();
                    Poly poly = pi.getPoly();
                    Point2D.Double ptOut = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                    if (((Point2D)ptOut).getX() < displayable.getMinX() || ((Point2D)ptOut).getX() > displayable.getMaxX() || ((Point2D)ptOut).getY() < displayable.getMinY() || ((Point2D)ptOut).getY() > displayable.getMaxY()) {
                        ++ignored;
                        continue;
                    }
                    portList[total] = new ShownPorts();
                    portList[total].loc = new Point2D.Double(poly.getCenterX(), poly.getCenterY());
                    portList[total].pp = pi.getPortProto();
                    ++total;
                }
            }
        }
        int fontSize = EditWindow.getDefaultFontSize();
        Point screenOrigin = wnd.databaseToScreen(0.0, 0.0);
        Point2D thPoint = wnd.screenToDatabase(screenOrigin.x, screenOrigin.y + fontSize);
        double textHeight = Math.abs(thPoint.getY());
        Point2D.Double[] labelLocs = new Point2D.Double[total];
        double digitIndentX = displayable.getWidth() / 20.0;
        double digitIndentY = displayable.getHeight() / 20.0;
        int leftSideCount = botSideCount;
        int topSideCount = botSideCount;
        int numPerSide = (total + 3) / 4;
        int rightSideCount = botSideCount = numPerSide;
        if (leftSideCount + topSideCount + rightSideCount + botSideCount > total) {
            --botSideCount;
        }
        if (leftSideCount + topSideCount + rightSideCount + botSideCount > total) {
            --topSideCount;
        }
        if (leftSideCount + topSideCount + rightSideCount + botSideCount > total) {
            --rightSideCount;
        }
        int fill2 = 0;
        for (i = 0; i < leftSideCount; ++i) {
            labelLocs[fill2++] = new Point2D.Double(displayable.getMinX() + digitIndentX, displayable.getHeight() / (double)(leftSideCount + 1) * (double)(i + 1) + displayable.getMinY());
        }
        for (i = 0; i < topSideCount; ++i) {
            shift = (double)(i % 3) * textHeight - textHeight;
            labelLocs[fill2++] = new Point2D.Double(displayable.getWidth() / (double)(topSideCount + 1) * (double)(i + 1) + displayable.getMinX(), displayable.getMaxY() - digitIndentY - shift);
        }
        for (i = 0; i < rightSideCount; ++i) {
            labelLocs[fill2++] = new Point2D.Double(displayable.getMaxX() - digitIndentX, displayable.getMaxY() - displayable.getHeight() / (double)(rightSideCount + 1) * (double)(i + 1));
        }
        for (i = 0; i < botSideCount; ++i) {
            shift = (double)(i % 3) * textHeight - textHeight;
            labelLocs[fill2++] = new Point2D.Double(displayable.getMaxX() - displayable.getWidth() / (double)(botSideCount + 1) * (double)(i + 1), displayable.getMinY() + digitIndentY - shift);
        }
        double x2 = 0.0;
        double y = 0.0;
        for (int i2 = 0; i2 < total; ++i2) {
            x2 += portList[i2].loc.getX();
            y += portList[i2].loc.getY();
        }
        Point2D.Double center = new Point2D.Double(x2 / (double)total, y / (double)total);
        for (int i3 = 0; i3 < total; ++i3) {
            portList[i3].angle = ((Point2D)center).getX() == portList[i3].loc.getX() && ((Point2D)center).getY() == portList[i3].loc.getY() ? 0 : -DBMath.figureAngle(center, portList[i3].loc);
        }
        ArrayList<ShownPorts> portLabels = new ArrayList<ShownPorts>();
        for (int i4 = 0; i4 < total; ++i4) {
            portLabels.add(portList[i4]);
        }
        Collections.sort(portLabels, new SortPortAngle());
        total = 0;
        for (ShownPorts sp2 : portLabels) {
            portList[total++] = sp2;
        }
        double bestDist = 0.0;
        int bestOff = 0;
        for (int i5 = 0; i5 < total; ++i5) {
            double dist = 0.0;
            for (int j = 0; j < total; ++j) {
                dist += labelLocs[j].distance(portList[(j + i5) % total].loc);
            }
            if (!(dist < bestDist) && i5 != 0) continue;
            bestOff = i5;
            bestDist = dist;
        }
        Highlighter highlighter = wnd.getHighlighter();
        Font font = wnd.getFont(null);
        FontRenderContext frc = new FontRenderContext(null, true, true);
        LineMetrics lm = font.getLineMetrics("hy", frc);
        double baselineVer = wnd.getTextUnitSize(lm.getDescent());
        double baselineHor = wnd.getTextUnitSize(2.0);
        for (int i6 = 0; i6 < total; ++i6) {
            int index = (bestOff + i6) % total;
            Point2D loc = labelLocs[i6];
            String msg = portList[index].pp.getName();
            Point locationLabel = wnd.databaseToScreen(loc.getX(), loc.getY());
            Point locationPort = wnd.databaseToScreen(portList[index].loc.getX(), portList[index].loc.getY());
            GlyphVector v = font.createGlyphVector(frc, msg);
            Rectangle2D glyphBounds = v.getLogicalBounds();
            int otherX = locationLabel.x + (int)glyphBounds.getWidth();
            int otherY = locationLabel.y - (int)glyphBounds.getHeight();
            Point2D locOther = wnd.screenToDatabase(otherX, otherY);
            if (otherX > wnd.getSize().width) {
                int offDist = otherX - wnd.getSize().width;
                locationLabel.x -= offDist;
                otherX -= offDist;
                loc = wnd.screenToDatabase(locationLabel.x, locationLabel.y);
            }
            if (Math.abs(locationPort.x - locationLabel.x) > Math.abs(locationPort.x - otherX)) {
                locationLabel.x = otherX;
            }
            if (Math.abs(locationPort.y - locationLabel.y) > Math.abs(locationPort.y - otherY)) {
                locationLabel.y = otherY;
            }
            Point2D locLineEnd = wnd.screenToDatabase(locationLabel.x, locationLabel.y);
            highlighter.addMessage(cell, msg, new Point2D.Double(loc.getX() + baselineHor, loc.getY() + baselineVer));
            Point2D.Double odd1 = new Point2D.Double(loc.getX(), locOther.getY());
            Point2D.Double odd2 = new Point2D.Double(locOther.getX(), loc.getY());
            highlighter.addLine(loc, odd1, cell);
            highlighter.addLine(odd1, locOther, cell);
            highlighter.addLine(locOther, odd2, cell);
            highlighter.addLine(odd2, loc, cell);
            highlighter.addLine(locLineEnd, portList[index].loc, cell);
        }
        highlighter.finished();
        System.out.println(total + " exported ports to show");
        if (ignored > 0) {
            System.out.println("Could not display " + ignored + " ports (outside of the window)");
        }
    }

    public static void synchronizeLibrary() {
        Library oLib2;
        List<Library> libs = Library.getVisibleLibraries();
        Library curLib = Library.getCurrent();
        int otherLibraries = libs.size() - 1;
        if (otherLibraries < 1) {
            System.out.println("There must be an other library (not the current one) from which to copy exports.");
            return;
        }
        Object[] libNames = new String[otherLibraries];
        int i = 0;
        for (Library oLib2 : libs) {
            if (oLib2 == curLib) continue;
            libNames[i++] = oLib2.getName();
        }
        String chosen = (String)JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Choose another library from which to copy exports", "Choose a Library", 3, null, libNames, libNames[0]);
        if (chosen == null) {
            return;
        }
        oLib2 = Library.findLibrary(chosen);
        if (oLib2 == null) {
            return;
        }
        new SynchronizeExports(oLib2);
    }

    public static void replaceFromOtherLibrary() {
        Library oLib2;
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        List<Library> libs = Library.getVisibleLibraries();
        Library curLib = Library.getCurrent();
        int otherLibraries = libs.size() - 1;
        if (otherLibraries < 1) {
            System.out.println("There must be an other library (not the current one) from which to replace cells.");
            return;
        }
        Object[] libNames = new String[otherLibraries];
        int i = 0;
        for (Library oLib2 : libs) {
            if (oLib2 == curLib) continue;
            libNames[i++] = oLib2.getName();
        }
        String chosen = (String)JOptionPane.showInputDialog(TopLevel.getCurrentJFrame(), "Choose another library from which to replace cell instances", "Choose a Library", 3, null, libNames, libNames[0]);
        if (chosen == null) {
            return;
        }
        oLib2 = Library.findLibrary(chosen);
        if (oLib2 == null) {
            return;
        }
        new ReplaceFromOtherLibrary(curCell, oLib2);
    }

    private static class ReplaceFromOtherLibrary
    extends Job {
        private Cell cell;
        private Library oLib;

        private ReplaceFromOtherLibrary(Cell cell, Library oLib) {
            super("Replace Cell Instances From Another Library", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.oLib = oLib;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            HashMap<NodeInst, Cell> cellsToReplace = new HashMap<NodeInst, Cell>();
            Iterator<NodeInst> it = this.cell.getNodes();
            while (it.hasNext()) {
                Cell newType;
                Cell oldType;
                NodeInst ni = it.next();
                if (!ni.isCellInstance() || ni.getXSize() != 0.0 || ni.getYSize() != 0.0 || (oldType = (Cell)ni.getProto()).getLibrary() == this.oLib) continue;
                String nameToFind = oldType.getName();
                if (oldType.getView() != View.UNKNOWN) {
                    nameToFind = nameToFind + oldType.getView().getAbbreviationExtension();
                }
                if ((newType = this.oLib.findNodeProto(nameToFind)) == null) continue;
                cellsToReplace.put(ni, newType);
            }
            System.out.println("Changing " + cellsToReplace.size() + " cell instances...");
            int replacements = 0;
            for (NodeInst ni : cellsToReplace.keySet()) {
                Cell newType = (Cell)cellsToReplace.get(ni);
                ni.replace(newType, true, true);
                ++replacements;
            }
            System.out.println("Changed " + replacements + " cell instances");
            return true;
        }
    }

    private static class SynchronizeExports
    extends Job {
        private Library oLib;

        private SynchronizeExports(Library oLib) {
            super("Synchronize exports", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.oLib = oLib;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            int newPorts = 0;
            boolean noCells = false;
            Library curLib = Library.getCurrent();
            Iterator<Cell> cIt = curLib.getCells();
            while (cIt.hasNext()) {
                Cell np = cIt.next();
                Iterator<Cell> oCIt = this.oLib.getCells();
                while (oCIt.hasNext()) {
                    Cell oNp = oCIt.next();
                    if (!np.getName().equals(oNp.getName())) continue;
                    Iterator<PortProto> pIt = oNp.getPorts();
                    while (pIt.hasNext()) {
                        PortInst pi;
                        Export oPp = (Export)pIt.next();
                        Export pp = (Export)np.findPortProto(oPp.getName());
                        if (pp != null) continue;
                        NodeInst oNi = oPp.getOriginalPort().getNodeInst();
                        if (oNi.isCellInstance()) {
                            if (!noCells) {
                                System.out.println("Cannot yet make exports that come from other cell instances (i.e. export " + oPp.getName() + " in " + oNp + ")");
                            }
                            noCells = true;
                            continue;
                        }
                        NodeInst ni = NodeInst.makeInstance(oNi.getProto(), (Point2D)oNi.getAnchorCenter(), oNi.getXSize(), oNi.getYSize(), np, oNi.getOrient(), null, oNi.getTechSpecific());
                        if (ni == null || (pp = Export.newInstance(np, pi = ni.findPortInstFromProto(oPp.getOriginalPort().getPortProto()), oPp.getName(), oPp.getCharacteristic())) == null) continue;
                        pp.copyTextDescriptorFrom(oPp, Export.EXPORT_NAME);
                        pp.copyVarsFrom(oPp);
                        ++newPorts;
                    }
                }
            }
            System.out.println("Created " + newPorts + " new exports in current " + curLib);
            return true;
        }
    }

    private static class SortPortAngle
    implements Comparator<ShownPorts> {
        private SortPortAngle() {
        }

        @Override
        public int compare(ShownPorts s1, ShownPorts s2) {
            return s1.angle - s2.angle;
        }
    }

    private static class ShownPorts {
        Point2D loc;
        PortProto pp;
        int angle;

        private ShownPorts() {
        }
    }

    public static class ExportsByNumber
    implements Comparator<Export> {
        @Override
        public int compare(Export e1, Export e2) {
            String s1 = e1.getName();
            String s2 = e2.getName();
            return TextUtils.STRING_NUMBER_ORDER.compare(s1, s2);
        }
    }

    public static class RenumberNumericExports
    extends Job {
        private List<Export> exports;

        public RenumberNumericExports(List<Export> exports) {
            super("Rename Numeric Exports", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.exports = exports;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            Collections.sort(this.exports, new ExportsByNumber());
            String lastPureName = "";
            int lastIndex = 0;
            for (Export e : this.exports) {
                String pureName;
                int numberPos;
                String name = e.getName();
                for (numberPos = name.length(); numberPos > 0 && Character.isDigit(name.charAt(numberPos - 1)); --numberPos) {
                }
                int nameEnd = numberPos;
                if (nameEnd > 0 && name.charAt(nameEnd - 1) == '_') {
                    --nameEnd;
                }
                if (!(pureName = name.substring(0, nameEnd)).equals(lastPureName)) {
                    lastIndex = 0;
                }
                lastPureName = pureName;
                String newName = pureName;
                if (lastIndex > 0) {
                    newName = newName + "_" + lastIndex;
                }
                ++lastIndex;
                if (newName.equals(name)) continue;
                e.rename(newName);
            }
            return true;
        }
    }

    public static class ChangeExportBodyOnly
    extends Job {
        private Export pp;
        private boolean bo;

        public ChangeExportBodyOnly(Export pp, boolean bo) {
            super("Change Export Body-Only " + pp.getName(), User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.pp = pp;
            this.bo = bo;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.pp.setBodyOnly(this.bo);
            return true;
        }
    }

    public static class ChangeExportCharacteristic
    extends Job {
        private Export pp;
        private PortCharacteristic newCh;

        public ChangeExportCharacteristic(Export pp, PortCharacteristic newCh) {
            super("Change Export Characteristics " + pp.getName(), User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.pp = pp;
            this.newCh = newCh;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.pp.setCharacteristic(this.newCh);
            return true;
        }
    }

    public static class RenameExport
    extends Job {
        private Export pp;
        private String newName;

        public RenameExport(Export pp, String newName) {
            super("Rename Export" + pp.getName(), User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.pp = pp;
            this.newName = newName;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.pp.rename(this.newName);
            return true;
        }
    }

    private static class MoveExport
    extends Job {
        private Export source;
        private PortInst dest;

        protected MoveExport(Export source, PortInst dest) {
            super("Move export", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.source = source;
            this.dest = dest;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.source.move(this.dest);
            return true;
        }
    }

    private static class DeleteExports
    extends Job {
        private Cell cell;
        private Set<Export> exportsToDelete;

        public DeleteExports(Cell cell, Set<Export> exportsToDelete) {
            super("Delete exports", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.exportsToDelete = exportsToDelete;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            this.cell.killExports(this.exportsToDelete);
            System.out.println(this.exportsToDelete.size() + " exports deleted");
            return true;
        }
    }

    private static class ReExportHighlighted
    extends Job {
        private Cell cell;
        private ERectangle bounds;
        private boolean deep;
        private boolean wiredPorts;
        private boolean unwiredPorts;
        private boolean fromRight;

        public ReExportHighlighted(Cell cell, ERectangle bounds, boolean deep, boolean wiredPorts, boolean unwiredPorts, boolean fromRight) {
            super("Re-export highlighted", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.bounds = bounds;
            this.deep = deep;
            this.wiredPorts = wiredPorts;
            this.unwiredPorts = unwiredPorts;
            this.fromRight = fromRight;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, true, true) != 0) {
                return false;
            }
            ExportChanges.reExportInBounds(this.cell, this.bounds, this.deep, this.wiredPorts, this.unwiredPorts, true, this.fromRight);
            return true;
        }
    }

    public static class ReExportPorts
    extends Job {
        private Cell cell;
        private List<PortInst> portInsts;
        private boolean sort;
        private boolean wiredPorts;
        private boolean unwiredPorts;
        private boolean onlyPowerGround;
        private boolean fromRight;
        private Map<PortInst, Export> originalExports;

        public ReExportPorts(Cell cell, List<PortInst> portInsts, boolean sort2, boolean wiredPorts, boolean unwiredPorts, boolean onlyPowerGround, boolean fromRight, Map<PortInst, Export> originalExports) {
            super("Re-export ports", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.portInsts = portInsts;
            this.wiredPorts = wiredPorts;
            this.unwiredPorts = unwiredPorts;
            this.onlyPowerGround = onlyPowerGround;
            this.fromRight = fromRight;
            this.sort = sort2;
            this.originalExports = originalExports;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, true, true) != 0) {
                return false;
            }
            int num = ExportChanges.reExportPorts(this.cell, this.portInsts, this.sort, this.wiredPorts, this.unwiredPorts, this.onlyPowerGround, this.fromRight, this.originalExports);
            System.out.println(num + " ports exported.");
            return true;
        }
    }

    private static class ReExportNodes
    extends Job {
        private Cell cell;
        private List<Geometric> nodeInsts;
        private boolean wiredPorts;
        private boolean unwiredPorts;
        private boolean onlyPowerGround;
        private boolean ignorePrimitives;
        private boolean fromRight;

        public ReExportNodes(Cell cell, List<Geometric> nodeInsts, boolean wiredPorts, boolean unwiredPorts, boolean onlyPowerGround, boolean ignorePrimitives, boolean fromRight) {
            super("Re-export nodes", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.cell = cell;
            this.nodeInsts = nodeInsts;
            this.wiredPorts = wiredPorts;
            this.unwiredPorts = unwiredPorts;
            this.onlyPowerGround = onlyPowerGround;
            this.ignorePrimitives = ignorePrimitives;
            this.fromRight = fromRight;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (CircuitChangeJobs.cantEdit(this.cell, null, true, true, true) != 0) {
                return false;
            }
            int num = ExportChanges.reExportNodes(this.cell, this.nodeInsts, this.wiredPorts, this.unwiredPorts, this.onlyPowerGround, this.ignorePrimitives, this.fromRight);
            System.out.println(num + " ports exported.");
            return true;
        }
    }

    public static class FollowExport
    extends Job {
        private Cell cell = WindowFrame.needCurCell();

        public FollowExport() {
            super("Re-export highlighted", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            if (this.cell == null) {
                return;
            }
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            int i;
            List exportsToFollow = ExportChanges.getSelectedExports();
            if (exportsToFollow.size() == 0) {
                System.out.println("There are no selected exports to follow");
                return false;
            }
            HashMap networksSeen = new HashMap();
            HashMap exportsSeen = new HashMap();
            ArrayList<Export> exportsFollowed = new ArrayList<Export>();
            for (Export e : exportsToFollow) {
                exportsFollowed.add(e);
            }
            for (i = 0; i < exportsFollowed.size(); ++i) {
                Export e;
                e = (Export)exportsFollowed.get(i);
                Cell upperCell = e.getParent();
                Iterator<NodeInst> nIt = upperCell.getInstancesOf();
                while (nIt.hasNext()) {
                    Netlist nl;
                    Network net;
                    NodeInst ni = nIt.next();
                    Cell higher = ni.getParent();
                    HashSet<Network> netsSeenInCell = (HashSet<Network>)networksSeen.get(higher);
                    if (netsSeenInCell == null) {
                        netsSeenInCell = new HashSet<Network>();
                        networksSeen.put(higher, netsSeenInCell);
                    }
                    if ((net = (nl = higher.getNetlist()).getNetwork(ni, e, 0)) == null || netsSeenInCell.contains(net)) continue;
                    netsSeenInCell.add(net);
                    Iterator<Export> it = net.getExports();
                    while (it.hasNext()) {
                        Export furtherUp = it.next();
                        HashSet<Export> exportsSeenInCell = (HashSet<Export>)exportsSeen.get(higher);
                        if (exportsSeenInCell == null) {
                            exportsSeenInCell = new HashSet<Export>();
                            exportsSeen.put(higher, exportsSeenInCell);
                        }
                        if (exportsSeenInCell.contains(furtherUp)) continue;
                        exportsSeenInCell.add(furtherUp);
                        exportsFollowed.add(furtherUp);
                    }
                }
                Cell iconCell = upperCell.iconView();
                if (iconCell == null) continue;
                Iterator<NodeInst> nIt2 = iconCell.getInstancesOf();
                while (nIt2.hasNext()) {
                    Netlist nl;
                    Network net;
                    NodeInst ni = nIt2.next();
                    if (ni.isIconOfParent()) continue;
                    Cell higher = ni.getParent();
                    HashSet<Network> netsSeenInCell = (HashSet<Network>)networksSeen.get(higher);
                    if (netsSeenInCell == null) {
                        netsSeenInCell = new HashSet<Network>();
                        networksSeen.put(higher, netsSeenInCell);
                    }
                    if (netsSeenInCell.contains(net = (nl = higher.getNetlist()).getNetwork(ni, e, 0))) continue;
                    netsSeenInCell.add(net);
                    Iterator<Export> it = net.getExports();
                    while (it.hasNext()) {
                        Export furtherUp = it.next();
                        HashSet<Export> exportsSeenInCell = (HashSet<Export>)exportsSeen.get(higher);
                        if (exportsSeenInCell == null) {
                            exportsSeenInCell = new HashSet<Export>();
                            exportsSeen.put(higher, exportsSeenInCell);
                        }
                        if (exportsSeenInCell.contains(furtherUp)) continue;
                        exportsSeenInCell.add(furtherUp);
                        exportsFollowed.add(furtherUp);
                    }
                }
            }
            if (networksSeen.size() == 0) {
                System.out.println("The selected Exports are not used anywhere");
                return true;
            }
            if (exportsToFollow.size() > 1) {
                System.out.print("The Exports ");
                for (i = 0; i < exportsToFollow.size(); ++i) {
                    if (i > 0) {
                        System.out.print(",");
                    }
                    System.out.print(" " + ((Export)exportsToFollow.get(i)).getName());
                }
                System.out.println(" are used:");
            } else {
                System.out.println("The Export " + ((Export)exportsToFollow.get(0)).getName() + " is used:");
            }
            for (Cell c : networksSeen.keySet()) {
                Set netsSeenInCell = (Set)networksSeen.get(c);
                Set exportsSeenInCell = (Set)exportsSeen.get(c);
                System.out.print("   Cell " + c.describe(false));
                if (netsSeenInCell.size() > 1) {
                    System.out.print(" networks");
                } else {
                    System.out.print(" network");
                }
                boolean comma = false;
                for (Network n : netsSeenInCell) {
                    if (comma) {
                        System.out.print(",");
                    }
                    comma = true;
                    System.out.print(" " + n.getName());
                }
                System.out.println();
                if (exportsSeenInCell == null) continue;
                System.out.print("      And further exported as");
                comma = false;
                for (Export e : exportsSeenInCell) {
                    if (comma) {
                        System.out.print(",");
                    }
                    comma = true;
                    System.out.print(" " + e.getName());
                }
                System.out.println();
            }
            return true;
        }
    }

    private static class PortInstsSortedByBusIndex
    implements Comparator<PortInst> {
        private PortInstsSortedByBusIndex() {
        }

        @Override
        public int compare(PortInst p1, PortInst p2) {
            String s1 = p1.getPortProto().getName();
            String s2 = p2.getPortProto().getName();
            return TextUtils.STRING_NUMBER_ORDER.compare(s1, s2);
        }
    }

    public static class ExportSortedByBusIndex
    implements Comparator<Export> {
        @Override
        public int compare(Export e1, Export e2) {
            String s1 = e1.getName();
            String s2 = e2.getName();
            return TextUtils.STRING_NUMBER_ORDER.compare(s1, s2);
        }
    }

    private static class ExportSortedByNameAndType
    implements Comparator<ExportList> {
        private ExportSortedByNameAndType() {
        }

        @Override
        public int compare(ExportList el1, ExportList el2) {
            PortCharacteristic ch2;
            Export e1 = el1.pp;
            Export e2 = el2.pp;
            PortCharacteristic ch1 = e1.getCharacteristic();
            if (ch1 != (ch2 = e2.getCharacteristic())) {
                return ch1.getOrder() - ch2.getOrder();
            }
            String s1 = e1.getName();
            String s2 = e2.getName();
            return TextUtils.STRING_NUMBER_ORDER.compare(s1, s2);
        }
    }

    private static class DescribeExports
    extends Job {
        private Cell cell = WindowFrame.needCurCell();
        private boolean summarize;

        protected DescribeExports(boolean summarize) {
            super("Describe Exports", User.getUserTool(), Job.Type.SERVER_EXAMINE, null, null, Job.Priority.USER);
            this.summarize = summarize;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            if (this.cell == null) {
                return false;
            }
            Netlist netlist = this.cell.getNetlist();
            if (netlist == null) {
                System.out.println("Sorry, a deadlock aborted your query (network information unavailable).  Please try again");
                return false;
            }
            Cell wnp = this.cell.contentsView();
            if (wnp == null) {
                wnp = this.cell.iconView();
            }
            if (wnp == this.cell) {
                wnp = null;
            }
            if (this.cell.getNumPorts() == 0) {
                System.out.println("There are no exports on " + this.cell);
                return true;
            }
            ArrayList<ExportList> exports = new ArrayList<ExportList>();
            Iterator<PortProto> it = this.cell.getPorts();
            while (it.hasNext()) {
                ExportList el = new ExportList();
                el.pp = (Export)it.next();
                el.equiv = -1;
                el.busList = -1;
                exports.add(el);
            }
            Collections.sort(exports, new ExportSortedByNameAndType());
            int num_found = exports.size();
            if (this.summarize) {
                Export ppJ;
                int blJ;
                int eqJ;
                int j;
                block1: for (j = 0; j < num_found; ++j) {
                    eqJ = ((ExportList)exports.get((int)j)).equiv;
                    blJ = ((ExportList)exports.get((int)j)).busList;
                    if (eqJ != -1 || blJ != -1) continue;
                    ppJ = ((ExportList)exports.get((int)j)).pp;
                    for (int k = j + 1; k < num_found; ++k) {
                        int eqK = ((ExportList)exports.get((int)k)).equiv;
                        int blK = ((ExportList)exports.get((int)k)).busList;
                        if (eqK != -1 || blK != -1) continue;
                        Export ppK = ((ExportList)exports.get((int)k)).pp;
                        if (ppJ.getCharacteristic() != ppK.getCharacteristic()) continue block1;
                        if (!netlist.sameNetwork(ppJ.getOriginalPort().getNodeInst(), ppJ.getOriginalPort().getPortProto(), ppK.getOriginalPort().getNodeInst(), ppK.getOriginalPort().getPortProto())) continue;
                        ((ExportList)exports.get((int)k)).equiv = j;
                        ((ExportList)exports.get((int)j)).equiv = -2;
                    }
                }
                block3: for (j = 0; j < num_found; ++j) {
                    String ptJ;
                    int sqPosJ;
                    eqJ = ((ExportList)exports.get((int)j)).equiv;
                    blJ = ((ExportList)exports.get((int)j)).busList;
                    if (eqJ != -1 || blJ != -1 || (sqPosJ = (ptJ = (ppJ = ((ExportList)exports.get((int)j)).pp).getName()).indexOf(91)) < 0) continue;
                    for (int k = j + 1; k < num_found; ++k) {
                        int eqK = ((ExportList)exports.get((int)k)).equiv;
                        int blK = ((ExportList)exports.get((int)k)).busList;
                        if (eqK != -1 || blK != -1) continue;
                        Export ppK = ((ExportList)exports.get((int)k)).pp;
                        if (ppJ.getCharacteristic() != ppK.getCharacteristic()) continue block3;
                        String ptK = ppK.getName();
                        int sqPosK = ptK.indexOf(91);
                        if (sqPosJ != sqPosK || !ptJ.substring(0, sqPosJ).equalsIgnoreCase(ptK.substring(0, sqPosK))) continue;
                        ((ExportList)exports.get((int)k)).busList = j;
                        ((ExportList)exports.get((int)j)).busList = -2;
                    }
                }
            }
            System.out.println("----- Exports on " + this.cell + ": total " + num_found + " -----");
            HashSet<ArcProto> arcsSeen = new HashSet<ArcProto>();
            for (int j = 0; j < num_found; ++j) {
                int m;
                ExportList el = (ExportList)exports.get(j);
                Export pp = el.pp;
                if (el.equiv >= 0 || el.busList >= 0) continue;
                Iterator<Technology> it2 = Technology.getTechnologies();
                while (it2.hasNext()) {
                    Technology tech = it2.next();
                    Iterator<ArcProto> aIt = tech.getArcs();
                    while (aIt.hasNext()) {
                        ArcProto ap = aIt.next();
                        arcsSeen.remove(ap);
                    }
                }
                String infstr = "";
                String activity = pp.getCharacteristic().getFullName();
                for (m = j + 1; m < num_found && ((ExportList)exports.get((int)m)).equiv != j; ++m) {
                }
                double lx = 0.0;
                double hx = 0.0;
                double ly = 0.0;
                double hy = 0.0;
                if (m < num_found) {
                    infstr = infstr + activity + " exports ";
                    for (int k = j; k < num_found; ++k) {
                        if (j != k && ((ExportList)exports.get((int)k)).equiv != j) continue;
                        if (j != k) {
                            infstr = infstr + ", ";
                        }
                        Export opp = ((ExportList)exports.get((int)k)).pp;
                        infstr = infstr + "'" + opp.getName() + "'";
                        Poly poly = opp.getPoly();
                        double x2 = poly.getCenterX();
                        double y = poly.getCenterY();
                        if (j == k) {
                            lx = hx = x2;
                            ly = hy = y;
                        } else {
                            if (x2 < lx) {
                                lx = x2;
                            }
                            if (x2 > hx) {
                                hx = x2;
                            }
                            if (y < ly) {
                                ly = y;
                            }
                            if (y > hy) {
                                hy = y;
                            }
                        }
                        ArcProto[] arcList = opp.getBasePort().getConnections();
                        for (int a = 0; a < arcList.length; ++a) {
                            arcsSeen.add(arcList[a]);
                        }
                    }
                    infstr = infstr + " at (" + lx + "<=X<=" + hx + ", " + ly + "<=Y<=" + hy + "), electrically connected to";
                    infstr = ExportChanges.addPossibleArcConnections(infstr, arcsSeen);
                } else {
                    for (m = j + 1; m < num_found && ((ExportList)exports.get((int)m)).busList != j; ++m) {
                    }
                    if (m < num_found) {
                        int tot = 0;
                        for (int k = j; k < num_found; ++k) {
                            if (j != k && ((ExportList)exports.get((int)k)).busList != j) continue;
                            ++tot;
                            Export opp = ((ExportList)exports.get((int)k)).pp;
                            Poly poly = opp.getPoly();
                            double x3 = poly.getCenterX();
                            double y = poly.getCenterY();
                            if (j == k) {
                                lx = hx = x3;
                                ly = hy = y;
                            } else {
                                if (x3 < lx) {
                                    lx = x3;
                                }
                                if (x3 > hx) {
                                    hx = x3;
                                }
                                if (y < ly) {
                                    ly = y;
                                }
                                if (y > hy) {
                                    hy = y;
                                }
                            }
                            ArcProto[] arcList = opp.getBasePort().getConnections();
                            for (int a = 0; a < arcList.length; ++a) {
                                arcsSeen.add(arcList[a]);
                            }
                        }
                        ArrayList<Export> sortedBusList = new ArrayList<Export>();
                        sortedBusList.add(((ExportList)exports.get((int)j)).pp);
                        for (int k = j + 1; k < num_found; ++k) {
                            ExportList elK = (ExportList)exports.get(k);
                            if (elK.busList != j) continue;
                            sortedBusList.add(elK.pp);
                        }
                        Collections.sort(sortedBusList, new ExportSortedByBusIndex());
                        boolean first = true;
                        for (Export ppS : sortedBusList) {
                            String pt1 = ppS.getName();
                            int openPos = pt1.indexOf(91);
                            if (first) {
                                infstr = infstr + activity + " ports '" + pt1.substring(0, openPos) + "[";
                                first = false;
                            } else {
                                infstr = infstr + ",";
                            }
                            int closePos = pt1.lastIndexOf(93);
                            infstr = infstr + pt1.substring(openPos + 1, closePos);
                        }
                        infstr = infstr + "]' at (" + lx + "<=X<=" + hx + ", " + ly + "<=Y<=" + hy + "), same bus, connects to";
                        infstr = ExportChanges.addPossibleArcConnections(infstr, arcsSeen);
                    } else {
                        Poly poly = pp.getPoly();
                        double x4 = poly.getCenterX();
                        double y = poly.getCenterY();
                        infstr = infstr + activity + " export '" + pp.getName() + "' at (" + x4 + ", " + y + ") connects to";
                        ArcProto[] arcList = pp.getBasePort().getConnections();
                        for (int a = 0; a < arcList.length; ++a) {
                            arcsSeen.add(arcList[a]);
                        }
                        infstr = ExportChanges.addPossibleArcConnections(infstr, arcsSeen);
                        if (wnp != null && pp.findEquivalent(wnp) == null) {
                            infstr = infstr + " *** no equivalent in " + wnp;
                        }
                    }
                }
                TextUtils.printLongString(infstr);
            }
            if (wnp != null) {
                Iterator<PortProto> it3 = wnp.getPorts();
                while (it3.hasNext()) {
                    Export pp = (Export)it3.next();
                    if (pp.findEquivalent(this.cell) != null) continue;
                    System.out.println("*** Export " + pp.getName() + ", found in " + wnp + ", is missing here");
                }
            }
            return true;
        }
    }

    private static class ExportList {
        Export pp;
        int equiv;
        int busList;

        private ExportList() {
        }
    }
}

