/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.geometry;

import com.sun.electric.database.text.Pref;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Schematics;
import com.sun.electric.tool.user.Resources;
import java.awt.Color;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;

public class EGraphics
extends Observable
implements Cloneable,
Serializable {
    private static Map<String, Outline> outlineNames = new HashMap<String, Outline>();
    private Layer layer = null;
    private boolean displayPatterned;
    private boolean printPatterned;
    private Outline patternOutline;
    private int transparentLayer;
    private int red;
    private int green;
    private int blue;
    private double opacity;
    private boolean foreground;
    private int[] pattern;
    private int[] reversedPattern;
    private Object appearance3D;
    private static Map<Layer, Pref> usePatternDisplayMap = new HashMap<Layer, Pref>();
    private static Map<Layer, Pref> usePatternPrinterMap = new HashMap<Layer, Pref>();
    private static Map<Layer, Pref> outlinePatternMap = new HashMap<Layer, Pref>();
    private static Map<Layer, Pref> transparentLayerMap = new HashMap<Layer, Pref>();
    private static Map<Layer, Pref> opacityMap = new HashMap<Layer, Pref>();
    private static Map<Layer, Pref> colorMap = new HashMap<Layer, Pref>();
    private static Map<Layer, Pref> patternMap = new HashMap<Layer, Pref>();
    public static final int FULLRGBBIT = 1;
    public static final int OPAQUEBIT = 2;
    public static final int WHITE = 2;
    public static final int BLACK = 6;
    public static final int RED = 10;
    public static final int BLUE = 14;
    public static final int GREEN = 18;
    public static final int CYAN = 22;
    public static final int MAGENTA = 26;
    public static final int YELLOW = 30;
    public static final int CELLTXT = 34;
    public static final int CELLOUT = 38;
    public static final int WINBOR = 42;
    public static final int HWINBOR = 46;
    public static final int MENBOR = 50;
    public static final int HMENBOR = 54;
    public static final int MENTXT = 58;
    public static final int MENGLY = 62;
    public static final int CURSOR = 66;
    public static final int GRAY = 70;
    public static final int ORANGE = 74;
    public static final int PURPLE = 78;
    public static final int BROWN = 82;
    public static final int LGRAY = 86;
    public static final int DGRAY = 90;
    public static final int LRED = 94;
    public static final int DRED = 98;
    public static final int LGREEN = 102;
    public static final int DGREEN = 106;
    public static final int LBLUE = 110;
    public static final int DBLUE = 114;
    public static final int LAYERT1 = 4;
    public static final int LAYERT2 = 8;
    public static final int LAYERT3 = 16;
    public static final int LAYERT4 = 32;
    public static final int LAYERT5 = 64;
    public static final int LAYERT6 = 128;
    public static final int LAYERT7 = 256;
    public static final int LAYERT8 = 512;
    public static final int LAYERT9 = 1024;
    public static final int LAYERT10 = 2048;
    public static final int LAYERT11 = 4096;
    public static final int LAYERT12 = 8192;
    public static final int TRANSPARENT_1 = 1;
    public static final int TRANSPARENT_2 = 2;
    public static final int TRANSPARENT_3 = 3;
    public static final int TRANSPARENT_4 = 4;
    public static final int TRANSPARENT_5 = 5;
    public static final int TRANSPARENT_6 = 6;
    public static final int TRANSPARENT_7 = 7;
    public static final int TRANSPARENT_8 = 8;
    public static final int TRANSPARENT_9 = 9;
    public static final int TRANSPARENT_10 = 10;
    public static final int TRANSPARENT_11 = 11;
    public static final int TRANSPARENT_12 = 12;

    public EGraphics(boolean displayPatterned, boolean printPatterned, Outline outlineWhenPatterned, int transparentLayer, int red, int green, int blue, double opacity, boolean foreground, int[] pattern) {
        this.displayPatterned = displayPatterned;
        this.printPatterned = printPatterned;
        this.patternOutline = outlineWhenPatterned != null ? outlineWhenPatterned : Outline.NOPAT;
        this.transparentLayer = transparentLayer;
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.opacity = opacity;
        this.foreground = foreground;
        this.setPatternLow(pattern);
        if (transparentLayer < 0 || transparentLayer > 12) {
            System.out.println("Graphics transparent color bad: " + transparentLayer);
        }
        if (red < 0 || red > 255 || green < 0 || green > 255 || blue < 0 || blue > 255) {
            System.out.println("Graphics color bad: (" + red + "," + green + "," + blue + ")");
        }
    }

    public EGraphics(EGraphics g) {
        this.displayPatterned = g.isPatternedOnDisplay();
        this.printPatterned = g.isPatternedOnPrinter();
        this.patternOutline = g.getOutlined();
        this.transparentLayer = g.getTransparentLayer();
        Color gColor = g.getColor();
        this.red = gColor.getRed();
        this.green = gColor.getGreen();
        this.blue = gColor.getBlue();
        this.opacity = g.getOpacity();
        this.foreground = g.getForeground();
        this.setPatternLow((int[])g.getPattern().clone());
        if (this.transparentLayer < 0 || this.transparentLayer > 12) {
            System.out.println("Graphics transparent color bad: " + this.transparentLayer);
        }
        if (this.red < 0 || this.red > 255 || this.green < 0 || this.green > 255 || this.blue < 0 || this.blue > 255) {
            System.out.println("Graphics color bad: (" + this.red + "," + this.green + "," + this.blue + ")");
        }
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
        Technology tech = layer.getTechnology();
        if (tech == null || layer.getIndex() < 0) {
            return;
        }
        String layerTechMsg = layer.getName() + "In" + tech.getTechName();
        Pref usePatternDisplayPref = Pref.makeBooleanPref("UsePatternDisplayFor" + layerTechMsg, Technology.getTechnologyPreferences(), this.displayPatterned);
        this.displayPatterned = usePatternDisplayPref.getBoolean();
        usePatternDisplayMap.put(layer, usePatternDisplayPref);
        Pref usePatternPrinterPref = Pref.makeBooleanPref("UsePatternPrinterFor" + layerTechMsg, Technology.getTechnologyPreferences(), this.printPatterned);
        this.printPatterned = usePatternPrinterPref.getBoolean();
        usePatternPrinterMap.put(layer, usePatternPrinterPref);
        Pref oldOutlinePatternDisplayPref = Pref.makeBooleanPref("OutlinePatternDisplayFor" + layerTechMsg, Technology.getTechnologyPreferences(), false);
        if (oldOutlinePatternDisplayPref.getBoolean()) {
            this.patternOutline = Outline.PAT_S;
        }
        Pref outlinePatternPref = Pref.makeIntPref("OutlinePatternFor" + layerTechMsg, Technology.getTechnologyPreferences(), this.patternOutline.getIndex());
        this.patternOutline = Outline.findOutline(outlinePatternPref.getInt());
        outlinePatternMap.put(layer, outlinePatternPref);
        Pref transparentLayerPref = Pref.makeIntPref("TransparentLayerFor" + layerTechMsg, Technology.getTechnologyPreferences(), this.transparentLayer);
        this.transparentLayer = transparentLayerPref.getInt();
        transparentLayerMap.put(layer, transparentLayerPref);
        Pref opacityPref = Pref.makeDoublePref("OpacityFor" + layerTechMsg, Technology.getTechnologyPreferences(), this.opacity);
        this.opacity = opacityPref.getDouble();
        opacityMap.put(layer, opacityPref);
        Pref colorPref = Pref.makeIntPref("ColorFor" + layerTechMsg, Technology.getTechnologyPreferences(), this.red << 16 | this.green << 8 | this.blue);
        int color = colorPref.getInt();
        this.red = color >> 16 & 0xFF;
        this.green = color >> 8 & 0xFF;
        this.blue = color & 0xFF;
        colorMap.put(layer, colorPref);
        String pat = this.makePatString(this.pattern);
        Pref patternPref = Pref.makeStringPref("PatternFor" + layerTechMsg, Technology.getTechnologyPreferences(), pat);
        pat = patternPref.getString();
        this.parsePatString(pat, this.pattern);
        this.setPatternLow(this.pattern);
        patternMap.put(layer, patternPref);
    }

    public void recachePrefs() {
        Technology tech = this.layer.getTechnology();
        if (tech == null) {
            return;
        }
        Pref usePatternDisplayPref = usePatternDisplayMap.get(this.layer);
        this.displayPatterned = usePatternDisplayPref.getBoolean();
        Pref usePatternPrinterPref = usePatternPrinterMap.get(this.layer);
        this.printPatterned = usePatternPrinterPref.getBoolean();
        Pref outlinePatternPref = outlinePatternMap.get(this.layer);
        this.patternOutline = Outline.findOutline(outlinePatternPref.getInt());
        Pref transparentLayerPref = transparentLayerMap.get(this.layer);
        this.transparentLayer = transparentLayerPref.getInt();
        Pref opacityPref = opacityMap.get(this.layer);
        this.opacity = opacityPref.getDouble();
        Pref colorPref = colorMap.get(this.layer);
        int color = colorPref.getInt();
        this.red = color >> 16 & 0xFF;
        this.green = color >> 8 & 0xFF;
        this.blue = color & 0xFF;
        Pref patternPref = patternMap.get(this.layer);
        String pat = patternPref.getString();
        this.parsePatString(pat, this.pattern);
        this.setPatternLow(this.pattern);
    }

    private String makePatString(int[] pattern) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < 16; ++i) {
            if (i > 0) {
                sb.append("/");
            }
            sb.append(Integer.toString(pattern[i]));
        }
        return sb.toString();
    }

    private void parsePatString(String patString, int[] pattern) {
        int pos = 0;
        for (int i = 0; i < 16; ++i) {
            pattern[i] = TextUtils.atoi(patString.substring(pos)) & 0xFFFF;
            pos = patString.indexOf(47, pos) + 1;
        }
    }

    public boolean isPatternedOnDisplay() {
        return this.displayPatterned;
    }

    public boolean isFactoryPatternedOnDisplay() {
        if (this.layer != null) {
            Pref pref = usePatternDisplayMap.get(this.layer);
            return pref.getBooleanFactoryValue();
        }
        return false;
    }

    public void setPatternedOnDisplay(boolean p) {
        Pref pref;
        this.displayPatterned = p;
        if (this.layer != null && (pref = usePatternDisplayMap.get(this.layer)) != null) {
            pref.setBoolean(p);
        }
    }

    public boolean isPatternedOnPrinter() {
        return this.printPatterned;
    }

    public boolean isFactoryPatternedOnPrinter() {
        if (this.layer != null) {
            Pref pref = usePatternPrinterMap.get(this.layer);
            return pref.getBooleanFactoryValue();
        }
        return false;
    }

    public void setPatternedOnPrinter(boolean p) {
        Pref pref;
        this.printPatterned = p;
        if (this.layer != null && (pref = usePatternPrinterMap.get(this.layer)) != null) {
            pref.setBoolean(p);
        }
    }

    public Outline getOutlined() {
        return this.patternOutline;
    }

    public Outline getFactoryOutlined() {
        if (this.layer == null) {
            return null;
        }
        Pref pref = outlinePatternMap.get(this.layer);
        return Outline.findOutline(pref.getIntFactoryValue());
    }

    public void setOutlined(Outline o) {
        Pref pref;
        if (o == null) {
            o = Outline.NOPAT;
        }
        this.patternOutline = o;
        if (this.layer != null && (pref = outlinePatternMap.get(this.layer)) != null) {
            pref.setInt(o.getIndex());
        }
        this.setPatternLow(this.pattern);
    }

    public int getTransparentLayer() {
        return this.transparentLayer;
    }

    public int getFactoryTransparentLayer() {
        if (this.layer == null) {
            return 0;
        }
        Pref pref = transparentLayerMap.get(this.layer);
        return pref.getIntFactoryValue();
    }

    public void setTransparentLayer(int transparentLayer) {
        Pref pref;
        if (transparentLayer < 0 || transparentLayer > 12) {
            System.out.println("Graphics transparent color bad: " + transparentLayer);
        }
        this.transparentLayer = transparentLayer;
        if (this.layer != null && (pref = transparentLayerMap.get(this.layer)) != null) {
            pref.setInt(transparentLayer);
        }
    }

    public int[] getPattern() {
        return this.pattern;
    }

    public int[] getReversedPattern() {
        return this.reversedPattern;
    }

    public int[] getFactoryPattern() {
        if (this.layer == null) {
            return null;
        }
        Pref pref = patternMap.get(this.layer);
        int[] retPat = new int[16];
        this.parsePatString(pref.getStringFactoryValue(), retPat);
        return retPat;
    }

    public void setPattern(int[] pattern) {
        Pref pref;
        this.setPatternLow(pattern);
        if (this.layer != null && (pref = patternMap.get(this.layer)) != null) {
            pref.setString(this.makePatString(pattern));
        }
    }

    private void setPatternLow(int[] pattern) {
        if (pattern.length != 16) {
            System.out.println("Graphics bad: has " + pattern.length + " pattern entries instead of 16");
        }
        this.pattern = pattern;
        this.reversedPattern = new int[16];
        boolean emptyPattern = true;
        for (int i = 0; i < this.reversedPattern.length; ++i) {
            int shortPattern = pattern[i];
            if (shortPattern != 0) {
                emptyPattern = false;
            }
            if (shortPattern >>> 16 != 0) {
                System.out.println("Graphics bad: has " + Integer.toHexString(shortPattern) + " pattern line");
            }
            for (int j = 0; j < 16; ++j) {
                if ((shortPattern & 1 << 15 - j) == 0) continue;
                int n = i;
                this.reversedPattern[n] = this.reversedPattern[n] | 65537 << j;
            }
        }
        if (emptyPattern && this.patternOutline == Outline.NOPAT && (this.displayPatterned || this.printPatterned)) {
            String msg = "Warning: layer ";
            if (this.layer != null) {
                msg = msg + this.layer.getName();
                if (this.layer.getTechnology() != null) {
                    msg = msg + " in technology " + this.layer.getTechnology().getTechName();
                }
            }
            msg = msg + " has an empty pattern.  Outlining it.";
            System.out.println(msg);
            this.patternOutline = Outline.PAT_S;
        }
    }

    public double getOpacity() {
        return this.opacity;
    }

    public double getFactoryOpacity() {
        if (this.layer == null) {
            return 0.0;
        }
        Pref pref = opacityMap.get(this.layer);
        return pref.getDoubleFactoryValue();
    }

    public void setOpacity(double opacity) {
        Pref pref;
        this.opacity = opacity;
        if (this.layer != null && (pref = opacityMap.get(this.layer)) != null) {
            pref.setDouble(opacity);
        }
    }

    public boolean getForeground() {
        return this.foreground;
    }

    public void setForeground(boolean f) {
        this.foreground = f;
    }

    public Color getColor() {
        int alpha = (int)(this.opacity * 255.0);
        Color color = new Color(this.red, this.green, this.blue, alpha);
        return color;
    }

    public Color getOpaqueColor() {
        Color color = new Color(this.red, this.green, this.blue, 255);
        return color;
    }

    public int getFactoryColor() {
        if (this.layer == null) {
            return 0;
        }
        Pref pref = colorMap.get(this.layer);
        return pref.getIntFactoryValue();
    }

    public int getRGB() {
        return this.red << 16 | this.green << 8 | this.blue;
    }

    public void setColor(Color color) {
        Object obj3D;
        Pref pref;
        this.transparentLayer = 0;
        this.red = color.getRed();
        this.green = color.getGreen();
        this.blue = color.getBlue();
        if (this.layer != null && (pref = colorMap.get(this.layer)) != null) {
            pref.setInt(this.red << 16 | this.green << 8 | this.blue);
        }
        if ((obj3D = this.get3DAppearance()) != null) {
            Class app3DClass = Resources.get3DClass("utils.J3DAppearance");
            try {
                Method setColorMethod3DClass = app3DClass.getDeclaredMethod("set3DColor", Object.class, Color.class);
                setColorMethod3DClass.invoke(obj3D, null, color);
            }
            catch (Exception e) {
                System.out.println("Cannot call 3D plugin method set3DColor: " + e.getMessage());
            }
        }
    }

    public static Color getColorFromIndex(int colorIndex) {
        int trueIndex;
        if ((colorIndex & 2) != 0) {
            switch (colorIndex) {
                case 2: {
                    return new Color(255, 255, 255);
                }
                case 6: {
                    return new Color(0, 0, 0);
                }
                case 10: {
                    return new Color(255, 0, 0);
                }
                case 14: {
                    return new Color(0, 0, 255);
                }
                case 18: {
                    return new Color(0, 255, 0);
                }
                case 22: {
                    return new Color(0, 255, 255);
                }
                case 26: {
                    return new Color(255, 0, 255);
                }
                case 30: {
                    return new Color(255, 255, 0);
                }
                case 34: {
                    return new Color(0, 0, 0);
                }
                case 38: {
                    return new Color(0, 0, 0);
                }
                case 42: {
                    return new Color(0, 0, 0);
                }
                case 46: {
                    return new Color(0, 255, 0);
                }
                case 50: {
                    return new Color(0, 0, 0);
                }
                case 54: {
                    return new Color(255, 255, 255);
                }
                case 58: {
                    return new Color(0, 0, 0);
                }
                case 62: {
                    return new Color(0, 0, 0);
                }
                case 66: {
                    return new Color(0, 0, 0);
                }
                case 70: {
                    return new Color(180, 180, 180);
                }
                case 74: {
                    return new Color(255, 190, 6);
                }
                case 78: {
                    return new Color(186, 0, 255);
                }
                case 82: {
                    return new Color(139, 99, 46);
                }
                case 86: {
                    return new Color(230, 230, 230);
                }
                case 90: {
                    return new Color(100, 100, 100);
                }
                case 94: {
                    return new Color(255, 150, 150);
                }
                case 98: {
                    return new Color(159, 80, 80);
                }
                case 102: {
                    return new Color(175, 255, 175);
                }
                case 106: {
                    return new Color(89, 159, 85);
                }
                case 110: {
                    return new Color(150, 150, 255);
                }
                case 114: {
                    return new Color(2, 15, 159);
                }
            }
            return null;
        }
        if ((colorIndex & 1) != 0) {
            return new Color(colorIndex >> 24 & 0xFF, colorIndex >> 16 & 0xFF, colorIndex >> 8 & 0xFF);
        }
        Technology curTech = Technology.getCurrent();
        Color[] colorMap = curTech.getColorMap();
        if (colorMap == null) {
            Technology altTech = Schematics.getDefaultSchematicTechnology();
            if (altTech != curTech) {
                colorMap = altTech.getColorMap();
            }
            if (colorMap == null) {
                return null;
            }
        }
        if ((trueIndex = colorIndex >> 2) < colorMap.length) {
            return colorMap[trueIndex];
        }
        return null;
    }

    public void setColorIndex(int colorIndex) {
        if ((colorIndex & 3) != 0) {
            this.transparentLayer = 0;
            this.setColor(EGraphics.getColorFromIndex(colorIndex));
            return;
        }
        if ((colorIndex & 4) != 0) {
            this.transparentLayer = 1;
        } else if ((colorIndex & 8) != 0) {
            this.transparentLayer = 2;
        } else if ((colorIndex & 0x10) != 0) {
            this.transparentLayer = 3;
        } else if ((colorIndex & 0x20) != 0) {
            this.transparentLayer = 4;
        } else if ((colorIndex & 0x40) != 0) {
            this.transparentLayer = 5;
        } else if ((colorIndex & 0x80) != 0) {
            this.transparentLayer = 6;
        } else if ((colorIndex & 0x100) != 0) {
            this.transparentLayer = 7;
        } else if ((colorIndex & 0x200) != 0) {
            this.transparentLayer = 8;
        } else if ((colorIndex & 0x400) != 0) {
            this.transparentLayer = 9;
        } else if ((colorIndex & 0x800) != 0) {
            this.transparentLayer = 10;
        } else if ((colorIndex & 0x1000) != 0) {
            this.transparentLayer = 11;
        } else if ((colorIndex & 0x2000) != 0) {
            this.transparentLayer = 12;
        }
    }

    public static int makeIndex(Color color) {
        int red = color.getRed();
        int green = color.getGreen();
        int blue = color.getBlue();
        int index = red << 24 | green << 16 | blue << 8 | 1;
        return index;
    }

    public static int makeIndex(int transparentLayer) {
        switch (transparentLayer) {
            case 1: {
                return 4;
            }
            case 2: {
                return 8;
            }
            case 3: {
                return 16;
            }
            case 4: {
                return 32;
            }
            case 5: {
                return 64;
            }
            case 6: {
                return 128;
            }
            case 7: {
                return 256;
            }
            case 8: {
                return 512;
            }
            case 9: {
                return 1024;
            }
            case 10: {
                return 2048;
            }
            case 11: {
                return 4096;
            }
            case 12: {
                return 8192;
            }
        }
        return 0;
    }

    public static int findColorIndex(String name) {
        if (name.equals("white")) {
            return 2;
        }
        if (name.equals("black")) {
            return 6;
        }
        if (name.equals("red")) {
            return 10;
        }
        if (name.equals("blue")) {
            return 14;
        }
        if (name.equals("green")) {
            return 18;
        }
        if (name.equals("cyan")) {
            return 22;
        }
        if (name.equals("magenta")) {
            return 26;
        }
        if (name.equals("yellow")) {
            return 30;
        }
        if (name.equals("gray")) {
            return 70;
        }
        if (name.equals("orange")) {
            return 74;
        }
        if (name.equals("purple")) {
            return 78;
        }
        if (name.equals("brown")) {
            return 82;
        }
        if (name.equals("light-gray")) {
            return 86;
        }
        if (name.equals("dark-gray")) {
            return 90;
        }
        if (name.equals("light-red")) {
            return 94;
        }
        if (name.equals("dark-red")) {
            return 98;
        }
        if (name.equals("light-green")) {
            return 102;
        }
        if (name.equals("dark-green")) {
            return 106;
        }
        if (name.equals("light-blue")) {
            return 110;
        }
        if (name.equals("dark-blue")) {
            return 114;
        }
        if (name.equals("transparent-1")) {
            return 4;
        }
        if (name.equals("transparent-2")) {
            return 8;
        }
        if (name.equals("transparent-3")) {
            return 16;
        }
        if (name.equals("transparent-4")) {
            return 32;
        }
        if (name.equals("transparent-5")) {
            return 64;
        }
        if (name.equals("transparent-6")) {
            return 128;
        }
        if (name.equals("transparent-7")) {
            return 256;
        }
        if (name.equals("transparent-8")) {
            return 512;
        }
        if (name.equals("transparent-9")) {
            return 1024;
        }
        if (name.equals("transparent-10")) {
            return 2048;
        }
        if (name.equals("transparent-11")) {
            return 4096;
        }
        if (name.equals("transparent-12")) {
            return 8192;
        }
        return 0;
    }

    public static String getColorIndexName(int colorIndex) {
        if ((colorIndex & 1) != 0) {
            int red = colorIndex >> 24 & 0xFF;
            int green = colorIndex >> 16 & 0xFF;
            int blue = colorIndex >> 8 & 0xFF;
            return "Color (" + red + "," + green + "," + blue + ")";
        }
        switch (colorIndex) {
            case 2: {
                return "white";
            }
            case 6: {
                return "black";
            }
            case 10: {
                return "red";
            }
            case 14: {
                return "blue";
            }
            case 18: {
                return "green";
            }
            case 22: {
                return "cyan";
            }
            case 26: {
                return "magenta";
            }
            case 30: {
                return "yellow";
            }
            case 70: {
                return "gray";
            }
            case 74: {
                return "orange";
            }
            case 78: {
                return "purple";
            }
            case 82: {
                return "brown";
            }
            case 86: {
                return "light-gray";
            }
            case 90: {
                return "dark-gray";
            }
            case 94: {
                return "light-red";
            }
            case 98: {
                return "dark-red";
            }
            case 102: {
                return "light-green";
            }
            case 106: {
                return "dark-green";
            }
            case 110: {
                return "light-blue";
            }
            case 114: {
                return "dark-blue";
            }
            case 4: {
                return "transparent-1";
            }
            case 8: {
                return "transparent-2";
            }
            case 16: {
                return "transparent-3";
            }
            case 32: {
                return "transparent-4";
            }
            case 64: {
                return "transparent-5";
            }
            case 128: {
                return "transparent-6";
            }
            case 256: {
                return "transparent-7";
            }
            case 512: {
                return "transparent-8";
            }
            case 1024: {
                return "transparent-9";
            }
            case 2048: {
                return "transparent-10";
            }
            case 4096: {
                return "transparent-11";
            }
            case 8192: {
                return "transparent-12";
            }
        }
        return "ColorIndex " + colorIndex;
    }

    public static int[] getColorIndices() {
        return new int[]{2, 6, 10, 14, 18, 22, 26, 30, 70, 74, 78, 82, 86, 90, 94, 98, 102, 106, 110, 114, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192};
    }

    public static int[] getTransparentColorIndices() {
        return new int[]{4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192};
    }

    public void set3DAppearance(Object obj) {
        this.appearance3D = obj;
    }

    public Object get3DAppearance() {
        return this.appearance3D;
    }

    public void notifyVisibility(Boolean layerVis) {
        this.setChanged();
        this.notifyObservers(layerVis);
        this.clearChanged();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Outline {
        NOPAT("None", 0, 32, 1),
        PAT_S("Solid", -1, 32, 1),
        PAT_T1("Solid-Thick", -1, 32, 3),
        PAT_T2("Solid-Thicker", -1, 32, 5),
        PAT_DO1("Dotted-Close", 85, 8, 1),
        PAT_DO2("Dotted-Far", 17, 8, 1),
        PAT_DA1("Dashed-Short", 51, 8, 1),
        PAT_DA2("Dashed-Long", 15, 6, 1),
        PAT_DD1("Dotted-Dashed-Short", 57, 8, 1),
        PAT_DD2("Dotted-Dashed-Long", 243, 10, 1),
        PAT_DO1_T1("Dotted-Close-Thick", 15, 6, 3),
        PAT_DO2_T1("Dotted-Far-Thick", 15, 8, 3),
        PAT_DA1_T1("Dashed-Thick", 131071, 19, 3),
        PAT_DO1_T2("Dotted-Close-Thicker", 31, 8, 5),
        PAT_DO2_T2("Dotted-Far-Thicker", 127, 9, 5);

        private String name;
        private int pattern;
        private int len;
        private int thickness;
        private boolean solid;

        private Outline(String name, int pattern, int len, int thickness) {
            this.name = name;
            outlineNames.put(name, this);
            this.pattern = pattern;
            this.len = len;
            this.thickness = thickness;
            this.solid = pattern == -1;
        }

        public String getName() {
            return this.name;
        }

        public String getConstName() {
            return this.name();
        }

        public int getIndex() {
            return this.ordinal();
        }

        public boolean isSolidPattern() {
            return this.solid;
        }

        public int getPattern() {
            return this.pattern;
        }

        public int getLen() {
            return this.len;
        }

        public int getThickness() {
            return this.thickness;
        }

        public static Outline findOutline(int index) {
            return ((Outline[])Outline.class.getEnumConstants())[index];
        }

        public static Outline findOutline(String name) {
            return (Outline)((Object)outlineNames.get(name));
        }

        public static List<Outline> getOutlines() {
            return Arrays.asList(Outline.class.getEnumConstants());
        }

        public String toString() {
            return this.name;
        }
    }
}

