/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.drc;

import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.GeometryHandler;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.geometry.PolyBase;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.HierarchyEnumerator;
import com.sun.electric.database.hierarchy.Nodable;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.variable.VarContext;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.DRCTemplate;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Consumer;
import com.sun.electric.tool.drc.CellLayersContainer;
import com.sun.electric.tool.drc.DRC;
import com.sun.electric.tool.drc.MTDRCTool;
import com.sun.electric.tool.user.ErrorLogger;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MTDRCAreaTool
extends MTDRCTool {
    public MTDRCAreaTool(Cell c, Consumer<MTDRCTool.MTDRCResult> consumer) {
        super("Design-Rule Area Check " + c, c, consumer);
    }

    @Override
    boolean checkArea() {
        return true;
    }

    @Override
    public MTDRCTool.MTDRCResult runTaskInternal(Layer theLayer) {
        DRCTemplate minAreaRule = DRC.getMinValue(theLayer, DRCTemplate.DRCRuleType.MINAREA);
        DRCTemplate enclosedAreaRule = DRC.getMinValue(theLayer, DRCTemplate.DRCRuleType.MINENCLOSEDAREA);
        DRCTemplate spaceRule = DRC.getSpacingRule(theLayer, null, theLayer, null, true, -1, -1.0, -1.0);
        if (minAreaRule == null && enclosedAreaRule == null && spaceRule == null) {
            return null;
        }
        ErrorLogger errorLogger = DRC.getDRCErrorLogger(true, false, ", Layer " + theLayer.getName());
        String msg = "Cell " + this.topCell.getName() + " , layer " + theLayer.getName();
        System.out.println("DRC for " + msg + " in thread " + Thread.currentThread().getName());
        LayerAreaEnumerator quickArea = new LayerAreaEnumerator(theLayer, minAreaRule, enclosedAreaRule, spaceRule, errorLogger, GeometryHandler.GHMode.ALGO_SWEEP, this.cellLayersCon);
        HierarchyEnumerator.enumerateCell(this.topCell, VarContext.globalContext, (HierarchyEnumerator.Visitor)quickArea);
        long endTime = System.currentTimeMillis();
        int errorCount = errorLogger.getNumErrors();
        int warnCount = errorLogger.getNumWarnings();
        System.out.println(errorCount + " errors and " + warnCount + " warnings found in " + msg + " (took " + TextUtils.getElapsedTime(endTime - this.startTime) + " in thread " + Thread.currentThread().getName() + ")");
        long accuEndTime = System.currentTimeMillis() - this.globalStartTime;
        System.out.println("Accumulative time " + TextUtils.getElapsedTime(accuEndTime));
        return new MTDRCTool.MTDRCResult(errorCount, warnCount);
    }

    private class LayerAreaEnumerator
    extends HierarchyEnumerator.Visitor {
        private Layer theLayer;
        private Map<Cell, GeometryHandlerLayerBucket> cellsMap;
        private Layer.Function.Set thisLayerFunction;
        private GeometryHandler.GHMode mode;
        private Collection<PrimitiveNode> nodesList;
        private Collection<ArcProto> arcsList;
        private CellLayersContainer cellLayersCon;
        private DRCTemplate minAreaRule;
        private DRCTemplate enclosedAreaRule;
        private DRCTemplate spacingRule;
        private ErrorLogger errorLogger;

        LayerAreaEnumerator(Layer layer, DRCTemplate minAreaR, DRCTemplate enclosedAreaR, DRCTemplate spaceR, ErrorLogger ErrorLog, GeometryHandler.GHMode m, CellLayersContainer cellLayersC) {
            this.minAreaRule = minAreaR;
            this.enclosedAreaRule = enclosedAreaR;
            this.spacingRule = spaceR;
            this.errorLogger = ErrorLog;
            this.theLayer = layer;
            this.thisLayerFunction = DRC.getMultiLayersSet(this.theLayer);
            this.mode = m;
            this.cellsMap = new HashMap<Cell, GeometryHandlerLayerBucket>();
            this.nodesList = new ArrayList<PrimitiveNode>();
            this.cellLayersCon = cellLayersC;
            block0: for (PrimitiveNode node : MTDRCAreaTool.this.topCell.getTechnology().getNodesCollection()) {
                for (Technology.NodeLayer nLayer : node.getLayers()) {
                    if (!this.thisLayerFunction.contains(nLayer.getLayer().getFunction(), this.theLayer.getFunctionExtras())) continue;
                    this.nodesList.add(node);
                    continue block0;
                }
            }
            this.arcsList = new ArrayList<ArcProto>();
            block2: for (ArcProto ap : MTDRCAreaTool.this.topCell.getTechnology().getArcsCollection()) {
                for (int i = 0; i < ap.getNumArcLayers(); ++i) {
                    if (ap.getLayer(i) != this.theLayer) continue;
                    this.arcsList.add(ap);
                    continue block2;
                }
            }
        }

        public boolean enterCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            Set<String> set = this.cellLayersCon.getLayersSet(cell);
            if (set != null && !set.contains(this.theLayer.getName())) {
                return false;
            }
            GeometryHandlerLayerBucket bucket = this.cellsMap.get(cell);
            if (bucket != null) {
                assert (bucket.merged);
                return false;
            }
            bucket = new GeometryHandlerLayerBucket();
            this.cellsMap.put(cell, bucket);
            Iterator<ArcInst> it = info.getCell().getArcs();
            while (it.hasNext()) {
                boolean notFound;
                ArcInst ai = it.next();
                Network aNet = info.getNetlist().getNetwork(ai, 0);
                if (aNet == null) continue;
                ArcProto ap = ai.getProto();
                boolean bl = notFound = !this.arcsList.contains(ap);
                if (notFound) continue;
                Technology tech = ap.getTechnology();
                for (Poly poly : tech.getShapeOfArc(ai, this.thisLayerFunction)) {
                    this.addElementLocal(poly, this.theLayer, bucket);
                }
            }
            return true;
        }

        private void addElementLocal(Poly poly, Layer layer, GeometryHandlerLayerBucket bucket) {
            bucket.local.add(layer, poly);
        }

        public void exitCell(HierarchyEnumerator.CellInfo info) {
            Cell cell = info.getCell();
            boolean isTopCell = cell == MTDRCAreaTool.this.topCell;
            GeometryHandlerLayerBucket bucket = this.cellsMap.get(cell);
            bucket.mergeGeometry(cell);
            if (isTopCell) {
                for (Layer layer : bucket.local.getKeySet()) {
                    this.checkMinAreaLayerWithTree(bucket.local, MTDRCAreaTool.this.topCell, layer);
                }
            }
        }

        public boolean visitNodeInst(Nodable no, HierarchyEnumerator.CellInfo info) {
            boolean notFound;
            NodeInst ni = no.getNodeInst();
            if (NodeInst.isSpecialNode(ni)) {
                return false;
            }
            NodeProto np = ni.getProto();
            GeometryHandlerLayerBucket bucket = this.cellsMap.get(info.getCell());
            if (ni.isCellInstance()) {
                return true;
            }
            AffineTransform trans = ni.rotateOut();
            PrimitiveNode pNp = (PrimitiveNode)np;
            boolean bl = notFound = !this.nodesList.contains(pNp);
            if (notFound) {
                return false;
            }
            Technology tech = pNp.getTechnology();
            for (Poly poly : tech.getShapeOfNode(ni, false, true, this.thisLayerFunction)) {
                poly.roundPoints();
                poly.transform(trans);
                this.addElementLocal(poly, this.theLayer, bucket);
            }
            return true;
        }

        private int checkMinAreaLayerWithTree(GeometryHandler merge, Cell cell, Layer layer) {
            if (this.minAreaRule == null && this.enclosedAreaRule == null && this.spacingRule == null) {
                return 0;
            }
            Collection<PolyBase.PolyBaseTree> trees = merge.getTreeObjects(layer);
            GenMath.MutableInteger errorFound = new GenMath.MutableInteger(0);
            if (trees.isEmpty()) {
                System.out.println("Nothing for layer " + layer.getName() + " found.");
            }
            for (PolyBase.PolyBaseTree obj : trees) {
                this.traversePolyTree(layer, obj, 0, cell, errorFound);
            }
            return errorFound.intValue();
        }

        private void traversePolyTree(Layer layer, PolyBase.PolyBaseTree obj, int level, Cell cell, GenMath.MutableInteger count) {
            List<PolyBase.PolyBaseTree> sons = obj.getSons();
            for (PolyBase.PolyBaseTree son : sons) {
                this.traversePolyTree(layer, son, level + 1, cell, count);
            }
            boolean minAreaCheck = level % 2 == 0;
            boolean checkMin = false;
            boolean checkNotch = false;
            DRC.DRCErrorType errorType = DRC.DRCErrorType.MINAREAERROR;
            double minVal = 0.0;
            String ruleName = "";
            if (minAreaCheck) {
                if (this.minAreaRule == null) {
                    return;
                }
                minVal = this.minAreaRule.getValue(0);
                ruleName = this.minAreaRule.ruleName;
                checkMin = true;
            } else {
                errorType = DRC.DRCErrorType.ENCLOSEDAREAERROR;
                if (this.enclosedAreaRule != null) {
                    minVal = this.enclosedAreaRule.getValue(0);
                    ruleName = this.enclosedAreaRule.ruleName;
                    checkMin = true;
                }
                checkNotch = this.spacingRule != null;
            }
            PolyBase poly = obj.getPoly();
            if (checkMin) {
                double area = poly.getArea();
                if (!DBMath.isGreaterThan(minVal, area)) {
                    return;
                }
                count.increment();
                DRC.createDRCErrorLogger(this.errorLogger, null, DRC.DRCCheckMode.ERROR_CHECK_DEFAULT, true, errorType, null, cell, minVal, area, ruleName, poly, null, layer, null, null, null);
            }
            if (checkNotch) {
                Rectangle2D bnd = poly.getBounds2D();
                if (bnd.getWidth() < this.spacingRule.getValue(0)) {
                    count.increment();
                    DRC.createDRCErrorLogger(this.errorLogger, null, DRC.DRCCheckMode.ERROR_CHECK_DEFAULT, true, DRC.DRCErrorType.NOTCHERROR, "(X axis)", cell, this.spacingRule.getValue(0), bnd.getWidth(), this.spacingRule.ruleName, poly, null, layer, null, null, layer);
                }
                if (bnd.getHeight() < this.spacingRule.getValue(1)) {
                    count.increment();
                    DRC.createDRCErrorLogger(this.errorLogger, null, DRC.DRCCheckMode.ERROR_CHECK_DEFAULT, true, DRC.DRCErrorType.NOTCHERROR, "(Y axis)", cell, this.spacingRule.getValue(1), bnd.getHeight(), this.spacingRule.ruleName, poly, null, layer, null, null, layer);
                }
            }
        }

        private class GeometryHandlerLayerBucket {
            GeometryHandler local;
            boolean merged = false;

            GeometryHandlerLayerBucket() {
                this.local = GeometryHandler.createGeometryHandler(LayerAreaEnumerator.this.mode, 1);
            }

            void mergeGeometry(Cell cell) {
                if (!this.merged) {
                    this.merged = true;
                    Iterator<NodeInst> it = cell.getNodes();
                    while (it.hasNext()) {
                        NodeInst ni = it.next();
                        if (!ni.isCellInstance()) continue;
                        AffineTransform trans = ni.transformOut();
                        Cell protoCell = (Cell)ni.getProto();
                        GeometryHandlerLayerBucket bucket = (GeometryHandlerLayerBucket)LayerAreaEnumerator.this.cellsMap.get(protoCell);
                        if (bucket == null) continue;
                        this.local.addAll(bucket.local, trans);
                    }
                    this.local.postProcess(true);
                } else assert (false);
            }
        }
    }
}

