/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellUsage;
import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.ExportId;
import com.sun.electric.database.IdManager;
import com.sun.electric.database.LibId;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.prototype.NodeProtoId;
import com.sun.electric.database.text.CellName;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public final class CellId
implements NodeProtoId,
Serializable {
    public static final CellId[] NULL_ARRAY = new CellId[0];
    public final IdManager idManager;
    public final LibId libId;
    public final CellName cellName;
    public final int cellIndex;
    private volatile CellUsage[] usagesIn = CellUsage.NULL_ARRAY;
    private volatile CellUsage[] hashUsagesIn = EMPTY_USAGE_HASH;
    private volatile CellUsage[] usagesOf = CellUsage.NULL_ARRAY;
    private volatile int numExportIds = 0;
    private volatile ExportId[] exportIds = new ExportId[10];
    private volatile int[] hashExportIds = EMPTY_EXPORT_HASH;
    private volatile int numNodeIds = 0;
    private volatile int numArcIds = 0;
    private static final CellUsage[] EMPTY_USAGE_HASH = new CellUsage[]{null};
    private static final int[] EMPTY_EXPORT_HASH = new int[]{-1};

    CellId(LibId libId, CellName cellName, int cellIndex) {
        if (cellName.getVersion() <= 0) {
            throw new IllegalArgumentException("cell version");
        }
        this.idManager = libId.idManager;
        this.libId = libId;
        this.cellName = cellName;
        this.cellIndex = cellIndex;
    }

    private Object writeReplace() {
        return new CellIdKey(this);
    }

    private Object readResolve() throws ObjectStreamException {
        throw new InvalidObjectException("CellId");
    }

    public IdManager getIdManager() {
        return this.idManager;
    }

    public int numUsagesIn() {
        return this.usagesIn.length;
    }

    public CellUsage getUsageIn(int i) {
        return this.usagesIn[i];
    }

    public int numUsagesOf() {
        return this.usagesOf.length;
    }

    public CellUsage getUsageOf(int i) {
        return this.usagesOf[i];
    }

    public CellUsage getUsageIn(CellId protoId) {
        return this.getUsageIn(protoId, true);
    }

    public int numExportIds() {
        return this.numExportIds;
    }

    public ExportId getPortId(int chronIndex) {
        return this.exportIds[chronIndex];
    }

    public ExportId newExportId(String externalId) {
        return this.newExportId(externalId, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExportId randomExportId(String suggestedId) {
        String prefix = suggestedId;
        int ind = prefix.indexOf(64);
        prefix = ind >= 0 ? prefix.substring(0, ind + 1) : prefix + '@';
        Random random = new Random();
        while (true) {
            int suffix = random.nextInt() & 0x3FFFFFFF;
            String s = prefix + suffix;
            CellId cellId = this;
            synchronized (cellId) {
                if (this.newExportId(s, false) == null) {
                    return this.newExportId(s, true);
                }
            }
        }
    }

    public int newNodeId() {
        return this.numNodeIds++;
    }

    public int newArcId() {
        return this.numArcIds++;
    }

    public Cell inDatabase(EDatabase database) {
        return database.getCell(this);
    }

    public String toString() {
        return this.libId + ":" + this.cellName.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    CellUsage getUsageIn(CellId protoId, boolean create) {
        CellUsage u;
        CellUsage[] hash = this.hashUsagesIn;
        int i = protoId.hashCode() & Integer.MAX_VALUE;
        i %= hash.length;
        int j = 1;
        while (hash[i] != null) {
            u = hash[i];
            if (u.protoId == protoId) {
                return u;
            }
            if ((i += j) >= hash.length) {
                i -= hash.length;
            }
            j += 2;
        }
        Class<CellUsage> clazz = CellUsage.class;
        synchronized (CellUsage.class) {
            if (hash == this.hashUsagesIn && hash[i] == null) {
                if (!create) {
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return null;
                }
                if (this.usagesIn.length * 2 <= hash.length - 3) {
                    hash[i] = u = new CellUsage(this, protoId, this.usagesIn.length);
                    this.usagesIn = CellId.appendUsage(this.usagesIn, u);
                    protoId.usagesOf = CellId.appendUsage(protoId.usagesOf, u);
                    this.check();
                    // ** MonitorExit[var5_6] (shouldn't be in output)
                    return u;
                }
                this.rehashUsagesIn();
            }
            // ** MonitorExit[var5_6] (shouldn't be in output)
            return this.getUsageIn(protoId, create);
        }
    }

    private void rehashUsagesIn() {
        CellUsage[] usagesIn = this.usagesIn;
        int newSize = usagesIn.length * 2 + 3;
        if (newSize < 0) {
            throw new IndexOutOfBoundsException();
        }
        CellUsage[] newHash = new CellUsage[GenMath.primeSince(newSize)];
        for (int k = usagesIn.length - 1; k >= 0; --k) {
            CellUsage u = usagesIn[k];
            int i = u.protoId.hashCode() & Integer.MAX_VALUE;
            i %= newHash.length;
            int j = 1;
            while (newHash[i] != null) {
                if ((i += j) >= newHash.length) {
                    i -= newHash.length;
                }
                j += 2;
            }
            newHash[i] = u;
        }
        this.hashUsagesIn = newHash;
        this.check();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExportId newExportId(String externalId, boolean create) {
        int[] hash = this.hashExportIds;
        ExportId[] exportIds = this.exportIds;
        int i = externalId.hashCode() & Integer.MAX_VALUE;
        i %= hash.length;
        try {
            int j = 1;
            while (hash[i] >= 0) {
                ExportId exportId = exportIds[hash[i]];
                if (exportId.externalId.equals(externalId)) {
                    return exportId;
                }
                if ((i += j) >= hash.length) {
                    i -= hash.length;
                }
                j += 2;
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        CellId cellId = this;
        synchronized (cellId) {
            if (hash == this.hashExportIds && hash[i] == -1) {
                if (!create) {
                    return null;
                }
                int chronIndex = this.numExportIds;
                exportIds = this.exportIds;
                if (chronIndex * 2 <= hash.length - 3) {
                    ExportId e = new ExportId(this, chronIndex, externalId);
                    hash[i] = chronIndex;
                    if (chronIndex >= exportIds.length) {
                        assert (chronIndex == exportIds.length);
                        int newLength = (int)Math.min((long)exportIds.length * 3L / 2L + 1L, Integer.MAX_VALUE);
                        ExportId[] newExportIds = new ExportId[newLength];
                        System.arraycopy(exportIds, 0, newExportIds, 0, chronIndex);
                        exportIds = newExportIds;
                    }
                    exportIds[chronIndex] = e;
                    this.exportIds = exportIds;
                    this.hashExportIds = hash;
                    this.numExportIds = chronIndex + 1;
                    return e;
                }
                this.rehashExportIds(exportIds, this.numExportIds);
            }
            return this.newExportId(externalId, create);
        }
    }

    private void rehashExportIds(ExportId[] exportIds, int numExports) {
        int newSize = exportIds.length * 2 + 3;
        if (newSize < 0) {
            throw new IndexOutOfBoundsException();
        }
        int[] newHash = new int[GenMath.primeSince(newSize)];
        Arrays.fill(newHash, -1);
        int k = 0;
        while (k < numExports) {
            ExportId exportId = exportIds[k];
            int i = exportId.hashCode() & Integer.MAX_VALUE;
            i %= newHash.length;
            int j = 1;
            while (newHash[i] >= 0) {
                assert (exportIds[newHash[i]] != exportId);
                if ((i += j) >= newHash.length) {
                    i -= newHash.length;
                }
                j += 2;
            }
            newHash[i] = k++;
        }
        this.hashExportIds = newHash;
        this.check();
    }

    private static CellUsage[] appendUsage(CellUsage[] usages, CellUsage newUsage) {
        CellUsage[] newUsages = new CellUsage[usages.length + 1];
        System.arraycopy(usages, 0, newUsages, 0, usages.length);
        newUsages[usages.length] = newUsage;
        return newUsages;
    }

    void check() {
        this.checkLinked();
        assert (this.idManager == this.libId.idManager);
        this.cellName.check();
        assert (this.cellName.getVersion() > 0);
        assert (this.libId.getCellId(this.cellName) == this);
        CellUsage[] usagesIn = this.usagesIn;
        for (int k = 0; k < usagesIn.length; ++k) {
            CellUsage u = usagesIn[k];
            assert (u.parentId == this);
            assert (u.indexInParent == k);
            assert (u.parentId.getIdManager() == this.getIdManager());
            u.protoId.checkLinked();
            u.check();
        }
        this.checkHashUsagesIn();
        this.checkHashExportIds();
        CellUsage[] usagesOf = this.usagesOf;
        for (int k = 0; k < usagesOf.length; ++k) {
            CellUsage u = usagesOf[k];
            assert (u.protoId.getIdManager() == this.getIdManager());
            u.parentId.checkLinked();
            assert (u == u.parentId.usagesIn[u.indexInParent]);
        }
        int numExportIds = this.numExportIds;
        for (int chronIndex = 0; chronIndex < numExportIds; ++chronIndex) {
            ExportId e = this.exportIds[chronIndex];
            assert (e.parentId == this);
            assert (e.chronIndex == chronIndex);
            assert (this.newExportId(e.externalId, false) == e);
            e.check();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHashUsagesIn() {
        Class<CellUsage> clazz = CellUsage.class;
        synchronized (CellUsage.class) {
            CellUsage[] usagesIn = this.usagesIn;
            CellUsage[] hash = this.hashUsagesIn;
            // ** MonitorExit[var3_1] (shouldn't be in output)
            int count = 0;
            for (int i = 0; i < hash.length; ++i) {
                CellUsage u = hash[i];
                if (u == null) continue;
                assert (u.parentId == this);
                assert (u == usagesIn[u.indexInParent]);
                ++count;
            }
            assert (usagesIn.length == count);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkHashExportIds() {
        int[] hash;
        ExportId[] exportIds;
        CellId cellId = this;
        synchronized (cellId) {
            exportIds = this.exportIds;
            hash = this.hashExportIds;
        }
        int count = 0;
        for (int i = 0; i < hash.length; ++i) {
            int k = hash[i];
            if (k == -1) continue;
            assert (k >= 0 && k < exportIds.length);
            ++count;
        }
        assert (this.numExportIds == count);
    }

    private void checkLinked() {
        assert (this == this.getIdManager().getCellId(this.cellIndex));
    }

    public static void main(String[] args) {
        IdManager idManager = new IdManager();
        LibId libId = idManager.newLibId("lib");
        CellName cellName = CellName.parseName("cell;1{sch}");
        CellId cellId = libId.newCellId(cellName);
        cellId.hashExportIds = new int[8];
        Arrays.fill(cellId.hashExportIds, -1);
        cellId.newExportId("A");
        String s = "B";
        cellId.newExportId(s);
        long startTime = System.currentTimeMillis();
        int numTries = 100000000;
        int k = 0;
        for (int i = 0; i < numTries; ++i) {
            ExportId eId = cellId.newExportId(s);
            k += eId.chronIndex;
        }
        long stopTime = System.currentTimeMillis();
        System.out.println("k=" + k + " t=" + (stopTime - startTime));
    }

    private static class CellIdKey
    extends EObjectInputStream.Key {
        private final int cellIndex;

        private CellIdKey(CellId cellId) {
            this.cellIndex = cellId.cellIndex;
        }

        protected Object readResolveInDatabase(EDatabase database) throws InvalidObjectException {
            return database.getIdManager().getCellId(this.cellIndex);
        }
    }
}

