#!/bin/sh
PYVER=25
# This is used to select the prepackaged python tarball
MYPYVER=25
PYTHON=/c/Python$PYVER/python.exe

build() {
  # MS Windows have other defaults than linux. The 'sed' I have installed on
  # my windows machine don't support the -i option.
  mv default.config tmp.cfg
  sed -e "s/type=external-midiplayer/type=sequencer-device/" -e "s/csound=csound/csound=AUTODETECT/" -e "s/mma=mma/mma=AUTODETECT/" tmp.cfg > default.config
  rm tmp.cfg

  ./configure PYTHON=/c/Python$PYVER/python.exe --disable-pygtk-test --enable-winmidi
  make skipmanual=yes PYTHON_INCLUDES=-I/c/Python$PYVER/include
  make winbuild
}

prepare_installer() {
  rm win32 -rf
  make DESTDIR=win32 prefix="" install skipmanual=yes PYTHON_INCLUDES=-I/c/Python$PYVER/include
  mkdir win32/python
  (cd win32/python && tar zxf ../../../my-python-$MYPYVER.tgz)
  mv win32/python/DLLs win32/bin
  mv win32/python/Lib win32/bin
  mv win32/python/libs win32/bin
  mv win32/python/LICENSE.txt win32/LICENSE.python.txt
  mv win32/python/NEWS.txt win32/NEWS.python.txt
  mv win32/python/README.txt win32/README.python.txt
  mv win32/python/python.exe win32/bin
  mv win32/python/pythonw.exe win32/bin
  mv win32/python/w9xpopen.exe win32/bin
  $PYTHON tools/get-gtk-files.py bin
  $PYTHON tools/get-gtk-files.py unpack
  mv win32/zlib-1.2.4/zlib1.dll win32/bin
  # Move these so CSound can find python25.dll
  mv win32/python/python25.dll win32/bin
  mv win32/python/msvcr71.dll win32/bin
  cp -a ../pygtk-stuff/* win32/bin/lib/site-packages
  (cp solfege/soundcard/winmidi.pyd win32/share/solfege/solfege/soundcard)
  cp win32-start-solfege.pyw win32/bin
  cp solfegedebug.bat win32/bin/
  cp testgtkenv.bat testgtkenv.py win32/bin/
  cp README.txt INSTALL.win32.txt INSTALL.txt AUTHORS.txt COPYING.txt win32
  echo "gtk-theme-name = \"MS-Windows\""  > win32/etc/gtk-2.0/gtkrc
  (cd win32 && find -name *.pyc | xargs rm)
  $PYTHON tools/trim_win32_installer.py
  rm -rf win32/python
  echo "Now you must double click the file windowsinstaller.iss and"
  echo "build the installer"
}

mk_pygtk_stuff() {
  rm -rf ../pygtk-stuff
  mkdir ../pygtk-stuff
  cp /C/Python$PYVER/Lib/site-packages/pygtk.* ../pygtk-stuff/
  cp -a /C/Python$PYVER/Lib/site-packages/cairo/ ../pygtk-stuff/
  cp -a /C/Python$PYVER/Lib/site-packages/gtk-2.0/ ../pygtk-stuff/
}
 
if test "x$1" = "xbuild"; then
  build
fi
if test "x$1" = "xmkinstalldir"; then
  prepare_installer
fi
if test "x$1" = "xbuildenv"; then
  mk_pygtk_stuff
fi
if test "x$1" = "x-h"; then
  echo "sub commands:"
  echo "   buildenv      create ../pygtk-stuff/  This has to be done one with"
  echo "                 the pygtk binary installer package installed."
  echo "   build         build the package"
  echo "   mkinstalldir  create the win32/ folder that the installer will pack"
fi

