/* GNU moe - My Own Editor
   Copyright (C) 2005-2025 Antonio Diaz Diaz.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

namespace Regex {

/* Search 'buffer' from 'p1' ('p1-1' if backward) for 'regex'.
   If found, set 'p1' at the first char of, and 'p2' after the end of, the
   substring found, and return in 'pieces' the text matching every '\*',
   '\?', etc, from the regular expresion.
   Return 0 if match, 1 if no match, 2 if trouble.
*/
int find( const Basic_buffer & buffer, Point & p1, Point & p2,
          const std::string & regex, std::vector< std::string > & pieces,
          const bool icase = false, const bool backward = false );


/* Delete block at [p1,p2) and replace it with the text produced from
   'regex' and 'pieces'.
   If there is no error, return true and set 'p2' after the newly
   inserted text.
*/
bool replace( Buffer & buffer, const Point & p1, Point & p2,
              const std::string & regex,
              const std::vector< std::string > & pieces );


// Return true if 'regex' from i1 matches 'name' from i2
//
bool match_filename( const std::string & regex, const std::string & name,
                     unsigned i1 = 0, unsigned i2 = 0 );

} // end namespace Regex
