/* -*-c-*- -------------- mixgtk_wm.c :
 * Implementation of the functions declared in mixgtk_wm.h
 * ------------------------------------------------------------------
 *  Last change: Time-stamp: "2001-06-24 14:36:18 jao"
 * ------------------------------------------------------------------
 * Copyright (C) 2001 Free Software Foundation, Inc.
 *  
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *  
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *  
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 */

#include "mixgtk_widgets.h"
#include "mixgtk_config.h"
#include "mixgtk_wm.h"

typedef struct window_info_t_
{
  mixgtk_dialog_id_t dialog;
  GtkWidget *widget;
  GtkCheckMenuItem *menu;
  const gchar *menu_name;
  const gchar *config_key;
  gboolean visible;
} window_info_t_;

static window_info_t_ infos_[] = {
  {MIXGTK_MIXVM_DIALOG, NULL, NULL, "mix_view", "MIX.view"},
  {MIXGTK_MIXAL_DIALOG, NULL, NULL, "mixal_view", "MIXAL.view"},
  {MIXGTK_DEVICES_DIALOG, NULL, NULL, "devices_view", "Devices.view"}
};

static size_t INF_NO_ = sizeof (infos_) / sizeof (infos_[0]);

static gboolean split_ = FALSE;
static const gchar *SPLIT_MENU_NAME_ = "split_windows";
static GtkCheckMenuItem *split_menu_ = NULL;

static const gchar *VIEW_YES_ = "Yes";
static const gchar *VIEW_NO_ = "No";

/* flag marking that we are inside a restart process */
static gboolean restart_ = FALSE;

gboolean
mixgtk_wm_init (void)
{
  static gboolean restart = FALSE;
  split_ = mixgtk_config_is_split ();
  if (split_)
    {
      gint i;
      split_menu_ = GTK_CHECK_MENU_ITEM
	(mixgtk_widget_factory_get_child_by_name (MIXGTK_MAIN,
						  SPLIT_MENU_NAME_));
      g_return_val_if_fail (split_menu_, FALSE);
      gtk_check_menu_item_set_active (split_menu_, TRUE);
      for (i = 0; i < INF_NO_; ++i)
	{
	  infos_[i].widget =
	    mixgtk_widget_factory_get_dialog (infos_[i].dialog);
	  g_return_val_if_fail (infos_[i].widget, FALSE);
	  infos_[i].menu = GTK_CHECK_MENU_ITEM
	    (mixgtk_widget_factory_get_child_by_name
	     (MIXGTK_MAIN, infos_[i].menu_name));
	  g_return_val_if_fail (infos_[i].menu, FALSE);
	  if (!restart)
	    {
	      const gchar *view = mixgtk_config_get (infos_[i].config_key);
	      infos_[i].visible = !view || !strcmp (VIEW_YES_, view);
	    }
	  if (infos_[i].visible) gtk_widget_show (infos_[i].widget);
	  gtk_check_menu_item_set_active (infos_[i].menu, infos_[i].visible);
	}
    }
  else
    {
      gint k;
      for (k = 0; k < INF_NO_; ++k)
	if (infos_[k].widget) gtk_widget_destroy (infos_[k].widget);
    }
    
  restart = TRUE;
  return TRUE;
}

void
mixgtk_wm_show_window (mixgtk_window_id_t w)
{
  g_return_if_fail (w < INF_NO_);
  if (!infos_[w].visible)
    {
      infos_[w].visible = TRUE;
      gtk_check_menu_item_set_active (infos_[w].menu, TRUE);
      mixgtk_config_update (infos_[w].config_key, VIEW_YES_);
      gtk_widget_show (infos_[w].widget);
    }
}

void
mixgtk_wm_hide_window (mixgtk_window_id_t w)
{
  g_return_if_fail (w < INF_NO_);
  if (infos_[w].visible && !restart_)
    {
      infos_[w].visible = FALSE;
      gtk_check_menu_item_set_active (infos_[w].menu, FALSE);
      mixgtk_config_update (infos_[w].config_key, VIEW_NO_);
      gtk_widget_hide (infos_[w].widget);
    }
}

/* callbacks */
void
on_view_toggled (GtkCheckMenuItem *item)
{
  if (!restart_)
    {
      gint k;
      for (k = 0; k < INF_NO_; ++k)
	if (item == infos_[k].menu) break;
      g_return_if_fail (k < INF_NO_);
      if (item->active)
	mixgtk_wm_show_window (k);
      else
	mixgtk_wm_hide_window (k);
      mixgtk_config_update (infos_[k].config_key,
			    (item->active)? VIEW_YES_ : VIEW_NO_);
      infos_[k].visible = item->active;
    }
}

void
on_split_windows_toggled (GtkCheckMenuItem *item)
{
  mixgtk_config_set_split (item->active);
  restart_ = TRUE;
  gtk_widget_destroy (mixgtk_widget_factory_get_dialog (MIXGTK_MAIN));
}

void
on_window_hide (GtkWidget *w)
{
  gint k;
  for (k = 0; k < INF_NO_; ++k)
    if (w == infos_[k].widget) break;
  g_return_if_fail (k < INF_NO_);
  mixgtk_wm_hide_window (k);
}
  
void
on_main_window_destroy (GtkWidget *w, gpointer data)
{
  if (restart_)
    {
      mixgtk_restart ();
      restart_ = FALSE;
    }
  else gtk_main_quit ();
}

