==================================================================
CVE-2024-12133: Potential DoS in handling of numerous SEQUENCE OF or SET OF elements
==================================================================

When an input DER data contains a large number of SEQUENCE OF or SET
OF elements, decoding the data and searching a specific element in it
take quadratic time to complete. This could be utilized for a remote
DoS attack by presenting a crafted certificate to the network peer.

Severity: Moderate
Vulnerable versions : All released version of libtasn1
Not vulnerable      : libtasn1 4.20.0

Vulnerability information
=========================
The issue is twofold: decoding a DER input with sequences and locating
a specific element in a sequence. Even though a DER sequence is
conceptually an array, in libtasn1 it is represented as a linked list,
whose elements are assigned a string name, such as "?1". Therefore a
simple lookup of an element at a given position is linear O(N) time
complexity. When decoding a DER sequence, in each step libtasn1 looks
up the parent node, recorded on the first element, which requires a
backward linear search, resulting in O(N^2) time complexity.

For details, see the original issue reported at:
https://gitlab.com/gnutls/libtasn1/-/issues/52

Exploitation
============
By presenting a certificate with a large number of Subject Alternative
Name or name constraint entries, the adversary can impose Denial of
Service (DoS) in applications using libtasn1 for certificate parsing
and verification.

Recommendation
=========
To address this vulnerability, please upgrade to libtasn1 4.20.0 or
later. At the same time, we recommend applications using libtasn1 for
certificate processing should set a limit of input sequences, such as
Subject Alternative Name or name constraint entries to reduce attack
surface.

Workaround
==========
For those who cannot modify the application code, resource control
mechanisms provided by the operating system, such as cgroups could
help avoid excessive usage of CPU time.

Credits
=======
This vulnerability was found and reported by Bing Shi.
