/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.models;

import gnu.kawa.models.Display;
import gnu.kawa.models.Model;
import gnu.kawa.models.Spacer;
import gnu.kawa.models.Viewable;
import gnu.math.IntNum;
import java.awt.Dimension;
import java.io.Serializable;

public abstract class Box
extends Model
implements Viewable,
Serializable {
    Viewable[] components;
    int numComponents;
    Viewable cellSpacing;

    public Viewable getCellSpacing() {
        return this.cellSpacing;
    }

    public void setCellSpacing(Object object2) {
        if (object2 instanceof IntNum || object2 instanceof Integer) {
            int n = ((Number)object2).intValue();
            Dimension dimension = this.getAxis() == 0 ? new Dimension(n, 0) : new Dimension(0, n);
            this.cellSpacing = Spacer.rigidArea(dimension);
        } else {
            this.cellSpacing = (Viewable)object2;
        }
    }

    public abstract int getAxis();

    public final int getComponentCount() {
        return this.numComponents;
    }

    public final Viewable getComponent(int n) {
        return this.components[n];
    }

    public void add(Viewable viewable) {
        Viewable[] viewableArray = this.components;
        int n = this.numComponents;
        if (n == 0) {
            this.components = viewableArray = new Viewable[4];
        } else if (viewableArray.length <= n) {
            this.components = new Viewable[2 * n];
            System.arraycopy(viewableArray, 0, this.components, 0, n);
            viewableArray = this.components;
        }
        this.components[n] = viewable;
        this.numComponents = n + 1;
    }

    public void makeView(Display display, Object object2) {
        display.addBox(this, object2);
    }
}

