/*
 * Decompiled with CFR 0.152.
 */
package gnu.kawa.functions;

import gnu.mapping.Namespace;
import gnu.mapping.Symbol;
import java.text.BreakIterator;

public class UnicodeUtils {
    static final Symbol Mc;
    static final Symbol Pc;
    static final Symbol Cc;
    static final Symbol Sc;
    static final Symbol Pd;
    static final Symbol Nd;
    static final Symbol Me;
    static final Symbol Pe;
    static final Symbol Pf;
    static final Symbol Cf;
    static final Symbol Pi;
    static final Symbol Nl;
    static final Symbol Zl;
    static final Symbol Ll;
    static final Symbol Sm;
    static final Symbol Lm;
    static final Symbol Sk;
    static final Symbol Mn;
    static final Symbol Lo;
    static final Symbol No;
    static final Symbol Po;
    static final Symbol So;
    static final Symbol Zp;
    static final Symbol Co;
    static final Symbol Zs;
    static final Symbol Ps;
    static final Symbol Cs;
    static final Symbol Lt;
    static final Symbol Cn;
    static final Symbol Lu;

    public static boolean isWhitespace(int n) {
        if (n == 32 || n >= 9 && n <= 13) {
            return true;
        }
        if (n < 133) {
            return false;
        }
        if (n == 133 || n == 160 || n == 5760 || n == 6158) {
            return true;
        }
        if (n < 8192 || n > 12288) {
            return false;
        }
        return n <= 8202 || n == 8232 || n == 8233 || n == 8239 || n == 8287 || n == 12288;
    }

    public static String capitalize(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        BreakIterator breakIterator = BreakIterator.getWordInstance();
        breakIterator.setText(string);
        int n = breakIterator.first();
        int n2 = breakIterator.next();
        while (n2 != -1) {
            int n3;
            boolean bl = false;
            for (n3 = n; n3 < n2; ++n3) {
                if (!Character.isLetter(string.codePointAt(n3))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                stringBuilder.append(string, n, n2);
            } else {
                n3 = string.charAt(n);
                char c = Character.toTitleCase((char)n3);
                stringBuilder.append(c);
                stringBuilder.append(string.substring(n + 1, n2).toLowerCase());
            }
            n = n2;
            n2 = breakIterator.next();
        }
        return stringBuilder.toString();
    }

    public static String foldCase(CharSequence charSequence) {
        int n = charSequence.length();
        if (n == 0) {
            return "";
        }
        StringBuilder stringBuilder = null;
        int n2 = 0;
        int n3 = 0;
        while (true) {
            boolean bl;
            int n4 = n3 == n ? -1 : (int)charSequence.charAt(n3);
            boolean bl2 = bl = n4 == 931 || n4 == 963 || n4 == 962;
            if (n4 < 0 || n4 == 304 || n4 == 305 || bl) {
                if (stringBuilder == null && n4 >= 0) {
                    stringBuilder = new StringBuilder();
                }
                if (n3 > n2) {
                    String string = ((Object)charSequence.subSequence(n2, n3)).toString().toUpperCase().toLowerCase();
                    if (stringBuilder == null) {
                        return string;
                    }
                    stringBuilder.append(string);
                }
                if (n4 < 0) break;
                if (bl) {
                    n4 = 963;
                }
                stringBuilder.append((char)n4);
                n2 = n3 + 1;
            }
            ++n3;
        }
        return stringBuilder.toString();
    }

    public static Symbol generalCategory(int n) {
        switch (Character.getType(n)) {
            case 8: {
                return Mc;
            }
            case 23: {
                return Pc;
            }
            case 15: {
                return Cc;
            }
            case 26: {
                return Sc;
            }
            case 20: {
                return Pd;
            }
            case 9: {
                return Nd;
            }
            case 7: {
                return Me;
            }
            case 22: {
                return Pe;
            }
            case 30: {
                return Pf;
            }
            case 16: {
                return Cf;
            }
            case 29: {
                return Pi;
            }
            case 10: {
                return Nl;
            }
            case 13: {
                return Zl;
            }
            case 2: {
                return Ll;
            }
            case 25: {
                return Sm;
            }
            case 4: {
                return Lm;
            }
            case 27: {
                return Sk;
            }
            case 6: {
                return Mn;
            }
            case 5: {
                return Lo;
            }
            case 11: {
                return No;
            }
            case 24: {
                return Po;
            }
            case 28: {
                return So;
            }
            case 14: {
                return Zp;
            }
            case 18: {
                return Co;
            }
            case 12: {
                return Zs;
            }
            case 21: {
                return Ps;
            }
            case 19: {
                return Cs;
            }
            case 3: {
                return Lt;
            }
            case 1: {
                return Lu;
            }
        }
        return Cn;
    }

    static {
        Namespace namespace = Namespace.EmptyNamespace;
        Mc = namespace.getSymbol("Mc");
        Pc = namespace.getSymbol("Pc");
        Cc = namespace.getSymbol("Cc");
        Sc = namespace.getSymbol("Sc");
        Pd = namespace.getSymbol("Pd");
        Nd = namespace.getSymbol("Nd");
        Me = namespace.getSymbol("Me");
        Pe = namespace.getSymbol("Pe");
        Pf = namespace.getSymbol("Pf");
        Cf = namespace.getSymbol("Cf");
        Pi = namespace.getSymbol("Pi");
        Nl = namespace.getSymbol("Nl");
        Zl = namespace.getSymbol("Zl");
        Ll = namespace.getSymbol("Ll");
        Sm = namespace.getSymbol("Sm");
        Lm = namespace.getSymbol("Lm");
        Sk = namespace.getSymbol("Sk");
        Mn = namespace.getSymbol("Mn");
        Lo = namespace.getSymbol("Lo");
        No = namespace.getSymbol("No");
        Po = namespace.getSymbol("Po");
        So = namespace.getSymbol("So");
        Zp = namespace.getSymbol("Zp");
        Co = namespace.getSymbol("Co");
        Zs = namespace.getSymbol("Zs");
        Ps = namespace.getSymbol("Ps");
        Cs = namespace.getSymbol("Cs");
        Lt = namespace.getSymbol("Lt");
        Cn = namespace.getSymbol("Cn");
        Lu = namespace.getSymbol("Lu");
    }
}

