/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.ExceptionsAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Filter;
import gnu.bytecode.Method;
import gnu.bytecode.ObjectType;
import gnu.bytecode.PrimType;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.ApplyExp;
import gnu.expr.CheckedTarget;
import gnu.expr.ClassExp;
import gnu.expr.Closure;
import gnu.expr.Compilation;
import gnu.expr.ConsumerTarget;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.Initializer;
import gnu.expr.InlineCalls;
import gnu.expr.Keyword;
import gnu.expr.ModuleExp;
import gnu.expr.PrimProcedure;
import gnu.expr.ProcInitializer;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.Special;
import gnu.expr.StackTarget;
import gnu.expr.Target;
import gnu.expr.ThisExp;
import gnu.kawa.functions.Convert;
import gnu.lists.LList;
import gnu.mapping.CallContext;
import gnu.mapping.OutPort;
import gnu.mapping.Procedure;
import gnu.mapping.PropertySet;
import gnu.mapping.Values;
import gnu.mapping.WrappedException;
import gnu.mapping.WrongArguments;
import java.util.Set;
import java.util.Vector;

public class LambdaExp
extends ScopeExp {
    public Expression body;
    public int min_args;
    public int max_args;
    Vector applyMethods;
    Variable argsArray;
    private Declaration firstArgsArrayArg;
    public Keyword[] keywords;
    public Expression[] defaultArgs;
    Declaration capturedVars;
    Variable heapFrame;
    public LambdaExp firstChild;
    public LambdaExp nextSibling;
    static final ApplyExp unknownContinuation = new ApplyExp((Expression)null, null);
    public Expression returnContinuation;
    Set<LambdaExp> tailCallers;
    public LambdaExp inlineHome;
    ReferenceExp[] throwsSpecification;
    public Declaration nameDecl;
    public Field closureEnvField;
    public Field staticLinkField;
    Variable closureEnv;
    static final int INLINE_ONLY = 1;
    static final int CAN_READ = 2;
    static final int CAN_CALL = 4;
    static final int IMPORTS_LEX_VARS = 8;
    static final int NEEDS_STATIC_LINK = 16;
    static final int CANNOT_INLINE = 32;
    static final int CLASS_METHOD = 64;
    static final int METHODS_COMPILED = 128;
    public static final int NO_FIELD = 256;
    static final int DEFAULT_CAPTURES_ARG = 512;
    public static final int SEQUENCE_RESULT = 1024;
    public static final int OVERLOADABLE_FIELD = 2048;
    public static final int ATTEMPT_INLINE = 4096;
    protected static final int NEXT_AVAIL_FLAG = 8192;
    ClassType type = Compilation.typeProcedure;
    int selectorValue;
    Method[] primMethods;
    Method[] primBodyMethods;
    Variable thisVariable;
    static Method searchForKeywordMethod3;
    static Method searchForKeywordMethod4;
    Initializer initChain;
    Procedure thisValue;
    Object[] properties;
    public Type returnType;

    public void capture(Declaration declaration) {
        if (declaration.isSimple()) {
            if (!(this.capturedVars != null || declaration.isStatic() || this instanceof ModuleExp || this instanceof ClassExp)) {
                this.heapFrame = new Variable("heapFrame");
            }
            declaration.setSimple(false);
            if (!declaration.isPublic()) {
                declaration.nextCapturedVar = this.capturedVars;
                this.capturedVars = declaration;
            }
        }
    }

    public void setExceptions(ReferenceExp[] referenceExpArray) {
        this.throwsSpecification = referenceExpArray;
    }

    public final boolean getInlineOnly() {
        return (this.flags & 1) != 0;
    }

    public final void setInlineOnly(boolean bl) {
        this.setFlag(bl, 1);
    }

    public final boolean getNeedsClosureEnv() {
        return (this.flags & 0x18) != 0;
    }

    public final boolean getNeedsStaticLink() {
        return (this.flags & 0x10) != 0;
    }

    public final void setNeedsStaticLink(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public final boolean getImportsLexVars() {
        return (this.flags & 8) != 0;
    }

    public final void setImportsLexVars(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final void setImportsLexVars() {
        int n = this.flags;
        this.flags |= 8;
        if ((n & 8) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    public final void setNeedsStaticLink() {
        int n = this.flags;
        this.flags |= 0x10;
        if ((n & 0x10) == 0 && this.nameDecl != null) {
            this.setCallersNeedStaticLink();
        }
    }

    void setCallersNeedStaticLink() {
        LambdaExp lambdaExp = this.outerLambda();
        ApplyExp applyExp = this.nameDecl.firstCall;
        while (applyExp != null) {
            for (LambdaExp lambdaExp2 = applyExp.context; lambdaExp2 != lambdaExp && !(lambdaExp2 instanceof ModuleExp); lambdaExp2 = lambdaExp2.outerLambda()) {
                lambdaExp2.setNeedsStaticLink();
            }
            applyExp = applyExp.nextCall;
        }
    }

    public final boolean getCanRead() {
        return (this.flags & 2) != 0;
    }

    public final void setCanRead(boolean bl) {
        this.flags = bl ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public final boolean getCanCall() {
        return (this.flags & 4) != 0;
    }

    public final void setCanCall(boolean bl) {
        this.flags = bl ? (this.flags |= 4) : (this.flags &= 0xFFFFFFFB);
    }

    public final boolean isClassMethod() {
        return (this.flags & 0x40) != 0;
    }

    public final void setClassMethod(boolean bl) {
        this.flags = bl ? (this.flags |= 0x40) : (this.flags &= 0xFFFFFFBF);
    }

    public final boolean isModuleBody() {
        return this instanceof ModuleExp;
    }

    public final boolean isClassGenerated() {
        return this.isModuleBody() || this instanceof ClassExp;
    }

    public boolean isAbstract() {
        return this.body == QuoteExp.abstractExp;
    }

    public int getCallConvention() {
        if (this.isModuleBody()) {
            return Compilation.defaultCallConvention >= 2 ? Compilation.defaultCallConvention : 2;
        }
        if (this.isClassMethod()) {
            return 1;
        }
        return Compilation.defaultCallConvention != 0 ? Compilation.defaultCallConvention : 1;
    }

    public final boolean isHandlingTailCalls() {
        return this.isModuleBody() || Compilation.defaultCallConvention >= 3 && !this.isClassMethod();
    }

    public final boolean variable_args() {
        return this.max_args < 0;
    }

    protected ClassType getCompiledClassType(Compilation compilation) {
        if (this.type == Compilation.typeProcedure) {
            throw new Error("internal error: getCompiledClassType");
        }
        return this.type;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(ClassType classType) {
        this.type = classType;
    }

    public int incomingArgs() {
        return this.min_args == this.max_args && this.max_args <= 4 && this.max_args > 0 ? this.max_args : 1;
    }

    int getSelectorValue(Compilation compilation) {
        int n = this.selectorValue;
        if (n == 0) {
            n = compilation.maxSelectorValue;
            compilation.maxSelectorValue = n + this.primMethods.length;
            this.selectorValue = ++n;
        }
        return n;
    }

    public final Method getMethod(int n) {
        if (this.primMethods == null || this.max_args >= 0 && n > this.max_args) {
            return null;
        }
        int n2 = n - this.min_args;
        if (n2 < 0) {
            return null;
        }
        int n3 = this.primMethods.length;
        return this.primMethods[n2 < n3 ? n2 : n3 - 1];
    }

    public final Method getMainMethod() {
        Method[] methodArray = this.primBodyMethods;
        return methodArray == null ? null : methodArray[methodArray.length - 1];
    }

    public final Type restArgType() {
        if (this.min_args == this.max_args) {
            return null;
        }
        if (this.primMethods == null) {
            throw new Error("internal error - restArgType");
        }
        Method[] methodArray = this.primMethods;
        if (this.max_args >= 0 && methodArray.length > this.max_args - this.min_args) {
            return null;
        }
        Method method = methodArray[methodArray.length - 1];
        Type[] typeArray = method.getParameterTypes();
        int n = typeArray.length - 1;
        if (method.getName().endsWith("$X")) {
            --n;
        }
        return typeArray[n];
    }

    public LambdaExp outerLambda() {
        return this.outer == null ? null : this.outer.currentLambda();
    }

    public LambdaExp outerLambdaNotInline() {
        ScopeExp scopeExp = this;
        while ((scopeExp = scopeExp.outer) != null) {
            ScopeExp scopeExp2;
            if (!(scopeExp instanceof LambdaExp) || ((LambdaExp)(scopeExp2 = scopeExp)).getInlineOnly()) continue;
            return scopeExp2;
        }
        return null;
    }

    boolean inlinedIn(LambdaExp lambdaExp) {
        LambdaExp lambdaExp2 = this;
        while (lambdaExp2.getInlineOnly()) {
            if (lambdaExp2 == lambdaExp) {
                return true;
            }
            lambdaExp2 = lambdaExp2.getCaller();
        }
        return false;
    }

    public LambdaExp getCaller() {
        return this.inlineHome;
    }

    public Variable declareThis(ClassType classType) {
        if (this.thisVariable == null) {
            this.thisVariable = new Variable("this");
            this.getVarScope().addVariableAfter(null, this.thisVariable);
            this.thisVariable.setParameter(true);
        }
        if (this.thisVariable.getType() == null) {
            this.thisVariable.setType(classType);
        }
        if (this.decls != null && this.decls.isThisParameter()) {
            this.decls.var = this.thisVariable;
        }
        return this.thisVariable;
    }

    public Variable declareClosureEnv() {
        if (this.closureEnv == null && this.getNeedsClosureEnv()) {
            Variable variable;
            LambdaExp lambdaExp = this.outerLambda();
            if (lambdaExp instanceof ClassExp) {
                lambdaExp = lambdaExp.outerLambda();
            }
            Variable variable2 = variable = lambdaExp.heapFrame != null ? lambdaExp.heapFrame : lambdaExp.closureEnv;
            if (this.isClassMethod() && !"*init*".equals(this.getName())) {
                this.closureEnv = this.declareThis(this.type);
            } else if (lambdaExp.heapFrame == null && !lambdaExp.getNeedsStaticLink() && !(lambdaExp instanceof ModuleExp)) {
                this.closureEnv = null;
            } else if (!this.isClassGenerated() && !this.getInlineOnly()) {
                Method method = this.getMainMethod();
                boolean bl = "*init*".equals(this.getName());
                if (!method.getStaticFlag() && !bl) {
                    this.closureEnv = this.declareThis(method.getDeclaringClass());
                } else {
                    Type type = method.getParameterTypes()[0];
                    this.closureEnv = new Variable("closureEnv", type);
                    Variable variable3 = bl ? this.declareThis(method.getDeclaringClass()) : null;
                    this.getVarScope().addVariableAfter(variable3, this.closureEnv);
                    this.closureEnv.setParameter(true);
                }
            } else if (this.inlinedIn(lambdaExp)) {
                this.closureEnv = variable;
            } else {
                this.closureEnv = new Variable("closureEnv", variable.getType());
                this.getVarScope().addVariable(this.closureEnv);
            }
        }
        return this.closureEnv;
    }

    public LambdaExp() {
    }

    public LambdaExp(int n) {
        this.min_args = n;
        this.max_args = n;
    }

    public LambdaExp(Expression expression) {
        this.body = expression;
    }

    public void loadHeapFrame(Compilation compilation) {
        ClassType classType;
        LambdaExp lambdaExp;
        for (lambdaExp = compilation.curLambda; lambdaExp != this && lambdaExp.getInlineOnly(); lambdaExp = lambdaExp.getCaller()) {
        }
        CodeAttr codeAttr = compilation.getCode();
        if (lambdaExp.heapFrame != null && this == lambdaExp) {
            codeAttr.emitLoad(lambdaExp.heapFrame);
            return;
        }
        if (lambdaExp.closureEnv != null) {
            codeAttr.emitLoad(lambdaExp.closureEnv);
            classType = (ClassType)lambdaExp.closureEnv.getType();
        } else {
            codeAttr.emitPushThis();
            classType = compilation.curClass;
        }
        while (lambdaExp != this) {
            Field field = lambdaExp.staticLinkField;
            if (field != null && field.getDeclaringClass() == classType) {
                codeAttr.emitGetField(field);
                classType = (ClassType)field.getType();
            }
            lambdaExp = lambdaExp.outerLambda();
        }
    }

    Declaration getArg(int n) {
        Declaration declaration = this.firstDecl();
        while (true) {
            if (declaration == null) {
                throw new Error("internal error - getArg");
            }
            if (n == 0) {
                return declaration;
            }
            --n;
            declaration = declaration.nextDecl();
        }
    }

    public void compileEnd(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        if (!this.getInlineOnly()) {
            if (compilation.method.reachableHere() && (Compilation.defaultCallConvention < 3 || this.isModuleBody() || this.isClassMethod() || this.isHandlingTailCalls())) {
                codeAttr.emitReturn();
            }
            this.popScope(codeAttr);
            if (!Compilation.fewerClasses) {
                codeAttr.popScope();
            }
        }
        LambdaExp lambdaExp = this.firstChild;
        while (lambdaExp != null) {
            if (!lambdaExp.getCanRead() && !lambdaExp.getInlineOnly()) {
                lambdaExp.compileAsMethod(compilation);
            }
            lambdaExp = lambdaExp.nextSibling;
        }
        if (this.heapFrame != null) {
            compilation.generateConstructor(this);
        }
    }

    public void generateApplyMethods(Compilation compilation) {
        compilation.generateMatchMethods(this);
        if (Compilation.defaultCallConvention >= 2) {
            compilation.generateApplyMethodsWithContext(this);
        } else {
            compilation.generateApplyMethodsWithoutContext(this);
        }
    }

    Field allocFieldFor(Compilation compilation) {
        Object object2;
        if (this.nameDecl != null && this.nameDecl.field != null) {
            return this.nameDecl.field;
        }
        boolean bl = this.getNeedsClosureEnv();
        ClassType classType = bl ? this.getOwningLambda().getHeapFrameType() : compilation.mainClass;
        String string = this.getName();
        String string2 = string == null ? "lambda" : Compilation.mangleNameIfNeeded(string);
        int n = 16;
        if (this.nameDecl != null && this.nameDecl.context instanceof ModuleExp) {
            boolean bl2 = this.nameDecl.needsExternalAccess();
            if (bl2) {
                string2 = "$Prvt$" + string2;
            }
            if (this.nameDecl.getFlag(2048)) {
                n |= 8;
                if (!((ModuleExp)this.nameDecl.context).isStatic()) {
                    n &= 0xFFFFFFEF;
                }
            }
            if (!this.nameDecl.isPrivate() || bl2 || compilation.immediate) {
                n |= 1;
            }
            if ((this.flags & 0x800) != 0) {
                int n2;
                object2 = string2;
                int n3 = n2 = this.min_args == this.max_args ? this.min_args : 1;
                while (classType.getDeclaredField(string2 = (String)object2 + '$' + n2++) != null) {
                }
            }
        } else {
            string2 = string2 + "$Fn" + ++compilation.localFieldIndex;
            if (!bl) {
                n |= 8;
            }
        }
        ClassType classType2 = Compilation.typeModuleMethod;
        object2 = classType.addField(string2, classType2, n);
        if (this.nameDecl != null) {
            this.nameDecl.field = object2;
        }
        return object2;
    }

    final void addApplyMethod(Compilation compilation, Field field) {
        LambdaExp lambdaExp = this;
        if (field != null && field.getStaticFlag()) {
            lambdaExp = compilation.getModule();
        } else {
            while (!((lambdaExp = lambdaExp.outerLambda()) instanceof ModuleExp) && lambdaExp.heapFrame == null) {
            }
            ClassType classType = lambdaExp.getHeapFrameType();
            if (!classType.getSuperclass().isSubtype(Compilation.typeModuleBody)) {
                lambdaExp = compilation.getModule();
            }
        }
        if (lambdaExp.applyMethods == null) {
            lambdaExp.applyMethods = new Vector();
        }
        lambdaExp.applyMethods.addElement(this);
    }

    public Field compileSetField(Compilation compilation) {
        Field field = this.allocFieldFor(compilation);
        if (compilation.usingCPStyle()) {
            this.compile(compilation, Type.objectType);
        } else {
            this.compileAsMethod(compilation);
            this.addApplyMethod(compilation, field);
        }
        return new ProcInitializer((LambdaExp)this, (Compilation)compilation, (Field)field).field;
    }

    public void compile(Compilation compilation, Target target) {
        if (target instanceof IgnoreTarget && (this.getInlineOnly() || !this.getCanRead())) {
            return;
        }
        CodeAttr codeAttr = compilation.getCode();
        LambdaExp lambdaExp = this.outerLambda();
        ClassType classType = Compilation.typeModuleMethod;
        if ((this.flags & 0x100) != 0 || compilation.immediate && lambdaExp instanceof ModuleExp) {
            this.compileAsMethod(compilation);
            this.addApplyMethod(compilation, null);
            ProcInitializer.emitLoadModuleMethod(this, compilation);
        } else {
            Field field = this.compileSetField(compilation);
            if (field.getStaticFlag()) {
                codeAttr.emitGetStatic(field);
            } else {
                LambdaExp lambdaExp2 = compilation.curLambda;
                Variable variable = lambdaExp2.heapFrame != null ? lambdaExp2.heapFrame : lambdaExp2.closureEnv;
                codeAttr.emitLoad(variable);
                codeAttr.emitGetField(field);
            }
        }
        target.compileFromStack(compilation, classType);
    }

    public ClassType getHeapFrameType() {
        if (this instanceof ModuleExp || this instanceof ClassExp) {
            return (ClassType)this.getType();
        }
        return (ClassType)this.heapFrame.getType();
    }

    public LambdaExp getOwningLambda() {
        ScopeExp scopeExp = this.outer;
        while (scopeExp != null) {
            if (scopeExp instanceof ModuleExp || scopeExp instanceof ClassExp && this.getNeedsClosureEnv() || scopeExp instanceof LambdaExp && ((LambdaExp)scopeExp).heapFrame != null) {
                return (LambdaExp)scopeExp;
            }
            scopeExp = scopeExp.outer;
        }
        return null;
    }

    void addMethodFor(Compilation compilation, ObjectType objectType) {
        ScopeExp scopeExp = this;
        while (scopeExp != null && !(scopeExp instanceof ClassExp)) {
            scopeExp = scopeExp.outer;
        }
        ClassType classType = scopeExp != null ? ((ClassExp)scopeExp).instanceType : this.getOwningLambda().getHeapFrameType();
        this.addMethodFor(classType, compilation, objectType);
    }

    void addMethodFor(ClassType classTypeArray, Compilation compilation, ObjectType objectType) {
        int n;
        int n2;
        Method[] methodArray;
        short s;
        int n3;
        Object object2;
        int n4;
        boolean bl;
        int n5;
        int n6;
        int n7;
        LambdaExp lambdaExp;
        String string;
        block57: {
            boolean bl2;
            string = this.getName();
            lambdaExp = this.outerLambda();
            n7 = this.keywords == null ? 0 : this.keywords.length;
            n6 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n7;
            n5 = (this.flags & 0x200) != 0 ? 0 : n6;
            bl = this.max_args < 0 || this.min_args + n5 < this.max_args;
            Method[] methodArray2 = new Method[n5 + 1];
            this.primBodyMethods = methodArray2;
            if (this.primMethods == null) {
                this.primMethods = methodArray2;
            }
            n4 = 0;
            if (this.nameDecl != null && this.nameDecl.getFlag(4096)) {
                bl2 = false;
            } else if (this.nameDecl != null && this.nameDecl.getFlag(2048)) {
                bl2 = true;
            } else if (this.isClassMethod()) {
                if (lambdaExp instanceof ClassExp) {
                    object2 = (ClassExp)lambdaExp;
                    boolean bl3 = bl2 = ((ClassExp)object2).isMakingClassPair() && objectType != null;
                    if (this == ((ClassExp)object2).initMethod) {
                        n4 = 73;
                    } else if (this == ((ClassExp)object2).clinitMethod) {
                        n4 = 67;
                        bl2 = true;
                    }
                } else {
                    bl2 = false;
                }
            } else {
                bl2 = this.thisVariable != null || objectType == classTypeArray ? false : (this.nameDecl != null && this.nameDecl.context instanceof ModuleExp ? ((ModuleExp)(object2 = (ModuleExp)this.nameDecl.context)).getSuperType() == null && ((ModuleExp)object2).getInterfaces() == null : true);
            }
            object2 = new StringBuffer(60);
            int n8 = n3 = bl2 ? 8 : 0;
            if (this.nameDecl != null) {
                if (this.nameDecl.needsExternalAccess()) {
                    n3 |= 1;
                } else {
                    short s2 = s = this.nameDecl.isPrivate() ? (short)0 : 1;
                    if (this.isClassMethod()) {
                        s = this.nameDecl.getAccessFlags(s);
                    }
                    n3 |= s;
                }
            }
            if (!lambdaExp.isModuleBody() && !(lambdaExp instanceof ClassExp) || string == null) {
                ((StringBuffer)object2).append("lambda");
                ((StringBuffer)object2).append(++compilation.method_counter);
            }
            if (n4 == 67) {
                ((StringBuffer)object2).append("<clinit>");
            } else if (this.getSymbol() != null) {
                ((StringBuffer)object2).append(Compilation.mangleName(string));
            }
            if (this.getFlag(1024)) {
                ((StringBuffer)object2).append("$C");
            }
            short s3 = s = this.getCallConvention() >= 2 && n4 == 0 ? (short)1 : 0;
            if (n4 != 0) {
                n3 = bl2 ? (n3 & 0xFFFFFFFD) + 1 : (n3 & 2) + 2;
            }
            if (classTypeArray.isInterface() || this.isAbstract()) {
                n3 |= 0x400;
            }
            if (!this.isClassMethod() || !(lambdaExp instanceof ClassExp) || this.min_args != this.max_args) break block57;
            methodArray = null;
            n2 = 0;
            Declaration declaration = this.firstDecl();
            block0: while (true) {
                block56: {
                    Object object3;
                    block59: {
                        block60: {
                            block58: {
                                if (declaration != null) break block58;
                                if (this.returnType != null) {
                                    break;
                                }
                                break block59;
                            }
                            if (!declaration.isThisParameter()) break block60;
                            --n2;
                            break block56;
                        }
                        if (declaration.getFlag(8192)) break block56;
                    }
                    if (methodArray == null) {
                        object3 = ((StringBuffer)object2).toString();
                        Filter filter = new Filter((String)object3){
                            final /* synthetic */ String val$mangled;
                            {
                                this.val$mangled = string;
                            }

                            public boolean select(Object object2) {
                                Method method = (Method)object2;
                                if (!method.getName().equals(this.val$mangled)) {
                                    return false;
                                }
                                Type[] typeArray = method.getParameterTypes();
                                return typeArray.length == LambdaExp.this.min_args;
                            }
                        };
                        methodArray = classTypeArray.getMethods(filter, 2);
                    }
                    object3 = null;
                    n = methodArray.length;
                    while (--n >= 0) {
                        Type type;
                        PrimType primType = methodArray[n];
                        Type type2 = type = declaration == null ? ((Method)((Object)primType)).getReturnType() : ((Method)((Object)primType)).getParameterTypes()[n2];
                        if (object3 == null) {
                            object3 = type;
                            continue;
                        }
                        if (type == object3) continue;
                        if (declaration == null) {
                            break block0;
                        }
                        break block56;
                    }
                    if (object3 != null) {
                        if (declaration != null) {
                            declaration.setType((Type)object3);
                        } else {
                            this.setCoercedReturnType((Type)object3);
                        }
                    }
                    if (declaration == null) break;
                }
                declaration = declaration.nextDecl();
                ++n2;
            }
        }
        methodArray = this.getFlag(1024) || this.getCallConvention() >= 2 ? Type.voidType : this.getReturnType().getImplementationType();
        n2 = objectType != null && objectType != classTypeArray ? 1 : 0;
        int n9 = 0;
        if (this.getCallConvention() >= 2 && n4 == 0) {
            n9 = 1;
        }
        int n10 = ((StringBuffer)object2).length();
        for (n = 0; n <= n5; ++n) {
            ClassType[] classTypeArray2;
            Object object4;
            Declaration declaration;
            int n11;
            ((StringBuffer)object2).setLength(n10);
            int n12 = n11 = this.min_args + n;
            if (n == n5 && bl) {
                ++n12;
            }
            Type[] typeArray = new Type[n2 + n12 + n9];
            if (n2 > 0) {
                typeArray[0] = objectType;
            }
            if ((declaration = this.firstDecl()) != null && declaration.isThisParameter()) {
                declaration = declaration.nextDecl();
            }
            int n13 = 0;
            while (n13 < n11) {
                typeArray[n2 + n13++] = declaration.getType().getImplementationType();
                declaration = declaration.nextDecl();
            }
            if (n9 != 0) {
                typeArray[typeArray.length - 1] = Compilation.typeCallContext;
            }
            if (n11 < n12) {
                Type type = declaration.getType();
                object4 = type.getName();
                if (classTypeArray.getClassfileVersion() >= 0x310000 && "java.lang.Object[]".equals(object4)) {
                    n3 |= 0x80;
                } else {
                    ((StringBuffer)object2).append("$V");
                }
                if (n7 > 0 || n5 < n6 || !"gnu.lists.LList".equals(object4) && !"java.lang.Object[]".equals(object4)) {
                    type = Compilation.objArrayType;
                    this.argsArray = new Variable("argsArray", Compilation.objArrayType);
                    this.argsArray.setParameter(true);
                }
                this.firstArgsArrayArg = declaration;
                typeArray[typeArray.length - (s != 0 ? 2 : 1)] = type;
            }
            if (s != 0) {
                ((StringBuffer)object2).append("$X");
            }
            n13 = lambdaExp instanceof ClassExp || lambdaExp instanceof ModuleExp && ((ModuleExp)lambdaExp).getFlag(65536) ? 1 : 0;
            string = ((StringBuffer)object2).toString();
            int n14 = 0;
            int n15 = ((StringBuffer)object2).length();
            block4: while (true) {
                for (classTypeArray2 = classTypeArray; classTypeArray2 != null; classTypeArray2 = classTypeArray2.getSuperclass()) {
                    if (classTypeArray2.getDeclaredMethod(string, typeArray) != null) {
                        ((StringBuffer)object2).setLength(n15);
                        ((StringBuffer)object2).append('$');
                        ((StringBuffer)object2).append(++n14);
                        string = ((StringBuffer)object2).toString();
                        continue;
                    }
                    if (n13 != 0) break block4;
                }
                break;
            }
            methodArray2[n] = object4 = classTypeArray.addMethod(string, typeArray, (Type)methodArray, n3);
            if (this.throwsSpecification == null || this.throwsSpecification.length <= 0) continue;
            n15 = this.throwsSpecification.length;
            classTypeArray2 = new ClassType[n15];
            for (int i = 0; i < n15; ++i) {
                Object object5;
                ClassType classType = null;
                Declaration declaration2 = this.throwsSpecification[i].getBinding();
                if (declaration2 != null) {
                    object5 = declaration2.getValue();
                    if (object5 instanceof ClassExp) {
                        classType = ((ClassExp)object5).getCompiledClassType(compilation);
                    } else {
                        compilation.error('e', "throws specification " + declaration2.getName() + " has non-class lexical binding");
                    }
                }
                if (classType == null) {
                    object5 = this.throwsSpecification[i].getName();
                    int n16 = ((String)object5).length();
                    if (n16 > 2 && ((String)object5).charAt(0) == '<' && ((String)object5).charAt(n16 - 1) == '>') {
                        object5 = ((String)object5).substring(1, n16 - 1);
                    }
                    classType = ClassType.make((String)object5);
                }
                classTypeArray2[i] = classType;
            }
            ExceptionsAttr exceptionsAttr = new ExceptionsAttr((Method)object4);
            exceptionsAttr.setExceptions(classTypeArray2);
        }
    }

    public void allocChildClasses(Compilation compilation) {
        Method method = this.getMainMethod();
        if (method != null && !method.getStaticFlag()) {
            this.declareThis(method.getDeclaringClass());
        }
        Declaration declaration = this.firstDecl();
        while (true) {
            Variable variable;
            if (declaration == this.firstArgsArrayArg && this.argsArray != null) {
                this.getVarScope().addVariable(this.argsArray);
            }
            if (!this.getInlineOnly() && this.getCallConvention() >= 2 && (this.firstArgsArrayArg == null ? declaration == null : (this.argsArray != null ? declaration == this.firstArgsArrayArg : declaration == this.firstArgsArrayArg.nextDecl()))) {
                variable = this.getVarScope().addVariable(null, Compilation.typeCallContext, "$ctx");
                variable.setParameter(true);
            }
            if (declaration == null) break;
            variable = declaration.var;
            if (!(variable != null || this.getInlineOnly() && declaration.ignorable())) {
                if (declaration.isSimple() && !declaration.isIndirectBinding()) {
                    variable = declaration.allocateVariable(null);
                } else {
                    String string = Compilation.mangleName(declaration.getName()).intern();
                    Type type = declaration.getType().getImplementationType();
                    variable = declaration.var = this.getVarScope().addVariable(null, type, string);
                    variable.setParameter(true);
                }
            }
            declaration = declaration.nextDecl();
        }
        this.declareClosureEnv();
        this.allocFrame(compilation);
        this.allocChildMethods(compilation);
    }

    void allocChildMethods(Compilation compilation) {
        LambdaExp lambdaExp = this.firstChild;
        while (lambdaExp != null) {
            Object object2;
            Object object3;
            if (!lambdaExp.isClassGenerated() && !lambdaExp.getInlineOnly()) {
                if (!lambdaExp.getNeedsClosureEnv()) {
                    object3 = null;
                } else if (this instanceof ClassExp || this instanceof ModuleExp) {
                    object3 = this.getCompiledClassType(compilation);
                } else {
                    object2 = this;
                    while (((LambdaExp)object2).heapFrame == null) {
                        object2 = ((LambdaExp)object2).outerLambda();
                    }
                    object3 = (ClassType)((LambdaExp)object2).heapFrame.getType();
                }
                lambdaExp.addMethodFor(compilation, (ObjectType)object3);
            }
            if (lambdaExp instanceof ClassExp && ((LambdaExp)(object3 = (ClassExp)lambdaExp)).getNeedsClosureEnv()) {
                if (this instanceof ModuleExp || this instanceof ClassExp) {
                    object2 = (ClassType)this.getType();
                } else {
                    Variable variable = this.heapFrame != null ? this.heapFrame : this.closureEnv;
                    object2 = (ClassType)variable.getType();
                }
                ((ClassExp)object3).closureEnvField = ((ClassExp)object3).staticLinkField = ((ClassExp)object3).instanceType.setOuterLink((ClassType)object2);
            }
            lambdaExp = lambdaExp.nextSibling;
        }
    }

    public void allocFrame(Compilation compilation) {
        if (this.heapFrame != null) {
            ClassType classType;
            if (this instanceof ModuleExp || this instanceof ClassExp) {
                classType = this.getCompiledClassType(compilation);
            } else {
                classType = new ClassType(compilation.generateClassName("frame"));
                classType.setSuper(compilation.getModuleType());
                compilation.addClass(classType);
            }
            this.heapFrame.setType(classType);
        }
    }

    void allocParameters(Compilation compilation) {
        CodeAttr codeAttr = compilation.getCode();
        int n = 0;
        int n2 = 0;
        codeAttr.locals.enterScope(this.getVarScope());
        int n3 = this.getLineNumber();
        if (n3 > 0) {
            codeAttr.putLineNumber(this.getFileName(), n3);
        }
        for (Declaration declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            if (this.argsArray != null && this.min_args == this.max_args && this.primMethods == null && this.getCallConvention() < 2) {
                codeAttr.emitLoad(this.argsArray);
                codeAttr.emitPushInt(n2);
                codeAttr.emitArrayLoad(Type.objectType);
                declaration.getType().emitCoerceFromObject(codeAttr);
                codeAttr.emitStore(declaration.getVariable());
            }
            ++n2;
            ++n;
        }
        if (this.heapFrame != null) {
            this.heapFrame.allocateLocal(codeAttr);
        }
    }

    void enterFunction(Compilation compilation) {
        int n;
        Object object2;
        Object object3;
        CodeAttr codeAttr = compilation.getCode();
        this.getVarScope().noteStartFunction(codeAttr);
        if (this.closureEnv != null && !this.closureEnv.isParameter() && !compilation.usingCPStyle()) {
            if (!this.getInlineOnly()) {
                codeAttr.emitPushThis();
                object3 = this.closureEnvField;
                if (object3 == null) {
                    object3 = this.outerLambda().closureEnvField;
                }
                codeAttr.emitGetField((Field)object3);
                codeAttr.emitStore(this.closureEnv);
            } else if (!this.inlinedIn(this.outerLambda())) {
                this.outerLambda().loadHeapFrame(compilation);
                codeAttr.emitStore(this.closureEnv);
            }
        }
        if (!compilation.usingCPStyle()) {
            object3 = this.heapFrame == null ? this.currentModule().getCompiledClassType(compilation) : (ClassType)this.heapFrame.getType();
            object2 = this.capturedVars;
            while (object2 != null) {
                if (((Declaration)object2).field == null) {
                    ((Declaration)object2).makeField((ClassType)object3, compilation, null);
                }
                object2 = ((Declaration)object2).nextCapturedVar;
            }
        }
        if (this.heapFrame != null && !compilation.usingCPStyle()) {
            object3 = (ClassType)this.heapFrame.getType();
            if (this.closureEnv != null && !(this instanceof ModuleExp)) {
                this.staticLinkField = ((ClassType)object3).addField("staticLink", this.closureEnv.getType());
            }
            if (!(this instanceof ModuleExp) && !(this instanceof ClassExp)) {
                ((ClassType)object3).setEnclosingMember(compilation.method);
                codeAttr.emitNew((ClassType)object3);
                codeAttr.emitDup((Type)object3);
                object2 = Compilation.getConstructor((ClassType)object3, this);
                codeAttr.emitInvokeSpecial((Method)object2);
                if (this.staticLinkField != null) {
                    codeAttr.emitDup((Type)object3);
                    codeAttr.emitLoad(this.closureEnv);
                    codeAttr.emitPutField(this.staticLinkField);
                }
                codeAttr.emitStore(this.heapFrame);
            }
        }
        object3 = this.argsArray;
        if (this.min_args == this.max_args && !Compilation.fewerClasses && this.primMethods == null && this.getCallConvention() < 2) {
            object3 = null;
        }
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.keywords == null ? 0 : this.keywords.length;
        int n6 = n = this.defaultArgs == null ? 0 : this.defaultArgs.length - n5;
        if (this instanceof ModuleExp) {
            return;
        }
        int n7 = -1;
        int n8 = 0;
        Method method = this.getMainMethod();
        Variable variable = compilation.callContextVar;
        for (Declaration declaration = this.firstDecl(); declaration != null; declaration = declaration.nextDecl()) {
            Variable variable2 = compilation.callContextVar = this.getCallConvention() < 2 ? null : this.getVarScope().lookup("$ctx");
            if (declaration == this.firstArgsArrayArg && object3 != null) {
                if (this.primMethods != null) {
                    n7 = n2;
                    n8 = n7 - this.min_args;
                } else {
                    n7 = 0;
                    n8 = 0;
                }
            }
            if (n7 >= 0 || !declaration.isSimple() || declaration.isIndirectBinding()) {
                Type type;
                Type type2 = declaration.getType();
                Type type3 = type = method == null || n7 >= 0 ? Type.objectType : type2;
                if (!declaration.isSimple()) {
                    declaration.loadOwningObject(null, compilation);
                }
                if (n7 < 0) {
                    codeAttr.emitLoad(declaration.getVariable());
                } else if (n2 < this.min_args) {
                    codeAttr.emitLoad((Variable)object3);
                    codeAttr.emitPushInt(n2);
                    codeAttr.emitArrayLoad(Type.objectType);
                } else if (n2 < this.min_args + n) {
                    codeAttr.emitPushInt(n2 - n7);
                    codeAttr.emitLoad((Variable)object3);
                    codeAttr.emitArrayLength();
                    codeAttr.emitIfIntLt();
                    codeAttr.emitLoad((Variable)object3);
                    codeAttr.emitPushInt(n2 - n7);
                    codeAttr.emitArrayLoad();
                    codeAttr.emitElse();
                    this.defaultArgs[n8 + n3++].compile(compilation, type2);
                    codeAttr.emitFi();
                } else if (this.max_args < 0 && n2 == this.min_args + n) {
                    codeAttr.emitLoad((Variable)object3);
                    codeAttr.emitPushInt(n2 - n7);
                    codeAttr.emitInvokeStatic(Compilation.makeListMethod);
                    type = Compilation.scmListType;
                } else {
                    Type[] typeArray;
                    codeAttr.emitLoad((Variable)object3);
                    codeAttr.emitPushInt(this.min_args + n - n7);
                    compilation.compileConstant(this.keywords[n4++]);
                    Expression expression = this.defaultArgs[n8 + n3++];
                    if (expression instanceof QuoteExp) {
                        if (searchForKeywordMethod4 == null) {
                            typeArray = new Type[]{Compilation.objArrayType, Type.intType, Type.objectType, Type.objectType};
                            searchForKeywordMethod4 = Compilation.scmKeywordType.addMethod("searchForKeyword", typeArray, Type.objectType, 9);
                        }
                        expression.compile(compilation, type2);
                        codeAttr.emitInvokeStatic(searchForKeywordMethod4);
                    } else {
                        if (searchForKeywordMethod3 == null) {
                            typeArray = new Type[]{Compilation.objArrayType, Type.intType, Type.objectType};
                            searchForKeywordMethod3 = Compilation.scmKeywordType.addMethod("searchForKeyword", typeArray, Type.objectType, 9);
                        }
                        codeAttr.emitInvokeStatic(searchForKeywordMethod3);
                        codeAttr.emitDup(1);
                        compilation.compileConstant(Special.dfault);
                        codeAttr.emitIfEq();
                        codeAttr.emitPop(1);
                        expression.compile(compilation, type2);
                        codeAttr.emitFi();
                    }
                }
                if (type2 != type) {
                    CheckedTarget.emitCheckedCoerce(compilation, this, n2 + 1, type2);
                }
                if (declaration.isIndirectBinding()) {
                    declaration.pushIndirectBinding(compilation);
                }
                if (declaration.isSimple()) {
                    codeAttr.emitStore(declaration.getVariable());
                } else {
                    codeAttr.emitPutField(declaration.field);
                }
            }
            ++n2;
        }
        compilation.callContextVar = variable;
    }

    void compileAsMethod(Compilation compilation) {
        int n;
        if ((this.flags & 0x80) != 0 || this.isAbstract()) {
            return;
        }
        this.flags |= 0x80;
        if (this.primMethods == null) {
            return;
        }
        Method method = compilation.method;
        LambdaExp lambdaExp = compilation.curLambda;
        compilation.curLambda = this;
        Method method2 = this.primMethods[0];
        boolean bl = method2.getStaticFlag();
        int n2 = this.primMethods.length - 1;
        Type type = this.restArgType();
        int[] nArray = null;
        if (n2 > 0) {
            nArray = new int[this.min_args + n2];
            n = 0;
            Declaration declaration = this.firstDecl();
            while (n < this.min_args + n2) {
                nArray[n++] = declaration.flags;
                declaration = declaration.nextDecl();
            }
        }
        n = this.getCallConvention() >= 2 ? 1 : 0;
        for (int i = 0; i <= n2; ++i) {
            compilation.method = this.primMethods[i];
            if (i < n2) {
                Object object2;
                int n3;
                CodeAttr codeAttr = compilation.method.startCode();
                for (n3 = i + 1; n3 < n2 && this.defaultArgs[n3] instanceof QuoteExp; ++n3) {
                }
                boolean bl2 = n3 == n2 && type != null;
                Variable variable = compilation.callContextVar;
                Variable variable2 = codeAttr.getArg(0);
                if (!bl) {
                    codeAttr.emitPushThis();
                    if (this.getNeedsClosureEnv()) {
                        this.closureEnv = variable2;
                    }
                    variable2 = codeAttr.getArg(1);
                }
                Declaration declaration = this.firstDecl();
                int n4 = 0;
                while (n4 < this.min_args + i) {
                    declaration.flags |= 0x40;
                    declaration.var = variable2;
                    codeAttr.emitLoad(variable2);
                    variable2 = variable2.nextVar();
                    ++n4;
                    declaration = declaration.nextDecl();
                }
                compilation.callContextVar = n != 0 ? variable2 : null;
                n4 = i;
                while (n4 < n3) {
                    object2 = StackTarget.getInstance(declaration.getType());
                    this.defaultArgs[n4].compile(compilation, (Target)object2);
                    ++n4;
                    declaration = declaration.nextDecl();
                }
                if (bl2) {
                    QuoteExp quoteExp;
                    object2 = type.getName();
                    if ("gnu.lists.LList".equals(object2)) {
                        quoteExp = new QuoteExp(LList.Empty);
                    } else if ("java.lang.Object[]".equals(object2)) {
                        quoteExp = new QuoteExp(Values.noArgs);
                    } else {
                        throw new Error("unimplemented #!rest type " + (String)object2);
                    }
                    quoteExp.compile(compilation, type);
                }
                if (n != 0) {
                    codeAttr.emitLoad(variable2);
                }
                if (bl) {
                    codeAttr.emitInvokeStatic(this.primMethods[n3]);
                } else {
                    codeAttr.emitInvokeVirtual(this.primMethods[n3]);
                }
                codeAttr.emitReturn();
                this.closureEnv = null;
                compilation.callContextVar = variable;
                continue;
            }
            if (nArray != null) {
                int n5 = 0;
                Declaration declaration = this.firstDecl();
                while (n5 < this.min_args + n2) {
                    declaration.flags = nArray[n5++];
                    declaration.var = null;
                    declaration = declaration.nextDecl();
                }
            }
            compilation.method.initCode();
            this.allocChildClasses(compilation);
            this.allocParameters(compilation);
            this.enterFunction(compilation);
            this.compileBody(compilation);
            this.compileEnd(compilation);
            this.generateApplyMethods(compilation);
        }
        compilation.method = method;
        compilation.curLambda = lambdaExp;
    }

    public void compileBody(Compilation compilation) {
        Target target;
        Variable variable = compilation.callContextVar;
        compilation.callContextVar = null;
        if (this.getCallConvention() >= 2) {
            Variable variable2 = this.getVarScope().lookup("$ctx");
            if (variable2 != null && variable2.getType() == Compilation.typeCallContext) {
                compilation.callContextVar = variable2;
            }
            target = ConsumerTarget.makeContextTarget(compilation);
        } else {
            target = Target.pushValue(this.getReturnType());
        }
        this.body.compileWithPosition(compilation, target, this.body.getLineNumber() > 0 ? this.body : this);
        compilation.callContextVar = variable;
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkLambdaExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.walkChildrenOnly(expWalker);
        this.walkProperties(expWalker);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void walkChildrenOnly(ExpWalker expWalker) {
        LambdaExp lambdaExp = expWalker.currentLambda;
        expWalker.currentLambda = this;
        try {
            expWalker.walkDefaultArgs(this);
            if (expWalker.exitValue == null && this.body != null) {
                this.body = expWalker.walk(this.body);
            }
        }
        finally {
            expWalker.currentLambda = lambdaExp;
        }
    }

    protected final void walkProperties(ExpWalker expWalker) {
        if (this.properties != null) {
            int n = this.properties.length;
            for (int i = 1; i < n; i += 2) {
                Object object2 = this.properties[i];
                if (!(object2 instanceof Expression)) continue;
                this.properties[i] = expWalker.walk((Expression)this.properties[i]);
            }
        }
    }

    protected boolean mustCompile() {
        if (this.keywords != null && this.keywords.length > 0) {
            return true;
        }
        if (this.defaultArgs != null) {
            int n = this.defaultArgs.length;
            while (--n >= 0) {
                Expression expression = this.defaultArgs[n];
                if (expression == null || expression instanceof QuoteExp) continue;
                return true;
            }
        }
        return false;
    }

    public void apply(CallContext callContext) throws Throwable {
        this.setIndexes();
        callContext.writeValue(new Closure(this, callContext));
    }

    Object evalDefaultArg(int n, CallContext callContext) {
        try {
            return this.defaultArgs[n].eval(callContext);
        }
        catch (Throwable throwable) {
            throw new WrappedException("error evaluating default argument", throwable);
        }
    }

    public Expression inline(ApplyExp applyExp, InlineCalls inlineCalls, Declaration declaration, boolean bl) {
        Method method;
        Expression[] expressionArray = applyExp.getArgs();
        if (!bl) {
            Expression expression;
            if ((this.flags & 0x1000) != 0 && (expression = InlineCalls.inlineCall(this, expressionArray, true)) != null) {
                return inlineCalls.walk(expression);
            }
            applyExp.args = inlineCalls.walkExps(applyExp.args, applyExp.args.length);
        }
        int n = applyExp.args.length;
        String string = WrongArguments.checkArgCount(this.getName(), this.min_args, this.max_args, n);
        if (string != null) {
            return inlineCalls.noteError(string);
        }
        int n2 = this.getCallConvention();
        Compilation compilation = inlineCalls.getCompilation();
        if (compilation.inlineOk(this) && this.isClassMethod() && (n2 <= 2 || n2 == 3) && (method = this.getMethod(n)) != null) {
            Expression expression;
            Expression[] expressionArray2;
            Procedure procedure;
            boolean bl2 = this.nameDecl.isStatic();
            if (bl2 || !(this.outer instanceof ClassExp) || ((ClassExp)(procedure = (ClassExp)this.outer)).isMakingClassPair()) {
                // empty if block
            }
            procedure = new PrimProcedure(method, this);
            if (bl2) {
                expressionArray2 = applyExp.args;
            } else {
                expression = inlineCalls.getCurrentLambda();
                while (true) {
                    if (expression == null) {
                        return inlineCalls.noteError("internal error: missing " + this);
                    }
                    if (((LambdaExp)expression).outer == this.outer) break;
                    expression = ((LambdaExp)expression).outerLambda();
                }
                Declaration declaration2 = ((ScopeExp)expression).firstDecl();
                if (declaration2 == null || !declaration2.isThisParameter()) {
                    return inlineCalls.noteError("calling non-static method " + this.getName() + " from static method " + expression.getName());
                }
                int n3 = applyExp.getArgCount();
                expressionArray2 = new Expression[1 + n3];
                System.arraycopy(applyExp.getArgs(), 0, expressionArray2, 1, n3);
                expressionArray2[0] = new ThisExp(declaration2);
            }
            expression = new ApplyExp(procedure, expressionArray2);
            return expression.setLine(applyExp);
        }
        return applyExp;
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock("(Lambda/", ")", 2);
        Object object2 = this.getSymbol();
        if (object2 != null) {
            outPort.print(object2);
            outPort.print('/');
        }
        outPort.print(this.id);
        outPort.print('/');
        outPort.print("fl:");
        outPort.print(Integer.toHexString(this.flags));
        outPort.writeSpaceFill();
        this.printLineColumn(outPort);
        outPort.startLogicalBlock("(", false, ")");
        Special special = null;
        int n = 0;
        int n2 = 0;
        int n3 = this.keywords == null ? 0 : this.keywords.length;
        int n4 = this.defaultArgs == null ? 0 : this.defaultArgs.length - n3;
        Declaration declaration = this.firstDecl();
        if (declaration != null && declaration.isThisParameter()) {
            n = -1;
        }
        while (declaration != null) {
            Special special2 = n < this.min_args ? null : (n < this.min_args + n4 ? Special.optional : (this.max_args < 0 && n == this.min_args + n4 ? Special.rest : Special.key));
            if (declaration != this.firstDecl()) {
                outPort.writeSpaceFill();
            }
            if (special2 != special) {
                outPort.print(special2);
                outPort.writeSpaceFill();
            }
            Expression expression = null;
            if (special2 == Special.optional || special2 == Special.key) {
                expression = this.defaultArgs[n2++];
            }
            if (expression != null) {
                outPort.print('(');
            }
            declaration.printInfo(outPort);
            if (expression != null && expression != QuoteExp.falseExp) {
                outPort.print(' ');
                expression.print(outPort);
                outPort.print(')');
            }
            ++n;
            special = special2;
            declaration = declaration.nextDecl();
        }
        outPort.endLogicalBlock(")");
        outPort.writeSpaceLinear();
        if (this.body == null) {
            outPort.print("<null body>");
        } else {
            this.body.print(outPort);
        }
        outPort.endLogicalBlock(")");
    }

    protected final String getExpClassName() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n >= 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    public String toString() {
        String string = this.getExpClassName() + ':' + this.getSymbol() + '/' + this.id + '/';
        int n = this.getLineNumber();
        if (n <= 0 && this.body != null) {
            n = this.body.getLineNumber();
        }
        if (n > 0) {
            string = string + "l:" + n;
        }
        return string;
    }

    public Object getProperty(Object object2, Object object3) {
        if (this.properties != null) {
            int n = this.properties.length;
            while ((n -= 2) >= 0) {
                if (this.properties[n] != object2) continue;
                return this.properties[n + 1];
            }
        }
        return object3;
    }

    public synchronized void setProperty(Object object2, Object object3) {
        this.properties = PropertySet.setProperty(this.properties, object2, object3);
    }

    public final Type getReturnType() {
        if (this.returnType == null) {
            this.returnType = Type.objectType;
            if (this.body != null && !this.isAbstract()) {
                this.returnType = this.body.getType();
            }
        }
        return this.returnType;
    }

    public final void setReturnType(Type type) {
        this.returnType = type;
    }

    public final void setCoercedReturnType(Type type) {
        this.returnType = type;
        if (type != null && type != Type.objectType && type != Type.voidType && this.body != QuoteExp.abstractExp) {
            Expression expression = this.body;
            this.body = Convert.makeCoercion(expression, type);
            this.body.setLine(expression);
        }
    }
}

