/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Field;
import gnu.bytecode.Location;
import gnu.bytecode.Method;
import gnu.bytecode.Type;
import gnu.bytecode.Variable;
import gnu.expr.AccessExp;
import gnu.expr.BindingInitializer;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.IgnoreTarget;
import gnu.expr.LambdaExp;
import gnu.expr.Language;
import gnu.expr.ModuleExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.Target;
import gnu.mapping.Environment;
import gnu.mapping.EnvironmentKey;
import gnu.mapping.OutPort;
import gnu.mapping.Symbol;
import gnu.mapping.Values;

public class SetExp
extends AccessExp {
    Expression new_value;
    public static final int DEFINING_FLAG = 1;
    public static final int GLOBAL_FLAG = 2;
    public static final int PREFER_BINDING2 = 4;
    public static final int PROCEDURE = 8;
    public static final int SET_IF_UNBOUND = 16;
    public static final int HAS_VALUE = 32;

    public SetExp(Object object2, Expression expression) {
        this.symbol = object2;
        this.new_value = expression;
    }

    public final Expression getNewValue() {
        return this.new_value;
    }

    public final boolean isDefining() {
        return (this.flags & 1) != 0;
    }

    public final void setDefining(boolean bl) {
        this.flags = bl ? (this.flags |= 1) : (this.flags &= 0xFFFFFFFE);
    }

    public final boolean getHasValue() {
        return (this.flags & 0x20) != 0;
    }

    public final void setHasValue(boolean bl) {
        this.flags = bl ? (this.flags |= 0x20) : (this.flags &= 0xFFFFFFDF);
    }

    public final boolean isFuncDef() {
        return (this.flags & 8) != 0;
    }

    public final void setFuncDef(boolean bl) {
        this.flags = bl ? (this.flags |= 8) : (this.flags &= 0xFFFFFFF7);
    }

    public final boolean isSetIfUnbound() {
        return (this.flags & 0x10) != 0;
    }

    public final void setSetIfUnbound(boolean bl) {
        this.flags = bl ? (this.flags |= 0x10) : (this.flags &= 0xFFFFFFEF);
    }

    public SetExp(Declaration declaration, Expression expression) {
        this.binding = declaration;
        this.symbol = declaration.getSymbol();
        this.new_value = expression;
    }

    public Object eval(Environment environment) throws Throwable {
        Symbol symbol = this.symbol instanceof Symbol ? (Symbol)this.symbol : environment.getSymbol(this.symbol.toString());
        Object object2 = null;
        Language language = Language.getDefaultLanguage();
        if (this.isFuncDef() && language.hasSeparateFunctionNamespace()) {
            object2 = EnvironmentKey.FUNCTION;
        }
        if (this.binding != null && !(this.binding.context instanceof ModuleExp)) {
            throw new Error("internal error - SetExp.eval with lexical binding");
        }
        if (this.isSetIfUnbound()) {
            gnu.mapping.Location location2 = environment.getLocation(symbol, object2);
            if (!location2.isBound()) {
                location2.set(this.new_value.eval(environment));
            }
            if (this.getHasValue()) {
                return location2;
            }
            return language.noValue();
        }
        Object object3 = this.new_value.eval(environment);
        if (this.isDefining()) {
            environment.define(symbol, object2, object3);
        } else {
            environment.put(symbol, object2, object3);
        }
        return this.getHasValue() ? object3 : language.noValue();
    }

    public void compile(Compilation compilation, Target target) {
        if (this.new_value instanceof LambdaExp && target instanceof IgnoreTarget && ((LambdaExp)this.new_value).getInlineOnly()) {
            return;
        }
        CodeAttr codeAttr = compilation.getCode();
        boolean bl = this.getHasValue() && !(target instanceof IgnoreTarget);
        boolean bl2 = false;
        Declaration declaration = this.binding;
        Expression expression = declaration.getValue();
        if (declaration.getFlag(0x20000000) && this.isDefining() && !declaration.ignorable()) {
            BindingInitializer.create(declaration, this.new_value, compilation);
        } else if (expression instanceof LambdaExp && declaration.context instanceof ModuleExp && (!declaration.isPrivate() || expression instanceof ClassExp) && ((LambdaExp)expression).getName() != null && expression == this.new_value) {
            ((LambdaExp)this.new_value).compileSetField(compilation);
        } else if (declaration.context instanceof ModuleExp && (this.new_value instanceof QuoteExp || declaration.getFlag(16384) || declaration.isAlias()) && this.isDefining() && expression != null) {
            if (bl) {
                declaration.load(this.contextDecl(), 0, compilation, Target.pushObject);
                bl2 = true;
            }
        } else {
            Object object2;
            Object object3;
            Declaration declaration2 = this.contextDecl();
            if (!this.isDefining()) {
                while (declaration != null && declaration.isAlias() && (expression = declaration.getValue()) instanceof ReferenceExp) {
                    object3 = (ReferenceExp)expression;
                    object2 = ((ReferenceExp)object3).binding;
                    if (object2 == null || declaration2 != null && ((Declaration)object2).needsContext()) break;
                    declaration2 = ((AccessExp)object3).contextDecl();
                    declaration = object2;
                }
            }
            if (declaration.ignorable()) {
                this.new_value.compile(compilation, Target.Ignore);
            } else if (declaration.isAlias() && this.isDefining()) {
                declaration.load(this.contextDecl(), 1, compilation, Target.pushObject);
                object3 = ClassType.make("gnu.mapping.IndirectableLocation");
                codeAttr.emitCheckcast((Type)object3);
                this.new_value.compile(compilation, Target.pushObject);
                object2 = ((ClassType)object3).getDeclaredMethod("setAlias", 1);
                codeAttr.emitInvokeVirtual((Method)object2);
            } else if (declaration.isIndirectBinding()) {
                declaration.load(declaration2, 1, compilation, Target.pushObject);
                if (this.isSetIfUnbound()) {
                    if (bl) {
                        codeAttr.emitDup();
                        bl2 = true;
                    }
                    codeAttr.pushScope();
                    codeAttr.emitDup();
                    object3 = codeAttr.addLocal(Compilation.typeLocation);
                    codeAttr.emitStore((Variable)object3);
                    codeAttr.emitInvokeVirtual(Compilation.typeLocation.getDeclaredMethod("isBound", 0));
                    codeAttr.emitIfIntEqZero();
                    codeAttr.emitLoad((Variable)object3);
                }
                this.new_value.compile(compilation, Target.pushObject);
                if (bl && !this.isSetIfUnbound()) {
                    codeAttr.emitDupX();
                    bl2 = true;
                }
                object3 = "set";
                codeAttr.emitInvokeVirtual(Compilation.typeLocation.getDeclaredMethod((String)object3, 1));
                if (this.isSetIfUnbound()) {
                    codeAttr.emitFi();
                    codeAttr.popScope();
                }
            } else if (declaration.isSimple()) {
                Type type = declaration.getType();
                this.new_value.compile(compilation, type);
                if (bl) {
                    codeAttr.emitDup(type);
                    bl2 = true;
                }
                if ((object3 = declaration.getVariable()) == null) {
                    object3 = declaration.allocateVariable(codeAttr);
                }
                codeAttr.emitStore((Variable)object3);
            } else if (declaration.context instanceof ClassExp && declaration.field == null && !this.getFlag(8) && ((ClassExp)declaration.context).isMakingClassPair()) {
                object3 = ClassExp.slotToMethodName("set", declaration.getName());
                object2 = (ClassExp)declaration.context;
                Method method = ((ClassExp)object2).type.getDeclaredMethod((String)object3, 1);
                ((LambdaExp)object2).loadHeapFrame(compilation);
                this.new_value.compile(compilation, declaration.getType());
                if (bl) {
                    codeAttr.emitDupX();
                    bl2 = true;
                }
                codeAttr.emitInvoke(method);
            } else {
                object3 = declaration.field;
                if (!((Field)object3).getStaticFlag()) {
                    declaration.loadOwningObject(declaration2, compilation);
                }
                Type type = ((Location)object3).getType();
                this.new_value.compile(compilation, type);
                if (((Field)object3).getStaticFlag()) {
                    if (bl) {
                        codeAttr.emitDup(type);
                        bl2 = true;
                    }
                    codeAttr.emitPutStatic((Field)object3);
                } else {
                    if (bl) {
                        codeAttr.emitDupX();
                        bl2 = true;
                    }
                    codeAttr.emitPutField((Field)object3);
                }
            }
        }
        if (bl && !bl2) {
            throw new Error("SetExp.compile: not implemented - return value");
        }
        if (bl) {
            target.compileFromStack(compilation, this.getType());
        } else {
            compilation.compileConstant(Values.empty, target);
        }
    }

    public final Type getType() {
        return !this.getHasValue() ? Type.void_type : (this.binding == null ? Type.pointer_type : this.binding.getType());
    }

    protected Expression walk(ExpWalker expWalker) {
        return expWalker.walkSetExp(this);
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.new_value = expWalker.walk(this.new_value);
    }

    public void print(OutPort outPort) {
        outPort.startLogicalBlock(this.isDefining() ? "(Define" : "(Set", ")", 2);
        outPort.writeSpaceFill();
        this.printLineColumn(outPort);
        if (this.binding == null || this.symbol.toString() != this.binding.getName()) {
            outPort.print('/');
            outPort.print(this.symbol);
        }
        if (this.binding != null) {
            outPort.print('/');
            outPort.print(this.binding);
        }
        outPort.writeSpaceLinear();
        this.new_value.print(outPort);
        outPort.endLogicalBlock(")");
    }

    public String toString() {
        return "SetExp[" + this.symbol + ":=" + this.new_value + ']';
    }
}

