/*
 * Decompiled with CFR 0.152.
 */
package gnu.jemacs.buffer;

import gnu.jemacs.buffer.Buffer;
import gnu.jemacs.buffer.CancelledException;
import gnu.jemacs.buffer.Command;
import gnu.jemacs.buffer.EFrame;
import gnu.jemacs.buffer.EKeymap;
import gnu.lists.LList;
import gnu.mapping.Procedure;
import gnu.mapping.Symbol;
import gnu.mapping.WrappedException;

public abstract class EWindow {
    public EFrame frame;
    public Buffer buffer;
    protected int[] pendingKeys = null;
    protected int pendingLength = 0;
    protected EWindow prevWindow;
    protected EWindow nextWindow;
    protected int charHeight;
    protected int charWidth;

    public EWindow(Buffer buffer) {
        this.buffer = buffer;
        this.nextWindow = this;
        this.prevWindow = this;
    }

    public static EWindow getSelected() {
        return EFrame.selectedFrame == null ? null : EFrame.selectedFrame.selectedWindow;
    }

    public void setSelected() {
        EWindow selected = EWindow.getSelected();
        if (selected != null && selected.buffer != this.buffer) {
            selected.unselect();
        }
        if (this.frame != null) {
            this.frame.selectedWindow = this;
        }
        EFrame.selectedFrame = this.frame;
        Buffer.setCurrent(this.buffer);
    }

    public abstract void unselect();

    public static void setSelected(EWindow window) {
        window.setSelected();
        window.requestFocus();
    }

    public void requestFocus() {
    }

    public EFrame getFrame() {
        return this.frame;
    }

    public final void setFrame(EFrame frame71) {
        this.frame = frame71;
    }

    public Buffer getBuffer() {
        return this.buffer;
    }

    public void setBuffer(Buffer buffer) {
        this.buffer = buffer;
    }

    public abstract int getPoint();

    public final void setPoint(int point) {
        this.setDot(point - 1);
    }

    public abstract void setDot(int var1);

    public final EWindow split(int lines, boolean horizontal) {
        return this.split(this.buffer, lines, horizontal);
    }

    public abstract EWindow split(Buffer var1, int var2, boolean var3);

    protected final void linkSibling(EWindow window, boolean horizontal) {
        EWindow next;
        this.nextWindow = window;
        window.prevWindow = this;
        window.nextWindow = next = this.nextWindow;
        next.prevWindow = window;
    }

    protected final void unlink() {
        if (this.frame.firstWindow == this) {
            this.frame.firstWindow = this.nextWindow == this ? null : this.nextWindow;
        }
        this.nextWindow.prevWindow = this.prevWindow;
        this.prevWindow.nextWindow = this.nextWindow;
        this.prevWindow = this;
        this.nextWindow = this;
    }

    public EWindow getNextWindow(boolean forwards) {
        return this.nextWindow;
    }

    public final EWindow getOtherWindow(boolean forwards) {
        EWindow win = this.getNextWindow(forwards);
        return win;
    }

    public final EWindow getNextWindowInFrame(int count) {
        EWindow win = this;
        if (count > 0) {
            while (--count >= 0) {
                win = win.getOtherWindow(true);
            }
        } else {
            while (++count <= 0) {
                win = win.getOtherWindow(false);
            }
        }
        return win;
    }

    public void delete() {
        EFrame frame71 = this.frame;
        this.deleteNoValidate();
        if (frame71.getFirstWindow() == null) {
            frame71.delete();
        } else {
            frame71.validate();
        }
    }

    protected void deleteNoValidate() {
        if (this.frame.selectedWindow == this) {
            EWindow next = this.getNextWindowInFrame(1);
            if (this.frame == EFrame.selectedFrame) {
                EWindow.setSelected(next);
            } else {
                this.frame.selectedWindow = next;
            }
        }
        this.unlink();
        this.frame = null;
    }

    public void deleteOtherWindows() {
        EWindow cur = this.frame.getFirstWindow();
        while (cur != null) {
            EWindow next = cur.getNextWindow(true);
            if (cur != this) {
                cur.deleteNoValidate();
            }
            cur = next;
        }
        this.frame.validate();
    }

    protected abstract void getCharSize();

    public abstract int getWidth();

    public abstract int getHeight();

    public int getHeightInLines() {
        if (this.charHeight == 0) {
            this.getCharSize();
        }
        return this.getHeight() / this.charHeight;
    }

    public int getWidthInColumns() {
        if (this.charWidth == 0) {
            this.getCharSize();
        }
        return this.getWidth() / this.charWidth;
    }

    public String toString() {
        StringBuffer sbuf = new StringBuffer(100);
        sbuf.append("#<window on ");
        if (this.buffer == null) {
            sbuf.append("no buffer");
        } else {
            sbuf.append('\"');
            sbuf.append(this.buffer.getName());
            sbuf.append('\"');
        }
        sbuf.append(" 0x");
        sbuf.append(Integer.toHexString(System.identityHashCode(this)));
        sbuf.append('>');
        return sbuf.toString();
    }

    public void pushPrefix(int prefix) {
        if (this.pendingKeys == null) {
            this.pendingKeys = new int[10];
        }
        this.pendingKeys[this.pendingLength++] = prefix;
    }

    public Object lookupKey(int key) {
        for (int j = 0; j < this.buffer.activeLength; ++j) {
            EKeymap actual = this.buffer.activeKeymaps[j];
            Object action = actual.lookupKey(this.pendingKeys, this.pendingLength, key, j < this.buffer.activeLength - 1);
            if (action == null) continue;
            return action;
        }
        return EKeymap.ignorable(key) ? null : this.tooLong(this.pendingLength);
    }

    public abstract Object tooLong(int var1);

    public void handleKey(int code) {
        Object command = this.lookupKey(code);
        this.pushPrefix(code);
        --this.pendingLength;
        this.handleCommand(command);
    }

    public void handleCommand(Object command) {
        if (command instanceof String || command instanceof Symbol) {
            Object resolved = Command.resolveSymbol(command);
            if (resolved == null) {
                throw new Error("no function defined for " + command);
            }
            command = resolved;
        }
        if (command instanceof EKeymap) {
            if (this.pendingKeys[this.pendingLength] != 0) {
                ++this.pendingLength;
            }
            return;
        }
        this.pendingLength = 0;
        try {
            Procedure proc = (Procedure)command;
            Object interactive = proc.getProperty("emacs-interactive", null);
            if (interactive != null) {
                if (interactive instanceof String) {
                    proc.applyN(Command.processInteractionString(interactive.toString()));
                } else if (interactive == LList.Empty) {
                    proc.apply0();
                } else {
                    System.err.println("not implemented: interactive not a string");
                    proc.apply0();
                }
            } else {
                proc.apply0();
            }
        }
        catch (CancelledException ex) {
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Error ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw new WrappedException(ex);
        }
    }
}

