/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.dialogs;

import com.sun.electric.database.EditingPreferences;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.Technology;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.JobException;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.dialogs.EDialog;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class LayoutText
extends EDialog {
    private static int lastSize = 12;
    private static double lastScale = 1.0;
    private static double lastSeparation = 0.0;
    private static boolean lastItalic = false;
    private static boolean lastBold = false;
    private static boolean lastUnderline = false;
    private static boolean lastInvertDots = false;
    private static String lastFont = User.getDefaultFont();
    private static String lastLayer = null;
    private static String lastMessage = null;
    private JButton cancel;
    private JTextField dotSeparation;
    private JCheckBox invertDots;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JButton ok;
    private JCheckBox textBold;
    private JComboBox textFont;
    private JCheckBox textItalic;
    private JComboBox textLayer;
    private JTextArea textMessage;
    private JTextField textScale;
    private JTextField textSize;
    private JCheckBox textUnderline;

    public LayoutText(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.ok);
        EDialog.makeTextFieldSelectAllOnTab(this.textSize);
        EDialog.makeTextFieldSelectAllOnTab(this.textScale);
        EDialog.makeTextFieldSelectAllOnTab(this.dotSeparation);
        Technology tech = Technology.getCurrent();
        this.textSize.setText(Integer.toString(lastSize));
        this.textScale.setText(TextUtils.formatDouble(lastScale));
        this.dotSeparation.setText(TextUtils.formatDistance(lastSeparation, tech));
        this.textItalic.setSelected(lastItalic);
        this.textBold.setSelected(lastBold);
        this.textUnderline.setSelected(lastUnderline);
        this.invertDots.setSelected(lastInvertDots);
        Iterator<PrimitiveNode> it = tech.getNodes();
        while (it.hasNext()) {
            PrimitiveNode np = it.next();
            if (np.getFunction() != PrimitiveNode.Function.NODE) continue;
            this.textLayer.addItem(np.getName());
        }
        if (lastLayer != null) {
            this.textLayer.setSelectedItem(lastLayer);
        }
        if (lastMessage != null) {
            this.textMessage.setText(lastMessage);
        }
        Font[] fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAllFonts();
        for (int i = 0; i < fonts.length; ++i) {
            this.textFont.addItem(fonts[i].getFontName());
        }
        if (lastFont != null) {
            this.textFont.setSelectedItem(lastFont);
        }
        this.textFont.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutText.this.updateMessageField();
            }
        });
        this.textItalic.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutText.this.updateMessageField();
            }
        });
        this.textBold.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutText.this.updateMessageField();
            }
        });
        this.textSize.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutText.this.updateMessageField();
            }
        });
        this.finishInitialization();
    }

    @Override
    protected void escapePressed() {
        this.cancel(null);
    }

    private void updateMessageField() {
        int size2;
        Font theFont;
        String fontName = (String)this.textFont.getSelectedItem();
        int fontStyle = 0;
        if (this.textItalic.isSelected()) {
            fontStyle |= 2;
        }
        if (this.textBold.isSelected()) {
            fontStyle |= 1;
        }
        if ((theFont = new Font(fontName, fontStyle, size2 = TextUtils.atoi(this.textSize.getText()))) != null) {
            this.textMessage.setFont(theFont);
        }
    }

    private void initComponents() {
        this.cancel = new JButton();
        this.ok = new JButton();
        this.jLabel1 = new JLabel();
        this.textSize = new JTextField();
        this.jLabel2 = new JLabel();
        this.textScale = new JTextField();
        this.jLabel3 = new JLabel();
        this.dotSeparation = new JTextField();
        this.jLabel4 = new JLabel();
        this.textFont = new JComboBox();
        this.textItalic = new JCheckBox();
        this.textBold = new JCheckBox();
        this.jLabel5 = new JLabel();
        this.textLayer = new JComboBox();
        this.jLabel6 = new JLabel();
        this.textUnderline = new JCheckBox();
        this.textMessage = new JTextArea();
        this.invertDots = new JCheckBox();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setTitle("Make Layout Text");
        this.setName("");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                LayoutText.this.closeDialog(evt);
            }
        });
        this.cancel.setText("Cancel");
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutText.this.cancel(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.cancel, gridBagConstraints);
        this.ok.setText("OK");
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LayoutText.this.ok(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.ok, gridBagConstraints);
        this.jLabel1.setText("Size (max 63):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel1, gridBagConstraints);
        this.textSize.setColumns(8);
        this.textSize.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textSize, gridBagConstraints);
        this.jLabel2.setText("Scale factor:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel2, gridBagConstraints);
        this.textScale.setColumns(8);
        this.textScale.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textScale, gridBagConstraints);
        this.jLabel3.setText("Dot separation (units):");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel3, gridBagConstraints);
        this.dotSeparation.setColumns(8);
        this.dotSeparation.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.dotSeparation, gridBagConstraints);
        this.jLabel4.setText("Font:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel4, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textFont, gridBagConstraints);
        this.textItalic.setText("Italic");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textItalic, gridBagConstraints);
        this.textBold.setText("Bold");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textBold, gridBagConstraints);
        this.jLabel5.setText("Layer:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel5, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textLayer, gridBagConstraints);
        this.jLabel6.setText("Message:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jLabel6, gridBagConstraints);
        this.textUnderline.setText("Underline");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        this.getContentPane().add((Component)this.textUnderline, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.textMessage, gridBagConstraints);
        this.invertDots.setText("Reverse-video");
        this.invertDots.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.invertDots.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.invertDots, gridBagConstraints);
        this.pack();
    }

    private void cancel(ActionEvent evt) {
        this.closeDialog(null);
    }

    private void ok(ActionEvent evt) {
        this.grabDialogValues();
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        PrimitiveNode primNode = Technology.getCurrent().findNodeProto(lastLayer);
        if (primNode == null) {
            System.out.println("Cannot find " + lastLayer + " primitive");
            return;
        }
        int yOffset = 0;
        String[] strings = lastMessage.split("\n");
        for (int i = 0; i < strings.length; ++i) {
            String str = strings[i];
            Raster ras = LayoutText.renderText(str, lastFont, lastSize, lastItalic, lastBold, lastUnderline);
            if (ras == null) {
                System.out.println("Cannot generate a raster for the text '" + str + "'");
                return;
            }
            DataBufferByte dbb = (DataBufferByte)ras.getDataBuffer();
            byte[] samples = dbb.getData();
            new CreateLayoutText(curCell, primNode, lastScale, lastSeparation, ras.getWidth(), ras.getHeight(), yOffset, lastInvertDots, samples);
            yOffset += ras.getHeight();
        }
        this.closeDialog(null);
    }

    private static Raster renderText(String msg, String fontName, int tSize, boolean italic, boolean bold, boolean underline) {
        Font font;
        int fontStyle = 0;
        if (italic) {
            fontStyle |= 2;
        }
        if (bold) {
            fontStyle |= 1;
        }
        if ((font = new Font(fontName, fontStyle, tSize)) == null) {
            System.out.println("Could not find font " + font + " to render text: " + msg);
            return null;
        }
        FontRenderContext frc = new FontRenderContext(null, true, true);
        GlyphVector gv = font.createGlyphVector(frc, msg);
        LineMetrics lm = font.getLineMetrics(msg, frc);
        Rectangle2D rasRect = gv.getLogicalBounds();
        int width = (int)rasRect.getWidth();
        int height = (int)((double)lm.getHeight() + 0.5);
        if (width <= 0 || height <= 0) {
            return null;
        }
        fontStyle = font.getStyle();
        if (underline) {
            ++height;
        }
        Rectangle2D.Double rasBounds = new Rectangle2D.Double(0.0, lm.getAscent() - lm.getLeading(), width, height);
        BufferedImage textImage = new BufferedImage(width, height, 10);
        Graphics2D g2 = textImage.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        g2.setColor(new Color(255, 255, 255));
        g2.drawGlyphVector(gv, (float)(-((RectangularShape)rasBounds).getX()), lm.getAscent() - lm.getLeading());
        if (underline) {
            g2.drawLine(0, height - 1, width - 1, height - 1);
        }
        return textImage.getData();
    }

    private void closeDialog(WindowEvent evt) {
        this.grabDialogValues();
        this.setVisible(false);
        this.dispose();
    }

    private void grabDialogValues() {
        lastSize = TextUtils.atoi(this.textSize.getText());
        lastScale = TextUtils.atof(this.textScale.getText());
        Technology tech = Technology.getCurrent();
        lastSeparation = TextUtils.atofDistance(this.dotSeparation.getText(), tech);
        lastItalic = this.textItalic.isSelected();
        lastBold = this.textBold.isSelected();
        lastUnderline = this.textUnderline.isSelected();
        lastInvertDots = this.invertDots.isSelected();
        lastLayer = (String)this.textLayer.getSelectedItem();
        lastFont = (String)this.textFont.getSelectedItem();
        lastMessage = this.textMessage.getText();
    }

    private static class CreateLayoutText
    extends Job {
        private Cell curCell;
        private NodeProto primNode;
        private double lastScale;
        private double lastSeparation;
        private int wid;
        private int hei;
        private int yOffset;
        private boolean invertDots;
        private byte[] samples;

        protected CreateLayoutText(Cell curCell, NodeProto primNode, double lastScale, double lastSeparation, int wid, int hei, int yOffset, boolean invertDots, byte[] samples) {
            super("Create Layout Text", User.getUserTool(), Job.Type.CHANGE, null, null, Job.Priority.USER);
            this.curCell = curCell;
            this.primNode = primNode;
            this.lastScale = lastScale;
            this.lastSeparation = lastSeparation;
            this.wid = wid;
            this.hei = hei;
            this.yOffset = yOffset;
            this.invertDots = invertDots;
            this.samples = samples;
            this.startJob();
        }

        @Override
        public boolean doIt() throws JobException {
            EditingPreferences ep = this.getEditingPreferences();
            double width = this.lastScale - this.lastSeparation;
            double height = this.lastScale - this.lastSeparation;
            int samp = 0;
            for (int y = 0; y < this.hei; ++y) {
                for (int x2 = 0; x2 < this.wid; ++x2) {
                    if (this.samples[samp++] == 0 != this.invertDots) continue;
                    Point2D.Double center = new Point2D.Double((double)x2 * this.lastScale, (double)(-(y + this.yOffset)) * this.lastScale);
                    NodeInst.newInstance(this.primNode, ep, center, width, height, this.curCell);
                }
            }
            return true;
        }
    }
}

