/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.util.config;

import com.sun.electric.util.CollectionFactory;
import com.sun.electric.util.config.EConfigContainer;
import com.sun.electric.util.config.InitStrategy;
import com.sun.electric.util.config.XmlConfigVerification;
import com.sun.electric.util.config.model.ConfigEntries;
import com.sun.electric.util.config.model.ConfigEntry;
import com.sun.electric.util.config.model.Include;
import com.sun.electric.util.config.model.Injection;
import com.sun.electric.util.config.model.Parameter;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlInitSax
extends InitStrategy {
    private static Logger logger = Logger.getLogger(XmlInitSax.class.getName());
    private String xmlFile;
    private static final String SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    private static final String XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";

    public XmlInitSax(String xmlFile) {
        this.xmlFile = xmlFile;
    }

    public XmlInitSax(URL xmlUrl) {
        this.xmlFile = xmlUrl.toString();
    }

    @Override
    public void init(EConfigContainer config) {
        ConfigEntries.refresh();
        HashMap<String, Injection> injections = CollectionFactory.createHashMap();
        ArrayList<Include> includes = CollectionFactory.createArrayList();
        SAXParser saxParser = null;
        HashSet<Include> visitedIncludes = CollectionFactory.createHashSet();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(true);
            saxParser = factory.newSAXParser();
            saxParser.setProperty(SCHEMA_LANGUAGE, XML_SCHEMA);
            saxParser.parse(this.xmlFile, (DefaultHandler)new ParserHandler(injections, includes));
            Include mainInclude = new Include(this.xmlFile, null);
            visitedIncludes.add(mainInclude);
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        try {
            this.parseIncludes(saxParser, includes, visitedIncludes, injections);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return;
        }
        try {
            if (XmlConfigVerification.runVerification(injections)) {
                for (Injection in : injections.values()) {
                    try {
                        logger.log(Level.FINE, "bind injection: " + in.getName() + " to " + in.getImplementation());
                        ConfigEntry<?> entry = ConfigEntries.getEntries().containsKey(in.getName()) ? ConfigEntries.getEntries().get(in.getName()) : in.createConfigEntry(injections);
                        config.addConfigEntry(in.getName(), entry);
                    }
                    catch (ClassNotFoundException e) {
                        logger.log(Level.CONFIG, "unable to bind injection: " + in.getName());
                    }
                    catch (LinkageError e) {
                        logger.log(Level.CONFIG, "unable to bind injection dependencies: " + in.getName());
                    }
                }
            }
        }
        catch (XmlConfigVerification.LoopExistsException e) {
            logger.log(Level.SEVERE, "A loop exists in the configuration");
        }
    }

    private void parseIncludes(SAXParser parser, List<Include> includes, Set<Include> visitedIncludes, Map<String, Injection> injections) throws Exception {
        for (Include include : includes) {
            if (visitedIncludes.contains(include)) continue;
            ArrayList<Include> newIncludes = CollectionFactory.createArrayList();
            parser.parse(this.getFileObject(include.getFile()), (DefaultHandler)new ParserHandler(injections, newIncludes));
            this.parseIncludes(parser, newIncludes, visitedIncludes, injections);
        }
    }

    private File getFileObject(String name) throws Exception {
        File result2 = new File(name);
        if (!result2.exists()) {
            result2 = new File(ClassLoader.getSystemResource(name).toURI());
        }
        return result2;
    }

    private static class ParserHandler
    extends DefaultHandler {
        private Injection currentInjection = null;
        private List<Parameter> currentParameters = null;
        private Parameter currentParameter = null;
        private Map<String, Injection> injections = null;
        private Include currentInclude = null;
        private List<Include> includes;

        public ParserHandler(Map<String, Injection> injections, List<Include> includes) {
            this.injections = injections;
            this.includes = includes;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (!localName.equals(XmlTags.configuration.toString())) {
                if (localName.equals(XmlTags.injection.toString())) {
                    this.parseInjectionTag(attributes);
                } else if (localName.equals(XmlTags.parameters.toString())) {
                    this.parseParametersTag(attributes);
                } else if (localName.equals(XmlTags.parameter.toString())) {
                    this.parseParameterTag(attributes);
                } else if (localName.equals(XmlTags.include.toString())) {
                    this.parseIncludeTag(attributes);
                } else if (localName.equals(XmlTags.initRuntimeParameter.toString())) {
                    this.parseInitRuntimeParamterTag(attributes);
                } else {
                    logger.log(Level.SEVERE, "unexpected opening tag: " + localName);
                }
            }
        }

        private void parseInitRuntimeParamterTag(Attributes attributes) throws SAXException {
            if (this.currentParameter != null) {
                throw new SAXException("error: closing tag expected");
            }
            String name = attributes.getValue(Parameter.Attributes.name.toString());
            String type = attributes.getValue(Parameter.Attributes.type.toString());
            Parameter.Type paramType = Parameter.Type.valueOf(type);
            this.currentParameter = new Parameter(name, null, null, paramType, false);
        }

        private void parseInjectionTag(Attributes attributes) throws SAXException {
            if (this.currentInjection != null) {
                throw new SAXException("error: closing tag expected");
            }
            String name = attributes.getValue(Injection.Attributes.name.toString());
            String impl = attributes.getValue(Injection.Attributes.implementation.toString());
            String factoryMethod = attributes.getValue(Injection.Attributes.factoryMethod.toString());
            String singleton = attributes.getValue(Injection.Attributes.singleton.toString());
            boolean isSingleton = false;
            if (singleton != null) {
                isSingleton = Boolean.parseBoolean(singleton);
            }
            this.currentInjection = new Injection(name, impl, factoryMethod, isSingleton);
        }

        private void parseParametersTag(Attributes attributes) throws SAXException {
            if (this.currentParameters != null) {
                throw new SAXException("error: closing tag expected");
            }
            this.currentParameters = CollectionFactory.createArrayList();
        }

        private void parseParameterTag(Attributes attributes) throws SAXException {
            if (this.currentParameter != null) {
                throw new SAXException("error: closing tag expected");
            }
            String name = attributes.getValue(Parameter.Attributes.name.toString());
            String ref = attributes.getValue(Parameter.Attributes.ref.toString());
            String type = attributes.getValue(Parameter.Attributes.type.toString());
            String value2 = attributes.getValue(Parameter.Attributes.value.toString());
            Parameter.Type paramType = ref != null ? Parameter.Type.Reference : Parameter.Type.valueOf(type);
            this.currentParameter = new Parameter(name, ref, value2, paramType, false);
        }

        private void parseIncludeTag(Attributes attributes) throws SAXException {
            if (this.currentParameter != null) {
                throw new SAXException("error: closing tag expected");
            }
            String file = attributes.getValue(Include.Attributes.file.toString());
            String id = attributes.getValue(Include.Attributes.id.toString());
            this.currentInclude = new Include(file, id);
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!localName.equals(XmlTags.configuration.toString())) {
                if (localName.equals(XmlTags.injection.toString())) {
                    this.injections.put(this.currentInjection.getName(), this.currentInjection);
                    this.currentInjection = null;
                } else if (localName.equals(XmlTags.parameters.toString())) {
                    this.currentInjection.setParameters(this.currentParameters);
                    this.currentParameters = null;
                } else if (localName.equals(XmlTags.parameter.toString())) {
                    this.currentParameters.add(this.currentParameter);
                    this.currentParameter = null;
                } else if (localName.equals(XmlTags.include.toString())) {
                    this.includes.add(this.currentInclude);
                    this.currentInclude = null;
                } else if (localName.equals(XmlTags.initRuntimeParameter.toString())) {
                    this.currentParameters.add(this.currentParameter);
                    this.currentParameter = null;
                } else {
                    logger.log(Level.SEVERE, "unexpected closing tag: " + localName);
                }
            }
        }

        @Override
        public void error(SAXParseException e) throws SAXException {
            throw new SAXException(e);
        }

        @Override
        public void warning(SAXParseException e) throws SAXException {
            throw new SAXException(e);
        }

        private static enum XmlTags {
            configuration,
            injection,
            parameters,
            parameter,
            include,
            initRuntimeParameter;

        }
    }
}

