/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.tecEditWizard2;

import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.tecEditWizard2.TechEditWizard;
import com.sun.electric.tool.user.tecEditWizard2.TechEditWizardData;
import com.sun.electric.tool.user.tecEditWizard2.TechEditWizardPanel;
import com.sun.electric.tool.user.tecEditWizard2.WizardField;
import com.sun.electric.util.TextUtils;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class Via
extends TechEditWizardPanel {
    private JPanel via;
    private JComboBox whichVia;
    private JTextField size;
    private JTextField spacing;
    private JTextField arraySpacing;
    private JTextField overhangInline;
    private JTextField sizeRule;
    private JTextField spacingRule;
    private JTextField arraySpacingRule;
    private JTextField overhangInlineRule;
    private double[] vSize;
    private double[] vSpacing;
    private double[] vArraySpacing;
    private double[] vOverhangInline;
    private String[] vSizeRule;
    private String[] vSpacingRule;
    private String[] vArraySpacingRule;
    private String[] vOverhangInlineRule;
    private boolean dataChanging;

    public Via(TechEditWizard parent, boolean modal) {
        super(parent, modal);
        this.setTitle("Via");
        this.setName("");
        this.via = new JPanel();
        this.via.setLayout(new GridBagLayout());
        JLabel heading = new JLabel("Via Parameters");
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.via.add((Component)heading, gbc);
        JLabel image = new JLabel();
        image.setIcon(Resources.getResource(this.getClass(), "Via.png"));
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 1;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.via.add((Component)image, gbc);
        JLabel whichViaLabel = new JLabel("Which via:");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 2;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 1, 0);
        this.via.add((Component)whichViaLabel, gbc);
        this.whichVia = new JComboBox();
        this.whichVia.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                Via.this.viaChanged();
            }
        });
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 2;
        gbc.insets = new Insets(4, 0, 4, 2);
        this.via.add((Component)this.whichVia, gbc);
        JLabel l1 = new JLabel("Distance");
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 3;
        this.via.add((Component)l1, gbc);
        JLabel l2 = new JLabel("Rule Name");
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 3;
        this.via.add((Component)l2, gbc);
        JLabel sizeLabel = new JLabel("Via size (A):");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 4;
        gbc.anchor = 17;
        gbc.insets = new Insets(4, 4, 1, 0);
        this.via.add((Component)sizeLabel, gbc);
        this.size = new JTextField();
        this.size.getDocument().addDocumentListener(new ViaDocumentListener());
        this.size.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 4;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.via.add((Component)this.size, gbc);
        this.sizeRule = new JTextField();
        this.sizeRule.getDocument().addDocumentListener(new ViaDocumentListener());
        this.sizeRule.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 4;
        gbc.insets = new Insets(4, 0, 1, 2);
        this.via.add((Component)this.sizeRule, gbc);
        JLabel spacingLabel = new JLabel("Via inline spacing (B):");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 5;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 4, 1, 0);
        this.via.add((Component)spacingLabel, gbc);
        this.spacing = new JTextField();
        this.spacing.getDocument().addDocumentListener(new ViaDocumentListener());
        this.spacing.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 5;
        gbc.insets = new Insets(1, 0, 1, 2);
        this.via.add((Component)this.spacing, gbc);
        this.spacingRule = new JTextField();
        this.spacingRule.getDocument().addDocumentListener(new ViaDocumentListener());
        this.spacingRule.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 5;
        gbc.insets = new Insets(1, 0, 1, 2);
        this.via.add((Component)this.spacingRule, gbc);
        JLabel arraySpacingLabel = new JLabel("Via array spacing (C):");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 6;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 4, 1, 0);
        this.via.add((Component)arraySpacingLabel, gbc);
        this.arraySpacing = new JTextField();
        this.arraySpacing.getDocument().addDocumentListener(new ViaDocumentListener());
        this.arraySpacing.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 6;
        gbc.insets = new Insets(1, 0, 1, 2);
        this.via.add((Component)this.arraySpacing, gbc);
        this.arraySpacingRule = new JTextField();
        this.arraySpacingRule.getDocument().addDocumentListener(new ViaDocumentListener());
        this.arraySpacingRule.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 6;
        gbc.insets = new Insets(1, 0, 1, 2);
        this.via.add((Component)this.arraySpacingRule, gbc);
        JLabel overhangInlineLabel = new JLabel("Via inline overhang (D):");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 7;
        gbc.anchor = 17;
        gbc.insets = new Insets(1, 4, 4, 0);
        this.via.add((Component)overhangInlineLabel, gbc);
        this.overhangInline = new JTextField();
        this.overhangInline.getDocument().addDocumentListener(new ViaDocumentListener());
        this.overhangInline.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 7;
        gbc.insets = new Insets(1, 0, 4, 2);
        this.via.add((Component)this.overhangInline, gbc);
        this.overhangInlineRule = new JTextField();
        this.overhangInlineRule.getDocument().addDocumentListener(new ViaDocumentListener());
        this.overhangInlineRule.setColumns(8);
        gbc = new GridBagConstraints();
        gbc.gridx = 2;
        gbc.gridy = 7;
        gbc.insets = new Insets(1, 0, 4, 2);
        this.via.add((Component)this.overhangInlineRule, gbc);
        JLabel nano = new JLabel("Distances are in nanometers");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 8;
        gbc.gridwidth = 3;
        gbc.insets = new Insets(4, 4, 4, 4);
        this.via.add((Component)nano, gbc);
    }

    public Component getComponent() {
        return this.via;
    }

    public String getName() {
        return "Via";
    }

    public void init() {
        int i;
        TechEditWizardData data2 = this.wizard.getTechEditData();
        int numVias = data2.getNumMetalLayers() - 1;
        this.whichVia.removeAllItems();
        for (i = 0; i < numVias; ++i) {
            this.whichVia.addItem(i + 1 + " to " + (i + 2));
        }
        if (numVias > 0) {
            this.vSize = new double[numVias];
            this.vSizeRule = new String[numVias];
            this.vSpacing = new double[numVias];
            this.vSpacingRule = new String[numVias];
            this.vArraySpacing = new double[numVias];
            this.vArraySpacingRule = new String[numVias];
            this.vOverhangInline = new double[numVias];
            this.vOverhangInlineRule = new String[numVias];
            for (i = 0; i < numVias; ++i) {
                this.vSize[i] = data2.getViaSize()[i].value;
                this.vSizeRule[i] = data2.getViaSize()[i].rule;
                this.vSpacing[i] = data2.getViaSpacing()[i].value;
                this.vSpacingRule[i] = data2.getViaSpacing()[i].rule;
                this.vArraySpacing[i] = data2.getViaArraySpacing()[i].value;
                this.vArraySpacingRule[i] = data2.getViaArraySpacing()[i].rule;
                this.vOverhangInline[i] = data2.getViaOverhangInline()[i].value;
                this.vOverhangInlineRule[i] = data2.getViaOverhangInline()[i].rule;
            }
            this.whichVia.setSelectedIndex(0);
        }
    }

    public void term() {
        TechEditWizardData data2 = this.wizard.getTechEditData();
        int numVias = data2.getNumMetalLayers() - 1;
        for (int i = 0; i < numVias; ++i) {
            data2.setViaSize(i, new WizardField(this.vSize[i], this.vSizeRule[i]));
            data2.setViaSpacing(i, new WizardField(this.vSpacing[i], this.vSpacingRule[i]));
            data2.setViaArraySpacing(i, new WizardField(this.vArraySpacing[i], this.vArraySpacingRule[i]));
            data2.setViaOverhangInline(i, new WizardField(this.vOverhangInline[i], this.vOverhangInlineRule[i]));
        }
    }

    private void viaChanged() {
        this.dataChanging = true;
        int which = this.whichVia.getSelectedIndex();
        if (which < 0 || this.vSize == null || which >= this.vSize.length) {
            this.size.setText("");
            this.sizeRule.setText("");
            this.spacing.setText("");
            this.spacingRule.setText("");
            this.arraySpacing.setText("");
            this.arraySpacingRule.setText("");
            this.overhangInline.setText("");
            this.overhangInlineRule.setText("");
        } else {
            this.size.setText(TextUtils.formatDouble(this.vSize[which]));
            this.sizeRule.setText(this.vSizeRule[which]);
            this.spacing.setText(TextUtils.formatDouble(this.vSpacing[which]));
            this.spacingRule.setText(this.vSpacingRule[which]);
            this.arraySpacing.setText(TextUtils.formatDouble(this.vArraySpacing[which]));
            this.arraySpacingRule.setText(this.vArraySpacingRule[which]);
            this.overhangInline.setText(TextUtils.formatDouble(this.vOverhangInline[which]));
            this.overhangInlineRule.setText(this.vOverhangInlineRule[which]);
        }
        this.dataChanging = false;
    }

    private void viaDataChanged() {
        if (this.dataChanging) {
            return;
        }
        int which = this.whichVia.getSelectedIndex();
        if (which < 0 || this.vSize == null || which >= this.vSize.length) {
            return;
        }
        this.vSize[which] = TextUtils.atof(this.size.getText());
        this.vSizeRule[which] = this.sizeRule.getText();
        this.vSpacing[which] = TextUtils.atof(this.spacing.getText());
        this.vSpacingRule[which] = this.spacingRule.getText();
        this.vArraySpacing[which] = TextUtils.atof(this.arraySpacing.getText());
        this.vArraySpacingRule[which] = this.arraySpacingRule.getText();
        this.vOverhangInline[which] = TextUtils.atof(this.overhangInline.getText());
        this.vOverhangInlineRule[which] = this.overhangInlineRule.getText();
    }

    private class ViaDocumentListener
    implements DocumentListener {
        private ViaDocumentListener() {
        }

        public void changedUpdate(DocumentEvent e) {
            Via.this.viaDataChanged();
        }

        public void insertUpdate(DocumentEvent e) {
            Via.this.viaDataChanged();
        }

        public void removeUpdate(DocumentEvent e) {
            Via.this.viaDataChanged();
        }
    }
}

