/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.io.output.bookshelf;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.input.bookshelf.Bookshelf;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutput;
import com.sun.electric.tool.io.output.bookshelf.BookshelfOutputWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;

public class BookshelfOutputNets
extends BookshelfOutputWriter {
    private static final Bookshelf.BookshelfFiles fileType = Bookshelf.BookshelfFiles.nets;
    private Cell cell;

    public BookshelfOutputNets(String genericFileName, Cell cell) {
        super(genericFileName, fileType);
        this.cell = cell;
    }

    public void write() throws IOException {
        Job.getUserInterface().setProgressNote("Nets File: " + this.fileName);
        PrintWriter writer = new PrintWriter(this.fileName);
        writer.println(BookshelfOutput.createBookshelfHeader(fileType));
        int size2 = this.cell.getNetlist().getNumNetworks();
        int counter = 0;
        Iterator<Network> inet = this.cell.getNetlist().getNetworks();
        while (inet.hasNext()) {
            if (counter % 20 == 0) {
                Job.getUserInterface().setProgressValue((int)((double)counter / (double)size2 * 100.0));
            }
            Network net = inet.next();
            writer.println("NetDegree : " + net.getPortsList().size() + "  " + net.getName());
            for (PortInst pi : net.getPortsList()) {
                writer.print("    " + pi.getNodeInst().getName() + " I  : ");
                double x = pi.getCenter().getX() - pi.getNodeInst().getTrueCenterX();
                double y = pi.getCenter().getY() - pi.getNodeInst().getTrueCenterY();
                writer.print(String.valueOf(x) + " ");
                writer.println(String.valueOf(y));
            }
            ++counter;
        }
        writer.flush();
        writer.close();
    }
}

