/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.plugins.j3d.ui;

import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.plugins.j3d.View3DWindow;
import com.sun.electric.plugins.j3d.ui.J3DDemoDialog;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.menus.EMenu;
import com.sun.electric.tool.user.menus.EMenuItem;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WindowContent;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.lang.reflect.Method;

public class J3DMenu {
    public static EMenu makeMenu() {
        return new EMenu("_3D Window", new EMenuItem("_3D View"){

            public void run() {
                if (J3DMenu.isJava3DAvailable()) {
                    J3DMenu.create3DViewCommand(false);
                }
            }
        }, new EMenuItem("_Capture Frame/Animate"){

            public void run() {
                if (J3DMenu.isJava3DAvailable()) {
                    J3DDemoDialog.create3DDemoDialog(TopLevel.getCurrentJFrame(), null);
                }
            }
        }, EMenuItem.SEPARATOR, new EMenuItem("_Test Hardware"){

            public void run() {
                if (J3DMenu.isJava3DAvailable()) {
                    J3DMenu.runHardwareTest();
                }
            }
        });
    }

    private static boolean isJava3DAvailable() {
        Class j3DUtilsClass = Resources.get3DClass("utils.J3DUtils");
        if (j3DUtilsClass == null) {
            System.out.println("Java3D is not available.");
            return false;
        }
        return true;
    }

    public static void create3DViewCommand(Boolean transPerNode) {
        Cell curCell = WindowFrame.needCurCell();
        if (curCell == null) {
            return;
        }
        if (!curCell.isLayout()) {
            System.out.println("3D View only available for Layout views");
            return;
        }
        WindowContent view2D = WindowFrame.getCurrentWindowFrame(false).getContent();
        if (!(view2D instanceof EditWindow)) {
            return;
        }
        WindowFrame frame = new WindowFrame();
        View3DWindow.create3DWindow(curCell, frame, view2D, transPerNode);
    }

    private static void runHardwareTest() {
        Class app3DClass = Resources.getJ3DClass("J3DQueryProperties");
        try {
            Method queryClass = app3DClass.getDeclaredMethod("queryHardwareAcceleration", new Class[0]);
            queryClass.invoke((Object)queryClass, new Object[0]);
        }
        catch (Exception e) {
            if (Job.getDebug()) {
                e.printStackTrace();
            }
            System.out.println("Cannot call 3D plugin method queryHardwareAcceleration: ");
        }
    }
}

