/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database;

import com.sun.electric.database.CellBackup;
import com.sun.electric.database.CellRevision;
import com.sun.electric.database.EquivPorts;
import com.sun.electric.database.ImmutableCell;
import com.sun.electric.database.ImmutableNodeInst;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.ERectangle;
import com.sun.electric.database.id.CellId;
import com.sun.electric.database.id.CellUsage;
import com.sun.electric.database.text.ImmutableArrayList;
import com.sun.electric.technology.TechPool;
import java.awt.geom.Rectangle2D;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellTree {
    public static final CellTree[] NULL_ARRAY = new CellTree[0];
    public static final ImmutableArrayList<CellTree> EMPTY_LIST = new ImmutableArrayList<CellTree>(NULL_ARRAY);
    public final CellBackup top;
    final CellTree[] subTrees;
    public final TechPool techPool;
    public final Set<CellId> allCells;
    private ERectangle bounds;
    private EquivPorts equivPorts;

    private CellTree(CellBackup top, CellTree[] subTrees, TechPool techPool, Set<CellId> allCells) {
        this.top = top;
        this.subTrees = subTrees;
        this.techPool = techPool;
        this.allCells = allCells;
    }

    public static CellTree newInstance(ImmutableCell d, TechPool techPool) {
        CellBackup top = CellBackup.newInstance(d, techPool);
        assert (top.cellRevision.cellUsages.length == 0);
        return new CellTree(top, NULL_ARRAY, top.techPool, Collections.singleton(top.cellRevision.d.cellId));
    }

    public CellTree with(CellBackup top, CellTree[] subTrees, TechPool superPool) {
        if (Arrays.equals(this.subTrees, subTrees)) {
            subTrees = this.subTrees;
        } else {
            int l;
            subTrees = (CellTree[])subTrees.clone();
            for (l = subTrees.length; l > 0 && subTrees[l - 1] == null; --l) {
            }
            if (l == 0) {
                subTrees = NULL_ARRAY;
            } else if (l != subTrees.length) {
                CellTree[] newSubTrees = null;
                if (l == this.subTrees.length) {
                    newSubTrees = this.subTrees;
                    for (int i = 0; i < l; ++i) {
                        if (newSubTrees[i] == subTrees[i]) continue;
                        newSubTrees = null;
                        break;
                    }
                }
                if (newSubTrees == null) {
                    newSubTrees = new CellTree[l];
                    System.arraycopy(subTrees, 0, newSubTrees, 0, l);
                }
                subTrees = newSubTrees;
            }
        }
        if (this.top == top && this.subTrees == subTrees) {
            return this;
        }
        CellRevision cellRevision = top.cellRevision;
        CellId cellId = cellRevision.d.cellId;
        BitSet techUsages = new BitSet();
        if (top.techPool != superPool.restrict(cellRevision.techUsages, top.techPool)) {
            throw new IllegalArgumentException();
        }
        techUsages.or(cellRevision.techUsages);
        HashSet<CellId> allCellsAccum = new HashSet<CellId>();
        for (int i = 0; i < cellRevision.cellUsages.length; ++i) {
            CellRevision.CellUsageInfo cui = cellRevision.cellUsages[i];
            CellTree subTree = subTrees[i];
            if (cui == null) {
                if (subTree == null) continue;
                throw new IllegalArgumentException();
            }
            BitSet subTechUsages = subTree.techPool.getTechUsages();
            if (subTree.techPool != superPool.restrict(subTechUsages, subTree.techPool)) {
                throw new IllegalArgumentException();
            }
            techUsages.or(subTechUsages);
            allCellsAccum.addAll(subTree.allCells);
            CellRevision subCellRevision = subTree.top.cellRevision;
            if (subCellRevision.d.cellId != cellId.getUsageIn((int)i).protoId) {
                throw new IllegalArgumentException();
            }
            cui.checkUsage(subCellRevision);
        }
        if (allCellsAccum.contains(cellId)) {
            throw new IllegalArgumentException("Recursive " + cellId);
        }
        allCellsAccum.add(cellId);
        Set<CellId> allCells = allCellsAccum.equals(this.allCells) ? this.allCells : (allCellsAccum.size() == 1 ? Collections.singleton(cellId) : Collections.unmodifiableSet(allCellsAccum));
        assert (allCellsAccum.equals(allCells));
        TechPool techPool = superPool.restrict(techUsages, this.techPool);
        CellTree newCellTree = new CellTree(top, subTrees, techPool, allCells);
        if (this.top == top) {
            CellTree oldSubTree;
            if (this.bounds != null) {
                assert (newCellTree.subTrees.length == this.subTrees.length);
                ERectangle cellBounds = this.bounds;
                for (int i = 0; i < this.subTrees.length; ++i) {
                    oldSubTree = this.subTrees[i];
                    if (oldSubTree == null) continue;
                    assert (oldSubTree.bounds != null);
                    if (newCellTree.subTrees[i].getBounds().equals(oldSubTree.bounds)) continue;
                    cellBounds = null;
                    break;
                }
                if (cellBounds != null) {
                    newCellTree.bounds = cellBounds;
                }
            }
            if (this.equivPorts != null) {
                assert (newCellTree.subTrees.length == this.subTrees.length);
                EquivPorts netCell = this.equivPorts;
                for (int i = 0; i < this.subTrees.length; ++i) {
                    oldSubTree = this.subTrees[i];
                    if (oldSubTree == null) continue;
                    assert (oldSubTree.equivPorts != null);
                    if (newCellTree.subTrees[i].getEquivPorts().equalsPorts(oldSubTree.equivPorts)) continue;
                    netCell = null;
                    break;
                }
                if (netCell != null) {
                    newCellTree.equivPorts = netCell;
                }
            }
        }
        return newCellTree;
    }

    public boolean sameNetlist(CellTree that) {
        if (this.top != that.top) {
            return false;
        }
        for (int i = 0; i < this.subTrees.length; ++i) {
            CellTree thisSubTree = this.subTrees[i];
            if (thisSubTree == null || this.subTrees[i].getEquivPorts().equalsPorts(that.subTrees[i].getEquivPorts())) continue;
            return false;
        }
        return true;
    }

    public CellTree[] getSubTrees() {
        return (CellTree[])this.subTrees.clone();
    }

    public ERectangle getBounds() {
        if (this.bounds == null) {
            this.bounds = this.computeBounds(null);
        }
        return this.bounds;
    }

    private ERectangle computeBounds(ERectangle candidateBounds) {
        CellRevision cellRevision = this.top.cellRevision;
        IdentityHashMap<CellId, ERectangle> subCellBounds = new IdentityHashMap<CellId, ERectangle>(cellRevision.cellUsages.length);
        for (CellTree subTree : this.subTrees) {
            if (subTree == null) continue;
            subCellBounds.put(subTree.top.cellRevision.d.cellId, subTree.getBounds());
        }
        boolean boundsEmpty = true;
        double cellHighY = 0.0;
        double cellLowY = 0.0;
        double cellHighX = 0.0;
        double cellLowX = 0.0;
        Rectangle2D.Double sb = new Rectangle2D.Double();
        for (ImmutableNodeInst n : this.top.cellRevision.nodes) {
            if (!(n.protoId instanceof CellId)) continue;
            ERectangle b = (ERectangle)subCellBounds.get((CellId)n.protoId);
            n.orient.rectangleBounds(b.getMinX(), b.getMinY(), b.getMaxX(), b.getMaxY(), n.anchor.getX(), n.anchor.getY(), sb);
            double lowx = sb.getMinX();
            double highx = sb.getMaxX();
            double lowy = sb.getMinY();
            double highy = sb.getMaxY();
            if (boundsEmpty) {
                boundsEmpty = false;
                cellLowX = lowx;
                cellHighX = highx;
                cellLowY = lowy;
                cellHighY = highy;
                continue;
            }
            if (lowx < cellLowX) {
                cellLowX = lowx;
            }
            if (highx > cellHighX) {
                cellHighX = highx;
            }
            if (lowy < cellLowY) {
                cellLowY = lowy;
            }
            if (!(highy > cellHighY)) continue;
            cellHighY = highy;
        }
        long gridMinX = DBMath.lambdaToGrid(cellLowX);
        long gridMinY = DBMath.lambdaToGrid(cellLowY);
        long gridMaxX = DBMath.lambdaToGrid(cellHighX);
        long gridMaxY = DBMath.lambdaToGrid(cellHighY);
        ERectangle primitiveBounds = this.top.getPrimitiveBounds();
        if (primitiveBounds != null) {
            if (boundsEmpty) {
                gridMinX = primitiveBounds.getGridMinX();
                gridMaxX = primitiveBounds.getGridMaxX();
                gridMinY = primitiveBounds.getGridMinY();
                gridMaxY = primitiveBounds.getGridMaxY();
            } else {
                gridMinX = Math.min(gridMinX, primitiveBounds.getGridMinX());
                gridMaxX = Math.max(gridMaxX, primitiveBounds.getGridMaxX());
                gridMinY = Math.min(gridMinY, primitiveBounds.getGridMinY());
                gridMaxY = Math.max(gridMaxY, primitiveBounds.getGridMaxY());
            }
        }
        if (candidateBounds != null && gridMinX == candidateBounds.getGridMinX() && gridMinY == candidateBounds.getGridMinY() && gridMaxX == candidateBounds.getGridMaxX() && gridMaxY == candidateBounds.getGridMaxY()) {
            return candidateBounds;
        }
        return ERectangle.fromGrid(gridMinX, gridMinY, gridMaxX - gridMinX, gridMaxY - gridMinY);
    }

    public EquivPorts getEquivPorts() {
        if (this.equivPorts == null) {
            this.equivPorts = new EquivPorts(this);
        }
        return this.equivPorts;
    }

    public EquivPorts computeEquivPorts() {
        return new EquivPorts(this);
    }

    public void check() {
        this.top.check();
        CellId cellId = this.top.cellRevision.d.cellId;
        BitSet techUsages = new BitSet();
        techUsages.or(this.top.cellRevision.techUsages);
        assert (this.subTrees.length == this.top.cellRevision.cellUsages.length);
        HashSet<CellId> allCells = new HashSet<CellId>();
        for (int i = 0; i < this.subTrees.length; ++i) {
            CellTree subTree = this.subTrees[i];
            CellRevision.CellUsageInfo cui = this.top.cellRevision.cellUsages[i];
            if (cui == null) {
                assert (subTree == null);
                continue;
            }
            CellRevision subCellRevision = subTree.top.cellRevision;
            CellUsage cu = cellId.getUsageIn(i);
            assert (subCellRevision.d.cellId == cu.protoId);
            cui.checkUsage(subCellRevision);
            BitSet subTechUsage = subTree.techPool.getTechUsages();
            assert (subTree.techPool == this.techPool.restrict(subTechUsage, subTree.techPool));
            techUsages.or(subTechUsage);
            allCells.addAll(subTree.allCells);
        }
        assert (this.top.techPool == this.techPool.restrict(this.top.cellRevision.techUsages, this.top.techPool));
        assert (techUsages.equals(this.techPool.getTechUsages()));
        assert (!allCells.contains(cellId));
        allCells.add(cellId);
        assert (allCells.equals(this.allCells));
        if (this.bounds != null) assert (this.bounds == this.computeBounds(this.bounds));
    }

    public String toString() {
        return this.top.toString();
    }
}

