/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user;

import com.sun.electric.database.change.DatabaseChangeEvent;
import com.sun.electric.database.change.DatabaseChangeListener;
import com.sun.electric.database.geometry.DBMath;
import com.sun.electric.database.geometry.EPoint;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.geometry.Poly;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Export;
import com.sun.electric.database.network.Netlist;
import com.sun.electric.database.network.Network;
import com.sun.electric.database.prototype.NodeProto;
import com.sun.electric.database.prototype.PortProto;
import com.sun.electric.database.text.TextUtils;
import com.sun.electric.database.topology.ArcInst;
import com.sun.electric.database.topology.Connection;
import com.sun.electric.database.topology.Geometric;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.database.topology.PortInst;
import com.sun.electric.database.topology.RTBounds;
import com.sun.electric.database.topology.RTNode;
import com.sun.electric.database.variable.DisplayedText;
import com.sun.electric.database.variable.ElectricObject;
import com.sun.electric.database.variable.TextDescriptor;
import com.sun.electric.database.variable.Variable;
import com.sun.electric.technology.ArcProto;
import com.sun.electric.technology.Layer;
import com.sun.electric.technology.PrimitiveNode;
import com.sun.electric.technology.PrimitivePort;
import com.sun.electric.technology.Technology;
import com.sun.electric.technology.technologies.Generic;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.routing.Router;
import com.sun.electric.tool.user.ActivityLogger;
import com.sun.electric.tool.user.Highlight2;
import com.sun.electric.tool.user.HighlightArea;
import com.sun.electric.tool.user.HighlightEOBJ;
import com.sun.electric.tool.user.HighlightLine;
import com.sun.electric.tool.user.HighlightListener;
import com.sun.electric.tool.user.HighlightMessage;
import com.sun.electric.tool.user.HighlightObject;
import com.sun.electric.tool.user.HighlightPoly;
import com.sun.electric.tool.user.HighlightText;
import com.sun.electric.tool.user.NetworkHighlighter;
import com.sun.electric.tool.user.User;
import com.sun.electric.tool.user.UserInterfaceMain;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.LayerVisibility;
import com.sun.electric.tool.user.ui.WindowFrame;
import com.sun.electric.tool.user.waveform.WaveformWindow;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Highlighter
implements DatabaseChangeListener {
    private static Highlighter currentHighlighter = null;
    private int highOffX = 0;
    private int highOffY = 0;
    private List<Highlight2> highlightList = new ArrayList<Highlight2>();
    private List<List<Highlight2>> highlightStack = new ArrayList<List<Highlight2>>();
    private boolean changed = false;
    private Highlight2 lastHighlightListEndObj;
    private int showNetworkLevel;
    private int type;
    private WindowFrame wf;
    private static Set<HighlightListener> highlightListeners = new HashSet<HighlightListener>();
    public static final int SELECT_HIGHLIGHTER = 0;
    public static final int MOUSEOVER_HIGHLIGHTER = 1;
    public static final int RULER_HIGHLIGHTER = 2;
    public static final int EXACTSELECTDISTANCE = 5;

    public Highlighter(int type, WindowFrame wf) {
        UserInterfaceMain.addDatabaseChangeListener(this);
        if (currentHighlighter == null) {
            currentHighlighter = this;
        }
        this.lastHighlightListEndObj = null;
        this.showNetworkLevel = 0;
        this.type = type;
        this.wf = wf;
    }

    void setChanged(boolean c) {
        this.changed = c;
    }

    public void delete() {
        UserInterfaceMain.removeDatabaseChangeListener(this);
    }

    public Highlight2 addElectricObject(ElectricObject eobj, Cell cell) {
        return this.addElectricObject(eobj, cell, true);
    }

    public Highlight2 addElectricObject(ElectricObject eobj, Cell cell, boolean highlightConnected) {
        HighlightEOBJ h1 = new HighlightEOBJ(eobj, cell, highlightConnected, -1);
        this.addHighlight(h1);
        return h1;
    }

    public Highlight2 addElectricObject(ElectricObject eobj, Cell cell, Color col) {
        return this.addElectricObject(eobj, cell, true, col);
    }

    public Highlight2 addElectricObject(ElectricObject eobj, Cell cell, boolean highlightConnected, Color col) {
        HighlightEOBJ h1 = new HighlightEOBJ(eobj, cell, highlightConnected, -1, col);
        this.addHighlight(h1);
        return h1;
    }

    public Highlight2 addText(ElectricObject eobj, Cell cell, Variable.Key varKey) {
        HighlightText h1 = new HighlightText(eobj, cell, varKey);
        this.addHighlight(h1);
        return h1;
    }

    public Highlight2 addMessage(Cell cell, String message, Point2D loc) {
        HighlightMessage h1 = new HighlightMessage(cell, message, loc, 0);
        this.addHighlight(h1);
        return h1;
    }

    public Highlight2 addMessage(Cell cell, String message, Point2D loc, int corner) {
        HighlightMessage h1 = new HighlightMessage(cell, message, loc, corner);
        this.addHighlight(h1);
        return h1;
    }

    public Highlight2 addArea(Rectangle2D area, Cell cell) {
        HighlightArea h1 = new HighlightArea(cell, area);
        this.addHighlight(h1);
        return h1;
    }

    public Highlight2 addObject(Object obj, Cell cell) {
        HighlightObject h1 = new HighlightObject(cell, obj);
        this.addHighlight(h1);
        return h1;
    }

    public Highlight2 addLine(Point2D start, Point2D end, Cell cell) {
        HighlightLine h1 = new HighlightLine(cell, start, end, null, false);
        this.addHighlight(h1);
        return h1;
    }

    public Highlight2 addLine(Point2D start, Point2D end, Cell cell, boolean thick) {
        HighlightLine h1 = new HighlightLine(cell, start, end, null, thick);
        this.addHighlight(h1);
        return h1;
    }

    public Highlight2 addThickLine(Point2D start, Point2D end, Cell cell) {
        HighlightLine h1 = new HighlightLine(cell, start, end, null, true);
        this.addHighlight(h1);
        return h1;
    }

    public Highlight2 addPoly(Poly poly, Cell cell, Color color) {
        HighlightPoly h1 = new HighlightPoly(cell, poly, color);
        this.addHighlight(h1);
        return h1;
    }

    public void addNetwork(Network net, Cell cell) {
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted highlighting (network information unavailable).  Please try again");
            return;
        }
        HashSet<Network> nets = new HashSet<Network>();
        nets.add(net);
        List<Highlight2> highlights = NetworkHighlighter.getHighlights(cell, netlist, nets, 0, 0);
        for (Highlight2 h : highlights) {
            this.addHighlight(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showNetworks(Cell cell) {
        int showNetworkLevel;
        Object ni;
        List<NodeInst> nodes;
        Netlist netlist = cell.acquireUserNetlist();
        if (netlist == null) {
            System.out.println("Sorry, a deadlock aborted netlist display (network information unavailable).  Please try again");
            return;
        }
        Set<Network> nets = this.getHighlightedNetworks();
        if (nets.size() == 0 && (nodes = this.getHighlightedNodes()).size() == 1) {
            ni = nodes.get(0);
            Iterator<Connection> it = ((NodeInst)ni).getConnections();
            while (it.hasNext()) {
                Connection con = it.next();
                Network net = netlist.getNetwork(con.getPortInst());
                nets.add(net);
            }
        }
        ni = this;
        synchronized (ni) {
            showNetworkLevel = this.showNetworkLevel;
        }
        if (showNetworkLevel == 0) {
            ArrayList<Network> sortedNets = new ArrayList<Network>(nets);
            Collections.sort(sortedNets, new TextUtils.NetworksByName());
            for (Network net : sortedNets) {
                System.out.println("Highlighting " + net);
            }
            this.clear();
        }
        int count = 0;
        List<Highlight2> highlights = NetworkHighlighter.getHighlights(cell, netlist, nets, showNetworkLevel, showNetworkLevel);
        for (Highlight2 h : highlights) {
            this.addHighlight(h);
            ++count;
        }
        Highlighter highlighter = this;
        synchronized (highlighter) {
            this.showNetworkLevel = showNetworkLevel + 1;
        }
        if (count == 0) {
            System.out.println("Nothing more in hierarchy on network(s) to show");
        }
    }

    public synchronized void addHighlight(Highlight2 h) {
        if (h == null) {
            return;
        }
        this.highlightList.add(h);
        this.changed = true;
    }

    public void clear() {
        this.clear(true);
    }

    private synchronized void clear(boolean resetLastHighlightListEndObj) {
        this.highOffY = 0;
        this.highOffX = 0;
        this.showNetworkLevel = 0;
        if (this.highlightList.size() == 0) {
            return;
        }
        if (resetLastHighlightListEndObj) {
            this.lastHighlightListEndObj = this.highlightList.get(this.highlightList.size() - 1);
        }
        this.highlightList.clear();
        this.changed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finished() {
        Highlighter highlighter = this;
        synchronized (highlighter) {
            for (Highlight2 h : this.getHighlights()) {
                if (h.isValid()) continue;
                this.remove(h);
                this.changed = true;
            }
            if (!this.changed) {
                return;
            }
        }
        boolean mixedArc = false;
        ArcProto foundArcProto = null;
        for (Highlight2 h : this.getHighlights()) {
            ElectricObject eobj;
            if (!(h instanceof HighlightEOBJ) || !((eobj = ((HighlightEOBJ)h).eobj) instanceof ArcInst)) continue;
            ArcProto ap = ((ArcInst)eobj).getProto();
            if (foundArcProto == null) {
                foundArcProto = ap;
                continue;
            }
            if (foundArcProto == ap) continue;
            mixedArc = true;
        }
        if (this.type == 0 && foundArcProto != null && !mixedArc) {
            User.getUserTool().setCurrentArcProto(foundArcProto);
        }
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Highlighter.this.fireHighlightChanged();
                }
            });
        } else {
            this.fireHighlightChanged();
        }
    }

    public void ensureHighlightingSeen() {
        if (this.wf == null || !(this.wf.getContent() instanceof EditWindow)) {
            return;
        }
        EditWindow wnd = (EditWindow)this.wf.getContent();
        Rectangle2D bounds = this.getHighlightedArea(wnd);
        if (bounds == null) {
            return;
        }
        double boundsArea = bounds.getWidth() * bounds.getHeight();
        Rectangle2D displayBounds = wnd.displayableBounds();
        double displayArea = displayBounds.getWidth() * displayBounds.getHeight();
        Highlight2 line1 = null;
        Highlight2 line2 = null;
        Highlight2 line3 = null;
        Highlight2 line4 = null;
        if (bounds.getMinX() >= displayBounds.getMaxX() || bounds.getMaxX() <= displayBounds.getMinX() || bounds.getMinY() >= displayBounds.getMaxY() || bounds.getMaxY() <= displayBounds.getMinY()) {
            Point2D.Double fromPt = new Point2D.Double(displayBounds.getCenterX(), displayBounds.getCenterY());
            Point2D.Double toPt = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
            GenMath.clipLine(fromPt, toPt, displayBounds.getMinX(), displayBounds.getMaxX(), displayBounds.getMinY(), displayBounds.getMaxY());
            if (((Point2D)fromPt).getX() != displayBounds.getCenterX() || ((Point2D)fromPt).getY() != displayBounds.getCenterY()) {
                Point2D.Double swap = fromPt;
                fromPt = toPt;
                toPt = swap;
            }
            line1 = this.addLine(fromPt, toPt, wnd.getCell());
            int angle = GenMath.figureAngle(fromPt, toPt);
            double headLength = fromPt.distance(toPt) / 10.0;
            double xLeft = ((Point2D)toPt).getX() - headLength * DBMath.cos(angle + 150);
            double yLeft = ((Point2D)toPt).getY() - headLength * DBMath.sin(angle + 150);
            double xRight = ((Point2D)toPt).getX() - headLength * DBMath.cos(angle - 150);
            double yRight = ((Point2D)toPt).getY() - headLength * DBMath.sin(angle - 150);
            line2 = this.addLine(new Point2D.Double(xLeft, yLeft), toPt, wnd.getCell());
            line3 = this.addLine(new Point2D.Double(xRight, yRight), toPt, wnd.getCell());
        } else if (boundsArea * 500.0 < displayArea) {
            if (bounds.getMinX() > displayBounds.getMinX() && bounds.getMinY() > displayBounds.getMinY()) {
                line1 = this.addLine(new Point2D.Double(displayBounds.getMinX(), displayBounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), wnd.getCell());
            }
            if (bounds.getMinX() > displayBounds.getMinX() && bounds.getMaxY() < displayBounds.getMaxY()) {
                line2 = this.addLine(new Point2D.Double(displayBounds.getMinX(), displayBounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), wnd.getCell());
            }
            if (bounds.getMaxX() < displayBounds.getMaxX() && bounds.getMinY() > displayBounds.getMinY()) {
                line3 = this.addLine(new Point2D.Double(displayBounds.getMaxX(), displayBounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), wnd.getCell());
            }
            if (bounds.getMaxX() < displayBounds.getMaxX() && bounds.getMaxY() < displayBounds.getMaxY()) {
                line4 = this.addLine(new Point2D.Double(displayBounds.getMaxX(), displayBounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), wnd.getCell());
            }
        }
        if (line1 != null || line2 != null || line3 != null || line4 != null) {
            Timer timer = new Timer(500, new FlashActionListener(this, line1, line2, line3, line4));
            timer.setRepeats(false);
            timer.start();
        }
    }

    private synchronized Highlight2 getLastSelected(List<Highlight2> underCursor) {
        List<Highlight2> currentHighlights = this.getHighlights();
        for (Highlight2 h : underCursor) {
            for (Highlight2 curHigh : currentHighlights) {
                if (!h.sameThing(curHigh)) continue;
                return this.lastHighlightListEndObj;
            }
        }
        if (currentHighlights.size() > 0) {
            return currentHighlights.get(currentHighlights.size() - 1);
        }
        return this.lastHighlightListEndObj;
    }

    public synchronized void copyState(Highlighter highlighter) {
        this.clear();
        this.lastHighlightListEndObj = highlighter.lastHighlightListEndObj;
        for (Highlight2 h : highlighter.getHighlights()) {
            Highlight2 copy = (Highlight2)h.clone();
            this.addHighlight(copy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showHighlights(EditWindow wnd, Graphics g) {
        int highOffY;
        int highOffX;
        int num = this.getNumHighlights();
        Highlighter highlighter = this;
        synchronized (highlighter) {
            highOffX = this.highOffX;
            highOffY = this.highOffY;
        }
        List<Highlight2> list = this.highlightList;
        Color colorH = new Color(User.getColor(User.ColorPrefType.HIGHLIGHT));
        Color colorM = new Color(User.getColor(User.ColorPrefType.MOUSEOVER_HIGHLIGHT));
        BasicStroke stroke = Highlight2.solidLine;
        for (Highlight2 h : list) {
            if (h.getCell() != wnd.getCell()) continue;
            boolean setConnected = User.isHighlightConnectedObjects();
            Color color = colorH;
            if (this.type == 1) {
                color = colorM;
                setConnected = false;
            }
            h.showHighlight(wnd, g, highOffX, highOffY, num == 1, color, stroke, setConnected);
        }
    }

    public WindowFrame getWindowFrame() {
        return this.wf;
    }

    public static synchronized void addHighlightListener(HighlightListener l) {
        highlightListeners.add(l);
    }

    public static synchronized void removeHighlightListener(HighlightListener l) {
        highlightListeners.remove(l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHighlightChanged() {
        if (this.type == 0) {
            ArrayList<HighlightListener> listenersCopy;
            Highlighter highlighter = this;
            synchronized (highlighter) {
                listenersCopy = new ArrayList<HighlightListener>(highlightListeners);
            }
            for (HighlightListener l : listenersCopy) {
                l.highlightChanged(this);
            }
        }
        Highlighter highlighter = this;
        synchronized (highlighter) {
            this.changed = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void fireHighlighterLostFocus(Highlighter highlighterGainedFocus) {
        if (this.type == 0) {
            ArrayList<HighlightListener> listenersCopy;
            Highlighter highlighter = this;
            synchronized (highlighter) {
                listenersCopy = new ArrayList<HighlightListener>(highlightListeners);
            }
            for (HighlightListener l : listenersCopy) {
                l.highlighterLostFocus(highlighterGainedFocus);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void gainedFocus() {
        Highlighter oldHighlighter = null;
        Highlighter highlighter = currentHighlighter;
        synchronized (highlighter) {
            oldHighlighter = currentHighlighter;
            currentHighlighter = this;
        }
        if (oldHighlighter != null && oldHighlighter != this) {
            oldHighlighter.fireHighlighterLostFocus(this);
        }
    }

    public synchronized void pushHighlight() {
        ArrayList<Highlight2> pushable = new ArrayList<Highlight2>();
        for (Highlight2 h : this.highlightList) {
            pushable.add(h);
        }
        this.highlightStack.add(pushable);
    }

    public synchronized void popHighlight() {
        int stackSize = this.highlightStack.size();
        if (stackSize <= 0) {
            System.out.println("There is no highlighting saved on the highlight stack");
            return;
        }
        List<Highlight2> popable = this.highlightStack.get(stackSize - 1);
        this.highlightStack.remove(stackSize - 1);
        this.clear();
        for (Highlight2 h : popable) {
            ElectricObject eobj;
            Highlight2 hh;
            Cell cell = h.getCell();
            if (h instanceof HighlightEOBJ) {
                hh = (HighlightEOBJ)h;
                eobj = hh.eobj;
                if (!cell.objInCell(eobj)) continue;
                HighlightEOBJ newH = (HighlightEOBJ)this.addElectricObject(eobj, cell);
                newH.point = hh.point;
                continue;
            }
            if (h instanceof HighlightText) {
                hh = (HighlightText)h;
                eobj = ((HighlightText)hh).eobj;
                if (!cell.objInCell(eobj)) continue;
                this.addText(eobj, cell, ((HighlightText)hh).varKey);
                continue;
            }
            if (h instanceof HighlightArea) {
                hh = (HighlightArea)h;
                this.addArea(((HighlightArea)hh).bounds, cell);
                continue;
            }
            if (h instanceof HighlightLine) {
                hh = (HighlightLine)h;
                if (((HighlightLine)hh).thickLine) {
                    this.addThickLine(((HighlightLine)hh).start, ((HighlightLine)hh).end, cell);
                    continue;
                }
                this.addLine(((HighlightLine)hh).start, ((HighlightLine)hh).end, cell);
                continue;
            }
            if (!(h instanceof HighlightMessage)) continue;
            hh = (HighlightMessage)h;
            this.addMessage(cell, ((HighlightMessage)hh).msg, ((HighlightMessage)hh).loc);
        }
        this.finished();
    }

    public synchronized void remove(Highlight2 h) {
        this.highlightList.remove(h);
    }

    public synchronized int getNumHighlights() {
        return this.highlightList.size();
    }

    public synchronized List<Highlight2> getHighlights() {
        ArrayList<Highlight2> highlightsCopy = new ArrayList<Highlight2>(this.highlightList);
        return highlightsCopy;
    }

    public synchronized void setHighlightListGeneral(List<Highlight2> newHighlights) {
        this.clear();
        for (Highlight2 obj : newHighlights) {
            this.highlightList.add(obj);
        }
        this.changed = true;
    }

    public synchronized void setHighlightList(List<Highlight2> newHighlights) {
        this.clear();
        for (Highlight2 obj : newHighlights) {
            this.highlightList.add(obj);
        }
        this.changed = true;
    }

    public List<Geometric> getHighlightedEObjs(boolean wantNodes, boolean wantArcs) {
        ArrayList<Geometric> highlightedGeoms = new ArrayList<Geometric>();
        for (Highlight2 h : this.getHighlights()) {
            h.getHighlightedEObjs(this, highlightedGeoms, wantNodes, wantArcs);
        }
        return highlightedGeoms;
    }

    public List<NodeInst> getHighlightedNodes() {
        ArrayList<NodeInst> highlightedNodes = new ArrayList<NodeInst>();
        for (Highlight2 h : this.getHighlights()) {
            h.getHighlightedNodes(this, highlightedNodes);
        }
        return highlightedNodes;
    }

    public List<ArcInst> getHighlightedArcs() {
        ArrayList<ArcInst> highlightedArcs = new ArrayList<ArcInst>();
        for (Highlight2 h : this.getHighlights()) {
            h.getHighlightedArcs(this, highlightedArcs);
        }
        return highlightedArcs;
    }

    public Set<Network> getHighlightedNetworks() {
        WindowFrame wf = WindowFrame.getCurrentWindowFrame();
        if (wf.getContent() instanceof WaveformWindow) {
            WaveformWindow ww = (WaveformWindow)wf.getContent();
            return ww.getHighlightedNetworks();
        }
        HashSet<Network> nets = new HashSet<Network>();
        Cell cell = WindowFrame.getCurrentCell();
        if (cell != null) {
            Netlist netlist = cell.acquireUserNetlist();
            if (netlist == null) {
                String msg = "Selected networks are not ready";
                System.out.println(msg);
                ActivityLogger.logMessage(msg);
                return nets;
            }
            for (Highlight2 h : this.getHighlights()) {
                h.getHighlightedNetworks(nets, netlist);
            }
        }
        return nets;
    }

    public List<DisplayedText> getHighlightedText(boolean unique) {
        ArrayList<DisplayedText> highlightedText = new ArrayList<DisplayedText>();
        for (Highlight2 h : this.getHighlights()) {
            h.getHighlightedText(highlightedText, unique, this.getHighlights());
        }
        return highlightedText;
    }

    public Rectangle2D getHighlightedArea(EditWindow wnd) {
        Rectangle2D.Double bounds = null;
        for (Highlight2 h : this.getHighlights()) {
            Rectangle2D highBounds = h.getHighlightedArea(wnd);
            if (highBounds == null) continue;
            if (bounds == null) {
                bounds = new Rectangle2D.Double();
                ((Rectangle2D)bounds).setRect(highBounds);
                continue;
            }
            Rectangle2D.union(bounds, highBounds, bounds);
        }
        return bounds;
    }

    public Highlight2 getOneHighlight() {
        if (this.getNumHighlights() == 0) {
            System.out.println("Must select an object first");
            return null;
        }
        Highlight2 h = null;
        for (Highlight2 theH : this.getHighlights()) {
            if (theH.getElectricObject() == null) continue;
            return theH;
        }
        if (h == null) {
            System.out.println("Must select an object first");
            return null;
        }
        return h;
    }

    public ElectricObject getOneElectricObject(Class type) {
        Highlight2 high = this.getOneHighlight();
        if (high == null) {
            return null;
        }
        if (!(high instanceof HighlightEOBJ)) {
            System.out.println("Must first select an object");
            return null;
        }
        ElectricObject eobj = high.getElectricObject();
        if (type == NodeInst.class && eobj instanceof PortInst) {
            eobj = ((PortInst)eobj).getNodeInst();
        }
        if (!type.isInstance(eobj)) {
            System.out.println("Wrong type of object is selected");
            System.out.println(" (Wanted " + this.getClassName(type) + " but got " + this.getClassName(eobj.getClass()) + ")");
            return null;
        }
        return eobj;
    }

    private String getClassName(Class type) {
        if (type == NodeInst.class) {
            return "Node";
        }
        if (type == ArcInst.class) {
            return "Arc";
        }
        return type.toString();
    }

    public synchronized void setHighlightOffset(int offX, int offY) {
        this.highOffX = offX;
        this.highOffY = offY;
    }

    public synchronized Point2D getHighlightOffset() {
        return new Point2D.Double(this.highOffX, this.highOffY);
    }

    public void selectArea(EditWindow wnd, double minSelX, double maxSelX, double minSelY, double maxSelY, boolean invertSelection, boolean findSpecial) {
        Rectangle2D.Double searchArea = new Rectangle2D.Double(minSelX, minSelY, maxSelX - minSelX, maxSelY - minSelY);
        List<Highlight2> underCursor = Highlighter.findAllInArea(this, wnd.getCell(), false, false, false, false, findSpecial, true, searchArea, wnd);
        if (invertSelection) {
            for (Highlight2 newHigh : underCursor) {
                boolean found = false;
                for (Highlight2 oldHigh : this.getHighlights()) {
                    if (!newHigh.sameThing(oldHigh)) continue;
                    this.remove(oldHigh);
                    found = true;
                    break;
                }
                if (found) continue;
                this.addHighlight(newHigh);
            }
        } else {
            this.setHighlightList(underCursor);
        }
    }

    public Highlight2 overHighlighted(EditWindow wnd, int x, int y) {
        for (Highlight2 h : this.getHighlights()) {
            if (!h.overHighlighted(wnd, x, y, this)) continue;
            return h;
        }
        return null;
    }

    private static Poly.Type getHighlightTextStyleBounds(EditWindow wnd, ElectricObject eObj, Variable.Key varKey, Rectangle2D bounds) {
        if (eObj == null) {
            return null;
        }
        Poly poly = eObj.computeTextPoly(wnd, varKey);
        if (poly == null) {
            return null;
        }
        bounds.setRect(poly.getBounds2D());
        Poly.Type style = poly.getStyle();
        if (style != Poly.Type.TEXTCENT && style != Poly.Type.TEXTBOX) {
            int rotation;
            style = Poly.rotateType(style, eObj);
            TextDescriptor td = poly.getTextDescriptor();
            if (td != null && (rotation = td.getRotation().getIndex()) != 0) {
                int angle = style.getTextAngle();
                style = Poly.Type.getTextTypeFromAngle((angle + 900 * rotation) % 3600);
            }
        }
        if (style == Poly.Type.TEXTBOX && eObj instanceof Geometric) {
            bounds.setRect(((Geometric)eObj).getBounds());
        }
        return style;
    }

    public static Point2D[] describeHighlightText(EditWindow wnd, ElectricObject eObj, Variable.Key varKey) {
        Rectangle2D.Double bounds = new Rectangle2D.Double();
        Poly.Type style = null;
        style = Highlighter.getHighlightTextStyleBounds(wnd, eObj, varKey, bounds);
        if (style == null) {
            return null;
        }
        Point2D[] points = null;
        if (style == Poly.Type.TEXTCENT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY())};
        } else if (style == Poly.Type.TEXTBOT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY())};
        } else if (style == Poly.Type.TEXTTOP) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY())};
        } else if (style == Poly.Type.TEXTLEFT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY())};
        } else if (style == Poly.Type.TEXTRIGHT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY())};
        } else if (style == Poly.Type.TEXTTOPLEFT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY())};
        } else if (style == Poly.Type.TEXTBOTLEFT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY())};
        } else if (style == Poly.Type.TEXTTOPRIGHT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY())};
        } else if (style == Poly.Type.TEXTBOTRIGHT) {
            points = new Point2D.Double[]{new Point2D.Double(bounds.getMinX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMinY()), new Point2D.Double(bounds.getMaxX(), bounds.getMaxY())};
        } else if (style == Poly.Type.TEXTBOX) {
            points = new Point2D.Double[12];
            double lX = bounds.getMinX();
            double hX = bounds.getMaxX();
            double lY = bounds.getMinY();
            double hY = bounds.getMaxY();
            points[0] = new Point2D.Double(lX, lY);
            points[1] = new Point2D.Double(hX, hY);
            points[2] = new Point2D.Double(lX, hY);
            points[3] = new Point2D.Double(hX, lY);
            double shrinkX = (hX - lX) / 5.0;
            double shrinkY = (hY - lY) / 5.0;
            points[4] = new Point2D.Double(lX + shrinkX, lY);
            points[5] = new Point2D.Double(hX - shrinkX, lY);
            points[6] = new Point2D.Double(lX + shrinkX, hY);
            points[7] = new Point2D.Double(hX - shrinkX, hY);
            points[8] = new Point2D.Double(lX, lY + shrinkY);
            points[9] = new Point2D.Double(lX, hY - shrinkY);
            points[10] = new Point2D.Double(hX, lY + shrinkY);
            points[11] = new Point2D.Double(hX, hY - shrinkY);
        }
        return points;
    }

    public Highlight2 findObject(Point2D pt, EditWindow wnd, boolean exclusively, boolean another, boolean invert, boolean findPort, boolean findPoint, boolean findSpecial, boolean findText) {
        List<Highlight2> highlightList;
        Cell cell = wnd.getCell();
        Rectangle2D.Double bounds = new Rectangle2D.Double(pt.getX(), pt.getY(), 0.0, 0.0);
        List<Highlight2> underCursor = Highlighter.findAllInArea(this, cell, exclusively, another, findPort, findPoint, findSpecial, findText, bounds, wnd);
        Highlight2 found = null;
        if (underCursor.size() == 0) {
            if (!invert) {
                this.clear();
                this.finished();
            }
            return found;
        }
        Highlight2 lastSelected = this.getLastSelected(underCursor);
        if (lastSelected != null) {
            ArrayList<Highlight2> newUnderCursor = new ArrayList<Highlight2>();
            while (!underCursor.isEmpty()) {
                Highlight2 h = Highlighter.getSimiliarHighlight(underCursor, lastSelected);
                newUnderCursor.add(h);
                underCursor.remove(h);
            }
            underCursor = newUnderCursor;
        }
        if (underCursor.size() > 1 && another) {
            highlightList = this.getHighlights();
            for (int j = 0; j < this.getNumHighlights(); ++j) {
                Highlight2 oldHigh = highlightList.get(j);
                for (int i = 0; i < underCursor.size(); ++i) {
                    if (!oldHigh.sameThing(underCursor.get(i))) continue;
                    if (invert) {
                        this.remove(oldHigh);
                    } else {
                        this.clear(false);
                    }
                    found = i < underCursor.size() - 1 ? underCursor.get(i + 1) : underCursor.get(0);
                    this.addHighlight(found);
                    this.finished();
                    return found;
                }
            }
        }
        found = underCursor.get(0);
        if (invert) {
            highlightList = this.getHighlights();
            for (Highlight2 h : highlightList) {
                if (!found.sameThing(h)) continue;
                this.remove(h);
                this.finished();
                return found;
            }
        } else {
            this.clear();
        }
        this.addHighlight(found);
        this.finished();
        return found;
    }

    public static List<Highlight2> findAllInArea(Highlighter highlighter, Cell cell, boolean exclusively, boolean another, boolean findPort, boolean findPoint, boolean findSpecial, boolean findText, Rectangle2D bounds, EditWindow wnd) {
        ArrayList<Highlight2> list = new ArrayList<Highlight2>();
        double directHitDist = Double.MIN_VALUE;
        if (wnd != null) {
            Point2D extra = wnd.deltaScreenToDatabase(5, 5);
            directHitDist = Math.abs(extra.getX());
        }
        if (findText && wnd != null) {
            Highlighter.findTextNow(cell, wnd, directHitDist, bounds, findSpecial, list);
        }
        boolean areaMustEnclose = User.isDraggingMustEncloseObjects();
        if (exclusively) {
            for (Highlight2 h : highlighter.getHighlights()) {
                if (!(h instanceof HighlightEOBJ)) continue;
                ElectricObject eobj = h.getElectricObject();
                if (eobj instanceof PortInst) {
                    eobj = ((PortInst)eobj).getNodeInst();
                }
                if (!(eobj instanceof NodeInst) || (h = Highlighter.checkOutObject((Geometric)eobj, findPort, findPoint, findSpecial, bounds, wnd, Double.MAX_VALUE, areaMustEnclose)) == null) continue;
                list.add(h);
            }
            return list;
        }
        Rectangle2D.Double searchArea = new Rectangle2D.Double(bounds.getMinX() - directHitDist, bounds.getMinY() - directHitDist, bounds.getWidth() + directHitDist * 2.0, bounds.getHeight() + directHitDist * 2.0);
        for (int phase = 0; phase < 3; ++phase) {
            Iterator<RTBounds> it = cell.searchIterator(searchArea);
            while (it.hasNext()) {
                Geometric geom = (Geometric)it.next();
                switch (phase) {
                    case 0: {
                        Highlight2 h;
                        if (!(geom instanceof NodeInst) || ((NodeInst)geom).isCellInstance() || (h = Highlighter.checkOutObject(geom, findPort, findPoint, findSpecial, bounds, wnd, directHitDist, areaMustEnclose)) == null) break;
                        list.add(h);
                        break;
                    }
                    case 1: {
                        Highlight2 h;
                        if (!findSpecial && !User.isEasySelectionOfCellInstances() || !(geom instanceof NodeInst) || !((NodeInst)geom).isCellInstance() || (h = Highlighter.checkOutObject(geom, findPort, findPoint, findSpecial, bounds, wnd, directHitDist, areaMustEnclose)) == null) break;
                        list.add(h);
                        break;
                    }
                    case 2: {
                        Highlight2 h;
                        if (!(geom instanceof ArcInst) || (h = Highlighter.checkOutObject(geom, findPort, findPoint, findSpecial, bounds, wnd, directHitDist, areaMustEnclose)) == null) break;
                        list.add(h);
                    }
                }
            }
        }
        return list;
    }

    private static void findTextNow(Cell cell, EditWindow wnd, double directHitDist, Rectangle2D bounds, boolean findSpecial, List<Highlight2> list) {
        LayerVisibility lv = wnd.getLayerVisibility();
        RTNode rtn = wnd.getTextInCell();
        if (rtn == null) {
            Poly.Type style;
            Variable var;
            Iterator<Variable> vIt;
            Poly.Type style2;
            Poly[] polys;
            rtn = RTNode.makeTopLevel();
            Rectangle2D.Double textBounds = new Rectangle2D.Double();
            if (User.isTextVisibilityOnCell() && (polys = cell.getAllText(findSpecial, wnd)) != null) {
                for (int i = 0; i < polys.length; ++i) {
                    Poly poly = polys[i];
                    if (poly == null || poly.setExactTextBounds(wnd, cell)) continue;
                    rtn = RTNode.linkGeom(null, rtn, new TextHighlightBound(poly.getBounds2D(), cell, poly.getDisplayedText().getVariableKey()));
                }
            }
            Iterator<Geometric> it = cell.getNodes();
            while (it.hasNext()) {
                NodeProto np;
                NodeInst ni = it.next();
                if (ni == null) {
                    if (!Job.getDebug()) continue;
                    System.out.println("Something is wrong in Highlighter:findAllInArea");
                    continue;
                }
                if (User.isTextVisibilityOnNode()) {
                    if (ni.isCellInstance() && !ni.isExpanded() && findSpecial && User.isTextVisibilityOnInstance() && (style2 = Highlighter.getHighlightTextStyleBounds(wnd, ni, NodeInst.NODE_PROTO, textBounds)) != null) {
                        rtn = RTNode.linkGeom(null, rtn, new TextHighlightBound(textBounds, ni, NodeInst.NODE_PROTO));
                    }
                    if (ni.isUsernamed() && (style2 = Highlighter.getHighlightTextStyleBounds(wnd, ni, NodeInst.NODE_NAME, textBounds)) != null) {
                        rtn = RTNode.linkGeom(null, rtn, new TextHighlightBound(textBounds, ni, NodeInst.NODE_NAME));
                    }
                    if (ni.getProto() != Generic.tech().invisiblePinNode || User.isTextVisibilityOnAnnotation()) {
                        vIt = ni.getParametersAndVariables();
                        while (vIt.hasNext()) {
                            var = vIt.next();
                            if (!var.isDisplay() || (style = Highlighter.getHighlightTextStyleBounds(wnd, ni, var.getKey(), textBounds)) == null) continue;
                            rtn = RTNode.linkGeom(null, rtn, new TextHighlightBound(textBounds, ni, var.getKey()));
                        }
                    }
                    if (User.isTextVisibilityOnPort()) {
                        Iterator<PortInst> pIt = ni.getPortInsts();
                        while (pIt.hasNext()) {
                            PortInst pi = pIt.next();
                            Iterator<Variable> vIt2 = pi.getVariables();
                            while (vIt2.hasNext()) {
                                Poly.Type style3;
                                Variable var2 = vIt2.next();
                                if (!var2.isDisplay() || (style3 = Highlighter.getHighlightTextStyleBounds(wnd, pi, var2.getKey(), textBounds)) == null) continue;
                                rtn = RTNode.linkGeom(null, rtn, new TextHighlightBound(textBounds, pi, var2.getKey()));
                            }
                        }
                    }
                }
                if (!User.isTextVisibilityOnExport() || (np = ni.getProto()) instanceof PrimitiveNode && !lv.isVisible((PrimitiveNode)np)) continue;
                Iterator<Export> eIt = ni.getExports();
                while (eIt.hasNext()) {
                    Export pp = eIt.next();
                    if (pp == null) continue;
                    Poly.Type style4 = Highlighter.getHighlightTextStyleBounds(wnd, pp, Export.EXPORT_NAME, textBounds);
                    if (style4 != null) {
                        rtn = RTNode.linkGeom(null, rtn, new TextHighlightBound(textBounds, pp, Export.EXPORT_NAME));
                    }
                    Iterator<Variable> vIt3 = pp.getVariables();
                    while (vIt3.hasNext()) {
                        Variable var3 = vIt3.next();
                        if (!var3.isDisplay() || (style4 = Highlighter.getHighlightTextStyleBounds(wnd, pp, var3.getKey(), textBounds)) == null) continue;
                        rtn = RTNode.linkGeom(null, rtn, new TextHighlightBound(textBounds, pp, var3.getKey()));
                    }
                }
            }
            if (User.isTextVisibilityOnArc()) {
                it = cell.getArcs();
                while (it.hasNext()) {
                    ArcInst ai = (ArcInst)it.next();
                    if (ai.isUsernamed() && (style2 = Highlighter.getHighlightTextStyleBounds(wnd, ai, ArcInst.ARC_NAME, textBounds)) != null) {
                        rtn = RTNode.linkGeom(null, rtn, new TextHighlightBound(textBounds, ai, ArcInst.ARC_NAME));
                    }
                    vIt = ai.getVariables();
                    while (vIt.hasNext()) {
                        var = vIt.next();
                        if (!var.isDisplay() || (style = Highlighter.getHighlightTextStyleBounds(wnd, ai, var.getKey(), textBounds)) == null) continue;
                        rtn = RTNode.linkGeom(null, rtn, new TextHighlightBound(textBounds, ai, var.getKey()));
                    }
                }
            }
            wnd.setTextInCell(rtn);
        }
        Rectangle2D.Double searchArea = new Rectangle2D.Double(bounds.getMinX() - directHitDist, bounds.getMinY() - directHitDist, bounds.getWidth() + directHitDist * 2.0, bounds.getHeight() + directHitDist * 2.0);
        RTNode.Search sea = new RTNode.Search(searchArea, rtn, true);
        while (sea.hasNext()) {
            TextHighlightBound thb = (TextHighlightBound)sea.next();
            if (!Highlighter.boundsIsHit(thb.getBounds(), bounds, directHitDist)) continue;
            list.add(new HighlightText(thb.getElectricObject(), cell, thb.getKey()));
        }
    }

    private static boolean boundsIsHit(Rectangle2D bounds, Rectangle2D selection, double directHitDist) {
        boolean areaMustEnclose = User.isDraggingMustEncloseObjects();
        if (areaMustEnclose && (selection.getHeight() > 0.0 || selection.getWidth() > 0.0)) {
            if (bounds.getMaxX() > selection.getMaxX()) {
                return false;
            }
            if (bounds.getMinX() < selection.getMinX()) {
                return false;
            }
            if (bounds.getMaxY() > selection.getMaxY()) {
                return false;
            }
            if (bounds.getMinY() < selection.getMinY()) {
                return false;
            }
        } else {
            double dist1 = selection.getMinX() - bounds.getMaxX();
            double dist2 = bounds.getMinX() - selection.getMaxX();
            double dist3 = selection.getMinY() - bounds.getMaxY();
            double dist4 = bounds.getMinY() - selection.getMaxY();
            double worstDist = Math.max(Math.max(dist1, dist2), Math.max(dist3, dist4));
            if (worstDist > directHitDist) {
                return false;
            }
        }
        return true;
    }

    public static Highlight2 checkOutObject(Geometric geom, boolean findPort, boolean findPoint, boolean findSpecial, Rectangle2D bounds, EditWindow wnd, double directHitDist, boolean areaMustEnclose) {
        LayerVisibility lv;
        LayerVisibility layerVisibility = lv = wnd != null ? wnd.getLayerVisibility() : LayerVisibility.getLayerVisibility();
        if (geom instanceof NodeInst) {
            PrimitiveNode np;
            NodeInst ni = (NodeInst)geom;
            boolean hardToSelect = ni.isHardSelect();
            if (ni.isCellInstance()) {
                if (!User.isEasySelectionOfCellInstances()) {
                    hardToSelect = true;
                }
            } else if (!User.isHighlightInvisibleObjects() && !lv.isVisible(np = (PrimitiveNode)ni.getProto())) {
                return null;
            }
            if (!findSpecial && hardToSelect) {
                return null;
            }
            if (ni.isInvisiblePinWithText()) {
                return null;
            }
            if (areaMustEnclose && (bounds.getHeight() > 0.0 || bounds.getWidth() > 0.0)) {
                Poly poly = Highlight2.getNodeInstOutline(ni);
                if (poly == null) {
                    return null;
                }
                if (!poly.isInside(bounds)) {
                    return null;
                }
                return new HighlightEOBJ(geom, geom.getParent(), true, -1);
            }
            double dist = Highlighter.distToNode(bounds, ni, wnd);
            if (dist <= directHitDist) {
                HighlightEOBJ h = new HighlightEOBJ(null, geom.getParent(), true, -1);
                Geometric eobj = geom;
                if (findPort) {
                    double bestDist = Double.MAX_VALUE;
                    PortInst bestPort = null;
                    Iterator<PortInst> it = ni.getPortInsts();
                    while (it.hasNext()) {
                        Poly poly;
                        PortInst pi = it.next();
                        PortProto pp = pi.getPortProto();
                        if (pp instanceof PrimitivePort && ((PrimitivePort)pp).isWellPort() && !findSpecial || !((dist = (poly = pi.getPoly()).polyDistance(bounds)) < bestDist)) continue;
                        bestDist = dist;
                        bestPort = pi;
                    }
                    if (bestPort != null) {
                        eobj = bestPort;
                    }
                }
                if (findPoint) {
                    EPoint[] points = ni.getTrace();
                    Point2D.Double cursor = new Point2D.Double(bounds.getCenterX(), bounds.getCenterY());
                    if (points != null) {
                        double bestDist = Double.MAX_VALUE;
                        int bestPoint = -1;
                        AffineTransform trans = ni.rotateOutAboutTrueCenter();
                        for (int i = 0; i < points.length; ++i) {
                            if (points[i] == null) continue;
                            Point2D.Double pt = new Point2D.Double(ni.getAnchorCenterX() + ((Point2D)points[i]).getX(), ni.getAnchorCenterY() + ((Point2D)points[i]).getY());
                            trans.transform(pt, pt);
                            dist = pt.distance(cursor);
                            if (!(dist < bestDist)) continue;
                            bestDist = dist;
                            bestPoint = i;
                        }
                        if (bestPoint >= 0) {
                            h.point = bestPoint;
                        }
                    }
                }
                h.eobj = eobj;
                return h;
            }
        } else {
            ArcInst ai = (ArcInst)geom;
            if (!findSpecial && ai.isHardSelect()) {
                return null;
            }
            if (!User.isHighlightInvisibleObjects() && !lv.isVisible(ai.getProto())) {
                return null;
            }
            if (areaMustEnclose && (bounds.getHeight() > 0.0 || bounds.getWidth() > 0.0)) {
                Poly poly = ai.makeLambdaPoly(ai.getGridBaseWidth(), Poly.Type.CLOSED);
                if (poly == null) {
                    return null;
                }
                if (!poly.isInside(bounds)) {
                    return null;
                }
                HighlightEOBJ h = new HighlightEOBJ(geom, geom.getParent(), true, -1);
                return h;
            }
            double dist = Highlighter.distToArc(bounds, ai, wnd);
            if (dist <= directHitDist) {
                HighlightEOBJ h = new HighlightEOBJ(geom, geom.getParent(), true, -1);
                return h;
            }
        }
        return null;
    }

    public static Highlight2 getSimiliarHighlight(List<Highlight2> highlights, Highlight2 exampleHigh) {
        if (highlights.size() == 0) {
            return null;
        }
        if (exampleHigh == null) {
            return highlights.get(0);
        }
        ArrayList<Highlight2> sameTypes = new ArrayList<Highlight2>();
        for (Highlight2 h : highlights) {
            if (h.getClass() != exampleHigh.getClass()) continue;
            sameTypes.add(h);
        }
        if (sameTypes.size() == 1) {
            return (Highlight2)sameTypes.get(0);
        }
        if (sameTypes.size() == 0) {
            return highlights.get(0);
        }
        if (exampleHigh.isHighlightEOBJ()) {
            ArcInst exAi;
            ArrayList<Highlight2> sameEObj = new ArrayList<Highlight2>();
            for (Highlight2 h : sameTypes) {
                if (h.getElectricObject().getClass() != exampleHigh.getElectricObject().getClass()) continue;
                sameEObj.add(h);
            }
            if (sameEObj.size() == 1) {
                return (Highlight2)sameEObj.get(0);
            }
            if (sameEObj.size() > 0) {
                if (exampleHigh.getElectricObject().getClass() == PortInst.class) {
                    PortInst pi;
                    PortInst exPi = (PortInst)exampleHigh.getElectricObject();
                    NodeProto exNp = exPi.getNodeInst().getProto();
                    for (Highlight2 h : sameEObj) {
                        pi = (PortInst)h.getElectricObject();
                        NodeProto np = pi.getNodeInst().getProto();
                        if (np != exNp) continue;
                        return h;
                    }
                    for (Highlight2 h : sameEObj) {
                        pi = (PortInst)h.getElectricObject();
                        if (Router.getArcToUse(exPi.getPortProto(), pi.getPortProto()) == null) continue;
                        return h;
                    }
                }
                if (exampleHigh.getElectricObject().getClass() == ArcInst.class) {
                    exAi = (ArcInst)exampleHigh.getElectricObject();
                    ArcProto exAp = exAi.getProto();
                    for (Highlight2 h : sameEObj) {
                        ArcInst ai = (ArcInst)h.getElectricObject();
                        ArcProto ap = ai.getProto();
                        if (exAp != ap) continue;
                        return h;
                    }
                }
            } else {
                exAi = null;
                PortInst exPi = null;
                if (exampleHigh.getElectricObject().getClass() == ArcInst.class) {
                    exAi = (ArcInst)exampleHigh.getElectricObject();
                }
                if (exampleHigh.getElectricObject().getClass() == PortInst.class) {
                    exPi = (PortInst)exampleHigh.getElectricObject();
                }
                for (Highlight2 h : sameTypes) {
                    ArcInst ai = exAi;
                    PortInst pi = exPi;
                    if (h.getElectricObject().getClass() == ArcInst.class) {
                        ai = (ArcInst)h.getElectricObject();
                    }
                    if (h.getElectricObject().getClass() == PortInst.class) {
                        pi = (PortInst)h.getElectricObject();
                    }
                    if (ai == null || pi == null || !pi.getPortProto().connectsTo(ai.getProto())) continue;
                    return h;
                }
            }
            if (sameEObj.size() > 0) {
                return (Highlight2)sameEObj.get(0);
            }
        }
        return (Highlight2)sameTypes.get(0);
    }

    public static double distToNode(Rectangle2D bounds, NodeInst ni, EditWindow wnd) {
        AffineTransform trans = ni.rotateOut();
        NodeProto np = ni.getProto();
        if (!ni.isCellInstance()) {
            PrimitiveNode.Function fun = np.getFunction();
            if (fun.isFET() || !ni.isCellInstance() && fun.isResistor() && ((PrimitiveNode)np).getSpecialType() == 2) {
                Technology tech = np.getTechnology();
                double bestDist = Double.MAX_VALUE;
                Poly[] polys = tech.getShapeOfNode(ni);
                for (int box = 0; box < polys.length; ++box) {
                    Layer.Function lf;
                    Poly poly = polys[box];
                    Layer layer = poly.getLayer();
                    if (layer == null || !(lf = layer.getFunction()).isPoly() && !lf.isDiff() && !lf.isMetal()) continue;
                    poly.transform(trans);
                    double dist = poly.polyDistance(bounds);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                }
                if (wnd != null) {
                    for (Poly poly : ni.getDisplayableVariables(wnd)) {
                        Layer.Function lf;
                        Layer layer = poly.getLayer();
                        if (layer == null || !(lf = layer.getFunction()).isPoly() && !lf.isDiff() && !lf.isMetal()) continue;
                        poly.transform(trans);
                        double dist = poly.polyDistance(bounds);
                        if (!(dist < bestDist)) continue;
                        bestDist = dist;
                    }
                }
                return bestDist;
            }
            if (((PrimitiveNode)np).isEdgeSelect()) {
                Technology tech = np.getTechnology();
                double bestDist = Double.MAX_VALUE;
                Poly[] polys = tech.getShapeOfNode(ni);
                for (int box = 0; box < polys.length; ++box) {
                    Poly poly = polys[box];
                    poly.transform(trans);
                    double dist = poly.polyDistance(bounds);
                    if (!(dist < bestDist)) continue;
                    bestDist = dist;
                }
                if (wnd != null) {
                    for (Poly poly : ni.getDisplayableVariables(wnd)) {
                        poly.transform(trans);
                        double dist = poly.polyDistance(bounds);
                        if (!(dist < bestDist)) continue;
                        bestDist = dist;
                    }
                }
                return bestDist;
            }
        }
        Poly nodePoly = ni.getBaseShape();
        nodePoly.setStyle(Poly.Type.FILLED);
        double dist = nodePoly.polyDistance(bounds);
        return dist;
    }

    public static double distToArc(Rectangle2D bounds, ArcInst ai, EditWindow wnd) {
        ArcProto ap = ai.getProto();
        if (ap.isEdgeSelect()) {
            Technology tech = ap.getTechnology();
            Poly[] polys = tech.getShapeOfArc(ai);
            double bestDist = Double.MAX_VALUE;
            for (int box = 0; box < polys.length; ++box) {
                Poly poly = polys[box];
                double dist = poly.polyDistance(bounds);
                if (!(dist < bestDist)) continue;
                bestDist = dist;
            }
            Poly[] textPolys = ai.getDisplayableVariables(wnd);
            for (int box = 0; box < textPolys.length; ++box) {
                Poly poly = textPolys[box];
                double dist = poly.polyDistance(bounds);
                if (!(dist < bestDist)) continue;
                bestDist = dist;
            }
            return bestDist;
        }
        long gridWid = ai.getGridBaseWidth();
        if (gridWid == 0L) {
            gridWid = DBMath.lambdaToSizeGrid(1.0);
        }
        Poly poly = ai.makeLambdaPoly(gridWid, Poly.Type.FILLED);
        return poly.polyDistance(bounds);
    }

    @Override
    public void databaseChanged(DatabaseChangeEvent e) {
        this.finished();
    }

    private static class TextHighlightBound
    implements RTBounds {
        private Rectangle2D bound;
        private ElectricObject obj;
        private Variable.Key key;

        TextHighlightBound(Rectangle2D bound, ElectricObject obj, Variable.Key key) {
            this.bound = new Rectangle2D.Double(bound.getMinX(), bound.getMinY(), bound.getWidth(), bound.getHeight());
            this.obj = obj;
            this.key = key;
        }

        public Rectangle2D getBounds() {
            return this.bound;
        }

        public ElectricObject getElectricObject() {
            return this.obj;
        }

        public Variable.Key getKey() {
            return this.key;
        }

        public String toString() {
            return "TextBound";
        }
    }

    private static class FlashActionListener
    implements ActionListener {
        private Highlighter hl;
        private Highlight2 line1;
        private Highlight2 line2;
        private Highlight2 line3;
        private Highlight2 line4;

        FlashActionListener(Highlighter hl, Highlight2 line1, Highlight2 line2, Highlight2 line3, Highlight2 line4) {
            this.hl = hl;
            this.line1 = line1;
            this.line2 = line2;
            this.line3 = line3;
            this.line4 = line4;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.line1 != null) {
                this.hl.remove(this.line1);
            }
            if (this.line2 != null) {
                this.hl.remove(this.line2);
            }
            if (this.line3 != null) {
                this.hl.remove(this.line3);
            }
            if (this.line4 != null) {
                this.hl.remove(this.line4);
            }
            this.hl.finished();
            this.hl.getWindowFrame().getContent().repaint();
        }
    }
}

