/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.database.id;

import com.sun.electric.database.EObjectInputStream;
import com.sun.electric.database.EObjectOutputStream;
import com.sun.electric.database.hierarchy.EDatabase;
import com.sun.electric.database.id.TechId;
import com.sun.electric.technology.Layer;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.Serializable;

public class LayerId
implements Serializable {
    public final TechId techId;
    public final String name;
    public final String fullName;
    public final int chronIndex;

    LayerId(TechId techId, String name, int chronIndex) {
        assert (techId != null);
        if (name.length() == 0 || !TechId.jelibSafeName(name)) {
            throw new IllegalArgumentException("LayerId.name");
        }
        this.techId = techId;
        this.name = name;
        this.fullName = techId.techName + ":" + name;
        this.chronIndex = chronIndex;
    }

    private Object writeReplace() {
        return new LayerIdKey(this);
    }

    public Layer inDatabase(EDatabase database) {
        return database.getTechPool().getLayer(this);
    }

    public String toString() {
        return this.fullName;
    }

    void check() {
        assert (this == this.techId.getLayerId(this.chronIndex));
        assert (this.name.length() > 0 && TechId.jelibSafeName(this.name));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LayerIdKey
    extends EObjectInputStream.Key<LayerId> {
        public LayerIdKey() {
        }

        private LayerIdKey(LayerId layerId) {
            super(layerId);
        }

        @Override
        public void writeExternal(EObjectOutputStream out, LayerId layerId) throws IOException {
            TechId techId = layerId.techId;
            if (techId.idManager != out.getIdManager()) {
                throw new NotSerializableException(layerId + " from other IdManager");
            }
            out.writeInt(techId.techIndex);
            out.writeInt(layerId.chronIndex);
        }

        @Override
        public LayerId readExternal(EObjectInputStream in) throws IOException, ClassNotFoundException {
            int techIndex = in.readInt();
            int chronIndex = in.readInt();
            return in.getIdManager().getTechId(techIndex).getLayerId(chronIndex);
        }
    }
}

