/*
 * Decompiled with CFR 0.152.
 */
package com.sun.electric.tool.user.ui;

import com.sun.electric.Main;
import com.sun.electric.database.geometry.GenMath;
import com.sun.electric.database.hierarchy.Cell;
import com.sun.electric.database.hierarchy.Library;
import com.sun.electric.database.hierarchy.View;
import com.sun.electric.database.topology.NodeInst;
import com.sun.electric.tool.Job;
import com.sun.electric.tool.io.FileType;
import com.sun.electric.tool.project.Project;
import com.sun.electric.tool.simulation.Signal;
import com.sun.electric.tool.user.CircuitChanges;
import com.sun.electric.tool.user.ErrorLogger;
import com.sun.electric.tool.user.Resources;
import com.sun.electric.tool.user.ViewChanges;
import com.sun.electric.tool.user.dialogs.ChangeCellGroup;
import com.sun.electric.tool.user.dialogs.NewCell;
import com.sun.electric.tool.user.menus.CellMenu;
import com.sun.electric.tool.user.menus.FileMenu;
import com.sun.electric.tool.user.tecEdit.ArcInfo;
import com.sun.electric.tool.user.tecEdit.LayerInfo;
import com.sun.electric.tool.user.tecEdit.Manipulate;
import com.sun.electric.tool.user.tecEdit.NodeInfo;
import com.sun.electric.tool.user.ui.EditWindow;
import com.sun.electric.tool.user.ui.PaletteFrame;
import com.sun.electric.tool.user.ui.TopLevel;
import com.sun.electric.tool.user.ui.WaveformWindow;
import com.sun.electric.tool.user.ui.WindowFrame;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.awt.image.PixelGrabber;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class ExplorerTree
extends JTree
implements DragGestureListener,
DragSourceListener {
    private TreeHandler handler = null;
    private DefaultMutableTreeNode rootNode;
    private DefaultTreeModel treeModel;
    private static final int SHOWALPHABETICALLY = 1;
    private static final int SHOWBYCELLGROUP = 2;
    private static final int SHOWBYHIERARCHY = 3;
    private static int howToShow = 2;
    private static ImageIcon iconLibrary = null;
    private static ImageIcon iconGroup = null;
    private static ImageIcon iconJobs = null;
    private static ImageIcon iconLibraries = null;
    private static ImageIcon iconErrors = null;
    private static ImageIcon iconErrorMsg = null;
    private static ImageIcon iconWarnMsg = null;
    private static ImageIcon iconSignals = null;
    private static ImageIcon iconSweeps = null;
    private static ImageIcon iconViewIcon = null;
    private static ImageIcon iconViewLayout = null;
    private static ImageIcon iconViewMultiPageSchematics = null;
    private static ImageIcon iconViewSchematics = null;
    private static ImageIcon iconViewMisc = null;
    private static ImageIcon iconViewText = null;
    private static ImageIcon iconSpiderWeb = null;
    private static ImageIcon iconLocked = null;
    private static ImageIcon iconUnlocked = null;
    private static ImageIcon iconAvailable = null;
    private static String libraryNode = "LIBRARIES";
    private DragSource dragSource = null;
    private DefaultMutableTreeNode selectedNode;

    public static ExplorerTree CreateExplorerTree(DefaultMutableTreeNode rootNode, DefaultTreeModel treeModel) {
        ExplorerTree tree = new ExplorerTree(rootNode, treeModel);
        tree.handler = new TreeHandler(tree);
        tree.addMouseListener(tree.handler);
        return tree;
    }

    private ExplorerTree(DefaultMutableTreeNode rootNode, DefaultTreeModel treeModel) {
        super(treeModel);
        this.rootNode = rootNode;
        this.treeModel = treeModel;
        this.initDND();
        this.getSelectionModel().setSelectionMode(1);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.setToggleClickCount(3);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.setCellRenderer(new MyRenderer());
    }

    public Object getCurrentlySelectedObject() {
        return this.handler.currentSelectedObject;
    }

    public static DefaultMutableTreeNode makeLibraryTree() {
        DefaultMutableTreeNode libraryExplorerTree = new DefaultMutableTreeNode(libraryNode);
        switch (howToShow) {
            case 1: {
                ExplorerTree.rebuildExplorerTreeByName(libraryExplorerTree);
                break;
            }
            case 2: {
                ExplorerTree.rebuildExplorerTreeByGroups(libraryExplorerTree);
                break;
            }
            case 3: {
                ExplorerTree.rebuildExplorerTreeByHierarchy(libraryExplorerTree);
            }
        }
        return libraryExplorerTree;
    }

    private static synchronized void rebuildExplorerTreeByName(DefaultMutableTreeNode libraryExplorerTree) {
        Iterator it = Library.getVisibleLibraries().iterator();
        while (it.hasNext()) {
            DefaultMutableTreeNode libTree;
            Library lib = (Library)it.next();
            if (!ExplorerTree.addTechnologyLibraryToTree(lib, libTree = new DefaultMutableTreeNode(lib))) {
                Iterator eit = lib.getCells();
                while (eit.hasNext()) {
                    Cell cell = (Cell)eit.next();
                    DefaultMutableTreeNode cellTree = new DefaultMutableTreeNode(cell);
                    libTree.add(cellTree);
                }
            }
            libraryExplorerTree.add(libTree);
        }
    }

    private static boolean addTechnologyLibraryToTree(Library lib, DefaultMutableTreeNode libTree) {
        boolean techLib = false;
        Iterator it = lib.getCells();
        while (it.hasNext()) {
            Cell cell = (Cell)it.next();
            if (!cell.isInTechnologyLibrary()) continue;
            techLib = true;
            break;
        }
        if (!techLib) {
            return false;
        }
        DefaultMutableTreeNode layerTree = new DefaultMutableTreeNode("TECHNOLOGY LAYERS");
        DefaultMutableTreeNode arcTree = new DefaultMutableTreeNode("TECHNOLOGY ARCS");
        DefaultMutableTreeNode nodeTree = new DefaultMutableTreeNode("TECHNOLOGY NODES");
        DefaultMutableTreeNode miscTree = new DefaultMutableTreeNode("TECHNOLOGY SUPPORT");
        libTree.add(layerTree);
        libTree.add(arcTree);
        libTree.add(nodeTree);
        libTree.add(miscTree);
        HashSet<Cell> allCells = new HashSet<Cell>();
        Cell[] layerCells = LayerInfo.getLayerCells(lib);
        for (int i = 0; i < layerCells.length; ++i) {
            allCells.add(layerCells[i]);
            layerTree.add(new DefaultMutableTreeNode(layerCells[i]));
        }
        Cell[] arcCells = ArcInfo.getArcCells(lib);
        for (int i = 0; i < arcCells.length; ++i) {
            allCells.add(arcCells[i]);
            arcTree.add(new DefaultMutableTreeNode(arcCells[i]));
        }
        Cell[] nodeCells = NodeInfo.getNodeCells(lib);
        for (int i = 0; i < nodeCells.length; ++i) {
            allCells.add(nodeCells[i]);
            nodeTree.add(new DefaultMutableTreeNode(nodeCells[i]));
        }
        Iterator it2 = lib.getCells();
        while (it2.hasNext()) {
            Cell cell = (Cell)it2.next();
            if (allCells.contains(cell)) continue;
            miscTree.add(new DefaultMutableTreeNode(cell));
        }
        return true;
    }

    private static synchronized void rebuildExplorerTreeByHierarchy(DefaultMutableTreeNode libraryExplorerTree) {
        Iterator it = Library.getVisibleLibraries().iterator();
        while (it.hasNext()) {
            DefaultMutableTreeNode libTree;
            Library lib = (Library)it.next();
            if (!ExplorerTree.addTechnologyLibraryToTree(lib, libTree = new DefaultMutableTreeNode(lib))) {
                Iterator eit = lib.getCells();
                while (eit.hasNext()) {
                    Cell cell = (Cell)eit.next();
                    if (cell.isIcon() || cell.getView().isTextView()) continue;
                    HashSet<Cell> addedCells = new HashSet<Cell>();
                    Iterator vIt = cell.getVersions();
                    while (vIt.hasNext()) {
                        Cell cellVersion = (Cell)vIt.next();
                        Iterator insts = cellVersion.getInstancesOf();
                        if (insts.hasNext() || addedCells.contains(cellVersion)) continue;
                        DefaultMutableTreeNode cellTree = new DefaultMutableTreeNode(cellVersion);
                        libTree.add(cellTree);
                        addedCells.add(cellVersion);
                        ExplorerTree.createHierarchicalExplorerTree(cellVersion, cellTree);
                    }
                }
            }
            libraryExplorerTree.add(libTree);
        }
    }

    private static void createHierarchicalExplorerTree(Cell cell, DefaultMutableTreeNode cellTree) {
        HashMap<Cell, GenMath.MutableInteger> cellCount = new HashMap<Cell, GenMath.MutableInteger>();
        Iterator it = cell.getNodes();
        while (it.hasNext()) {
            Cell subCell;
            NodeInst ni = (NodeInst)it.next();
            if (!(ni.getProto() instanceof Cell) || (subCell = (Cell)ni.getProto()).isIcon() && (ni.isIconOfParent() || (subCell = subCell.contentsView()) == null)) continue;
            GenMath.MutableInteger mi = (GenMath.MutableInteger)cellCount.get(subCell);
            if (mi == null) {
                mi = new GenMath.MutableInteger(0);
                cellCount.put(subCell, mi);
            }
            mi.setValue(mi.intValue() + 1);
        }
        it = cellCount.keySet().iterator();
        while (it.hasNext()) {
            Cell subCell = (Cell)it.next();
            GenMath.MutableInteger mi = (GenMath.MutableInteger)cellCount.get(subCell);
            if (mi == null) continue;
            CellAndCount cc = new CellAndCount(subCell, mi.intValue());
            DefaultMutableTreeNode subCellTree = new DefaultMutableTreeNode(cc);
            cellTree.add(subCellTree);
            ExplorerTree.createHierarchicalExplorerTree(subCell, subCellTree);
        }
    }

    private static synchronized void rebuildExplorerTreeByGroups(DefaultMutableTreeNode libraryExplorerTree) {
        HashSet<Cell> cellsSeen = new HashSet<Cell>();
        Iterator it = Library.getVisibleLibraries().iterator();
        while (it.hasNext()) {
            DefaultMutableTreeNode libTree;
            Library lib = (Library)it.next();
            if (!ExplorerTree.addTechnologyLibraryToTree(lib, libTree = new DefaultMutableTreeNode(lib))) {
                Cell cell;
                Iterator eit = lib.getCells();
                while (eit.hasNext()) {
                    cell = (Cell)eit.next();
                    cellsSeen.remove(cell);
                }
                eit = lib.getCells();
                while (eit.hasNext()) {
                    cell = (Cell)eit.next();
                    if (cell.getNewestVersion() != cell) continue;
                    Cell.CellGroup group = cell.getCellGroup();
                    int numNewCells = 0;
                    Iterator gIt = group.getCells();
                    while (gIt.hasNext()) {
                        Cell cellInGroup = (Cell)gIt.next();
                        if (cellInGroup.getNewestVersion() != cellInGroup) continue;
                        ++numNewCells;
                    }
                    if (numNewCells == 1) {
                        ExplorerTree.addCellAndAllVersions(cell, libTree);
                        continue;
                    }
                    List cellsInGroup = group.getCellsSortedByView();
                    DefaultMutableTreeNode groupTree = null;
                    Iterator gIt2 = cellsInGroup.iterator();
                    while (gIt2.hasNext()) {
                        Cell cellInGroup = (Cell)gIt2.next();
                        if (cellInGroup.getNumVersions() > 1 && cellInGroup.getNewestVersion() != cellInGroup || cellsSeen.contains(cellInGroup)) continue;
                        if (groupTree == null) {
                            groupTree = new DefaultMutableTreeNode(group);
                        }
                        cellsSeen.add(cellInGroup);
                        ExplorerTree.addCellAndAllVersions(cellInGroup, groupTree);
                    }
                    if (groupTree == null) continue;
                    libTree.add(groupTree);
                }
            }
            libraryExplorerTree.add(libTree);
        }
    }

    private static void addCellAndAllVersions(Cell cell, DefaultMutableTreeNode libTree) {
        DefaultMutableTreeNode cellTree = new DefaultMutableTreeNode(cell);
        libTree.add(cellTree);
        if (cell.isMultiPage()) {
            int pageCount = cell.getNumMultiPages();
            for (int i = 0; i < pageCount; ++i) {
                MultiPageCell mpc = new MultiPageCell();
                mpc.cell = cell;
                mpc.pageNo = i;
                DefaultMutableTreeNode pageTree = new DefaultMutableTreeNode(mpc);
                cellTree.add(pageTree);
            }
        }
        if (cell.getNumVersions() > 1) {
            Iterator vIt = cell.getVersions();
            while (vIt.hasNext()) {
                Cell oldVersion = (Cell)vIt.next();
                if (oldVersion == cell) continue;
                DefaultMutableTreeNode oldCellTree = new DefaultMutableTreeNode(oldVersion);
                cellTree.add(oldCellTree);
                if (!oldVersion.isMultiPage()) continue;
                int pageCount = oldVersion.getNumMultiPages();
                for (int i = 0; i < pageCount; ++i) {
                    MultiPageCell mpc = new MultiPageCell();
                    mpc.cell = oldVersion;
                    mpc.pageNo = i;
                    DefaultMutableTreeNode pageTree = new DefaultMutableTreeNode(mpc);
                    oldCellTree.add(pageTree);
                }
            }
        }
    }

    public String convertValueToText(Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Object nodeInfo = ((DefaultMutableTreeNode)value).getUserObject();
        if (nodeInfo instanceof Cell) {
            Cell cell = (Cell)nodeInfo;
            if (cell.isSchematic()) {
                Cell.CellGroup group = cell.getCellGroup();
                Cell mainSchematic = group.getMainSchematics();
                int numSchematics = 0;
                Iterator gIt = group.getCells();
                while (gIt.hasNext()) {
                    Cell cellInGroup = (Cell)gIt.next();
                    if (!cellInGroup.isSchematic()) continue;
                    ++numSchematics;
                }
                if (numSchematics > 1 && cell == mainSchematic) {
                    return cell.noLibDescribe() + " **";
                }
            }
            return cell.noLibDescribe();
        }
        if (nodeInfo instanceof MultiPageCell) {
            MultiPageCell mpc = (MultiPageCell)nodeInfo;
            return mpc.cell.noLibDescribe() + " Page " + (mpc.pageNo + 1);
        }
        if (nodeInfo instanceof Library) {
            Library lib = (Library)nodeInfo;
            String nodeName = lib.getName();
            if (lib == Library.getCurrent() && Library.getNumLibraries() > 1) {
                nodeName = nodeName + " [Current]";
                iconLibrary = Resources.getResource(this.getClass(), "IconLibraryCheck.gif");
            } else {
                iconLibrary = Resources.getResource(this.getClass(), "IconLibrary.gif");
            }
            return nodeName;
        }
        if (nodeInfo instanceof CellAndCount) {
            CellAndCount cc = (CellAndCount)nodeInfo;
            return cc.getCell().noLibDescribe() + " (" + cc.getCount() + ")";
        }
        if (nodeInfo instanceof Cell.CellGroup) {
            Cell.CellGroup group = (Cell.CellGroup)nodeInfo;
            return group.getName();
        }
        if (nodeInfo instanceof ErrorLogger) {
            ErrorLogger el = (ErrorLogger)nodeInfo;
            return el.describe();
        }
        if (nodeInfo instanceof ErrorLogger.MessageLog) {
            ErrorLogger.MessageLog el = (ErrorLogger.MessageLog)nodeInfo;
            return el.getMessage();
        }
        if (nodeInfo instanceof Signal) {
            Signal sig = (Signal)nodeInfo;
            return sig.getSignalName();
        }
        if (nodeInfo == null) {
            return "";
        }
        return nodeInfo.toString();
    }

    private void initDND() {
        this.dragSource = DragSource.getDefaultDragSource();
        DragGestureRecognizer dgr = this.dragSource.createDefaultDragGestureRecognizer(this, 0x40000000, this);
    }

    public void dragGestureRecognized(DragGestureEvent e) {
        Transferable transferable;
        if (this.selectedNode == null) {
            return;
        }
        if (this.selectedNode.getUserObject() instanceof Signal) {
            Signal sSig = (Signal)this.selectedNode.getUserObject();
            transferable = new StringSelection(sSig.getFullName());
            this.dragSource.startDrag(e, DragSource.DefaultLinkDrop, transferable, this);
        }
        if (this.selectedNode.getUserObject() instanceof Cell) {
            Cell cell = (Cell)this.selectedNode.getUserObject();
            transferable = new EditWindow.NodeProtoTransferable(cell);
            if (TopLevel.getOperatingSystem() == TopLevel.OS.MACINTOSH) {
                BufferedImage img = new BufferedImage(1, 1, 1);
                this.dragSource.startDrag(e, DragSource.DefaultLinkDrop, img, new Point(0, 0), transferable, this);
            } else {
                this.dragSource.startDrag(e, DragSource.DefaultLinkDrop, transferable, this);
            }
        }
    }

    public void dragEnter(DragSourceDragEvent e) {
    }

    public void dragOver(DragSourceDragEvent e) {
    }

    public void dragExit(DragSourceEvent e) {
    }

    public void dragDropEnd(DragSourceDropEvent e) {
    }

    public void dropActionChanged(DragSourceDragEvent e) {
    }

    private static class TreeHandler
    implements MouseListener,
    MouseMotionListener {
        private ExplorerTree tree;
        private Object currentSelectedObject;
        private Cell originalCell;
        private boolean draggingCell;
        private MouseEvent currentMouseEvent;
        private TreePath currentPath;
        private TreePath originalPath;

        TreeHandler(ExplorerTree tree) {
            this.tree = tree;
        }

        public void mouseClicked(MouseEvent e) {
        }

        public void mouseEntered(MouseEvent e) {
        }

        public void mouseExited(MouseEvent e) {
        }

        public void mouseMoved(MouseEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            this.draggingCell = false;
            if (e.isPopupTrigger()) {
                this.cacheEvent(e);
                this.doContextMenu();
                return;
            }
            this.cacheEvent(e);
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (e.getClickCount() == 2) {
                Cell cell;
                if (this.currentSelectedObject instanceof CellAndCount) {
                    CellAndCount cc = (CellAndCount)this.currentSelectedObject;
                    wf.setCellWindow(cc.getCell());
                    return;
                }
                if (this.currentSelectedObject instanceof Cell) {
                    Cell cell2 = (Cell)this.currentSelectedObject;
                    wf.setCellWindow(cell2);
                    return;
                }
                if (this.currentSelectedObject instanceof MultiPageCell) {
                    MultiPageCell mpc = (MultiPageCell)this.currentSelectedObject;
                    Cell cell3 = mpc.cell;
                    wf.setCellWindow(cell3);
                    if (wf.getContent() instanceof EditWindow) {
                        EditWindow wnd = (EditWindow)wf.getContent();
                        wnd.setMultiPageNumber(mpc.pageNo);
                    }
                    return;
                }
                if (this.currentSelectedObject instanceof Library || this.currentSelectedObject instanceof Cell.CellGroup || this.currentSelectedObject instanceof String) {
                    if (this.tree.isExpanded(this.currentPath)) {
                        this.tree.collapsePath(this.currentPath);
                    } else {
                        this.tree.expandPath(this.currentPath);
                    }
                    return;
                }
                if (this.currentSelectedObject instanceof Signal) {
                    Signal sig = (Signal)this.currentSelectedObject;
                    if (wf.getContent() instanceof WaveformWindow) {
                        WaveformWindow ww = (WaveformWindow)wf.getContent();
                        ww.addSignal(sig);
                    }
                    return;
                }
                if (this.currentSelectedObject instanceof WaveformWindow.SweepSignal) {
                    WaveformWindow.SweepSignal ss = (WaveformWindow.SweepSignal)this.currentSelectedObject;
                    if (ss == null) {
                        return;
                    }
                    ss.setIncluded(!ss.isIncluded());
                    return;
                }
                if (this.currentSelectedObject instanceof Job) {
                    Job job = (Job)this.currentSelectedObject;
                    System.out.println(job.getInfo());
                    return;
                }
                if (this.currentSelectedObject instanceof ErrorLogger.MessageLog) {
                    ErrorLogger.MessageLog el = (ErrorLogger.MessageLog)this.currentSelectedObject;
                    String msg = el.reportLog(true, null);
                    System.out.println(msg);
                    return;
                }
                if (this.currentSelectedObject instanceof Cell && (cell = (Cell)this.currentSelectedObject).getNewestVersion() == cell) {
                    this.originalCell = cell;
                    this.originalPath = new TreePath(this.currentPath.getPath());
                    this.draggingCell = true;
                }
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.cacheEvent(e);
                this.doContextMenu();
            }
        }

        public void mouseDragged(MouseEvent e) {
            if (!this.draggingCell) {
                return;
            }
            this.cacheEvent(e);
            this.tree.clearSelection();
            this.tree.addSelectionPath(this.originalPath);
            this.tree.addSelectionPath(this.currentPath);
            this.tree.updateUI();
        }

        private void cacheEvent(MouseEvent e) {
            this.currentPath = this.tree.getPathForLocation(e.getX(), e.getY());
            if (this.currentPath == null) {
                this.currentSelectedObject = null;
                return;
            }
            this.tree.setSelectionPath(this.currentPath);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.currentPath.getLastPathComponent();
            this.tree.selectedNode = node;
            this.currentSelectedObject = node.getUserObject();
            this.currentMouseEvent = e;
        }

        private void doContextMenu() {
            JPopupMenu menu;
            if (this.currentSelectedObject instanceof Job) {
                Job job = (Job)this.currentSelectedObject;
                JPopupMenu popup = job.getPopupStatus();
                popup.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (this.currentSelectedObject instanceof CellAndCount) {
                CellAndCount cc = (CellAndCount)this.currentSelectedObject;
                this.currentSelectedObject = cc.getCell();
            }
            if (this.currentSelectedObject instanceof Cell) {
                Cell cell = (Cell)this.currentSelectedObject;
                JPopupMenu menu2 = new JPopupMenu("Cell");
                JMenuItem menuItem = new JMenuItem("Edit");
                menu2.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.editCellAction(false);
                    }
                });
                menuItem = new JMenuItem("Edit in New Window");
                menu2.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.editCellAction(true);
                    }
                });
                int projStatus = Project.getCellStatus(cell);
                if (projStatus != 4 && (projStatus != 0 || Project.isLibraryManaged(cell.getLibrary()))) {
                    menu2.addSeparator();
                    if (projStatus == 1) {
                        menuItem = new JMenuItem("Check Out");
                        menu2.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                Project.checkOut((Cell)TreeHandler.this.currentSelectedObject);
                            }
                        });
                    }
                    if (projStatus == 2) {
                        menuItem = new JMenuItem("Check In...");
                        menu2.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                Project.checkIn((Cell)TreeHandler.this.currentSelectedObject);
                            }
                        });
                        menuItem = new JMenuItem("Cancel Check-Out");
                        menu2.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                Project.cancelCheckOut((Cell)TreeHandler.this.currentSelectedObject);
                            }
                        });
                    }
                    if (projStatus == 0) {
                        menuItem = new JMenuItem("Add To Repository");
                        menu2.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                Project.addCell((Cell)TreeHandler.this.currentSelectedObject);
                            }
                        });
                    } else {
                        menuItem = new JMenuItem("Show History of This Cell...");
                        menu2.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                Project.examineHistory((Cell)TreeHandler.this.currentSelectedObject);
                            }
                        });
                    }
                    if (projStatus == 1 || projStatus == 2) {
                        menuItem = new JMenuItem("Remove From Repository");
                        menu2.add(menuItem);
                        menuItem.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent e) {
                                Project.removeCell((Cell)TreeHandler.this.currentSelectedObject);
                            }
                        });
                    }
                }
                menu2.addSeparator();
                menuItem = new JMenuItem("Place Instance of Cell");
                menu2.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.newCellInstanceAction();
                    }
                });
                menuItem = new JMenuItem("Create New Cell");
                menu2.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.newCellAction();
                    }
                });
                menu2.addSeparator();
                menuItem = new JMenuItem("Create New Version of Cell");
                menu2.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.newCellVersionAction();
                    }
                });
                menuItem = new JMenuItem("Duplicate Cell");
                menu2.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.duplicateCellAction();
                    }
                });
                menuItem = new JMenuItem("Delete Cell");
                menu2.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.deleteCellAction();
                    }
                });
                menu2.addSeparator();
                menuItem = new JMenuItem("Rename Cell");
                menu2.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.renameCellAction();
                    }
                });
                JMenu subMenu = new JMenu("Change View");
                menu2.add(subMenu);
                Iterator it = View.getOrderedViews().iterator();
                while (it.hasNext()) {
                    View view = (View)it.next();
                    if (cell.getView() == view) continue;
                    JMenuItem subMenuItem = new JMenuItem(view.getFullName());
                    subMenu.add(subMenuItem);
                    subMenuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.reViewCellAction(e);
                        }
                    });
                }
                menu2.addSeparator();
                if (cell.isSchematic() && cell.getNewestVersion() == cell && cell.getCellGroup().getMainSchematics() != cell) {
                    menuItem = new JMenuItem("Make This the Main Schematic");
                    menu2.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.makeCellMainSchematic();
                        }
                    });
                }
                menuItem = new JMenuItem("Change Cell Group...");
                menu2.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.changeCellGroupAction();
                    }
                });
                menu2.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (this.currentSelectedObject instanceof MultiPageCell) {
                MultiPageCell mpc = (MultiPageCell)this.currentSelectedObject;
                Cell cell = mpc.cell;
                JPopupMenu menu3 = new JPopupMenu("Cell");
                JMenuItem menuItem = new JMenuItem("Edit");
                menu3.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.editCellAction(false);
                    }
                });
                menuItem = new JMenuItem("Edit in New Window");
                menu3.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.editCellAction(true);
                    }
                });
                menu3.addSeparator();
                menuItem = new JMenuItem("Make New Page");
                menu3.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.makeNewSchematicPage();
                    }
                });
                menuItem = new JMenuItem("Delete This Page");
                menu3.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.deleteSchematicPage();
                    }
                });
                menu3.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (this.currentSelectedObject instanceof Library) {
                Library lib = (Library)this.currentSelectedObject;
                JPopupMenu menu4 = new JPopupMenu("Library");
                JMenuItem menuItem = new JMenuItem("Open");
                menu4.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.openAction();
                    }
                });
                menuItem = new JMenuItem("Open all below here");
                menu4.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.recursiveOpenAction();
                    }
                });
                menuItem = new JMenuItem("Close all below here");
                menu4.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.recursiveCloseAction();
                    }
                });
                if (lib != Library.getCurrent()) {
                    menu4.addSeparator();
                    menuItem = new JMenuItem("Make This the Current Library");
                    menu4.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.setCurLibAction();
                        }
                    });
                }
                menu4.addSeparator();
                if (Project.isLibraryManaged(lib)) {
                    menuItem = new JMenuItem("Update from Repository");
                    menu4.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Project.updateProject();
                        }
                    });
                } else {
                    menuItem = new JMenuItem("Add to Project Management Repository");
                    menu4.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Project.addALibrary((Library)TreeHandler.this.currentSelectedObject);
                        }
                    });
                }
                menu4.addSeparator();
                menuItem = new JMenuItem("Create New Cell");
                menu4.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.newCellAction();
                    }
                });
                menu4.addSeparator();
                menuItem = new JMenuItem("Rename Library");
                menu4.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.renameLibraryAction();
                    }
                });
                menuItem = new JMenuItem("Save Library");
                menu4.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.saveLibraryAction();
                    }
                });
                menuItem = new JMenuItem("Close Library");
                menu4.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.closeLibraryAction();
                    }
                });
                menu4.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (this.currentSelectedObject instanceof Cell.CellGroup) {
                menu = new JPopupMenu("CellGroup");
                JMenuItem menuItem = new JMenuItem("Open");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.openAction();
                    }
                });
                menuItem = new JMenuItem("Open all below here");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.recursiveOpenAction();
                    }
                });
                menuItem = new JMenuItem("Close all below here");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.recursiveCloseAction();
                    }
                });
                menu.addSeparator();
                menuItem = new JMenuItem("Create New Cell");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.newCellAction();
                    }
                });
                menuItem = new JMenuItem("Rename Cells in Group");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.renameGroupAction();
                    }
                });
                menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (this.currentSelectedObject instanceof WaveformWindow.SweepSignal) {
                menu = new JPopupMenu("Sweep Signal");
                JMenuItem menuItem = new JMenuItem("Include");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.setSweepAction(true);
                    }
                });
                menuItem = new JMenuItem("Exclude");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.setSweepAction(false);
                    }
                });
                menuItem = new JMenuItem("Highlight");
                menu.add(menuItem);
                menuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        TreeHandler.this.highlightSweepAction();
                    }
                });
                menu.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                return;
            }
            if (this.currentSelectedObject instanceof String) {
                String msg = (String)this.currentSelectedObject;
                if (msg.equalsIgnoreCase("sweeps")) {
                    JPopupMenu menu5 = new JPopupMenu("All Sweeps");
                    JMenuItem menuItem = new JMenuItem("Include All");
                    menu5.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.setAllSweepsAction(true);
                        }
                    });
                    menuItem = new JMenuItem("Exclude All");
                    menu5.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.setAllSweepsAction(false);
                        }
                    });
                    menu5.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                    return;
                }
                if (msg.equalsIgnoreCase("libraries")) {
                    JPopupMenu menu6 = new JPopupMenu("Libraries");
                    JMenuItem menuItem = new JMenuItem("Open");
                    menu6.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.openAction();
                        }
                    });
                    menuItem = new JMenuItem("Open all below here");
                    menu6.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.recursiveOpenAction();
                        }
                    });
                    menuItem = new JMenuItem("Close all below here");
                    menu6.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.recursiveCloseAction();
                        }
                    });
                    menu6.addSeparator();
                    menuItem = new JMenuItem("Create New Cell");
                    menu6.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.newCellAction();
                        }
                    });
                    menu6.addSeparator();
                    menuItem = new JMenuItem("Show Cells Alphabetically");
                    menu6.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.showAlphabeticallyAction();
                        }
                    });
                    menuItem = new JMenuItem("Show Cells by Group");
                    menu6.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.showByGroupAction();
                        }
                    });
                    menuItem = new JMenuItem("Show Cells by Hierarchy");
                    menu6.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            TreeHandler.this.showByHierarchyAction();
                        }
                    });
                    menu6.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                    return;
                }
                if (msg.equalsIgnoreCase("TECHNOLOGY LAYERS")) {
                    JPopupMenu menu7 = new JPopupMenu("Technology Layers");
                    JMenuItem menuItem = new JMenuItem("Add New Layer");
                    menu7.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Manipulate.makeCell(1);
                        }
                    });
                    menuItem = new JMenuItem("Reorder Layers");
                    menu7.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Manipulate.reorderPrimitives(1);
                        }
                    });
                    menu7.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                    return;
                }
                if (msg.equalsIgnoreCase("TECHNOLOGY ARCS")) {
                    JPopupMenu menu8 = new JPopupMenu("Technology Arcs");
                    JMenuItem menuItem = new JMenuItem("Add New Arc");
                    menu8.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Manipulate.makeCell(2);
                        }
                    });
                    menuItem = new JMenuItem("Reorder Arcs");
                    menu8.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Manipulate.reorderPrimitives(2);
                        }
                    });
                    menu8.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                    return;
                }
                if (msg.equalsIgnoreCase("TECHNOLOGY NODES")) {
                    JPopupMenu menu9 = new JPopupMenu("Technology Nodes");
                    JMenuItem menuItem = new JMenuItem("Add New Node");
                    menu9.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Manipulate.makeCell(3);
                        }
                    });
                    menuItem = new JMenuItem("Reorder Nodes");
                    menu9.add(menuItem);
                    menuItem.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            Manipulate.reorderPrimitives(3);
                        }
                    });
                    menu9.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                    return;
                }
            }
            if (this.currentSelectedObject instanceof ErrorLogger) {
                ErrorLogger logger = (ErrorLogger)this.currentSelectedObject;
                JPopupMenu p = logger.getPopupMenu();
                if (p != null) {
                    p.show((Component)this.currentMouseEvent.getSource(), this.currentMouseEvent.getX(), this.currentMouseEvent.getY());
                }
                return;
            }
        }

        private void openAction() {
            this.tree.expandPath(this.currentPath);
        }

        private void recursiveOpenAction() {
            this.recursivelyOpen(this.currentPath);
        }

        private void recursivelyOpen(TreePath path) {
            this.tree.expandPath(path);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            int numChildren = node.getChildCount();
            for (int i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                TreePath descentPath = path.pathByAddingChild(child);
                this.recursivelyOpen(descentPath);
            }
        }

        private void recursiveCloseAction() {
            this.recursivelyClose(this.currentPath);
        }

        private void recursivelyClose(TreePath path) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            int numChildren = node.getChildCount();
            for (int i = 0; i < numChildren; ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                TreePath descentPath = path.pathByAddingChild(child);
                this.recursivelyClose(descentPath);
            }
            this.tree.collapsePath(path);
        }

        private void setCurLibAction() {
            Library lib = (Library)this.currentSelectedObject;
            lib.setCurrent();
            WindowFrame.wantToRedoTitleNames();
            WindowFrame.wantToRedoLibraryTree();
            EditWindow.repaintAll();
        }

        private void renameLibraryAction() {
            Library lib = (Library)this.currentSelectedObject;
            CircuitChanges.renameLibrary(lib);
        }

        private void saveLibraryAction() {
            Library lib = (Library)this.currentSelectedObject;
            FileMenu.saveLibraryCommand(lib, FileType.DEFAULTLIB, false, true);
        }

        private void closeLibraryAction() {
            Library lib = (Library)this.currentSelectedObject;
            FileMenu.closeLibraryCommand(lib);
        }

        private void renameGroupAction() {
            String response;
            Cell.CellGroup cellGroup = (Cell.CellGroup)this.currentSelectedObject;
            String defaultName = "";
            if (cellGroup.getNumCells() > 0) {
                defaultName = ((Cell)cellGroup.getCells().next()).getName();
            }
            if ((response = JOptionPane.showInputDialog(this.tree, "New name for cells in this group", defaultName)) == null) {
                return;
            }
            CircuitChanges.renameCellGroupInJob(cellGroup, response);
        }

        private void editCellAction(boolean newWindow) {
            Cell cell = null;
            int pageNo = 1;
            if (this.currentSelectedObject instanceof Cell) {
                cell = (Cell)this.currentSelectedObject;
            } else if (this.currentSelectedObject instanceof MultiPageCell) {
                MultiPageCell mpc = (MultiPageCell)this.currentSelectedObject;
                cell = mpc.cell;
                pageNo = mpc.pageNo;
            }
            WindowFrame wf = null;
            if (newWindow) {
                wf = WindowFrame.createEditWindow(cell);
            } else {
                wf = WindowFrame.getCurrentWindowFrame();
                wf.setCellWindow(cell);
            }
            if (cell.isMultiPage() && wf.getContent() instanceof EditWindow) {
                EditWindow wnd = (EditWindow)wf.getContent();
                wnd.setMultiPageNumber(pageNo);
            }
        }

        private void newCellInstanceAction() {
            Cell cell = (Cell)this.currentSelectedObject;
            if (cell == null) {
                return;
            }
            PaletteFrame.placeInstance(cell, null, false);
        }

        private void newCellAction() {
            TopLevel jf = TopLevel.getCurrentJFrame();
            NewCell dialog = new NewCell((Frame)jf, true);
            if (!Main.BATCHMODE) {
                dialog.setVisible(true);
            }
        }

        private void setSweepAction(boolean include) {
            WaveformWindow.SweepSignal ss = (WaveformWindow.SweepSignal)this.currentSelectedObject;
            if (ss == null) {
                return;
            }
            ss.setIncluded(include);
        }

        private void highlightSweepAction() {
            WaveformWindow.SweepSignal ss = (WaveformWindow.SweepSignal)this.currentSelectedObject;
            if (ss == null) {
                return;
            }
            ss.highlight();
        }

        private void setAllSweepsAction(boolean include) {
            WindowFrame wf = WindowFrame.getCurrentWindowFrame();
            if (wf == null) {
                return;
            }
            if (wf.getContent() instanceof WaveformWindow) {
                WaveformWindow ww = (WaveformWindow)wf.getContent();
                List sweeps = ww.getSweepSignals();
                Iterator it = sweeps.iterator();
                while (it.hasNext()) {
                    WaveformWindow.SweepSignal ss = (WaveformWindow.SweepSignal)it.next();
                    ss.setIncluded(include);
                }
            }
        }

        private void newCellVersionAction() {
            Cell cell = (Cell)this.currentSelectedObject;
            CircuitChanges.newVersionOfCell(cell);
        }

        private void duplicateCellAction() {
            Cell cell = (Cell)this.currentSelectedObject;
            String newName = JOptionPane.showInputDialog(this.tree, "Name of duplicated cell", cell.getName() + "NEW");
            if (newName == null) {
                return;
            }
            CircuitChanges.duplicateCell(cell, newName);
        }

        private void deleteCellAction() {
            Cell cell = (Cell)this.currentSelectedObject;
            CircuitChanges.deleteCell(cell, true);
        }

        private void renameCellAction() {
            Cell cell = (Cell)this.currentSelectedObject;
            String response = JOptionPane.showInputDialog(this.tree, "New name for " + cell, cell.getName());
            if (response == null) {
                return;
            }
            CircuitChanges.renameCellInJob(cell, response);
        }

        private void reViewCellAction(ActionEvent e) {
            JMenuItem menuItem = (JMenuItem)e.getSource();
            String viewName = menuItem.getText();
            View newView = View.findView(viewName);
            if (newView != null) {
                Cell cell = (Cell)this.currentSelectedObject;
                ViewChanges.changeCellView(cell, newView);
            }
        }

        private void makeCellMainSchematic() {
            Cell cell = (Cell)this.currentSelectedObject;
            if (cell == null) {
                return;
            }
            cell.getCellGroup().setMainSchematics(cell);
        }

        private void changeCellGroupAction() {
            Cell cell = (Cell)this.currentSelectedObject;
            if (cell == null) {
                return;
            }
            ChangeCellGroup dialog = new ChangeCellGroup((Frame)TopLevel.getCurrentJFrame(), true, cell, cell.getLibrary());
            if (!Main.BATCHMODE) {
                dialog.setVisible(true);
            }
        }

        private void makeNewSchematicPage() {
            MultiPageCell mpc = (MultiPageCell)this.currentSelectedObject;
            Cell cell = mpc.cell;
            if (!cell.isMultiPage()) {
                System.out.println("First turn this cell into a multi-page schematic");
                return;
            }
            int numPages = cell.getNumMultiPages();
            CellMenu.SetMultiPageJob job = new CellMenu.SetMultiPageJob(cell, numPages + 1);
            EditWindow wnd = EditWindow.needCurrent();
            if (wnd != null) {
                wnd.setMultiPageNumber(numPages);
            }
        }

        private void deleteSchematicPage() {
            MultiPageCell mpc = (MultiPageCell)this.currentSelectedObject;
            Cell cell = mpc.cell;
            if (!cell.isMultiPage()) {
                return;
            }
            int numPages = cell.getNumMultiPages();
            if (numPages <= 1) {
                System.out.println("Cannot delete the last page of a multi-page schematic");
                return;
            }
            CellMenu.DeleteMultiPageJob job = new CellMenu.DeleteMultiPageJob(cell, mpc.pageNo);
        }

        private void showAlphabeticallyAction() {
            howToShow = 1;
            WindowFrame.wantToRedoLibraryTree();
        }

        private void showByGroupAction() {
            howToShow = 2;
            WindowFrame.wantToRedoLibraryTree();
        }

        private void showByHierarchyAction() {
            howToShow = 3;
            WindowFrame.wantToRedoLibraryTree();
        }
    }

    private class MyRenderer
    extends DefaultTreeCellRenderer {
        private Font plainFont;
        private Font boldFont;
        private HashMap iconGroups = new HashMap();

        public MyRenderer() {
            this.plainFont = new Font("arial", 0, 11);
            this.boldFont = new Font("arial", 1, 11);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setFont(this.plainFont);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object nodeInfo = node.getUserObject();
            if (nodeInfo instanceof Library) {
                Library lib = (Library)nodeInfo;
                if (iconLibrary == null) {
                    iconLibrary = Resources.getResource(this.getClass(), "IconLibrary.gif");
                }
                if (lib.isChangedMajor()) {
                    this.setFont(this.boldFont);
                }
                this.setIcon(iconLibrary);
            }
            if (nodeInfo instanceof CellAndCount) {
                CellAndCount cc = (CellAndCount)nodeInfo;
                nodeInfo = cc.getCell();
            }
            if (nodeInfo instanceof Cell) {
                Cell cell = (Cell)nodeInfo;
                IconGroup ig = cell.isIcon() ? this.findIconGroup(View.ICON) : (cell.getView() == View.LAYOUT ? this.findIconGroup(View.LAYOUT) : (cell.isSchematic() ? this.findIconGroup(View.SCHEMATIC) : (cell.getView().isTextView() ? this.findIconGroup(View.DOC) : this.findIconGroup(View.UNKNOWN))));
                if (cell.getNewestVersion() != cell) {
                    this.setIcon(ig.old);
                } else {
                    switch (Project.getCellStatus(cell)) {
                        case 0: {
                            this.setIcon(ig.regular);
                            break;
                        }
                        case 1: {
                            this.setIcon(ig.available);
                            break;
                        }
                        case 3: {
                            this.setIcon(ig.locked);
                            break;
                        }
                        case 2: {
                            this.setIcon(ig.unlocked);
                        }
                    }
                }
            }
            if (nodeInfo instanceof MultiPageCell) {
                if (iconViewMultiPageSchematics == null) {
                    iconViewMultiPageSchematics = Resources.getResource(this.getClass(), "IconViewMultiPageSchematics.gif");
                }
                this.setIcon(iconViewMultiPageSchematics);
            }
            if (nodeInfo instanceof Cell.CellGroup) {
                if (iconGroup == null) {
                    iconGroup = Resources.getResource(this.getClass(), "IconGroup.gif");
                }
                this.setIcon(iconGroup);
            }
            if (nodeInfo instanceof String) {
                String theString = (String)nodeInfo;
                if (theString.equalsIgnoreCase("jobs")) {
                    if (iconJobs == null) {
                        iconJobs = Resources.getResource(this.getClass(), "IconJobs.gif");
                    }
                    this.setIcon(iconJobs);
                } else if (theString.equalsIgnoreCase("libraries")) {
                    if (iconLibraries == null) {
                        iconLibraries = Resources.getResource(this.getClass(), "IconLibraries.gif");
                    }
                    this.setIcon(iconLibraries);
                } else if (theString.equalsIgnoreCase("errors")) {
                    if (iconErrors == null) {
                        iconErrors = Resources.getResource(this.getClass(), "IconErrors.gif");
                    }
                    this.setIcon(iconErrors);
                } else if (theString.equalsIgnoreCase("signals")) {
                    if (iconSignals == null) {
                        iconSignals = Resources.getResource(this.getClass(), "IconSignals.gif");
                    }
                    this.setIcon(iconSignals);
                } else if (theString.equalsIgnoreCase("sweeps")) {
                    if (iconSweeps == null) {
                        iconSweeps = Resources.getResource(this.getClass(), "IconSweeps.gif");
                    }
                    this.setIcon(iconSweeps);
                }
            }
            if (nodeInfo instanceof ErrorLogger.MessageLog) {
                ErrorLogger.MessageLog theLog = (ErrorLogger.MessageLog)nodeInfo;
                if (theLog instanceof ErrorLogger.WarningLog) {
                    if (iconWarnMsg == null) {
                        iconWarnMsg = Resources.getResource(this.getClass(), "IconWarningLog.gif");
                    }
                    this.setIcon(iconWarnMsg);
                } else {
                    if (iconErrorMsg == null) {
                        iconErrorMsg = Resources.getResource(this.getClass(), "IconErrorLog.gif");
                    }
                    this.setIcon(iconErrorMsg);
                }
            }
            if (nodeInfo instanceof Job) {
                Job j = (Job)nodeInfo;
            }
            return this;
        }

        private IconGroup findIconGroup(View view) {
            IconGroup ig = (IconGroup)this.iconGroups.get(view);
            if (ig == null) {
                ig = new IconGroup();
                if (view == View.LAYOUT) {
                    ig.regular = Resources.getResource(this.getClass(), "IconViewLayout.gif");
                } else if (view == View.SCHEMATIC) {
                    ig.regular = Resources.getResource(this.getClass(), "IconViewSchematics.gif");
                } else if (view == View.ICON) {
                    ig.regular = Resources.getResource(this.getClass(), "IconViewIcon.gif");
                } else if (view == View.DOC) {
                    ig.regular = Resources.getResource(this.getClass(), "IconViewText.gif");
                } else {
                    ig.regular = Resources.getResource(this.getClass(), "IconViewMisc.gif");
                }
                if (iconSpiderWeb == null) {
                    iconSpiderWeb = Resources.getResource(this.getClass(), "IconSpiderWeb.gif");
                }
                if (iconLocked == null) {
                    iconLocked = Resources.getResource(this.getClass(), "IconLocked.gif");
                }
                if (iconUnlocked == null) {
                    iconUnlocked = Resources.getResource(this.getClass(), "IconUnlocked.gif");
                }
                if (iconAvailable == null) {
                    iconAvailable = Resources.getResource(this.getClass(), "IconAvailable.gif");
                }
                ig.old = this.buildIcon(iconSpiderWeb, ig.regular);
                ig.available = this.buildIcon(iconAvailable, ig.regular);
                ig.locked = this.buildIcon(iconLocked, ig.regular);
                ig.unlocked = this.buildIcon(iconUnlocked, ig.regular);
                this.iconGroups.put(view, ig);
            }
            return ig;
        }

        private ImageIcon buildIcon(ImageIcon fg, ImageIcon bg) {
            int wid = fg.getIconWidth();
            int hei = fg.getIconHeight();
            BufferedImage bi = new BufferedImage(wid, hei, 1);
            int[] backgroundValues = new int[wid * hei];
            PixelGrabber background = new PixelGrabber(bg.getImage(), 0, 0, wid, hei, backgroundValues, 0, wid);
            int[] foregroundValues = new int[wid * hei];
            PixelGrabber foreground = new PixelGrabber(fg.getImage(), 0, 0, wid, hei, foregroundValues, 0, wid);
            try {
                background.grabPixels();
                foreground.grabPixels();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            for (int y = 0; y < hei; ++y) {
                for (int x = 0; x < wid; ++x) {
                    int bCol = backgroundValues[y * wid + x];
                    int fCol = foregroundValues[y * wid + x];
                    if ((fCol & 0xFFFFFF) != 0xFFFFFF) {
                        bCol = fCol;
                    }
                    bi.setRGB(x, y, bCol);
                }
            }
            return new ImageIcon(bi);
        }
    }

    private static class MultiPageCell {
        private Cell cell;
        private int pageNo;

        private MultiPageCell() {
        }
    }

    private static class CellAndCount {
        private Cell cell;
        private int count;

        public CellAndCount(Cell cell, int count) {
            this.cell = cell;
            this.count = count;
        }

        public Cell getCell() {
            return this.cell;
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class IconGroup {
        private ImageIcon regular;
        private ImageIcon old;
        private ImageIcon available;
        private ImageIcon locked;
        private ImageIcon unlocked;

        private IconGroup() {
        }
    }
}

