/*
 * Electric(tm) VLSI Design System
 *
 * File: graphpcmsgview.cpp
 * Message window implementation file
 * Written by: Steven M. Rubin, Static Free Software
 *
 * Copyright (c) 2000 Static Free Software.
 *
 * Electric(tm) is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * Electric(tm) is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Electric(tm); see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 59 Temple Place, Suite 330,
 * Boston, Mass 02111-1307, USA.
 *
 * Static Free Software
 * 4119 Alpine Road
 * Portola Valley, California 94028
 * info@staticfreesoft.com
 */

#include "graphpcstdafx.h"
#include "graphpc.h"
#include "graphpcmsgview.h"
#include "graphpcchildframe.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CElectricMsgView

IMPLEMENT_DYNCREATE(CElectricMsgView, CEditView)

CElectricMsgView::CElectricMsgView()
{
}

CElectricMsgView::~CElectricMsgView()
{
}

BEGIN_MESSAGE_MAP(CElectricMsgView, CEditView)
	//{{AFX_MSG_MAP(CElectricMsgView)
	ON_CONTROL_REFLECT(EN_CHANGE, OnChange)
	ON_WM_CHAR()
	ON_WM_SIZE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CElectricMsgView drawing

void CElectricMsgView::OnDraw(CDC* pDC)
{
	CDocument* pDoc = GetDocument();
}

/////////////////////////////////////////////////////////////////////////////
// CElectricMsgView diagnostics

#ifdef _DEBUG
void CElectricMsgView::AssertValid() const
{
	CEditView::AssertValid();
}

void CElectricMsgView::Dump(CDumpContext& dc) const
{
	CEditView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CElectricMsgView message handlers

void gra_activateframe(CChildFrame *frame, BOOL bActivate);
void gra_resize(CChildFrame *frame, int cx, int cy);
void gra_keyaction(UINT nChar, UINT nFlags, UINT nRepCnt);

void CElectricMsgView::OnChange()
{
}

void CElectricMsgView::OnChar(UINT nChar, UINT nRepCnt, UINT nFlags)
{
	UINT rChar;

	if (nChar == 033) rChar = 04; else
		rChar = nChar;
	gra_keyaction(rChar, 0, 1);
}

void CElectricMsgView::OnActivateView(BOOL bActivate, CView* pActivateView, CView* pDeactiveView)
{
	extern CChildFrame *gra_messageswindow;

	CEditView::OnActivateView(bActivate, pActivateView, pDeactiveView);

	gra_activateframe(gra_messageswindow, bActivate);
}

void CElectricMsgView::OnSize(UINT nType, int cx, int cy)
{
	extern CChildFrame *gra_messageswindow;

	CEditView::OnSize(nType, cx, cy);

	if (cx != 0 && cy != 0)
		gra_resize(gra_messageswindow, cx, cy);
}
