;;; DO NOT MODIFY THIS FILE
(if (featurep 'gnus-autoloads) (error "Already loaded"))

;;;### (autoloads nil "_pkg" "lisp/_pkg.el")

(package-provide 'gnus :version 2.05 :author-version "5.10.10" :type 'regular)

;;;***

;;;### (autoloads (binhex-decode-region binhex-decode-region-external binhex-decode-region-internal) "binhex" "lisp/binhex.el")

(defconst binhex-begin-line "^:...............................................................$")

(autoload 'binhex-decode-region-internal "binhex" "\
Binhex decode region between START and END without using an external program.
If HEADER-ONLY is non-nil only decode header and return filename." t nil)

(autoload 'binhex-decode-region-external "binhex" "\
Binhex decode region between START and END using external decoder." t nil)

(autoload 'binhex-decode-region "binhex" "\
Binhex decode region between START and END." t nil)

;;;***

;;;### (autoloads (canlock-verify canlock-insert-header) "canlock" "lisp/canlock.el")

(autoload 'canlock-insert-header "canlock" "\
Insert a Cancel-Key and/or a Cancel-Lock header if possible." nil nil)

(autoload 'canlock-verify "canlock" "\
Verify Cancel-Lock or Cancel-Key in BUFFER.
If BUFFER is nil, the current buffer is assumed.  Signal an error if
it fails." t nil)

;;;***

;;;### (autoloads (gnus-article-outlook-deuglify-article gnus-outlook-deuglify-article gnus-article-outlook-repair-attribution gnus-article-outlook-unwrap-lines) "deuglify" "lisp/deuglify.el")

(autoload 'gnus-article-outlook-unwrap-lines "deuglify" "\
Unwrap lines that appear to be wrapped citation lines.
You can control what lines will be unwrapped by frobbing
`gnus-outlook-deuglify-unwrap-min' and `gnus-outlook-deuglify-unwrap-max',
indicating the minimum and maximum length of an unwrapped citation line.  If
NODISPLAY is non-nil, don't redisplay the article buffer." t nil)

(autoload 'gnus-article-outlook-repair-attribution "deuglify" "\
Repair a broken attribution line.
If NODISPLAY is non-nil, don't redisplay the article buffer." t nil)

(autoload 'gnus-outlook-deuglify-article "deuglify" "\
Full deuglify of broken Outlook (Express) articles.
Treat dumbquotes, unwrap lines, repair attribution and rearrange citation.  If
NODISPLAY is non-nil, don't redisplay the article buffer." t nil)

(autoload 'gnus-article-outlook-deuglify-article "deuglify" "\
Deuglify broken Outlook (Express) articles and redisplay." t nil)

;;;***

;;;### (autoloads (gnus-earcon-display) "earcon" "lisp/earcon.el")

(autoload 'gnus-earcon-display "earcon" "\
Play sounds in message buffers." t nil)

;;;***

;;;### (autoloads (fill-flowed fill-flowed-encode) "flow-fill" "lisp/flow-fill.el")

(autoload 'fill-flowed-encode "flow-fill" nil nil nil)

(autoload 'fill-flowed "flow-fill" nil nil nil)

;;;***

;;;### (autoloads (gmm-tool-bar-from-list gmm-widget-p gmm-error gmm-message) "gmm-utils" "lisp/gmm-utils.el")

(autoload 'gmm-message "gmm-utils" "\
If LEVEL is lower than `gmm-verbose' print ARGS using `message'.

Guideline for numbers:
1 - error messages, 3 - non-serious error messages, 5 - messages for things
that take a long time, 7 - not very important messages on stuff, 9 - messages
inside loops." nil nil)

(autoload 'gmm-error "gmm-utils" "\
Beep an error if LEVEL is equal to or less than `gmm-verbose'.
ARGS are passed to `message'." nil nil)

(autoload 'gmm-widget-p "gmm-utils" "\
Non-nil if SYMBOL is a widget." nil nil)

(autoload 'gmm-tool-bar-from-list "gmm-utils" "\
Make a tool bar from ICON-LIST.

Within each entry of ICON-LIST, the first element is a menu
command, the second element is an icon file name and the third
element is a test function.  You can use \\[describe-key]
<menu-entry> to find out the name of a menu command.  The fourth
and all following elements are passed as the PROPS argument to the
function `tool-bar-local-item'.

If ZAP-LIST is a list, remove those item from the default
`tool-bar-map'.  If it is t, start with a new sparse map.  You
can use \\[describe-key] <icon> to find out the name of an icon
item.  When \\[describe-key] <icon> shows \"<tool-bar> <new-file>
runs the command find-file\", then use `new-file' in ZAP-LIST.

DEFAULT-MAP specifies the default key map for ICON-LIST." nil nil)

;;;***

;;;### (autoloads (gnus-agent-regenerate gnus-agent-batch gnus-agent-batch-fetch gnus-agent-find-parameter gnus-agent-possibly-alter-active gnus-agent-get-undownloaded-list gnus-agent-delete-group gnus-agent-rename-group gnus-agent-possibly-save-gcc gnus-agentize gnus-slave-unplugged gnus-plugged gnus-unplugged) "gnus-agent" "lisp/gnus-agent.el")

(autoload 'gnus-unplugged "gnus-agent" "\
Start Gnus unplugged." t nil)

(autoload 'gnus-plugged "gnus-agent" "\
Start Gnus plugged." t nil)

(autoload 'gnus-slave-unplugged "gnus-agent" "\
Read news as a slave unplugged." t nil)

(autoload 'gnus-agentize "gnus-agent" "\
Allow Gnus to be an offline newsreader.

The gnus-agentize function is now called internally by gnus when
gnus-agent is set.  If you wish to avoid calling gnus-agentize,
customize gnus-agent to nil.

This will modify the `gnus-setup-news-hook', and
`message-send-mail-real-function' variables, and install the Gnus agent
minor mode in all Gnus buffers." t nil)

(autoload 'gnus-agent-possibly-save-gcc "gnus-agent" "\
Save GCC if Gnus is unplugged." nil nil)

(autoload 'gnus-agent-rename-group "gnus-agent" "\
Rename fully-qualified OLD-GROUP as NEW-GROUP.
Always updates the agent, even when disabled, as the old agent
files would corrupt gnus when the agent was next enabled.
Depends upon the caller to determine whether group renaming is
supported." nil nil)

(autoload 'gnus-agent-delete-group "gnus-agent" "\
Delete fully-qualified GROUP.
Always updates the agent, even when disabled, as the old agent
files would corrupt gnus when the agent was next enabled.
Depends upon the caller to determine whether group deletion is
supported." nil nil)

(autoload 'gnus-agent-get-undownloaded-list "gnus-agent" "\
Construct list of articles that have not been downloaded." nil nil)

(autoload 'gnus-agent-possibly-alter-active "gnus-agent" "\
Possibly expand a group's active range to include articles
downloaded into the agent." nil nil)

(autoload 'gnus-agent-find-parameter "gnus-agent" "\
Search for GROUPs SYMBOL in the group's parameters, the group's
topic parameters, the group's category, or the customizable
variables.  Returns the first non-nil value found." nil nil)

(autoload 'gnus-agent-batch-fetch "gnus-agent" "\
Start Gnus and fetch session." t nil)

(autoload 'gnus-agent-batch "gnus-agent" "\
Start Gnus, send queue and fetch session." t nil)

(autoload 'gnus-agent-regenerate "gnus-agent" "\
Regenerate all agent covered files.
If CLEAN, obsolete (ignore)." t nil)

;;;***

;;;### (autoloads (gnus-article-prepare-display) "gnus-art" "lisp/gnus-art.el")

(autoload 'gnus-article-prepare-display "gnus-art" "\
Make the current buffer look like a nice article." nil nil)

;;;***

;;;### (autoloads (gnus-audio-play) "gnus-audio" "lisp/gnus-audio.el")

(autoload 'gnus-audio-play "gnus-audio" "\
Play a sound FILE through the speaker." t nil)

;;;***

;;;### (autoloads (gnus-cache-delete-group gnus-cache-rename-group gnus-cache-generate-nov-databases gnus-cache-generate-active gnus-jog-cache) "gnus-cache" "lisp/gnus-cache.el")

(autoload 'gnus-jog-cache "gnus-cache" "\
Go through all groups and put the articles into the cache.

Usage:
$ emacs -batch -l ~/.emacs -l gnus -f gnus-jog-cache" t nil)

(autoload 'gnus-cache-generate-active "gnus-cache" "\
Generate the cache active file." t nil)

(autoload 'gnus-cache-generate-nov-databases "gnus-cache" "\
Generate NOV files recursively starting in DIR." t nil)

(autoload 'gnus-cache-rename-group "gnus-cache" "\
Rename OLD-GROUP as NEW-GROUP.
Always updates the cache, even when disabled, as the old cache
files would corrupt Gnus when the cache was next enabled.  It
depends on the caller to determine whether group renaming is
supported." nil nil)

(autoload 'gnus-cache-delete-group "gnus-cache" "\
Delete GROUP from the cache.
Always updates the cache, even when disabled, as the old cache
files would corrupt gnus when the cache was next enabled.
Depends upon the caller to determine whether group deletion is
supported." nil nil)

;;;***

;;;### (autoloads (gnus-delay-initialize gnus-delay-send-queue gnus-delay-article) "gnus-delay" "lisp/gnus-delay.el")

(autoload 'gnus-delay-article "gnus-delay" "\
Delay this article by some time.
DELAY is a string, giving the length of the time.  Possible values are:

* <digits><units> for <units> in minutes (`m'), hours (`h'), days (`d'),
  weeks (`w'), months (`M'), or years (`Y');

* YYYY-MM-DD for a specific date.  The time of day is given by the
  variable `gnus-delay-default-hour', minute and second are zero.

* hh:mm for a specific time.  Use 24h format.  If it is later than this
  time, then the deadline is tomorrow, else today." t nil)

(autoload 'gnus-delay-send-queue "gnus-delay" "\
Send all the delayed messages that are due now." t nil)

(autoload 'gnus-delay-initialize "gnus-delay" "\
Initialize the gnus-delay package.
This sets up a key binding in `message-mode' to delay a message.
This tells Gnus to look for delayed messages after getting new news.

The optional arg NO-KEYMAP is ignored.
Checking delayed messages is skipped if optional arg NO-CHECK is non-nil." nil nil)

;;;***

;;;### (autoloads (gnus-user-format-function-D gnus-user-format-function-d) "gnus-diary" "lisp/gnus-diary.el")

(autoload 'gnus-user-format-function-d "gnus-diary" nil nil nil)

(autoload 'gnus-user-format-function-D "gnus-diary" nil nil nil)

;;;***

;;;### (autoloads (turn-on-gnus-dired-mode) "gnus-dired" "lisp/gnus-dired.el")

(autoload 'turn-on-gnus-dired-mode "gnus-dired" "\
Convenience method to turn on gnus-dired-mode." nil nil)

;;;***

;;;### (autoloads (gnus-draft-reminder) "gnus-draft" "lisp/gnus-draft.el")

(autoload 'gnus-draft-reminder "gnus-draft" "\
Reminder user if there are unsent drafts." t nil)

;;;***

;;;### (autoloads (gnus-convert-png-to-face gnus-convert-face-to-png gnus-face-from-file gnus-x-face-from-file gnus-insert-random-x-face-header gnus-random-x-face) "gnus-fun" "lisp/gnus-fun.el")

(autoload 'gnus-random-x-face "gnus-fun" "\
Return X-Face header data chosen randomly from `gnus-x-face-directory'." t nil)

(autoload 'gnus-insert-random-x-face-header "gnus-fun" "\
Insert a random X-Face header from `gnus-x-face-directory'." t nil)

(autoload 'gnus-x-face-from-file "gnus-fun" "\
Insert an X-Face header based on an image file." t nil)

(autoload 'gnus-face-from-file "gnus-fun" "\
Return a Face header based on an image file." t nil)

(autoload 'gnus-convert-face-to-png "gnus-fun" "\
Convert FACE (which is base64-encoded) to a PNG.
The PNG is returned as a string." nil nil)

(autoload 'gnus-convert-png-to-face "gnus-fun" "\
Convert FILE to a Face.
FILE should be a PNG file that's 48x48 and smaller than or equal to
726 bytes." nil nil)

;;;***

;;;### (autoloads (gnus-fetch-group-other-frame gnus-fetch-group) "gnus-group" "lisp/gnus-group.el")

(autoload 'gnus-fetch-group "gnus-group" "\
Start Gnus if necessary and enter GROUP.
Returns whether the fetching was successful or not." t nil)

(autoload 'gnus-fetch-group-other-frame "gnus-group" "\
Pop up a frame and enter GROUP." t nil)

;;;***

;;;### (autoloads (gnus-batch-score) "gnus-kill" "lisp/gnus-kill.el")

(defalias 'gnus-batch-kill 'gnus-batch-score)

(autoload 'gnus-batch-score "gnus-kill" "\
Run batched scoring.
Usage: emacs -batch -l ~/.emacs -l gnus -f gnus-batch-score" t nil)

;;;***

;;;### (autoloads (gnus-mailing-list-mode gnus-mailing-list-insinuate turn-on-gnus-mailing-list-mode) "gnus-ml" "lisp/gnus-ml.el")

(autoload 'turn-on-gnus-mailing-list-mode "gnus-ml" nil nil nil)

(autoload 'gnus-mailing-list-insinuate "gnus-ml" "\
Setup group parameters from List-Post header.
If FORCE is non-nil, replace the old ones." t nil)

(autoload 'gnus-mailing-list-mode "gnus-ml" "\
Minor mode for providing mailing-list commands.

\\{gnus-mailing-list-mode-map}" t nil)

;;;***

;;;### (autoloads (gnus-group-split-fancy gnus-group-split gnus-group-split-update gnus-group-split-setup) "gnus-mlspl" "lisp/gnus-mlspl.el")

(autoload 'gnus-group-split-setup "gnus-mlspl" "\
Set up the split for nnmail-split-fancy.
Sets things up so that nnmail-split-fancy is used for mail
splitting, and defines the variable nnmail-split-fancy according with
group parameters.

If AUTO-UPDATE is non-nil (prefix argument accepted, if called
interactively), it makes sure nnmail-split-fancy is re-computed before
getting new mail, by adding gnus-group-split-update to
nnmail-pre-get-new-mail-hook.

A non-nil CATCH-ALL replaces the current value of
gnus-group-split-default-catch-all-group.  This variable is only used
by gnus-group-split-update, and only when its CATCH-ALL argument is
nil.  This argument may contain any fancy split, that will be added as
the last split in a `|' split produced by gnus-group-split-fancy,
unless overridden by any group marked as a catch-all group.  Typical
uses are as simple as the name of a default mail group, but more
elaborate fancy splits may also be useful to split mail that doesn't
match any of the group-specified splitting rules.  See
`gnus-group-split-fancy' for details." t nil)

(autoload 'gnus-group-split-update "gnus-mlspl" "\
Computes nnmail-split-fancy from group params and CATCH-ALL.
It does this by calling by calling (gnus-group-split-fancy nil
nil CATCH-ALL).

If CATCH-ALL is nil, gnus-group-split-default-catch-all-group is used
instead.  This variable is set by gnus-group-split-setup." t nil)

(autoload 'gnus-group-split "gnus-mlspl" "\
Uses information from group parameters in order to split mail.
See `gnus-group-split-fancy' for more information.

gnus-group-split is a valid value for nnmail-split-methods." nil nil)

(autoload 'gnus-group-split-fancy "gnus-mlspl" "\
Uses information from group parameters in order to split mail.
It can be embedded into `nnmail-split-fancy' lists with the SPLIT

\(: gnus-group-split-fancy GROUPS NO-CROSSPOST CATCH-ALL)

GROUPS may be a regular expression or a list of group names, that will
be used to select candidate groups.  If it is omitted or nil, all
existing groups are considered.

if NO-CROSSPOST is omitted or nil, a & split will be returned,
otherwise, a | split, that does not allow crossposting, will be
returned.

For each selected group, a SPLIT is composed like this: if SPLIT-SPEC
is specified, this split is returned as-is (unless it is nil: in this
case, the group is ignored).  Otherwise, if TO-ADDRESS, TO-LIST and/or
EXTRA-ALIASES are specified, a regexp that matches any of them is
constructed (extra-aliases may be a list).  Additionally, if
SPLIT-REGEXP is specified, the regexp will be extended so that it
matches this regexp too, and if SPLIT-EXCLUDE is specified, RESTRICT
clauses will be generated.

If CATCH-ALL is nil, no catch-all handling is performed, regardless of
catch-all marks in group parameters.  Otherwise, if there is no
selected group whose SPLIT-REGEXP matches the empty string, nor is
there a selected group whose SPLIT-SPEC is 'catch-all, this fancy
split (say, a group name) will be appended to the returned SPLIT list,
as the last element of a '| SPLIT.

For example, given the following group parameters:

nnml:mail.bar:
\((to-address . \"bar@femail.com\")
 (split-regexp . \".*@femail\\\\.com\"))
nnml:mail.foo:
\((to-list . \"foo@nowhere.gov\")
 (extra-aliases \"foo@localhost\" \"foo-redist@home\")
 (split-exclude \"bugs-foo\" \"rambling-foo\")
 (admin-address . \"foo-request@nowhere.gov\"))
nnml:mail.others:
\((split-spec . catch-all))

Calling (gnus-group-split-fancy nil nil \"mail.others\") returns:

\(| (& (any \"\\\\(bar@femail\\\\.com\\\\|.*@femail\\\\.com\\\\)\"
	   \"mail.bar\")
      (any \"\\\\(foo@nowhere\\\\.gov\\\\|foo@localhost\\\\|foo-redist@home\\\\)\"
	   - \"bugs-foo\" - \"rambling-foo\" \"mail.foo\"))
   \"mail.others\")" nil nil)

;;;***

;;;### (autoloads (gnus-change-server) "gnus-move" "lisp/gnus-move.el")

(autoload 'gnus-change-server "gnus-move" "\
Move from FROM-SERVER to TO-SERVER.
Update the .newsrc.eld file to reflect the change of nntp server." t nil)

;;;***

;;;### (autoloads (gnus-button-reply gnus-button-mailto gnus-msg-mail) "gnus-msg" "lisp/gnus-msg.el")

(autoload 'gnus-msg-mail "gnus-msg" "\
Start editing a mail message to be sent.
Like `message-mail', but with Gnus paraphernalia, particularly the
Gcc: header for archiving purposes." t nil)

(autoload 'gnus-button-mailto "gnus-msg" "\
Mail to ADDRESS." nil nil)

(autoload 'gnus-button-reply "gnus-msg" "\
Like `message-reply'." t nil)

(define-mail-user-agent 'gnus-user-agent 'gnus-msg-mail 'message-send-and-exit 'message-kill-buffer 'message-send-hook)

;;;***

;;;### (autoloads (gnus-nocem-load-cache gnus-nocem-scan-groups) "gnus-nocem" "lisp/gnus-nocem.el")

(autoload 'gnus-nocem-scan-groups "gnus-nocem" "\
Scan all NoCeM groups for new NoCeM messages." t nil)

(autoload 'gnus-nocem-load-cache "gnus-nocem" "\
Load the NoCeM cache." t nil)

;;;***

;;;### (autoloads (gnus-treat-newsgroups-picon gnus-treat-mail-picon gnus-treat-from-picon) "gnus-picon" "lisp/gnus-picon.el")

(autoload 'gnus-treat-from-picon "gnus-picon" "\
Display picons in the From header.
If picons are already displayed, remove them." t nil)

(autoload 'gnus-treat-mail-picon "gnus-picon" "\
Display picons in the Cc and To headers.
If picons are already displayed, remove them." t nil)

(autoload 'gnus-treat-newsgroups-picon "gnus-picon" "\
Display picons in the Newsgroups and Followup-To headers.
If picons are already displayed, remove them." t nil)

;;;***

;;;### (autoloads (gnus-add-to-sorted-list gnus-sorted-nunion gnus-sorted-union gnus-sorted-nintersection gnus-sorted-range-intersection gnus-sorted-intersection gnus-intersection gnus-sorted-complement gnus-sorted-ndifference gnus-sorted-difference) "gnus-range" "lisp/gnus-range.el")

(autoload 'gnus-sorted-difference "gnus-range" "\
Return a list of elements of LIST1 that do not appear in LIST2.
Both lists have to be sorted over <.
The tail of LIST1 is not copied." nil nil)

(autoload 'gnus-sorted-ndifference "gnus-range" "\
Return a list of elements of LIST1 that do not appear in LIST2.
Both lists have to be sorted over <.
LIST1 is modified." nil nil)

(autoload 'gnus-sorted-complement "gnus-range" "\
Return a list of elements that are in LIST1 or LIST2 but not both.
Both lists have to be sorted over <." nil nil)

(autoload 'gnus-intersection "gnus-range" nil nil nil)

(autoload 'gnus-sorted-intersection "gnus-range" "\
Return intersection of LIST1 and LIST2.
LIST1 and LIST2 have to be sorted over <." nil nil)

(autoload 'gnus-sorted-range-intersection "gnus-range" "\
Return intersection of RANGE1 and RANGE2.
RANGE1 and RANGE2 have to be sorted over <." nil nil)

(defalias 'gnus-set-sorted-intersection 'gnus-sorted-nintersection)

(autoload 'gnus-sorted-nintersection "gnus-range" "\
Return intersection of LIST1 and LIST2 by modifying cdr pointers of LIST1.
LIST1 and LIST2 have to be sorted over <." nil nil)

(autoload 'gnus-sorted-union "gnus-range" "\
Return union of LIST1 and LIST2.
LIST1 and LIST2 have to be sorted over <." nil nil)

(autoload 'gnus-sorted-nunion "gnus-range" "\
Return union of LIST1 and LIST2 by modifying cdr pointers of LIST1.
LIST1 and LIST2 have to be sorted over <." nil nil)

(autoload 'gnus-add-to-sorted-list "gnus-range" "\
Add NUM into sorted LIST by side effect." nil nil)

;;;***

;;;### (autoloads (gnus-registry-install-hooks gnus-registry-initialize) "gnus-registry" "lisp/gnus-registry.el")

(autoload 'gnus-registry-initialize "gnus-registry" nil t nil)

(autoload 'gnus-registry-install-hooks "gnus-registry" "\
Install the registry hooks." t nil)

;;;***

;;;### (autoloads (gnus-sieve-article-add-rule gnus-sieve-generate gnus-sieve-update) "gnus-sieve" "lisp/gnus-sieve.el")

(autoload 'gnus-sieve-update "gnus-sieve" "\
Update the Sieve script in gnus-sieve-file, by replacing the region
between gnus-sieve-region-start and gnus-sieve-region-end with
\(gnus-sieve-script gnus-sieve-select-method gnus-sieve-crosspost), then
execute gnus-sieve-update-shell-command.
See the documentation for these variables and functions for details." t nil)

(autoload 'gnus-sieve-generate "gnus-sieve" "\
Generate the Sieve script in gnus-sieve-file, by replacing the region
between gnus-sieve-region-start and gnus-sieve-region-end with
\(gnus-sieve-script gnus-sieve-select-method gnus-sieve-crosspost).
See the documentation for these variables and functions for details." t nil)

(autoload 'gnus-sieve-article-add-rule "gnus-sieve" nil t nil)

;;;***

;;;### (autoloads (gnus-batch-brew-soup) "gnus-soup" "lisp/gnus-soup.el")

(autoload 'gnus-batch-brew-soup "gnus-soup" "\
Brew a SOUP packet from groups mention on the command line.
Will use the remaining command line arguments as regular expressions
for matching on group names.

For instance, if you want to brew on all the nnml groups, as well as
groups with \"emacs\" in the name, you could say something like:

$ emacs -batch -f gnus-batch-brew-soup ^nnml \".*emacs.*\"

Note -- this function hasn't been implemented yet." t nil)

;;;***

;;;### (autoloads (gnus-update-format) "gnus-spec" "lisp/gnus-spec.el")

(autoload 'gnus-update-format "gnus-spec" "\
Update the format specification near point." t nil)

;;;***

;;;### (autoloads (gnus-fixup-nnimap-unread-after-getting-new-news gnus-declare-backend) "gnus-start" "lisp/gnus-start.el")

(autoload 'gnus-declare-backend "gnus-start" "\
Declare back end NAME with ABILITIES as a Gnus back end." nil nil)

(autoload 'gnus-fixup-nnimap-unread-after-getting-new-news "gnus-start" nil nil nil)

;;;***

;;;### (autoloads (gnus-add-configuration) "gnus-win" "lisp/gnus-win.el")

(autoload 'gnus-add-configuration "gnus-win" "\
Add the window configuration CONF to `gnus-buffer-configuration'." nil nil)

;;;***

;;;### (autoloads (gnus gnus-other-frame gnus-slave gnus-no-server gnus-slave-no-server) "gnus" "lisp/gnus.el")
(when (fboundp 'custom-autoload)
(custom-autoload 'gnus-select-method "gnus"))

(autoload 'gnus-slave-no-server "gnus" "\
Read network news as a slave, without connecting to the local server." t nil)

(autoload 'gnus-no-server "gnus" "\
Read network news.
If ARG is a positive number, Gnus will use that as the startup
level. If ARG is nil, Gnus will be started at level 2.  If ARG is
non-nil and not a positive number, Gnus will prompt the user for the
name of an NNTP server to use.
As opposed to `gnus', this command will not connect to the local
server." t nil)

(autoload 'gnus-slave "gnus" "\
Read news as a slave." t nil)

(autoload 'gnus-other-frame "gnus" "\
Pop up a frame to read news.
This will call one of the Gnus commands which is specified by the user
option `gnus-other-frame-function' (default `gnus') with the argument
ARG if Gnus is not running, otherwise just pop up a Gnus frame.  The
optional second argument DISPLAY should be a standard display string
such as \"unix:0\" to specify where to pop up a frame.  If DISPLAY is
omitted or the function `make-frame-on-display' is not available, the
current display is used." t nil)

(autoload 'gnus "gnus" "\
Read network news.
If ARG is non-nil and a positive number, Gnus will use that as the
startup level.  If ARG is non-nil and not a positive number, Gnus will
prompt the user for the name of an NNTP server to use." t nil)

;;;***

;;;### (autoloads (mail-check-payment mail-add-payment hashcash-verify-payment hashcash-insert-payment) "hashcash" "lisp/hashcash.el")

(autoload 'hashcash-insert-payment "hashcash" "\
Insert X-Payment and X-Hashcash headers with a payment for ARG" t nil)

(autoload 'hashcash-verify-payment "hashcash" "\
Verify a hashcash payment" nil nil)

(autoload 'mail-add-payment "hashcash" "\
Add X-Payment: and X-Hashcash: headers with a hashcash payment
for each recipient address.  Prefix arg sets default payment temporarily." t nil)

(autoload 'mail-check-payment "hashcash" "\
Look for a valid X-Payment: or X-Hashcash: header.
Prefix arg sets default accept amount temporarily." t nil)

;;;***

;;;### (autoloads (html2text) "html2text" "lisp/html2text.el")

(autoload 'html2text "html2text" "\
Convert HTML to plain text in the current buffer." t nil)

;;;***

;;;### (autoloads (unbold-region bold-region message-news-other-frame message-news-other-window message-mail-other-frame message-mail-other-window message-bounce message-resend message-insinuate-rmail message-forward-rmail-make-body message-forward-make-body message-forward message-recover message-supersede message-cancel-news message-followup message-wide-reply message-reply message-news message-mail message-mode message-signature-insert-empty-line message-signature-file message-signature message-indent-citation-function message-cite-function message-yank-prefix message-citation-line-function message-send-mail-function message-user-organization-file message-signature-separator message-from-style) "message" "lisp/message.el")

(defvar message-from-style 'default "\
*Specifies how \"From\" headers look.

If nil, they contain just the return address like:
	king@grassland.com
If `parens', they look like:
	king@grassland.com (Elvis Parsley)
If `angles', they look like:
	Elvis Parsley <king@grassland.com>

Otherwise, most addresses look like `angles', but they look like
`parens' if `angles' would need quoting and `parens' would not.")

(defvar message-signature-separator "^-- *$" "\
Regexp matching the signature separator.")

(defvar message-user-organization-file "/usr/lib/news/organization" "\
*Local news organization file.")

(defvar message-send-mail-function 'message-send-mail-with-sendmail "\
Function to call to send the current buffer as mail.
The headers should be delimited by a line whose contents match the
variable `mail-header-separator'.

Valid values include `message-send-mail-with-sendmail' (the default),
`message-send-mail-with-mh', `message-send-mail-with-qmail',
`message-smtpmail-send-it', `smtpmail-send-it' and `feedmail-send-it'.

See also `send-mail-function'.")

(defvar message-citation-line-function 'message-insert-citation-line "\
*Function called to insert the \"Whomever writes:\" line.

Note that Gnus provides a feature where the reader can click on
`writes:' to hide the cited text.  If you change this line too much,
people who read your message will have to change their Gnus
configuration.  See the variable `gnus-cite-attribution-suffix'.")

(defvar message-yank-prefix "> " "\
*Prefix inserted on the lines of yanked messages.
Fix `message-cite-prefix-regexp' if it is set to an abnormal value.
See also `message-yank-cited-prefix'.")

(defvar message-cite-function 'message-cite-original "\
*Function for citing an original message.
Predefined functions include `message-cite-original' and
`message-cite-original-without-signature'.
Note that `message-cite-original' uses `mail-citation-hook' if that is non-nil.")

(defvar message-indent-citation-function 'message-indent-citation "\
*Function for modifying a citation just inserted in the mail buffer.
This can also be a list of functions.  Each function can find the
citation between (point) and (mark t).  And each function should leave
point and mark around the citation text as modified.")

(defvar message-signature t "\
*String to be inserted at the end of the message buffer.
If t, the `message-signature-file' file will be inserted instead.
If a function, the result from the function will be used instead.
If a form, the result from the form will be used instead.")

(defvar message-signature-file "~/.signature" "\
*Name of file containing the text inserted at end of message buffer.
Ignored if the named file doesn't exist.
If nil, don't insert a signature.")

(defvar message-signature-insert-empty-line t "\
*If non-nil, insert an empty line before the signature separator.")

(define-mail-user-agent 'message-user-agent 'message-mail 'message-send-and-exit 'message-kill-buffer 'message-send-hook)

(autoload 'message-mode "message" "Major mode for editing mail and news to be sent.\nLike Text Mode but with these additional commands:\\<message-mode-map>\nC-c C-s  `message-send' (send the message)  C-c C-c  `message-send-and-exit'\nC-c C-d  Postpone sending the message       C-c C-k  Kill the message\nC-c C-f  move to a header field (and create it if there isn't):\n	 C-c C-f C-t  move to To	C-c C-f C-s  move to Subject\n	 C-c C-f C-c  move to Cc	C-c C-f C-b  move to Bcc\n	 C-c C-f C-w  move to Fcc	C-c C-f C-r  move to Reply-To\n	 C-c C-f C-u  move to Summary	C-c C-f C-n  move to Newsgroups\n	 C-c C-f C-k  move to Keywords	C-c C-f C-d  move to Distribution\n         C-c C-f C-o  move to From (\"Originator\")\n	 C-c C-f C-f  move to Followup-To\n	 C-c C-f C-m  move to Mail-Followup-To\n	 C-c C-f C-i  cycle through Importance values\n	 C-c C-f s    change subject and append \"(was: <Old Subject>)\"\n	 C-c C-f x    crossposting with FollowUp-To header and note in body\n	 C-c C-f t    replace To: header with contents of Cc: or Bcc:\n	 C-c C-f a    Insert X-No-Archive: header and a note in the body\nC-c C-t  `message-insert-to' (add a To header to a news followup)\nC-c C-l  `message-to-list-only' (removes all but list address in to/cc)\nC-c C-n  `message-insert-newsgroups' (add a Newsgroup header to a news reply)\nC-c C-b  `message-goto-body' (move to beginning of message text).\nC-c C-i  `message-goto-signature' (move to the beginning of the signature).\nC-c C-w  `message-insert-signature' (insert `message-signature-file' file).\nC-c C-y  `message-yank-original' (insert current message, if any).\nC-c C-q  `message-fill-yanked-message' (fill what was yanked).\nC-c C-e  `message-elide-region' (elide the text between point and mark).\nC-c C-v  `message-delete-not-region' (remove the text outside the region).\nC-c C-z  `message-kill-to-signature' (kill the text up to the signature).\nC-c C-r  `message-caesar-buffer-body' (rot13 the message body).\nC-c C-a  `mml-attach-file' (attach a file as MIME).\nC-c C-u  `message-insert-or-toggle-importance'  (insert or cycle importance).\nC-c M-n  `message-insert-disposition-notification-to'  (request receipt).\nC-c M-m  `message-mark-inserted-region' (mark region with enclosing tags).\nC-c M-f  `message-mark-insert-file' (insert file marked with enclosing tags).\nM-RET    `message-newline-and-reformat' (break the line and reformat)." t nil)

(autoload 'message-mail "message" "\
Start editing a mail message to be sent.
OTHER-HEADERS is an alist of header/value pairs.  CONTINUE says whether
to continue editing a message already being composed.  SWITCH-FUNCTION
is a function used to switch to and display the mail buffer." t nil)

(autoload 'message-news "message" "\
Start editing a news article to be sent." t nil)

(autoload 'message-reply "message" "\
Start editing a reply to the article in the current buffer." t nil)

(autoload 'message-wide-reply "message" "\
Make a \"wide\" reply to the message in the current buffer." t nil)

(autoload 'message-followup "message" "\
Follow up to the message in the current buffer.
If TO-NEWSGROUPS, use that as the new Newsgroups line." t nil)

(autoload 'message-cancel-news "message" "\
Cancel an article you posted.
If ARG, allow editing of the cancellation message." t nil)

(autoload 'message-supersede "message" "\
Start composing a message to supersede the current message.
This is done simply by taking the old article and adding a Supersedes
header line with the old Message-ID." t nil)

(autoload 'message-recover "message" "\
Reread contents of current buffer from its last auto-save file." t nil)

(autoload 'message-forward "message" "\
Forward the current message via mail.
Optional NEWS will use news to forward instead of mail.
Optional DIGEST will use digest to forward." t nil)

(autoload 'message-forward-make-body "message" nil nil nil)

(autoload 'message-forward-rmail-make-body "message" nil nil nil)

(autoload 'message-insinuate-rmail "message" "\
Let RMAIL use message to forward." t nil)

(autoload 'message-resend "message" "\
Resend the current article to ADDRESS." t nil)

(autoload 'message-bounce "message" "\
Re-mail the current message.
This only makes sense if the current message is a bounce message that
contains some mail you have written which has been bounced back to
you." t nil)

(autoload 'message-mail-other-window "message" "\
Like `message-mail' command, but display mail buffer in another window." t nil)

(autoload 'message-mail-other-frame "message" "\
Like `message-mail' command, but display mail buffer in another frame." t nil)

(autoload 'message-news-other-window "message" "\
Start editing a news article to be sent." t nil)

(autoload 'message-news-other-frame "message" "\
Start editing a news article to be sent." t nil)

(autoload 'bold-region "message" "\
Bold all nonblank characters in the region.
Works by overstriking characters.
Called from program, takes two arguments START and END
which specify the range to operate on." t nil)

(autoload 'unbold-region "message" "\
Remove all boldness (overstruck characters) in the region.
Called from program, takes two arguments START and END
which specify the range to operate on." t nil)

;;;***

;;;### (autoloads (mm-inline-external-body mm-extern-cache-contents) "mm-extern" "lisp/mm-extern.el")

(autoload 'mm-extern-cache-contents "mm-extern" "\
Put the external-body part of HANDLE into its cache." nil nil)

(autoload 'mm-inline-external-body "mm-extern" "\
Show the external-body part of HANDLE.
This function replaces the buffer of HANDLE with a buffer contains
the entire message.
If NO-DISPLAY is nil, display it. Otherwise, do nothing after replacing." nil nil)

;;;***

;;;### (autoloads (mm-inline-partial) "mm-partial" "lisp/mm-partial.el")

(autoload 'mm-inline-partial "mm-partial" "\
Show the partial part of HANDLE.
This function replaces the buffer of HANDLE with a buffer contains
the entire message.
If NO-DISPLAY is nil, display it. Otherwise, do nothing after replacing." nil nil)

;;;***

;;;### (autoloads (mm-url-insert-file-contents-external mm-url-insert-file-contents) "mm-url" "lisp/mm-url.el")

(autoload 'mm-url-insert-file-contents "mm-url" "\
Insert file contents of URL.
If `mm-url-use-external' is non-nil, use `mm-url-program'." nil nil)

(autoload 'mm-url-insert-file-contents-external "mm-url" "\
Insert file contents of URL using `mm-url-program'." nil nil)

;;;***

;;;### (autoloads (mm-uu-dissect-text-parts mm-uu-dissect) "mm-uu" "lisp/mm-uu.el")

(autoload 'mm-uu-dissect "mm-uu" "\
Dissect the current buffer and return a list of uu handles.
The optional NOHEADER means there's no header in the buffer.
MIME-TYPE specifies a MIME type and parameters, which defaults to the
value of `mm-uu-text-plain-type'." nil nil)

(autoload 'mm-uu-dissect-text-parts "mm-uu" "\
Dissect text parts and put uu handles into HANDLE.
Assume text has been decoded if DECODED is non-nil." nil nil)

;;;***

;;;### (autoloads (mml1991-sign mml1991-encrypt) "mml1991" "lisp/mml1991.el")

(autoload 'mml1991-encrypt "mml1991" nil nil nil)

(autoload 'mml1991-sign "mml1991" nil nil nil)

;;;***

;;;### (autoloads (mml2015-self-encrypt mml2015-sign mml2015-encrypt mml2015-verify-test mml2015-verify mml2015-decrypt-test mml2015-decrypt) "mml2015" "lisp/mml2015.el")

(autoload 'mml2015-decrypt "mml2015" nil nil nil)

(autoload 'mml2015-decrypt-test "mml2015" nil nil nil)

(autoload 'mml2015-verify "mml2015" nil nil nil)

(autoload 'mml2015-verify-test "mml2015" nil nil nil)

(autoload 'mml2015-encrypt "mml2015" nil nil nil)

(autoload 'mml2015-sign "mml2015" nil nil nil)

(autoload 'mml2015-self-encrypt "mml2015" nil nil nil)

;;;***

;;;### (autoloads (nndiary-generate-nov-databases) "nndiary" "lisp/nndiary.el")

(autoload 'nndiary-generate-nov-databases "nndiary" "\
Generate NOV databases in all nndiary directories." t nil)

;;;***

;;;### (autoloads (nndoc-add-type) "nndoc" "lisp/nndoc.el")

(autoload 'nndoc-add-type "nndoc" "\
Add document DEFINITION to the list of nndoc document definitions.
If POSITION is nil or `last', the definition will be added
as the last checked definition, if t or `first', add as the
first definition, and if any other symbol, add after that
symbol in the alist." nil nil)

;;;***

;;;### (autoloads (nnfolder-generate-active-file) "nnfolder" "lisp/nnfolder.el")

(autoload 'nnfolder-generate-active-file "nnfolder" "\
Look for mbox folders in the nnfolder directory and make them into groups.
This command does not work if you use short group names." t nil)

;;;***

;;;### (autoloads (nnkiboze-generate-groups) "nnkiboze" "lisp/nnkiboze.el")

(autoload 'nnkiboze-generate-groups "nnkiboze" "\
\"Usage: emacs -batch -l nnkiboze -f nnkiboze-generate-groups\".
Finds out what articles are to be part of the nnkiboze groups." t nil)

;;;***

;;;### (autoloads (nnml-generate-nov-databases) "nnml" "lisp/nnml.el")

(autoload 'nnml-generate-nov-databases "nnml" "\
Generate NOV databases in all nnml directories." t nil)

;;;***

;;;### (autoloads (nnsoup-revert-variables nnsoup-set-variables nnsoup-pack-replies) "nnsoup" "lisp/nnsoup.el")

(autoload 'nnsoup-pack-replies "nnsoup" "\
Make an outbound package of SOUP replies." t nil)

(autoload 'nnsoup-set-variables "nnsoup" "\
Use the SOUP methods for posting news and mailing mail." t nil)

(autoload 'nnsoup-revert-variables "nnsoup" "\
Revert posting and mailing methods to the standard Emacs methods." t nil)

;;;***

;;;### (autoloads (parse-time-string) "parse-time" "lisp/parse-time.el")

(autoload 'parse-time-string "parse-time" "\
Parse the time-string STRING into (SEC MIN HOUR DAY MON YEAR DOW DST TZ).
STRING should be on something resembling an RFC2822 string, à la
\"Fri, 25 Mar 2016 16:24:56 +0100\", but this function is
somewhat liberal in what format it accepts, and will attempt to
return a \"likely\" value even for somewhat malformed strings.
The values are identical to those of `decode-time', but any values that are
unknown are returned as nil." nil nil)

;;;***

;;;### (autoloads (quoted-printable-decode-region) "qp" "lisp/qp.el")

(autoload 'quoted-printable-decode-region "qp" "\
Decode quoted-printable in the region between FROM and TO, per RFC 2045.
If CODING-SYSTEM is non-nil, decode bytes into characters with that
coding-system.

Interactively, you can supply the CODING-SYSTEM argument
with \\[universal-coding-system-argument].

The CODING-SYSTEM argument is a historical hangover and is deprecated.
QP encodes raw bytes and should be decoded into raw bytes.  Decoding
them into characters should be done separately." t nil)

;;;***

;;;### (autoloads (gnus-score-mode) "score-mode" "lisp/score-mode.el")

(autoload 'gnus-score-mode "score-mode" "\
Mode for editing Gnus score files.
This mode is an extended emacs-lisp mode.

\\{gnus-score-mode-map}" t nil)

;;;***

;;;### (autoloads (gnus-smiley-display smiley-buffer smiley-region) "smiley" "lisp/smiley.el")

(autoload 'smiley-region "smiley" "\
Smilify the region between point and mark." t nil)

(autoload 'smiley-buffer "smiley" nil t nil)

(autoload 'gnus-smiley-display "smiley" "\
Display \"smileys\" as small graphical icons.
With arg, turn displaying on if and only if arg is positive." t nil)

;;;***

;;;### (autoloads (spam-report-deagentize spam-report-agentize spam-report-url-to-file spam-report-url-ping-mm-url spam-report-process-queue) "spam-report" "lisp/spam-report.el")

(autoload 'spam-report-process-queue "spam-report" "\
Report all queued requests from `spam-report-requests-file'.

If FILE is given, use it instead of `spam-report-requests-file'.
If KEEP is t, leave old requests in the file.  If KEEP is the
symbol `ask', query before flushing the queue file." t nil)

(autoload 'spam-report-url-ping-mm-url "spam-report" "\
Ping a host through HTTP, addressing a specific GET resource. Use
the external program specified in `mm-url-program' to connect to
server." nil nil)

(autoload 'spam-report-url-to-file "spam-report" "\
Collect spam report requests in `spam-report-requests-file'.
Customize `spam-report-url-ping-function' to use this function." nil nil)

(autoload 'spam-report-agentize "spam-report" "\
Add spam-report support to the Agent.
Spam reports will be queued with \\[spam-report-url-to-file] when
the Agent is unplugged, and will be submitted in a batch when the
Agent is plugged." t nil)

(autoload 'spam-report-deagentize "spam-report" "\
Remove spam-report support from the Agent.
Spam reports will be queued with the method used when
\\[spam-report-agentize] was run." t nil)

;;;***

;;;### (autoloads (spam-initialize) "spam" "lisp/spam.el")

(autoload 'spam-initialize "spam" "\
Install the spam.el hooks and do other initialization" t nil)

;;;***

;;;### (autoloads (safe-date-to-time time-to-days time-to-day-in-year date-leap-year-p days-between date-to-day time-add time-subtract time-since days-to-time time-less-p seconds-to-time time-to-seconds date-to-time) "time-date" "lisp/time-date.el")

(autoload 'date-to-time "time-date" "\
Parse a string that represents a date-time and return a time value." nil nil)

(autoload 'time-to-seconds "time-date" "\
Convert time value TIME to a floating point number.
You can use `float-time' instead." nil nil)

(autoload 'seconds-to-time "time-date" "\
Convert SECONDS (a floating point number) to a time value." nil nil)

(autoload 'time-less-p "time-date" "\
Say whether time value T1 is less than time value T2." nil nil)

(autoload 'days-to-time "time-date" "\
Convert DAYS into a time value." nil nil)

(autoload 'time-since "time-date" "\
Return the time elapsed since TIME.
TIME should be either a time value or a date-time string." nil nil)

(defalias 'subtract-time 'time-subtract)

(autoload 'time-subtract "time-date" "\
Subtract two time values.
Return the difference in the format of a time value." nil nil)

(autoload 'time-add "time-date" "\
Add two time values.  One should represent a time difference." nil nil)

(autoload 'date-to-day "time-date" "\
Return the number of days between year 1 and DATE.
DATE should be a date-time string." nil nil)

(autoload 'days-between "time-date" "\
Return the number of days between DATE1 and DATE2.
DATE1 and DATE2 should be date-time strings." nil nil)

(autoload 'date-leap-year-p "time-date" "\
Return t if YEAR is a leap year." nil nil)

(autoload 'time-to-day-in-year "time-date" "\
Return the day number within the year corresponding to TIME." nil nil)

(autoload 'time-to-days "time-date" "\
The number of days between the Gregorian date 0001-12-31bce and TIME.
TIME should be a time value.
The Gregorian date Sunday, December 31, 1bce is imaginary." nil nil)

(autoload 'safe-date-to-time "time-date" "\
Parse a string that represents a date-time and return a time value.
If DATE is malformed, return a time value of zeros." nil nil)

;;;***

;;;### (autoloads (uudecode-decode-region uudecode-decode-region-internal uudecode-decode-region-external) "uudecode" "lisp/uudecode.el")

(autoload 'uudecode-decode-region-external "uudecode" "\
Uudecode region between START and END using external program.
If FILE-NAME is non-nil, save the result to FILE-NAME.  The program
used is specified by `uudecode-decoder-program'." t nil)

(autoload 'uudecode-decode-region-internal "uudecode" "\
Uudecode region between START and END without using an external program.
If FILE-NAME is non-nil, save the result to FILE-NAME." t nil)

(autoload 'uudecode-decode-region "uudecode" "\
Uudecode region between START and END.
If FILE-NAME is non-nil, save the result to FILE-NAME." nil nil)

;;;***

;;;### (autoloads (yenc-extract-filename yenc-decode-region) "yenc" "lisp/yenc.el")

(autoload 'yenc-decode-region "yenc" "\
Yenc decode region between START and END using an internal decoder." t nil)

(autoload 'yenc-extract-filename "yenc" "\
Extract file name from an yenc header." nil nil)

;;;***

(provide 'gnus-autoloads)
