/* 
 * Copyright (c) 2010, 2012 Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef __UIFORM_H__
#define __UIFORM_H__

#include "base/ui_form.h"
#include "DelegateWrapper.h"

#pragma make_public(::bec::UIForm)
#pragma make_public(::bec::MenuItem)
#pragma make_public(::bec::ToolbarItem)

namespace MySQL {
  namespace Grt {

    public enum class MenuItemType
    {
      MenuAction=        ::bec::MenuAction,
      MenuSeparator=     ::bec::MenuSeparator,
      MenuCascade=       ::bec::MenuCascade,
      MenuCheck=         ::bec::MenuCheck,
      MenuRadio=         ::bec::MenuRadio,

      MenuUnavailable=   ::bec::MenuUnavailable
    };

    public ref class MenuItem
    {
      String^ caption;
      String^ shortcut;
      String^ name;
      MenuItemType type;

      bool enabled;
      bool checked;

      List<MenuItem^>^ subitems;

    public:
      MenuItem(const ::bec::MenuItem& item);

      String^ get_caption();
      String^ get_shortcut();
      String^ get_name();
      MenuItemType get_type();

      bool get_checked();
      void set_checked(bool value);
      
      bool get_enabled();
      void set_enabled(bool value);
      
      List<MenuItem^>^ get_subitems();
    };


    public enum class ToolbarItemType 
    {
      ToolbarAction=        ::bec::ToolbarAction,
      ToolbarSeparator=     ::bec::ToolbarSeparator,
      ToolbarToggle=        ::bec::ToolbarToggle,
      ToolbarLabel=         ::bec::ToolbarLabel,
      ToolbarDropDown=      ::bec::ToolbarDropDown,
      ToolbarRadio=         ::bec::ToolbarRadio,
      ToolbarCheck=         ::bec::ToolbarCheck,
      ToolbarSearch=        ::bec::ToolbarSearch
    };

    public ref class ToolbarItem
    {
      int icon;
      int alt_icon;
      String^ name;
      String^ caption;
      String^ command;
      String^ tooltip;
      ToolbarItemType type;

      bool enabled;
      bool checked;

    public:

      ToolbarItem(const ::bec::ToolbarItem& item)
        : icon(item.icon), alt_icon(item.alt_icon),
        name(CppStringToNative(item.name)),
        caption(CppStringToNative(item.caption)),
        command(CppStringToNative(item.command)),
        tooltip(CppStringToNative(item.tooltip)),
        type((ToolbarItemType)item.type),
        enabled(item.enabled),
        checked(item.checked)
      {}

      int get_icon()
      { return icon; }

      int get_alt_icon()
      { return alt_icon; }

      String^ get_name()
      { return name; }

      String^ get_caption()
      { return caption; }

      String^ get_command()
      { return command; }

      String^ get_tooltip()
      { return tooltip; }

      ToolbarItemType get_type()
      { return type; }

      bool get_checked()
      { return checked; }

      bool get_enabled()
      { return enabled; }
    };


    public ref class UIForm
    {
    protected:
      ::bec::UIForm *inner;
      Runtime::InteropServices::GCHandle m_gch;

      UIForm(::bec::UIForm *inn)
      {
        init(inn);
      }

      UIForm()
        : inner(NULL)
      {
      }

      // Returns a fixed pointer to this object that will not be modified by the GC
      IntPtr GetFixedId()
      {
        if (!m_gch.IsAllocated)
           m_gch = Runtime::InteropServices::GCHandle::Alloc(this);
         return Runtime::InteropServices::GCHandle::ToIntPtr(m_gch);
      }

      // Needs to be called when destroying the object
      void ReleaseHandle()
      {
        if (m_gch.IsAllocated)
          m_gch.Free();
      }

    public:
      virtual ~UIForm()
      { 
        delete inner; 
        inner = NULL;
        ReleaseHandle();
      }

      void init(::bec::UIForm *inn)
      {
        inner = inn;

        if (inner != NULL)
        {
          // get a fixed pointer to this object
          IntPtr ip = this->GetFixedId();

          // set it as the user data
          inner->set_frontend_data((void*)(intptr_t)ip);
        }
      }

      ::bec::UIForm *get_unmanaged_object()
      { return inner; }

        // Returns the object based on the fixed pointer retrieved by GetFixedId()
      static UIForm^ GetFromFixedId( IntPtr ip )
      {
        Runtime::InteropServices::GCHandle gcHandle = Runtime::InteropServices::GCHandle::FromIntPtr( ip );
        return (UIForm^)gcHandle.Target;
      }

      bool can_close()
      {
        return get_unmanaged_object()->can_close();
      } 

      void close()
      {
        get_unmanaged_object()->close();
      }

      String^ get_title()
      {
        return CppStringToNativeRaw(get_unmanaged_object()->get_title());
      }

      String^ form_id()
      {
        return CppStringToNativeRaw(get_unmanaged_object()->form_id());
      }
    };

  } // namespace Forms
} // namespace MySQL

#endif // __UIFORM_H__