/* 
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "Grt.h"
#include "TableEditorBE.h"

namespace MySQL {
namespace Grt {
namespace Db {

TableColumnsListBE::TableColumnsListBE(::bec::TableColumnsListBE *inn)
  : ListModel(inn)
{}

void TableColumnsListBE::reorder_many(List<int> ^rows, int nindex)
{
  std::vector<int> nlist;

  for (int i= 0; i < rows->Count; i++)
    nlist.push_back(rows[i]);

  get_unmanaged_object()->reorder_many(nlist, nindex);
}

bool TableColumnsListBE::get_row(NodeId^ node,
             [Out] String^ %name,
             [Out] String^ %type,
             [Out] bool^ %ispk,
             [Out] bool^ %notnull,
             [Out] bool^ %unique,
             [Out] bool^ %isbinary,
             [Out] bool^ %isunsigned,
             [Out] bool^ %iszerofill,
             [Out] String^ %flags,
             [Out] String^ %defvalue,
             [Out] String^ %charset,
             [Out] String^ %collation,
             [Out] String^ %comment)
{
  std::string name_str= NativeToCppString(name);
  std::string type_str= NativeToCppString(type);
  std::string flags_str= NativeToCppString(flags);
  std::string defvalue_str= NativeToCppString(defvalue);
  std::string charset_str= NativeToCppString(charset);
  std::string collation_str= NativeToCppString(collation);
  std::string comment_str= NativeToCppString(comment);

  bool local_ispk;
  bool local_notnull;
  bool local_unique;
  bool local_isbinary;
  bool local_isunsigned;
  bool local_iszerofill;

  bool retval= get_unmanaged_object()->get_row(*node->get_unmanaged_object(), 
    name_str, 
    type_str, 
    local_ispk, 
    local_notnull, 
    local_unique, 
    local_isbinary,
    local_isunsigned,
    local_iszerofill,
    flags_str, 
    defvalue_str, 
    charset_str, 
    collation_str,
    comment_str);

  *ispk= local_ispk;
  *notnull= local_notnull;
  *unique= local_unique;
  *isbinary= local_isbinary;
  *isunsigned= local_isunsigned;
  *iszerofill= local_iszerofill;

  name= CppStringToNative(name_str);
  type= CppStringToNative(type_str);
  flags= CppStringToNative(flags_str);
  defvalue= CppStringToNative(defvalue_str);
  charset= CppStringToNative(charset_str);
  collation= CppStringToNative(collation_str);
  comment= CppStringToNative(comment_str);

  return retval;
}

IndexColumnsListBE::IndexColumnsListBE(IndexListBE^ owner)
  : ListModel(new ::bec::IndexColumnsListBE(owner->get_unmanaged_object()))
{}

IndexColumnsListBE::IndexColumnsListBE(::bec::IndexColumnsListBE *inn)
  : ListModel(inn)
{}

void IndexColumnsListBE::set_column_enabled(NodeId^ node, bool flag)
{
 get_unmanaged_object()->set_column_enabled(*node->get_unmanaged_object(), flag); 
}

bool IndexColumnsListBE::get_column_enabled(NodeId^ node)
{
  return get_unmanaged_object()->get_column_enabled(*node->get_unmanaged_object()); 
}

int IndexColumnsListBE::get_max_order_index()
{
  return get_unmanaged_object()->get_max_order_index();
}


IndexListBE::IndexListBE(TableEditorBE^ owner)
  : ListModel(new ::bec::IndexListBE(owner->get_unmanaged_object()))
{}

IndexListBE::IndexListBE(::bec::IndexListBE *inn)
  : ListModel(inn)
{}
  
IndexColumnsListBE^ IndexListBE::get_columns() 
{ return gcnew IndexColumnsListBE(get_unmanaged_object()->get_columns()); }

void IndexListBE::select_index(NodeId^ node)
{ get_unmanaged_object()->select_index(*node->get_unmanaged_object()); }

FKConstraintColumnsListBE::FKConstraintColumnsListBE(FKConstraintListBE^ owner)
  : ListModel(new ::bec::FKConstraintColumnsListBE(owner->get_unmanaged_object()))
{}

FKConstraintColumnsListBE::FKConstraintColumnsListBE(::bec::FKConstraintColumnsListBE *inn)
  : ListModel(inn)
{}

List<String^>^ FKConstraintColumnsListBE::get_ref_columns_list(NodeId^ node)
{
  return CppStringListToNative(
    static_cast<::bec::FKConstraintColumnsListBE *>(inner)->get_ref_columns_list(*node->get_unmanaged_object()));
}

bool FKConstraintColumnsListBE::set_column_is_fk(NodeId^ node, bool flag)
{
  return get_unmanaged_object()->set_column_is_fk(*node->get_unmanaged_object(), flag); 
}

bool FKConstraintColumnsListBE::get_column_is_fk(NodeId^ node)
{
  return get_unmanaged_object()->get_column_is_fk(*node->get_unmanaged_object()); 
}

FKConstraintListBE::FKConstraintListBE(TableEditorBE^ owner)
  : ListModel(new ::bec::FKConstraintListBE(owner->get_unmanaged_object()))
{}

FKConstraintListBE::FKConstraintListBE(::bec::FKConstraintListBE *inn)
  : ListModel(inn)
{}

/*
NodeId^ FKConstraintListBE::add_column(String^ column_name)
{ return gcnew NodeId(&get_unmanaged_object()->add_column(NativeToCppString(column_name))); }*/

void FKConstraintListBE::select_fk(NodeId^ node)
{ get_unmanaged_object()->select_fk(*node->get_unmanaged_object()); }


FKConstraintColumnsListBE^ FKConstraintListBE::get_columns()
{ return gcnew FKConstraintColumnsListBE(get_unmanaged_object()->get_columns()); }



IndexListBE^ TableEditorBE::get_indexes() 
{ return gcnew IndexListBE(get_unmanaged_object()->get_indexes()); }

FKConstraintListBE^ TableEditorBE::get_fks() 
{ return gcnew FKConstraintListBE(get_unmanaged_object()->get_fks()); }


// table options
//...

// column editing
NodeId^ TableEditorBE::add_column(String^ name)
{ return gcnew NodeId(&get_unmanaged_object()->add_column(NativeToCppString(name))); }

void TableEditorBE::remove_column(NodeId^ node)
{ get_unmanaged_object()->remove_column(*node->get_unmanaged_object()); }

//db_Column get_column_with_name(const std::string &name);

// fk editing
NodeId^ TableEditorBE::add_fk(String^ name)
{
  return gcnew NodeId(&get_unmanaged_object()->add_fk(NativeToCppString(name)));
}

void TableEditorBE::remove_fk(NodeId^ node)
{ get_unmanaged_object()->remove_fk(*node->get_unmanaged_object()); }

NodeId^ TableEditorBE::add_fk_with_columns(List<NodeId ^> ^columns)
{
  std::vector<::bec::NodeId> node_vec= ObjectListToCppVector<NodeId, ::bec::NodeId>(columns);
  return gcnew NodeId(&get_unmanaged_object()->add_fk_with_columns(node_vec));
}

// index editing
NodeId^ TableEditorBE::add_index(String^ name)
{ return gcnew NodeId(&get_unmanaged_object()->add_index(NativeToCppString(name))); }

void TableEditorBE::remove_index(NodeId^ node)
{ get_unmanaged_object()->remove_index(*node->get_unmanaged_object()); }

NodeId^ TableEditorBE::add_index_with_columns(List<NodeId ^> ^columns)
{
  std::vector<::bec::NodeId> node_vec= ObjectListToCppVector<NodeId, ::bec::NodeId>(columns);
  return gcnew NodeId(&get_unmanaged_object()->add_index_with_columns(node_vec));
}

List<String^>^ TableEditorBE::get_index_types()
{  
  return CppStringListToNative(
    static_cast<::bec::TableEditorBE *>(inner)->get_index_types());
}


} // namespace Db
} // namespace Grt
} // namespace MySQL
