/* 
 * Copyright (c) 2008, 2011, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#include "stdafx.h"

#include "Grt.h"
#include "grtdb/db_object_helpers.h"

#include "SchemaEditorWrapper.h"

using namespace MySQL::Grt::Db;

//--------------------------------------------------------------------------------------------------

SchemaEditorWrapper::SchemaEditorWrapper(::bec::SchemaEditorBE *inn)
  : DBObjectEditorBE(inn)
{
}

//--------------------------------------------------------------------------------------------------

SchemaEditorWrapper::SchemaEditorWrapper(MySQL::Grt::GrtManager^ grtm, MySQL::Grt::GrtValue^ args)
  : DBObjectEditorBE(
    new bec::SchemaEditorBE(grtm->get_unmanaged_object(), 
    db_SchemaRef::cast_from(grt::BaseListRef::cast_from(args->get_unmanaged_object()).get(0)), 
    get_rdbms_for_db_object(grt::BaseListRef::cast_from(args->get_unmanaged_object()).get(0)))
    )
{
}

//--------------------------------------------------------------------------------------------------

::bec::SchemaEditorBE* SchemaEditorWrapper::get_unmanaged_object()
{
  return static_cast<::bec::SchemaEditorBE *>(inner);
}

//--------------------------------------------------------------------------------------------------

void SchemaEditorWrapper::set_schema_option_by_name(System::String^ name, System::String^ value)
{
  get_unmanaged_object()->set_schema_option_by_name(NativeToCppString(name), NativeToCppString(value));
}

//--------------------------------------------------------------------------------------------------

String^ SchemaEditorWrapper::get_schema_option_by_name(String^ name)
{
  return CppStringToNative(get_unmanaged_object()->get_schema_option_by_name(NativeToCppString(name)));
}

//--------------------------------------------------------------------------------------------------

