/* 
 * Copyright (c) 2008, 2012, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */
#ifndef _STUB_VIEW_H_
#define _STUB_VIEW_H_

#include "stub_base.h"

namespace mforms { namespace stub {

class ViewImpl : public ObjectImpl
{
protected:
  ViewImpl(::mforms::View *view);
  static void __stdcall show(::mforms::View *self, bool show);
  static bool __stdcall is_shown(::mforms::View *self);
  static void __stdcall set_tooltip(::mforms::View *self, const std::string &text);
  static int __stdcall get_width(::mforms::View *self);
  static int __stdcall get_height(::mforms::View *self);
  static int __stdcall get_preferred_width(::mforms::View *self);
  virtual int get_preferred_width();
  static int __stdcall get_preferred_height(::mforms::View *self);
  virtual int get_preferred_height();
  static int __stdcall get_x(::mforms::View *self);
  static int __stdcall get_y(::mforms::View *self);
  static void __stdcall set_size(::mforms::View *self, int w, int h);
  virtual void set_size(int width, int height);
  static void __stdcall set_position(::mforms::View *self, int x, int y);
  static void __stdcall set_enabled(::mforms::View *self, bool flag);
  static void __stdcall set_name(::mforms::View *view, const std::string &name);
  static void __stdcall relayout(::mforms::View *view);
  static void __stdcall set_needs_repaint(::mforms::View *view);
  void size_changed();
  void setup();
  virtual void move_child(ViewImpl *child, int x, int y);
  static void __stdcall set_front_color(::mforms::View *self, const std::string &color);
  static void __stdcall set_back_color(::mforms::View *self, const std::string &color);
  static void __stdcall set_back_image(::mforms::View *self, const std::string &path, mforms::Alignment layout);
  static void __stdcall destroy(View *self);
  static void __stdcall set_padding(View *self, int, int, int, int);
  static void __stdcall client_to_screen(View *self, int&, int&);
public:
  static void init();
};

};
};

#endif
