system_vars_list =[ { 'description': 'The name of the group.',
    'dynamic': True,
    'name': 'group_replication_group_name'},
  { 'description': 'Whether the server should start Group Replication or not during server start.',
    'dynamic': True,
    'name': 'group_replication_start_on_boot'},
  { 'description': 'The local address in host:port formatted string.',
    'dynamic': True,
    'name': 'group_replication_local_address'},
  { 'description': 'A list of peer addresses, comma separated list such as host1:port1,host2:port2.',
    'dynamic': True,
    'name': 'group_replication_group_seeds'},
  { 'description': 'A comma separated list of peer addresses, such as host1:port1,host2:port2.',
    'dynamic': True,
    'name': 'group_replication_force_members'},
  { 'description': 'Configure this server to bootstrap the group.',
    'dynamic': True,
    'name': 'group_replication_bootstrap_group'},
  { 'description': 'The number of times the group communication thread waits',
    'dynamic': True,
    'name': 'group_replication_poll_spin_loops'},
  { 'description': 'The number of times that a joining member tries to connect to the available donors before giving up.',
    'dynamic': True,
    'name': 'group_replication_recovery_retry_count'},
  { 'description': 'The sleep time, in seconds, between reconnection attempts when no donor was found in the group.',
    'dynamic': True,
    'name': 'group_replication_recovery_reconnect_interval'},
  { 'description': 'Whether Group Replication recovery connection should use SSL or not.',
    'dynamic': True,
    'name': 'group_replication_recovery_use_ssl'},
  { 'description': 'The path to a file that contains a list of trusted SSL certificate authorities.',
    'dynamic': True,
    'name': 'group_replication_recovery_ssl_ca'},
  { 'description': 'The path to a directory that contains trusted SSL certificate authority certificates.',
    'dynamic': True,
    'name': 'group_replication_recovery_ssl_capath'},
  { 'description': 'The name of the SSL certificate file to use for establishing a secure connection.',
    'dynamic': True,
    'name': 'group_replication_recovery_ssl_cert'},
  { 'description': 'The name of the SSL key file to use for establishing a secure connection.',
    'dynamic': True,
    'name': 'group_replication_recovery_ssl_key'},
  { 'description': 'The path to a directory that contains files containing certificate revocation lists.',
    'dynamic': True,
    'name': 'group_replication_recovery_ssl_crl'},
  { 'description': 'The path to a directory that contains files containing certificate revocation lists.',
    'dynamic': True,
    'name': 'group_replication_recovery_ssl_crlpath'},
  { 'description': "Make the recovery process check the server's Common Name value in the donor sent certificate.",
    'dynamic': True,
    'name': 'group_replication_recovery_ssl_verify_server_cert'},
  { 'description': 'Recovery policies when handling cached transactions after state transfer. This option specifies whether a member is marked online after it has received all transactions that it missed before it joined the group (TRANSACTIONS_CERTIFIED) or after it has received and applied them (TRANSACTIONS_APPLIED).',
    'dynamic': True,
    'name': 'group_replication_recovery_complete_at'},
  { 'description': 'Timeout, in seconds, that the plugin waits for each of the components when shutting down.',
    'dynamic': True,
    'name': 'group_replication_components_stop_timeout'},
  { 'description': 'Allow the current server to join the group even if it has a lower plugin version than the group.',
    'dynamic': True,
    'name': 'group_replication_allow_local_lower_version_join'},
  { 'description': 'Allow the current server to join the group even if it has transactions not present in the group.',
    'dynamic': True,
    'name': 'group_replication_allow_local_disjoint_gtids_join'},
  { 'description': 'Determines the interval between successive column values for transactions that execute on this server.',
    'dynamic': True,
    'name': 'group_replication_auto_increment_increment'},
  { 'description': 'The value in bytes above which (LZ4) compression is enforced. When set to zero, deactivates compression.',
    'dynamic': True,
    'name': 'group_replication_compression_threshold'},
  { 'description': 'The number of consecutive GTIDs that are reserved for each member. Each member consumes its blocks and reserve more when needed.',
    'dynamic': True,
    'name': 'group_replication_gtid_assignment_block_size'},
  { 'description': 'Specifies the security state of the connection between Group Replication members.',
    'dynamic': True,
    'name': 'group_replication_ssl_mode'},
  { 'description': 'Instructs the group to use a single server for the read/write workload.',
    'dynamic': True,
    'name': 'group_replication_single_primary_mode'},
  { 'description': 'Enable or disable strict consistency checks for multi-master update everywhere.',
    'dynamic': True,
    'name': 'group_replication_enforce_update_everywhere_checks'},
  { 'description': 'Specifies the mode used for flow control.',
    'dynamic': True,
    'name': 'group_replication_flow_control_mode'},
  { 'description': 'Specifies the number of waiting transactions in the certifier queue that trigger flow control.',
    'dynamic': True,
    'name': 'group_replication_flow_control_certifier_threshold'},
  { 'description': 'Specifies the number of waiting transactions in the applier queue that trigger flow control.',
    'dynamic': True,
    'name': 'group_replication_flow_control_applier_threshold'},
  { 'description': 'The list of hosts permitted to connect to the group.',
    'dynamic': True,
    'name': 'group_replication_ip_whitelist'},
  { 'description': 'Port on which the X Plugin accepts connections',
    'dynamic': False,
    'name': 'mysqlx_port'},
  { 'description': 'Maximum number of concurrent client connections the can accept',
    'dynamic': True,
    'name': 'mysqlx_max_connections'},
  { 'description': 'Maximum permitted waiting time in seconds for a connection to set up a session',
    'dynamic': True,
    'name': 'mysqlx_connect_timeout'},
  { 'description': 'Enabled when using SSL with',
    'dynamic': False,
    'name': 'mysqlx_ssl'},
  { 'description': 'Path to X509 key in PEM format.',
    'dynamic': False,
    'name': 'mysqlx_ssl_key'},
  { 'description': 'Path to SSL CA file in PEM format',
    'dynamic': False,
    'name': 'mysqlx_ssl_ca'},
  { 'description': 'SSL CA file directory',
    'dynamic': False,
    'name': 'mysqlx_ssl_capath'},
  { 'description': 'Path to X509 certficate in PEM format',
    'dynamic': False,
    'name': 'mysqlx_ssl_cert'},
  { 'description': 'Certificate revocation list',
    'dynamic': False,
    'name': 'mysqlx_ssl_crl'},
  { 'description': 'Certificate revocation list path',
    'dynamic': False,
    'name': 'mysqlx_ssl_crlpath'},
  { 'description': 'The size of the audit log buffer',
    'dynamic': False,
    'name': 'audit_log_buffer_size'},
  { 'description': 'Audit logging policy for connection-related events',
    'dynamic': True,
    'name': 'audit_log_connection_policy'},
  { 'description': 'Whether to audit current session',
    'dynamic': False,
    'name': 'audit_log_current_session'},
  { 'description': 'Accounts not to audit',
    'dynamic': True,
    'name': 'audit_log_exclude_accounts'},
  { 'description': 'The name of the audit log file',
    'dynamic': False,
    'name': 'audit_log_file'},
  { 'description': 'ID of current audit log filter',
    'dynamic': False,
    'name': 'audit_log_filter_id'},
  { 'description': 'Close and reopen the audit log file',
    'dynamic': True,
    'name': 'audit_log_flush'},
  { 'description': 'The audit log file format',
    'dynamic': False,
    'name': 'audit_log_format'},
  { 'description': 'Accounts to audit',
    'dynamic': True,
    'name': 'audit_log_include_accounts'},
  { 'description': 'Audit logging policy',
    'dynamic': True,
    'name': 'audit_log_policy'},
  { 'description': 'Close and reopen the audit log file at a certain size',
    'dynamic': True,
    'name': 'audit_log_rotate_on_size'},
  { 'description': 'Audit logging policy for statement-related events',
    'dynamic': True,
    'name': 'audit_log_statement_policy'},
  { 'description': 'The audit logging strategy',
    'dynamic': False,
    'name': 'audit_log_strategy'},
  { 'description': 'Whether to autogenerate SSL key and certificate files',
    'dynamic': False,
    'name': 'auto_generate_certs'},
  { 'description': 'AUTO_INCREMENT columns are incremented by this value',
    'dynamic': True,
    'name': 'auto_increment_increment'},
  { 'description': 'Offset added to AUTO_INCREMENT columns',
    'dynamic': True,
    'name': 'auto_increment_offset'},
  { 'description': 'Sets the autocommit mode',
    'dynamic': True,
    'name': 'autocommit'},
  { 'description': 'Creating and dropping stored procedures alters ACLs',
    'dynamic': True,
    'name': 'automatic_sp_privileges'},
  { 'description': 'Whether ALTER TABLE should upgrade pre-5.6.4 temporal columns',
    'dynamic': True,
    'name': 'avoid_temporal_upgrade'},
  { 'description': 'Number of outstanding connection requests MySQL can have',
    'dynamic': False,
    'name': 'back_log'},
  { 'description': 'Enable or disable BACKUP DATABASE privilege elevation',
    'dynamic': False,
    'name': 'backup_elevation'},
  { 'description': 'Enable or disable MySQL Backup history log',
    'dynamic': True,
    'name': 'backup_history_log'},
  { 'description': 'Name of the MySQL Backup history log file',
    'dynamic': True,
    'name': 'backup_history_log_file'},
  { 'description': 'Enable or disable MySQL Backup progress log',
    'dynamic': True,
    'name': 'backup_progress_log'},
  { 'description': 'Name of the MySQL Backup progress log file',
    'dynamic': True,
    'name': 'backup_progress_log_file'},
  { 'description': 'Number of seconds DDL statements wait for BACKUP DATABASE or RESTORE before aborting',
    'dynamic': True,
    'name': 'backup_wait_timeout'},
  { 'description': 'Default backup image file directory',
    'dynamic': True,
    'name': 'backupdir'},
  { 'description': 'Path of installation directory',
    'dynamic': False,
    'name': 'basedir'},
  { 'description': 'bdb-data-direct',
    'dynamic': False,
    'name': 'bdb-data-direct'},
  { 'description': 'Berkeley DB home directory',
    'dynamic': False,
    'name': 'bdb-home'},
  { 'description': 'Berkeley DB lock detect',
    'dynamic': False,
    'name': 'bdb-lock-detect'},
  { 'description': 'bdb-log-direct',
    'dynamic': False,
    'name': 'bdb-log-direct'},
  { 'description': 'Berkeley DB log file directory',
    'dynamic': False,
    'name': 'bdb-logdir'},
  { 'description': 'Start Berkeley DB in multi-process mode',
    'dynamic': False,
    'name': 'bdb-shared-data'},
  { 'description': 'Berkeley DB tempfile name',
    'dynamic': False,
    'name': 'bdb-tmpdir'},
  { 'description': 'The buffer that is allocated to cache index and rows for BDB tables',
    'dynamic': False,
    'name': 'bdb_cache_size'},
  { 'description': 'The buffer that is allocated to cache index and rows for BDB tables',
    'dynamic': False,
    'name': 'bdb_log_buffer_size'},
  { 'description': 'The maximum number of locks that can be active for a BDB table',
    'dynamic': False,
    'name': 'bdb_max_lock'},
  { 'description': 'Allow big result sets by saving all temporary sets on file',
    'dynamic': True,
    'name': 'big-tables'},
  { 'description': 'IP address or host name to bind to',
    'dynamic': False,
    'name': 'bind-address'},
  { 'description': 'Specifies the format of the binary log',
    'dynamic': True,
    'name': 'binlog-format'},
  { 'description': 'Size of the cache to hold the SQL statements for the binary log during a transaction',
    'dynamic': True,
    'name': 'binlog_cache_size'},
  { 'description': 'Enable/disable binary log checksums',
    'dynamic': True,
    'name': 'binlog_checksum'},
  { 'description': 'Causes updates using statement format to nontransactional engines to be written directly to binary log. See documentation before using.',
    'dynamic': True,
    'name': 'binlog_direct_non_transactional_updates'},
  { 'description': 'Controls what happens when the server cannot write to the binary log.',
    'dynamic': True,
    'name': 'binlog_error_action'},
  { 'description': 'Sets the number of microseconds to wait before synchronizing transactions to disk.',
    'dynamic': True,
    'name': 'binlog_group_commit_sync_delay'},
  { 'description': 'Sets the maximum number of transactions to wait for before aborting the current delay specified by binlog_group_commit_sync_delay.',
    'dynamic': True,
    'name': 'binlog_group_commit_sync_no_delay_count'},
  { 'description': 'Controls how binary logs are iterated during GTID recovery',
    'dynamic': False,
    'name': 'binlog_gtid_simple_recovery'},
  { 'description': 'How long to read transactions before flushing to binary log',
    'dynamic': True,
    'name': 'binlog_max_flush_queue_time'},
  { 'description': 'Whether to commit in same order as writes to binary log',
    'dynamic': True,
    'name': 'binlog_order_commits'},
  { 'description': 'Use full or minimal images when logging row changes. Allowed values are full, minimal, and noblob.',
    'dynamic': True,
    'name': 'binlog_row_image'},
  { 'description': 'When TRUE, enables logging of rows query log events in row-based logging mode. FALSE by default. Do not enable when producing logs for pre-5.6.2 replication slaves or other readers.',
    'dynamic': True,
    'name': 'binlog_rows_query_log_events'},
  { 'description': 'Size of the cache to hold nontransactional statements for the binary log during a transaction',
    'dynamic': True,
    'name': 'binlog_stmt_cache_size'},
  { 'description': 'Deprecated and will be removed in a future version. Use the renamed binlog_error_action instead.',
    'dynamic': True,
    'name': 'binlogging_impossible_mode'},
  { 'description': 'Mode for block-based encryption algorithms',
    'dynamic': True,
    'name': 'block_encryption_mode'},
  { 'description': 'Size of tree cache used in bulk insert optimization',
    'dynamic': True,
    'name': 'bulk_insert_buffer_size'},
  { 'description': 'Set the file system character set',
    'dynamic': True,
    'name': 'character-set-filesystem'},
  { 'description': 'Specify default character set',
    'dynamic': True,
    'name': 'character-set-server'},
  { 'description': 'Directory where character sets are installed',
    'dynamic': False,
    'name': 'character-sets-dir'},
  { 'description': 'The default character set',
    'dynamic': False,
    'name': 'character_set'},
  { 'description': 'Current client character set',
    'dynamic': True,
    'name': 'character_set_client'},
  { 'description': 'Current connection character set',
    'dynamic': True,
    'name': 'character_set_connection'},
  { 'description': 'The character set used by the default database',
    'dynamic': True,
    'name': 'character_set_database'},
  { 'description': 'Current result character set',
    'dynamic': True,
    'name': 'character_set_results'},
  { 'description': 'The character set used by the server for storing identifiers',
    'dynamic': False,
    'name': 'character_set_system'},
  { 'description': 'Whether built-in authentication plugins do proxying',
    'dynamic': True,
    'name': 'check_proxy_users'},
  { 'description': 'Specify default collation',
    'dynamic': True,
    'name': 'collation-server'},
  { 'description': 'The collation of the connection',
    'dynamic': True,
    'name': 'collation_connection'},
  { 'description': 'The collation used by the default database',
    'dynamic': True,
    'name': 'collation_database'},
  { 'description': 'Default completion type',
    'dynamic': True,
    'name': 'completion_type'},
  { 'description': 'Use concurrent insert with MyISAM',
    'dynamic': True,
    'name': 'concurrent_insert'},
  { 'description': 'Consecutive failed connection attempts before delays occur',
    'dynamic': True,
    'name': 'connection_control_failed_connections_threshold'},
  { 'description': 'Maximum delay (milliseconds) for server response to failed connection attempts',
    'dynamic': True,
    'name': 'connection_control_max_connection_delay'},
  { 'description': 'Minimum delay (milliseconds) for server response to failed connection attempts',
    'dynamic': True,
    'name': 'connection_control_min_connection_delay'},
  { 'description': "Number of seconds the mysqld server waits for a connect packet before responding with 'Bad handshake'",
    'dynamic': True,
    'name': 'connect_timeout'},
  { 'description': 'Write core file on server crashes',
    'dynamic': False,
    'name': 'core_file'},
  { 'description': 'Use pre-5.6.4 storage format for temporal types when creating tables. Intended for use in replication and upgrades/downgrades between NDB 7.2 and NDB 7.3/7.4.',
    'dynamic': False,
    'name': 'create_old_temporals'},
  { 'description': '',
    'dynamic': False,
    'name': 'daemon_memcached_enable_binlog'},
  { 'description': 'Specifies the shared library that implements the InnoDB memcached plugin',
    'dynamic': False,
    'name': 'daemon_memcached_engine_lib_name'},
  { 'description': 'Path of directory that contains the shared library that implements the InnoDB memcached plugin',
    'dynamic': False,
    'name': 'daemon_memcached_engine_lib_path'},
  { 'description': 'Space-separated options that are passed to the underlying memcached daemon on startup',
    'dynamic': False,
    'name': 'daemon_memcached_option'},
  { 'description': 'Specifies how many memcached read operations to perform before doing a COMMIT to start a new transaction',
    'dynamic': False,
    'name': 'daemon_memcached_r_batch_size'},
  { 'description': 'Specifies how many memcached write operations to perform before doing a COMMIT to start a new transaction',
    'dynamic': False,
    'name': 'daemon_memcached_w_batch_size'},
  { 'description': 'Path of data directory',
    'dynamic': False,
    'name': 'datadir'},
  { 'description': 'The DATE format (unused)',
    'dynamic': False,
    'name': 'date_format'},
  { 'description': 'The DATETIME/TIMESTAMP format (unused)',
    'dynamic': False,
    'name': 'datetime_format'},
  { 'description': 'Output debug log; supported only if MySQL was built with debugging support',
    'dynamic': True,
    'name': 'debug'},
  { 'description': 'Interface to Debug Sync facility',
    'dynamic': True,
    'name': 'debug_sync'},
  { 'description': 'The default storage engine (table type) for tables',
    'dynamic': True,
    'name': 'default-storage-engine'},
  { 'description': 'The default authentication plugin',
    'dynamic': False,
    'name': 'default_authentication_plugin'},
  { 'description': 'Age in days when passwords effectively expire',
    'dynamic': True,
    'name': 'default_password_lifetime'},
  { 'description': 'The default storage engine (table type) for TEMPORARY tables',
    'dynamic': True,
    'name': 'default_tmp_storage_engine'},
  { 'description': 'The default week format used by WEEK() functions',
    'dynamic': True,
    'name': 'default_week_format'},
  { 'description': 'Type of DELAY_KEY_WRITE',
    'dynamic': True,
    'name': 'delay-key-write'},
  { 'description': 'After inserting delayed_insert_limit rows, the INSERT DELAYED handler will check if there are any SELECT statements pending. If so, it allows these to execute before continuing',
    'dynamic': True,
    'name': 'delayed_insert_limit'},
  { 'description': 'How many seconds an INSERT DELAYED thread should wait for INSERT statements before terminating',
    'dynamic': True,
    'name': 'delayed_insert_timeout'},
  { 'description': 'What size queue (in rows) should be allocated for handling INSERT DELAYED',
    'dynamic': True,
    'name': 'delayed_queue_size'},
  { 'description': 'Obsolete: Replaced by --enforce-gtid-consistency in MySQL 5.6.9.',
    'dynamic': False,
    'name': 'disable-gtid-unsafe-statements'},
  { 'description': 'Obsolete: Replaced by enforce_gtid_consistency in MySQL 5.6.9.',
    'dynamic': False,
    'name': 'disable_gtid_unsafe_statements'},
  { 'description': 'Storage engines that cannot be used to create tables',
    'dynamic': False,
    'name': 'disabled_storage_engines'},
  { 'description': 'Whether the server disconnects clients with expired passwords if clients cannot handle such accounts',
    'dynamic': False,
    'name': 'disconnect_on_expired_password'},
  { 'description': "Scale of the result of '/' operator will be increased by this many digits",
    'dynamic': True,
    'name': 'div_precision_increment'},
  { 'description': 'Whether optimizer JSON output should add end markers',
    'dynamic': True,
    'name': 'end_markers_in_json'},
  { 'description': 'Prevents execution of statements that cannot be logged in a transactionally safe manner',
    'dynamic': False,
    'name': 'enforce-gtid-consistency'},
  { 'description': 'Prevents execution of statements that cannot be logged in a transactionally safe manner',
    'dynamic': False,
    'name': 'enforce_gtid_consistency'},
  { 'description': 'Push supported query conditions to the storage engine',
    'dynamic': True,
    'name': 'engine-condition-pushdown'},
  { 'description': 'The cutoff for switching from index dives to index statistics',
    'dynamic': True,
    'name': 'eq_range_index_dive_limit'},
  { 'description': 'Number of errors', 'dynamic': False, 'name': 'error_count'},
  { 'description': 'Enable/disable and start/stop the event scheduler. Note that this variable underwent significant changes in behavior and permitted values in MySQL 5.1.11 and 5.1.12',
    'dynamic': True,
    'name': 'event-scheduler'},
  { 'description': 'Deprecated and will be removed in a future version. Use the renamed gtid_executed_compression_period instead.',
    'dynamic': True,
    'name': 'executed_gtids_compression_period'},
  { 'description': 'If nonzero, binary logs will be purged after expire_logs_days days; possible purges happen at startup and at binary log rotation',
    'dynamic': True,
    'name': 'expire_logs_days'},
  { 'description': 'Whether TIMESTAMP columns are nullable and have DEFAULT NULL',
    'dynamic': False,
    'name': 'explicit_defaults_for_timestamp'},
  { 'description': 'The external proxy user',
    'dynamic': False,
    'name': 'external_user'},
  { 'description': 'Sets the frequency that in-memory structures are synchronized to disk',
    'dynamic': True,
    'name': 'falcon_checkpoint_schedule'},
  { 'description': 'Enable Falcon checksum validation',
    'dynamic': True,
    'name': 'falcon_checksums'},
  { 'description': 'Sets the repeatable read isolation mode',
    'dynamic': True,
    'name': 'falcon_consistent_read'},
  { 'description': 'Sets the log information written to the standard output by the Falcon engine in the event of an error',
    'dynamic': True,
    'name': 'falcon_debug_mask'},
  { 'description': 'Specifies whether the debug server should be enabled.',
    'dynamic': False,
    'name': 'falcon_debug_server'},
  { 'description': 'Disables the periodic fsync operation.',
    'dynamic': True,
    'name': 'falcon_disable_fsync'},
  { 'description': 'Sets the number of gopher threads',
    'dynamic': False,
    'name': 'falcon_gopher_threads'},
  { 'description': 'Number of megabytes of pending index data that should be stored until the data is flushed to the serial log',
    'dynamic': True,
    'name': 'falcon_index_chill_threshold'},
  { 'description': 'Initial size of a Falcon tablespace file when created',
    'dynamic': True,
    'name': 'falcon_initial_allocation'},
  { 'description': 'Number of asynchronous I/O threads',
    'dynamic': True,
    'name': 'falcon_io_threads'},
  { 'description': 'Blobs smaller than this value are stored in data pages not blob pages',
    'dynamic': False,
    'name': 'falcon_large_blob_threshold'},
  { 'description': 'Number of seconds Falcon will force one transaction to wait on another',
    'dynamic': True,
    'name': 'falcon_lock_wait_timeout'},
  { 'description': 'falcon_max_transaction_backlog',
    'dynamic': True,
    'name': 'falcon_max_transaction_backlog'},
  { 'description': 'Size of the memory cache (in bytes) for pages from the tablespace file',
    'dynamic': False,
    'name': 'falcon_page_cache_size'},
  { 'description': 'Size of the pages (in bytes) used to store information within the tablespace',
    'dynamic': False,
    'name': 'falcon_page_size'},
  { 'description': 'Number of megabytes of pending record data stored before flushing the records to the serial log',
    'dynamic': True,
    'name': 'falcon_record_chill_threshold'},
  { 'description': 'Maximum amount of memory (in bytes) that will be allocated for caching record data',
    'dynamic': True,
    'name': 'falcon_record_memory_max'},
  { 'description': 'Percentage of falcon_record_scavenge_threshold that will be retained in the record cache after a scavenge',
    'dynamic': True,
    'name': 'falcon_record_scavenge_floor'},
  { 'description': 'Percentage of falcon_record_memory_max that will cause the scavenger thread to start removing old generations of records from the record cache',
    'dynamic': True,
    'name': 'falcon_record_scavenge_threshold'},
  { 'description': 'Record scavenging threshold',
    'dynamic': False,
    'name': 'falcon_scavenge_schedule'},
  { 'description': 'Memory windows (1MB each) allocated for the Falcon serial log',
    'dynamic': False,
    'name': 'falcon_serial_log_buffers'},
  { 'description': 'Location for the Falcon serial log files',
    'dynamic': False,
    'name': 'falcon_serial_log_dir'},
  { 'description': 'Set the priority for writing the Falcon serial log',
    'dynamic': True,
    'name': 'falcon_serial_log_priority'},
  { 'description': 'Enables two-phase commit for Falcon tables',
    'dynamic': False,
    'name': 'falcon_support_xa'},
  { 'description': 'Use a deferred index hash lookup',
    'dynamic': False,
    'name': 'falcon_use_deferred_index_hash'},
  { 'description': 'Use the sector cache for reading blocks from disk',
    'dynamic': False,
    'name': 'falcon_use_sectorcache'},
  { 'description': 'Use index supernodes',
    'dynamic': False,
    'name': 'falcon_use_supernodes'},
  { 'description': 'Flush tables to disk between SQL statements',
    'dynamic': True,
    'name': 'flush'},
  { 'description': 'A dedicated thread is created to flush all tables at the given interval',
    'dynamic': True,
    'name': 'flush_time'},
  { 'description': 'If set to 1 (the default), foreign key constraints for InnoDB tables are checked.',
    'dynamic': True,
    'name': 'foreign_key_checks'},
  { 'description': 'List of operators for MATCH ... AGAINST ( ... IN BOOLEAN MODE)',
    'dynamic': True,
    'name': 'ft_boolean_syntax'},
  { 'description': 'The maximum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable',
    'dynamic': False,
    'name': 'ft_max_word_len'},
  { 'description': 'The minimum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable',
    'dynamic': False,
    'name': 'ft_min_word_len'},
  { 'description': 'Number of best matches to use for query expansion',
    'dynamic': False,
    'name': 'ft_query_expansion_limit'},
  { 'description': 'Use stopwords from this file instead of built-in list',
    'dynamic': False,
    'name': 'ft_stopword_file'},
  { 'description': 'Enable|disable general log',
    'dynamic': True,
    'name': 'general-log'},
  { 'description': 'Name of the general query log file',
    'dynamic': True,
    'name': 'general_log_file'},
  { 'description': 'The maximum length of the result of function group_concat',
    'dynamic': True,
    'name': 'group_concat_max_len'},
  { 'description': 'Controls whether GTID based logging is enabled and what type of transactions the logs can contain',
    'dynamic': False,
    'name': 'gtid-mode'},
  { 'description': 'Obsolete: Replaced by gtid_executed in MySQL 5.6.9.',
    'dynamic': False,
    'name': 'gtid_done'},
  { 'description': 'Global: All GTIDs in the binary log (global) or current transaction (session). Read-only.',
    'dynamic': False,
    'name': 'gtid_executed'},
  { 'description': 'Compress gtid_executed table each time this many transactions have occurred. 0 means never compress this table. Applies only when binary logging is disabled.',
    'dynamic': True,
    'name': 'gtid_executed_compression_period'},
  { 'description': 'Obsolete: Replaced by gtid_purged in MySQL 5.6.9.',
    'dynamic': False,
    'name': 'gtid_lost'},
  { 'description': 'Controls whether GTID based logging is enabled and what type of transactions the logs can contain',
    'dynamic': False,
    'name': 'gtid_mode'},
  { 'description': 'Specifies the GTID for the next statement to execute. See documentation for details.',
    'dynamic': True,
    'name': 'gtid_next'},
  { 'description': 'The set of GTIDs owned by this client (session), or by all clients, together with the thread ID of the owner (global). Read-only.',
    'dynamic': False,
    'name': 'gtid_owned'},
  { 'description': 'The set of all GTIDs that have been purged from the binary log.',
    'dynamic': True,
    'name': 'gtid_purged'},
  { 'description': 'Whether mysqld supports archive tables',
    'dynamic': False,
    'name': 'have_archive'},
  { 'description': 'Is Berkeley DB supported',
    'dynamic': False,
    'name': 'have_bdb'},
  { 'description': 'Whether mysqld supports BLACKHOLE tables',
    'dynamic': False,
    'name': 'have_blackhole_engine'},
  { 'description': 'Whether statement profiling capability is available',
    'dynamic': False,
    'name': 'have_community_features'},
  { 'description': 'Availability of the zlib compression library',
    'dynamic': False,
    'name': 'have_compress'},
  { 'description': 'Availability of the crypt() system call',
    'dynamic': False,
    'name': 'have_crypt'},
  { 'description': 'Whether mysqld supports csv tables',
    'dynamic': False,
    'name': 'have_csv'},
  { 'description': 'Whether mysqld supports dynamic loading of plugins',
    'dynamic': False,
    'name': 'have_dynamic_loading'},
  { 'description': 'Whether mysqld supports EXAMPLE tables',
    'dynamic': False,
    'name': 'have_example_engine'},
  { 'description': 'Whether mysqld supports FEDERATED tables',
    'dynamic': False,
    'name': 'have_federated_engine'},
  { 'description': 'Whether mysqld supports spatial data types',
    'dynamic': False,
    'name': 'have_geometry'},
  { 'description': 'Whether mysqld supports InnoDB tables',
    'dynamic': False,
    'name': 'have_innodb'},
  { 'description': 'Whether mysqld supports isam tables',
    'dynamic': False,
    'name': 'have_isam'},
  { 'description': 'Whether mysqld supports merge tables',
    'dynamic': False,
    'name': 'have_merge_engine'},
  { 'description': 'Whether mysqld supports NDB Cluster tables (set by --ndbcluster option)',
    'dynamic': False,
    'name': 'have_ndbcluster'},
  { 'description': 'Whether mysqld supports SSL connections',
    'dynamic': False,
    'name': 'have_openssl'},
  { 'description': 'Whether mysqld supports partitioning',
    'dynamic': False,
    'name': 'have_partition_engine'},
  { 'description': 'Whether mysqld supports partitioning',
    'dynamic': False,
    'name': 'have_partitioning'},
  { 'description': 'Whether statement profiling capability is available',
    'dynamic': False,
    'name': 'have_profiling'},
  { 'description': 'Whether mysqld supports query cache',
    'dynamic': False,
    'name': 'have_query_cache'},
  { 'description': 'Whether mysqld supports the raid option',
    'dynamic': False,
    'name': 'have_raid'},
  { 'description': 'Shows whether row-based replication is supported',
    'dynamic': False,
    'name': 'have_row_based_replication'},
  { 'description': 'YES if RTREE indexes are available, NO if not. (These are used for spatial indexes in MyISAM tables.)',
    'dynamic': False,
    'name': 'have_rtree_keys'},
  { 'description': 'Whether mysqld supports SSL connections',
    'dynamic': False,
    'name': 'have_ssl'},
  { 'description': 'Whether statement execution timeout is available',
    'dynamic': False,
    'name': 'have_statement_timeout'},
  { 'description': 'Is symbolic link support enabled',
    'dynamic': False,
    'name': 'have_symlink'},
  { 'description': 'Size of the host cache',
    'dynamic': True,
    'name': 'host_cache_size'},
  { 'description': 'The name of the server host',
    'dynamic': False,
    'name': 'hostname'},
  { 'description': 'This variable is a synonym for the LAST_INSERT_ID variable. It exists for compatibility with other database systems',
    'dynamic': True,
    'name': 'identity'},
  { 'description': 'Ignore the built-in InnoDB',
    'dynamic': False,
    'name': 'ignore-builtin-innodb'},
  { 'description': 'Directories treated as nondatabase directories',
    'dynamic': False,
    'name': 'ignore_db_dirs'},
  { 'description': 'Which table statistics source to use',
    'dynamic': True,
    'name': 'information_schema_stats'},
  { 'description': 'Read SQL statements from this file at startup',
    'dynamic': False,
    'name': 'init-file'},
  { 'description': 'Statements that are executed for each new connection',
    'dynamic': True,
    'name': 'init_connect'},
  { 'description': 'Statements that are executed when a slave connects to a master',
    'dynamic': True,
    'name': 'init_slave'},
  { 'description': 'Control InnoDB adaptive flushing of dirty pages',
    'dynamic': True,
    'name': 'innodb_adaptive_flushing'},
  { 'description': 'Low water mark representing percentage of redo log capacity at which adaptive flushing is enabled.',
    'dynamic': True,
    'name': 'innodb_adaptive_flushing_lwm'},
  { 'description': 'Enable or disable InnoDB adaptive hash indexes',
    'dynamic': False,
    'name': 'innodb_adaptive_hash_index'},
  { 'description': 'Partitions the adaptive hash index search system into n partitions, with each partition protected by a separate latch. Each index is bound to a specific partition based on space ID and index ID attributes.',
    'dynamic': False,
    'name': 'innodb_adaptive_hash_index_parts'},
  { 'description': 'Allows InnoDB to automatically adjust the value of innodb_thread_sleep_delay up or down according to the current workload',
    'dynamic': True,
    'name': 'innodb_adaptive_max_sleep_delay'},
  { 'description': 'How often to auto-commit idle connections that use the InnoDB memcached interface, in seconds.',
    'dynamic': True,
    'name': 'innodb_api_bk_commit_interval'},
  { 'description': '', 'dynamic': False, 'name': 'innodb_api_disable_rowlock'},
  { 'description': 'Lets you use the InnoDB memcached plugin with the MySQL binary log',
    'dynamic': False,
    'name': 'innodb_api_enable_binlog'},
  { 'description': 'Locks the table used by the InnoDB memcached plugin, so that it cannot be dropped or altered by DDL through the SQL interface',
    'dynamic': False,
    'name': 'innodb_api_enable_mdl'},
  { 'description': 'Lets you control the transaction isolation level on queries processed by the memcached interface',
    'dynamic': True,
    'name': 'innodb_api_trx_level'},
  { 'description': 'Data file autoextend increment in megabytes',
    'dynamic': True,
    'name': 'innodb_autoextend_increment'},
  { 'description': 'Set InnoDB auto-increment lock mode',
    'dynamic': False,
    'name': 'innodb_autoinc_lock_mode'},
  { 'description': 'This debug option delays table creation until the background drop list is empty.',
    'dynamic': True,
    'name': 'innodb_background_drop_list_empty'},
  { 'description': 'If Windows AWE is used, size in Megabytes of InnoDB buffer pool allocated from the AWE memory',
    'dynamic': False,
    'name': 'innodb_buffer_pool_awe_mem_mb'},
  { 'description': 'Defines the chunk size that is used when resizing the buffer pool',
    'dynamic': False,
    'name': 'innodb_buffer_pool_chunk_size'},
  { 'description': 'Permits multiple buffer pool instances when the buffer pool is less than 1GB in size',
    'dynamic': False,
    'name': 'innodb_buffer_pool_debug'},
  { 'description': 'Specifies whether to record the pages cached in the InnoDB buffer pool when the MySQL server is shut down, to shorten the warmup process at the next restart',
    'dynamic': True,
    'name': 'innodb_buffer_pool_dump_at_shutdown'},
  { 'description': 'Immediately records the pages cached in the InnoDB buffer pool',
    'dynamic': True,
    'name': 'innodb_buffer_pool_dump_now'},
  { 'description': 'Specifies the percentage of the most recently used pages for each buffer pool to read out and dump.',
    'dynamic': True,
    'name': 'innodb_buffer_pool_dump_pct'},
  { 'description': 'Specifies the file that holds the list of page numbers produced by innodb_buffer_pool_dump_at_shutdown or innodb_buffer_pool_dump_now',
    'dynamic': True,
    'name': 'innodb_buffer_pool_filename'},
  { 'description': 'Specifies how many parts the InnoDB buffer pool is divided into',
    'dynamic': False,
    'name': 'innodb_buffer_pool_instances'},
  { 'description': 'Interrupts process of restoring InnoDB buffer pool contents triggered by innodb_buffer_pool_load_at_startup or innodb_buffer_pool_load_now',
    'dynamic': True,
    'name': 'innodb_buffer_pool_load_abort'},
  { 'description': 'Specifies that, on MySQL server startup, the InnoDB buffer pool is automatically "warmed up" by loading the same pages it held at an earlier time',
    'dynamic': False,
    'name': 'innodb_buffer_pool_load_at_startup'},
  { 'description': 'Immediately "warms up" the InnoDB buffer pool by loading a set of data pages, without waiting for a server restart',
    'dynamic': True,
    'name': 'innodb_buffer_pool_load_now'},
  { 'description': 'Size of the memory buffer InnoDB uses to cache data and indexes of its tables',
    'dynamic': False,
    'name': 'innodb_buffer_pool_size'},
  { 'description': 'Maximum size for the InnoDB change buffer, as a percentage of the total size of buffer pool',
    'dynamic': True,
    'name': 'innodb_change_buffer_max_size'},
  { 'description': 'Whether InnoDB performs insert buffering.',
    'dynamic': True,
    'name': 'innodb_change_buffering'},
  { 'description': 'Sets a debug flag for InnoDB change buffering',
    'dynamic': True,
    'name': 'innodb_change_buffering_debug'},
  { 'description': 'Specifies how to generate and verify the checksum stored in each disk block of each InnoDB tablespace',
    'dynamic': True,
    'name': 'innodb_checksum_algorithm'},
  { 'description': 'Enable InnoDB checksums validation',
    'dynamic': False,
    'name': 'innodb_checksums'},
  { 'description': 'Enables per-index compression-related statistics in the INFORMATION_SCHEMA.INNODB_CMP_PER_INDEX table',
    'dynamic': True,
    'name': 'innodb_cmp_per_index_enabled'},
  { 'description': 'Helps in performance tuning in heavily concurrent environments',
    'dynamic': True,
    'name': 'innodb_commit_concurrency'},
  { 'description': 'Compresses all tables using a specified compression algorithm',
    'dynamic': True,
    'name': 'innodb_compress_debug'},
  { 'description': 'Sets the cutoff point at which MySQL begins adding padding within compressed pages to avoid expensive compression failures',
    'dynamic': True,
    'name': 'innodb_compression_failure_threshold_pct'},
  { 'description': 'Specifies the level of zlib compression to use for InnoDB compressed tables and indexes',
    'dynamic': True,
    'name': 'innodb_compression_level'},
  { 'description': 'Specifies the maximum percentage that can be reserved as free space within each compressed page, to avoid compression failures when tightly packed data is recompressed',
    'dynamic': True,
    'name': 'innodb_compression_pad_pct_max'},
  { 'description': 'Number of times a thread is allowed to enter InnoDB within the same SQL query after it has once got the ticket',
    'dynamic': True,
    'name': 'innodb_concurrency_tickets'},
  { 'description': 'Enable this option to create performance-optimized temporary tables using CREATE TEMPORY TABLE syntax',
    'dynamic': True,
    'name': 'innodb_create_intrinsic'},
  { 'description': 'Path to individual files and their sizes',
    'dynamic': False,
    'name': 'innodb_data_file_path'},
  { 'description': 'The common part for InnoDB table spaces',
    'dynamic': False,
    'name': 'innodb_data_home_dir'},
  { 'description': 'Enables or disables deadlock detection',
    'dynamic': True,
    'name': 'innodb_deadlock_detect'},
  { 'description': 'Defines the default row format (ROW_FORMAT) for InnoDB tables.',
    'dynamic': True,
    'name': 'innodb_default_row_format'},
  { 'description': 'Disable OS file system cache for merge-sort temporary files',
    'dynamic': True,
    'name': 'innodb_disable_sort_file_cache'},
  { 'description': 'Disables resizing of the InnoDB buffer pool',
    'dynamic': True,
    'name': 'innodb_disable_resize_buffer_pool_debug'},
  { 'description': 'Enable InnoDB doublewrite buffer',
    'dynamic': False,
    'name': 'innodb_doublewrite'},
  { 'description': 'Whether to flush dirty buffer pages when the percentage of dirty pages is less than the maximum dirty percent',
    'dynamic': False,
    'name': 'innodb_extra_dirty_writes'},
  { 'description': 'Speeds up the shutdown process of the InnoDB storage engine',
    'dynamic': True,
    'name': 'innodb_fast_shutdown'},
  { 'description': 'Dirties the first page of the specified tablespace',
    'dynamic': True,
    'name': 'innodb_fil_make_page_dirty_debug'},
  { 'description': 'The format for new InnoDB tables',
    'dynamic': True,
    'name': 'innodb_file_format'},
  { 'description': 'Whether InnoDB performs file format compatibility checking',
    'dynamic': True,
    'name': 'innodb_file_format_check'},
  { 'description': 'The file format tag in the shared tablespace',
    'dynamic': True,
    'name': 'innodb_file_format_max'},
  { 'description': 'Number of file I/O threads in InnoDB',
    'dynamic': False,
    'name': 'innodb_file_io_threads'},
  { 'description': 'Stores each InnoDB table and its indexes in a separate .ibd file in the database directory',
    'dynamic': False,
    'name': 'innodb_file_per_table'},
  { 'description': 'Defines the percentage B-tree leaf and non-leaf page space that is to be filled with data. The remaining space is reserved for future growth.',
    'dynamic': True,
    'name': 'innodb_fill_factor'},
  { 'description': 'Write and flush logs every N seconds',
    'dynamic': True,
    'name': 'innodb_flush_log_at_timeout'},
  { 'description': 'Set to 0 (write and flush once per second), 1 (write and flush at each commit) or 2 (write at commit, flush once per second)',
    'dynamic': True,
    'name': 'innodb_flush_log_at_trx_commit'},
  { 'description': 'Specifies to flush data',
    'dynamic': False,
    'name': 'innodb_flush_method'},
  { 'description': 'Specifies whether or not flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent',
    'dynamic': True,
    'name': 'innodb_flush_neighbors'},
  { 'description': 'Enable innodb_flush_sync to ignore the innodb_io_capacity setting for bursts of I/O activity that occur at checkpoints. Disable innodb_flush_sync to adhere to the limit on I/O activity defined by the innodb_io_capacity setting.',
    'dynamic': True,
    'name': 'innodb_flush_sync'},
  { 'description': 'Number of iterations for which InnoDB keeps the previously calculated snapshot of the flushing state, controlling how quickly adaptive flushing responds to changing workloads',
    'dynamic': True,
    'name': 'innodb_flushing_avg_loops'},
  { 'description': 'Lets InnoDB load tables at startup that are marked as corrupted; use only during troubleshooting',
    'dynamic': False,
    'name': 'innodb_force_load_corrupted'},
  { 'description': 'Helps to save your data in case the disk image of the database becomes corrupt',
    'dynamic': False,
    'name': 'innodb_force_recovery'},
  { 'description': 'Specifies which InnoDB table with a FULLTEXT index to examine by querying several innodb_ft_* tables in the information_schema',
    'dynamic': True,
    'name': 'innodb_ft_aux_table'},
  { 'description': 'Size of the cache that holds a parsed document in memory while creating an InnoDB FULLTEXT index',
    'dynamic': False,
    'name': 'innodb_ft_cache_size'},
  { 'description': 'Whether to enable additional full-text search diagnostic output',
    'dynamic': True,
    'name': 'innodb_ft_enable_diag_print'},
  { 'description': 'During creation of an InnoDB FULLTEXT index, omits stopwords from the search index',
    'dynamic': True,
    'name': 'innodb_ft_enable_stopword'},
  { 'description': 'Maximum length of words that are stored in an InnoDB FULLTEXT index',
    'dynamic': False,
    'name': 'innodb_ft_max_token_size'},
  { 'description': 'Minimum length of words that are stored in an InnoDB FULLTEXT index',
    'dynamic': False,
    'name': 'innodb_ft_min_token_size'},
  { 'description': 'Number of words to process during each OPTIMIZE TABLE operation on an InnoDB FULLTEXT index',
    'dynamic': True,
    'name': 'innodb_ft_num_word_optimize'},
  { 'description': 'The InnoDB FULLTEXT search query result cache limit.',
    'dynamic': True,
    'name': 'innodb_ft_result_cache_limit'},
  { 'description': 'Specifies a table holding a list of stopwords for InnoDB FULLTEXT indexes, which overrides the default stopword list and can be overridden by innodb_ft_user_stopword_table',
    'dynamic': True,
    'name': 'innodb_ft_server_stopword_table'},
  { 'description': 'Number of threads used to create an InnoDB FULLTEXT index in parallel, when building a search index for a large table',
    'dynamic': False,
    'name': 'innodb_ft_sort_pll_degree'},
  { 'description': 'The total memory allocated for the InnoDB FULLTEXT search index cache.',
    'dynamic': False,
    'name': 'innodb_ft_total_cache_size'},
  { 'description': 'Specifies a table holding a list of stopwords for InnoDB FULLTEXT indexes, which overrides the default stopword list and also innodb_ft_server_stopword_table',
    'dynamic': True,
    'name': 'innodb_ft_user_stopword_table'},
  { 'description': 'The limit on the maximum number of I/O operations per second',
    'dynamic': False,
    'name': 'innodb_io_capacity'},
  { 'description': 'The limit up to which InnoDB is allowed to extend the innodb_io_capacity setting in case of emergency',
    'dynamic': True,
    'name': 'innodb_io_capacity_max'},
  { 'description': 'Enables longer keys for column prefix indexes',
    'dynamic': True,
    'name': 'innodb_large_prefix'},
  { 'description': 'Limits the number of records per B-tree page',
    'dynamic': True,
    'name': 'innodb_limit_optimistic_insert_debug'},
  { 'description': 'Timeout in seconds an InnoDB transaction may wait for a lock before a rollback occurs',
    'dynamic': False,
    'name': 'innodb_lock_wait_timeout'},
  { 'description': 'Force InnoDB not to use next-key locking. Instead use only row-level locking',
    'dynamic': False,
    'name': 'innodb_locks_unsafe_for_binlog'},
  { 'description': 'Where full logs should be archived',
    'dynamic': False,
    'name': 'innodb_log_arch_dir'},
  { 'description': 'Unused', 'dynamic': False, 'name': 'innodb_log_archive'},
  { 'description': 'Size of buffer which InnoDB uses to write log to the log files on disk',
    'dynamic': False,
    'name': 'innodb_log_buffer_size'},
  { 'description': 'Specifies how to generate and verify the checksum stored in each redo log disk block',
    'dynamic': True,
    'name': 'innodb_log_checksum_algorithm'},
  { 'description': 'Enables or disables checksums for redo log pages.',
    'dynamic': True,
    'name': 'innodb_log_checksums'},
  { 'description': 'Specifies whether images of re-compressed pages are stored in InnoDB redo logs',
    'dynamic': True,
    'name': 'innodb_log_compressed_pages'},
  { 'description': 'Size of each log file in a log group',
    'dynamic': False,
    'name': 'innodb_log_file_size'},
  { 'description': 'Number of InnoDB log files in the log group',
    'dynamic': False,
    'name': 'innodb_log_files_in_group'},
  { 'description': 'Path to InnoDB log files',
    'dynamic': False,
    'name': 'innodb_log_group_home_dir'},
  { 'description': 'The write-ahead block size for the redo log.',
    'dynamic': True,
    'name': 'innodb_log_write_ahead_size'},
  { 'description': 'Influences the algorithms and heuristics for the flush operation for the InnoDB buffer pool',
    'dynamic': True,
    'name': 'innodb_lru_scan_depth'},
  { 'description': 'Percentage of dirty pages allowed in buffer pool',
    'dynamic': True,
    'name': 'innodb_max_dirty_pages_pct'},
  { 'description': 'Low water mark representing percentage of dirty pages where preflushing is enabled to control the dirty page ratio',
    'dynamic': True,
    'name': 'innodb_max_dirty_pages_pct_lwm'},
  { 'description': 'The maximum number of background I/O requests to merge to issue a larger I/O request',
    'dynamic': False,
    'name': 'innodb_max_merged_io'},
  { 'description': 'Desired maximum length of the purge queue (0 = no limit)',
    'dynamic': True,
    'name': 'innodb_max_purge_lag'},
  { 'description': 'Specifies the maximum delay in milliseconds for the formula calculated using the innodb_max_purge_lag configuration option',
    'dynamic': True,
    'name': 'innodb_max_purge_lag_delay'},
  { 'description': 'Sets the threshold for truncating the InnoDB undo log',
    'dynamic': True,
    'name': 'innodb_max_undo_log_size'},
  { 'description': 'Size of a memory pool InnoDB uses to store data dictionary information and other internal data structures',
    'dynamic': False,
    'name': 'innodb_additional_mem_pool_size'},
  { 'description': 'Overrides the current MERGE_THRESHOLD setting with the specified value for all indexes that are currently in the dictionary cache',
    'dynamic': True,
    'name': 'innodb_merge_threshold_set_all_debug'},
  { 'description': 'Obsolete setting; do not use',
    'dynamic': False,
    'name': 'innodb_mirrored_log_groups'},
  { 'description': 'Turns off one or more counters in the information_schema.innodb_metrics table',
    'dynamic': True,
    'name': 'innodb_monitor_disable'},
  { 'description': 'Turns on one or more counters in the information_schema.innodb_metrics table',
    'dynamic': True,
    'name': 'innodb_monitor_enable'},
  { 'description': 'Resets to zero the count value for one or more counters in the information_schema.innodb_metrics table',
    'dynamic': True,
    'name': 'innodb_monitor_reset'},
  { 'description': 'Resets all values (minimum, maximum, and so on) for one or more counters in the information_schema.innodb_metrics table',
    'dynamic': True,
    'name': 'innodb_monitor_reset_all'},
  { 'description': 'Enables the NUMA MPOL_INTERLEAVE memory policy for allocation of the InnoDB buffer pool',
    'dynamic': False,
    'name': 'innodb_numa_interleave'},
  { 'description': 'Percentage of the InnoDB buffer pool to reserve for old blocks',
    'dynamic': True,
    'name': 'innodb_old_blocks_pct'},
  { 'description': 'How long (in ms) blocks must remain in old end of InnoDB buffer pool before moving to new end',
    'dynamic': True,
    'name': 'innodb_old_blocks_time'},
  { 'description': 'Specifies an upper limit on size of the temporary log files used during online DDL operations for InnoDB tables.',
    'dynamic': True,
    'name': 'innodb_online_alter_log_max_size'},
  { 'description': 'The maximum number of files that InnoDB keeps open at the same time',
    'dynamic': False,
    'name': 'innodb_open_files'},
  { 'description': 'Makes the OPTIMIZE TABLE statement for an InnoDB table process the newly added, deleted, and updated token data for a FULLTEXT index, rather than reorganizing the data in the clustered index of the table',
    'dynamic': True,
    'name': 'innodb_optimize_fulltext_only'},
  { 'description': 'Enable this option to store POINT data as fixed-length data rather than a variable-length data.',
    'dynamic': True,
    'name': 'innodb_optimize_point_storage'},
  { 'description': 'Number of page cleaner threads.',
    'dynamic': False,
    'name': 'innodb_page_cleaners'},
  { 'description': 'Specifies the page size for all InnoDB tablespaces in an instance',
    'dynamic': False,
    'name': 'innodb_page_size'},
  { 'description': 'During shutdown, prints information about all InnoDB deadlocks to the server error log',
    'dynamic': True,
    'name': 'innodb_print_all_deadlocks'},
  { 'description': 'Specifies the number of InnoDB redo logs that trigger a purge operation.',
    'dynamic': True,
    'name': 'innodb_purge_batch_size'},
  { 'description': 'The rate at which undo log purge should be invoked as part of the purge action. A value of n invokes undo log purge on every nth iteration of purge invocation.',
    'dynamic': True,
    'name': 'innodb_purge_rseg_truncate_frequency'},
  { 'description': 'Specifies whether the InnoDB purge operation should be performed in one or more separate threads. By default, this operation is part of the InnoDB master thread.',
    'dynamic': False,
    'name': 'innodb_purge_threads'},
  { 'description': 'Enables the random read-ahead technique for optimizing InnoDB I/O',
    'dynamic': True,
    'name': 'innodb_random_read_ahead'},
  { 'description': 'The sensitivity of InnoDB linear read-ahead',
    'dynamic': True,
    'name': 'innodb_read_ahead_threshold'},
  { 'description': 'Number of background I/O threads for read prefetch requests',
    'dynamic': False,
    'name': 'innodb_read_io_threads'},
  { 'description': 'Starts the server in read-only mode',
    'dynamic': False,
    'name': 'innodb_read_only'},
  { 'description': 'The slave server replication thread delay',
    'dynamic': True,
    'name': 'innodb_replication_delay'},
  { 'description': 'Roll back entire transaction on transaction timeout, not just last statement',
    'dynamic': False,
    'name': 'innodb_rollback_on_timeout'},
  { 'description': 'Defines how many of the rollback segments in the system tablespace that InnoDB uses within a transaction',
    'dynamic': True,
    'name': 'innodb_rollback_segments'},
  { 'description': 'Saves a page number',
    'dynamic': True,
    'name': 'innodb_saved_page_number_debug'},
  { 'description': 'Specifies size of a buffer used for sorting data during creation of an InnoDB index',
    'dynamic': False,
    'name': 'innodb_sort_buffer_size'},
  { 'description': 'The maximum delay between polls for a spin lock',
    'dynamic': True,
    'name': 'innodb_spin_wait_delay'},
  { 'description': 'Causes InnoDB to automatically recalculate persistent statistics after the data in a table is changed substantially',
    'dynamic': True,
    'name': 'innodb_stats_auto_recalc'},
  { 'description': 'Include delete-marked records when calculating persistent InnoDB statistics',
    'dynamic': True,
    'name': 'innodb_stats_include_delete_marked'},
  { 'description': 'Specifies how InnoDB index statistics collection code should treat NULLs',
    'dynamic': True,
    'name': 'innodb_stats_method'},
  { 'description': 'Enable or disable InnoDB table statistics updates for metadata statements',
    'dynamic': False,
    'name': 'innodb_stats_on_metadata'},
  { 'description': 'Turns on the InnoDB persistent statistics feature',
    'dynamic': True,
    'name': 'innodb_stats_persistent'},
  { 'description': 'Number of pages to sample in each InnoDB index, when the persistent statistics feature is also enabled',
    'dynamic': True,
    'name': 'innodb_stats_persistent_sample_pages'},
  { 'description': 'Number of index pages to sample for index distribution statistics',
    'dynamic': True,
    'name': 'innodb_stats_sample_pages'},
  { 'description': 'Number of pages to sample in each InnoDB index, when the persistent statistics feature is turned off (the default setting)',
    'dynamic': True,
    'name': 'innodb_stats_transient_sample_pages'},
  { 'description': 'Used to enable or disable periodic output for the standard InnoDB Monitor. Also used in combination with innodb_status_output_locks to enable and disable periodic output for the InnoDB Lock Monitor.',
    'dynamic': True,
    'name': 'innodb_status_output'},
  { 'description': 'Used to enable or disable periodic output for the standard InnoDB Lock Monitor. innodb_status_output must also be enabled to produce periodic output for the InnoDB Lock Monitor.',
    'dynamic': True,
    'name': 'innodb_status_output_locks'},
  { 'description': 'Whether InnoDB returns errors rather than warnings for exceptional conditions',
    'dynamic': True,
    'name': 'innodb_strict_mode'},
  { 'description': 'Enable InnoDB support for the XA two-phase commit',
    'dynamic': True,
    'name': 'innodb_support_xa'},
  { 'description': 'Splits an internal data structure used to coordinate threads, for higher concurrency in workloads with large numbers of waiting threads',
    'dynamic': False,
    'name': 'innodb_sync_array_size'},
  { 'description': 'Count of spin-loop rounds in InnoDB mutexes',
    'dynamic': True,
    'name': 'innodb_sync_spin_loops'},
  { 'description': 'Enables InnoDB sync debug checking',
    'dynamic': False,
    'name': 'innodb_sync_debug'},
  { 'description': 'Enable InnoDB locking in LOCK TABLES',
    'dynamic': True,
    'name': 'innodb_table_locks'},
  { 'description': 'Defines the path to temporary tablespace data files and their sizes.',
    'dynamic': False,
    'name': 'innodb_temp_data_file_path'},
  { 'description': 'Defines a directory location for the temporary table files created during online ALTER TABLE operations.',
    'dynamic': True,
    'name': 'innodb_tmpdir'},
  { 'description': 'Sets the maximum number of threads allowed inside InnoDB. Value 0 will disable the thread throttling',
    'dynamic': True,
    'name': 'innodb_thread_concurrency'},
  { 'description': 'Whether to use the lock-free method of handling thread concurrency',
    'dynamic': False,
    'name': 'innodb_thread_concurrency_timer_based'},
  { 'description': 'Time, in microseconds, that an InnoDB thread sleeps before joining InnoDB queue. Value 0 disables the sleep behavior',
    'dynamic': True,
    'name': 'innodb_thread_sleep_delay'},
  { 'description': 'Pauses purging of delete-marked records while allowing the purge view to be updated',
    'dynamic': True,
    'name': 'innodb_trx_purge_view_update_only_debug'},
  { 'description': 'Sets a debug flag that limits TRX_RSEG_N_SLOTS to a given value for the trx_rsegf_undo_find_free function',
    'dynamic': True,
    'name': 'innodb_trx_rseg_n_slots_debug'},
  { 'description': 'The relative or absolute directory path where InnoDB creates separate tablespaces for the undo logs; typically used to place those logs on a different storage device',
    'dynamic': False,
    'name': 'innodb_undo_directory'},
  { 'description': 'Enable this option to mark the InnoDB undo tablespace for truncation',
    'dynamic': True,
    'name': 'innodb_undo_log_truncate'},
  { 'description': 'Defines the number of undo logs (rollback segments) used by InnoDB; replaces the innodb_rollback_segments setting',
    'dynamic': True,
    'name': 'innodb_undo_logs'},
  { 'description': 'Number of undo logs to place in each tablespace created by a non-zero innodb_undo_logs setting',
    'dynamic': False,
    'name': 'innodb_undo_tablespaces'},
  { 'description': 'Whether to use legacy InnoDB index cardinality calculation algorithm',
    'dynamic': True,
    'name': 'innodb_use_legacy_cardinality_algorithm'},
  { 'description': 'Specifies whether to use the Linux asynchronous I/O subsystem',
    'dynamic': False,
    'name': 'innodb_use_native_aio'},
  { 'description': 'Whether InnoDB uses the OS or its own memory allocator',
    'dynamic': False,
    'name': 'innodb_use_sys_malloc'},
  { 'description': 'The version of InnoDB',
    'dynamic': False,
    'name': 'innodb_version'},
  { 'description': 'Number of background I/O threads for writing dirty pages from the buffer cache to disk',
    'dynamic': False,
    'name': 'innodb_write_io_threads'},
  { 'description': 'Set the value to be used by the following INSERT or ALTER TABLE statement when inserting an AUTO_INCREMENT value',
    'dynamic': True,
    'name': 'insert_id'},
  { 'description': 'Number of seconds the server waits for activity on an interactive connection before closing it',
    'dynamic': True,
    'name': 'interactive_timeout'},
  { 'description': 'Storage engine for internal temporary tables',
    'dynamic': True,
    'name': 'internal_tmp_disk_storage_engine'},
  { 'description': 'Size of buffer that is used for full joins',
    'dynamic': True,
    'name': 'join_buffer_size'},
  { 'description': 'How join buffers are used',
    'dynamic': True,
    'name': 'join_cache_level'},
  { 'description': 'Do not overwrite existing .MYD/.MYI files in default database directory',
    'dynamic': True,
    'name': 'keep_files_on_create'},
  { 'description': 'Size of buffer used for index blocks for MyISAM tables',
    'dynamic': True,
    'name': 'key_buffer_size'},
  { 'description': 'This characterizes the number of hits a hot block has to be untouched until it is considered aged enough to be downgraded to a warm block. This specifies the percentage ratio of that number of hits to the total number of blocks in key cache',
    'dynamic': True,
    'name': 'key_cache_age_threshold'},
  { 'description': 'The default size of key cache blocks',
    'dynamic': True,
    'name': 'key_cache_block_size'},
  { 'description': 'The minimum percentage of warm blocks in key cache',
    'dynamic': True,
    'name': 'key_cache_division_limit'},
  { 'description': 'Keyring plugin data file',
    'dynamic': True,
    'name': 'keyring_file_data'},
  { 'description': 'Oracle Key Vault keyring plugin configuration directory',
    'dynamic': True,
    'name': 'keyring_okv_conf_dir'},
  { 'description': 'Client error messages in given language. May be given as a full path',
    'dynamic': False,
    'name': 'language'},
  { 'description': 'Enable support for large pages',
    'dynamic': False,
    'name': 'large-pages'},
  { 'description': 'Whether large files are supported',
    'dynamic': False,
    'name': 'large_files_support'},
  { 'description': 'Size of memory pages when large page support is enabled',
    'dynamic': False,
    'name': 'large_page_size'},
  { 'description': 'The most recent AUTO_INCREMENT value',
    'dynamic': True,
    'name': 'last_insert_id'},
  { 'description': 'Locale for error messages',
    'dynamic': True,
    'name': 'lc-messages'},
  { 'description': 'Directory where error messages are installed',
    'dynamic': False,
    'name': 'lc-messages-dir'},
  { 'description': 'The locale that controls the language used to display day and month names',
    'dynamic': True,
    'name': 'lc_time_names'},
  { 'description': 'Type of license for the server',
    'dynamic': False,
    'name': 'license'},
  { 'description': 'Whether LOCAL is supported for LOAD DATA INFILE statements. Default can be overridden by a number of server and client settings, see text for more information.',
    'dynamic': True,
    'name': 'local_infile'},
  { 'description': 'Timeout for metadata locks',
    'dynamic': True,
    'name': 'lock_wait_timeout'},
  { 'description': 'Whether mysqld is locked in memory',
    'dynamic': False,
    'name': 'locked_in_memory'},
  { 'description': 'Log connections and queries to file',
    'dynamic': False,
    'name': 'log'},
  { 'description': 'The destination for MySQL Backup history and progress log output. Syntax: log-backup-output[=value[,value...]], where "value" could be TABLE, FILE, or NONE',
    'dynamic': True,
    'name': 'log-backup-output'},
  { 'description': 'Specifies binary log file name',
    'dynamic': False,
    'name': 'log-bin'},
  { 'description': 'If equal to 0 (the default), then when --log-bin is used, creation of a stored function is allowed only to users having the SUPER privilege and only if the function created does not break binary logging',
    'dynamic': True,
    'name': 'log-bin-trust-function-creators'},
  { 'description': '(deprecated) Use log-bin-trust-function-creators',
    'dynamic': True,
    'name': 'log-bin-trust-routine-creators'},
  { 'description': 'Use version 1 binary log row events',
    'dynamic': False,
    'name': 'log-bin-use-v1-row-events'},
  { 'description': 'Error log file', 'dynamic': False, 'name': 'log-error'},
  { 'description': 'The destination for general query log and slow query log output',
    'dynamic': True,
    'name': 'log-output'},
  { 'description': 'Log queries that are executed without benefit of any index to the slow query log if it is open',
    'dynamic': True,
    'name': 'log-queries-not-using-indexes'},
  { 'description': 'Tells the slave to log the updates performed by its SQL thread to its own binary log',
    'dynamic': False,
    'name': 'log-slave-updates'},
  { 'description': 'Whether to log slow queries. Logging defaults to hostname-slow.log file. Must be enabled to activate other slow query log options',
    'dynamic': False,
    'name': 'log-slow-queries'},
  { 'description': 'Log some noncritical warnings to the log file',
    'dynamic': True,
    'name': 'log-warnings'},
  { 'description': 'Whether to log CREATE/ALTER USER, GRANT in backward-compatible fashion',
    'dynamic': True,
    'name': 'log_backward_compatible_user_definitions'},
  { 'description': 'Whether the binary log is enabled',
    'dynamic': False,
    'name': 'log_bin'},
  { 'description': 'Complete path to binary log, including filename',
    'dynamic': False,
    'name': 'log_bin_basename'},
  { 'description': 'File that holds the names for last binary log files',
    'dynamic': False,
    'name': 'log_bin_index'},
  { 'description': 'Shows whether server is using version 1 binary log row events',
    'dynamic': False,
    'name': 'log_bin_use_v1_row_events'},
  { 'description': 'Whether to log CREATE/ALTER USER, GRANT in backward-compatible fashion',
    'dynamic': True,
    'name': 'log_builtin_as_identified_by_password'},
  { 'description': 'Error logging verbosity level',
    'dynamic': True,
    'name': 'log_error_verbosity'},
  { 'description': 'Whether the slave should log the updates performed by its SQL thread to its own binary log. Read-only; set using the --log-slave-updates server option.',
    'dynamic': False,
    'name': 'log_slave_updates'},
  { 'description': 'Log slow OPTIMIZE, ANALYZE, ALTER and other administrative statements to the slow query log if it is open',
    'dynamic': True,
    'name': 'log_slow_admin_statements'},
  { 'description': 'Cause slow statements as executed by the slave to be written to the slow query log',
    'dynamic': True,
    'name': 'log_slow_slave_statements'},
  { 'description': 'Disables error 1592 warnings being written to the error log',
    'dynamic': True,
    'name': 'log_statements_unsafe_for_binlog'},
  { 'description': 'Whether to write error log to syslog',
    'dynamic': True,
    'name': 'log_syslog'},
  { 'description': 'Facility for syslog messages',
    'dynamic': True,
    'name': 'log_syslog_facility'},
  { 'description': 'Whether to include server PID in syslog messages',
    'dynamic': True,
    'name': 'log_syslog_include_pid'},
  { 'description': 'Tag for server identifier in syslog messages',
    'dynamic': True,
    'name': 'log_syslog_tag'},
  { 'description': 'Throttle write rate to slow log for queries not using indexes slow query log if it is open',
    'dynamic': True,
    'name': 'log_throttle_queries_not_using_indexes'},
  { 'description': 'Log timestamp format',
    'dynamic': True,
    'name': 'log_timestamps'},
  { 'description': 'Log all queries that have taken more than long_query_time seconds to execute to file',
    'dynamic': True,
    'name': 'long_query_time'},
  { 'description': 'INSERT/DELETE/UPDATE has lower priority than selects',
    'dynamic': True,
    'name': 'low-priority-updates'},
  { 'description': 'This variable describes the case sensitivity of file names on the file system',
    'dynamic': False,
    'name': 'lower_case_file_system'},
  { 'description': 'If set to 1, table names are stored in lowercase on disk and table names will be case insensitive. Should be set to 2 if you are using a case-insensitive file system.',
    'dynamic': False,
    'name': 'lower_case_table_names'},
  { 'description': 'Sets the block size for Maria tables',
    'dynamic': False,
    'name': 'maria-block-size'},
  { 'description': 'Sets the interval between automatic checkpoints',
    'dynamic': True,
    'name': 'maria-checkpoint-interval'},
  { 'description': 'Sets size of each of the Maria log files',
    'dynamic': True,
    'name': 'maria-log-file-size'},
  { 'description': 'Sets the mode for purging Maria log files',
    'dynamic': True,
    'name': 'maria-log-purge-type'},
  { 'description': 'The maximum size of an external sort file',
    'dynamic': True,
    'name': 'maria-max-sort-file-size'},
  { 'description': 'Sets the default mode for page checksums',
    'dynamic': True,
    'name': 'maria-page-checksum'},
  { 'description': 'Sets the pagecache age',
    'dynamic': True,
    'name': 'maria-pagecache-age-threshold'},
  { 'description': 'Sets the buffer size for data and index pages',
    'dynamic': False,
    'name': 'maria-pagecache-buffer-size'},
  { 'description': 'The minimum percentage of warm blocks in the page cache',
    'dynamic': True,
    'name': 'maria-pagecache-division-limit'},
  { 'description': 'Force recovery of Maria tables without the log file',
    'dynamic': True,
    'name': 'maria-recover'},
  { 'description': 'Number of threads to be used when repairing tables',
    'dynamic': True,
    'name': 'maria-repair-threads'},
  { 'description': 'Sets the sort buffer size for indexes',
    'dynamic': True,
    'name': 'maria-sort-buffer-size'},
  { 'description': 'Sets the statistics collection method',
    'dynamic': True,
    'name': 'maria-stats-method'},
  { 'description': 'Controls the synchronization of the directory after a log file has been extended or created',
    'dynamic': True,
    'name': 'maria-sync-log-dir'},
  { 'description': "Whether to write master status information and replication I/O thread location in the master's binary logs to a file or table",
    'dynamic': True,
    'name': 'master_info_repository'},
  { 'description': 'Cause master to read checksums from binary log.',
    'dynamic': True,
    'name': 'master_verify_checksum'},
  { 'description': 'Max packet length to send to/receive from server',
    'dynamic': True,
    'name': 'max_allowed_packet'},
  { 'description': 'Can be used to restrict the total size used to cache a multi-statement transaction',
    'dynamic': True,
    'name': 'max_binlog_cache_size'},
  { 'description': 'Binary log will be rotated automatically when size exceeds this value',
    'dynamic': True,
    'name': 'max_binlog_size'},
  { 'description': 'Can be used to restrict the total size used to cache all nontransactional statements during a transaction',
    'dynamic': True,
    'name': 'max_binlog_stmt_cache_size'},
  { 'description': 'Number of interrupted connections from a host before this host is blocked from further connections',
    'dynamic': True,
    'name': 'max_connect_errors'},
  { 'description': 'Number of simultaneous clients allowed',
    'dynamic': True,
    'name': 'max_connections'},
  { 'description': 'Do not start more than this number of threads to handle INSERT DELAYED statements. If set to zero, which means INSERT DELAYED is not used',
    'dynamic': True,
    'name': 'max_delayed_threads'},
  { 'description': 'The maximum digest size in bytes',
    'dynamic': False,
    'name': 'max_digest_length'},
  { 'description': 'Max number of errors/warnings to store for a statement',
    'dynamic': True,
    'name': 'max_error_count'},
  { 'description': 'Statement execution timeout value',
    'dynamic': True,
    'name': 'max_execution_time'},
  { 'description': 'Do not allow creation of heap tables bigger than this',
    'dynamic': True,
    'name': 'max_heap_table_size'},
  { 'description': 'This variable is a synonym for max_delayed_threads',
    'dynamic': True,
    'name': 'max_insert_delayed_threads'},
  { 'description': 'Joins that are probably going to read more than max_join_size records return an error',
    'dynamic': True,
    'name': 'max_join_size'},
  { 'description': 'Max number of bytes in sorted records',
    'dynamic': True,
    'name': 'max_length_for_sort_data'},
  { 'description': 'Max size of parameter values that mysql_stmt_send_long_data() can send',
    'dynamic': False,
    'name': 'max_long_data_size'},
  { 'description': 'Maximum number of points in geometry values for ST_Buffer_Strategy()',
    'dynamic': True,
    'name': 'max_points_in_geometry'},
  { 'description': 'Maximum number of prepared statements in the server',
    'dynamic': True,
    'name': 'max_prepared_stmt_count'},
  { 'description': 'If nonzero, relay log is rotated automatically when its size exceeds this value. If zero, size at which rotation occurs is determined by the value of max_binlog_size.',
    'dynamic': True,
    'name': 'max_relay_log_size'},
  { 'description': 'Limit assumed max number of seeks when looking up rows based on a key',
    'dynamic': True,
    'name': 'max_seeks_for_key'},
  { 'description': 'Number of bytes to use when sorting data values',
    'dynamic': True,
    'name': 'max_sort_length'},
  { 'description': 'Maximum stored procedure recursion depth',
    'dynamic': True,
    'name': 'max_sp_recursion_depth'},
  { 'description': 'Statement execution timeout value',
    'dynamic': True,
    'name': 'max_statement_time'},
  { 'description': 'Unused', 'dynamic': True, 'name': 'max_tmp_tables'},
  { 'description': 'The maximum number of active connections for a single user (0 = no limit)',
    'dynamic': True,
    'name': 'max_user_connections'},
  { 'description': 'After this many write locks, allow some read locks to run in between',
    'dynamic': True,
    'name': 'max_write_lock_count'},
  { 'description': 'Defines the path to the mecabrc configuration file for the MeCab parser for InnoDB Full-Text Search.',
    'dynamic': False,
    'name': 'mecab_rc_file'},
  { 'description': 'Size of the metadata locks cache',
    'dynamic': False,
    'name': 'metadata_locks_cache_size'},
  { 'description': 'Number of metadata lock hashes',
    'dynamic': False,
    'name': 'metadata_locks_hash_instances'},
  { 'description': 'Queries examining fewer than this number of rows are not logged to slow query log',
    'dynamic': True,
    'name': 'min-examined-row-limit'},
  { 'description': 'The maximum number of ranges to send to a table handler at once during range selects',
    'dynamic': True,
    'name': 'multi_range_count'},
  { 'description': 'Default pointer size to be used for MyISAM tables',
    'dynamic': True,
    'name': 'myisam_data_pointer_size'},
  { 'description': 'Deprecated option',
    'dynamic': False,
    'name': 'myisam_max_extra_sort_file_size'},
  { 'description': 'Do not use the fast sort index method to create index if the temporary file would get bigger than this',
    'dynamic': True,
    'name': 'myisam_max_sort_file_size'},
  { 'description': 'The maximum amount of memory to use for memory mapping compressed MyISAM files.',
    'dynamic': False,
    'name': 'myisam_mmap_size'},
  { 'description': 'The value of the --myisam-recover option',
    'dynamic': False,
    'name': 'myisam_recover_options'},
  { 'description': 'Number of threads to use when repairing MyISAM tables. The value of 1 disables parallel repair',
    'dynamic': True,
    'name': 'myisam_repair_threads'},
  { 'description': 'The buffer allocated when sorting the index for a REPAIR TABLE or when creating indexes for CREATE INDEX or ALTER TABLE',
    'dynamic': True,
    'name': 'myisam_sort_buffer_size'},
  { 'description': 'Specifies how MyISAM index statistics collection code should treat NULLs',
    'dynamic': True,
    'name': 'myisam_stats_method'},
  { 'description': 'Use memory mapping for reading and writing MyISAM tables',
    'dynamic': True,
    'name': 'myisam_use_mmap'},
  { 'description': 'Whether the mysql_native_password authentication plugin does proxying',
    'dynamic': True,
    'name': 'mysql_native_password_proxy_users'},
  { 'description': 'Maximum size of recorded statements',
    'dynamic': False,
    'name': 'mysql_firewall_max_query_size'},
  { 'description': 'Whether MySQL Enterprise Firewall is operational',
    'dynamic': True,
    'name': 'mysql_firewall_mode'},
  { 'description': 'Whether to enable firewall trace',
    'dynamic': True,
    'name': 'mysql_firewall_trace'},
  { 'description': 'Whether the server supports connections over named pipes',
    'dynamic': False,
    'name': 'named_pipe'},
  { 'description': 'Size (in bytes) to use for NDB transaction batches',
    'dynamic': False,
    'name': 'ndb-batch-size'},
  { 'description': 'Specifies size in bytes that large BLOB reads should be batched into. 0 = no limit.',
    'dynamic': True,
    'name': 'ndb-blob-read-batch-bytes'},
  { 'description': 'Specifies size in bytes that large BLOB writes should be batched into. 0 = no limit.',
    'dynamic': True,
    'name': 'ndb-blob-write-batch-bytes'},
  { 'description': 'Number of connections to the cluster used by MySQL',
    'dynamic': False,
    'name': 'ndb-cluster-connection-pool'},
  { 'description': 'Comma-separated list of node IDs for connections to the cluster used by MySQL; the number of nodes in the list must be the same as the value set for --ndb-cluster-connection-pool',
    'dynamic': False,
    'name': 'ndb-cluster-connection-pool-nodeids'},
  { 'description': 'Use this value (FIXED or DYNAMIC) by default for COLUMN_FORMAT and ROW_FORMAT options when creating or adding columns to a table.',
    'dynamic': True,
    'name': 'ndb-default-column-format'},
  { 'description': 'Specifies that constraint checks on unique indexes (where these are supported) should be deferred until commit time. Not normally needed or used; for testing purposes only.',
    'dynamic': True,
    'name': 'ndb-deferred-constraints'},
  { 'description': 'Default distribution for new tables in NDBCLUSTER (KEYHASH or LINHASH, default is KEYHASH)',
    'dynamic': True,
    'name': 'ndb-distribution'},
  { 'description': 'Cause a MySQL server acting as a slave to log mysql.ndb_apply_status updates received from its immediate master in its own binary log, using its own server ID. Effective only if the server is started with the --ndbcluster option.',
    'dynamic': False,
    'name': 'ndb-log-apply-status'},
  { 'description': 'When enabled, causes epochs in which there were no changes to be written to the ndb_apply_status and ndb_binlog_index tables, even when --log-slave-updates is enabled.',
    'dynamic': True,
    'name': 'ndb-log-empty-epochs'},
  { 'description': 'When enabled, causes updates that produced no changes to be written to the ndb_apply_status and ndb_binlog_index tables, even when --log-slave-updates is enabled.',
    'dynamic': True,
    'name': 'ndb-log-empty-update'},
  { 'description': 'Log primary key reads with exclusive locks; allow conflict resolution based on read conflicts.',
    'dynamic': True,
    'name': 'ndb-log-exclusive-reads'},
  { 'description': 'Log originating server id and epoch in mysql.ndb_binlog_index table.',
    'dynamic': False,
    'name': 'ndb-log-orig'},
  { 'description': 'Write NDB transaction IDs in the binary log. Requires --log-bin-v1-events=OFF.',
    'dynamic': False,
    'name': 'ndb-log-transaction-id'},
  { 'description': 'Toggles logging of updates on the master between updates (OFF) and writes (ON)',
    'dynamic': True,
    'name': 'ndb-log-update-as-write'},
  { 'description': 'Time (in seconds) for the MySQL server to wait for connection to cluster management and data nodes before accepting MySQL client connections.',
    'dynamic': False,
    'name': 'ndb-wait-connected'},
  { 'description': 'Time (in seconds) for the MySQL server to wait for NDB engine setup to complete.',
    'dynamic': False,
    'name': 'ndb-wait-setup'},
  { 'description': 'Set to OFF to keep ALTER TABLE from using copying operations on NDB tables',
    'dynamic': True,
    'name': 'ndb-allow-copying-alter-table'},
  { 'description': 'NDB auto-increment prefetch size',
    'dynamic': True,
    'name': 'ndb_autoincrement_prefetch_sz'},
  { 'description': 'Number of milliseconds between checks of cluster SQL nodes made by the MySQL query cache',
    'dynamic': True,
    'name': 'ndb_cache_check_time'},
  { 'description': 'Causes RESET SLAVE to clear all rows from the ndb_apply_status table. ON by default.',
    'dynamic': True,
    'name': 'ndb_clear_apply_status'},
  { 'description': 'Most recent NDB epoch on this slave in which a conflict was detected.',
    'dynamic': False,
    'name': 'Ndb_conflict_last_conflict_epoch'},
  { 'description': 'Specifies cluster data node "closest" to this MySQL Server, for transaction hinting and fully replicated tables',
    'dynamic': True,
    'name': 'ndb_data_node_neighbour'},
  { 'description': 'Sets default row format and column format (FIXED or DYNAMIC) used for new NDB tables.',
    'dynamic': True,
    'name': 'ndb_default_column_format'},
  { 'description': 'Specifies that constraint checks should be deferred (where these are supported). Not normally needed or used; for testing purposes only.',
    'dynamic': True,
    'name': 'ndb_deferred_constraints'},
  { 'description': 'Default distribution for new tables in NDBCLUSTER (KEYHASH or LINHASH, default is KEYHASH)',
    'dynamic': True,
    'name': 'ndb_distribution'},
  { 'description': 'Percentage of free memory that should be available in event buffer before resumption of buffering, after reaching limit set by ndb_eventbuffer_max_alloc.',
    'dynamic': True,
    'name': 'ndb_eventbuffer_free_percent'},
  { 'description': 'Maximum memory that can be allocated for buffering events by the NDB API. Defaults to 0 (no limit).',
    'dynamic': True,
    'name': 'ndb_eventbuffer_max_alloc'},
  { 'description': 'Controls logging of MySQL Cluster schema, connection, and data distribution events in the MySQL error log',
    'dynamic': True,
    'name': 'ndb_extra_logging'},
  { 'description': 'Forces sending of buffers to NDB immediately, without waiting for other threads',
    'dynamic': True,
    'name': 'ndb_force_send'},
  { 'description': 'Whether new NDB tables are fully replicated',
    'dynamic': True,
    'name': 'ndb_fully_replicated'},
  { 'description': 'Sets the granularity of the statistics by determining the number of starting and ending keys',
    'dynamic': True,
    'name': 'ndb_index_stat_cache_entries'},
  { 'description': 'Use NDB index statistics in query optimization',
    'dynamic': True,
    'name': 'ndb_index_stat_enable'},
  { 'description': 'Comma-separated list of tunable options for NDB index statistics; the list should contain no spaces',
    'dynamic': True,
    'name': 'ndb_index_stat_option'},
  { 'description': 'How often to query data nodes instead of the statistics cache',
    'dynamic': True,
    'name': 'ndb_index_stat_update_freq'},
  { 'description': 'Enables pushing down of joins to data nodes',
    'dynamic': True,
    'name': 'ndb_join_pushdown'},
  { 'description': 'Whether or not a MySQL server acting as a slave logs mysql.ndb_apply_status updates received from its immediate master in its own binary log, using its own server ID.',
    'dynamic': False,
    'name': 'ndb_log_apply_status'},
  { 'description': 'Write updates to NDB tables in the binary log. Effective only if binary logging is enabled with --log-bin.',
    'dynamic': True,
    'name': 'ndb_log_bin'},
  { 'description': 'Insert mapping between epochs and binary log positions into the ndb_binlog_index table. Defaults to ON. Effective only if binary logging is enabled on the server.',
    'dynamic': True,
    'name': 'ndb_log_binlog_index'},
  { 'description': 'When enabled, epochs in which there were no changes are written to the ndb_apply_status and ndb_binlog_index tables, even when log_slave_updates is enabled.',
    'dynamic': True,
    'name': 'ndb_log_empty_epochs'},
  { 'description': 'When enabled, updates which produce no changes are written to the ndb_apply_status and ndb_binlog_index tables, even when log_slave_updates is enabled.',
    'dynamic': True,
    'name': 'ndb_log_empty_update'},
  { 'description': 'Log primary key reads with exclusive locks; allow conflict resolution based on read conflicts.',
    'dynamic': True,
    'name': 'ndb_log_exclusive_reads'},
  { 'description': 'Whether the id and epoch of the originating server are recorded in the mysql.ndb_binlog_index table. Set using the --ndb-log-orig option when starting mysqld.',
    'dynamic': False,
    'name': 'ndb_log_orig'},
  { 'description': 'Whether NDB transaction IDs are written into the binary log. (Read-only.)',
    'dynamic': False,
    'name': 'ndb_log_transaction_id'},
  { 'description': 'Log complete rows (ON) or updates only (OFF)',
    'dynamic': True,
    'name': 'ndb_log_updated_only'},
  { 'description': 'Sets the number of milliseconds to wait between processing sets of rows by OPTIMIZE TABLE on NDB tables.',
    'dynamic': True,
    'name': 'ndb_optimization_delay'},
  { 'description': 'Determines how an SQL node chooses a cluster data node to use as transaction coordinator',
    'dynamic': False,
    'name': 'ndb_optimized_node_selection'},
  { 'description': 'Enable read from any replica',
    'dynamic': True,
    'name': 'ndb_read_backup'},
  { 'description': 'CPU mask for locking receiver threads to specific CPUs; specified as hexadecimal. See documentation for details.',
    'dynamic': True,
    'name': 'ndb_recv_thread_cpu_mask'},
  { 'description': 'NDB 7.5.4 and later: Threshold for number of epochs completely buffered, but not yet consumed by binlog injector thread which when exceeded generates BUFFERED_EPOCHS_OVER_THRESHOLD event buffer status message; prior to NDB 7.5.4: Threshold for number of epochs to lag behind before reporting binary log status',
    'dynamic': True,
    'name': 'ndb_report_thresh_binlog_epoch_slip'},
  { 'description': 'This is a threshold on the percentage of free memory remaining before reporting binary log status',
    'dynamic': True,
    'name': 'ndb_report_thresh_binlog_mem_usage'},
  { 'description': 'Show the mock tables used to support foreign_key_checks=0.',
    'dynamic': True,
    'name': 'ndb_show_foreign_key_mock_tables'},
  { 'description': 'Role for slave to play in conflict detection and resolution. Value is one of PRIMARY, SECONDARY, PASS, or NONE (default). Can be changed only when slave SQL thread is stopped. See documentation for further information.',
    'dynamic': True,
    'name': 'ndb_slave_conflict_role'},
  { 'description': 'The most recently committed NDB epoch on this slave. When this value is greater than or equal to Ndb_conflict_last_conflict_epoch, no conflicts have yet been detected.',
    'dynamic': False,
    'name': 'Ndb_slave_max_replicated_epoch'},
  { 'description': 'NDB tables created when this setting is enabled are not checkpointed to disk (although table schema files are created). The setting in effect when the table is created with or altered to use NDBCLUSTER persists for the lifetime of the table.',
    'dynamic': True,
    'name': 'ndb_table_no_logging'},
  { 'description': 'NDB tables are not persistent on disk: no schema files are created and the tables are not logged',
    'dynamic': True,
    'name': 'ndb_table_temporary'},
  { 'description': 'Use copying ALTER TABLE operations in MySQL Cluster',
    'dynamic': False,
    'name': 'ndb_use_copying_alter_table'},
  { 'description': 'Use exact row count when planning queries',
    'dynamic': True,
    'name': 'ndb_use_exact_count'},
  { 'description': 'Forces NDB to use a count of records during SELECT COUNT(*) query planning to speed up this type of query',
    'dynamic': True,
    'name': 'ndb_use_transactions'},
  { 'description': 'Shows build and NDB engine version as an integer.',
    'dynamic': False,
    'name': 'ndb_version'},
  { 'description': 'Shows build information including NDB engine version in ndb-x.y.z format.',
    'dynamic': False,
    'name': 'ndb_version_string'},
  { 'description': 'The name used for the NDB information database; read only.',
    'dynamic': False,
    'name': 'ndbinfo_database'},
  { 'description': 'Used for debugging only.',
    'dynamic': True,
    'name': 'ndbinfo_max_bytes'},
  { 'description': 'Used for debugging only.',
    'dynamic': True,
    'name': 'ndbinfo_max_rows'},
  { 'description': 'Put the ndbinfo database into offline mode, in which no rows are returned from tables or views.',
    'dynamic': True,
    'name': 'ndbinfo_offline'},
  { 'description': 'Whether to show ndbinfo internal base tables in the mysql client. The default is OFF.',
    'dynamic': True,
    'name': 'ndbinfo_show_hidden'},
  { 'description': 'The prefix to use for naming ndbinfo internal base tables',
    'dynamic': True,
    'name': 'ndbinfo_table_prefix'},
  { 'description': 'The version of the ndbinfo engine; read only.',
    'dynamic': False,
    'name': 'ndbinfo_version'},
  { 'description': 'Buffer length for TCP/IP and socket communication',
    'dynamic': True,
    'name': 'net_buffer_length'},
  { 'description': 'Number of seconds to wait for more data from a connection before aborting the read',
    'dynamic': True,
    'name': 'net_read_timeout'},
  { 'description': 'Number of times to retry an interrupted read or write on a communication port before giving up',
    'dynamic': True,
    'name': 'net_retry_count'},
  { 'description': 'Number of seconds to wait for a block to be written to a connection before aborting the write',
    'dynamic': True,
    'name': 'net_write_timeout'},
  { 'description': "Use very new, possibly 'unsafe' functions",
    'dynamic': True,
    'name': 'new'},
  { 'description': 'Defines the n-gram token size for the InnoDB Full-Text Search n-gram parser.',
    'dynamic': False,
    'name': 'ngram_token_size'},
  { 'description': 'Whether server is offline',
    'dynamic': True,
    'name': 'offline_mode'},
  { 'description': 'Cause the server to revert to certain behaviors present in older versions',
    'dynamic': False,
    'name': 'old'},
  { 'description': 'Use old, nonoptimized alter table',
    'dynamic': True,
    'name': 'old-alter-table'},
  { 'description': 'Selects password hashing method for PASSWORD()',
    'dynamic': True,
    'name': 'old_passwords'},
  { 'description': 'If this is not 0, then mysqld will use this value to reserve file descriptors to use with setrlimit()',
    'dynamic': False,
    'name': 'open-files-limit'},
  { 'description': 'How join buffers are used',
    'dynamic': True,
    'name': 'optimizer_join_cache_level'},
  { 'description': 'Controls the heuristic(s) applied during query optimization to prune less-promising partial plans from the optimizer search space',
    'dynamic': True,
    'name': 'optimizer_prune_level'},
  { 'description': 'Maximum depth of search performed by the query optimizer',
    'dynamic': True,
    'name': 'optimizer_search_depth'},
  { 'description': 'Enable control over which optimizations to use',
    'dynamic': True,
    'name': 'optimizer_switch'},
  { 'description': 'Control optimizer tracing',
    'dynamic': True,
    'name': 'optimizer_trace'},
  { 'description': 'Control optimizer tracing',
    'dynamic': True,
    'name': 'optimizer_trace_features'},
  { 'description': 'Control optimizer tracing',
    'dynamic': True,
    'name': 'optimizer_trace_limit'},
  { 'description': 'Control optimizer tracing',
    'dynamic': True,
    'name': 'optimizer_trace_max_mem_size'},
  { 'description': 'Control optimizer tracing',
    'dynamic': True,
    'name': 'optimizer_trace_offset'},
  { 'description': 'How the optimizer reads multiple ranges of index tuples',
    'dynamic': True,
    'name': 'optimizer_use_mrr'},
  { 'description': 'Maximum amount of memory available to parser',
    'dynamic': True,
    'name': 'parser_max_mem_size'},
  { 'description': 'Whether Performance Schema is enabled',
    'dynamic': False,
    'name': 'performance_schema'},
  { 'description': 'Number of rows in the accounts table',
    'dynamic': False,
    'name': 'performance_schema_accounts_size'},
  { 'description': 'Number of rows in the events_statements_summary_by_digest table',
    'dynamic': False,
    'name': 'performance_schema_digests_size'},
  { 'description': 'Number of instrumented errors',
    'dynamic': False,
    'name': 'performance_schema_error_size'},
  { 'description': 'Number of rows in the events_stages_history_long table',
    'dynamic': False,
    'name': 'performance_schema_events_stages_history_long_size'},
  { 'description': 'Number of rows per thread in the events_stages_history table',
    'dynamic': False,
    'name': 'performance_schema_events_stages_history_size'},
  { 'description': 'Number of rows in the events_statements_history_long table',
    'dynamic': False,
    'name': 'performance_schema_events_statements_history_long_size'},
  { 'description': 'Number of rows per thread in the events_statements_history table',
    'dynamic': False,
    'name': 'performance_schema_events_statements_history_size'},
  { 'description': 'Number of rows in the events_transactions_history_long table',
    'dynamic': False,
    'name': 'performance_schema_events_transactions_history_long_size'},
  { 'description': 'Number of rows per thread in the events_transactions_history table',
    'dynamic': False,
    'name': 'performance_schema_events_transactions_history_size'},
  { 'description': 'Number of rows in the events_waits_history_long table',
    'dynamic': False,
    'name': 'performance_schema_events_waits_history_long_size'},
  { 'description': 'Number of rows per thread in the events_waits_history table',
    'dynamic': False,
    'name': 'performance_schema_events_waits_history_size'},
  { 'description': 'Number of rows in the hosts table',
    'dynamic': False,
    'name': 'performance_schema_hosts_size'},
  { 'description': 'The maximum number of condition instruments',
    'dynamic': False,
    'name': 'performance_schema_max_cond_classes'},
  { 'description': 'The maximum number of instrumented condition objects',
    'dynamic': False,
    'name': 'performance_schema_max_cond_instances'},
  { 'description': 'The maximum Performance Schema digest size in bytes',
    'dynamic': False,
    'name': 'performance_schema_max_digest_length'},
  { 'description': 'The maximum number of file instruments',
    'dynamic': False,
    'name': 'performance_schema_max_file_classes'},
  { 'description': 'The maximum number of opened file objects',
    'dynamic': False,
    'name': 'performance_schema_max_file_handles'},
  { 'description': 'The maximum number of instrumented file objects',
    'dynamic': False,
    'name': 'performance_schema_max_file_instances'},
  { 'description': 'Maximum number of indexes to keep statistics for',
    'dynamic': False,
    'name': 'performance_schema_max_index_stat'},
  { 'description': 'The maximum number of memory instruments',
    'dynamic': False,
    'name': 'performance_schema_max_memory_classes'},
  { 'description': 'The maximum number of metadata locks to track',
    'dynamic': False,
    'name': 'performance_schema_max_metadata_locks'},
  { 'description': 'The maximum number of mutex instruments',
    'dynamic': False,
    'name': 'performance_schema_max_mutex_classes'},
  { 'description': 'The maximum number of instrumented mutex objects',
    'dynamic': False,
    'name': 'performance_schema_max_mutex_instances'},
  { 'description': 'Number of rows in the prepared_statements_instances table',
    'dynamic': False,
    'name': 'performance_schema_max_prepared_statements_instances'},
  { 'description': 'The maximum number of stored programs for statistics',
    'dynamic': False,
    'name': 'performance_schema_max_program_instances'},
  { 'description': 'The maximum number of rwlock instruments',
    'dynamic': False,
    'name': 'performance_schema_max_rwlock_classes'},
  { 'description': 'The maximum number of instrumented rwlock objects',
    'dynamic': False,
    'name': 'performance_schema_max_rwlock_instances'},
  { 'description': 'The maximum number of socket instruments',
    'dynamic': False,
    'name': 'performance_schema_max_socket_classes'},
  { 'description': 'The maximum number of instrumented socket objects',
    'dynamic': False,
    'name': 'performance_schema_max_socket_instances'},
  { 'description': 'The maximum number of bytes stored from SQL statements',
    'dynamic': False,
    'name': 'performance_schema_max_sql_text_length'},
  { 'description': 'The maximum number of stage instruments',
    'dynamic': False,
    'name': 'performance_schema_max_stage_classes'},
  { 'description': 'The maximum number of statement instruments',
    'dynamic': False,
    'name': 'performance_schema_max_statement_classes'},
  { 'description': 'The maximum stored program nesting for statistics',
    'dynamic': False,
    'name': 'performance_schema_max_statement_stack'},
  { 'description': 'The maximum number of opened table objects',
    'dynamic': False,
    'name': 'performance_schema_max_table_handles'},
  { 'description': 'The maximum number of instrumented table objects',
    'dynamic': False,
    'name': 'performance_schema_max_table_instances'},
  { 'description': 'Maximum number of tables to keep lock statistics for',
    'dynamic': False,
    'name': 'performance_schema_max_table_lock_stat'},
  { 'description': 'The maximum number of thread instruments',
    'dynamic': False,
    'name': 'performance_schema_max_thread_classes'},
  { 'description': 'The maximum number of instrumented thread objects',
    'dynamic': False,
    'name': 'performance_schema_max_thread_instances'},
  { 'description': 'Size of the connection attribute strings buffer per thread',
    'dynamic': False,
    'name': 'performance_schema_session_connect_attrs_size'},
  { 'description': 'Number of rows in the setup_actors table',
    'dynamic': False,
    'name': 'performance_schema_setup_actors_size'},
  { 'description': 'Number of rows in the setup_objects table',
    'dynamic': False,
    'name': 'performance_schema_setup_objects_size'},
  { 'description': 'Number of rows in the users table',
    'dynamic': False,
    'name': 'performance_schema_users_size'},
  { 'description': 'Whether to load persisted configuration settings',
    'dynamic': False,
    'name': 'persisted_globals_load'},
  { 'description': 'Process ID file used by mysqld_safe',
    'dynamic': False,
    'name': 'pid-file'},
  { 'description': 'Directory for plugins',
    'dynamic': False,
    'name': 'plugin_dir'},
  { 'description': 'Port number on which to listen for TCP/IP connections',
    'dynamic': False,
    'name': 'port'},
  { 'description': 'Size of buffer that is allocated when preloading indexes',
    'dynamic': True,
    'name': 'preload_buffer_size'},
  { 'description': 'The current number of prepared statements',
    'dynamic': False,
    'name': 'prepared_stmt_count'},
  { 'description': 'Enable or disable statement profiling',
    'dynamic': True,
    'name': 'profiling'},
  { 'description': 'How many statements to maintain profiling information for',
    'dynamic': True,
    'name': 'profiling_history_size'},
  { 'description': 'The version of the client/server protocol used by the MySQL server',
    'dynamic': False,
    'name': 'protocol_version'},
  { 'description': 'The user proxied by the external proxy user',
    'dynamic': False,
    'name': 'proxy_user'},
  { 'description': 'For internal server use',
    'dynamic': True,
    'name': 'pseudo_slave_mode'},
  { 'description': 'For internal server use',
    'dynamic': True,
    'name': 'pseudo_thread_id'},
  { 'description': 'Allocation block size for query parsing and execution',
    'dynamic': True,
    'name': 'query_alloc_block_size'},
  { 'description': 'Do not cache results that are bigger than this',
    'dynamic': True,
    'name': 'query_cache_limit'},
  { 'description': 'Minimal size of unit in which space for results is allocated (last unit will be trimmed after writing all result data)',
    'dynamic': True,
    'name': 'query_cache_min_res_unit'},
  { 'description': 'The memory allocated to store results from old queries',
    'dynamic': True,
    'name': 'query_cache_size'},
  { 'description': 'Query cache type',
    'dynamic': True,
    'name': 'query_cache_type'},
  { 'description': 'Invalidate queries in query cache on LOCK for write',
    'dynamic': True,
    'name': 'query_cache_wlock_invalidate'},
  { 'description': 'Persistent buffer for query parsing and execution',
    'dynamic': True,
    'name': 'query_prealloc_size'},
  { 'description': 'Used to support replication of the RAND() function',
    'dynamic': True,
    'name': 'rand_seed1'},
  { 'description': 'Used to support replication of the RAND() function',
    'dynamic': True,
    'name': 'rand_seed2'},
  { 'description': 'Allocation block size for storing ranges during optimization',
    'dynamic': True,
    'name': 'range_alloc_block_size'},
  { 'description': 'Limit on range optimizer memory consumption',
    'dynamic': True,
    'name': 'range_optimizer_max_mem_size'},
  { 'description': 'Allows for switching the server between IDEMPOTENT mode (key and some other errors suppressed) and STRICT mode; STRICT mode is the default.',
    'dynamic': True,
    'name': 'rbr_exec_mode'},
  { 'description': 'Each thread that does a sequential scan for a MyISAM table allocates a buffer of this size for each table it scans',
    'dynamic': True,
    'name': 'read_buffer_size'},
  { 'description': 'Prevent client updates except from clients with SUPER',
    'dynamic': True,
    'name': 'read_only'},
  { 'description': 'When reading rows from a MyISAM table in sorted order after a sort, the rows are read through this buffer to avoid a disk seeks. If not set, then it is set to the value of record_buffer.',
    'dynamic': True,
    'name': 'read_rnd_buffer_size'},
  { 'description': 'The location and base name to use for relay logs',
    'dynamic': False,
    'name': 'relay-log'},
  { 'description': 'The location and name to use for the file that keeps a list of the last relay logs',
    'dynamic': False,
    'name': 'relay-log-index'},
  { 'description': 'Complete path to relay log, including filename',
    'dynamic': False,
    'name': 'relay_log_basename'},
  { 'description': 'The name of the relay log index file',
    'dynamic': False,
    'name': 'relay_log_index'},
  { 'description': 'The name of the file in which the slave records information about the relay logs',
    'dynamic': False,
    'name': 'relay_log_info_file'},
  { 'description': "Whether to write the replication SQL thread's location in the relay logs to a file or a table",
    'dynamic': True,
    'name': 'relay_log_info_repository'},
  { 'description': 'Determines whether relay logs are purged',
    'dynamic': True,
    'name': 'relay_log_purge'},
  { 'description': 'Whether automatic recovery of relay log files from master at startup is enabled; must be enabled for a crash-safe slave.',
    'dynamic': True,
    'name': 'relay_log_recovery'},
  { 'description': 'Maximum space to use for all relay logs',
    'dynamic': False,
    'name': 'relay_log_space_limit'},
  { 'description': 'Host name or IP of the slave to be reported to the master during slave registration',
    'dynamic': False,
    'name': 'report-host'},
  { 'description': 'An arbitrary password that the slave server should report to the master. Not the same as the password for the MySQL replication user account.',
    'dynamic': False,
    'name': 'report-password'},
  { 'description': 'Port for connecting to slave reported to the master during slave registration',
    'dynamic': False,
    'name': 'report-port'},
  { 'description': 'An arbitrary user name that a slave server should report to the master. Not the same as the name used with the MySQL replication user account.',
    'dynamic': False,
    'name': 'report-user'},
  { 'description': 'Whether client connections must use secure transport',
    'dynamic': True,
    'name': 'require_secure_transport'},
  { 'description': 'Whether RESTORE disables restored events',
    'dynamic': True,
    'name': 'restore_disables_events'},
  { 'description': 'Enable or disable RESTORE privilege elevation',
    'dynamic': False,
    'name': 'restore_elevation'},
  { 'description': 'Whether RESTORE performs privilege checking before restoring',
    'dynamic': True,
    'name': 'restore_precheck'},
  { 'description': 'Whether the example query rewrite plugin is enabled',
    'dynamic': True,
    'name': 'rewriter_enabled'},
  { 'description': 'For internal use',
    'dynamic': True,
    'name': 'rewriter_verbose'},
  { 'description': 'Not used; removed in later versions',
    'dynamic': True,
    'name': 'rpl_recovery_rank'},
  { 'description': 'Whether semisynchronous replication is enabled on the master',
    'dynamic': True,
    'name': 'rpl_semi_sync_master_enabled'},
  { 'description': 'Internal use',
    'dynamic': True,
    'name': 'rpl_semi_sync_master_reply_log_file_pos'},
  { 'description': 'Number of milliseconds to wait for slave acknowledgment',
    'dynamic': True,
    'name': 'rpl_semi_sync_master_timeout'},
  { 'description': 'The semisynchronous replication debug trace level on the master',
    'dynamic': True,
    'name': 'rpl_semi_sync_master_trace_level'},
  { 'description': 'How many slave acknowledgments the master must receive per transaction before proceeding',
    'dynamic': True,
    'name': 'rpl_semi_sync_master_wait_for_slave_count'},
  { 'description': 'Whether master waits for timeout even with no slaves',
    'dynamic': True,
    'name': 'rpl_semi_sync_master_wait_no_slave'},
  { 'description': 'The wait point for slave transaction receipt acknowledgment',
    'dynamic': True,
    'name': 'rpl_semi_sync_master_wait_point'},
  { 'description': 'Whether semisynchronous replication is enabled on slave',
    'dynamic': True,
    'name': 'rpl_semi_sync_slave_enabled'},
  { 'description': 'The semisynchronous replication debug trace level on the slave',
    'dynamic': True,
    'name': 'rpl_semi_sync_slave_trace_level'},
  { 'description': 'Set the number of seconds that STOP SLAVE waits before timing out.',
    'dynamic': True,
    'name': 'rpl_stop_slave_timeout'},
  { 'description': 'Deprecated option; use GRANT SHOW DATABASES instead',
    'dynamic': True,
    'name': 'safe-show-database'},
  { 'description': 'Defines the number of schema definition objects that can be kept in the dictionary object cache',
    'dynamic': True,
    'name': 'schema_definition_cache'},
  { 'description': 'Disallow authentication for accounts that have old (pre-4.1) passwords',
    'dynamic': True,
    'name': 'secure-auth'},
  { 'description': 'Limit BACKUP DATABASE and RESTORE to files in a single directory',
    'dynamic': False,
    'name': 'secure-backup-file-priv'},
  { 'description': 'Limit LOAD DATA, and SELECT ... INTO OUTFILE, and LOAD_FILE() to files in specified directory',
    'dynamic': False,
    'name': 'secure-file-priv'},
  { 'description': 'Uniquely identifies the server instance in the community of replication partners. Must be set to a value greater than 0 to enable replication.',
    'dynamic': True,
    'name': 'server-id'},
  { 'description': 'Sets the number of least significant bits in the server_id actually used for identifying the server, permitting NDB API applications to store application data in the most significant bits. server_id must be less than 2 to the power of this value.',
    'dynamic': False,
    'name': 'server-id-bits'},
  { 'description': 'The effective value of server_id if the server was started with the --server-id-bits option set to a nondefault value.',
    'dynamic': False,
    'name': 'server_id_bits'},
  { 'description': "The server's globally unique ID, automatically (re)generated at server start",
    'dynamic': False,
    'name': 'server_uuid'},
  { 'description': 'Enables a tracker which can be configured to track different GTIDs.',
    'dynamic': True,
    'name': 'session_track_gtids'},
  { 'description': 'Whether to track schema changes',
    'dynamic': True,
    'name': 'session_track_schema'},
  { 'description': 'Whether to track session state changes',
    'dynamic': True,
    'name': 'session_track_state_change'},
  { 'description': 'Session variables to track changes for',
    'dynamic': True,
    'name': 'session_track_system_variables'},
  { 'description': 'Whether to autogenerate RSA key-pair files',
    'dynamic': False,
    'name': 'sha256_password_auto_generate_rsa_keys'},
  { 'description': 'The SHA2 password plugin private key path name',
    'dynamic': False,
    'name': 'sha256_password_private_key_path'},
  { 'description': 'Whether the sha256_password authentication plugin does proxying',
    'dynamic': True,
    'name': 'sha256_password_proxy_users'},
  { 'description': 'The SHA2 password plugin public key path name',
    'dynamic': False,
    'name': 'sha256_password_public_key_path'},
  { 'description': 'Whether the server allows shared-memory connections',
    'dynamic': False,
    'name': 'shared_memory'},
  { 'description': 'The name of shared memory to use for shared-memory connections',
    'dynamic': False,
    'name': 'shared_memory_base_name'},
  { 'description': 'Compatibility for SHOW STATUS/VARIABLES',
    'dynamic': True,
    'name': 'show_compatibility_56'},
  { 'description': 'Whether SHOW CREATE TABLE should indicate pre-5.6.4 temporal columns',
    'dynamic': True,
    'name': 'show_old_temporals'},
  { 'description': 'Controls how binary logs are iterated during GTID recovery',
    'dynamic': False,
    'name': 'simplified_binlog_gtid_recovery'},
  { 'description': "Do not resolve host names. All host names are IPs or 'localhost'",
    'dynamic': False,
    'name': 'skip-name-resolve'},
  { 'description': 'Do not allow connection with TCP/IP',
    'dynamic': False,
    'name': 'skip-networking'},
  { 'description': 'Do not allow SHOW DATABASE statements',
    'dynamic': False,
    'name': 'skip-show-database'},
  { 'description': 'Disables synchronous BDB log flushes',
    'dynamic': False,
    'name': 'skip-sync-bdb-logs'},
  { 'description': 'Skip system (external) locking',
    'dynamic': False,
    'name': 'skip_external_locking'},
  { 'description': 'The location where the slave should put its temporary files when replicating a LOAD DATA INFILE statement',
    'dynamic': False,
    'name': 'slave-load-tmpdir'},
  { 'description': 'Number of seconds to wait for more data from a master/slave connection before aborting the read',
    'dynamic': True,
    'name': 'slave-net-timeout'},
  { 'description': 'Tells the slave thread to continue replication when a query returns an error from the provided list',
    'dynamic': False,
    'name': 'slave-skip-errors'},
  { 'description': 'Turns update batching on and off for a replication slave',
    'dynamic': True,
    'name': 'slave_allow_batching'},
  { 'description': 'Maximum number of transactions processed by a multi-threaded slave before a checkpoint operation is called to update progress status. Not supported by MySQL Cluster.',
    'dynamic': True,
    'name': 'slave_checkpoint_group'},
  { 'description': 'Update progress status of multi-threaded slave and flush relay log info to disk after this number of milliseconds. Not supported by MySQL Cluster.',
    'dynamic': True,
    'name': 'slave_checkpoint_period'},
  { 'description': 'Use compression on master/slave protocol',
    'dynamic': True,
    'name': 'slave_compressed_protocol'},
  { 'description': 'Allows for switching the slave thread between IDEMPOTENT mode (key and some other errors suppressed) and STRICT mode; STRICT mode is the default, except for MySQL Cluster, where IDEMPOTENT is always used',
    'dynamic': True,
    'name': 'slave_exec_mode'},
  { 'description': 'Maximum size, in bytes, of a packet that can be sent from a replication master to a slave; overrides max_allowed_packet.',
    'dynamic': True,
    'name': 'slave_max_allowed_packet'},
  { 'description': 'Tells the slave to use database partioning (DATABASE) or information (LOGICAL_CLOCK) from master to parallelize transactions. The default is DATABASE.',
    'dynamic': True,
    'name': 'slave_parallel_type'},
  { 'description': 'Number of worker threads for executing events in parallel. Set to 0 (the default) to disable slave multi-threading. Not supported by MySQL Cluster.',
    'dynamic': True,
    'name': 'slave_parallel_workers'},
  { 'description': 'Maximum size of slave worker queues holding events not yet applied.',
    'dynamic': True,
    'name': 'slave_pending_jobs_size_max'},
  { 'description': 'Ensures that all commits by slave workers happen in the same order as on the master to maintain consistency when using parallel worker threads.',
    'dynamic': True,
    'name': 'slave_preserve_commit_order'},
  { 'description': 'Determines search algorithms used for slave update batching. Any 2 or 3 from the list INDEX_SEARCH, TABLE_SCAN, HASH_SCAN; the default is TABLE_SCAN,INDEX_SCAN.',
    'dynamic': True,
    'name': 'slave_rows_search_algorithms'},
  { 'description': 'Cause slave to examine checksums when reading from relay log.',
    'dynamic': True,
    'name': 'slave_sql_verify_checksum'},
  { 'description': 'Number of times the slave SQL thread will retry a transaction in case it failed with a deadlock or elapsed lock wait timeout, before giving up and stopping',
    'dynamic': True,
    'name': 'slave_transaction_retries'},
  { 'description': 'Controls type conversion mode on replication slave. Value is a list of zero or more elements from the list: ALL_LOSSY, ALL_NON_LOSSY. Set to an empty string to disallow type conversions between master and slave.',
    'dynamic': False,
    'name': 'slave_type_conversions'},
  { 'description': 'Enable|disable slow query log',
    'dynamic': True,
    'name': 'slow-query-log'},
  { 'description': 'If creating the thread takes longer than this value (in seconds), the Slow_launch_threads counter will be incremented',
    'dynamic': True,
    'name': 'slow_launch_time'},
  { 'description': 'Name of the slow query log file',
    'dynamic': True,
    'name': 'slow_query_log_file'},
  { 'description': 'Socket file on which to listen for Unix socket connections',
    'dynamic': False,
    'name': 'socket'},
  { 'description': 'Each thread that needs to do a sort allocates a buffer of this size',
    'dynamic': True,
    'name': 'sort_buffer_size'},
  { 'description': 'Set the SQL server mode',
    'dynamic': True,
    'name': 'sql-mode'},
  { 'description': 'If set to 1, you can find the last inserted row for a table that contains an AUTO_INCREMENT column by using the following construct: WHERE auto_increment_column IS NULL',
    'dynamic': True,
    'name': 'sql_auto_is_null'},
  { 'description': 'If set to 0, MySQL aborts SELECT statements that are likely to take a very long time to execute',
    'dynamic': True,
    'name': 'sql_big_selects'},
  { 'description': 'This variable is deprecated, and is mapped to big_tables',
    'dynamic': True,
    'name': 'sql_big_tables'},
  { 'description': 'Forces the result to be put into a temporary table',
    'dynamic': True,
    'name': 'sql_buffer_result'},
  { 'description': 'Toggle binary logging',
    'dynamic': True,
    'name': 'sql_log_bin'},
  { 'description': 'If set to 1, no logging is done to the general query log for this client',
    'dynamic': True,
    'name': 'sql_log_off'},
  { 'description': 'This variable is deprecated, and is mapped to SQL_LOG_BIN',
    'dynamic': True,
    'name': 'sql_log_update'},
  { 'description': 'This variable is deprecated, and is mapped to low_priority_updates',
    'dynamic': True,
    'name': 'sql_low_priority_updates'},
  { 'description': 'This variable is deprecated, and is mapped to max_join_size',
    'dynamic': True,
    'name': 'sql_max_join_size'},
  { 'description': 'If set to 1, warnings of Note level are recorded',
    'dynamic': True,
    'name': 'sql_notes'},
  { 'description': 'If set to 1 the server quotes identifiers for SHOW CREATE TABLE and SHOW CREATE DATABASE statements',
    'dynamic': True,
    'name': 'sql_quote_show_create'},
  { 'description': 'If set to 1, MySQL aborts UPDATE or DELETE statements that do not use a key in the WHERE clause or a LIMIT clause',
    'dynamic': True,
    'name': 'sql_safe_updates'},
  { 'description': 'The maximum number of rows to return from SELECT statements',
    'dynamic': True,
    'name': 'sql_select_limit'},
  { 'description': 'Number of events from the master that a slave server should skip. Not compatible with GTID replication.',
    'dynamic': True,
    'name': 'sql_slave_skip_counter'},
  { 'description': 'This variable controls whether single-row INSERT statements produce an information string if warnings occur',
    'dynamic': True,
    'name': 'sql_warnings'},
  { 'description': 'Path of file that contains list of trusted SSL CAs',
    'dynamic': False,
    'name': 'ssl-ca'},
  { 'description': 'Path of directory that contains trusted SSL CA certificates in PEM format',
    'dynamic': False,
    'name': 'ssl-capath'},
  { 'description': 'Path of file that contains X509 certificate in PEM format',
    'dynamic': False,
    'name': 'ssl-cert'},
  { 'description': 'List of permitted ciphers to use for connection encryption',
    'dynamic': False,
    'name': 'ssl-cipher'},
  { 'description': 'Path of file that contains certificate revocation lists',
    'dynamic': False,
    'name': 'ssl-crl'},
  { 'description': 'Path of directory that contains certificate revocation list files',
    'dynamic': False,
    'name': 'ssl-crlpath'},
  { 'description': 'Path of file that contains X509 key in PEM format',
    'dynamic': False,
    'name': 'ssl-key'},
  { 'description': 'The default storage engine',
    'dynamic': True,
    'name': 'storage_engine'},
  { 'description': 'Sets a "soft" upper limit for number of cached stored routines per connection. Stored procedures and stored functions are cached separately; this variable sets size for both of these.',
    'dynamic': True,
    'name': 'stored_program_cache'},
  { 'description': 'Defines the number of stored program and event definition objects that can be kept in the dictionary object cache',
    'dynamic': True,
    'name': 'stored_program_definition_cache'},
  { 'description': 'Whether to ignore SUPER exceptions to read-only mode',
    'dynamic': True,
    'name': 'super_read_only'},
  { 'description': 'Synchronously flush Berkeley DB logs. Enabled by default',
    'dynamic': False,
    'name': 'sync-bdb-logs'},
  { 'description': 'Synchronously flush binary log to disk after every #th event',
    'dynamic': True,
    'name': 'sync_binlog'},
  { 'description': 'Sync .frm to disk on create. Enabled by default',
    'dynamic': True,
    'name': 'sync_frm'},
  { 'description': 'Synchronize master.info to disk after every #th event.',
    'dynamic': True,
    'name': 'sync_master_info'},
  { 'description': 'Synchronize relay log to disk after every #th event.',
    'dynamic': True,
    'name': 'sync_relay_log'},
  { 'description': 'Synchronize relay.info file to disk after every #th event.',
    'dynamic': True,
    'name': 'sync_relay_log_info'},
  { 'description': 'The server system time zone',
    'dynamic': False,
    'name': 'system_time_zone'},
  { 'description': 'Defines the number of tablespace definition objects that can be kept in the dictionary object cache',
    'dynamic': True,
    'name': 'tablespace_definition_cache'},
  { 'description': 'Number of open tables for all threads',
    'dynamic': True,
    'name': 'table_cache'},
  { 'description': 'Number of table definitions that can be stored in the definition cache.',
    'dynamic': True,
    'name': 'table_definition_cache'},
  { 'description': 'Currently unused',
    'dynamic': True,
    'name': 'table_lock_wait_timeout'},
  { 'description': 'Number of open tables for all threads',
    'dynamic': True,
    'name': 'table_open_cache'},
  { 'description': 'Number of open tables cache instances',
    'dynamic': False,
    'name': 'table_open_cache_instances'},
  { 'description': 'A synonym for storage_engine',
    'dynamic': True,
    'name': 'table_type'},
  { 'description': 'How many threads we should keep in a cache for reuse',
    'dynamic': True,
    'name': 'thread_cache_size'},
  { 'description': 'Permits the application to give the threads system a hint for the desired number of threads that should be run at the same time',
    'dynamic': False,
    'name': 'thread_concurrency'},
  { 'description': 'The thread-handling model',
    'dynamic': False,
    'name': 'thread_handling'},
  { 'description': 'The thread pool algorithm',
    'dynamic': False,
    'name': 'thread_pool_algorithm'},
  { 'description': 'Whether the current session is high priority',
    'dynamic': True,
    'name': 'thread_pool_high_priority_connection'},
  { 'description': 'The maximum permitted number of unused threads',
    'dynamic': True,
    'name': 'thread_pool_max_unused_threads'},
  { 'description': 'How long before a statement is moved to high-priority execution',
    'dynamic': True,
    'name': 'thread_pool_prio_kickup_timer'},
  { 'description': 'Number of thread groups in the thread pool',
    'dynamic': False,
    'name': 'thread_pool_size'},
  { 'description': 'How long before a statement is defined as stalled',
    'dynamic': True,
    'name': 'thread_pool_stall_limit'},
  { 'description': 'The stack size for each thread',
    'dynamic': False,
    'name': 'thread_stack'},
  { 'description': 'The TIME format (unused)',
    'dynamic': False,
    'name': 'time_format'},
  { 'description': 'The current time zone.',
    'dynamic': True,
    'name': 'time_zone'},
  { 'description': 'Specify whether to time mutexes (only InnoDB mutexes are currently supported)',
    'dynamic': True,
    'name': 'timed_mutexes'},
  { 'description': 'Change the value returned by NOW()',
    'dynamic': True,
    'name': 'timestamp'},
  { 'description': 'Protocols permitted for secure connections',
    'dynamic': False,
    'name': 'tls_version'},
  { 'description': 'If an in-memory temporary table exceeds this size, MySQL will automatically convert it to an on-disk MyISAM table',
    'dynamic': True,
    'name': 'tmp_table_size'},
  { 'description': 'Path for temporary files',
    'dynamic': False,
    'name': 'tmpdir'},
  { 'description': 'Allocation block size for transactions to be stored in binary log',
    'dynamic': True,
    'name': 'transaction_alloc_block_size'},
  { 'description': 'Allows batching of statements within a transaction. Disable AUTOCOMMIT to use.',
    'dynamic': True,
    'name': 'transaction_allow_batching'},
  { 'description': 'Persistent buffer for transactions to be stored in binary log',
    'dynamic': True,
    'name': 'transaction_prealloc_size'},
  { 'description': 'Reserved for future use.',
    'dynamic': True,
    'name': 'transaction_write_set_extraction'},
  { 'description': 'The default transaction isolation level',
    'dynamic': True,
    'name': 'tx_isolation'},
  { 'description': 'Default transaction access mode',
    'dynamic': True,
    'name': 'tx_read_only'},
  { 'description': 'If set to 1 (the default), uniqueness checks for secondary indexes in InnoDB tables are performed',
    'dynamic': True,
    'name': 'unique_checks'},
  { 'description': 'This variable controls whether updates to a view can be made when the view does not contain all columns of the primary key',
    'dynamic': True,
    'name': 'updatable_views_with_limit'},
  { 'description': 'Whether to check passwords against user name',
    'dynamic': True,
    'name': 'validate_password_check_user_name'},
  { 'description': 'validate_password dictionary file',
    'dynamic': True,
    'name': 'validate_password_dictionary_file'},
  { 'description': 'validate_password required password length',
    'dynamic': True,
    'name': 'validate_password_length'},
  { 'description': 'validate_password required number of uppercase/lowercase characters',
    'dynamic': True,
    'name': 'validate_password_mixed_case_count'},
  { 'description': 'validate_password required number of digit characters',
    'dynamic': True,
    'name': 'validate_password_number_count'},
  { 'description': 'validate_password password policy',
    'dynamic': True,
    'name': 'validate_password_policy'},
  { 'description': 'validate_password required number of special characters',
    'dynamic': True,
    'name': 'validate_password_special_char_count'},
  { 'description': 'Whether to perform additional validation of user plugins',
    'dynamic': False,
    'name': 'validate_user_plugins'},
  { 'description': 'Output version information and exit',
    'dynamic': False,
    'name': 'version'},
  { 'description': 'This variable contains the value of the --with-comment option specified when building MySQL',
    'dynamic': False,
    'name': 'version_comment'},
  { 'description': 'The type of machine or architecture on which MySQL was built',
    'dynamic': False,
    'name': 'version_compile_machine'},
  { 'description': 'The type of operating system on which MySQL was built',
    'dynamic': False,
    'name': 'version_compile_os'},
  { 'description': 'Client token list for Version Tokens',
    'dynamic': True,
    'name': 'version_tokens_session'},
  { 'description': 'For internal use',
    'dynamic': False,
    'name': 'version_tokens_session_number'},
  { 'description': 'Number of seconds the server waits for activity on a connection before closing it',
    'dynamic': True,
    'name': 'wait_timeout'},
  { 'description': 'Number of warnings',
    'dynamic': False,
    'name': 'warning_count'}]


status_vars_list =[ { 'description': 'The number of bytes sent through the network.',
    'dynamic': False,
    'name': 'Mysqlx_bytes_sent'},
  { 'description': 'The number of bytes received through the network.',
    'dynamic': False,
    'name': 'Mysqlx_bytes_received'},
  { 'description': 'The number of StmtExecute requests received for the SQL namespace.',
    'dynamic': False,
    'name': 'Mysqlx_stmt_execute_sql'},
  { 'description': 'The number of StmtExecute requests received for the X Plugin namespace.',
    'dynamic': False,
    'name': 'Mysqlx_stmt_execute_xplugin'},
  { 'description': 'The number of create collection statements received.',
    'dynamic': False,
    'name': 'Mysqlx_stmt_create_collection'},
  { 'description': 'The number of create collection index statements received.',
    'dynamic': False,
    'name': 'Mysqlx_stmt_create_collection_index'},
  { 'description': 'The number of drop collection statements received.',
    'dynamic': False,
    'name': 'Mysqlx_stmt_drop_collection'},
  { 'description': 'The number of drop collection index statements received.',
    'dynamic': False,
    'name': 'Mysqlx_stmt_drop_collection_index'},
  { 'description': 'The number of list object statements received.',
    'dynamic': False,
    'name': 'Mysqlx_stmt_list_objects'},
  { 'description': 'The number of enable notice statements received.',
    'dynamic': False,
    'name': 'Mysqlx_stmt_enable_notices'},
  { 'description': 'The number of disable notice statements received.',
    'dynamic': False,
    'name': 'Mysqlx_stmt_disable_notices'},
  { 'description': 'The number of list notice statements received.',
    'dynamic': False,
    'name': 'Mysqlx_stmt_list_notices'},
  { 'description': 'The number of list client statements received.',
    'dynamic': False,
    'name': 'Mysqlx_stmt_list_clients'},
  { 'description': 'The number of kill client statements received.',
    'dynamic': False,
    'name': 'Mysqlx_stmt_kill_client'},
  { 'description': 'The number of ping statements received.',
    'dynamic': False,
    'name': 'Mysqlx_stmt_ping'},
  { 'description': 'The number of insert requests received.',
    'dynamic': False,
    'name': 'Mysqlx_crud_insert'},
  { 'description': 'The number of update requests received.',
    'dynamic': False,
    'name': 'Mysqlx_crud_update'},
  { 'description': 'The number of delete requests received.',
    'dynamic': False,
    'name': 'Mysqlx_crud_delete'},
  { 'description': 'The number of find requests received.',
    'dynamic': False,
    'name': 'Mysqlx_crud_find'},
  { 'description': 'The number of expectation blocks opened.',
    'dynamic': False,
    'name': 'Mysqlx_expect_open'},
  { 'description': 'The number of expectation blocks closed.',
    'dynamic': False,
    'name': 'Mysqlx_expect_close'},
  { 'description': 'The number of rows sent back to clients.',
    'dynamic': False,
    'name': 'Mysqlx_rows_sent'},
  { 'description': 'The number of warning notices sent back to clients.',
    'dynamic': False,
    'name': 'Mysqlx_notice_warning_sent'},
  { 'description': 'The number of other types of notices sent back to clients.',
    'dynamic': False,
    'name': 'Mysqlx_notice_other_sent'},
  { 'description': 'The current SSL cipher (empty for non-SSL connections).',
    'dynamic': False,
    'name': 'Mysqlx_ssl_cipher'},
  { 'description': 'A list of possible SSL ciphers (empty for non-SSL connections).',
    'dynamic': False,
    'name': 'Mysqlx_ssl_cipher_list'},
  { 'description': 'The certificate verification depth for SSL connection.',
    'dynamic': False,
    'name': 'Mysqlx_ssl_verify_depth'},
  { 'description': 'The certificate verification mode for SSL connection.',
    'dynamic': False,
    'name': 'Mysqlx_ssl_verify_mode'},
  { 'description': 'The name of the protocol used for the SSL connection.',
    'dynamic': False,
    'name': 'Mysqlx_ssl_version'},
  { 'description': 'The number of sessions that have been opened.',
    'dynamic': False,
    'name': 'Mysqlx_sessions'},
  { 'description': 'The number of sessions that have been closed.',
    'dynamic': False,
    'name': 'Mysqlx_sessions_closed'},
  { 'description': 'The number of sessions that have closed with a fatal error.',
    'dynamic': False,
    'name': 'Mysqlx_sessions_fatal_error'},
  { 'description': 'The number of errors during initialisation.',
    'dynamic': False,
    'name': 'Mysqlx_init_error'},
  { 'description': 'The number of session attempts which have been accepted.',
    'dynamic': False,
    'name': 'Mysqlx_sessions_accepted'},
  { 'description': 'The number of session attempts which have been rejected.',
    'dynamic': False,
    'name': 'Mysqlx_sessions_rejected'},
  { 'description': 'The number of sessions which have been killed.',
    'dynamic': False,
    'name': 'Mysqlx_sessions_killed'},
  { 'description': 'The number of connections which have been closed.',
    'dynamic': False,
    'name': 'Mysqlx_connections_closed'},
  { 'description': 'The number of connections which have been accepted.',
    'dynamic': False,
    'name': 'Mysqlx_connections_accepted'},
  { 'description': 'The number of connections which have been rejected.',
    'dynamic': False,
    'name': 'Mysqlx_connections_rejected'},
  { 'description': 'The number of connections which have caused accept errors.',
    'dynamic': False,
    'name': 'Mysqlx_connection_accept_errors'},
  { 'description': 'The number of connections which have been closed.',
    'dynamic': False,
    'name': 'Mysqlx_connection_errors'},
  { 'description': 'The number of worker threads available.',
    'dynamic': False,
    'name': 'Mysqlx_worker_threads'},
  { 'description': 'The number of worker threads currently used.',
    'dynamic': False,
    'name': 'Mysqlx_worker_threads_active'},
  { 'description': 'If SSL is active.',
    'dynamic': False,
    'name': 'Mysqlx_ssl_active'},
  { 'description': 'The certificate verification depth limit currently set in ctx.',
    'dynamic': False,
    'name': 'Mysqlx_ssl_ctx_verify_depth'},
  { 'description': 'The certificate verification mode currently set in ctx.',
    'dynamic': False,
    'name': 'Mysqlx_ssl_ctx_verify_mode'},
  { 'description': 'The number of successful SSL connections to the server.',
    'dynamic': False,
    'name': 'Mysqlx_ssl_finished_accepts'},
  { 'description': 'The number of accepted SSL connections.',
    'dynamic': False,
    'name': 'Mysqlx_ssl_accepts'},
  { 'description': 'The last date for which the SSL certificate is valid.',
    'dynamic': False,
    'name': 'Mysqlx_ssl_server_not_after'},
  { 'description': 'The first date for which the SSL certificate is valid.',
    'dynamic': False,
    'name': 'Mysqlx_ssl_server_not_before'},
  { 'description': 'The number of negotiates needed to establish the connection.',
    'dynamic': False,
    'name': 'Mysqlx_ssl_accept_renegotiates'},
  { 'description': 'number of errors that were sent to clients',
    'dynamic': False,
    'name': 'Mysqlx_errors_sent'},
  { 'description': 'Number of connections aborted because the client died without closing the connection properly',
    'dynamic': False,
    'name': 'Aborted_clients'},
  { 'description': 'Number of failed attempts to connect to MySQL server',
    'dynamic': False,
    'name': 'Aborted_connects'},
  { 'description': 'Number of cached privilege objects',
    'dynamic': False,
    'name': 'Acl_cache_items_count'},
  { 'description': 'Audit log file current size',
    'dynamic': False,
    'name': 'Audit_log_current_size'},
  { 'description': 'Size of largest dropped audited event',
    'dynamic': False,
    'name': 'Audit_log_event_max_drop_size'},
  { 'description': 'Number of handled audited events',
    'dynamic': False,
    'name': 'Audit_log_events'},
  { 'description': 'Number of filtered audited events',
    'dynamic': False,
    'name': 'Audit_log_events_filtered'},
  { 'description': 'Number of dropped audited events',
    'dynamic': False,
    'name': 'Audit_log_events_lost'},
  { 'description': 'Number of written audited events',
    'dynamic': False,
    'name': 'Audit_log_events_written'},
  { 'description': 'Combined size of written audited events',
    'dynamic': False,
    'name': 'Audit_log_total_size'},
  { 'description': 'Number of write-delayed audited events',
    'dynamic': False,
    'name': 'Audit_log_write_waits'},
  { 'description': 'Number of transactions that used a temporary file instead of the binary log cache',
    'dynamic': False,
    'name': 'Binlog_cache_disk_use'},
  { 'description': 'Number of transactions that used the temporary binary log cache',
    'dynamic': False,
    'name': 'Binlog_cache_use'},
  { 'description': 'Number of nontransactional statements that used a temporary file instead of the binary log statement cache',
    'dynamic': False,
    'name': 'Binlog_stmt_cache_disk_use'},
  { 'description': 'Number of statements that used the temporary binary log statement cache',
    'dynamic': False,
    'name': 'Binlog_stmt_cache_use'},
  { 'description': 'Number of bytes received from all clients',
    'dynamic': False,
    'name': 'Bytes_received'},
  { 'description': 'Number of bytes sent to all clients',
    'dynamic': False,
    'name': 'Bytes_sent'},
  { 'description': 'Count of admin statements',
    'dynamic': False,
    'name': 'Com_admin_commands'},
  { 'description': 'Count of ALTER DATABASE statements',
    'dynamic': False,
    'name': 'Com_alter_db'},
  { 'description': 'Count of ALTER DATABASE ... UPGRADE DATA DIRECTORY NAMEstatements',
    'dynamic': False,
    'name': 'Com_alter_db_upgrade'},
  { 'description': 'Count for ALTER EVENT statements',
    'dynamic': False,
    'name': 'Com_alter_event'},
  { 'description': 'Count of ALTER FUNCTION statements',
    'dynamic': False,
    'name': 'Com_alter_function'},
  { 'description': 'Count of ALTER PROCEDURE statements',
    'dynamic': False,
    'name': 'Com_alter_procedure'},
  { 'description': 'Count of ALTER SERVER statements',
    'dynamic': False,
    'name': 'Com_alter_server'},
  { 'description': 'Count of ALTER TABLE statements',
    'dynamic': False,
    'name': 'Com_alter_table'},
  { 'description': 'Count of ALTER TABLESPACE statements',
    'dynamic': False,
    'name': 'Com_alter_tablespace'},
  { 'description': 'Count of ALTER USER statements',
    'dynamic': False,
    'name': 'Com_alter_user'},
  { 'description': 'Count of ALTER USER ... DEFAULT ROLE statements',
    'dynamic': False,
    'name': 'Com_alter_user_default_role'},
  { 'description': 'Count of ANALYZE statements',
    'dynamic': False,
    'name': 'Com_analyze'},
  { 'description': 'Count of CACHE INDEX statements',
    'dynamic': False,
    'name': 'Com_assign_to_keycache'},
  { 'description': 'Count of BACKUP DATABASE statements',
    'dynamic': False,
    'name': 'Com_backup'},
  { 'description': 'Count of BACKUP TABLE statements',
    'dynamic': False,
    'name': 'Com_backup_table'},
  { 'description': 'Count of BEGIN statements',
    'dynamic': False,
    'name': 'Com_begin'},
  { 'description': 'Count of BINLOG statements',
    'dynamic': False,
    'name': 'Com_binlog'},
  { 'description': 'Number of calls to stored procedures',
    'dynamic': False,
    'name': 'Com_call_procedure'},
  { 'description': 'Count of CHANGE DATABASE statements',
    'dynamic': False,
    'name': 'Com_change_db'},
  { 'description': 'Count of CHANGE MASTER TO statements',
    'dynamic': False,
    'name': 'Com_change_master'},
  { 'description': 'Count of CHANGE REPLICATION FILTER statements',
    'dynamic': False,
    'name': 'Com_change_repl_filter'},
  { 'description': 'Count of CHECK statements',
    'dynamic': False,
    'name': 'Com_check'},
  { 'description': 'Count of CHECKSUM statements',
    'dynamic': False,
    'name': 'Com_checksum'},
  { 'description': 'Count of COMMIT statements',
    'dynamic': False,
    'name': 'Com_commit'},
  { 'description': 'Count of CREATE DATABASE statements',
    'dynamic': False,
    'name': 'Com_create_db'},
  { 'description': 'Count of CREATE EVENT statements',
    'dynamic': False,
    'name': 'Com_create_event'},
  { 'description': 'Count of CREATE FUNCTION statements',
    'dynamic': False,
    'name': 'Com_create_function'},
  { 'description': 'Count of CREATE INDEX statements',
    'dynamic': False,
    'name': 'Com_create_index'},
  { 'description': 'Count of CREATE PROCEDURE statements',
    'dynamic': False,
    'name': 'Com_create_procedure'},
  { 'description': 'Count of CREATE ROLE statements',
    'dynamic': False,
    'name': 'Com_create_role'},
  { 'description': 'Count of CREATE SERVER statements',
    'dynamic': False,
    'name': 'Com_create_server'},
  { 'description': 'Count of CREATE TABLE statements',
    'dynamic': False,
    'name': 'Com_create_table'},
  { 'description': 'Count of CREATE TRIGGER statements',
    'dynamic': False,
    'name': 'Com_create_trigger'},
  { 'description': 'Count of CREATE FUNCTION (UDF) statements',
    'dynamic': False,
    'name': 'Com_create_udf'},
  { 'description': 'Count of CREATE USER statements',
    'dynamic': False,
    'name': 'Com_create_user'},
  { 'description': 'Count of CREATE VIEW statements',
    'dynamic': False,
    'name': 'Com_create_view'},
  { 'description': 'Count of DEALLOCATE PREPARE statements',
    'dynamic': False,
    'name': 'Com_dealloc_sql'},
  { 'description': 'Count of DELETE statements',
    'dynamic': False,
    'name': 'Com_delete'},
  { 'description': 'Count of multiple table DELETE statements',
    'dynamic': False,
    'name': 'Com_delete_multi'},
  { 'description': 'Count of DO statements',
    'dynamic': False,
    'name': 'Com_do'},
  { 'description': 'Count of DROP DATABASE statements',
    'dynamic': False,
    'name': 'Com_drop_db'},
  { 'description': 'Count of DROP EVENT statements',
    'dynamic': False,
    'name': 'Com_drop_event'},
  { 'description': 'Count of DROP FUNCTION statements',
    'dynamic': False,
    'name': 'Com_drop_function'},
  { 'description': 'Count of DROP INDEX statements',
    'dynamic': False,
    'name': 'Com_drop_index'},
  { 'description': 'Count of DROP PROCEDURE statements',
    'dynamic': False,
    'name': 'Com_drop_procedure'},
  { 'description': 'Count of DROP ROLE statements',
    'dynamic': False,
    'name': 'Com_drop_role'},
  { 'description': 'Count of DROP SERVER statements',
    'dynamic': False,
    'name': 'Com_drop_server'},
  { 'description': 'Count of DROP TABLE statements',
    'dynamic': False,
    'name': 'Com_drop_table'},
  { 'description': 'Count of DROP TRIGGER statements',
    'dynamic': False,
    'name': 'Com_drop_trigger'},
  { 'description': 'Count of DROP USER statements',
    'dynamic': False,
    'name': 'Com_drop_user'},
  { 'description': 'Count of DROP_VIEW statements',
    'dynamic': False,
    'name': 'Com_drop_view'},
  { 'description': 'Count of empty statements',
    'dynamic': False,
    'name': 'Com_empty_query'},
  { 'description': 'Count of EXECUTE statements',
    'dynamic': False,
    'name': 'Com_execute_sql'},
  { 'description': 'Count of EXPLAIN FOR CONNECTION statements',
    'dynamic': False,
    'name': 'Com_explain_other'},
  { 'description': 'Count of FLUSH statements',
    'dynamic': False,
    'name': 'Com_flush'},
  { 'description': 'Count of GET DIAGNOSTICS statements',
    'dynamic': False,
    'name': 'Com_get_diagnostics'},
  { 'description': 'Count of GRANT statements',
    'dynamic': False,
    'name': 'Com_grant'},
  { 'description': 'Count of GRANT ROLE statements',
    'dynamic': False,
    'name': 'Com_grant_roles'},
  { 'description': 'Count of HANDLER CLOSE statements',
    'dynamic': False,
    'name': 'Com_ha_close'},
  { 'description': 'Count of HANDLER OPEN statements',
    'dynamic': False,
    'name': 'Com_ha_open'},
  { 'description': 'Count of HANDLER READ statements',
    'dynamic': False,
    'name': 'Com_ha_read'},
  { 'description': 'Count of HELP statements',
    'dynamic': False,
    'name': 'Com_help'},
  { 'description': 'Count of INSERT statements',
    'dynamic': False,
    'name': 'Com_insert'},
  { 'description': 'Count of INSERT SELECT statements',
    'dynamic': False,
    'name': 'Com_insert_select'},
  { 'description': 'Count of INSTALL COMPONENT statements',
    'dynamic': False,
    'name': 'Com_install_component'},
  { 'description': 'Count of INSTALL PLUGIN statements',
    'dynamic': False,
    'name': 'Com_install_plugin'},
  { 'description': 'Count of KILL statements',
    'dynamic': False,
    'name': 'Com_kill'},
  { 'description': 'Count of LOAD statements',
    'dynamic': False,
    'name': 'Com_load'},
  { 'description': 'Count of LOAD MASTER DATA statements',
    'dynamic': False,
    'name': 'Com_load_master_data'},
  { 'description': 'Count of LOAD MASTER TABLE statements',
    'dynamic': False,
    'name': 'Com_load_master_table'},
  { 'description': 'Count of LOCK TABLES statements',
    'dynamic': False,
    'name': 'Com_lock_tables'},
  { 'description': 'Count of OPTIMIZE statements',
    'dynamic': False,
    'name': 'Com_optimize'},
  { 'description': 'Count of PRELOAD KEYS statements',
    'dynamic': False,
    'name': 'Com_preload_keys'},
  { 'description': 'Count of PREPARE statements',
    'dynamic': False,
    'name': 'Com_prepare_sql'},
  { 'description': 'Count of PURGE statements',
    'dynamic': False,
    'name': 'Com_purge'},
  { 'description': 'Count of PURGE BEFORE DATE statements',
    'dynamic': False,
    'name': 'Com_purge_before_date'},
  { 'description': 'Count of PURGE BACKUP LOG statements',
    'dynamic': False,
    'name': 'Com_purge_bup_log'},
  { 'description': 'Count of RELEASE SAVEPOINT statements',
    'dynamic': False,
    'name': 'Com_release_savepoint'},
  { 'description': 'Count of RENAME TABLE statements',
    'dynamic': False,
    'name': 'Com_rename_table'},
  { 'description': 'Count of RENAME USER statements',
    'dynamic': False,
    'name': 'Com_rename_user'},
  { 'description': 'Count of REPAIR statements',
    'dynamic': False,
    'name': 'Com_repair'},
  { 'description': 'Count of REPLACE statements',
    'dynamic': False,
    'name': 'Com_replace'},
  { 'description': 'Count of REPLACE SELECT statements',
    'dynamic': False,
    'name': 'Com_replace_select'},
  { 'description': 'Count of RESET statements',
    'dynamic': False,
    'name': 'Com_reset'},
  { 'description': 'Count of RESIGNAL statements',
    'dynamic': False,
    'name': 'Com_resignal'},
  { 'description': 'Count of RESTORE DATABASE statements',
    'dynamic': False,
    'name': 'Com_restore'},
  { 'description': 'Count of RESTORE TABLE statements',
    'dynamic': False,
    'name': 'Com_restore_table'},
  { 'description': 'Count of REVOKE statements that revoke roles',
    'dynamic': False,
    'name': 'Com_revoke'},
  { 'description': 'Count of REVOKE ALL statements',
    'dynamic': False,
    'name': 'Com_revoke_all'},
  { 'description': 'Count of REVOKE ROLES statements',
    'dynamic': False,
    'name': 'Com_revoke_roles'},
  { 'description': 'Count of ROLLBACK statements',
    'dynamic': False,
    'name': 'Com_rollback'},
  { 'description': 'Count of ROLLBACK TO SAVEPOINT statements',
    'dynamic': False,
    'name': 'Com_rollback_to_savepoint'},
  { 'description': 'Count of SAVEPOINT statements',
    'dynamic': False,
    'name': 'Com_savepoint'},
  { 'description': 'Count of SELECT statements',
    'dynamic': False,
    'name': 'Com_select'},
  { 'description': 'Count of SET OPTION statements',
    'dynamic': False,
    'name': 'Com_set_option'},
  { 'description': 'Count of SET ROLE statements',
    'dynamic': False,
    'name': 'Com_set_role'},
  { 'description': 'Count of SHOW AUTHORS statements',
    'dynamic': False,
    'name': 'Com_show_authors'},
  { 'description': 'Count of SHOW BINLOG EVENTS statements',
    'dynamic': False,
    'name': 'Com_show_binlog_events'},
  { 'description': 'Count of SHOW BINLOGS statements',
    'dynamic': False,
    'name': 'Com_show_binlogs'},
  { 'description': 'Count of SHOW CHARSET statements',
    'dynamic': False,
    'name': 'Com_show_charsets'},
  { 'description': 'Count of SHOW COLLATION statements',
    'dynamic': False,
    'name': 'Com_show_collations'},
  { 'description': 'Count of SHOW COLUMN TYPES statements',
    'dynamic': False,
    'name': 'Com_show_column_types'},
  { 'description': 'Count of SHOW CONTRIBUTORS statements',
    'dynamic': False,
    'name': 'Com_show_contributors'},
  { 'description': 'Count of SHOW CREATE DATABASE statements',
    'dynamic': False,
    'name': 'Com_show_create_db'},
  { 'description': 'Count of SHOW CREATE EVENT statements',
    'dynamic': False,
    'name': 'Com_show_create_event'},
  { 'description': 'Count of SHOW CREATE FUNCTION statements',
    'dynamic': False,
    'name': 'Com_show_create_func'},
  { 'description': 'Count of SHOW CREATE PROCEDURE statements',
    'dynamic': False,
    'name': 'Com_show_create_proc'},
  { 'description': 'Count of SHOW CREATE TABLE statements',
    'dynamic': False,
    'name': 'Com_show_create_table'},
  { 'description': 'Count of SHOW CREATE TRIGGER statements',
    'dynamic': False,
    'name': 'Com_show_create_trigger'},
  { 'description': 'Count of SHOW CREATE USER statements',
    'dynamic': False,
    'name': 'Com_show_create_user'},
  { 'description': 'Count of SHOW DATABASES statements',
    'dynamic': False,
    'name': 'Com_show_databases'},
  { 'description': 'Count of SHOW ENGINE LOGS statements',
    'dynamic': False,
    'name': 'Com_show_engine_logs'},
  { 'description': 'Count of SHOW ENGINE MUTEX statements',
    'dynamic': False,
    'name': 'Com_show_engine_mutex'},
  { 'description': 'Count of SHOW ENGINE STATUS statements',
    'dynamic': False,
    'name': 'Com_show_engine_status'},
  { 'description': 'Count of SHOW ERRORS statements',
    'dynamic': False,
    'name': 'Com_show_errors'},
  { 'description': 'Count of SHOW EVENTS statements',
    'dynamic': False,
    'name': 'Com_show_events'},
  { 'description': 'Count of SHOW FIELDS statements',
    'dynamic': False,
    'name': 'Com_show_fields'},
  { 'description': 'Count of SHOW FUNCTION CODE statements',
    'dynamic': False,
    'name': 'Com_show_function_code'},
  { 'description': 'Count of SHOW FUNCTION STATUS statements',
    'dynamic': False,
    'name': 'Com_show_function_status'},
  { 'description': 'Count of SHOW GRANTS statements',
    'dynamic': False,
    'name': 'Com_show_grants'},
  { 'description': 'Count of SHOW INNODB STATUS statements',
    'dynamic': False,
    'name': 'Com_show_innodb_status'},
  { 'description': 'Count of SHOW KEYS statements',
    'dynamic': False,
    'name': 'Com_show_keys'},
  { 'description': 'Count of SHOW LOGS statements',
    'dynamic': False,
    'name': 'Com_show_logs'},
  { 'description': 'Count of SHOW MASTER STATUS statements',
    'dynamic': False,
    'name': 'Com_show_master_status'},
  { 'description': 'Count of SHOW NDB STATUS statements',
    'dynamic': False,
    'name': 'Com_show_ndb_status'},
  { 'description': 'Count of SHOW NEW MASTER statements',
    'dynamic': False,
    'name': 'Com_show_new_master'},
  { 'description': 'Count of SHOW OPEN TABLES statements',
    'dynamic': False,
    'name': 'Com_show_open_tables'},
  { 'description': 'Count of SHOW PLUGINS statements',
    'dynamic': False,
    'name': 'Com_show_plugins'},
  { 'description': 'Count of SHOW PRIVILEGES statements',
    'dynamic': False,
    'name': 'Com_show_privileges'},
  { 'description': 'Count of SHOW PROCEDURE CODE statements',
    'dynamic': False,
    'name': 'Com_show_procedure_code'},
  { 'description': 'Count of SHOW PROCEDURE STATUS statements',
    'dynamic': False,
    'name': 'Com_show_procedure_status'},
  { 'description': 'Count of SHOW PROCESSLIST statements',
    'dynamic': False,
    'name': 'Com_show_processlist'},
  { 'description': 'Count of SHOW PROFILE statements',
    'dynamic': False,
    'name': 'Com_show_profile'},
  { 'description': 'Count of SHOW PROFILES statements',
    'dynamic': False,
    'name': 'Com_show_profiles'},
  { 'description': 'Count of SHOW RELAYLOG EVENTS statements',
    'dynamic': False,
    'name': 'Com_show_relaylog_events'},
  { 'description': 'Count of SHOW SLAVE HOSTS statements',
    'dynamic': False,
    'name': 'Com_show_slave_hosts'},
  { 'description': 'Count of SHOW SLAVE STATUS statements',
    'dynamic': False,
    'name': 'Com_show_slave_status'},
  { 'description': 'Count of SHOW SLAVE STATUS NONBLOCKING statements',
    'dynamic': False,
    'name': 'Com_show_slave_status_nonblocking'},
  { 'description': 'Count of SHOW STATUS statements',
    'dynamic': False,
    'name': 'Com_show_status'},
  { 'description': 'Count of SHOW STORAGE ENGINES statements',
    'dynamic': False,
    'name': 'Com_show_storage_engines'},
  { 'description': 'Count of SHOW TABLE STATUS statements',
    'dynamic': False,
    'name': 'Com_show_table_status'},
  { 'description': 'Count of SHOW TABLES statements',
    'dynamic': False,
    'name': 'Com_show_tables'},
  { 'description': 'Count of SHOW TRIGGERS statements',
    'dynamic': False,
    'name': 'Com_show_triggers'},
  { 'description': 'Count of SHOW VARIABLES statements',
    'dynamic': False,
    'name': 'Com_show_variables'},
  { 'description': 'Count of SHOW WARNINGS statements',
    'dynamic': False,
    'name': 'Com_show_warnings'},
  { 'description': 'Count of SHUTDOWN statements',
    'dynamic': False,
    'name': 'Com_shutdown'},
  { 'description': 'Count of SIGNAL statements',
    'dynamic': False,
    'name': 'Com_signal'},
  { 'description': 'Count of START SLAVE statements',
    'dynamic': False,
    'name': 'Com_slave_start'},
  { 'description': 'Count of STOP SLAVE statements',
    'dynamic': False,
    'name': 'Com_slave_stop'},
  { 'description': 'Count of STATEMENT CLOSE statements',
    'dynamic': False,
    'name': 'Com_stmt_close'},
  { 'description': 'Count of STATEMENT EXECUTE statements',
    'dynamic': False,
    'name': 'Com_stmt_execute'},
  { 'description': 'Count of STATEMENT FETCH statements',
    'dynamic': False,
    'name': 'Com_stmt_fetch'},
  { 'description': 'Count of STATEMENT PREPARE statements',
    'dynamic': False,
    'name': 'Com_stmt_prepare'},
  { 'description': 'Count of automatic repreparations of prepared statements',
    'dynamic': False,
    'name': 'Com_stmt_reprepare'},
  { 'description': 'Count of STATEMENT RESET statements',
    'dynamic': False,
    'name': 'Com_stmt_reset'},
  { 'description': 'Count of STATEMENT SEND LONG DATA statements',
    'dynamic': False,
    'name': 'Com_stmt_send_long_data'},
  { 'description': 'Count of TRUNCATE statements',
    'dynamic': False,
    'name': 'Com_truncate'},
  { 'description': 'Count of UINSTALL COMPONENT statements',
    'dynamic': False,
    'name': 'Com_uninstall_component'},
  { 'description': 'Count of UNINSTALL PLUGIN statements',
    'dynamic': False,
    'name': 'Com_uninstall_plugin'},
  { 'description': 'Count of UNLOCK TABLES statements',
    'dynamic': False,
    'name': 'Com_unlock_tables'},
  { 'description': 'Count of UPDATE statements',
    'dynamic': False,
    'name': 'Com_update'},
  { 'description': 'Count of multiple UPDATE statements',
    'dynamic': False,
    'name': 'Com_update_multi'},
  { 'description': 'Count of XA COMMIT statements',
    'dynamic': False,
    'name': 'Com_xa_commit'},
  { 'description': 'Count of XA END statements',
    'dynamic': False,
    'name': 'Com_xa_end'},
  { 'description': 'Count of XA PREPARE statements',
    'dynamic': False,
    'name': 'Com_xa_prepare'},
  { 'description': 'Count of XA RECOVER statements',
    'dynamic': False,
    'name': 'Com_xa_recover'},
  { 'description': 'Count of XA ROLLBACK statements',
    'dynamic': False,
    'name': 'Com_xa_rollback'},
  { 'description': 'Count of XA START statements',
    'dynamic': False,
    'name': 'Com_xa_start'},
  { 'description': 'Whether the client connection uses compression in the client/server protocol',
    'dynamic': False,
    'name': 'Compression'},
  { 'description': 'How many times the server delayed a connection request',
    'dynamic': False,
    'name': 'Connection_control_delay_generated'},
  { 'description': 'Number of errors calling accept on the listening port',
    'dynamic': False,
    'name': 'Connection_errors_accept'},
  { 'description': 'Number of connections refused due to internal errors',
    'dynamic': False,
    'name': 'Connection_errors_internal'},
  { 'description': 'Number of connections refused due to the max_connections limit',
    'dynamic': False,
    'name': 'Connection_errors_max_connections'},
  { 'description': 'Number of errors searching for connection client IP addresses',
    'dynamic': False,
    'name': 'Connection_errors_peer_addr'},
  { 'description': 'Number of errors calling select/poll on the listening port',
    'dynamic': False,
    'name': 'Connection_errors_select'},
  { 'description': 'Number of connections refused by libwrap',
    'dynamic': False,
    'name': 'Connection_errors_tcpwrap'},
  { 'description': 'Number of connection attempts',
    'dynamic': False,
    'name': 'Connections'},
  { 'description': 'Number of temporary tables on disk created automatically by the server while executing statements',
    'dynamic': False,
    'name': 'Created_tmp_disk_tables'},
  { 'description': 'How many temporary files mysqld has created',
    'dynamic': False,
    'name': 'Created_tmp_files'},
  { 'description': 'How many temporary tables mysqld has created',
    'dynamic': False,
    'name': 'Created_tmp_tables'},
  { 'description': 'Number of rows written with INSERT DELAYED for which some error occurred',
    'dynamic': False,
    'name': 'Delayed_errors'},
  { 'description': 'Number of INSERT DELAYED thread handlers in use',
    'dynamic': False,
    'name': 'Delayed_insert_threads'},
  { 'description': 'Number of INSERT DELAYED rows written',
    'dynamic': False,
    'name': 'Delayed_writes'},
  { 'description': 'Number of statements rejected by MySQL Enterprise Firewall',
    'dynamic': False,
    'name': 'Firewall_access_denied'},
  { 'description': 'Number of statements accepted by MySQL Enterprise Firewall',
    'dynamic': False,
    'name': 'Firewall_access_granted'},
  { 'description': 'Number of statements recorded by MySQL Enterprise Firewall',
    'dynamic': False,
    'name': 'Firewall_cached_entries'},
  { 'description': 'Number of FLUSH statements executed',
    'dynamic': False,
    'name': 'Flush_commands'},
  { 'description': 'Number of internal COMMIT statements',
    'dynamic': False,
    'name': 'Handler_commit'},
  { 'description': 'Number of times that rows have been deleted from tables',
    'dynamic': False,
    'name': 'Handler_delete'},
  { 'description': 'Number of times that tables have been discovered',
    'dynamic': False,
    'name': 'Handler_discover'},
  { 'description': 'Number of locks started while a statement executed.',
    'dynamic': False,
    'name': 'Handler_external_lock'},
  { 'description': 'Number of times storage engine MRR implementation is used for table access',
    'dynamic': False,
    'name': 'Handler_mrr_init'},
  { 'description': 'A counter for the prepare phase of two-phase commit operations',
    'dynamic': False,
    'name': 'Handler_prepare'},
  { 'description': 'Number of times the first entry in an index was read',
    'dynamic': False,
    'name': 'Handler_read_first'},
  { 'description': 'Number of requests to read a row based on a key',
    'dynamic': False,
    'name': 'Handler_read_key'},
  { 'description': 'Number of requests to read the last index entry',
    'dynamic': False,
    'name': 'Handler_read_last'},
  { 'description': 'Number of requests to read the next row in key order',
    'dynamic': False,
    'name': 'Handler_read_next'},
  { 'description': 'Number of requests to read the previous row in key order',
    'dynamic': False,
    'name': 'Handler_read_prev'},
  { 'description': 'Number of requests to read a row based on a fixed position',
    'dynamic': False,
    'name': 'Handler_read_rnd'},
  { 'description': 'Number of requests to read the next row in the data file',
    'dynamic': False,
    'name': 'Handler_read_rnd_next'},
  { 'description': 'Number of requests for a storage engine to perform a rollback operation',
    'dynamic': False,
    'name': 'Handler_rollback'},
  { 'description': 'Number of requests for a storage engine to place a savepoint',
    'dynamic': False,
    'name': 'Handler_savepoint'},
  { 'description': 'Number of requests for a storage engine to roll back to a savepoint',
    'dynamic': False,
    'name': 'Handler_savepoint_rollback'},
  { 'description': 'Number of requests to update a row in a table',
    'dynamic': False,
    'name': 'Handler_update'},
  { 'description': 'Number of requests to insert a row in a table',
    'dynamic': False,
    'name': 'Handler_write'},
  { 'description': 'Display total number of InnoDB rollback segments; different from innodb_undo_logs, which displays the number of active rollback segments',
    'dynamic': False,
    'name': 'Innodb_available_undo_logs'},
  { 'description': 'Number of bytes containing data (dirty or clean) in the buffer pool',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_bytes_data'},
  { 'description': 'Number of bytes currently dirty in the buffer pool',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_bytes_dirty'},
  { 'description': 'Display status of buffer pool recording operation triggered by innodb_buffer_pool_dump_at_shutdown or innodb_buffer_pool_dump_now',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_dump_status'},
  { 'description': 'Display status of buffer pool warmup operation triggered by innodb_buffer_pool_load_at_startup or innodb_buffer_pool_load_now',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_load_status'},
  { 'description': 'Number of pages containing data (dirty or clean) in the buffer pool',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_pages_data'},
  { 'description': 'Number of pages currently dirty in the buffer pool',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_pages_dirty'},
  { 'description': 'Number of buffer pool page-flush requests',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_pages_flushed'},
  { 'description': 'Number of buffer pool pages free',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_pages_free'},
  { 'description': 'Number of latched pages in InnoDB buffer pool',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_pages_latched'},
  { 'description': 'Number of pages that are busy because they have been allocated for administrative overhead',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_pages_misc'},
  { 'description': 'The total size of buffer pool, in pages',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_pages_total'},
  { 'description': 'Number of pages read by the InnoDB read-ahead thread',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_read_ahead'},
  { 'description': 'Number of read-ahead pages evicted without being accessed',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_read_ahead_evicted'},
  { 'description': 'Number of random read-aheads initiated by InnoDB',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_read_ahead_rnd'},
  { 'description': 'Number of sequential read-aheads initiated by InnoDB',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_read_ahead_seq'},
  { 'description': 'Number of logical read requests InnoDB has done',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_read_requests'},
  { 'description': 'Number of logical reads that InnoDB could not satisfy from the buffer pool and had to do a single-page read',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_reads'},
  { 'description': 'The status of the dynamic buffer pool resizing operation.',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_resize_status'},
  { 'description': 'Counts number of waits for pages to be flushed',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_wait_free'},
  { 'description': 'Number of writes done to the buffer pool',
    'dynamic': False,
    'name': 'Innodb_buffer_pool_write_requests'},
  { 'description': 'Number of fsync() operations so far',
    'dynamic': False,
    'name': 'Innodb_data_fsyncs'},
  { 'description': 'The current number of pending fsync() operations',
    'dynamic': False,
    'name': 'Innodb_data_pending_fsyncs'},
  { 'description': 'The current number of pending reads',
    'dynamic': False,
    'name': 'Innodb_data_pending_reads'},
  { 'description': 'Number of pending writes',
    'dynamic': False,
    'name': 'Innodb_data_pending_writes'},
  { 'description': 'The amount of data read so far, in bytes',
    'dynamic': False,
    'name': 'Innodb_data_read'},
  { 'description': 'The total number of data reads',
    'dynamic': False,
    'name': 'Innodb_data_reads'},
  { 'description': 'The total number of data writes',
    'dynamic': False,
    'name': 'Innodb_data_writes'},
  { 'description': 'The amount of data written in bytes',
    'dynamic': False,
    'name': 'Innodb_data_written'},
  { 'description': 'Number of doublewrite pages that have been written',
    'dynamic': False,
    'name': 'Innodb_dblwr_pages_written'},
  { 'description': 'Number of doublewrite operations that have been performed',
    'dynamic': False,
    'name': 'Innodb_dblwr_writes'},
  { 'description': 'Whether atomic instructions are available',
    'dynamic': False,
    'name': 'Innodb_have_atomic_builtins'},
  { 'description': 'Whether atomic instructions are available',
    'dynamic': False,
    'name': 'Innodb_have_sync_atomic'},
  { 'description': 'Whether the InnoDB memory heap is enabled',
    'dynamic': False,
    'name': 'Innodb_heap_enabled'},
  { 'description': 'Number of times that the log buffer was too small and a wait was required for it to be flushed before continuing',
    'dynamic': False,
    'name': 'Innodb_log_waits'},
  { 'description': 'Number of log write requests',
    'dynamic': False,
    'name': 'Innodb_log_write_requests'},
  { 'description': 'Number of physical writes to the log',
    'dynamic': False,
    'name': 'Innodb_log_writes'},
  { 'description': 'Number of physical files currently opened by InnoDB',
    'dynamic': False,
    'name': 'Innodb_num_open_files'},
  { 'description': 'Number of fsync() writes done to the log file',
    'dynamic': False,
    'name': 'Innodb_os_log_fsyncs'},
  { 'description': 'Number of pending log file fsync() operations',
    'dynamic': False,
    'name': 'Innodb_os_log_pending_fsyncs'},
  { 'description': 'Number of pending log file writes',
    'dynamic': False,
    'name': 'Innodb_os_log_pending_writes'},
  { 'description': 'Number of bytes written to the log file',
    'dynamic': False,
    'name': 'Innodb_os_log_written'},
  { 'description': 'The compiled-in InnoDB page size',
    'dynamic': False,
    'name': 'Innodb_page_size'},
  { 'description': 'Number of pages created',
    'dynamic': False,
    'name': 'Innodb_pages_created'},
  { 'description': 'Number of pages read',
    'dynamic': False,
    'name': 'Innodb_pages_read'},
  { 'description': 'Number of pages written',
    'dynamic': False,
    'name': 'Innodb_pages_written'},
  { 'description': 'Number of row locks currently being waited for',
    'dynamic': False,
    'name': 'Innodb_row_lock_current_waits'},
  { 'description': 'The total time spent in acquiring row locks, in milliseconds',
    'dynamic': False,
    'name': 'Innodb_row_lock_time'},
  { 'description': 'The average time to acquire a row lock, in milliseconds',
    'dynamic': False,
    'name': 'Innodb_row_lock_time_avg'},
  { 'description': 'The maximum time to acquire a row lock, in milliseconds',
    'dynamic': False,
    'name': 'Innodb_row_lock_time_max'},
  { 'description': 'Number of times a row lock had to be waited for',
    'dynamic': False,
    'name': 'Innodb_row_lock_waits'},
  { 'description': 'Number of rows deleted from InnoDB tables',
    'dynamic': False,
    'name': 'Innodb_rows_deleted'},
  { 'description': 'Number of rows inserted into InnoDB tables',
    'dynamic': False,
    'name': 'Innodb_rows_inserted'},
  { 'description': 'Number of rows read from InnoDB tables',
    'dynamic': False,
    'name': 'Innodb_rows_read'},
  { 'description': 'Number of rows updated in InnoDB tables',
    'dynamic': False,
    'name': 'Innodb_rows_updated'},
  { 'description': 'Number of times output from the SHOW ENGINE INNODB STATUS statement has been truncated',
    'dynamic': False,
    'name': 'Innodb_truncated_status_writes'},
  { 'description': 'Number of wakeups that should not occur',
    'dynamic': False,
    'name': 'Innodb_wake_ups'},
  { 'description': 'Number of key blocks in the key cache that have changed but have not yet been flushed to disk',
    'dynamic': False,
    'name': 'Key_blocks_not_flushed'},
  { 'description': 'Number of unused blocks in the key cache',
    'dynamic': False,
    'name': 'Key_blocks_unused'},
  { 'description': 'Number of used blocks in the key cache',
    'dynamic': False,
    'name': 'Key_blocks_used'},
  { 'description': 'Number of requests to read a key block from the cache',
    'dynamic': False,
    'name': 'Key_read_requests'},
  { 'description': 'Number of physical reads of a key block from disk',
    'dynamic': False,
    'name': 'Key_reads'},
  { 'description': 'Number of requests to write a key block to the cache',
    'dynamic': False,
    'name': 'Key_write_requests'},
  { 'description': 'Number of physical writes of a key block from disk',
    'dynamic': False,
    'name': 'Key_writes'},
  { 'description': 'The total cost of the last compiled query as computed by the query optimizer',
    'dynamic': False,
    'name': 'Last_query_cost'},
  { 'description': 'Number of iterations in execution plan construction for the previous statement.',
    'dynamic': False,
    'name': 'Last_query_partial_plans'},
  { 'description': 'Number of attempts to connect to locked accounts',
    'dynamic': False,
    'name': 'Locked_connects'},
  { 'description': 'Number of statements that exceeded the execution timeout value',
    'dynamic': False,
    'name': 'Max_execution_time_exceeded'},
  { 'description': 'Number of statements for which execution timeout was set',
    'dynamic': False,
    'name': 'Max_execution_time_set'},
  { 'description': 'Number of statements for which execution timeout setting failed',
    'dynamic': False,
    'name': 'Max_execution_time_set_failed'},
  { 'description': 'Number of statements that exceeded the execution timeout value',
    'dynamic': False,
    'name': 'Max_statement_time_exceeded'},
  { 'description': 'Number of statements for which execution timeout was set',
    'dynamic': False,
    'name': 'Max_statement_time_set'},
  { 'description': 'Number of statements for which execution timeout setting failed',
    'dynamic': False,
    'name': 'Max_statement_time_set_failed'},
  { 'description': 'The maximum number of connections that have been in use simultaneously since the server started',
    'dynamic': False,
    'name': 'Max_used_connections'},
  { 'description': 'The time at which Max_used_connections reached its current value',
    'dynamic': False,
    'name': 'Max_used_connections_time'},
  { 'description': 'The character set currently used by the MeCab full-text parser plugin.',
    'dynamic': False,
    'name': 'mecab_charset'},
  { 'description': 'MySQL Cluster node ID for this MySQL server',
    'dynamic': False,
    'name': 'ndb-nodeid'},
  { 'description': 'Amount of data (in bytes) received from the data nodes by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_bytes_received_count'},
  { 'description': 'Amount of data (in bytes) received from the data nodes in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_bytes_received_count_session'},
  { 'description': 'Amount of data (in bytes) received from the data nodes by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_bytes_received_count_slave'},
  { 'description': 'Amount of data (in bytes) sent to the data nodes by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_bytes_sent_count'},
  { 'description': 'Amount of data (in bytes) sent to the data nodes in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_bytes_sent_count_session'},
  { 'description': 'Amount of data (in bytes) sent to the data nodes by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_bytes_sent_count_slave'},
  { 'description': 'Number of bytes of events received by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_event_bytes_count'},
  { 'description': 'Number of bytes of events received by the NDB binary log injector thread.',
    'dynamic': False,
    'name': 'Ndb_api_event_bytes_count_injector'},
  { 'description': 'Number of row change events received by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_event_data_count'},
  { 'description': 'Number of row change events received by the NDB binary log injector thread.',
    'dynamic': False,
    'name': 'Ndb_api_event_data_count_injector'},
  { 'description': 'Number of events received, other than row change events, by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_event_nondata_count'},
  { 'description': 'Number of events received, other than row change events, by the NDB binary log injector thread.',
    'dynamic': False,
    'name': 'Ndb_api_event_nondata_count_injector'},
  { 'description': 'Number of operations based on or using primary keys by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_pk_op_count'},
  { 'description': 'Number of operations based on or using primary keys in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_pk_op_count_session'},
  { 'description': 'Number of operations based on or using primary keys by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_pk_op_count_slave'},
  { 'description': 'Number of scans that have been pruned to a single partition by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_pruned_scan_count'},
  { 'description': 'Number of scans that have been pruned to a single partition in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_pruned_scan_count_session'},
  { 'description': 'Number of scans that have been pruned to a single partition by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_pruned_scan_count_slave'},
  { 'description': 'Number of range scans that have been started by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_range_scan_count'},
  { 'description': 'Number of range scans that have been started in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_range_scan_count_session'},
  { 'description': 'Number of range scans that have been started by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_range_scan_count_slave'},
  { 'description': 'Total number of rows that have been read by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_read_row_count'},
  { 'description': 'Total number of rows that have been read in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_read_row_count_session'},
  { 'description': 'Total number of rows that have been read by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_read_row_count_slave'},
  { 'description': 'Number of batches of rows received by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_scan_batch_count'},
  { 'description': 'Number of batches of rows received in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_scan_batch_count_session'},
  { 'description': 'Number of batches of rows received by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_scan_batch_count_slave'},
  { 'description': 'Number of table scans that have been started, including scans of internal tables, by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_table_scan_count'},
  { 'description': 'Number of table scans that have been started, including scans of internal tables, in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_table_scan_count_session'},
  { 'description': 'Number of table scans that have been started, including scans of internal tables, by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_table_scan_count_slave'},
  { 'description': 'Number of transactions aborted by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_trans_abort_count'},
  { 'description': 'Number of transactions aborted in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_trans_abort_count_session'},
  { 'description': 'Number of transactions aborted by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_trans_abort_count_slave'},
  { 'description': 'Number of transactions aborted (may be greater than the sum of TransCommitCount and TransAbortCount) by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_trans_close_count'},
  { 'description': 'Number of transactions aborted (may be greater than the sum of TransCommitCount and TransAbortCount) in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_trans_close_count_session'},
  { 'description': 'Number of transactions aborted (may be greater than the sum of TransCommitCount and TransAbortCount) by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_trans_close_count_slave'},
  { 'description': 'Number of transactions committed by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_trans_commit_count'},
  { 'description': 'Number of transactions committed in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_trans_commit_count_session'},
  { 'description': 'Number of transactions committed by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_trans_commit_count_slave'},
  { 'description': 'Total number of rows that have been read by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_trans_local_read_row_count'},
  { 'description': 'Total number of rows that have been read in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_trans_local_read_row_count_session'},
  { 'description': 'Total number of rows that have been read by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_trans_local_read_row_count_slave'},
  { 'description': 'Number of transactions started by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_trans_start_count'},
  { 'description': 'Number of transactions started in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_trans_start_count_session'},
  { 'description': 'Number of transactions started by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_trans_start_count_slave'},
  { 'description': 'Number of operations based on or using unique keys by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_uk_op_count'},
  { 'description': 'Number of operations based on or using unique keys in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_uk_op_count_session'},
  { 'description': 'Number of operations based on or using unique keys by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_uk_op_count_slave'},
  { 'description': 'Number of times thread has been blocked while waiting for execution of an operation to complete by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_wait_exec_complete_count'},
  { 'description': 'Number of times thread has been blocked while waiting for execution of an operation to complete in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_wait_exec_complete_count_session'},
  { 'description': 'Number of times thread has been blocked while waiting for execution of an operation to complete by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_wait_exec_complete_count_slave'},
  { 'description': 'Number of times thread has been blocked waiting for a metadata-based signal by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_wait_meta_request_count'},
  { 'description': 'Number of times thread has been blocked waiting for a metadata-based signal in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_wait_meta_request_count_session'},
  { 'description': 'Number of times thread has been blocked waiting for a metadata-based signal by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_wait_meta_request_count_slave'},
  { 'description': 'Total time (in nanoseconds) spent waiting for some type of signal from the data nodes by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_wait_nanos_count'},
  { 'description': 'Total time (in nanoseconds) spent waiting for some type of signal from the data nodes in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_wait_nanos_count_session'},
  { 'description': 'Total time (in nanoseconds) spent waiting for some type of signal from the data nodes by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_wait_nanos_count_slave'},
  { 'description': 'Number of times thread has been blocked while waiting for a scan-based signal by this MySQL Server (SQL node).',
    'dynamic': False,
    'name': 'Ndb_api_wait_scan_result_count'},
  { 'description': 'Number of times thread has been blocked while waiting for a scan-based signal in this client session.',
    'dynamic': False,
    'name': 'Ndb_api_wait_scan_result_count_session'},
  { 'description': 'Number of times thread has been blocked while waiting for a scan-based signal by this slave.',
    'dynamic': False,
    'name': 'Ndb_api_wait_scan_result_count_slave'},
  { 'description': 'If the server is acting as a MySQL Cluster node, then the value of this variable its node ID in the cluster',
    'dynamic': False,
    'name': 'Ndb_cluster_node_id'},
  { 'description': 'The host name or IP address of the Cluster management server. Formerly Ndb_connected_host',
    'dynamic': False,
    'name': 'Ndb_config_from_host'},
  { 'description': 'The port for connecting to Cluster management server. Formerly Ndb_connected_port',
    'dynamic': False,
    'name': 'Ndb_config_from_port'},
  { 'description': 'Number of rows that have been found in conflict by the NDB$EPOCH() conflict detection function',
    'dynamic': False,
    'name': 'Ndb_conflict_fn_epoch'},
  { 'description': 'Number of rows that have been found in conflict by the NDB$EPOCH2() conflict detection function',
    'dynamic': False,
    'name': 'Ndb_conflict_fn_epoch2'},
  { 'description': 'Number of rows that have been found in conflict by the NDB$EPOCH2_TRANS() conflict detection function',
    'dynamic': False,
    'name': 'Ndb_conflict_fn_epoch2_trans'},
  { 'description': 'Number of rows that have been found in conflict by the NDB$EPOCH_TRANS() conflict detection function',
    'dynamic': False,
    'name': 'Ndb_conflict_fn_epoch_trans'},
  { 'description': 'If the server is part of a MySQL Cluster involved in cluster replication, the value of this variable indicates the number of times that conflict resolution based on "greater timestamp wins" has been applied',
    'dynamic': False,
    'name': 'Ndb_conflict_fn_max'},
  { 'description': 'Number of times that conflict resolution based on outcome of NDB$MAX_DELETE_WIN() has been applied.',
    'dynamic': False,
    'name': 'Ndb_conflict_fn_max_del_win'},
  { 'description': 'If the server is part of a MySQL Cluster involved in cluster replication, the value of this variable indicates the number of times that "same timestamp wins" conflict resolution has been applied',
    'dynamic': False,
    'name': 'Ndb_conflict_fn_old'},
  { 'description': 'Number of rows found to be in conflict by a transactional conflict function',
    'dynamic': False,
    'name': 'Ndb_conflict_last_stable_epoch'},
  { 'description': 'Number of reflected operations that were not applied due an error during execution.',
    'dynamic': False,
    'name': 'Ndb_conflict_reflected_op_discard_count'},
  { 'description': 'Number of reflected operations received that have been prepared for execution.',
    'dynamic': False,
    'name': 'Ndb_conflict_reflected_op_prepare_count'},
  { 'description': 'Number of refresh operations that have been prepared.',
    'dynamic': False,
    'name': 'Ndb_conflict_refresh_op_count'},
  { 'description': 'Number of epoch transactions committed after requiring transactional conflict handling.',
    'dynamic': False,
    'name': 'Ndb_conflict_trans_conflict_commit_count'},
  { 'description': 'Number of internal iterations required to commit an epoch transaction. Should be (slightly) greater than or equal to Ndb_conflict_trans_conflict_commit_count.',
    'dynamic': False,
    'name': 'Ndb_conflict_trans_detect_iter_count'},
  { 'description': 'Number of transactions rejected after being found in conflict by a transactional conflict function.',
    'dynamic': False,
    'name': 'Ndb_conflict_trans_reject_count'},
  { 'description': 'Number of rows found in conflict by a transactional conflict function. Includes any rows included in or dependent on conflicting transactions.',
    'dynamic': False,
    'name': 'Ndb_conflict_trans_row_conflict_count'},
  { 'description': 'Total number of rows realigned after being found in conflict by a transactional conflict function. Includes Ndb_conflict_trans_row_conflict_count and any rows included in or dependent on conflicting transactions.',
    'dynamic': False,
    'name': 'Ndb_conflict_trans_row_reject_count'},
  { 'description': 'Number of delete-delete conflicts detected (delete operation is applied, but row does not exist)',
    'dynamic': False,
    'name': 'Ndb_epoch_delete_delete_count'},
  { 'description': 'Provides the number of round trips to the NDB kernel made by operations',
    'dynamic': False,
    'name': 'Ndb_execute_count'},
  { 'description': 'Epoch most recently committed by NDB.',
    'dynamic': False,
    'name': 'Ndb_last_commit_epoch_server'},
  { 'description': 'Epoch most recently committed by this NDB client.',
    'dynamic': False,
    'name': 'Ndb_last_commit_epoch_session'},
  { 'description': 'If the server is part of a MySQL Cluster, the value of this variable is the number of data nodes in the cluster',
    'dynamic': False,
    'name': 'Ndb_number_of_data_nodes'},
  { 'description': 'Number of scans executed by NDB since the cluster was last started where partition pruning could be used',
    'dynamic': False,
    'name': 'Ndb_pruned_scan_count'},
  { 'description': 'Number of joins that API nodes have attempted to push down to the data nodes',
    'dynamic': False,
    'name': 'Ndb_pushed_queries_defined'},
  { 'description': 'Number of joins that API nodes have tried to push down, but failed',
    'dynamic': False,
    'name': 'Ndb_pushed_queries_dropped'},
  { 'description': 'Number of joins successfully pushed down and executed on the data nodes',
    'dynamic': False,
    'name': 'Ndb_pushed_queries_executed'},
  { 'description': 'Number of reads executed on the data nodes by pushed-down joins',
    'dynamic': False,
    'name': 'Ndb_pushed_reads'},
  { 'description': 'Activation threshold when receive thread takes over the polling of the cluster connection (measured in concurrently active threads)',
    'dynamic': False,
    'name': 'ndb_recv_thread_activation_threshold'},
  { 'description': 'The total number of scans executed by NDB since the cluster was last started',
    'dynamic': False,
    'name': 'Ndb_scan_count'},
  { 'description': 'Number of rows waiting to be written in INSERT DELAY queues',
    'dynamic': False,
    'name': 'Not_flushed_delayed_rows'},
  { 'description': 'Number of ongoing anonymous transactions that violate GTID consistency',
    'dynamic': False,
    'name': 'Ongoing_anonymous_gtid_violating_transaction_count'},
  { 'description': 'Number of ongoing anonymous transactions',
    'dynamic': False,
    'name': 'Ongoing_anonymous_transaction_count'},
  { 'description': 'Number of ongoing automatic transactions that violate GTID consistency',
    'dynamic': False,
    'name': 'Ongoing_automatic_gtid_violating_transaction_count'},
  { 'description': 'Number of files that are open',
    'dynamic': False,
    'name': 'Open_files'},
  { 'description': 'Number of streams that are open (used mainly for logging)',
    'dynamic': False,
    'name': 'Open_streams'},
  { 'description': 'Number of cached table definitions',
    'dynamic': False,
    'name': 'Open_table_definitions'},
  { 'description': 'Number of tables that are open',
    'dynamic': False,
    'name': 'Open_tables'},
  { 'description': 'Number of files that have been opened using my_open()',
    'dynamic': False,
    'name': 'Opened_files'},
  { 'description': 'Number of table definitions that have been cached',
    'dynamic': False,
    'name': 'Opened_table_definitions'},
  { 'description': 'Number of tables that have been opened',
    'dynamic': False,
    'name': 'Opened_tables'},
  { 'description': 'How many accounts table rows could not be added',
    'dynamic': False,
    'name': 'Performance_schema_accounts_lost'},
  { 'description': 'How many condition instruments could not be loaded',
    'dynamic': False,
    'name': 'Performance_schema_cond_classes_lost'},
  { 'description': 'How many condition instrument instances could not be created',
    'dynamic': False,
    'name': 'Performance_schema_cond_instances_lost'},
  { 'description': 'How many digests could not be instrumented',
    'dynamic': False,
    'name': 'Performance_schema_digest_lost'},
  { 'description': 'How many file instruments could not be loaded',
    'dynamic': False,
    'name': 'Performance_schema_file_classes_lost'},
  { 'description': 'How many file instrument instances could not be opened',
    'dynamic': False,
    'name': 'Performance_schema_file_handles_lost'},
  { 'description': 'How many file instrument instances could not be created',
    'dynamic': False,
    'name': 'Performance_schema_file_instances_lost'},
  { 'description': 'How many hosts table rows could not be added',
    'dynamic': False,
    'name': 'Performance_schema_hosts_lost'},
  { 'description': 'Number of indexes for which statistics were lost',
    'dynamic': False,
    'name': 'Performance_schema_index_stat_lost'},
  { 'description': 'How many events are lost or not recorded',
    'dynamic': False,
    'name': 'Performance_schema_locker_lost'},
  { 'description': 'How many memory instruments could not be loaded',
    'dynamic': False,
    'name': 'Performance_schema_memory_classes_lost'},
  { 'description': 'Number of metadata locks that could not be recorded',
    'dynamic': False,
    'name': 'Performance_schema_metadata_lock_lost'},
  { 'description': 'How many mutex instruments could not be loaded',
    'dynamic': False,
    'name': 'Performance_schema_mutex_classes_lost'},
  { 'description': 'How many mutex instrument instances could not be created',
    'dynamic': False,
    'name': 'Performance_schema_mutex_instances_lost'},
  { 'description': 'Number of stored program statements for which statistics were lost',
    'dynamic': False,
    'name': 'Performance_schema_nested_statement_lost'},
  { 'description': 'Number of prepared statements that could not be instrumented',
    'dynamic': False,
    'name': 'Performance_schema_prepared_statements_lost'},
  { 'description': 'Number of stored programs for which statistics were lost',
    'dynamic': False,
    'name': 'Performance_schema_program_lost'},
  { 'description': 'How many rwlock instruments could not be loaded',
    'dynamic': False,
    'name': 'Performance_schema_rwlock_classes_lost'},
  { 'description': 'How many rwlock instrument instances could not be created',
    'dynamic': False,
    'name': 'Performance_schema_rwlock_instances_lost'},
  { 'description': 'The size of the longest valid connection attribute buffer seen',
    'dynamic': False,
    'name': 'Performance_schema_session_connect_attrs_longest_seen'},
  { 'description': 'The number of connections for which attribute strings could not be created',
    'dynamic': False,
    'name': 'Performance_schema_session_connect_attrs_lost'},
  { 'description': 'How many socket instruments could not be loaded',
    'dynamic': False,
    'name': 'Performance_schema_socket_classes_lost'},
  { 'description': 'How many socket instrument instances could not be created',
    'dynamic': False,
    'name': 'Performance_schema_socket_instances_lost'},
  { 'description': 'How many stage instruments could not be loaded',
    'dynamic': False,
    'name': 'Performance_schema_stage_classes_lost'},
  { 'description': 'How many statement instruments could not be loaded',
    'dynamic': False,
    'name': 'Performance_schema_statement_classes_lost'},
  { 'description': 'How many table instrument instances could not be opened',
    'dynamic': False,
    'name': 'Performance_schema_table_handles_lost'},
  { 'description': 'How many table instrument instances could not be created',
    'dynamic': False,
    'name': 'Performance_schema_table_instances_lost'},
  { 'description': 'Number of tables for which lock statistics were lost',
    'dynamic': False,
    'name': 'Performance_schema_table_lock_stat_lost'},
  { 'description': 'How many thread instruments could not be loaded',
    'dynamic': False,
    'name': 'Performance_schema_thread_classes_lost'},
  { 'description': 'How many thread instrument instances could not be created',
    'dynamic': False,
    'name': 'Performance_schema_thread_instances_lost'},
  { 'description': 'How many users table rows could not be added',
    'dynamic': False,
    'name': 'Performance_schema_users_lost'},
  { 'description': 'The current number of prepared statements',
    'dynamic': False,
    'name': 'Prepared_stmt_count'},
  { 'description': 'Number of free memory blocks in the query cache',
    'dynamic': False,
    'name': 'Qcache_free_blocks'},
  { 'description': 'The amount of free memory for the query cache',
    'dynamic': False,
    'name': 'Qcache_free_memory'},
  { 'description': 'Number of query cache hits',
    'dynamic': False,
    'name': 'Qcache_hits'},
  { 'description': 'Number of query cache inserts',
    'dynamic': False,
    'name': 'Qcache_inserts'},
  { 'description': 'Number of queries that were deleted from the query cache due to lack of free memory in the cache',
    'dynamic': False,
    'name': 'Qcache_lowmem_prunes'},
  { 'description': 'Number of noncached queries (not cacheable, or not cached due to the query_cache_type setting)',
    'dynamic': False,
    'name': 'Qcache_not_cached'},
  { 'description': 'Number of queries registered in the query cache',
    'dynamic': False,
    'name': 'Qcache_queries_in_cache'},
  { 'description': 'The total number of blocks in the query cache',
    'dynamic': False,
    'name': 'Qcache_total_blocks'},
  { 'description': 'Number of statements executed by the server',
    'dynamic': False,
    'name': 'Queries'},
  { 'description': 'Number of statements that clients have sent to the server',
    'dynamic': False,
    'name': 'Questions'},
  { 'description': 'Number of rewrite rules successfully loaded into memory',
    'dynamic': False,
    'name': 'Rewriter_number_loaded_rules'},
  { 'description': 'Number of reloads of rules table into memory',
    'dynamic': False,
    'name': 'Rewriter_number_reloads'},
  { 'description': 'Number of queries rewritten since the plugin was loaded',
    'dynamic': False,
    'name': 'Rewriter_number_rewritten_queries'},
  { 'description': 'Whether an error occurred when last loading the rewriting rules into memory',
    'dynamic': False,
    'name': 'Rewriter_reload_error'},
  { 'description': 'Number of semisynchronous slaves',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_clients'},
  { 'description': 'The average time the master waited for a slave reply',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_net_avg_wait_time'},
  { 'description': 'The total time the master waited for slave replies',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_net_wait_time'},
  { 'description': 'The total number of times the master waited for slave replies',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_net_waits'},
  { 'description': 'Number of times the master turned off semisynchronous replication',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_no_times'},
  { 'description': 'Number of commits not acknowledged successfully',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_no_tx'},
  { 'description': 'Whether semisynchronous replication is operational on the master',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_status'},
  { 'description': 'Number of times the master failed when calling time functions',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_timefunc_failures'},
  { 'description': 'The average time the master waited for each transaction',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_tx_avg_wait_time'},
  { 'description': 'The total time the master waited for transactions',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_tx_wait_time'},
  { 'description': 'The total number of times the master waited for transactions',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_tx_waits'},
  { 'description': 'The total number of times the master waited for an event with binary coordinates lower than events waited for previously',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_wait_pos_backtraverse'},
  { 'description': 'Number of sessions currently waiting for slave replies',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_wait_sessions'},
  { 'description': 'Number of commits acknowledged successfully',
    'dynamic': False,
    'name': 'Rpl_semi_sync_master_yes_tx'},
  { 'description': 'Whether semisynchronous replication is operational on slave',
    'dynamic': False,
    'name': 'Rpl_semi_sync_slave_status'},
  { 'description': 'The status of fail-safe replication (not implemented)',
    'dynamic': False,
    'name': 'Rpl_status'},
  { 'description': 'The RSA public key value',
    'dynamic': False,
    'name': 'Rsa_public_key'},
  { 'description': 'Number of joins that perform table scans because they do not use indexes',
    'dynamic': False,
    'name': 'Select_full_join'},
  { 'description': 'Number of joins that used a range search on a reference table',
    'dynamic': False,
    'name': 'Select_full_range_join'},
  { 'description': 'Number of joins that used ranges on the first table',
    'dynamic': False,
    'name': 'Select_range'},
  { 'description': 'Number of joins without keys that check for key usage after each row',
    'dynamic': False,
    'name': 'Select_range_check'},
  { 'description': 'Number of joins that did a full scan of the first table',
    'dynamic': False,
    'name': 'Select_scan'},
  { 'description': "The slave's replication heartbeat interval, in seconds",
    'dynamic': False,
    'name': 'Slave_heartbeat_period'},
  { 'description': 'Shows when the latest heartbeat signal was received, in TIMESTAMP format.',
    'dynamic': False,
    'name': 'Slave_last_heartbeat'},
  { 'description': 'Number of temporary tables that the slave SQL thread currently has open',
    'dynamic': False,
    'name': 'Slave_open_temp_tables'},
  { 'description': 'Number of heartbeats received by a replication slave since previous reset',
    'dynamic': False,
    'name': 'Slave_received_heartbeats'},
  { 'description': 'The total number of times since startup that the replication slave SQL thread has retried transactions',
    'dynamic': False,
    'name': 'Slave_retried_transactions'},
  { 'description': 'The state of this server as a replication slave (slave I/O thread status)',
    'dynamic': False,
    'name': 'Slave_running'},
  { 'description': 'Number of threads that have taken more than slow_launch_time seconds to create',
    'dynamic': False,
    'name': 'Slow_launch_threads'},
  { 'description': 'Number of queries that have taken more than long_query_time seconds',
    'dynamic': False,
    'name': 'Slow_queries'},
  { 'description': 'Number of merge passes that the sort algorithm has had to do',
    'dynamic': False,
    'name': 'Sort_merge_passes'},
  { 'description': 'Number of sorts that were done using ranges',
    'dynamic': False,
    'name': 'Sort_range'},
  { 'description': 'Number of sorted rows',
    'dynamic': False,
    'name': 'Sort_rows'},
  { 'description': 'Number of sorts that were done by scanning the table',
    'dynamic': False,
    'name': 'Sort_scan'},
  { 'description': 'Number of negotiates needed to establish the connection',
    'dynamic': False,
    'name': 'Ssl_accept_renegotiates'},
  { 'description': 'Number of accepted SSL connections',
    'dynamic': False,
    'name': 'Ssl_accepts'},
  { 'description': 'Number of callback cache hits',
    'dynamic': False,
    'name': 'Ssl_callback_cache_hits'},
  { 'description': 'The current SSL cipher',
    'dynamic': False,
    'name': 'Ssl_cipher'},
  { 'description': 'The list of possible SSL ciphers',
    'dynamic': False,
    'name': 'Ssl_cipher_list'},
  { 'description': 'Number of SSL connection attempts to an SSL-enabled master',
    'dynamic': False,
    'name': 'Ssl_client_connects'},
  { 'description': 'Number of negotiates needed to establish the connection to an SSL-enabled master',
    'dynamic': False,
    'name': 'Ssl_connect_renegotiates'},
  { 'description': 'The SSL context verification depth (how many certificates in the chain are tested)',
    'dynamic': False,
    'name': 'Ssl_ctx_verify_depth'},
  { 'description': 'The SSL context verification mode',
    'dynamic': False,
    'name': 'Ssl_ctx_verify_mode'},
  { 'description': 'The default SSL timeout',
    'dynamic': False,
    'name': 'Ssl_default_timeout'},
  { 'description': 'Number of successful SSL connections to the server',
    'dynamic': False,
    'name': 'Ssl_finished_accepts'},
  { 'description': 'Number of successful slave connections to an SSL-enabled master',
    'dynamic': False,
    'name': 'Ssl_finished_connects'},
  { 'description': 'SSL certificate last valid date',
    'dynamic': False,
    'name': 'Ssl_server_not_after'},
  { 'description': 'SSL certificate first valid date',
    'dynamic': False,
    'name': 'Ssl_server_not_before'},
  { 'description': 'Number of SSL session cache hits',
    'dynamic': False,
    'name': 'Ssl_session_cache_hits'},
  { 'description': 'Number of SSL session cache misses',
    'dynamic': False,
    'name': 'Ssl_session_cache_misses'},
  { 'description': 'The SSL session cache mode',
    'dynamic': False,
    'name': 'Ssl_session_cache_mode'},
  { 'description': 'Number of SSL session cache overflows',
    'dynamic': False,
    'name': 'Ssl_session_cache_overflows'},
  { 'description': 'The SSL session cache size',
    'dynamic': False,
    'name': 'Ssl_session_cache_size'},
  { 'description': 'Number of SSL session cache timeouts',
    'dynamic': False,
    'name': 'Ssl_session_cache_timeouts'},
  { 'description': 'How many SSL connections were reused from the cache',
    'dynamic': False,
    'name': 'Ssl_sessions_reused'},
  { 'description': 'How many SSL session cache entries were used',
    'dynamic': False,
    'name': 'Ssl_used_session_cache_entries'},
  { 'description': 'The verification depth for replication SSL connections',
    'dynamic': False,
    'name': 'Ssl_verify_depth'},
  { 'description': 'The verification mode for replication SSL connections',
    'dynamic': False,
    'name': 'Ssl_verify_mode'},
  { 'description': 'The SSL version number',
    'dynamic': False,
    'name': 'Ssl_version'},
  { 'description': 'Number of times that a table lock was acquired immediately',
    'dynamic': False,
    'name': 'Table_locks_immediate'},
  { 'description': 'Number of times that a table lock could not be acquired immediately and a wait was needed',
    'dynamic': False,
    'name': 'Table_locks_waited'},
  { 'description': 'Number of hits for open tables cache lookups',
    'dynamic': False,
    'name': 'Table_open_cache_hits'},
  { 'description': 'Number of misses for open tables cache lookups',
    'dynamic': False,
    'name': 'Table_open_cache_misses'},
  { 'description': 'Number of overflows for the open tables cache',
    'dynamic': False,
    'name': 'Table_open_cache_overflows'},
  { 'description': 'When the memory-mapped implementation of the log that is used by mysqld acts as the transaction coordinator for recovery of internal XA transactions,this variable indicates the largest number of pages used for the log since the server started',
    'dynamic': False,
    'name': 'Tc_log_max_pages_used'},
  { 'description': 'The page size used for the memory-mapped implementation of the XA recovery log',
    'dynamic': False,
    'name': 'Tc_log_page_size'},
  { 'description': 'For the memory-mapped implementation of the recovery log, this variable increments each time the server was not able to commit a transaction and had to wait for a free page in the log',
    'dynamic': False,
    'name': 'Tc_log_page_waits'},
  { 'description': 'Number of threads in the thread cache',
    'dynamic': False,
    'name': 'Threads_cached'},
  { 'description': 'Number of currently open connections',
    'dynamic': False,
    'name': 'Threads_connected'},
  { 'description': 'Number of threads created to handle connections',
    'dynamic': False,
    'name': 'Threads_created'},
  { 'description': 'Number of threads that are not sleeping',
    'dynamic': False,
    'name': 'Threads_running'},
  { 'description': 'Number of seconds the server has been up',
    'dynamic': False,
    'name': 'Uptime'},
  { 'description': 'Number of seconds since the most recent FLUSH STATUS',
    'dynamic': False,
    'name': 'Uptime_since_flush_status'},
  { 'description': 'When the dictionary file was last parsed',
    'dynamic': False,
    'name': 'validate_password_dictionary_file_last_parsed'},
  { 'description': 'Number of words in dictionary file',
    'dynamic': False,
    'name': 'validate_password_dictionary_file_words_count'}]
