opts_list = [
( 'General', [
	( 'Features', [
		{'caption': 'federated', 'versions': [((5, 1, 26), (6, 0, 7)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'numeric'}], 'description': 'Enables the FEDERATED storage engine', 'name': 'federated'},
		{'caption': 'enable-locking', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)), ((5, 5, 3),)], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Deprecated option, use --external-locking instead', 'name': 'enable-locking'},
		{'description': 'Print a symbolic stack trace on failure', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)), ((5, 5, 7),)], 'deprecated': (5, 1, 54), 'caption': 'enable-pstack', 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'name': 'enable-pstack'},
		{'caption': 'event-scheduler', 'versions': [((5, 1, 6),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'OFF', 'type': 'enum', 'choice': ['ON', 'OFF', 'DISABLED']}], 'description': 'Enable/disable and start/stop the event scheduler. Note that this variable underwent significant changes in behavior and permitted values in MySQL 5.1.11 and 5.1.12', 'name': 'event-scheduler'},
		{'description': 'Obsolete. ISAM storage engine is no longer supported', 'versions': [(), ((4, 1),), ()], 'deprecated': None, 'caption': 'isam', 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'name': 'isam'},
		{'description': 'Enable (or disable) partitioning support', 'versions': [(), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'disabledby': 'skip-partition', 'caption': 'partition', 'values': [{'default': 'on', 'on': 'on', 'off': 'disabledby', 'type': 'boolean'}], 'name': 'partition'},
		{'caption': 'plugin', 'versions': [(), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Prefix for specifying plugin-specific options.', 'name': 'plugin'},
		{'optype': {'format': 'plugin-load=plugin_list'}, 'description': 'Set the list of plugins to load at startup', 'versions': [((5, 1, 18),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'plugin-load', 'values': [{'type': 'string'}], 'name': 'plugin-load'},
		{'optype': {'format': 'plugin-load-add=plugin_list'}, 'description': 'Add to list of plugins to load at startup', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'caption': 'plugin-load-add', 'values': [{'type': 'string'}], 'name': 'plugin-load-add'},
		{'caption': 'profiling_history_size', 'versions': [((5, 0, 37), (5, 1, 24), (6, 0, 5)), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '15', 'minimum': '0', 'type': 'numeric', 'maximum': '100'}], 'description': 'How many statements to maintain profiling information for', 'name': 'profiling_history_size'},
		{'caption': 'skip-event-scheduler', 'versions': [(), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Sets the Event Scheduler to OFF.', 'name': 'skip-event-scheduler'},
		{'caption': 'skip-partition', 'versions': [(), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Do not enable user-defined partitioning', 'name': 'skip-partition'}]),
	( 'Transactions', [
		{'caption': 'autocommit', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': '1', 'off': '0', 'type': 'boolean'}], 'description': 'Sets the autocommit mode', 'name': 'autocommit'}]),
	( 'Memory usage', [
		{'caption': 'host_cache_size', 'versions': [((5, 6, 5),), ((5, 6), (5, 7)), ()], 'values': [{'default': '128', 'minimum': '0', 'type': 'numeric', 'maximum': '65536'}], 'description': 'The size of the host cache', 'name': 'host_cache_size'},
		{'caption': 'join_buffer_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'outversion': (5, 6, 5), 'default': '131072', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '8200', 'type': 'numeric'}, {'inversion': (5, 6, 6), 'default': '262144', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '8200', 'type': 'numeric'}, {'outversion': (6, 0, 8), 'default': '131072', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '8200', 'type': 'numeric'}, {'inversion': (6, 0, 9), 'default': '131072', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '128', 'type': 'numeric'}, {'outversion': (5, 6, 5), 'default': '131072', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '8200', 'type': 'numeric'}, {'inversion': (5, 6, 6), 'default': '262144', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '128', 'type': 'numeric'}, {'outversion': (6, 0, 8), 'default': '131072', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '8200', 'type': 'numeric'}, {'inversion': (6, 0, 9), 'default': '131072', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '128', 'type': 'numeric'}], 'description': 'The size of the buffer that is used for full joins', 'name': 'join_buffer_size'},
		{'caption': 'join_cache_level', 'versions': [((6, 0, 9),), ((6, 0),), ((6, 0, 14),)], 'values': [{'default': '1', 'minimum': '0', 'type': 'numeric', 'maximum': '8'}], 'description': 'How join buffers are used', 'name': 'join_cache_level'},
		{'caption': 'large-pages', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'type': 'boolean', 'off': 'false', 'platform': 'linux'}], 'description': 'Enable support for large pages', 'name': 'large-pages'},
		{'caption': 'query_alloc_block_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '8192', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '1024', 'blocksize': '1024', 'type': 'numeric'}, {'default': '8192', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '1024', 'blocksize': '1024', 'type': 'numeric'}], 'description': 'Allocation block size for query parsing and execution', 'name': 'query_alloc_block_size'},
		{'caption': 'sort_buffer_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '2097144', 'bitsize': '32', 'minimum': '32768', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '2097144', 'bitsize': '64', 'minimum': '32768', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'Each thread that needs to do a sort allocates a buffer of this size', 'name': 'sort_buffer_size'}]),
	( 'Informational', [
		{'caption': 'server-id', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'Uniquely identifies the server instance in the community of replication partners. Must be set to a value greater than 0 to enable replication.', 'name': 'server-id'},
		{'caption': 'server-id-bits', 'versions': [((5, 1, 47),), ((5, 1), (5, 5)), ()], 'values': [{'default': '32', 'minimum': '7', 'type': 'numeric', 'maximum': '32'}], 'description': 'Sets the number of least significant bits in the server_id actually used for identifying the server, permitting NDB API applications to store application data in the most significant bits. server_id must be less than 2 to the power of this value.', 'name': 'server-id-bits'}]),
	( 'Directories', [
		{'caption': 'basedir', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filename'}], 'description': 'Path to installation directory', 'name': 'basedir'},
		{'caption': 'datadir', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filename'}], 'description': 'Path to the database root', 'name': 'datadir'},
		{'caption': 'plugin_dir', 'versions': [((4, 1, 25), (5, 0, 67), (5, 1, 2)), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '{basedir}/lib/plugin', 'platform': 'windows', 'inversion': (5, 1, 2), 'type': 'dirname'}, {'default': '{basedir}/lib/mysql/plugin', 'platform': 'other', 'inversion': (5, 1, 2), 'type': 'dirname'}, {'default': '{basedir}/lib/plugin', 'platform': 'windows', 'inversion': (5, 5, 0), 'type': 'dirname', 'outversion': (5, 5, 4)}, {'default': '{basedir}/lib/mysql/plugin', 'platform': 'other', 'inversion': (5, 5, 0), 'type': 'dirname', 'outversion': (5, 5, 4)}, {'default': '{basedir}/lib/plugin', 'inversion': (5, 5, 5), 'type': 'dirname'}], 'description': 'Directory for plugins', 'name': 'plugin_dir'},
		{'caption': 'tmpdir', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filename'}], 'description': 'Path for temporary files', 'name': 'tmpdir'}]),
	( 'System', [
		{'caption': 'core-file', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Write core file on server crashes', 'name': 'core-file'},
		{'description': 'Use system (external) locking', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'disabledby': 'skip-external-locking', 'caption': 'external-locking', 'values': [{'default': 'false', 'on': 'true', 'off': 'disabledby', 'type': 'boolean'}], 'name': 'external-locking'},
		{'caption': 'gdb', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Set up signals usable for debugging', 'name': 'gdb'},
		{'caption': 'ignore-db-dir', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'type': 'dirname'}], 'description': 'Treat directory as nondatabase directory', 'name': 'ignore-db-dir'},
		{'caption': 'lower_case_table_names', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '2'}], 'description': 'If set to 1, table names are stored in lowercase on disk and table names will be case insensitive. Should be set to 2 if you are using a case-insensitive file system.', 'name': 'lower_case_table_names'},
		{'optype': {'format': 'pid-file=file_name'}, 'description': 'Process ID file used by mysqld_safe', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'pid-file', 'values': [{'type': 'filename'}], 'name': 'pid-file'},
		{'caption': 'skip-external-locking', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Skip system (external) locking', 'name': 'skip-external-locking'},
		{'caption': 'skip-host-cache', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': "Don't cache host names", 'name': 'skip-host-cache'},
		{'description': 'Deprecated option', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)), ((5, 5, 3),)], 'deprecated': None, 'caption': 'skip-locking', 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'name': 'skip-locking'},
		{'caption': 'skip-stack-trace', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': "Don't print a stack trace on failure", 'name': 'skip-stack-trace'},
		{'caption': 'skip-symlink', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)), ((5, 5, 3),)], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': "Don't allow symlinking of tables. Deprecated option. Use --skip-symbolic-links.", 'name': 'skip-symlink'},
		{'description': 'Use symbolic links', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'disabledby': 'skip-symbolic-links', 'caption': 'symbolic-links', 'values': [{'on': '1', 'off': '0', 'type': 'boolean'}], 'name': 'symbolic-links'},
		{'caption': 'sysdate-is-now', 'versions': [((5, 0, 20), (5, 1, 8)), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Nondefault option to alias SYSDATE() to NOW() to make it safe-replicable', 'name': 'sysdate-is-now'},
		{'description': 'Enable symbolic link support. Deprecated option. Use --symbolic-links.', 'versions': [(), ((5, 1), (5, 4), (6, 0)), ()], 'deprecated': (5, 0), 'caption': 'use-symbolic-links', 'values': [{'default': 'true', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'name': 'use-symbolic-links'},
		{'caption': 'user', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Run mysqld daemon as user', 'name': 'user'},
		{'caption': 'skip-safemalloc', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)), ((5, 5, 6),)], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': "Don't check for memory overruns during each memory allocation", 'name': 'skip-safemalloc'},
		{'caption': 'lower_case_file_system', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': '1', 'off': '0', 'type': 'boolean'}], 'description': 'This variable describes the case sensitivity of file names on the file system', 'name': 'lower_case_file_system'}]),
	( 'General', [
		{'caption': 'auto_increment_increment', 'versions': [((5, 0, 2),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1', 'minimum': '1', 'type': 'numeric', 'maximum': '65535'}], 'description': 'AUTO_INCREMENT columns are incremented by this value', 'name': 'auto_increment_increment'},
		{'caption': 'auto_increment_offset', 'versions': [((5, 0, 2),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1', 'minimum': '1', 'type': 'numeric', 'maximum': '65535'}], 'description': 'Offset added to AUTO_INCREMENT columns', 'name': 'auto_increment_offset'},
		{'caption': 'big-tables', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)), ((5, 6, 1),)], 'values': [{'on': '1', 'off': '0', 'type': 'boolean'}], 'description': 'Allow big result sets by saving all temporary sets on file', 'name': 'big-tables'},
		{'caption': 'default-storage-engine', 'versions': [((4, 1, 2),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'MyISAM', 'outversion': (5, 5, 4), 'type': 'enum'}, {'default': 'InnoDB', 'inversion': (5, 5, 5), 'type': 'enum'}, {'default': 'MyISAM', 'inversion': (6, 0, 0), 'type': 'enum'}], 'description': 'The default storage engine (table type) for tables', 'name': 'default-storage-engine'},
		{'caption': 'default_tmp_storage_engine', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'InnoDB', 'type': 'enum'}], 'description': 'The default storage engine (table type) for TEMPORARY tables', 'name': 'default_tmp_storage_engine'},
		{'description': 'This option is a synonym for --default-storage-engine', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (6, 0)), ((6, 0, 8),)], 'deprecated': (5, 0), 'caption': 'default-table-type', 'values': [{'type': 'string'}], 'name': 'default-table-type'},
		{'optype': {'format': 'init-file=file_name'}, 'description': 'Read SQL statements from this file at startup', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'init-file', 'values': [{'type': 'filename'}], 'name': 'init-file'},
		{'caption': 'lock_wait_timeout', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '31536000', 'minimum': '1', 'type': 'numeric', 'maximum': '31536000'}], 'description': 'Timeout for metadata locks', 'name': 'lock_wait_timeout'},
		{'caption': 'max_long_data_size', 'versions': [((5, 1, 57), (5, 5, 11)), ((5, 1), (5, 5)), ()], 'values': [{'default': '1048576', 'minimum': '1024', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'Max size of parameter values that mysql_stmt_send_long_data() can send', 'name': 'max_long_data_size'},
		{'caption': 'stored_program_cache', 'versions': [((5, 5, 21), (5, 6, 5)), ((5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '256', 'minimum': '256', 'type': 'numeric', 'maximum': '524288'}], 'description': 'Sets a "soft" upper limit for number of cached stored routines per connection. Stored procedures and stored functions are cached separately; this variable sets the size for both of these.', 'name': 'stored_program_cache'},
		{'caption': 'old', 'versions': [((5, 1, 18),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Cause the server to revert to certain behaviors present in older versions', 'name': 'old'},
		{'caption': 'one-thread', 'versions': [(), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)), ((5, 6, 1),)], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Only use one thread (for debugging under Linux)', 'name': 'one-thread'}]),
	( 'Iternational', [
		{'caption': 'character-set-client-handshake', 'versions': [((4, 1, 15),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'true', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': "Don't ignore client side character set value sent during handshake", 'name': 'character-set-client-handshake'},
		{'caption': 'character-set-filesystem', 'versions': [((5, 0, 19), (5, 1, 6)), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Set the file system character set', 'name': 'character-set-filesystem'},
		{'caption': 'character-set-server', 'versions': [((4, 1, 3),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Set the default character set', 'name': 'character-set-server'},
		{'optype': {'format': 'character-sets-dir=path'}, 'description': 'Directory where character sets are', 'versions': [((4, 1, 2),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'character-sets-dir', 'values': [{'type': 'dirname'}], 'name': 'character-sets-dir'},
		{'caption': 'collation-server', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Set the default collation', 'name': 'collation-server'},
		{'optype': {'format': 'default-character-set=name'}, 'description': 'Set the default character set', 'versions': [((4, 1, 3),), ((4, 1), (5, 0)), ()], 'deprecated': (5, 0), 'caption': 'default-character-set', 'values': [{'type': 'string'}], 'name': 'default-character-set'},
		{'optype': {'format': 'default-collation=name'}, 'description': 'Set the default collation', 'versions': [(), ((4, 1),), ()], 'deprecated': (4, 1, 3), 'caption': 'default-collation', 'values': [{'type': 'string'}], 'name': 'default-collation'},
		{'caption': 'default-time-zone', 'versions': [((4, 1, 3),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Set the default time zone', 'name': 'default-time-zone'},
		{'caption': 'default_week_format', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '7'}], 'description': 'The default week format used by WEEK() functions', 'name': 'default_week_format'},
		{'description': 'Client error messages in given language. May be given as a full path', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'deprecated': (5, 5, 0), 'caption': 'language', 'values': [{'default': '/usr/local/mysql/share/mysql/english/', 'type': 'dirname'}], 'name': 'language'},
		{'caption': 'lc-messages', 'versions': [((6, 0, 14),), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'The locale for error messages', 'name': 'lc-messages'},
		{'caption': 'lc-messages-dir', 'versions': [((6, 0, 14),), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'dirname'}], 'description': 'The directory where error messages are located', 'name': 'lc-messages-dir'},
		{'caption': 'skip-character-set-client-handshake', 'versions': [((4, 1, 15), (5, 0, 13)), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Ignore client side character set value sent during handshake', 'name': 'skip-character-set-client-handshake'},
		{'optype': {'format': 'default_time_zone'}, 'description': 'The current time zone.', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'time_zone', 'values': [{'type': 'string'}], 'name': 'time_zone'}]),
	( 'SQL', [
		{'caption': 'ansi', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Use ANSI SQL syntax instead of MySQL syntax', 'name': 'ansi'},
		{'caption': 'explicit_defaults_for_timestamp', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Whether TIMESTAMP columns are nullable and have DEFAULT NULL', 'name': 'explicit_defaults_for_timestamp'},
		{'caption': 'sql-bin-update-same', 'versions': [(), ((4, 1),), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'The update log is deprecated since version 5.0, is replaced by the binary log and this option does nothing anymore', 'name': 'sql-bin-update-same'},
		{'caption': 'sql-mode', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': "''", 'inversion': (4, 1, 0), 'type': 'set', 'outversion': (5, 6, 5), 'choice': ['ALLOW_INVALID_DATES', 'ANSI_QUOTES', 'ERROR_FOR_DIVISION_BY_ZERO', 'HIGH_NOT_PRECEDENCE', 'IGNORE_SPACE', 'NO_AUTO_CREATE_USER', 'NO_AUTO_VALUE_ON_ZERO', 'NO_BACKSLASH_ESCAPES', 'NO_DIR_IN_CREATE', 'NO_ENGINE_SUBSTITUTION', 'NO_FIELD_OPTIONS', 'NO_KEY_OPTIONS', 'NO_TABLE_OPTIONS', 'NO_UNSIGNED_SUBTRACTION', 'NO_ZERO_DATE', 'NO_ZERO_IN_DATE', 'ONLY_FULL_GROUP_BY', 'PAD_CHAR_TO_FULL_LENGTH', 'PIPES_AS_CONCAT', 'REAL_AS_FLOAT', 'STRICT_ALL_TABLES', 'STRICT_TRANS_TABLES']}, {'default': 'NO_ENGINE_SUBSTITUTION', 'inversion': (5, 6, 6), 'type': 'set', 'choice': ['ALLOW_INVALID_DATES', 'ANSI_QUOTES', 'ERROR_FOR_DIVISION_BY_ZERO', 'HIGH_NOT_PRECEDENCE', 'IGNORE_SPACE', 'NO_AUTO_CREATE_USER', 'NO_AUTO_VALUE_ON_ZERO', 'NO_BACKSLASH_ESCAPES', 'NO_DIR_IN_CREATE', 'NO_ENGINE_SUBSTITUTION', 'NO_FIELD_OPTIONS', 'NO_KEY_OPTIONS', 'NO_TABLE_OPTIONS', 'NO_UNSIGNED_SUBTRACTION', 'NO_ZERO_DATE', 'NO_ZERO_IN_DATE', 'ONLY_FULL_GROUP_BY', 'PAD_CHAR_TO_FULL_LENGTH', 'PIPES_AS_CONCAT', 'REAL_AS_FLOAT', 'STRICT_ALL_TABLES', 'STRICT_TRANS_TABLES']}], 'description': 'Set the SQL server mode', 'name': 'sql-mode'}]),
	( 'Backup', [
		{'caption': 'backup_elevation', 'versions': [((6, 0, 14),), ((6, 0),), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Enable or disable BACKUP DATABASE privilege elevation', 'name': 'backup_elevation'},
		{'caption': 'backup_history_log', 'versions': [((6, 0, 8),), ((6, 0),), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Enable or disable MySQL Backup history log', 'name': 'backup_history_log'},
		{'caption': 'backup_history_log_file', 'versions': [((6, 0, 8),), ((6, 0),), ()], 'values': [{'default': 'backup_history.log', 'type': 'filename'}], 'description': 'Name of the MySQL Backup history log file', 'name': 'backup_history_log_file'},
		{'caption': 'backup_progress_log', 'versions': [((6, 0, 8),), ((6, 0),), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Enable or disable MySQL Backup progress log', 'name': 'backup_progress_log'},
		{'caption': 'backup_progress_log_file', 'versions': [((6, 0, 8),), ((6, 0),), ()], 'values': [{'default': 'backup_progress.log', 'type': 'filename'}], 'description': 'Name of the MySQL Backup progress log file', 'name': 'backup_progress_log_file'},
		{'caption': 'backupdir', 'versions': [((6, 0, 7),), ((6, 0),), ()], 'values': [{'type': 'filename'}], 'description': 'Default backup image file directory', 'name': 'backupdir'},
		{'caption': 'log-backup-output', 'versions': [((6, 0, 8),), ((6, 0),), ()], 'values': [{'default': 'TABLE', 'type': 'set', 'choice': ['TABLE', 'FILE', 'NONE']}], 'description': 'The destination for MySQL Backup history and progress log output. Syntax: log-backup-output[=value[,value...]], where "value" could be TABLE, FILE, or NONE', 'name': 'log-backup-output'},
		{'caption': 'mysql-backup', 'versions': [((6, 0, 14),), ((6, 0),), ()], 'values': [], 'description': 'Enable MySQL Backup features', 'name': 'mysql-backup'}])]),
( 'Logging', [
	( 'Audit', [
		{'optype': {'format': 'audit-log[=value]'}, 'description': 'Whether to activate the audit log plugin', 'versions': [((5, 5, 28),), ((5, 5),), ()], 'caption': 'audit-log', 'values': [{'default': 'ON', 'type': 'enum', 'choice': ['ON', 'OFF', 'FORCE', 'FORCE_PLUS_PERMANENT']}], 'name': 'audit-log'}]),
	( 'Slow query log options', [
		{'caption': 'log-slow-admin-statements', 'versions': [((4, 1, 13),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Log slow OPTIMIZE, ANALYZE, ALTER and other administrative statements to the slow query log if it is open', 'name': 'log-slow-admin-statements'},
		{'description': 'Whether to log slow queries. Logging defaults to hostname-slow.log file. Must be enabled to activate other slow query log options', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)), ((5, 6, 1),)], 'deprecated': (5, 1, 29), 'caption': 'log-slow-queries', 'values': [{'on': '1', 'off': '0', 'type': 'boolean'}], 'name': 'log-slow-queries'},
		{'caption': 'log-slow-slave-statements', 'versions': [((5, 1, 21), (6, 0, 4)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Cause slow statements as executed by the slave to be written to the slow query log', 'name': 'log-slow-slave-statements'},
		{'caption': 'long_query_time', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '10', 'outversion': (5, 0, 20), 'minimum': '1', 'type': 'numeric'}, {'default': '10', 'inversion': (5, 1, 21), 'minimum': '0', 'type': 'numeric'}, {'default': '10', 'outversion': (6, 0, 3), 'minimum': '1', 'type': 'numeric'}, {'default': '10', 'inversion': (6, 0, 4), 'minimum': '0', 'type': 'numeric'}], 'description': 'Log all queries that have taken more than long_query_time seconds to execute to file', 'name': 'long_query_time'},
		{'caption': 'slow_query_log_file', 'versions': [((5, 1, 12),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filedownload'}], 'description': 'Name of the slow query log file', 'name': 'slow_query_log_file'}]),
	( 'Advanced log options', [
		{'caption': 'expire_logs_days', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '99'}], 'description': 'If nonzero, binary logs will be purged after expire_logs_days days; possible purges happen at startup and at binary log rotation', 'name': 'expire_logs_days'},
		{'description': 'Log some extra information to update log. Please note that this option is deprecated; see --log-short-format option', 'versions': [(), ((4, 1),), ()], 'deprecated': (4, 1), 'caption': 'log-long-format', 'values': [], 'name': 'log-long-format'},
		{'caption': 'log-tc', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'tc.log', 'type': 'filename'}], 'description': 'Path to transaction coordinator log (used for transactions that affect more than one storage engine, when binary log is disabled)', 'name': 'log-tc'},
		{'caption': 'log-tc-size', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '24576', 'bitsize': '32', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '24576', 'bitsize': '64', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'Size in KB of transaction coordinator log', 'name': 'log-tc-size'},
		{'description': 'Log some noncritical warnings to the log file', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'disabledby': 'skip-log-warnings', 'caption': 'log-warnings', 'values': [{'inversion': (4, 1, 3), 'default': '1', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '0', 'type': 'numeric'}, {'inversion': (4, 1, 3), 'default': '1', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '0', 'type': 'numeric'}], 'name': 'log-warnings'}]),
	( 'General', [
		{'caption': 'console', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': '1', 'type': 'boolean', 'off': '0', 'platform': 'windows'}], 'description': 'Write error output on screen; do not remove the console window on Windows', 'name': 'console'},
		{'caption': 'general-log', 'versions': [((5, 1, 12),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Enable|disable general log', 'name': 'general-log'},
		{'optype': {'inversion': '5.1.29'}, 'description': 'Name of the general query log file', 'versions': [((5, 1, 12),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'general_log_file', 'values': [{'default': 'host_name.log', 'type': 'filedownload'}], 'name': 'general_log_file'},
		{'description': 'Log connections and queries to file', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)), ((5, 6, 1),)], 'deprecated': (5, 1, 29), 'caption': 'log', 'values': [{'default': 'OFF', 'type': 'string'}], 'name': 'log'},
		{'caption': 'log-error', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filename'}], 'description': 'Error log file', 'name': 'log-error'},
		{'caption': 'log-isam', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filename'}], 'description': 'Log all MyISAM changes to file', 'name': 'log-isam'},
		{'caption': 'log-output', 'versions': [((5, 1, 6),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'FILE', 'type': 'set', 'choice': ['TABLE', 'FILE', 'NONE']}], 'description': 'The destination for general query log and slow query log output', 'name': 'log-output'},
		{'caption': 'log-queries-not-using-indexes', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Log queries that are executed without benefit of any index to the slow query log if it is open', 'name': 'log-queries-not-using-indexes'},
		{'optype': {'format': 'log-raw[=value]'}, 'description': 'Whether to log queries without rewriting', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'caption': 'log-raw', 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'name': 'log-raw'},
		{'caption': 'log-short-format', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': "Don't log extra information to update and slow-query logs", 'name': 'log-short-format'},
		{'caption': 'log-slave-updates', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'This option tells the slave to log the updates performed by its SQL thread to its own binary log', 'name': 'log-slave-updates'},
		{'optype': {'inversion': '5.1.29'}, 'description': 'Enable|disable slow query log', 'versions': [((5, 1, 12),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'slow-query-log', 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'name': 'slow-query-log'}]),
	( 'Binlog Options', [
		{'caption': 'binlog-checksum', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'NONE', 'outversion': (5, 6, 5), 'type': 'string', 'choice': ['NONE', 'CRC32']}, {'default': 'CRC32', 'inversion': (5, 6, 6), 'type': 'string', 'choice': ['NONE', 'CRC32']}], 'description': 'Enable/disable binary log checksums', 'name': 'binlog-checksum'},
		{'caption': 'binlog-do-db', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Limits binary logging to specific databases', 'name': 'binlog-do-db'},
		{'caption': 'binlog-ignore-db', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Tells the master that updates to the given database should not be logged to the binary log', 'name': 'binlog-ignore-db'},
		{'caption': 'binlog-row-event-max-size', 'versions': [((5, 1, 5),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'outversion': (5, 6, 5), 'default': '1024', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '256', 'type': 'numeric'}, {'inversion': (5, 6, 6), 'default': '8192', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '256', 'type': 'numeric'}, {'outversion': (5, 6, 5), 'default': '1024', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '256', 'type': 'numeric'}, {'inversion': (5, 6, 6), 'default': '8192', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '256', 'type': 'numeric'}], 'description': 'Binary log max event size', 'name': 'binlog-row-event-max-size'},
		{'caption': 'binlog_cache_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '32768', 'bitsize': '32', 'minimum': '4096', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '32768', 'bitsize': '64', 'minimum': '4096', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'The size of the cache to hold the SQL statements for the binary log during a transaction', 'name': 'binlog_cache_size'},
		{'caption': 'binlog_stmt_cache_size', 'versions': [((5, 5, 9), (5, 6, 1)), ((5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '32768', 'bitsize': '32', 'minimum': '4096', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '32768', 'bitsize': '64', 'minimum': '4096', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'The size of the cache to hold nontransactional statements for the binary log during a transaction', 'name': 'binlog_stmt_cache_size'},
		{'optype': {'format': 'binlog-format=format'}, 'description': 'Specifies the format of the binary log', 'versions': [((5, 1, 5),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'binlog-format', 'values': [{'default': 'STATEMENT', 'inversion': (5, 1, 5), 'type': 'enum', 'outversion': (5, 1, 7), 'choice': ['ROW', 'STATEMENT']}, {'default': 'STATEMENT', 'inversion': (5, 1, 8), 'type': 'enum', 'outversion': (5, 1, 11), 'choice': ['ROW', 'STATEMENT', 'MIXED']}, {'default': 'MIXED', 'inversion': (5, 1, 12), 'type': 'enum', 'outversion': (5, 1, 28), 'choice': ['ROW', 'STATEMENT', 'MIXED']}, {'default': 'MIXED', 'inversion': (5, 1, 14), 'type': 'enum', 'choice': ['ROW', 'STATEMENT', 'MIXED']}, {'default': 'MIXED', 'inversion': (5, 1, 16), 'type': 'enum', 'choice': ['ROW', 'STATEMENT', 'MIXED']}, {'default': 'MIXED', 'inversion': (5, 1, 19), 'type': 'enum', 'choice': ['ROW', 'STATEMENT', 'MIXED']}, {'default': 'MIXED', 'inversion': (5, 1, 32), 'type': 'enum', 'choice': ['ROW', 'STATEMENT', 'MIXED']}, {'default': 'MIXED', 'inversion': (5, 1, 39), 'type': 'enum', 'outversion': (5, 1, 51), 'choice': ['ROW', 'STATEMENT', 'MIXED']}, {'default': 'STATEMENT', 'inversion': (5, 1, 29), 'type': 'enum', 'choice': ['ROW', 'STATEMENT', 'MIXED']}, {'default': 'STATEMENT', 'inversion': (5, 1, 15), 'type': 'enum', 'choice': ['ROW', 'STATEMENT', 'MIXED']}], 'name': 'binlog-format'},
		{'caption': 'binlog-rows-query-log-events', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Enables logging of rows query log events when using row-based logging. Disabled by default. Do not enable when producing logs for pre-5.6.2 slaves/readers.', 'name': 'binlog-rows-query-log-events'},
		{'caption': 'binlog_direct_non_transactional_updates', 'versions': [((5, 1, 44), (5, 5, 2), (6, 0, 14)), ((5, 1), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Causes updates using statement format to nontransactional engines to be written directly to binary log. See documentation before using.', 'name': 'binlog_direct_non_transactional_updates'},
		{'caption': 'log-bin', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'OFF', 'type': 'filename'}], 'description': 'Enables binary log', 'name': 'log-bin'},
		{'caption': 'log-bin-index', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'OFF', 'type': 'filename'}], 'description': 'File that holds the names for last binary log files', 'name': 'log-bin-index'},
		{'caption': 'log-bin-trust-function-creators', 'versions': [((5, 0, 16),), ((5, 0), (5, 1), (5, 4), (5, 5), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'If equal to 0 (the default), then when --log-bin is used, creation of a stored function is allowed only to users having the SUPER privilege and only if the function created does not break binary logging', 'name': 'log-bin-trust-function-creators'},
		{'description': '(deprecated) Use log-bin-trust-function-creators', 'versions': [((5, 0, 6),), ((5, 0), (5, 1), (5, 2), (5, 4), (5, 5)), ((5, 2, 5), (5, 5, 3))], 'deprecated': (5, 0, 16), 'caption': 'log-bin-trust-routine-creators', 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'name': 'log-bin-trust-routine-creators'},
		{'caption': 'log-bin-use-v1-row-events', 'versions': [((5, 1, 56), (5, 5, 15)), ((5, 1), (5, 5)), ()], 'values': [{'on': '1', 'inversion': (5, 1, 56), 'off': '0', 'default': '1', 'outversion': (5, 1, 99), 'type': 'boolean'}, {'on': '1', 'inversion': (5, 1, 56), 'off': '0', 'default': '1', 'outversion': (5, 1, 99), 'type': 'boolean'}, {'default': '0', 'on': '1', 'inversion': (5, 5, 15), 'off': '0', 'type': 'boolean'}], 'description': 'Use version 1 binary log row events (MySQL Cluster).', 'name': 'log-bin-use-v1-row-events'},
		{'caption': 'log_bin_use_v1_row_events', 'versions': [((5, 1, 56), (5, 5, 15)), ((5, 1), (5, 5)), ()], 'values': [{'on': '1', 'inversion': (5, 1, 56), 'off': '0', 'default': '1', 'outversion': (5, 1, 99), 'type': 'boolean'}, {'on': '1', 'inversion': (5, 1, 56), 'off': '0', 'default': '1', 'outversion': (5, 1, 99), 'type': 'boolean'}, {'default': '0', 'on': '1', 'inversion': (5, 5, 15), 'off': '0', 'type': 'boolean'}], 'description': 'Shows whether server is using version 1 binary log row events (MySQL Cluster).', 'name': 'log_bin_use_v1_row_events'},
		{'caption': 'max-binlog-dump-events', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'type': 'numeric'}], 'description': 'Option used by mysql-test for debugging and testing of replication', 'name': 'max-binlog-dump-events'},
		{'caption': 'max_binlog_cache_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '4294967295', 'outversion': (5, 1, 35), 'minimum': '4096', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '18446744073709547520', 'inversion': (5, 1, 36), 'minimum': '4096', 'type': 'numeric', 'maximum': '18446744073709547520'}, {'inversion': (5, 4, 0), 'default': '4294967295', 'maximum': '4294967295', 'outversion': (5, 4, 1), 'minimum': '4096', 'type': 'numeric'}, {'default': '18446744073709547520', 'inversion': (5, 4, 2), 'minimum': '4096', 'type': 'numeric', 'maximum': '18446744073709547520'}, {'default': '4294967295', 'inversion': (6, 0, 0), 'minimum': '4096', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'Can be used to restrict the total size used to cache a multi-statement transaction', 'name': 'max_binlog_cache_size'},
		{'caption': 'max_binlog_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1073741824', 'minimum': '4096', 'type': 'numeric', 'maximum': '1073741824'}], 'description': 'Binary log will be rotated automatically when the size exceeds this value', 'name': 'max_binlog_size'},
		{'caption': 'max_binlog_stmt_cache_size', 'versions': [((5, 5, 9), (5, 6, 1)), ((5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '18446744073709547520', 'minimum': '4096', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'Can be used to restrict the total size used to cache all nontransactional statements during a transaction', 'name': 'max_binlog_stmt_cache_size'},
		{'caption': 'sporadic-binlog-dump-fail', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Option used by mysql-test for debugging and testing of replication', 'name': 'sporadic-binlog-dump-fail'},
		{'caption': 'sync_binlog', 'versions': [((4, 1, 3), (5, 0, 1)), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'bitsize': '32', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '0', 'bitsize': '64', 'minimum': '0', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'Synchronously flush binary log to disk after every #th event', 'name': 'sync_binlog'}])]),
( 'InnoDB', [
	( 'Datafiles', [
		{'caption': 'innodb_data_file_path', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Path to individual files and their sizes', 'name': 'innodb_data_file_path'},
		{'caption': 'innodb_data_home_dir', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filename'}], 'description': 'The common part for InnoDB table spaces', 'name': 'innodb_data_home_dir'},
		{'caption': 'innodb_file_format', 'versions': [((5, 1, 38), (5, 4, 2)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': 'Antelope', 'inversion': (5, 1, 38), 'type': 'string'}, {'default': 'Barracuda', 'inversion': (5, 5, 0), 'type': 'string', 'outversion': (5, 5, 6), 'choice': ['Antelope', 'Barracuda']}, {'default': 'Antelope', 'inversion': (5, 5, 7), 'type': 'string', 'choice': ['Antelope', 'Barracuda']}], 'description': 'The format for new InnoDB tables', 'name': 'innodb_file_format'},
		{'caption': 'innodb_file_format_check', 'versions': [((5, 1, 38), (5, 4, 2)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': 'Antelope', 'outversion': (5, 1, 41), 'type': 'string'}, {'default': 'Barracuda', 'inversion': (5, 1, 42), 'type': 'string'}, {'default': 'Antelope', 'outversion': (5, 5, 0), 'type': 'string'}, {'default': 'Barracuda', 'inversion': (5, 5, 4), 'type': 'string'}, {'default': 'on', 'on': 'on', 'inversion': (5, 5, 5), 'off': 'off', 'type': 'boolean'}], 'description': 'Whether InnoDB performs file format compatibility checking', 'name': 'innodb_file_format_check'},
		{'caption': 'innodb_file_format_max', 'versions': [((5, 5, 5),), ((5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': 'Antelope', 'type': 'string', 'choice': ['Antelope', 'Barracuda']}], 'description': 'The file format tag in the shared tablespace', 'name': 'innodb_file_format_max'}]),
	( 'Buffer pool', [
		{'caption': 'innodb_buffer_pool_awe_mem_mb', 'versions': [(), ((4, 1), (5, 0), (5, 1)), ((5, 1, 13),)], 'values': [{'default': '0', 'platform': 'windows', 'minimum': '0', 'type': 'numeric', 'maximum': '63000'}], 'description': 'If Windows AWE is used, the size in Megabytes of InnoDB buffer pool allocated from the AWE memory', 'name': 'innodb_buffer_pool_awe_mem_mb'},
		{'caption': 'innodb_buffer_pool_dump_at_shutdown', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Specifies whether to record the pages cached in the InnoDB buffer pool when the MySQL server is shut down, to shorten the warmup process at the next restart', 'name': 'innodb_buffer_pool_dump_at_shutdown'},
		{'caption': 'innodb_buffer_pool_dump_now', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Immediately records the pages cached in the InnoDB buffer pool', 'name': 'innodb_buffer_pool_dump_now'},
		{'caption': 'innodb_buffer_pool_filename', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'ib_buffer_pool', 'type': 'string'}], 'description': 'Specifies the file that holds the list of page numbers produced by innodb_buffer_pool_dump_at_shutdown or innodb_buffer_pool_dump_now', 'name': 'innodb_buffer_pool_filename'},
		{'caption': 'innodb_buffer_pool_load_abort', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Interrupts the process of restoring InnoDB buffer pool contents triggered by innodb_buffer_pool_load_at_startup or innodb_buffer_pool_load_now', 'name': 'innodb_buffer_pool_load_abort'},
		{'caption': 'innodb_buffer_pool_load_at_startup', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Specifies that, on MySQL server startup, the InnoDB buffer pool is automatically "warmed up" by loading the same pages it held at an earlier time', 'name': 'innodb_buffer_pool_load_at_startup'},
		{'caption': 'innodb_buffer_pool_load_now', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Immediately "warms up" the InnoDB buffer pool by loading a set of data pages, without waiting for a server restart', 'name': 'innodb_buffer_pool_load_now'},
		{'caption': 'innodb_buffer_pool_instances', 'versions': [((5, 5, 4),), ((5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '1', 'outversion': (5, 6, 5), 'minimum': '1', 'type': 'numeric', 'maximum': '64'}, {'default': 'autosized', 'inversion': (5, 6, 6), 'minimum': '1', 'type': 'numeric', 'maximum': '64'}], 'description': 'Specifies how many parts the InnoDB buffer pool is divided into', 'name': 'innodb_buffer_pool_instances'},
		{'caption': 'innodb_buffer_pool_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '8388608', 'inversion': (5, 0, 0), 'minimum': '1048576', 'type': 'numeric', 'outversion': (5, 1, 27)}, {'inversion': (5, 1, 28), 'default': '134217728', 'bitsize': '32', 'maximum': '2**32-1', 'minimum': '1048576', 'type': 'numeric'}, {'inversion': (5, 1, 28), 'default': '134217728', 'bitsize': '64', 'maximum': '2**64-1', 'minimum': '1048576', 'type': 'numeric'}], 'description': 'The size of the memory buffer InnoDB uses to cache data and indexes of its tables', 'name': 'innodb_buffer_pool_size'}]),
	( 'Logfiles', [
		{'caption': 'innodb_flush_log_at_trx_commit', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1', 'type': 'enum', 'choice': ['0', '1', '2']}], 'description': 'Set to 0 (write and flush once per second), 1 (write and flush at each commit) or 2 (write at commit, flush once per second)', 'name': 'innodb_flush_log_at_trx_commit'},
		{'caption': 'innodb_flush_method', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'async_unbuffered', 'platform': 'windows', 'type': 'enum'}, {'default': 'fdatasync', 'platform': 'linux', 'outversion': (5, 1, 23), 'type': 'enum', 'choice': ['fdatasync', 'O_DSYNC', 'O_DIRECT']}, {'default': 'fdatasync', 'platform': 'linux', 'inversion': (5, 1, 24), 'type': 'enum', 'choice': ['O_DSYNC', 'O_DIRECT']}, {'default': 'fdatasync', 'platform': 'hpux', 'outversion': (5, 1, 23), 'type': 'enum', 'choice': ['fdatasync', 'O_DSYNC', 'O_DIRECT']}, {'default': 'fdatasync', 'platform': 'hpux', 'inversion': (5, 1, 24), 'type': 'enum', 'choice': ['O_DSYNC', 'O_DIRECT']}, {'default': 'fdatasync', 'platform': 'solaris', 'outversion': (5, 1, 23), 'type': 'enum', 'choice': ['fdatasync', 'O_DSYNC', 'O_DIRECT']}, {'default': 'fdatasync', 'platform': 'solaris', 'inversion': (5, 1, 24), 'type': 'enum', 'choice': ['O_DSYNC', 'O_DIRECT']}], 'description': 'Specifies to flush data', 'name': 'innodb_flush_method'},
		{'caption': 'innodb_flush_neighbors', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Specifies whether flushing a page from the InnoDB buffer pool also flushes other dirty pages in the same extent', 'name': 'innodb_flush_neighbors'},
		{'description': 'Where full logs should be archived', 'versions': [(), ((4, 1), (5, 0), (5, 1)), ((5, 1, 21),)], 'deprecated': (5, 0, 24), 'caption': 'innodb_log_arch_dir', 'values': [{'type': 'filename'}], 'name': 'innodb_log_arch_dir'},
		{'caption': 'innodb_log_archive', 'versions': [(), ((4, 1), (5, 0), (5, 1)), ((5, 1, 18),)], 'values': [{'default': '0', 'type': 'numeric'}], 'description': 'Unused', 'name': 'innodb_log_archive'},
		{'caption': 'innodb_log_buffer_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1048576', 'minimum': '1048576', 'type': 'numeric', 'maximum': '4294967295'}, {'inversion': (5, 4, 0), 'default': '16777216', 'maximum': '4294967295', 'outversion': (5, 4, 1), 'minimum': '2097152', 'type': 'numeric'}, {'inversion': (5, 4, 2), 'default': '16777216', 'maximum': '4294967295', 'outversion': (5, 4, 2), 'minimum': '262144', 'type': 'numeric'}, {'default': '8388608', 'inversion': (5, 4, 3), 'minimum': '262144', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '1048576', 'inversion': (6, 0, 0), 'minimum': '1048576', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'The size of the buffer which InnoDB uses to write log to the log files on disk', 'name': 'innodb_log_buffer_size'},
		{'caption': 'innodb_log_compressed_pages', 'versions': [((5, 6, 7),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'type': 'boolean', 'off': 'off', 'choice': ['on', 'off']}], 'description': 'Specifies whether images of re-compressed pages are stored in InnoDB redo logs', 'name': 'innodb_log_compressed_pages'},
		{'caption': 'innodb_log_file_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '5242880', 'minimum': '1048576', 'type': 'numeric', 'maximum': '4294967295'}, {'inversion': (5, 4, 0), 'default': '134217728', 'maximum': '4294967295', 'outversion': (5, 4, 1), 'minimum': '33554432', 'type': 'numeric'}, {'inversion': (5, 4, 2), 'default': '134217728', 'maximum': '4294967295', 'outversion': (5, 4, 2), 'minimum': '108576', 'type': 'numeric'}, {'default': '5242880', 'inversion': (5, 4, 3), 'minimum': '108576', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '5242880', 'inversion': (6, 0, 0), 'minimum': '1048576', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '5242880', 'inversion': (5, 6, 3), 'minimum': '1048576', 'type': 'numeric', 'maximum': '512GB / innodb_log_files_in_group'}], 'description': 'Size of each log file in a log group', 'name': 'innodb_log_file_size'},
		{'caption': 'innodb_log_files_in_group', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '2', 'minimum': '2', 'type': 'numeric', 'maximum': '100'}, {'inversion': (5, 4, 0), 'default': '3', 'maximum': '100', 'outversion': (5, 4, 2), 'minimum': '3', 'type': 'numeric'}, {'default': '2', 'inversion': (5, 4, 3), 'minimum': '2', 'type': 'numeric', 'maximum': '100'}], 'description': 'Number of InnoDB log files in the log group', 'name': 'innodb_log_files_in_group'},
		{'caption': 'innodb_log_group_home_dir', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filename'}], 'description': 'Path to InnoDB log files', 'name': 'innodb_log_group_home_dir'},
		{'caption': 'innodb_mirrored_log_groups', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1', 'minimum': '1', 'type': 'numeric', 'maximum': '10'}], 'description': 'Number of identical copies of log groups to keep for the database', 'name': 'innodb_mirrored_log_groups'},
		{'caption': 'innodb_online_alter_log_max_size', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '134217728', 'type': 'numeric'}], 'description': 'Specifies an upper limit on the size of the temporary log file used during CREATE INDEX and DROP STATEMENTS statements for InnoDB tables', 'name': 'innodb_online_alter_log_max_size'},
		{'caption': 'innodb_undo_directory', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': '.', 'type': 'string'}], 'description': 'The relative or absolute directory path where InnoDB creates separate tablespaces for the undo logs; typically used to place those logs on a different storage device', 'name': 'innodb_undo_directory'},
		{'caption': 'innodb_undo_logs', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '128'}], 'description': 'Defines how many of the rollback segments in the system tablespace that InnoDB uses within a transaction; replaces the innodb_rollback_segments setting', 'name': 'innodb_undo_logs'}]),
	( 'Various', [
		{'caption': 'innodb_fast_shutdown', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1', 'type': 'numeric', 'choice': ['0', '1', '2']}], 'description': 'Speeds up the shutdown process of the InnoDB storage engine', 'name': 'innodb_fast_shutdown'}]),
	( 'Memory', [
		{'caption': 'innodb_additional_mem_pool_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1048576', 'minimum': '524288', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '8388608', 'inversion': (5, 4, 0), 'minimum': '2097152', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '1048576', 'inversion': (6, 0, 0), 'minimum': '524288', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'Size of a memory pool InnoDB uses to store data dictionary information and other internal data structures', 'name': 'innodb_additional_mem_pool_size'},
		{'caption': 'innodb_page_size', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'default': '16384', 'type': 'enum', 'choice': ['4k', '8k', '16k', '4096', '8192', '16384']}], 'description': 'Specifies the page size for all InnoDB tablespaces in an instance', 'name': 'innodb_page_size'},
		{'caption': 'innodb_sort_buffer_size', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'default': '1048576', 'type': 'numeric', 'maximum': '67108864'}, {'inversion': (5, 6, 4), 'minimum': '524288', 'type': 'numeric'}, {'inversion': (5, 6, 5), 'minimum': '65536', 'type': 'numeric'}], 'description': 'Specifies the size of a buffer used for sorting data during creation of an InnoDB index', 'name': 'innodb_sort_buffer_size'}]),
	( 'Fulltext search', [
		{'caption': 'innodb_ft_aux_table', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'type': 'string'}], 'description': 'Specifies which InnoDB table with a FULLTEXT index to examine by querying several innodb_ft_* tables in the information_schema', 'name': 'innodb_ft_aux_table'},
		{'caption': 'innodb_ft_enable_stopword', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'During creation of an InnoDB FULLTEXT index, omits stopwords from the search index', 'name': 'innodb_ft_enable_stopword'},
		{'caption': 'innodb_ft_num_word_optimize', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'default': '2000', 'type': 'numeric'}], 'description': 'Number of words to process during each OPTIMIZE TABLE operation on an InnoDB FULLTEXT index', 'name': 'innodb_ft_num_word_optimize'},
		{'caption': 'innodb_ft_server_stopword_table', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'NULL', 'type': 'string'}], 'description': 'Specifies a table holding a list of stopwords for InnoDB FULLTEXT indexes, which overrides the default stopword list and can be overridden by innodb_ft_user_stopword_table', 'name': 'innodb_ft_server_stopword_table'},
		{'caption': 'innodb_ft_user_stopword_table', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'NULL', 'type': 'string'}], 'description': 'Specifies a table holding a list of stopwords for InnoDB FULLTEXT indexes, which overrides the default stopword list and also innodb_ft_server_stopword_table', 'name': 'innodb_ft_user_stopword_table'},
		{'caption': 'innodb_ft_max_token_size', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'default': '84', 'minimum': '10', 'type': 'numeric', 'maximum': '252'}], 'description': 'Maximum length of words that are stored in an InnoDB FULLTEXT index', 'name': 'innodb_ft_max_token_size'},
		{'caption': 'innodb_ft_min_token_size', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'default': '3', 'minimum': '0', 'type': 'numeric', 'maximum': '16'}], 'description': 'Minimum length of words that are stored in an InnoDB FULLTEXT index', 'name': 'innodb_ft_min_token_size'},
		{'caption': 'innodb_ft_cache_size', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'default': '33554432', 'type': 'numeric'}], 'description': 'Size of the cache that holds a parsed document in memory while creating an InnoDB FULLTEXT index', 'name': 'innodb_ft_cache_size'},
		{'caption': 'innodb_ft_sort_pll_degree', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'default': '2', 'minimum': '1', 'type': 'numeric', 'maximum': '32'}], 'description': 'Number of threads used to create an InnoDB FULLTEXT index in parallel, when building a search index for a large table', 'name': 'innodb_ft_sort_pll_degree'},
		{'caption': 'innodb_optimize_fulltext_only', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Makes the OPTIMIZE TABLE statement for an InnoDB table process the newly added, deleted, and updated token data for a FULLTEXT index, rather than reorganizing the data in the clustered index of the table', 'name': 'innodb_optimize_fulltext_only'}]),
	( 'General', [
		{'caption': 'ignore-builtin-innodb', 'versions': [((5, 1, 33),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'on': '1', 'off': '0', 'type': 'boolean'}], 'description': 'Ignore the built-in InnoDB', 'name': 'ignore-builtin-innodb'},
		{'caption': 'innodb', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': '1', 'outversion': (5, 1, 35), 'off': '0', 'type': 'boolean'}, {'inversion': (5, 1, 36), 'type': 'enum', 'choice': ['OFF', 'ON', 'FORCE']}, {'on': '1', 'inversion': (5, 4, 0), 'off': '0', 'outversion': (5, 4, 1), 'type': 'boolean'}, {'inversion': (5, 4, 2), 'type': 'enum', 'choice': ['OFF', 'ON', 'FORCE']}, {'on': '1', 'inversion': (6, 0, 0), 'off': '0', 'type': 'boolean'}], 'description': 'Enable InnoDB (if this version of MySQL supports it)', 'name': 'innodb'},
		{'caption': 'innodb_adaptive_flushing', 'versions': [((5, 1, 38), (5, 4, 2)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Control InnoDB adaptive flushing of dirty pages', 'name': 'innodb_adaptive_flushing'},
		{'caption': 'innodb_adaptive_flushing_lwm', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '10', 'minimum': '0', 'type': 'numeric', 'maximum': '70'}], 'description': 'Low water mark representing percentage of redo log capacity at which adaptive flushing is enabled.', 'name': 'innodb_adaptive_flushing_lwm'},
		{'caption': 'innodb_adaptive_hash_index', 'versions': [((5, 0, 52), (5, 1, 24), (6, 0, 5)), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Enable or disable InnoDB adaptive hash indexes', 'name': 'innodb_adaptive_hash_index'},
		{'caption': 'innodb_adaptive_max_sleep_delay', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '1000000'}], 'description': 'Allows InnoDB to automatically adjust the value of innodb_thread_concurrency up or down according to the current workload', 'name': 'innodb_adaptive_max_sleep_delay'},
		{'caption': 'innodb_api_bk_commit_interval', 'versions': [((5, 6, 7),), ((5, 6), (5, 7)), ()], 'values': [{'default': '5', 'minimum': '1', 'type': 'numeric', 'maximum': '1073741824 '}], 'description': 'Specifies how often to auto-commit idle connections that use the InnoDB memcached interface', 'name': 'innodb_api_bk_commit_interval'},
		{'caption': 'innodb_api_disable_rowlock', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': '', 'name': 'innodb_api_disable_rowlock'},
		{'caption': 'innodb_api_enable_binlog', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Lets you use the InnoDB memcached plugin with the MySQL binary log', 'name': 'innodb_api_enable_binlog'},
		{'caption': 'innodb_api_enable_mdl', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Locks the table used by the InnoDB memcached plugin, so that it cannot be dropped or altered by DDL through the SQL interface', 'name': 'innodb_api_enable_mdl'},
		{'caption': 'innodb_api_trx_level', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '0', 'type': 'numeric'}], 'description': 'Lets you control the transaction isolation level on queries processed by the memcached interface', 'name': 'innodb_api_trx_level'},
		{'caption': 'innodb_autoextend_increment', 'versions': [((4, 1, 5),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '8', 'minimum': '1', 'type': 'numeric', 'maximum': '1000'}, {'inversion': (5, 4, 0), 'default': '64', 'maximum': '1000', 'outversion': (5, 4, 2), 'minimum': '1', 'type': 'numeric'}, {'inversion': (5, 4, 3), 'default': '8', 'maximum': '1000', 'outversion': (5, 6, 5), 'minimum': '1', 'type': 'numeric'}, {'default': '64', 'inversion': (5, 6, 6), 'minimum': '1', 'type': 'numeric', 'maximum': '1000'}], 'description': 'Data file autoextend increment in megabytes', 'name': 'innodb_autoextend_increment'},
		{'caption': 'innodb_autoinc_lock_mode', 'versions': [((5, 1, 22),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1', 'type': 'numeric', 'choice': ['0', '1', '2']}], 'description': 'Set InnoDB auto-increment lock mode', 'name': 'innodb_autoinc_lock_mode'},
		{'caption': 'innodb_change_buffer_max_size', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'default': '25', 'minimum': '0', 'type': 'numeric', 'maximum': '50'}], 'description': 'Maximum size for the InnoDB change buffer, as a percentage of the total size of the buffer pool', 'name': 'innodb_change_buffer_max_size'},
		{'caption': 'innodb_change_buffering', 'versions': [((5, 1, 38), (5, 4, 2)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': 'inserts', 'outversion': (5, 5, 3), 'type': 'enum', 'choice': ['inserts', 'none']}, {'default': 'all', 'inversion': (5, 5, 4), 'type': 'enum', 'choice': ['inserts', 'deletes', 'purges', 'changes', 'all', 'none']}], 'description': 'Whether InnoDB performs insert buffering.', 'name': 'innodb_change_buffering'},
		{'caption': 'innodb_checksum_algorithm', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'innodb', 'outversion': (5, 6, 5), 'type': 'enum', 'choice': ['innodb', 'crc32', 'none', 'strict_innodb', 'strict_crc32', 'strict_none']}, {'default': 'crc32', 'inversion': (5, 6, 6), 'type': 'enum', 'choice': ['innodb', 'crc32', 'none', 'strict_innodb', 'strict_crc32', 'strict_none']}], 'description': 'Specifies how to generate and verify the checksum stored in each disk block of each InnoDB tablespace', 'name': 'innodb_checksum_algorithm'},
		{'caption': 'innodb_checksums', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Enable InnoDB checksums validation', 'name': 'innodb_checksums'},
		{'caption': 'innodb_cmp_per_index_enabled', 'versions': [((5, 6, 7),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'type': 'boolean', 'off': 'off', 'choice': ['off', 'on']}], 'description': 'Enables per-index compression-related statistics in the INFORMATION_SCHEMA.INNODB_CMP_PER_INDEX table', 'name': 'innodb_cmp_per_index_enabled'},
		{'caption': 'innodb_commit_concurrency', 'versions': [((5, 0, 12),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '1000'}], 'description': 'Helps in performance tuning in heavily concurrent environments', 'name': 'innodb_commit_concurrency'},
		{'caption': 'innodb_compression_failure_threshold_pct', 'versions': [((5, 6, 7),), ((5, 6), (5, 7)), ()], 'values': [{'default': '5', 'minimum': '0', 'type': 'numeric', 'maximum': '100'}], 'description': '', 'name': 'innodb_compression_failure_threshold_pct'},
		{'caption': 'innodb_compression_level', 'versions': [((5, 6, 7),), ((5, 6), (5, 7)), ()], 'values': [{'default': '6', 'minimum': '0', 'type': 'numeric', 'maximum': '9'}], 'description': 'Specifies the level of zlib compression to use for InnoDB compressed tables and indexes', 'name': 'innodb_compression_level'},
		{'caption': 'innodb_compression_pad_pct_max', 'versions': [((5, 6, 7),), ((5, 6), (5, 7)), ()], 'values': [{'default': '50', 'minimum': '0', 'type': 'numeric', 'maximum': '75'}], 'description': 'Specifies the maximum percentage that can be reserved within each InnoDB page for storing delta information when a compressed table or index is updated', 'name': 'innodb_compression_pad_pct_max'},
		{'caption': 'innodb_concurrency_tickets', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '500', 'outversion': (5, 6, 5), 'minimum': '1', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '5000', 'inversion': (5, 6, 6), 'minimum': '1', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'Number of times a thread is allowed to enter InnoDB within the same SQL query after it has once got the ticket', 'name': 'innodb_concurrency_tickets'},
		{'caption': 'innodb_doublewrite', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': '1', 'off': '0', 'type': 'boolean'}], 'description': 'Enable InnoDB doublewrite buffer', 'name': 'innodb_doublewrite'},
		{'caption': 'innodb_extra_dirty_writes', 'versions': [(), ((5, 4),), ((5, 4, 2),)], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Whether to flush dirty buffer pages when the percentage of dirty pages is less than the maximum dirty percent', 'name': 'innodb_extra_dirty_writes'},
		{'caption': 'innodb_file_io_threads', 'versions': [(), ((4, 1), (5, 0), (5, 1), (6, 0)), ()], 'values': [{'default': '4', 'minimum': '4', 'type': 'numeric', 'maximum': '64'}], 'description': 'Number of file I/O threads in InnoDB', 'name': 'innodb_file_io_threads'},
		{'caption': 'innodb_file_per_table', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'inversion': (4, 1, 1), 'off': 'off', 'type': 'boolean'}, {'on': 'on', 'inversion': (5, 5, 0), 'off': 'off', 'default': 'on', 'outversion': (5, 5, 6), 'type': 'boolean'}, {'on': 'on', 'inversion': (5, 5, 7), 'off': 'off', 'default': 'off', 'outversion': (5, 6, 5), 'type': 'boolean'}, {'default': 'on', 'on': 'on', 'inversion': (5, 6, 6), 'off': 'off', 'type': 'boolean'}], 'description': 'Stores each InnoDB table to an .ibd file in the database dir', 'name': 'innodb_file_per_table'},
		{'caption': 'innodb_flushing_avg_loops', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '30', 'minimum': '1', 'type': 'numeric', 'maximum': '1000'}], 'description': 'Number of iterations for which InnoDB keeps the previously calculated snapshot of the flushing state, controlling how quickly adaptive flushing responds to changing workloads', 'name': 'innodb_flushing_avg_loops'},
		{'caption': 'innodb_force_load_corrupted', 'versions': [((5, 5, 18), (5, 6, 3)), ((5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Lets InnoDB load tables at startup that are marked as corrupted; use only during troubleshooting', 'name': 'innodb_force_load_corrupted'},
		{'caption': 'innodb_force_recovery', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'type': 'enum', 'choice': ['0', '1', '2', '3', '4', '5', '6']}], 'description': 'Helps to save your data in case the disk image of the database becomes corrupt', 'name': 'innodb_force_recovery'},
		{'caption': 'innodb_io_capacity', 'versions': [((5, 1, 38),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '200', 'bitsize': '32', 'minimum': '100', 'type': 'numeric', 'maximum': '2**32-1'}, {'default': '200', 'bitsize': '64', 'minimum': '100', 'type': 'numeric', 'maximum': '2**64-1'}], 'description': 'The limit on the maximum number of I/O operations per second', 'name': 'innodb_io_capacity'},
		{'caption': 'innodb_io_capacity_max', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'see formula in description', 'minimum': '2000', 'type': 'numeric'}, {'bitsize': '32', 'type': 'numeric', 'maximum': '4294967295'}, {'bitsize': '64', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'The limit up to which InnoDB is allowed to extend the innodb_io_capacity setting in case of emergency', 'name': 'innodb_io_capacity_max'},
		{'caption': 'innodb_large_prefix', 'versions': [((5, 5, 14), (5, 6, 3)), ((5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Enables longer keys for column prefix indexes', 'name': 'innodb_large_prefix'},
		{'caption': 'innodb_lock_wait_timeout', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '50', 'minimum': '1', 'type': 'numeric', 'maximum': '1073741824'}], 'description': 'Timeout in seconds an InnoDB transaction may wait for a lock before a rollback occurs', 'name': 'innodb_lock_wait_timeout'},
		{'caption': 'innodb_locks_unsafe_for_binlog', 'versions': [((4, 1, 4),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Force InnoDB not to use next-key locking. Instead use only row-level locking', 'name': 'innodb_locks_unsafe_for_binlog'},
		{'caption': 'innodb_lru_scan_depth', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': '1024', 'bitsize': '32', 'minimum': '100', 'type': 'numeric', 'maximum': '2**32-1'}, {'default': '1024', 'bitsize': '64', 'minimum': '100', 'type': 'numeric', 'maximum': '2**64-1'}], 'description': 'Influences the algorithms and heuristics for the flush operation for the InnoDB buffer pool', 'name': 'innodb_lru_scan_depth'},
		{'caption': 'innodb_max_dirty_pages_pct', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '90', 'minimum': '0', 'type': 'numeric', 'maximum': '100'}, {'default': '75', 'inversion': (5, 4, 0), 'minimum': '0', 'type': 'numeric', 'maximum': '99'}, {'default': '90', 'inversion': (6, 0, 0), 'minimum': '0', 'type': 'numeric', 'maximum': '100'}], 'description': 'Percentage of dirty pages allowed in bufferpool', 'name': 'innodb_max_dirty_pages_pct'},
		{'caption': 'innodb_max_dirty_pages_pct_lwm', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '99'}], 'description': 'Low water mark representing percentage of dirty pages where preflushing is enabled to control the dirty page ratio', 'name': 'innodb_max_dirty_pages_pct_lwm'},
		{'caption': 'innodb_max_merged_io', 'versions': [(), ((5, 4),), ((5, 4, 2),)], 'values': [{'default': '64', 'type': 'numeric'}], 'description': 'The maximum number of background I/O requests to merge to issue a larger I/O request', 'name': 'innodb_max_merged_io'},
		{'caption': 'innodb_max_purge_lag', 'versions': [((4, 1, 6),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'Desired maximum length of the purge queue (0 = no limit)', 'name': 'innodb_max_purge_lag'},
		{'caption': 'innodb_max_purge_lag_delay', 'versions': [((5, 6, 5),), ((5, 6), (5, 7)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric'}], 'description': 'Specifies the maximum delay in milliseconds for the formula calculated using the innodb_max_purge_lag configuration option', 'name': 'innodb_max_purge_lag_delay'},
		{'caption': 'innodb_monitor_disable', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'type': 'string'}], 'description': 'Turns off one or more counters in the information_schema.innodb_metrics table', 'name': 'innodb_monitor_disable'},
		{'caption': 'innodb_monitor_enable', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'type': 'string'}], 'description': 'Turns on one or more counters in the information_schema.innodb_metrics table', 'name': 'innodb_monitor_enable'},
		{'caption': 'innodb_monitor_reset', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'type': 'string'}], 'description': 'Resets to zero the count value for one or more counters in the information_schema.innodb_metrics table', 'name': 'innodb_monitor_reset'},
		{'caption': 'innodb_monitor_reset_all', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'type': 'string'}], 'description': 'Resets all values (minimum, maximum, and so on) for one or more counters in the information_schema.innodb_metrics table', 'name': 'innodb_monitor_reset_all'},
		{'caption': 'innodb_old_blocks_pct', 'versions': [((5, 1, 41),), ((5, 1), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '37', 'minimum': '5', 'type': 'numeric', 'maximum': '95'}], 'description': 'Percentage of the InnoDB buffer pool to reserve for old blocks', 'name': 'innodb_old_blocks_pct'},
		{'caption': 'innodb_old_blocks_time', 'versions': [((5, 1, 41),), ((5, 1), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '0', 'outversion': (5, 6, 5), 'minimum': '0', 'type': 'numeric', 'maximum': '2**32-1'}, {'default': '1000', 'inversion': (5, 6, 6), 'minimum': '0', 'type': 'numeric', 'maximum': '2**32-1'}], 'description': 'How long (in ms) blocks must remain in old end of InnoDB buffer pool before moving to new end', 'name': 'innodb_old_blocks_time'},
		{'caption': 'innodb_online_alter_log_max_size', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '134217728', 'type': 'numeric'}], 'description': 'Specifies an upper limit on the size of the temporary log file used during CREATE INDEX and DROP STATEMENTS statements for InnoDB tables', 'name': 'innodb_online_alter_log_max_size'},
		{'caption': 'innodb_open_files', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '300', 'outversion': (5, 6, 5), 'minimum': '10', 'type': 'numeric', 'maximum': '4294967295'}, {'default': 'autosized', 'inversion': (5, 6, 6), 'minimum': '10', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'The maximum number of files that InnoDB keeps open at the same time', 'name': 'innodb_open_files'},
		{'caption': 'innodb_print_all_deadlocks', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'During shutdown, prints information about all InnoDB deadlocks to the server error log', 'name': 'innodb_print_all_deadlocks'},
		{'caption': 'innodb_purge_batch_size', 'versions': [((5, 5, 4),), ((5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '20', 'inversion': (5, 5, 4), 'minimum': '1', 'type': 'numeric', 'maximum': '5000'}, {'default': '300', 'inversion': (5, 6, 3), 'minimum': '1', 'type': 'numeric', 'maximum': '5000'}], 'description': 'Specifies the number of InnoDB redo logs that trigger a purge operation.', 'name': 'innodb_purge_batch_size'},
		{'caption': 'innodb_purge_threads', 'versions': [((5, 5, 4),), ((5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '0', 'inversion': (5, 4, 2), 'minimum': '0', 'type': 'numeric', 'maximum': '1'}, {'default': '0', 'inversion': (5, 5, 4), 'minimum': '0', 'type': 'numeric', 'maximum': '1'}, {'default': '0', 'inversion': (5, 6, 2), 'minimum': '0', 'type': 'numeric', 'maximum': '32'}, {'default': '1', 'inversion': (5, 6, 5), 'minimum': '1', 'type': 'numeric', 'maximum': '32'}, {'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '1'}], 'description': 'Specifies whether the InnoDB purge operation should be performed in one or more separate threads. By default, this operation is part of the InnoDB master thread.', 'name': 'innodb_purge_threads'},
		{'caption': 'innodb_random_read_ahead', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Enables the random read-ahead technique for optimizing InnoDB I/O', 'name': 'innodb_random_read_ahead'},
		{'caption': 'innodb_read_ahead_threshold', 'versions': [((5, 1, 38), (5, 4, 2)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '56', 'minimum': '0', 'type': 'numeric', 'maximum': '64'}], 'description': 'The sensitivity of InnoDB linear read-ahead', 'name': 'innodb_read_ahead_threshold'},
		{'caption': 'innodb_read_io_threads', 'versions': [((5, 1, 38),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '4', 'minimum': '1', 'type': 'numeric', 'maximum': '64'}], 'description': 'The number of background I/O threads for read prefetch requests', 'name': 'innodb_read_io_threads'},
		{'caption': 'innodb_read_only', 'versions': [((5, 6, 7),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Starts the server in read-only mode', 'name': 'innodb_read_only'},
		{'caption': 'innodb_replication_delay', 'versions': [((5, 1, 38), (5, 4, 2)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'The slave server replication thread delay', 'name': 'innodb_replication_delay'},
		{'caption': 'innodb_rollback_on_timeout', 'versions': [((5, 0, 32), (5, 1, 15)), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [], 'description': 'Roll back entire transaction on transaction timeout, not just last statement', 'name': 'innodb_rollback_on_timeout'},
		{'caption': 'innodb_rollback_segments', 'versions': [((5, 5, 11), (5, 6, 2)), ((5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '128', 'minimum': '1', 'type': 'numeric', 'maximum': '128'}], 'description': 'Defines how many of the rollback segments in the system tablespace that InnoDB uses within a transaction', 'name': 'innodb_rollback_segments'},
		{'description': 'Truncates the binary log after last nonrolled-back transaction after InnoDB crash recovery', 'versions': [((4, 1, 3),), ((4, 1), (5, 0)), ((5, 0, 3),)], 'deprecated': (5, 0, 3), 'caption': 'innodb-safe-binlog', 'values': [{'on': '1', 'off': '0', 'type': 'boolean'}], 'name': 'innodb-safe-binlog'},
		{'caption': 'innodb_stats_auto_recalc', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Causes InnoDB to automatically recalculate persistent statistics after the data in a table is changed substantially', 'name': 'innodb_stats_auto_recalc'},
		{'caption': 'innodb_stats_method', 'versions': [((5, 1, 56), (5, 5, 10), (5, 6, 2)), ((5, 1), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': 'nulls_equal', 'type': 'enum', 'choice': ['nulls_equal', 'nulls_unequal', 'nulls_ignored']}], 'description': 'Specifies how InnoDB index statistics collection code should treat NULLs', 'name': 'innodb_stats_method'},
		{'caption': 'innodb_stats_on_metadata', 'versions': [((5, 1, 17), (5, 5, 4)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'on', 'on': 'on', 'outversion': (5, 6, 5), 'off': 'off', 'type': 'boolean'}, {'default': 'off', 'on': 'on', 'inversion': (5, 6, 6), 'off': 'off', 'type': 'boolean'}], 'description': 'Enable or disable InnoDB table statistics updates for metadata statements', 'name': 'innodb_stats_on_metadata'},
		{'caption': 'innodb_stats_persistent', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'OFF', 'type': 'enum', 'choice': ['OFF', 'ON', '0', '1', 'default']}], 'description': 'Turns on the InnoDB persistent statistics feature', 'name': 'innodb_stats_persistent'},
		{'caption': 'innodb_stats_persistent_sample_pages', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'default': '20', 'type': 'numeric'}], 'description': 'The number of pages to sample in each InnoDB index, when the persistent statistics feature is also enabled', 'name': 'innodb_stats_persistent_sample_pages'},
		{'caption': 'innodb_stats_transient_sample_pages', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'default': '8', 'type': 'numeric'}], 'description': 'The number of pages to sample in each InnoDB index, when the persistent statistics feature is turned off (the default setting)', 'name': 'innodb_stats_transient_sample_pages'},
		{'caption': 'innodb-status-file', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Enable SHOW ENGINE INNODB STATUS output in the innodb_status.[pid] file', 'name': 'innodb-status-file'},
		{'caption': 'innodb_support_xa', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'true', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Enable InnoDB support for the XA two-phase commit', 'name': 'innodb_support_xa'},
		{'caption': 'innodb_sync_array_size', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': '1', 'minimum': '1', 'type': 'numeric'}], 'description': 'Splits an internal data structure used to coordinate threads, for higher concurrency in workloads with large numbers of waiting threads', 'name': 'innodb_sync_array_size'},
		{'caption': 'innodb_sync_spin_loops', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '20', 'outversion': (5, 4, 1), 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '30', 'inversion': (5, 4, 2), 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'Count of spin-loop rounds in InnoDB mutexes', 'name': 'innodb_sync_spin_loops'},
		{'caption': 'innodb_sort_buffer_size', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'default': '1048576', 'type': 'numeric', 'maximum': '67108864'}, {'inversion': (5, 6, 4), 'minimum': '524288', 'type': 'numeric'}, {'inversion': (5, 6, 5), 'minimum': '65536', 'type': 'numeric'}], 'description': 'Specifies the size of a buffer used for sorting data during creation of an InnoDB index', 'name': 'innodb_sort_buffer_size'},
		{'caption': 'innodb_spin_wait_delay', 'versions': [((5, 1, 38), (5, 4, 2)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '6', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'The maximum delay between polls for a spin lock', 'name': 'innodb_spin_wait_delay'},
		{'caption': 'innodb_stats_sample_pages', 'versions': [((5, 1, 38), (5, 4, 2)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '8', 'minimum': '1', 'type': 'numeric', 'maximum': '2**64-1'}], 'description': 'The number of index pages to sample for index distribution statistics', 'name': 'innodb_stats_sample_pages'},
		{'caption': 'innodb_strict_mode', 'versions': [((5, 1, 38), (5, 4, 2)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Whether InnoDB returns errors rather than warnings for exceptional conditions', 'name': 'innodb_strict_mode'},
		{'caption': 'innodb_table_locks', 'versions': [((4, 1, 2),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'true', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Enable InnoDB locking in LOCK TABLES', 'name': 'innodb_table_locks'},
		{'caption': 'innodb_thread_concurrency', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '8', 'minimum': '1', 'type': 'numeric', 'maximum': '1000'}, {'default': '20', 'inversion': (5, 0, 9), 'minimum': '1', 'type': 'numeric', 'maximum': '1000'}, {'default': '8', 'inversion': (5, 0, 19), 'minimum': '0', 'type': 'numeric', 'maximum': '1000'}, {'default': '0', 'inversion': (5, 4, 0), 'minimum': '0', 'type': 'numeric', 'maximum': '1000'}, {'default': '8', 'inversion': (6, 0, 0), 'minimum': '0', 'type': 'numeric', 'maximum': '1000'}], 'description': 'Sets the maximum number of threads allowed inside InnoDB. Value 0 will disable the thread throttling', 'name': 'innodb_thread_concurrency'},
		{'caption': 'innodb_thread_concurrency_timer_based', 'versions': [(), ((5, 4),), ((5, 4, 2),)], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Whether to use the lock-free method of handling thread concurrency', 'name': 'innodb_thread_concurrency_timer_based'},
		{'caption': 'innodb_thread_sleep_delay', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'inversion': (5, 0, 8), 'default': '0', 'maximum': '4294967295', 'outversion': (5, 0, 18), 'minimum': '1000', 'type': 'numeric'}, {'inversion': (5, 0, 19), 'default': '0', 'maximum': '4294967295', 'outversion': (5, 0, 20), 'minimum': '1000', 'type': 'numeric'}, {'default': '8', 'inversion': (5, 0, 21), 'type': 'numeric'}, {'default': '10000', 'inversion': (5, 1, 0), 'type': 'numeric'}, {'default': '10000', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'Time, in microseconds, that an InnoDB thread sleeps before joining InnoDB queue. Value 0 disables the sleep behavior', 'name': 'innodb_thread_sleep_delay'},
		{'caption': 'innodb_undo_directory', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': '.', 'type': 'string'}], 'description': 'The relative or absolute directory path where InnoDB creates separate tablespaces for the undo logs; typically used to place those logs on a different storage device', 'name': 'innodb_undo_directory'},
		{'caption': 'innodb_undo_logs', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '128'}], 'description': 'Defines how many of the rollback segments in the system tablespace that InnoDB uses within a transaction; replaces the innodb_rollback_segments setting', 'name': 'innodb_undo_logs'},
		{'caption': 'innodb_undo_tablespaces', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric'}], 'description': 'The number of undo logs to place in each tablespace created by a non-zero innodb_undo_logs setting', 'name': 'innodb_undo_tablespaces'},
		{'caption': 'innodb_use_legacy_cardinality_algorithm', 'versions': [((5, 0, 82), (5, 1, 35)), ((5, 0), (5, 1)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Whether to use legacy InnoDB index cardinality calculation algorithm', 'name': 'innodb_use_legacy_cardinality_algorithm'},
		{'caption': 'innodb_use_native_aio', 'versions': [((5, 5, 4),), ((5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Specifies whether to use the Linux asynchronous I/O subsystem', 'name': 'innodb_use_native_aio'},
		{'caption': 'innodb_use_sys_malloc', 'versions': [((5, 1, 38), (5, 4, 2)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Whether InnoDB uses the OS or its own memory allocator', 'name': 'innodb_use_sys_malloc'},
		{'caption': 'innodb_write_io_threads', 'versions': [((5, 1, 38),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '4', 'minimum': '1', 'type': 'numeric', 'maximum': '64'}], 'description': 'The number of background I/O threads for writing dirty pages from the buffer cache to disk', 'name': 'innodb_write_io_threads'},
		{'caption': 'timed_mutexes', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Specify whether to time mutexes (only InnoDB mutexes are currently supported)', 'name': 'timed_mutexes'},
		{'caption': 'innodb_optimize_fulltext_only', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Makes the OPTIMIZE TABLE statement for an InnoDB table process the newly added, deleted, and updated token data for a FULLTEXT index, rather than reorganizing the data in the clustered index of the table', 'name': 'innodb_optimize_fulltext_only'},
		{'caption': 'skip-innodb', 'versions': ((), ((5, 1),), ()), 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Disable InnoDB', 'name': 'skip-innodb'}])]),
( 'Networking', [
	( 'Data / Memory size', [
		{'caption': 'host_cache_size', 'versions': [((5, 6, 5),), ((5, 6), (5, 7)), ()], 'values': [{'default': '128', 'minimum': '0', 'type': 'numeric', 'maximum': '65536'}], 'description': 'The size of the host cache', 'name': 'host_cache_size'},
		{'caption': 'max_allowed_packet', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1048576', 'outversion': (5, 6, 5), 'minimum': '1024', 'type': 'numeric', 'maximum': '1073741824'}, {'default': '4194304', 'inversion': (5, 6, 6), 'minimum': '1024', 'type': 'numeric', 'maximum': '1073741824'}], 'description': 'Max packet length to send to/receive from server', 'name': 'max_allowed_packet'},
		{'caption': 'net_buffer_length', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '16384', 'minimum': '1024', 'type': 'numeric', 'maximum': '1048576'}], 'description': 'Buffer length for TCP/IP and socket communication', 'name': 'net_buffer_length'}]),
	( 'SSL', [
		{'description': 'Enable SSL for connection (automatically enabled with other flags)', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'disabledby': 'skip-ssl', 'caption': 'ssl', 'values': [{'default': 'false', 'on': 'true', 'off': 'disabledby', 'type': 'boolean'}], 'name': 'ssl'},
		{'caption': 'ssl-ca', 'versions': [((5, 0, 23), (5, 1, 11)), ((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filename'}], 'description': 'The path to a file that contains a list of trusted SSL CAs', 'name': 'ssl-ca'},
		{'caption': 'ssl-capath', 'versions': [((5, 0, 23), (5, 1, 11)), ((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'dirname'}], 'description': 'The path to a directory that contains trusted SSL CA certificates in PEM format', 'name': 'ssl-capath'},
		{'caption': 'ssl-cert', 'versions': [((5, 0, 23), (5, 1, 11)), ((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filename'}], 'description': 'X509 cert in PEM format (implies --ssl)', 'name': 'ssl-cert'},
		{'caption': 'ssl-cipher', 'versions': [((5, 0, 23), (5, 1, 11)), ((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filename'}], 'description': 'SSL cipher to use (implies --ssl)', 'name': 'ssl-cipher'},
		{'caption': 'ssl-crl', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'type': 'filename'}], 'description': 'The path to a file that contains certificate revocation lists', 'name': 'ssl-crl'},
		{'caption': 'ssl-crlpath', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'type': 'dirname'}], 'description': 'The path to a directory that contains certificate revocation list files', 'name': 'ssl-crlpath'},
		{'caption': 'ssl-key', 'versions': [((5, 0, 23), (5, 1, 11)), ((4, 0), (4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'X509 key in PEM format (implies --ssl)', 'name': 'ssl-key'},
		{'caption': 'ssl-verify-server-cert', 'versions': [((5, 1, 11),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': '1', 'off': '0', 'type': 'boolean'}], 'description': 'For clients, verify server host name against Common Name in server certificate', 'name': 'ssl-verify-server-cert'},
		{'caption': 'skip-ssl', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': "Don't use ssl", 'name': 'skip-ssl'}]),
	( 'Timeout Settings', [
		{'caption': 'connect_timeout', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '5', 'outversion': (5, 0, 51), 'minimum': '2', 'type': 'numeric'}, {'default': '10', 'inversion': (5, 0, 52), 'type': 'numeric'}, {'default': '5', 'outversion': (5, 1, 22), 'type': 'numeric'}, {'default': '10', 'inversion': (5, 1, 23), 'type': 'numeric'}], 'description': "The number of seconds the mysqld server waits for a connect packet before responding with 'Bad handshake'", 'name': 'connect_timeout'},
		{'caption': 'interactive_timeout', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '28800', 'minimum': '1', 'type': 'numeric'}], 'description': 'The number of seconds the server waits for activity on an interactive connection before closing it', 'name': 'interactive_timeout'},
		{'caption': 'net_read_timeout', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '30', 'minimum': '1', 'type': 'numeric'}], 'description': 'Number of seconds to wait for more data from a connection before aborting the read', 'name': 'net_read_timeout'},
		{'caption': 'net_write_timeout', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '60', 'minimum': '1', 'type': 'numeric'}], 'description': 'Number of seconds to wait for a block to be written to a connection before aborting the write', 'name': 'net_write_timeout'},
		{'caption': 'wait_timeout', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '28800', 'minimum': '1', 'type': 'numeric', 'maximum': '31536000'}, {'default': '28800', 'platform': 'windows', 'minimum': '1', 'type': 'numeric', 'maximum': '2147483'}], 'description': 'The number of seconds the server waits for activity on a connection before closing it', 'name': 'wait_timeout'}]),
	( 'Advanced', [
		{'caption': 'max_connect_errors', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'outversion': (5, 6, 5), 'default': '10', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '1', 'type': 'numeric'}, {'inversion': (5, 6, 6), 'default': '100', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '1', 'type': 'numeric'}, {'outversion': (5, 6, 5), 'default': '10', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '1', 'type': 'numeric'}, {'inversion': (5, 6, 6), 'default': '100', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '1', 'type': 'numeric'}], 'description': 'Number of interrupted connections from a host before this host is blocked from further connections', 'name': 'max_connect_errors'},
		{'caption': 'max_connections', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '100', 'outversion': (5, 1, 14), 'type': 'numeric'}, {'default': '151', 'inversion': (5, 1, 15), 'minimum': '1', 'type': 'numeric', 'maximum': '16384'}, {'default': '151', 'inversion': (5, 1, 17), 'minimum': '1', 'type': 'numeric', 'maximum': '100000'}], 'description': 'The number of simultaneous clients allowed', 'name': 'max_connections'},
		{'caption': 'max_user_connections', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'The maximum number of active connections for a single user (0 = no limit)', 'name': 'max_user_connections'},
		{'caption': 'net_retry_count', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '10', 'bitsize': '32', 'minimum': '1', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '10', 'bitsize': '64', 'minimum': '1', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'Number of times to retry an interrupted read or write on a communication port before giving up', 'name': 'net_retry_count'}]),
	( 'General', [
		{'caption': 'back_log', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '50', 'outversion': (5, 6, 5), 'minimum': '1', 'type': 'numeric', 'maximum': '65535'}, {'default': 'autosize', 'inversion': (5, 6, 6), 'minimum': '1', 'type': 'numeric', 'maximum': '65535'}], 'description': 'The number of outstanding connection requests MySQL can have', 'name': 'back_log'},
		{'optype': {'format': 'bind-address=addr'}, 'description': 'IP address or host name to bind to', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'bind-address', 'values': [{'default': '0.0.0.0', 'outversion': (5, 6, 5), 'type': 'string'}, {'default': '*', 'inversion': (5, 6, 6), 'type': 'string'}], 'name': 'bind-address'},
		{'caption': 'port', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '3306', 'type': 'numeric'}], 'description': 'Port number to use for connection', 'name': 'port'},
		{'caption': 'port-open-timeout', 'versions': [((5, 0, 19), (5, 1, 5)), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'type': 'numeric'}], 'description': 'Maximum time in seconds to wait for the port to become free (Default: no wait)', 'name': 'port-open-timeout'},
		{'caption': 'skip-name-resolve', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': "Don't resolve host names. All host names are IPs or 'localhost'", 'name': 'skip-name-resolve'},
		{'caption': 'skip-networking', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': "Don't allow connection with TCP/IP", 'name': 'skip-networking'},
		{'caption': 'socket', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '/tmp/mysql.sock', 'type': 'filebrowse'}], 'description': 'Socket file to use for connection', 'name': 'socket'},
		{'caption': 'enable-named-pipe', 'versions': [(), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Enable support for named pipes.', 'name': 'enable-named-pipe'}])]),
( 'Advanced', [
	( 'Transactions', [
		{'caption': 'completion_type', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'inversion': (5, 0, 3), 'type': 'numeric', 'outversion': (5, 5, 2), 'choice': ['0', '1', '2']}, {'default': 'NO_CHAIN', 'inversion': (5, 5, 3), 'type': 'enum', 'choice': ['NO_CHAIN', 'CHAIN', 'RELEASE', '0', '1', '2']}, {'default': '0', 'inversion': (6, 0, 0), 'type': 'numeric', 'outversion': (6, 0, 14), 'choice': ['0', '1', '2']}, {'default': 'NO_CHAIN', 'inversion': (6, 0, 14), 'type': 'enum', 'choice': ['NO_CHAIN', 'CHAIN', 'RELEASE', '0', '1', '2']}], 'description': 'Default completion type', 'name': 'completion_type'},
		{'caption': 'transaction-isolation', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'enum', 'choice': ['READ-UNCOMMITTED', 'READ-COMMITTED', 'REPEATABLE-READ', 'SERIALIZABLE']}], 'description': 'Default transaction isolation level', 'name': 'transaction-isolation'},
		{'caption': 'transaction-read-only', 'versions': [((5, 6, 5),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Default transaction access mode', 'name': 'transaction-read-only'},
		{'caption': 'transaction_alloc_block_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '8192', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '1024', 'blocksize': '1024', 'type': 'numeric'}, {'default': '8192', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '1024', 'blocksize': '1024', 'type': 'numeric'}], 'description': 'Allocation block size for transactions to be stored in binary log', 'name': 'transaction_alloc_block_size'},
		{'caption': 'transaction_prealloc_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '4096', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '1024', 'blocksize': '1024', 'type': 'numeric'}, {'default': '4096', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '1024', 'blocksize': '1024', 'type': 'numeric'}], 'description': 'Persistent buffer for transactions to be stored in binary log', 'name': 'transaction_prealloc_size'}]),
	( 'Deprecated', [
		{'description': 'Disable the ISAM storage engine', 'versions': [((4, 1, 1),), ((4, 1),), ()], 'deprecated': None, 'caption': 'skip-isam', 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'name': 'skip-isam'},
		{'caption': 'old-protocol', 'versions': [(), ((4, 1),), ((4, 1, 1),)], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Use old server behaviors', 'name': 'old-protocol'},
		{'caption': 'old-alter-table', 'versions': [(), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Use old, nonoptimized alter table', 'name': 'old-alter-table'},
		{'description': 'Change the value of a variable; please note that this option is deprecated', 'versions': [(), ((4, 1), (5, 0)), ()], 'deprecated': (5, 0), 'caption': 'set-variable', 'values': [{'type': 'string'}], 'name': 'set-variable'},
		{'caption': 'skip-new', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': "Don't use new, possibly wrong routines", 'name': 'skip-new'},
		{'description': 'Synchronously flush Berkeley DB logs. Enabled by default', 'versions': [(), ((4, 1), (5, 0)), ()], 'deprecated': None, 'disabledby': 'skip-sync-bdb-logs', 'caption': 'sync-bdb-logs', 'values': [{'default': 'true', 'on': 'true', 'off': 'disabledby', 'type': 'boolean'}], 'name': 'sync-bdb-logs'},
		{'description': 'Deprecated; use --log-warnings instead', 'versions': [(), ((4, 1), (5, 0)), ()], 'deprecated': (5, 0), 'caption': 'warnings', 'values': [{'default': '1', 'bitsize': '32', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '1', 'bitsize': '64', 'minimum': '0', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'name': 'warnings'}]),
	( 'Thread specific settings', [
		{'caption': 'slow_launch_time', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '2', 'type': 'numeric'}], 'description': 'If creating the thread takes longer than this value (in seconds), the Slow_launch_threads counter will be incremented', 'name': 'slow_launch_time'},
		{'caption': 'thread_cache_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '16384'}], 'description': 'How many threads we should keep in a cache for reuse', 'name': 'thread_cache_size'},
		{'caption': 'thread_concurrency', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '10', 'minimum': '1', 'type': 'numeric', 'maximum': '512'}], 'description': 'Permits the application to give the threads system a hint for the desired number of threads that should be run at the same time', 'name': 'thread_concurrency'},
		{'optype': {'format': 'thread_handling=name'}, 'description': 'The thread-handling model', 'versions': [((5, 1, 17),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'thread_handling', 'values': [{'outversion': (5, 5, 13), 'type': 'enum', 'choice': ['no-threads', 'one-thread-per-connection']}, {'inversion': (5, 5, 16), 'type': 'enum', 'choice': ['no-threads', 'one-thread-per-connection', 'dynamically-loaded']}, {'inversion': (6, 0, 0), 'type': 'enum', 'outversion': (6, 0, 3), 'choice': ['no-threads', 'one-thread-per-connection']}, {'inversion': (6, 0, 4), 'type': 'enum', 'choice': ['no-threads', 'one-thread-per-connection', 'pool-of-threads']}], 'name': 'thread_handling'},
		{'optype': {'format': 'thread_pool_size=#'}, 'description': 'The number of thread groups in the thread pool', 'versions': [((5, 5, 16), (6, 0, 4)), ((5, 5), (6, 0)), ((6, 0, 14),)], 'caption': 'thread_pool_size', 'values': [{'default': '16', 'minimum': '1', 'type': 'numeric', 'maximum': '64'}, {'default': '20', 'inversion': (6, 0, 4), 'minimum': '1', 'type': 'numeric', 'maximum': '16384'}], 'name': 'thread_pool_size'},
		{'caption': 'thread_stack', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '196608', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '131072', 'blocksize': '1024', 'type': 'numeric'}, {'default': '262144', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '131072', 'blocksize': '1024', 'type': 'numeric'}], 'description': 'The stack size for each thread', 'name': 'thread_stack'},
		{'optype': {'format': 'thread_pool_algorithm=#'}, 'description': 'The thread pool algorithm', 'versions': [((5, 5, 16),), ((5, 5),), ()], 'caption': 'thread_pool_algorithm', 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '1'}], 'name': 'thread_pool_algorithm'},
		{'optype': {'format': 'thread_pool_high_priority_connection=#'}, 'description': 'Whether the current session is high priority', 'versions': [((5, 5, 16),), ((5, 5),), ()], 'caption': 'thread_pool_high_priority_connection', 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '1'}], 'name': 'thread_pool_high_priority_connection'},
		{'optype': {'format': 'thread_pool_max_unused_threads=#'}, 'description': 'The maximum permitted number of unused threads', 'versions': [((5, 5, 16),), ((5, 5),), ()], 'caption': 'thread_pool_max_unused_threads', 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '4096'}], 'name': 'thread_pool_max_unused_threads'},
		{'optype': {'format': 'thread_pool_prio_kickup_timer=#'}, 'description': 'How long before a statement is moved to high-priority execution', 'versions': [((5, 5, 16),), ((5, 5),), ()], 'caption': 'thread_pool_prio_kickup_timer', 'values': [{'default': '1000', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967294'}], 'name': 'thread_pool_prio_kickup_timer'},
		{'optype': {'format': 'thread_pool_stall_limit=#'}, 'description': 'How long before a statement is defined as stalled', 'versions': [((5, 5, 16),), ((5, 5),), ()], 'caption': 'thread_pool_stall_limit', 'values': [{'default': '6', 'minimum': '4', 'type': 'numeric', 'maximum': '600'}], 'name': 'thread_pool_stall_limit'}]),
	( 'Various', [
		{'caption': 'bulk_insert_buffer_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '8388608', 'bitsize': '32', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '8388608', 'bitsize': '64', 'minimum': '0', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'Size of tree cache used in bulk insert optimization', 'name': 'bulk_insert_buffer_size'},
		{'caption': 'group_concat_max_len', 'versions': [((4, 1, 10),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1024', 'bitsize': '32', 'minimum': '4', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '1024', 'bitsize': '64', 'minimum': '4', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'The maximum length of the result of function group_concat', 'name': 'group_concat_max_len'},
		{'caption': 'key_cache_block_size', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1024', 'minimum': '512', 'type': 'numeric', 'maximum': '16384'}], 'description': 'The default size of key cache blocks', 'name': 'key_cache_block_size'},
		{'caption': 'key_cache_division_limit', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '100', 'minimum': '1', 'type': 'numeric', 'maximum': '100'}], 'description': 'The minimum percentage of warm blocks in key cache', 'name': 'key_cache_division_limit'},
		{'caption': 'max_heap_table_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '16777216', 'bitsize': '32', 'minimum': '16384', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '16777216', 'bitsize': '64', 'minimum': '16384', 'type': 'numeric', 'maximum': '1844674407370954752'}], 'description': "Don't allow creation of heap tables bigger than this", 'name': 'max_heap_table_size'},
		{'caption': 'max_join_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '4294967295', 'minimum': '1', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '18446744073709551615', 'inversion': (5, 5, 0), 'minimum': '1', 'type': 'numeric', 'maximum': '18446744073709551615'}], 'description': 'Joins that are probably going to read more than max_join_size records return an error', 'name': 'max_join_size'},
		{'caption': 'max_length_for_sort_data', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1024', 'minimum': '4', 'type': 'numeric', 'maximum': '8388608'}], 'description': 'Max number of bytes in sorted records', 'name': 'max_length_for_sort_data'},
		{'caption': 'max_seeks_for_key', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '4294967295', 'bitsize': '32', 'minimum': '1', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '18446744073709547520', 'bitsize': '64', 'minimum': '1', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'Limit assumed max number of seeks when looking up rows based on a key', 'name': 'max_seeks_for_key'},
		{'caption': 'max_sort_length', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1024', 'minimum': '4', 'type': 'numeric', 'maximum': '8388608'}], 'description': 'The number of bytes to use when sorting data values', 'name': 'max_sort_length'},
		{'caption': 'max_write_lock_count', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '4294967295', 'bitsize': '32', 'minimum': '1', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '18446744073709547520', 'bitsize': '64', 'minimum': '1', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'After this many write locks, allow some read locks to run in between', 'name': 'max_write_lock_count'},
		{'caption': 'multi_range_count', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 2)), ((5, 2, 4), (6, 0, 3))], 'values': [{'default': '256', 'minimum': '1', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'The maximum number of ranges to send to a table handler at once during range selects', 'name': 'multi_range_count'},
		{'description': "Use very new, possibly 'unsafe' functions", 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'disabledby': 'skip-new', 'caption': 'new', 'values': [{'default': 'false', 'on': 'true', 'off': 'disabledby', 'type': 'boolean'}], 'name': 'new'},
		{'caption': 'preload_buffer_size', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '32768', 'minimum': '1024', 'type': 'numeric', 'maximum': '1073741824'}], 'description': 'The size of the buffer that is allocated when preloading indexes', 'name': 'preload_buffer_size'},
		{'caption': 'query_alloc_block_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '8192', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '1024', 'blocksize': '1024', 'type': 'numeric'}, {'default': '8192', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '1024', 'blocksize': '1024', 'type': 'numeric'}], 'description': 'Allocation block size for query parsing and execution', 'name': 'query_alloc_block_size'},
		{'caption': 'query_prealloc_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '8192', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '8192', 'blocksize': '1024', 'type': 'numeric'}, {'default': '8192', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '8192', 'blocksize': '1024', 'type': 'numeric'}], 'description': 'Persistent buffer for query parsing and execution', 'name': 'query_prealloc_size'},
		{'caption': 'range_alloc_block_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '2048', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '2048', 'blocksize': '1024', 'type': 'numeric'}, {'inversion': (5, 0, 54), 'default': '4096', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '4096', 'blocksize': '1024', 'type': 'numeric'}, {'default': '2048', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '2048', 'blocksize': '1024', 'type': 'numeric'}, {'inversion': (5, 0, 54), 'default': '4096', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '4096', 'blocksize': '1024', 'type': 'numeric'}], 'description': 'Allocation block size for storing ranges during optimization', 'name': 'range_alloc_block_size'},
		{'caption': 'read_buffer_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '131072', 'minimum': '8200', 'type': 'numeric', 'maximum': '2147479552'}], 'description': 'Each thread that does a sequential scan for a MyISAM table allocates a buffer of this size for each table it scans', 'name': 'read_buffer_size'},
		{'caption': 'read_rnd_buffer_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '262144', 'minimum': '8200', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'When reading rows from a MyISAM table in sorted order after a sort, the rows are read through this buffer to avoid a disk seeks. If not set, then it is set to the value of record_buffer.', 'name': 'read_rnd_buffer_size'},
		{'caption': 'tmp_table_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'system dependent', 'minimum': '1024', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'If an in-memory temporary table exceeds this size, MySQL will automatically convert it to an on-disk MyISAM table', 'name': 'tmp_table_size'}]),
	( 'Insert delayed settings', [
		{'caption': 'delayed_insert_limit', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '100', 'bitsize': '32', 'minimum': '1', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '100', 'bitsize': '64', 'minimum': '1', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'After inserting delayed_insert_limit rows, the INSERT DELAYED handler will check if there are any SELECT statements pending. If so, it allows these to execute before continuing', 'name': 'delayed_insert_limit'},
		{'caption': 'delayed_insert_timeout', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '300', 'type': 'numeric'}], 'description': 'How many seconds an INSERT DELAYED thread should wait for INSERT statements before terminating', 'name': 'delayed_insert_timeout'},
		{'caption': 'delayed_queue_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1000', 'bitsize': '32', 'minimum': '1', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '1000', 'bitsize': '64', 'minimum': '1', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'What size queue (in rows) should be allocated for handling INSERT DELAYED', 'name': 'delayed_queue_size'},
		{'caption': 'max_delayed_threads', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '20', 'minimum': '0', 'type': 'numeric', 'maximum': '16384'}], 'description': "Don't start more than this number of threads to handle INSERT DELAYED statements. If set to zero, which means INSERT DELAYED is not used", 'name': 'max_delayed_threads'}]),
	( 'General', [
		{'caption': 'bootstrap', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Used by mysql installation scripts', 'name': 'bootstrap'},
		{'caption': 'chroot', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filename'}], 'description': 'Chroot mysqld daemon during startup', 'name': 'chroot'},
		{'caption': 'debug-sync-timeout', 'versions': [((5, 1, 41), (6, 0, 6)), ((5, 1), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'numeric'}], 'description': 'Timeout for Debug Sync synchronization points', 'name': 'debug-sync-timeout'},
		{'caption': 'div_precision_increment', 'versions': [((5, 0, 6),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '4', 'minimum': '0', 'type': 'numeric', 'maximum': '30'}], 'description': "Scale of the result of '/' operator will be increased by this many digits", 'name': 'div_precision_increment'},
		{'caption': 'eq_range_index_dive_limit', 'versions': [((5, 6, 5),), ((5, 6), (5, 7)), ()], 'values': [{'default': '10', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'The cutoff for switching from index dives to index statistics', 'name': 'eq_range_index_dive_limit'},
		{'caption': 'exit-info', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'numeric'}], 'description': 'Used for debugging; Use at your own risk!', 'name': 'exit-info'},
		{'caption': 'flush', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Flush tables to disk between SQL statements', 'name': 'flush'},
		{'caption': 'flush_time', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric'}, {'default': '1800', 'platform': 'windows', 'outversion': (5, 6, 5), 'minimum': '0', 'type': 'numeric'}, {'default': '0', 'platform': 'windows', 'inversion': (5, 6, 6), 'minimum': '0', 'type': 'numeric'}], 'description': 'A dedicated thread is created to flush all tables at the given interval', 'name': 'flush_time'},
		{'caption': 'init_connect', 'versions': [((4, 1, 2),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Statements that are executed for each new connection', 'name': 'init_connect'},
		{'caption': 'init_slave', 'versions': [((4, 1, 2),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Command(s) that are executed when a slave connects to a master', 'name': 'init_slave'},
		{'caption': 'max_error_count', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '64', 'minimum': '0', 'type': 'numeric', 'maximum': '65535'}], 'description': 'Max number of errors/warnings to store for a statement', 'name': 'max_error_count'},
		{'optype': {'inversion': '5.0.21'}, 'description': 'Maximum number of prepared statements in the server', 'versions': [((4, 1, 19), (5, 0, 21), (5, 1, 10)), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'max_prepared_stmt_count', 'values': [{'default': '16382', 'minimum': '0', 'type': 'numeric', 'maximum': '1048576'}], 'name': 'max_prepared_stmt_count'},
		{'caption': 'max_sp_recursion_depth', 'versions': [((5, 0, 17),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'type': 'numeric', 'maximum': '255'}], 'description': 'Maximum stored procedure recursion depth', 'name': 'max_sp_recursion_depth'},
		{'caption': 'memlock', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Lock the mysqld process in memory', 'name': 'memlock'},
		{'caption': 'min-examined-row-limit', 'versions': [((5, 1, 21), (6, 0, 4)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'bitsize': '32', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '0', 'bitsize': '64', 'minimum': '0', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'Queries examining fewer than this number of rows are not logged to slow query log', 'name': 'min-examined-row-limit'},
		{'caption': 'mutex-deadlock-detector', 'versions': [((6, 0, 9),), ((6, 0),), ()], 'values': [{'default': 'true', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Enable detection of incorrect mutex usage', 'name': 'mutex-deadlock-detector'},
		{'caption': 'old-style-user-limits', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Enable old-style user limits (before 5.0.3, user resources were counted per each user+host vs. per account)', 'name': 'old-style-user-limits'},
		{'caption': 'open-files-limit', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '65535'}], 'description': 'If this is not 0, then mysqld will use this value to reserve file descriptors to use with setrlimit()', 'name': 'open-files-limit'},
		{'caption': 'restore_disables_events', 'versions': [((6, 0, 14),), ((6, 0),), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Whether RESTORE disables restored events', 'name': 'restore_disables_events'},
		{'caption': 'restore_elevation', 'versions': [((6, 0, 14),), ((6, 0),), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Enable or disable RESTORE privilege elevation', 'name': 'restore_elevation'},
		{'caption': 'restore_precheck', 'versions': [((6, 0, 14),), ((6, 0),), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Whether RESTORE performs privilege checking before restoring', 'name': 'restore_precheck'},
		{'caption': 'skip-concurrent-insert', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Turn off the ability to select and insert at the same time on MyISAM tables', 'name': 'skip-concurrent-insert'},
		{'description': "Don't give threads different priorities", 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)), ((5, 6, 1),)], 'deprecated': (5, 1, 29), 'caption': 'skip-thread-priority', 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'name': 'skip-thread-priority'},
		{'optype': {'format': 'slow-start-timeout=#'}, 'description': 'Wait before trying to kill windows service at startup', 'versions': [((5, 5, 20), (5, 6, 5)), ((5, 5), (5, 6), (5, 7)), ()], 'caption': 'slow-start-timeout', 'values': [{'default': '15000', 'platform': 'windows', 'type': 'numeric'}], 'name': 'slow-start-timeout'},
		{'caption': 'sync_frm', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'true', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Sync .frm to disk on create. Enabled by default', 'name': 'sync_frm'},
		{'caption': 'updatable_views_with_limit', 'versions': [((5, 0, 2),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1', 'on': '1', 'off': '0', 'type': 'boolean'}], 'description': 'This variable controls whether updates to a view can be made when the view does not contain all columns of the primary key', 'name': 'updatable_views_with_limit'},
		{'caption': 'debug', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': "'d:t:o,/tmp/mysqld.trace'", 'type': 'string'}], 'description': 'Output debug log', 'name': 'debug'},
		{'caption': 'standalone', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Instructs the MySQL server not to run as a service', 'name': 'standalone'}])]),
( 'Other', [
	( 'Storage Engines', [
		{'caption': 'skip-bdb', 'versions': [(), ((4, 1), (5, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Disable Berkeley DB (if this version of MySQL supports it)', 'name': 'skip-bdb'},
		{'caption': 'skip-merge', 'versions': [((5, 0, 24), (5, 1, 12)), ((5, 0), (5, 1)), ((5, 1, 14),)], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Disable Merge storage engine', 'name': 'skip-merge'},
		{'description': 'Disables synchronous BDB log flushes', 'versions': [(), ((4, 1), (5, 0)), ()], 'deprecated': None, 'caption': 'skip-sync-bdb-logs', 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'name': 'skip-sync-bdb-logs'},
		{'caption': 'skip-falcon', 'versions': [(), ((6, 0),), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Disable the Falcon storage engine', 'name': 'skip-falcon'},
		{'caption': 'skip-ndbcluster', 'versions': [(), ((5, 1), (5, 5), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Disable the NDB Cluster storage engine', 'name': 'skip-ndbcluster'}]),
	( 'NDB', [
		{'caption': 'ndb_autoincrement_prefetch_sz', 'versions': [((4, 1, 8),), ((4, 1), (5, 0), (5, 1), (5, 5), (6, 0)), ()], 'values': [{'default': '32', 'outversion': (5, 0, 55), 'minimum': '1', 'type': 'numeric', 'maximum': '256'}, {'default': '1', 'inversion': (5, 0, 56), 'minimum': '1', 'type': 'numeric', 'maximum': '256'}, {'inversion': (5, 1, 1), 'default': '32', 'maximum': '256', 'outversion': (5, 1, 22), 'minimum': '1', 'type': 'numeric'}, {'inversion': (5, 1, 23), 'default': '1', 'maximum': '256', 'outversion': (5, 1, 24), 'minimum': '1', 'type': 'numeric'}, {'inversion': (5, 1, 16), 'default': '32', 'maximum': '256', 'outversion': (5, 1, 22), 'minimum': '1', 'type': 'numeric'}, {'default': '1', 'inversion': (5, 1, 23), 'minimum': '1', 'type': 'numeric', 'maximum': '256'}, {'inversion': (5, 1, 19), 'default': '32', 'maximum': '256', 'outversion': (5, 1, 22), 'minimum': '1', 'type': 'numeric'}, {'inversion': (5, 1, 23), 'default': '1', 'maximum': '256', 'outversion': (5, 1, 39), 'minimum': '1', 'type': 'numeric'}, {'default': '1', 'inversion': (5, 1, 41), 'minimum': '1', 'type': 'numeric', 'maximum': '65536'}, {'inversion': (5, 1, 30), 'default': '32', 'maximum': '256', 'outversion': (5, 1, 39), 'minimum': '1', 'type': 'numeric'}, {'default': '1', 'inversion': (5, 1, 41), 'minimum': '1', 'type': 'numeric', 'maximum': '65536'}, {'default': '1', 'inversion': (5, 5, 15), 'minimum': '1', 'type': 'numeric', 'maximum': '65536'}], 'description': 'NDB auto-increment prefetch size', 'name': 'ndb_autoincrement_prefetch_sz'},
		{'caption': 'ndb-batch-size', 'versions': [((5, 1, 23),), ((5, 1), (5, 5)), ()], 'values': [{'default': '32768', 'minimum': '0', 'type': 'numeric', 'maximum': '31536000'}], 'description': 'The size (in bytes) to use for NDB transaction batches', 'name': 'ndb-batch-size'},
		{'caption': 'ndb-blob-read-batch-bytes', 'versions': [((5, 1, 51),), ((5, 1), (5, 5)), ()], 'values': [{'default': '65535', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'Specifies the size in bytes that large BLOB reads should be batched into. 0 = no limit.', 'name': 'ndb-blob-read-batch-bytes'},
		{'caption': 'ndb-blob-write-batch-bytes', 'versions': [((5, 1, 51),), ((5, 1), (5, 5)), ()], 'values': [{'default': '65535', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'Specifies the size in bytes that large BLOB writes should be batched into. 0 = no limit.', 'name': 'ndb-blob-write-batch-bytes'},
		{'caption': 'ndb_cache_check_time', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 5)), ()], 'values': [{'default': '0', 'type': 'numeric'}], 'description': 'The number of milliseconds between checks of cluster SQL nodes made by the MySQL query cache', 'name': 'ndb_cache_check_time'},
		{'caption': 'ndb-cluster-connection-pool', 'versions': [((5, 1, 19),), ((5, 1), (5, 5)), ()], 'values': [{'default': '1', 'minimum': '1', 'type': 'numeric', 'maximum': '63'}], 'description': 'The number of connections to the cluster used by MySQL', 'name': 'ndb-cluster-connection-pool'},
		{'caption': 'ndb-connectstring', 'versions': [(), ((5, 1), (5, 5)), ()], 'values': [{'type': 'string'}], 'description': 'The management server that distributes the cluster configuration', 'name': 'ndb-connectstring'},
		{'caption': 'ndb_extra_logging', 'versions': [((5, 1, 6),), ((5, 1), (5, 5)), ()], 'values': [{'default': '0', 'type': 'numeric'}], 'description': 'Controls logging of MySQL Cluster schema, connection, and data distribution events in the MySQL error log', 'name': 'ndb_extra_logging'},
		{'caption': 'ndb_force_send', 'versions': [((4, 1, 8),), ((4, 1), (5, 0), (5, 1), (5, 5)), ()], 'values': [{'default': 'true', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Forces sending of buffers to NDB immediately, without waiting for other threads', 'name': 'ndb_force_send'},
		{'caption': 'ndb-log-apply-status', 'versions': [((5, 1, 51),), ((5, 1), (5, 5)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Cause a MySQL server acting as a slave to log mysql.ndb_apply_status updates received from its immediate master in its own binary log, using its own server ID. Effective only if the server is started with the --ndbcluster option.', 'name': 'ndb-log-apply-status'},
		{'caption': 'ndb-log-transaction-id', 'versions': [((5, 1, 56), (5, 5, 15)), ((5, 1), (5, 5)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Write NDB transaction IDs in the binary log. Requires --log-bin-v1-events=OFF.', 'name': 'ndb-log-transaction-id'},
		{'caption': 'ndb_log_updated_only', 'versions': [((5, 1, 19),), ((5, 1), (5, 5)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Log complete rows (ON) or updates only (OFF)', 'name': 'ndb_log_updated_only'},
		{'caption': 'ndb-log-update-as-write', 'versions': [((5, 1, 19),), ((5, 1), (5, 5)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Toggles logging of updates on the master between updates (OFF) and writes (ON)', 'name': 'ndb-log-update-as-write'},
		{'caption': 'ndb-log-empty-epochs', 'versions': [((5, 1, 31),), ((5, 1), (5, 5)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'When enabled, causes epochs in which there were no changes to be written to the ndb_apply_status and ndb_binlog_index tables, even when --log-slave-updates is enabled.', 'name': 'ndb-log-empty-epochs'},
		{'caption': 'ndb_log_empty_epochs', 'versions': [((5, 1, 31),), ((5, 1), (5, 5)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'When enabled, epochs in which there were no changes are written to the ndb_apply_status and ndb_binlog_index tables, even when log_slave_updates is enabled.', 'name': 'ndb_log_empty_epochs'},
		{'caption': 'ndb-nodeid', 'versions': [((5, 0, 45), (5, 1, 15)), ((5, 0), (5, 1), (5, 5)), ()], 'values': [{'inversion': (5, 0, 45), 'minimum': '1', 'type': 'numeric', 'maximum': '63'}, {'inversion': (5, 1, 5), 'minimum': '1', 'type': 'numeric', 'maximum': '255'}], 'description': 'MySQL Cluster node ID for this MySQL server', 'name': 'ndb-nodeid'},
		{'caption': 'ndb-mgmd-host', 'versions': [(), ((5, 0), (5, 1), (5, 5)), ()], 'values': [{'default': 'localhost:1186', 'type': 'string'}], 'description': 'Set the host (and port, if desired) for connecting to the management server', 'name': 'ndb-mgmd-host'},
		{'caption': 'ndb-wait-connected', 'versions': [((5, 1, 16),), ((5, 1), (5, 5)), ()], 'values': [{'default': '0', 'outversion': (5, 1, 56), 'minimum': '0', 'type': 'numeric', 'maximum': '31536000'}, {'default': '0', 'outversion': (5, 1, 56), 'minimum': '0', 'type': 'numeric', 'maximum': '31536000'}, {'default': '30', 'inversion': (5, 1, 56), 'minimum': '0', 'type': 'numeric', 'maximum': '31536000'}, {'default': '30', 'inversion': (5, 1, 56), 'minimum': '0', 'type': 'numeric', 'maximum': '31536000'}], 'description': 'Time (in seconds) for the MySQL server to wait for connection to cluster management and data nodes before accepting MySQL client connections.', 'name': 'ndb-wait-connected'},
		{'caption': 'ndb-wait-setup', 'versions': [((5, 1, 39),), ((5, 1), (5, 5)), ()], 'values': [{'default': '15', 'outversion': (5, 1, 56), 'minimum': '0', 'type': 'numeric', 'maximum': '31536000'}, {'default': '15', 'outversion': (5, 1, 56), 'minimum': '0', 'type': 'numeric', 'maximum': '31536000'}, {'default': '30', 'inversion': (5, 1, 56), 'minimum': '0', 'type': 'numeric', 'maximum': '31536000'}, {'default': '30', 'inversion': (5, 1, 56), 'minimum': '0', 'type': 'numeric', 'maximum': '31536000'}], 'description': 'Time (in seconds) for the MySQL server to wait for NDB engine setup to complete.', 'name': 'ndb-wait-setup'},
		{'description': 'Enable NDB Cluster (if this version of MySQL supports it)', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 5)), ()], 'disabledby': 'skip-ndbcluster', 'caption': 'ndbcluster', 'values': [{'default': 'false', 'on': 'true', 'off': 'disabledby', 'type': 'boolean'}], 'name': 'ndbcluster'},
		{'caption': 'ndb-deferred-constraints', 'versions': [((5, 1, 56),), ((5, 1), (5, 5)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Specifies that constraint checks on unique indexes (where these are supported) should be deferred until commit time. Not normally needed or used; for testing purposes only.', 'name': 'ndb-deferred-constraints'},
		{'caption': 'ndb_deferred_constraints', 'versions': [((5, 1, 56),), ((5, 1), (5, 5)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Specifies that constraint checks should be deferred (where these are supported). Not normally needed or used; for testing purposes only.', 'name': 'ndb_deferred_constraints'},
		{'caption': 'ndb-distribution', 'versions': [((5, 1, 32),), ((5, 1), (5, 5)), ()], 'values': [{'default': 'KEYHASH', 'type': 'enum', 'choice': ['LINHASH', 'KEYHASH']}], 'description': 'Default distribution for new tables in NDBCLUSTER (KEYHASH or LINHASH, default is KEYHASH)', 'name': 'ndb-distribution'},
		{'caption': 'ndb_distribution', 'versions': [((5, 1, 32),), ((5, 1), (5, 5)), ()], 'values': [{'default': 'KEYHASH', 'type': 'enum', 'choice': ['LINHASH', 'KEYHASH']}], 'description': 'Default distribution for new tables in NDBCLUSTER (KEYHASH or LINHASH, default is KEYHASH)', 'name': 'ndb_distribution'},
		{'caption': 'ndb_index_stat_cache_entries', 'versions': [(), ((4, 1), (5, 0), (5, 1)), ((5, 1, 14),)], 'values': [{'default': '32', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'Sets the granularity of the statistics by determining the number of starting and ending keys', 'name': 'ndb_index_stat_cache_entries'},
		{'caption': 'ndb_index_stat_enable', 'versions': [(), ((4, 1), (5, 0), (5, 1)), ((5, 1, 19),)], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Use NDB index statistics in query optimization', 'name': 'ndb_index_stat_enable'},
		{'caption': 'ndb_index_stat_update_freq', 'versions': [(), ((4, 1), (5, 0), (5, 1)), ((5, 1, 14),)], 'values': [{'default': '20', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}], 'description': 'How often to query data nodes instead of the statistics cache', 'name': 'ndb_index_stat_update_freq'},
		{'caption': 'ndb_optimized_node_selection', 'versions': [((4, 1, 9),), ((4, 1), (5, 0), (5, 1), (5, 5)), ()], 'values': [{'on': 'on', 'inversion': (4, 1, 9), 'off': 'off', 'default': 'on', 'outversion': (5, 1, 22), 'type': 'boolean'}, {'default': '3', 'inversion': (5, 1, 22), 'minimum': '0', 'type': 'numeric', 'maximum': '3'}], 'description': 'Determines how an SQL node chooses a cluster data node to use as transaction coordinator', 'name': 'ndb_optimized_node_selection'},
		{'caption': 'ndb_report_thresh_binlog_epoch_slip', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 5), (6, 0)), ()], 'values': [{'default': '3', 'minimum': '0', 'type': 'numeric', 'maximum': '256'}], 'description': 'This is a threshold on the number of epochs to be behind before reporting binlog status', 'name': 'ndb_report_thresh_binlog_epoch_slip'},
		{'caption': 'ndb_report_thresh_binlog_mem_usage', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 5), (6, 0)), ()], 'values': [{'default': '10', 'minimum': '0', 'type': 'numeric', 'maximum': '10'}], 'description': 'This is a threshold on the percentage of free memory remaining before reporting binlog status', 'name': 'ndb_report_thresh_binlog_mem_usage'},
		{'caption': 'ndb_use_transactions', 'versions': [((4, 1, 18),), ((4, 1), (5, 0), (5, 1), (5, 5), (6, 0)), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Forces NDB to use a count of records during SELECT COUNT(*) query planning to speed up this type of query', 'name': 'ndb_use_transactions'}]),
	( 'Memcached', [
		{'caption': 'daemon_memcached_enable_binlog', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': '', 'name': 'daemon_memcached_enable_binlog'},
		{'caption': 'daemon_memcached_engine_lib_name', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'innodb_engine.so', 'type': 'string'}], 'description': 'Specifies the shared library that implements the InnoDB memcached plugin', 'name': 'daemon_memcached_engine_lib_name'},
		{'caption': 'daemon_memcached_engine_lib_path', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '', 'type': 'string'}], 'description': 'The path of the directory containing the shared library that implements the InnoDB memcached plugin', 'name': 'daemon_memcached_engine_lib_path'},
		{'caption': 'daemon_memcached_option', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '', 'type': 'string'}], 'description': 'Space-separated options that are passed to the underlying memcached daemon on startup', 'name': 'daemon_memcached_option'},
		{'caption': 'daemon_memcached_r_batch_size', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '1', 'type': 'numeric'}], 'description': 'Specifies how many memcached read operations to perform before doing a COMMIT to start a new transaction', 'name': 'daemon_memcached_r_batch_size'},
		{'caption': 'daemon_memcached_w_batch_size', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '1', 'type': 'numeric'}], 'description': 'Specifies how many memcached write operations to perform before doing a COMMIT to start a new transaction', 'name': 'daemon_memcached_w_batch_size'}])]),
( 'Security', [
	( 'Security', [
		{'caption': 'allow-suspicious-udfs', 'versions': [((4, 1, 10), (5, 0, 3)), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Allows use of UDFs consisting of only one symbol xxx() without corresponding xxx_init() or xxx_deinit()', 'name': 'allow-suspicious-udfs'},
		{'caption': 'authentication_windows_log_level', 'versions': [((5, 5, 16),), ((5, 5),), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '4'}], 'description': 'Windows authentication plugin logging level', 'name': 'authentication_windows_log_level'},
		{'caption': 'authentication_windows_use_principal_name', 'versions': [((5, 5, 16),), ((5, 5),), ()], 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Whether to use Windows authentication plugin principal name', 'name': 'authentication_windows_use_principal_name'},
		{'optype': {'format': 'des-key-file=file_name'}, 'description': 'Load keys for des_encrypt() and des_encrypt from given file', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'des-key-file', 'values': [], 'name': 'des-key-file'},
		{'caption': 'read_only', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Make all nontemporary tables read only', 'name': 'read_only'},
		{'caption': 'safe-mode', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)), ((5, 6, 6),)], 'values': [{'on': '1', 'off': '0', 'type': 'boolean'}], 'description': 'Skip some optimization stages (for testing)', 'name': 'safe-mode'},
		{'description': 'Deprecated option; use GRANT SHOW DATABASES instead', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)), ((5, 5, 3),)], 'deprecated': (4, 0, 2), 'caption': 'safe-show-database', 'values': [{'on': '1', 'off': '0', 'type': 'boolean'}], 'name': 'safe-show-database'},
		{'caption': 'safe-user-create', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': "Don't allow new user creation by the user who has no write privileges to the mysql.user table", 'name': 'safe-user-create'},
		{'caption': 'safemalloc-mem-limit', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)), ((5, 5, 6),)], 'values': [{'type': 'numeric'}], 'description': 'Simulate memory shortage', 'name': 'safemalloc-mem-limit'},
		{'caption': 'secure-auth', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'outversion': (5, 6, 4), 'off': 'off', 'type': 'boolean'}, {'default': 'on', 'on': 'on', 'inversion': (5, 6, 5), 'off': 'off', 'type': 'boolean'}], 'description': 'Disallow authentication for accounts that have old (pre-4.1) passwords', 'name': 'secure-auth'},
		{'caption': 'secure-backup-file-priv', 'versions': [((6, 0, 11),), ((6, 0),), ()], 'values': [{'type': 'string'}], 'description': 'Limit BACKUP DATABASE and RESTORE to files in a single directory', 'name': 'secure-backup-file-priv'},
		{'optype': {'format': 'secure-file-priv=path'}, 'description': 'Limit LOAD_FILE(), LOAD DATA, and SELECT ... INTO OUTFILE to files in specified directory', 'versions': [((5, 0, 38), (5, 1, 17)), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'secure-file-priv', 'values': [{'type': 'string'}], 'name': 'secure-file-priv'},
		{'caption': 'skip-grant-tables', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Start without grant tables. This gives all users FULL ACCESS to all tables', 'name': 'skip-grant-tables'},
		{'caption': 'skip-show-database', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'on': 'name', 'off': 'del', 'type': 'boolean'}], 'description': 'Do not allow SHOW DATABASE statements', 'name': 'skip-show-database'}]),
	( 'Validate password', [
		{'optype': {'format': 'validate-password[=value]'}, 'description': 'Whether to activate the audit log plugin', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'caption': 'validate-password', 'values': [{'default': 'ON', 'type': 'enum', 'choice': ['ON', 'OFF', 'FORCE', 'FORCE_PLUS_PERMANENT']}], 'name': 'validate-password'},
		{'caption': 'validate_password_dictionary_file', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '{configdir}/mysql_password_dictionary.txt', 'type': 'fileedit'}], 'description': 'validate_password dictionary file', 'name': 'validate_password_dictionary_file'},
		{'caption': 'validate_password_length', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '8', 'minimum': '0', 'type': 'numeric'}], 'description': 'validate_password required password length', 'name': 'validate_password_length'},
		{'caption': 'validate_password_mixed_case_count', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '1', 'minimum': '0', 'type': 'numeric'}], 'description': 'validate_password required number of uppercase/lowercase characters', 'name': 'validate_password_mixed_case_count'},
		{'caption': 'validate_password_number_count', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '1', 'minimum': '0', 'type': 'numeric'}], 'description': 'validate_password required number of digit characters', 'name': 'validate_password_number_count'},
		{'caption': 'validate_password_policy_number', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '1', 'type': 'enum', 'choice': ['0', '1', '2']}], 'description': 'validate_password password policy', 'name': 'validate_password_policy_number'},
		{'caption': 'validate_password_special_char_count', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'default': '1', 'minimum': '0', 'type': 'numeric'}], 'description': 'validate_password required number of special characters', 'name': 'validate_password_special_char_count'}]),
	( 'Authentication', [
		{'optype': {'format': 'default-authentication-plugin=plugin_name'}, 'description': 'The default authentication plugin', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'caption': 'default-authentication-plugin', 'values': [{'default': 'mysql_native_password', 'type': 'enum', 'choice': ['mysql_native_password', 'sha256_password']}], 'name': 'default-authentication-plugin'},
		{'caption': 'old_passwords', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'on': '1', 'outversion': (5, 6, 5), 'off': '0', 'type': 'boolean'}, {'default': '0', 'inversion': (5, 6, 6), 'type': 'enum', 'choice': ['0', '1', '2']}], 'description': 'Type of password encryption method', 'name': 'old_passwords'}])]),
( 'Replication', [
	( 'Relay Log', [
		{'caption': 'max_relay_log_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '1073741824'}], 'description': 'If nonzero, relay log will be rotated automatically when the size exceeds this value', 'name': 'max_relay_log_size'},
		{'caption': 'relay-log', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filename'}], 'description': 'The location and base name to use for relay logs', 'name': 'relay-log'},
		{'caption': 'relay-log-index', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'filename'}], 'description': 'The location and name to use for the file that keeps a list of the last relay logs', 'name': 'relay-log-index'},
		{'caption': 'relay-log-info-file', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'relay-log.info', 'type': 'filename'}], 'description': 'The location and name of the file that remembers where the SQL replication thread is in the relay logs', 'name': 'relay-log-info-file'},
		{'caption': 'relay_log_info_file', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'relay-log.info', 'type': 'filedownload'}], 'description': 'The name of the file in which the slave records information about the relay logs.', 'name': 'relay_log_info_file'},
		{'caption': 'relay-log-info-repository', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'FILE', 'type': 'string', 'choice': ['FILE', 'TABLE']}], 'description': "Whether to write the replication SQL thread's location in the relay logs to a file or a table.", 'name': 'relay-log-info-repository'},
		{'caption': 'relay_log_index', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '*host_name*-relay-bin.index', 'type': 'string'}], 'description': 'The name of the relay log index file.', 'name': 'relay_log_index'},
		{'caption': 'relay_log_purge', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'true', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Determines whether relay logs are purged', 'name': 'relay_log_purge'},
		{'caption': 'relay-log-recovery', 'versions': [((6, 0, 11),), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Enables automatic recovery of relay log files from master at startup', 'name': 'relay-log-recovery'},
		{'caption': 'relay_log_recovery', 'versions': [((6, 0, 11),), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Whether automatic recovery of relay log files from master at startup is enabled', 'name': 'relay_log_recovery'},
		{'caption': 'relay_log_space_limit', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'bitsize': '32', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '0', 'bitsize': '64', 'minimum': '0', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'Maximum space to use for all relay logs', 'name': 'relay_log_space_limit'},
		{'caption': 'sync_relay_log', 'versions': [((6, 0, 10),), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'outversion': (5, 6, 5), 'default': '0', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '0', 'type': 'numeric'}, {'outversion': (5, 6, 5), 'default': '0', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '0', 'type': 'numeric'}, {'inversion': (5, 6, 6), 'default': '10000', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '0', 'type': 'numeric'}, {'inversion': (5, 6, 6), 'default': '10000', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '0', 'type': 'numeric'}], 'description': 'Synchronize relay log to disk after every #th event.', 'name': 'sync_relay_log'},
		{'caption': 'sync_relay_log_info', 'versions': [((6, 0, 11),), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'outversion': (5, 6, 5), 'default': '0', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '0', 'type': 'numeric'}, {'outversion': (5, 6, 5), 'default': '0', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '0', 'type': 'numeric'}, {'inversion': (5, 6, 6), 'default': '10000', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '0', 'type': 'numeric'}, {'inversion': (5, 6, 6), 'default': '10000', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '0', 'type': 'numeric'}], 'description': 'Synchronize relay.info file to disk after every #th event.', 'name': 'sync_relay_log_info'}]),
	( 'Master', [
		{'caption': 'auto_increment_increment', 'versions': [((5, 0, 2),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1', 'minimum': '1', 'type': 'numeric', 'maximum': '65535'}], 'description': 'AUTO_INCREMENT columns are incremented by this value', 'name': 'auto_increment_increment'},
		{'caption': 'auto_increment_offset', 'versions': [((5, 0, 2),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1', 'minimum': '1', 'type': 'numeric', 'maximum': '65535'}], 'description': 'Offset added to AUTO_INCREMENT columns', 'name': 'auto_increment_offset'},
		{'description': 'The number of seconds the slave thread will sleep before retrying to connect to the master in case the master goes down or the connection is lost', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)], 'deprecated': (5, 1, 17), 'caption': 'master-connect-retry', 'values': [{'default': '60', 'type': 'numeric'}], 'name': 'master-connect-retry'},
		{'description': 'Master host name or IP address for replication', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)], 'deprecated': (5, 1, 17), 'caption': 'master-host', 'values': [{'type': 'string'}], 'name': 'master-host'},
		{'optype': {'format': 'master-info-file=file_name'}, 'description': "The location and name of the file that remembers the master and where the I/O replication thread is in the master's binlogs", 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'master-info-file', 'values': [{'default': 'master.info', 'type': 'filename'}], 'name': 'master-info-file'},
		{'caption': 'master-info-repository', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'FILE', 'type': 'string', 'choice': ['FILE', 'TABLE']}], 'description': "Whether to write master status information and replication I/O thread location in the master's binary logs to a file or table.", 'name': 'master-info-repository'},
		{'description': 'The password the slave thread will authenticate with when connecting to the master', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)], 'deprecated': (5, 1, 17), 'caption': 'master-password', 'values': [{'type': 'string'}], 'name': 'master-password'},
		{'description': 'The port the master is listening on', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)], 'deprecated': (5, 1, 17), 'caption': 'master-port', 'values': [{'default': '3306', 'type': 'numeric'}], 'name': 'master-port'},
		{'caption': 'master-retry-count', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '86400', 'bitsize': '32', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '86400', 'bitsize': '64', 'minimum': '0', 'type': 'numeric', 'maximum': '18446744073709551615'}], 'description': 'The number of tries the slave will make to connect to the master before giving up', 'name': 'master-retry-count'},
		{'description': 'Enable the slave to connect to the master using SSL', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)], 'deprecated': (5, 1, 17), 'caption': 'master-ssl', 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'name': 'master-ssl'},
		{'description': 'Master SSL CA file. Only applies if you have enabled master-ssl', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)], 'deprecated': (5, 1, 17), 'caption': 'master-ssl-ca', 'values': [{'type': 'filename'}], 'name': 'master-ssl-ca'},
		{'description': 'Master SSL CA path. Only applies if you have enabled master-ssl', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)], 'deprecated': (5, 1, 17), 'caption': 'master-ssl-capath', 'values': [{'type': 'filename'}], 'name': 'master-ssl-capath'},
		{'description': 'Master SSL certificate file name. Only applies if you have enabled master-ssl', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)], 'deprecated': (5, 1, 17), 'caption': 'master-ssl-cert', 'values': [{'type': 'filename'}], 'name': 'master-ssl-cert'},
		{'description': 'Master SSL cipher. Only applies if you have enabled master-ssl', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)], 'deprecated': (5, 1, 17), 'caption': 'master-ssl-cipher', 'values': [{'type': 'filename'}], 'name': 'master-ssl-cipher'},
		{'description': 'Master SSL keyfile name. Only applies if you have enabled master-ssl', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)], 'deprecated': (5, 1, 17), 'caption': 'master-ssl-key', 'values': [{'type': 'filename'}], 'name': 'master-ssl-key'},
		{'description': 'The user name the slave thread will use for authentication when connecting to the master. The user must have FILE privilege. If the master user is not set, user test is assumed. The value in master.info will take precedence if it can be read', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5)), ((5, 5, 3),)], 'deprecated': (5, 1, 17), 'caption': 'master-user', 'values': [{'default': 'test', 'type': 'string'}], 'name': 'master-user'},
		{'caption': 'master-verify-checksum', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Cause master to examine checksums when reading from the binary log', 'name': 'master-verify-checksum'},
		{'caption': 'sync_master_info', 'versions': [((6, 0, 11),), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'outversion': (5, 6, 5), 'default': '0', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '0', 'type': 'numeric'}, {'outversion': (5, 6, 5), 'default': '0', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '0', 'type': 'numeric'}, {'inversion': (5, 6, 6), 'default': '10000', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '0', 'type': 'numeric'}, {'inversion': (5, 6, 6), 'default': '10000', 'bitsize': '64', 'maximum': '18446744073709547520', 'minimum': '0', 'type': 'numeric'}], 'description': 'Synchronize master.info to disk after every #th event.', 'name': 'sync_master_info'}]),
	( 'Slave', [
		{'caption': 'slave_exec_mode', 'versions': [((5, 1, 23), (6, 0, 5)), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'STRICT', 'type': 'enum', 'choice': ['IDEMPOTENT', 'STRICT']}], 'description': 'Allows for switching between idempotent mode (key and some other errors suppressed) and strict mode; strict mode is the default, except for MySQL Cluster, where idempotent is always used', 'name': 'slave_exec_mode'},
		{'caption': 'abort-slave-event-count', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric'}], 'description': 'Option used by mysql-test for debugging and testing of replication', 'name': 'abort-slave-event-count'},
		{'caption': 'disconnect-slave-event-count', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'type': 'numeric'}], 'description': 'Option used by mysql-test for debugging and testing of replication', 'name': 'disconnect-slave-event-count'},
		{'caption': 'init_slave', 'versions': [((4, 1, 2),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Command(s) that are executed when a slave connects to a master', 'name': 'init_slave'},
		{'caption': 'show-slave-auth-info', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Show user name and password in SHOW SLAVE HOSTS on this master', 'name': 'show-slave-auth-info'},
		{'caption': 'slave_allow_batching', 'versions': [((5, 1, 19),), ((5, 1), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Turns update batching on and off for a replication slave', 'name': 'slave_allow_batching'},
		{'caption': 'slave-load-tmpdir', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '/tmp', 'type': 'filename'}], 'description': 'The location where the slave should put its temporary files when replicating a LOAD DATA INFILE statement', 'name': 'slave-load-tmpdir'},
		{'caption': 'slave-skip-errors', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [], 'description': 'Tells the slave thread to continue replication when a query returns an error from the provided list', 'name': 'slave-skip-errors'},
		{'caption': 'slave-checkpoint-group', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': '512', 'blocksize': '8', 'minimum': '32', 'type': 'numeric', 'maximum': '524280'}], 'description': 'Maximum number of transactions processed by a multi-threaded slave before a checkpoint operation is called to update progress status.', 'name': 'slave-checkpoint-group'},
		{'caption': 'slave_checkpoint_group', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': '512', 'blocksize': '8', 'minimum': '32', 'type': 'numeric', 'maximum': '524280'}], 'description': 'Maximum number of transactions processed by a multi-threaded slave before a checkpoint operation is called to update progress status.', 'name': 'slave_checkpoint_group'},
		{'caption': 'slave-checkpoint-period', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': '300', 'units': 'millisecond', 'minimum': '1', 'type': 'numeric', 'maximum': '4G'}], 'description': 'Update progress status of multi-threaded slave and flush relay log info to disk after this number of milliseconds.', 'name': 'slave-checkpoint-period'},
		{'caption': 'slave_checkpoint_period', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': '300', 'units': 'millisecond', 'minimum': '1', 'type': 'numeric', 'maximum': '4G'}], 'description': 'Update progress status of multi-threaded slave and flush relay log info to disk after this number of milliseconds.', 'name': 'slave_checkpoint_period'},
		{'caption': 'slave_compressed_protocol', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Use compression on master/slave protocol', 'name': 'slave_compressed_protocol'},
		{'caption': 'slave-max-allowed-packet', 'versions': [((5, 1, 64), (5, 5, 26), (5, 6, 6)), ((5, 1), (5, 5), (5, 6), (5, 7)), ()], 'values': [{'default': '1073741824', 'minimum': '1024', 'type': 'numeric', 'maximum': '1073741824'}], 'description': 'Maximum size, in bytes, of a packet that can be sent from a replication master to a slave; overrides max_allowed_packet.', 'name': 'slave-max-allowed-packet'},
		{'caption': 'slave-net-timeout', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '3600', 'minimum': '1', 'type': 'numeric'}], 'description': 'Number of seconds to wait for more data from a master/slave connection before aborting the read', 'name': 'slave-net-timeout'},
		{'caption': 'slave-parallel-workers', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'values': [{'default': '0', 'minimum': '0', 'type': 'numeric', 'maximum': '1024'}], 'description': 'Number of worker threads for executing events in parallel. Set to 0 (the default) to disable slave multi-threading.', 'name': 'slave-parallel-workers'},
		{'caption': 'slave-rows-search-algorithms', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'values': [{'type': 'set', 'choice': ['TABLE_SCAN,INDEX_SCAN', 'INDEX_SCAN,HASH_SCAN', 'TABLE_SCAN,HASH_SCAN', 'TABLE_SCAN,INDEX_SCAN,HASH_SCAN']}], 'description': 'Determines search algorithms used for slave update batching. Any 2 or 3 from the list INDEX_SEARCH, TABLE_SCAN, HASH_SCAN; the default is TABLE_SCAN,INDEX_SCAN.', 'name': 'slave-rows-search-algorithms'},
		{'caption': 'slave-sql-verify-checksum', 'versions': [((5, 6, 2),), ((5, 6), (5, 7)), ()], 'values': [{'default': '0', 'on': '1', 'type': 'boolean', 'off': '0', 'choice': ['0', '1']}], 'description': 'Cause slave to examine checksums when reading from the relay log', 'name': 'slave-sql-verify-checksum'},
		{'caption': 'slave_transaction_retries', 'versions': [((4, 1, 11), (5, 0, 3)), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '10', 'bitsize': '32', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '10', 'bitsize': '64', 'minimum': '0', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'Number of times the slave SQL thread will retry a transaction in case it failed with a deadlock or elapsed lock wait timeout, before giving up and stopping', 'name': 'slave_transaction_retries'},
		{'caption': 'slave_type_conversions', 'versions': [((5, 1, 44), (5, 5, 3), (6, 0, 14)), ((5, 1), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '', 'type': 'set', 'choice': ['ALL_LOSSY', 'ALL_NON_LOSSY', 'ALL_LOSSY,ALL_NON_LOSSY']}], 'description': 'Controls type conversion mode on replication slave. Value is a list of zero or more elements from the list: ALL_LOSSY, ALL_NON_LOSSY. Set to an empty string to disallow type conversions between master and slave.', 'name': 'slave_type_conversions'}]),
	( 'General', [
		{'caption': 'disable-gtid-unsafe-statements', 'versions': [((5, 6, 5),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Prevents execution of statements that cannot be logged in a transactionally safe manner. These include CREATE TEMPORARY TABLE inside transactions, all updates to non-transactional tables, and CREATE TABLE ... SELECT.', 'name': 'disable-gtid-unsafe-statements'},
		{'caption': 'disable_gtid_unsafe_statements', 'versions': [((5, 6, 5),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'When true, execution of statements that cannot be logged in a transactionally safe manner is not allowed. Read-only; set using --disable-gtid-unsafe-statements when starting the server.', 'name': 'disable_gtid_unsafe_statements'},
		{'caption': 'gtid-mode', 'versions': [((5, 6, 5),), ((5, 6), (5, 7)), ()], 'values': [{'default': 'OFF', 'type': 'enum', 'choice': ['OFF', 'UPGRADE_STEP_1', 'UPGRADE_STEP_2', 'ON']}], 'description': 'ON enables GTIDs; OFF disables them. UPGRADE_STEP_1 and UPGRADE_STEP_2 are currently unsupported.', 'name': 'gtid-mode'},
		{'caption': 'init-rpl-role', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Set the replication role (not used)', 'name': 'init-rpl-role'},
		{'caption': 'replicate-do-db', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Tells the slave SQL thread to restrict replication to the specified database', 'name': 'replicate-do-db'},
		{'caption': 'replicate-do-table', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Tells the slave SQL thread to restrict replication to the specified table', 'name': 'replicate-do-table'},
		{'caption': 'replicate-ignore-db', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Tells the slave SQL thread not to replicate to the specified database', 'name': 'replicate-ignore-db'},
		{'caption': 'replicate-ignore-table', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Tells the slave SQL thread not to replicate to the specified table', 'name': 'replicate-ignore-table'},
		{'caption': 'replicate-rewrite-db', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Updates to a database with a different name than the original', 'name': 'replicate-rewrite-db'},
		{'caption': 'replicate-same-server-id', 'versions': [((5, 0, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'In replication, if set to 1, do not skip events having our server id', 'name': 'replicate-same-server-id'},
		{'caption': 'replicate-wild-do-table', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Tells the slave thread to restrict replication to the tables that match the specified wildcard pattern', 'name': 'replicate-wild-do-table'},
		{'caption': 'replicate-wild-ignore-table', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Tells the slave thread not to replicate to the tables that match the given wildcard pattern', 'name': 'replicate-wild-ignore-table'},
		{'caption': 'report-host', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'Host name or IP of the slave to be reported to the master during slave registration', 'name': 'report-host'},
		{'caption': 'report-password', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'An arbitrary password that the slave server should report to the master. Not the same as the password for the MySQL replication user account', 'name': 'report-password'},
		{'caption': 'report-port', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '3306', 'type': 'numeric'}, {'default': '0', 'inversion': (5, 5, 23), 'type': 'numeric'}, {'default': '[slave_port]', 'inversion': (5, 6, 5), 'type': 'numeric'}], 'description': 'Port for connecting to slave reported to the master during slave registration', 'name': 'report-port'},
		{'caption': 'report-user', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'type': 'string'}], 'description': 'An arbitrary user name that a slave server should report to the master. Not the same as the name used with the MySQL replication user account.', 'name': 'report-user'},
		{'caption': 'skip-slave-start', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'If set, slave is not autostarted', 'name': 'skip-slave-start'}])]),
( 'MyISAM', [
	( 'Advanced Settings', [
		{'caption': 'myisam-block-size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1024', 'minimum': '1024', 'type': 'numeric', 'maximum': '16384'}], 'description': 'Block size to be used for MyISAM index pages', 'name': 'myisam-block-size'},
		{'caption': 'myisam_data_pointer_size', 'versions': [((4, 1, 2),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '4', 'outversion': (5, 0, 5), 'minimum': '2', 'type': 'numeric', 'maximum': '8'}, {'default': '6', 'inversion': (5, 0, 6), 'minimum': '2', 'type': 'numeric', 'maximum': '7'}], 'description': 'Default pointer size to be used for MyISAM tables', 'name': 'myisam_data_pointer_size'},
		{'optype': {'outversion': '5.0.6'}, 'description': 'Deprecated option', 'versions': [(), ((4, 1), (5, 0)), ()], 'deprecated': (5, 0, 6), 'caption': 'myisam_max_extra_sort_file_size', 'values': [{'default': '2147483648', 'outversion': (5, 0, 6), 'type': 'numeric'}], 'name': 'myisam_max_extra_sort_file_size'},
		{'caption': 'myisam_max_sort_file_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '2147483648', 'type': 'numeric'}], 'description': "Don't use the fast sort index method to create index if the temporary file would get bigger than this", 'name': 'myisam_max_sort_file_size'},
		{'caption': 'myisam_mmap_size', 'versions': [((5, 0, 90), (5, 1, 43), (5, 5, 1), (6, 0, 14)), ((5, 0), (5, 1), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '4294967295', 'bitsize': '32', 'minimum': '7', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '18446744073709547520', 'bitsize': '64', 'minimum': '7', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'The maximum amount of memory to use for memory mapping compressed MyISAM files.', 'name': 'myisam_mmap_size'},
		{'caption': 'myisam-recover', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (6, 0)), ((5, 5, 3), (6, 0, 14))], 'values': [{'default': 'OFF', 'type': 'enum', 'choice': ['DEFAULT', 'BACKUP', 'FORCE', 'QUICK']}], 'description': 'Set the mode for automatic MyISAM recovery', 'name': 'myisam-recover'},
		{'caption': 'myisam-recover-options', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'OFF', 'type': 'enum', 'choice': ['OFF', 'DEFAULT', 'BACKUP', 'FORCE', 'QUICK']}], 'description': 'Set the mode for automatic MyISAM recovery', 'name': 'myisam-recover-options'},
		{'caption': 'myisam_repair_threads', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1', 'bitsize': '32', 'minimum': '1', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '1', 'bitsize': '64', 'minimum': '1', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'Number of threads to use when repairing MyISAM tables. The value of 1 disables parallel repair', 'name': 'myisam_repair_threads'},
		{'caption': 'myisam_sort_buffer_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '8388608', 'bitsize': '32', 'minimum': '4', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '8388608', 'bitsize': '64', 'minimum': '4', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'The buffer that is allocated when sorting the index when doing a REPAIR or when creating indexes with CREATE INDEX or ALTER TABLE', 'name': 'myisam_sort_buffer_size'},
		{'caption': 'myisam_stats_method', 'versions': [((4, 1, 15), (5, 0, 14)), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'nulls_unequal', 'inversion': (4, 1), 'type': 'enum'}, {'inversion': (5, 0), 'type': 'enum', 'choice': ['nulls_equal', 'nulls_unequal', 'nulls_ignored']}], 'description': 'Specifies how MyISAM index statistics collection code should treat NULLs', 'name': 'myisam_stats_method'},
		{'caption': 'myisam_use_mmap', 'versions': [((5, 1, 4),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Use memory mapping for reading and writing MyISAM tables', 'name': 'myisam_use_mmap'}]),
	( 'Fulltext search', [
		{'caption': 'ft_boolean_syntax', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '+-><()~*:""&', 'type': 'string'}], 'description': 'List of operators for MATCH ... AGAINST ( ... IN BOOLEAN MODE)', 'name': 'ft_boolean_syntax'},
		{'caption': 'ft_max_word_len', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'minimum': '10', 'type': 'numeric'}], 'description': 'The maximum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable', 'name': 'ft_max_word_len'},
		{'caption': 'ft_min_word_len', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '4', 'minimum': '1', 'type': 'numeric'}], 'description': 'The minimum length of the word to be included in a FULLTEXT index. Note: FULLTEXT indexes must be rebuilt after changing this variable', 'name': 'ft_min_word_len'},
		{'caption': 'ft_query_expansion_limit', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '20', 'minimum': '0', 'type': 'numeric', 'maximum': '1000'}], 'description': 'Number of best matches to use for query expansion', 'name': 'ft_query_expansion_limit'},
		{'optype': {'format': 'ft_stopword_file=file_name'}, 'description': 'Use stopwords from this file instead of built-in list', 'versions': [((4, 1, 10),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'ft_stopword_file', 'values': [{'default': '{configdir}/mysql_ft_stopword_file.txt', 'type': 'fileedit'}], 'name': 'ft_stopword_file'}]),
	( 'General', [
		{'description': 'Use concurrent insert with MyISAM', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'disabledby': 'skip-concurrent-insert', 'caption': 'concurrent_insert', 'values': [{'default': 'true', 'on': 'true', 'outversion': (5, 0, 5), 'off': 'false', 'type': 'boolean'}, {'default': '1', 'inversion': (5, 0, 6), 'type': 'numeric', 'outversion': (5, 5, 2), 'choice': ['0', '1', '2']}, {'default': 'AUTO', 'inversion': (5, 5, 3), 'type': 'enum', 'choice': ['NEVER', 'AUTO', 'ALWAYS', '0', '1', '2']}, {'default': '1', 'inversion': (6, 0, 0), 'type': 'numeric', 'outversion': (6, 0, 14), 'choice': ['0', '1', '2']}, {'default': 'AUTO', 'inversion': (6, 0, 14), 'type': 'enum', 'choice': ['NEVER', 'AUTO', 'ALWAYS', '0', '1', '2']}], 'name': 'concurrent_insert'},
		{'caption': 'keep_files_on_create', 'versions': [((5, 0, 48), (5, 1, 21)), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'off', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'description': 'Do not overwrite existing .MYD/.MYI files in default database directory', 'name': 'keep_files_on_create'},
		{'caption': 'key_buffer_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '8388608', 'outversion': (5, 1, 22), 'minimum': '8', 'type': 'numeric', 'maximum': '4294967295'}, {'inversion': (5, 1, 23), 'default': '8388608', 'bitsize': '32', 'maximum': '4294967295', 'minimum': '8', 'type': 'numeric'}, {'inversion': (5, 1, 23), 'default': '8388608', 'bitsize': '64', 'maximum': 'OS_PER_PROCESS_LIMIT', 'minimum': '8', 'type': 'numeric'}], 'description': 'The size of the buffer used for index blocks for MyISAM tables', 'name': 'key_buffer_size'},
		{'caption': 'key_cache_age_threshold', 'versions': [((4, 1, 1),), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '300', 'bitsize': '32', 'minimum': '100', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '300', 'bitsize': '64', 'minimum': '100', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'This characterizes the number of hits a hot block has to be untouched until it is considered aged enough to be downgraded to a warm block. This specifies the percentage ratio of that number of hits to the total number of blocks in key cache', 'name': 'key_cache_age_threshold'}])]),
( 'Performance', [
	( 'Query cache', [
		{'caption': 'query_cache_limit', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1048576', 'bitsize': '32', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '1048576', 'bitsize': '64', 'minimum': '0', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': "Don't cache results that are bigger than this", 'name': 'query_cache_limit'},
		{'caption': 'query_cache_min_res_unit', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '4096', 'bitsize': '32', 'minimum': '512', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '4096', 'bitsize': '64', 'minimum': '512', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'Minimal size of unit in which space for results is allocated (last unit will be trimmed after writing all result data)', 'name': 'query_cache_min_res_unit'},
		{'caption': 'query_cache_size', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '0', 'bitsize': '32', 'minimum': '0', 'type': 'numeric', 'maximum': '4294967295'}, {'default': '0', 'bitsize': '64', 'minimum': '0', 'type': 'numeric', 'maximum': '18446744073709547520'}], 'description': 'The memory allocated to store results from old queries', 'name': 'query_cache_size'},
		{'caption': 'query_cache_type', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1', 'type': 'enum', 'choice': ['0', '1', '2']}], 'description': 'Query cache type', 'name': 'query_cache_type'},
		{'caption': 'query_cache_wlock_invalidate', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'Invalidate queries in query cache on LOCK for write', 'name': 'query_cache_wlock_invalidate'}]),
	( 'Optimizer', [
		{'caption': 'engine-condition-pushdown', 'versions': [((5, 0, 3),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (6, 0)), ((5, 6, 1),)], 'values': [{'default': 'off', 'on': 'on', 'inversion': (5, 0, 3), 'off': 'off', 'type': 'boolean'}, {'default': 'on', 'on': 'on', 'inversion': (5, 1, 0), 'off': 'off', 'type': 'boolean'}], 'description': 'Push supported query conditions to the storage engine', 'name': 'engine-condition-pushdown'},
		{'caption': 'optimizer_join_cache_level', 'versions': [((5, 6, 1), (6, 0, 14)), ((5, 6), (6, 0)), ((5, 6, 3),)], 'values': [{'default': '4', 'minimum': '0', 'type': 'numeric', 'maximum': '4'}, {'default': '1', 'inversion': (6, 0, 14), 'minimum': '0', 'type': 'numeric', 'maximum': '8'}], 'description': 'How join buffers are used', 'name': 'optimizer_join_cache_level'},
		{'caption': 'optimizer_prune_level', 'versions': [((5, 0, 1),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '1', 'on': '1', 'off': '0', 'type': 'boolean'}], 'description': 'Controls the heuristic(s) applied during query optimization to prune less-promising partial plans from the optimizer search space', 'name': 'optimizer_prune_level'},
		{'caption': 'optimizer_search_depth', 'versions': [((5, 0, 1),), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '62', 'type': 'numeric'}, {'default': '62', 'outversion': (5, 5, 99), 'minimum': '0', 'type': 'numeric', 'maximum': '63'}, {'default': '62', 'inversion': (5, 6), 'minimum': '0', 'type': 'numeric', 'maximum': '62'}, {'inversion': (6, 0, 0), 'default': '62', 'maximum': '63', 'outversion': (6, 0, 13), 'minimum': '0', 'type': 'numeric'}, {'default': '62', 'inversion': (6, 0, 14), 'minimum': '0', 'type': 'numeric', 'maximum': '62'}], 'description': 'Maximum depth of search performed by the query optimizer', 'name': 'optimizer_search_depth'},
		{'optype': {'inversion': '5.1.34'}, 'description': 'Enable control over which optimizations to use', 'versions': [((5, 1, 34), (5, 2, 4), (5, 4, 2)), ((5, 1), (5, 2), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'optimizer_switch', 'values': [{'outversion': (5, 2, 3), 'type': 'set', 'choice': ['index_merge={on|off}', 'index_merge_intersection={on|off}', 'index_merge_sort_union={on|off}', 'index_merge_union={on|off}']}, {'default': "''", 'inversion': (5, 2, 4), 'type': 'set', 'choice': ['no_semijoin', 'no_materialization']}, {'inversion': (5, 4, 2), 'type': 'set', 'outversion': (5, 5, 2), 'choice': ['index_merge={on|off}', 'index_merge_intersection={on|off}', 'index_merge_sort_union={on|off}', 'index_merge_union={on|off}']}, {'inversion': (5, 5, 3), 'type': 'set', 'choice': ['engine_condition_pushdown={on|off}', 'index_merge={on|off}', 'index_merge_intersection={on|off}', 'index_merge_sort_union={on|off}', 'index_merge_union={on|off}']}, {'inversion': (5, 6, 1), 'type': 'set', 'outversion': (5, 6, 2), 'choice': ['engine_condition_pushdown={on|off}', 'index_merge={on|off}', 'index_merge_intersection={on|off}', 'index_merge_sort_union={on|off}', 'index_merge_union={on|off}', 'engine_condition_pushdown={on|off}', 'index_condition_pushdown={on|off}', 'mrr={on|off}', 'mrr_cost_based={on|off}']}, {'inversion': (5, 6, 3), 'type': 'set', 'choice': ['engine_condition_pushdown={on|off}', 'index_merge={on|off}', 'index_merge_intersection={on|off}', 'index_merge_sort_union={on|off}', 'index_merge_union={on|off}', 'engine_condition_pushdown={on|off}', 'index_condition_pushdown={on|off}', 'mrr={on|off}', 'mrr_cost_based={on|off}', 'block_nested_loop={on|off}', 'batched_key_access={on|off}']}, {'default': "''", 'inversion': (6, 0, 0), 'type': 'set', 'outversion': (6, 0, 10), 'choice': ['no_firstmatch', 'no_loosescan', 'no_materialization', 'no_semijoin']}, {'inversion': (6, 0, 11), 'type': 'set', 'outversion': (6, 0, 13), 'choice': ['index_merge={on|off}', 'index_merge_intersection={on|off}', 'index_merge_sort_union={on|off}', 'index_merge_union={on|off}', 'semijoin={on|off}', 'firstmatch={on|off}', 'loosescan={on|off}', 'materialization={on|off}']}, {'inversion': (6, 0, 14), 'type': 'set', 'choice': ['index_merge={on|off}', 'index_merge_intersection={on|off}', 'index_merge_sort_union={on|off}', 'index_merge_union={on|off}', 'semijoin={on|off}', 'firstmatch={on|off}', 'loosescan={on|off}', 'materialization={on|off}', 'engine_condition_pushdown={on|off}', 'index_condition_pushdown={on|off}', 'mrr={on|off}', 'mrr_cost_based={on|off}']}], 'name': 'optimizer_switch'}]),
	( 'Performance Schema', [
		{'optype': {'format': 'performance_schema=#'}, 'description': 'Whether Performance Schema is enabled', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema', 'values': [{'default': 'off', 'on': 'on', 'outversion': (5, 6, 5), 'off': 'off', 'type': 'boolean'}, {'default': 'on', 'on': 'on', 'inversion': (5, 6, 6), 'off': 'off', 'type': 'boolean'}], 'name': 'performance_schema'},
		{'optype': {'format': 'performance_schema_consumer_xxx=#'}, 'description': 'Configure Performance Schema consumer', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_consumer_xxx', 'values': [{'default': 'on', 'on': 'on', 'off': 'off', 'type': 'boolean'}], 'name': 'performance_schema_consumer_xxx'},
		{'optype': {'format': 'performance_schema_digests_size=#'}, 'description': 'The number of rows in the statement digest summary table', 'versions': [((5, 6, 5),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_digests_size', 'values': [{'default': '200', 'outversion': (5, 6, 5), 'minimum': '0', 'type': 'numeric', 'maximum': '200'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'minimum': '-1', 'type': 'numeric', 'maximum': '200'}], 'name': 'performance_schema_digests_size'},
		{'optype': {'format': 'performance_schema_events_stages_history_long_size=#'}, 'description': 'The number of rows in events_stages_history_long', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_events_stages_history_long_size', 'values': [{'default': '10000', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_events_stages_history_long_size'},
		{'optype': {'format': 'performance_schema_events_stages_history_size=#'}, 'description': 'The number of rows in events_stages_history', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_events_stages_history_size', 'values': [{'default': '10', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_events_stages_history_size'},
		{'optype': {'format': 'performance_schema_events_statements_history_long_size=#'}, 'description': 'The number of rows in events_statements_history_long', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_events_statements_history_long_size', 'values': [{'default': '10000', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_events_statements_history_long_size'},
		{'optype': {'format': 'performance_schema_events_statements_history_size=#'}, 'description': 'The number of rows in events_statements_history', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_events_statements_history_size', 'values': [{'default': '10', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_events_statements_history_size'},
		{'optype': {'format': 'performance_schema_events_waits_history_long_size=#'}, 'description': 'The number of rows in events_waits_history_long', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_events_waits_history_long_size', 'values': [{'default': '10000', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_events_waits_history_long_size'},
		{'optype': {'format': 'performance_schema_events_waits_history_size=#'}, 'description': 'The number of rows in events_waits_history', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_events_waits_history_size', 'values': [{'default': '10', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_events_waits_history_size'},
		{'optype': {'format': 'performance_schema_hosts_size=#'}, 'description': 'The number of rows in hosts table', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_hosts_size', 'values': [{'default': '10', 'outversion': (5, 6, 5), 'minimum': '0', 'type': 'numeric', 'maximum': '1048576'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'minimum': '-1', 'type': 'numeric', 'maximum': '1048576'}], 'name': 'performance_schema_hosts_size'},
		{'optype': {'format': 'performance_schema_instrument=instrument=#'}, 'description': 'Configure Performance Schema instrument', 'versions': [((5, 6, 4),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_instrument', 'values': [{'type': 'string'}], 'name': 'performance_schema_instrument'},
		{'optype': {'format': 'performance_schema_max_cond_classes=#'}, 'description': 'The maximum number of condition instruments', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_max_cond_classes', 'values': [{'default': '80', 'type': 'numeric'}], 'name': 'performance_schema_max_cond_classes'},
		{'optype': {'format': 'performance_schema_max_cond_instances=#'}, 'description': 'The maximum number of instrumented condition objects', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_max_cond_instances', 'values': [{'default': '1000', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_max_cond_instances'},
		{'optype': {'format': 'performance_schema_max_file_classes=#'}, 'description': 'The maximum number of file instruments', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_max_file_classes', 'values': [{'default': '50', 'type': 'numeric'}], 'name': 'performance_schema_max_file_classes'},
		{'optype': {'format': 'performance_schema_max_file_handles=#'}, 'description': 'The maximum number of opened file objects', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_max_file_handles', 'values': [{'default': '32768', 'type': 'numeric'}], 'name': 'performance_schema_max_file_handles'},
		{'optype': {'format': 'performance_schema_max_file_instances=#'}, 'description': 'The maximum number of instrumented file objects', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_max_file_instances', 'values': [{'default': '10000', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_max_file_instances'},
		{'optype': {'format': 'performance_schema_max_mutex_classes=#'}, 'description': 'The maximum number of mutex instruments', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_max_mutex_classes', 'values': [{'default': '200', 'type': 'numeric'}], 'name': 'performance_schema_max_mutex_classes'},
		{'optype': {'format': 'performance_schema_max_mutex_instances=#'}, 'description': 'The maximum number of instrumented mutex objects', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_max_mutex_instances', 'values': [{'default': '1000', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_max_mutex_instances'},
		{'optype': {'format': 'performance_schema_max_rwlock_classes=#'}, 'description': 'The maximum number of rwlock instruments', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_max_rwlock_classes', 'values': [{'default': '20', 'type': 'numeric'}], 'name': 'performance_schema_max_rwlock_classes'},
		{'optype': {'format': 'performance_schema_max_rwlock_instances=#'}, 'description': 'The maximum number of instrumented rwlock objects', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_max_rwlock_instances', 'values': [{'default': '1000', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_max_rwlock_instances'},
		{'optype': {'format': 'performance_schema_max_stage_classes=#'}, 'description': 'The maximum number of stage instruments', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_max_stage_classes', 'values': [{'default': '100', 'type': 'numeric'}], 'name': 'performance_schema_max_stage_classes'},
		{'optype': {'format': 'performance_schema_max_socket_classes=#'}, 'description': 'The maximum number of socket instruments', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_max_socket_classes', 'values': [{'default': '10', 'type': 'numeric'}], 'name': 'performance_schema_max_socket_classes'},
		{'optype': {'format': 'performance_schema_max_socket_instances=#'}, 'description': 'The maximum number of instrumented socket objects', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_max_socket_instances', 'values': [{'default': '1000', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_max_socket_instances'},
		{'optype': {'format': 'performance_schema_max_statement_classes=#'}, 'description': 'The maximum number of statement instruments', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_max_statement_classes', 'values': [{'default': '100', 'type': 'numeric'}], 'name': 'performance_schema_max_statement_classes'},
		{'optype': {'format': 'performance_schema_max_table_handles=#'}, 'description': 'The maximum number of opened table objects', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_max_table_handles', 'values': [{'default': '100000', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_max_table_handles'},
		{'optype': {'format': 'performance_schema_max_table_instances=#'}, 'description': 'The maximum number of instrumented table objects', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_max_table_instances', 'values': [{'default': '50000', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_max_table_instances'},
		{'optype': {'format': 'performance_schema_max_thread_classes=#'}, 'description': 'The maximum number of thread instruments', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_max_thread_classes', 'values': [{'default': '50', 'type': 'numeric'}], 'name': 'performance_schema_max_thread_classes'},
		{'optype': {'format': 'performance_schema_max_thread_instances=#'}, 'description': 'The maximum number of instrumented thread objects', 'versions': [((5, 5, 3), (6, 0, 14)), ((5, 5), (5, 6), (5, 7), (6, 0)), ()], 'caption': 'performance_schema_max_thread_instances', 'values': [{'default': '1000', 'outversion': (5, 6, 5), 'type': 'numeric'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'type': 'numeric'}], 'name': 'performance_schema_max_thread_instances'},
		{'optype': {'format': 'performance_schema_setup_actors_size=#'}, 'description': 'The number of rows in setup_actors', 'versions': [((5, 6, 1),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_setup_actors_size', 'values': [{'default': '100', 'type': 'numeric'}], 'name': 'performance_schema_setup_actors_size'},
		{'optype': {'format': 'performance_schema_setup_objects_size=#'}, 'description': 'The number of rows in setup_objects', 'versions': [((5, 6, 1),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_setup_objects_size', 'values': [{'default': '100', 'type': 'numeric'}], 'name': 'performance_schema_setup_objects_size'},
		{'optype': {'format': 'performance_schema_users_size=#'}, 'description': 'The number of rows in users table', 'versions': [((5, 6, 3),), ((5, 6), (5, 7)), ()], 'caption': 'performance_schema_users_size', 'values': [{'default': '10', 'outversion': (5, 6, 5), 'minimum': '0', 'type': 'numeric', 'maximum': '1048576'}, {'default': '-1 (autosized)', 'inversion': (5, 6, 6), 'minimum': '-1', 'type': 'numeric', 'maximum': '1048576'}], 'name': 'performance_schema_users_size'}]),
	( 'General', [
		{'caption': 'delay-key-write', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'ON', 'type': 'enum', 'choice': ['ON', 'OFF', 'ALL']}], 'description': 'Type of DELAY_KEY_WRITE', 'name': 'delay-key-write'},
		{'caption': 'low-priority-updates', 'versions': [(), ((4, 1), (5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': 'false', 'on': 'true', 'off': 'false', 'type': 'boolean'}], 'description': 'INSERT/DELETE/UPDATE has lower priority than selects', 'name': 'low-priority-updates'},
		{'caption': 'profiling_history_size', 'versions': [((5, 0, 37), (5, 1, 24), (6, 0, 5)), ((5, 0), (5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '15', 'minimum': '0', 'type': 'numeric', 'maximum': '100'}], 'description': 'How many statements to maintain profiling information for', 'name': 'profiling_history_size'},
		{'caption': 'table_definition_cache', 'versions': [((5, 1, 3),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '128', 'outversion': (5, 1, 24), 'minimum': '1', 'type': 'numeric', 'maximum': '524288'}, {'default': '256', 'inversion': (5, 1, 25), 'minimum': '256', 'type': 'numeric', 'maximum': '524288'}, {'default': '400', 'inversion': (5, 4, 0), 'minimum': '400', 'type': 'numeric', 'maximum': '524288'}, {'inversion': (6, 0, 0), 'default': '128', 'maximum': '524288', 'outversion': (6, 0, 5), 'minimum': '1', 'type': 'numeric'}, {'default': '256', 'inversion': (6, 0, 6), 'minimum': '256', 'type': 'numeric', 'maximum': '524288'}], 'description': 'The number of table definitions that can be stored in the definition cache.', 'name': 'table_definition_cache'},
		{'caption': 'table_open_cache', 'versions': [((5, 1, 3),), ((5, 1), (5, 4), (5, 5), (5, 6), (5, 7), (6, 0)), ()], 'values': [{'default': '64', 'minimum': '64', 'type': 'numeric', 'maximum': '524288'}, {'inversion': (5, 4, 0), 'default': '400', 'maximum': '524288', 'outversion': (5, 4, 1), 'minimum': '64', 'type': 'numeric'}, {'default': '400', 'inversion': (5, 4, 2), 'minimum': '400', 'type': 'numeric', 'maximum': '524288'}, {'default': '64', 'inversion': (6, 0, 0), 'minimum': '64', 'type': 'numeric', 'maximum': '524288'}], 'description': 'The number of open tables for all threads', 'name': 'table_open_cache'},
		{'optype': {'format': 'table_open_cache'}, 'description': 'The number of open tables cache instances', 'versions': [((5, 6, 6),), ((5, 6), (5, 7)), ()], 'caption': 'table_open_cache_instances', 'values': [{'default': '1', 'type': 'numeric'}], 'name': 'table_open_cache_instances'}])]),
]
