/* 
 * Copyright (c) 2008, 2010, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#ifndef __GRT_VALUE_TREE_H__
#define __GRT_VALUE_TREE_H__

#if ValueTreeBE_VERSION > 4
# error ValueTreeBE Wrapper outdated.
#endif

namespace MySQL {
  namespace Grt {

    public ref class GrtValueTree : public TreeModel
    {
    public:
      enum class Columns
      {
        Name = ::bec::ValueTreeBE::Name,
        Type = ::bec::ValueTreeBE::Type
      };

      inline ::bec::ValueTreeBE *get_unmanaged_object()
      { return static_cast<::bec::ValueTreeBE *>(inner); }


      GrtValueTree(GRT^ grt)
        : TreeModel(new ::bec::ValueTreeBE(grt->get_unmanaged_object()))
      {}

      GrtValueTree(::bec::ValueTreeBE *inn)
        : TreeModel(inn)
      {}

      /*void set_displayed_global_value(String^ path)
      { get_unmanaged_object()->set_displayed_global_value(NativeToCppString(path)); }*/

      void show_captions(bool flag)
      { get_unmanaged_object()->show_captions(flag); }

      //virtual int count_children(const NodeId &node);
      //virtual NodeId get_child(const NodeId &parent, int index);

      bool get_row(NodeId^ node, [Out] String^ %name, [Out] String^ %type)
      {
        std::string s1, s2;
        bool retval= get_unmanaged_object()->get_row(*node->get_unmanaged_object(), s1, s2); 
        name= CppStringToNative(s1);
        type= CppStringToNative(s2);
        return retval;      
      }

      GrtValue^ get_node_value(NodeId^ node)
      {
        return gcnew GrtValue(get_unmanaged_object()->get_node_value(*node->get_unmanaged_object()));
      }

      //virtual bool expand_node(const NodeId &node);
      //virtual void collapse_node(const NodeId &node);

      //virtual void refresh();

      String^ get_path_for_node(NodeId^ node_id, bool full)
      { return CppStringToNative(get_unmanaged_object()->get_path_for_node(*node_id->get_unmanaged_object(), full)); }
    };

  } // namespace Grt
} // namespace MySQL

#endif // __GRT_VALUE_TREE_H__