/* 
 * Copyright (c) 2008, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */

#pragma once

using namespace System;
using namespace Drawing;
using namespace Windows::Forms;
using namespace Layout;

namespace MySQL {
  namespace Forms {

    private ref class FormFillLayout : public LayoutEngine
    {
    public:
      virtual bool Layout(Object^ container, LayoutEventArgs^ arguments) override;
      System::Drawing::Size GetPreferredSize(Control^ container, System::Drawing::Size proposedSize);
    };

    /**
     * A form with a fill layout.
     */
    public ref class FillForm : public Form
    {
    private:
      FormFillLayout^ layoutEngine;

    public:
      delegate Windows::Forms::DialogResult ShowModalDelegate(IWin32Window^ parent);

      FillForm();

      System::Drawing::Size ComputeLayout(System::Drawing::Size proposedSize, bool resizeChildren);
      virtual System::Drawing::Size GetPreferredSize(System::Drawing::Size proposedSize) override;

      virtual property Windows::Forms::Layout::LayoutEngine^ LayoutEngine
      {
        Windows::Forms::Layout::LayoutEngine^ get() override
        {
          if (layoutEngine == nullptr)
            layoutEngine = gcnew FormFillLayout();

          return layoutEngine;
        }
      }
    };

    public ref class FormImpl : public ViewImpl
    {
    private:
      bool _hide_on_close;
      Form^ _owner;
    protected:
      static bool create(mforms::Form *self, mforms::Form *owner, mforms::FormFlag flag);
      static void set_title(mforms::Form *self, const std::string &title);
      static void show_modal(mforms::Form *self, mforms::Button *accept, mforms::Button *cancel);
      static bool run_modal(mforms::Form *self, mforms::Button *accept,mforms::Button *cancel);
      static void close(mforms::Form *self);
      static void set_content(mforms::Form *self, mforms::View *view);
      static void center(mforms::Form *self);
      static void flush_events(mforms::Form *self);
      static void end_modal(mforms::Form *self, bool result);

      // Events from .NET.
      static void disposed(System::Object ^sender, System::EventArgs ^e);
      static void closing(System::Object ^sender, FormClosingEventArgs  ^e);
    public:
      FormImpl(mforms::Form *form, mforms::Form *owner, mforms::FormFlag flag);

      void center();
      void flush_events();
      bool hide_on_close();

      property Form^ Owner
      {
        Form^ get() { return _owner; }
      }

      static void init(Manager ^mgr)
      {
        mforms::ControlFactory *f= mforms::ControlFactory::get_instance();

        DEF_CALLBACK3(bool, mforms::Form*, mforms::Form*, mforms::FormFlag, mgr, f->_form_impl, FormImpl, create);
        DEF_CALLBACK1(void, mforms::Form*, mgr, f->_form_impl, FormImpl, close);
        DEF_CALLBACK2(void, mforms::Form*, mforms::View*, mgr, f->_form_impl, FormImpl, set_content);
        DEF_CALLBACK2(void, mforms::Form*, const std::string&, mgr, f->_form_impl, FormImpl, set_title);
        DEF_CALLBACK3(bool, mforms::Form*, mforms::Button*, mforms::Button*, mgr, f->_form_impl, FormImpl, run_modal);
        DEF_CALLBACK3(void, mforms::Form*, mforms::Button*, mforms::Button*, mgr, f->_form_impl, FormImpl, show_modal);
        DEF_CALLBACK2(void, mforms::Form*, bool, mgr, f->_form_impl, FormImpl, end_modal);
        DEF_CALLBACK1(void, mforms::Form*, mgr, f->_form_impl, FormImpl, center);
        DEF_CALLBACK1(void, mforms::Form*, mgr, f->_form_impl, FormImpl, flush_events);
      }
    };

  };
};
