/* 
 * Copyright (c) 2009, 2013, Oracle and/or its affiliates. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301  USA
 */


#ifndef _WF_DRAWBOX_H_
#define _WF_DRAWBOX_H_

using namespace System;
using namespace Windows::Forms;
using namespace System::Windows::Forms::Layout;

namespace MySQL {
  namespace Forms {

    public ref class DrawBoxLayout : public LayoutEngine
    {
    public:
      virtual bool Layout(Object^ container, LayoutEventArgs^ arguments) override;
    };

    // A helper class to set a few things which are only accessible from a descendant.
    private ref class CanvasControl : Windows::Forms::Control
    {
    private:
      mforms::DrawBox* backend;

      DrawBoxLayout^ layoutEngine;
      Dictionary<Control^, int> alignments;
    public:
      CanvasControl();

      virtual System::Drawing::Size GetPreferredSize(System::Drawing::Size proposedSize) override;
      void Add(Control ^control, mforms::Alignment alignment);
      void Remove(Control ^control);
      void Move(Control ^control, int x, int y);
      mforms::Alignment GetAlignment(Control ^control);

      virtual property Windows::Forms::Layout::LayoutEngine^ LayoutEngine
      {
        Windows::Forms::Layout::LayoutEngine^ get() override
        {
          if (layoutEngine == nullptr)
            layoutEngine = gcnew DrawBoxLayout();
          return layoutEngine;
        }
      }

      void set_backend(mforms::DrawBox* backend);
      void DoRepaint();
    };

    public ref class DrawBoxImpl : public ViewImpl
    {
    protected:
      DrawBoxImpl(mforms::DrawBox *self);
      ~DrawBoxImpl();

      static bool create(mforms::DrawBox *self);
      static void set_needs_repaint(mforms::DrawBox *self);
      static void add(mforms::DrawBox *self, mforms::View *view, mforms::Alignment alignment);
      static void remove(mforms::DrawBox *self, mforms::View *view);
      static void move(mforms::DrawBox *self, mforms::View *view, int x, int y);

      void drawbox_mouse_move(System::Object ^sender, MouseEventArgs ^e);
      void drawbox_mouse_down(System::Object ^sender, MouseEventArgs ^e);
      void drawbox_mouse_up(System::Object ^sender, MouseEventArgs ^e);
      void drawbox_mouse_click(System::Object ^sender, MouseEventArgs ^e);
      void drawbox_mouse_double_click(System::Object ^sender, MouseEventArgs ^e);
      void drawbox_mouse_enter(System::Object ^sender, EventArgs ^e);
      void drawbox_mouse_leave(System::Object ^sender, EventArgs ^e);
      void drawbox_repaint(System::Object ^sender, PaintEventArgs ^e);
      void drawbox_key_down(System::Object ^sender, KeyEventArgs ^e);

    public:
      static void init(Manager ^mgr)
      {
        mforms::ControlFactory *f= mforms::ControlFactory::get_instance();

        DEF_CALLBACK1(bool, mforms::DrawBox*, mgr, f->_drawbox_impl, DrawBoxImpl, create);
        DEF_CALLBACK1(void, mforms::DrawBox*, mgr, f->_drawbox_impl, DrawBoxImpl, set_needs_repaint);
        DEF_CALLBACK3(void, mforms::DrawBox*, mforms::View*, mforms::Alignment, mgr, f->_drawbox_impl, DrawBoxImpl, add);
        DEF_CALLBACK2(void, mforms::DrawBox*, mforms::View*, mgr, f->_drawbox_impl, DrawBoxImpl, remove);
        DEF_CALLBACK4(void, mforms::DrawBox*, mforms::View*, int, int, mgr, f->_drawbox_impl, DrawBoxImpl, move);
      }
    };

  };
};


#endif
