/*
 * Decompiled with CFR 0.152.
 */
package testsuite.clusterj;

import com.mysql.clusterj.ClusterJUserException;
import java.util.Arrays;
import java.util.HashSet;
import testsuite.clusterj.AbstractQueryTest;
import testsuite.clusterj.model.AllPrimitives;

public class QueryInTest
extends AbstractQueryTest {
    @Override
    public Class<?> getInstanceType() {
        return AllPrimitives.class;
    }

    @Override
    void createInstances(int n) {
        this.createAllPrimitivesInstances(10);
    }

    public void testBtreeEqualOrIn() {
        this.equalOrInQuery("int_not_null_btree", 4, "int_null_none", new Object[0], "none", 4);
        this.equalOrInQuery("int_not_null_btree", 4, "int_null_none", new Object[]{6, 9}, "none", 4, 6, 9);
        this.equalOrInQuery("int_null_btree", 4, "int_null_none", new Object[]{4, 6, 9}, "none", 4, 6, 9);
        this.equalOrInQuery("int_null_btree", 4, "int_null_none", new Object[]{6, 6, 6, 9}, "none", 4, 6, 9);
        this.equalOrInQuery("int_not_null_btree", 4, "int_null_none", Arrays.asList(new Object[0]), "none", 4);
        this.equalOrInQuery("int_not_null_btree", 4, "int_null_none", Arrays.asList(6, 9), "none", 4, 6, 9);
        this.equalOrInQuery("int_null_btree", 4, "int_null_none", new HashSet<Integer>(Arrays.asList(4, 6, 9)), "none", 4, 6, 9);
        this.equalOrInQuery("int_null_btree", 4, "int_null_none", new HashSet<Integer>(Arrays.asList(6, 6, 6, 9)), "none", 4, 6, 9);
        this.failOnError();
    }

    public void testIn() {
        this.inQuery("int_not_null_none", new Object[]{4, 6, 9}, "none", 4, 6, 9);
        this.inQuery("int_not_null_hash", Arrays.asList(4, 6, 9), "none", 4, 6, 9);
        this.inQuery("int_not_null_both", new Object[]{4, 6, 9}, "idx_int_not_null_both", 4, 6, 9);
        this.inQuery("int_not_null_btree", new Object[]{4, 6, 9}, "idx_int_not_null_btree", 4, 6, 9);
        this.failOnError();
    }

    public void testInAndIn() {
        this.inAndInQuery("int_not_null_none", new Object[]{4, 6, 9}, "id", new Object[]{4, 9}, "PRIMARY", 4, 9);
        this.inAndInQuery("int_not_null_hash", new Object[]{4, 9}, "int_not_null_both", new Object[]{6, 9}, "idx_int_not_null_both", 9);
        this.inAndInQuery("int_not_null_hash", new Object[]{4, 9}, "int_not_null_btree", new Object[]{6, 9}, "idx_int_not_null_btree", 9);
        this.inAndInQuery("int_not_null_both", new Object[]{4, 9}, "int_not_null_hash", new Object[]{6, 9}, "idx_int_not_null_both", 9);
        this.inAndInQuery("int_not_null_btree", new Object[]{4, 9}, "int_not_null_hash", new Object[]{6, 9}, "idx_int_not_null_btree", 9);
        this.failOnError();
    }

    public void testHashEqualOrIn() {
        this.equalOrInQuery("int_not_null_hash", 4, "int_null_both", new Object[]{6, 9}, "none", 4, 6, 9);
        this.equalOrInQuery("int_null_hash", 4, "int_null_both", new Object[]{6, 9}, "none", 4, 6, 9);
        this.failOnError();
    }

    public void testBothEqualOrIn() {
        this.equalOrInQuery("int_not_null_both", 4, "int_null_hash", new Object[]{6, 9}, "none", 4, 6, 9);
        this.equalOrInQuery("int_null_both", 4, "int_null_hash", new Object[]{6, 9}, "none", 4, 6, 9);
        this.failOnError();
    }

    public void testNoneEqualOrIn() {
        this.equalOrInQuery("int_not_null_none", 4, "int_null_btree", new Object[]{6, 9}, "none", 4, 6, 9);
        this.equalOrInQuery("int_null_none", 4, "int_null_btree", new Object[]{6, 9}, "none", 4, 6, 9);
        this.failOnError();
    }

    public void testNullParameterForIn() {
        try {
            this.equalOrInQuery("int_not_null_btree", 4, "int_null_none", null, "none", 4);
            QueryInTest.fail((String)"testNullParameterForIn should throw ClusterJUserException.");
        }
        catch (ClusterJUserException clusterJUserException) {
            // empty catch block
        }
    }
}

